/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RotationShardShuffler;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.RoutingValidationException;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardShuffler;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class IndexRoutingTable
extends AbstractDiffable<IndexRoutingTable>
implements Iterable<IndexShardRoutingTable> {
    public static final IndexRoutingTable PROTO = IndexRoutingTable.builder("").build();
    private final String index;
    private final ShardShuffler shuffler;
    private final ImmutableOpenIntMap<IndexShardRoutingTable> shards;
    private final List<ShardRouting> allActiveShards;

    IndexRoutingTable(String index, ImmutableOpenIntMap<IndexShardRoutingTable> shards) {
        this.index = index;
        this.shuffler = new RotationShardShuffler(ThreadLocalRandom.current().nextInt());
        this.shards = shards;
        ArrayList<ShardRouting> allActiveShards = new ArrayList<ShardRouting>();
        for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : shards) {
            for (ShardRouting shardRouting : (IndexShardRoutingTable)intObjectCursor.value) {
                shardRouting.freeze();
                if (!shardRouting.active()) continue;
                allActiveShards.add(shardRouting);
            }
        }
        this.allActiveShards = Collections.unmodifiableList(allActiveShards);
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public IndexRoutingTable normalizeVersions() {
        Builder builder = new Builder(this.index);
        for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : this.shards) {
            builder.addIndexShard(((IndexShardRoutingTable)intObjectCursor.value).normalizeVersions());
        }
        return builder.build();
    }

    public void validate(RoutingTableValidation validation, MetaData metaData) {
        if (!metaData.hasIndex(this.index())) {
            validation.addIndexFailure(this.index(), "Exists in routing does not exists in metadata");
            return;
        }
        IndexMetaData indexMetaData = metaData.index(this.index());
        for (String failure : this.validate(indexMetaData)) {
            validation.addIndexFailure(this.index, failure);
        }
    }

    public List<String> validate(IndexMetaData indexMetaData) {
        ArrayList<String> failures = new ArrayList<String>();
        if (indexMetaData.getNumberOfShards() != this.shards().size()) {
            HashSet<Integer> expected = Sets.newHashSet();
            for (int i = 0; i < indexMetaData.getNumberOfShards(); ++i) {
                expected.add(i);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : this) {
                expected.remove(indexShardRoutingTable.shardId().id());
            }
            failures.add("Wrong number of shards in routing table, missing: " + expected);
        }
        for (IndexShardRoutingTable indexShardRoutingTable : this) {
            int routingNumberOfReplicas = indexShardRoutingTable.size() - 1;
            if (routingNumberOfReplicas != indexMetaData.getNumberOfReplicas()) {
                failures.add("Shard [" + indexShardRoutingTable.shardId().id() + "] routing table has wrong number of replicas, expected [" + indexMetaData.getNumberOfReplicas() + "], got [" + routingNumberOfReplicas + "]");
            }
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                if (shardRouting.index().equals(this.index())) continue;
                failures.add("shard routing has an index [" + shardRouting.index() + "] that is different than the routing table");
            }
        }
        return failures;
    }

    @Override
    public UnmodifiableIterator<IndexShardRoutingTable> iterator() {
        return this.shards.valuesIt();
    }

    public int numberOfNodesShardsAreAllocatedOn(String ... excludedNodes) {
        HashSet<String> nodes = Sets.newHashSet();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            for (ShardRouting shardRouting : shardRoutingTable) {
                if (!shardRouting.assignedToNode()) continue;
                String currentNodeId = shardRouting.currentNodeId();
                boolean excluded = false;
                if (excludedNodes != null) {
                    for (String excludedNode : excludedNodes) {
                        if (!currentNodeId.equals(excludedNode)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                nodes.add(currentNodeId);
            }
        }
        return nodes.size();
    }

    public ImmutableOpenIntMap<IndexShardRoutingTable> shards() {
        return this.shards;
    }

    public ImmutableOpenIntMap<IndexShardRoutingTable> getShards() {
        return this.shards();
    }

    public IndexShardRoutingTable shard(int shardId) {
        return this.shards.get(shardId);
    }

    public boolean allPrimaryShardsActive() {
        return this.primaryShardsActive() == this.shards().size();
    }

    public int primaryShardsActive() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().active()) continue;
            ++counter;
        }
        return counter;
    }

    public boolean allPrimaryShardsUnassigned() {
        return this.primaryShardsUnassigned() == this.shards.size();
    }

    public int primaryShardsUnassigned() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().unassigned()) continue;
            ++counter;
        }
        return counter;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            shards.addAll(shardRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public ShardsIterator randomAllActiveShardsIt() {
        return new PlainShardsIterator(this.shuffler.shuffle(this.allActiveShards));
    }

    public GroupShardsIterator groupByShardsIt() {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>(this.shards.size());
        for (IndexShardRoutingTable indexShard : this) {
            set.add(indexShard.shardsIt());
        }
        return new GroupShardsIterator(set);
    }

    public GroupShardsIterator groupByAllIt() {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (IndexShardRoutingTable indexShard : this) {
            for (ShardRouting shardRouting : indexShard) {
                set.add(shardRouting.shardsIt());
            }
        }
        return new GroupShardsIterator(set);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRoutingTable that = (IndexRoutingTable)o;
        if (!this.index.equals(that.index)) {
            return false;
        }
        return this.shards.equals(that.shards);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public void validate() throws RoutingValidationException {
    }

    @Override
    public IndexRoutingTable readFrom(StreamInput in) throws IOException {
        String index = in.readString();
        Builder builder = new Builder(index);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            builder.addIndexShard(IndexShardRoutingTable.Builder.readFromThin(in, index));
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shards.size());
        for (IndexShardRoutingTable indexShard : this) {
            IndexShardRoutingTable.Builder.writeToThin(indexShard, out);
        }
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("-- index [" + this.index + "]\n");
        ArrayList<IndexShardRoutingTable> ordered = new ArrayList<IndexShardRoutingTable>();
        for (IndexShardRoutingTable indexShard : this) {
            ordered.add(indexShard);
        }
        CollectionUtil.timSort(ordered, new Comparator<IndexShardRoutingTable>(){

            @Override
            public int compare(IndexShardRoutingTable o1, IndexShardRoutingTable o2) {
                int v = o1.shardId().index().name().compareTo(o2.shardId().index().name());
                if (v == 0) {
                    v = Integer.compare(o1.shardId().id(), o2.shardId().id());
                }
                return v;
            }
        });
        for (IndexShardRoutingTable indexShard : ordered) {
            sb.append("----shard_id [").append(indexShard.shardId().index().name()).append("][").append(indexShard.shardId().id()).append("]\n");
            for (ShardRouting shard : indexShard) {
                sb.append("--------").append(shard.shortSummary()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Builder {
        private final String index;
        private final ImmutableOpenIntMap.Builder<IndexShardRoutingTable> shards = ImmutableOpenIntMap.builder();

        public Builder(String index) {
            this.index = index;
        }

        public static IndexRoutingTable readFrom(StreamInput in) throws IOException {
            return PROTO.readFrom(in);
        }

        public Builder initializeAsNew(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null));
        }

        public Builder initializeAsRecovery(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.CLUSTER_RECOVERED, null));
        }

        public Builder initializeAsFromDangling(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.DANGLING_INDEX_IMPORTED, null));
        }

        public Builder initializeAsFromCloseToOpen(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.INDEX_REOPENED, null));
        }

        public Builder initializeAsNewRestore(IndexMetaData indexMetaData, RestoreSource restoreSource, IntSet ignoreShards) {
            return this.initializeAsRestore(indexMetaData, restoreSource, ignoreShards, true, new UnassignedInfo(UnassignedInfo.Reason.NEW_INDEX_RESTORED, "restore_source[" + restoreSource.snapshotId().getRepository() + "/" + restoreSource.snapshotId().getSnapshot() + "]"));
        }

        public Builder initializeAsRestore(IndexMetaData indexMetaData, RestoreSource restoreSource) {
            return this.initializeAsRestore(indexMetaData, restoreSource, null, false, new UnassignedInfo(UnassignedInfo.Reason.EXISTING_INDEX_RESTORED, "restore_source[" + restoreSource.snapshotId().getRepository() + "/" + restoreSource.snapshotId().getSnapshot() + "]"));
        }

        private Builder initializeAsRestore(IndexMetaData indexMetaData, RestoreSource restoreSource, IntSet ignoreShards, boolean asNew, UnassignedInfo unassignedInfo) {
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardId = 0; shardId < indexMetaData.getNumberOfShards(); ++shardId) {
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(new ShardId(indexMetaData.getIndex(), shardId));
                for (int i = 0; i <= indexMetaData.getNumberOfReplicas(); ++i) {
                    if (asNew && ignoreShards.contains(shardId)) {
                        indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(this.index, shardId, null, i == 0, unassignedInfo));
                        continue;
                    }
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(this.index, shardId, i == 0 ? restoreSource : null, i == 0, unassignedInfo));
                }
                this.shards.put(shardId, indexShardRoutingBuilder.build());
            }
            return this;
        }

        private Builder initializeEmpty(IndexMetaData indexMetaData, UnassignedInfo unassignedInfo) {
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardId = 0; shardId < indexMetaData.getNumberOfShards(); ++shardId) {
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(new ShardId(indexMetaData.getIndex(), shardId));
                for (int i = 0; i <= indexMetaData.getNumberOfReplicas(); ++i) {
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(this.index, shardId, null, i == 0, unassignedInfo));
                }
                this.shards.put(shardId, indexShardRoutingBuilder.build());
            }
            return this;
        }

        public Builder addReplica() {
            for (IntCursor cursor : this.shards.keys()) {
                int shardId = cursor.value;
                ShardRouting shard = ShardRouting.newUnassigned(this.index, shardId, null, false, new UnassignedInfo(UnassignedInfo.Reason.REPLICA_ADDED, null));
                this.shards.put(shardId, new IndexShardRoutingTable.Builder(this.shards.get(shard.id())).addShard(shard).build());
            }
            return this;
        }

        public Builder removeReplica() {
            for (IntCursor cursor : this.shards.keys()) {
                int shardId = cursor.value;
                IndexShardRoutingTable indexShard = this.shards.get(shardId);
                if (indexShard.replicaShards().isEmpty()) {
                    return this;
                }
                IndexShardRoutingTable.Builder builder = new IndexShardRoutingTable.Builder(indexShard.shardId());
                for (ShardRouting shardRouting : indexShard) {
                    builder.addShard(new ShardRouting(shardRouting));
                }
                boolean removed = false;
                for (ShardRouting shardRouting : indexShard) {
                    if (shardRouting.primary() || shardRouting.assignedToNode()) continue;
                    builder.removeShard(shardRouting);
                    removed = true;
                    break;
                }
                if (!removed) {
                    for (ShardRouting shardRouting : indexShard) {
                        if (shardRouting.primary()) continue;
                        builder.removeShard(shardRouting);
                        break;
                    }
                }
                this.shards.put(shardId, builder.build());
            }
            return this;
        }

        public Builder addIndexShard(IndexShardRoutingTable indexShard) {
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public Builder addShard(IndexShardRoutingTable refData, ShardRouting shard) {
            IndexShardRoutingTable indexShard = this.shards.get(shard.id());
            indexShard = indexShard == null ? new IndexShardRoutingTable.Builder(refData.shardId()).addShard(new ShardRouting(shard)).build() : new IndexShardRoutingTable.Builder(indexShard).addShard(new ShardRouting(shard)).build();
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public IndexRoutingTable build() throws RoutingValidationException {
            IndexRoutingTable indexRoutingTable = new IndexRoutingTable(this.index, this.shards.build());
            indexRoutingTable.validate();
            return indexRoutingTable;
        }
    }
}

