/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.Streams;

public class FsBlobContainer
extends AbstractBlobContainer {
    protected final FsBlobStore blobStore;
    protected final Path path;

    public FsBlobContainer(FsBlobStore blobStore, BlobPath blobPath, Path path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        MapBuilder<String, PlainBlobMetaData> builder = MapBuilder.newMapBuilder();
        blobNamePrefix = blobNamePrefix == null ? "" : blobNamePrefix;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path, blobNamePrefix + "*");){
            for (Path file : stream) {
                BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                if (!attrs.isRegularFile()) continue;
                builder.put(file.getFileName().toString(), new PlainBlobMetaData(file.getFileName().toString(), attrs.size()));
            }
        }
        return builder.immutableMap();
    }

    @Override
    public void deleteBlob(String blobName) throws IOException {
        Path blobPath = this.path.resolve(blobName);
        Files.deleteIfExists(blobPath);
    }

    @Override
    public boolean blobExists(String blobName) {
        return Files.exists(this.path.resolve(blobName), new LinkOption[0]);
    }

    @Override
    public InputStream readBlob(String name) throws IOException {
        return new BufferedInputStream(Files.newInputStream(this.path.resolve(name), new OpenOption[0]), this.blobStore.bufferSizeInBytes());
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize) throws IOException {
        Path file = this.path.resolve(blobName);
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            Streams.copy(inputStream, outputStream, new byte[this.blobStore.bufferSizeInBytes()]);
        }
        IOUtils.fsync(file, false);
        IOUtils.fsync(this.path, true);
    }

    @Override
    public void writeBlob(String blobName, BytesReference data) throws IOException {
        Path file = this.path.resolve(blobName);
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            data.writeTo(outputStream);
        }
        IOUtils.fsync(file, false);
        IOUtils.fsync(this.path, true);
    }

    @Override
    public void move(String source, String target) throws IOException {
        Path sourcePath = this.path.resolve(source);
        Path targetPath = this.path.resolve(target);
        assert (!Files.exists(targetPath, new LinkOption[0]));
        Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync(this.path, true);
    }
}

