/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;

public final class ShardCoreKeyMap {
    private final Map<Object, ShardId> coreKeyToShard = new IdentityHashMap<Object, ShardId>();
    private final Multimap<String, Object> indexToCoreKey = HashMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LeafReader reader) {
        ShardId shardId = ShardUtils.extractShardId(reader);
        if (shardId == null) {
            throw new IllegalArgumentException("Could not extract shard id from " + reader);
        }
        final Object coreKey = reader.getCoreCacheKey();
        final String index = shardId.getIndex();
        ShardCoreKeyMap shardCoreKeyMap = this;
        synchronized (shardCoreKeyMap) {
            if (this.coreKeyToShard.put(coreKey, shardId) == null) {
                boolean added = this.indexToCoreKey.put(index, coreKey);
                assert (added);
                LeafReader.CoreClosedListener listener = new LeafReader.CoreClosedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onClose(Object ownerCoreCacheKey) throws IOException {
                        assert (coreKey == ownerCoreCacheKey);
                        ShardCoreKeyMap shardCoreKeyMap = ShardCoreKeyMap.this;
                        synchronized (shardCoreKeyMap) {
                            ShardCoreKeyMap.this.coreKeyToShard.remove(ownerCoreCacheKey);
                            ShardCoreKeyMap.this.indexToCoreKey.remove(index, coreKey);
                        }
                    }
                };
                boolean addedListener = false;
                try {
                    reader.addCoreClosedListener(listener);
                    addedListener = true;
                }
                finally {
                    if (!addedListener) {
                        try {
                            listener.onClose(coreKey);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Blow up trying to recover from failure to add listener", e);
                        }
                    }
                }
            }
        }
    }

    public synchronized ShardId getShardId(Object coreKey) {
        return this.coreKeyToShard.get(coreKey);
    }

    public synchronized Set<Object> getCoreKeysForIndex(String index) {
        return ImmutableSet.copyOf(this.indexToCoreKey.get(index));
    }

    public synchronized int size() {
        assert (this.indexToCoreKey.size() == this.coreKeyToShard.size());
        return this.coreKeyToShard.size();
    }
}

