/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.fd;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.discovery.zen.fd.FaultDetection;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class MasterFaultDetection
extends FaultDetection {
    public static final String MASTER_PING_ACTION_NAME = "internal:discovery/zen/fd/master_ping";
    private final ClusterService clusterService;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private volatile MasterPinger masterPinger;
    private final Object masterNodeMutex = new Object();
    private volatile DiscoveryNode masterNode;
    private volatile int retryCount;
    private final AtomicBoolean notifiedMasterFailure = new AtomicBoolean();

    public MasterFaultDetection(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, ClusterService clusterService) {
        super(settings, threadPool, transportService, clusterName);
        this.clusterService = clusterService;
        this.logger.debug("[master] uses ping_interval [{}], ping_timeout [{}], ping_retries [{}]", this.pingInterval, this.pingRetryTimeout, this.pingRetryCount);
        transportService.registerRequestHandler(MASTER_PING_ACTION_NAME, MasterPingRequest.class, "same", false, false, new MasterPingRequestHandler());
    }

    public DiscoveryNode masterNode() {
        return this.masterNode;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(DiscoveryNode masterNode, String reason) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[master] restarting fault detection against master [{}], reason [{}]", masterNode, reason);
            }
            this.innerStop();
            this.innerStart(masterNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DiscoveryNode masterNode, String reason) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[master] starting fault detection against master [{}], reason [{}]", masterNode, reason);
            }
            this.innerStart(masterNode);
        }
    }

    private void innerStart(DiscoveryNode masterNode) {
        this.masterNode = masterNode;
        this.retryCount = 0;
        this.notifiedMasterFailure.set(false);
        try {
            this.transportService.connectToNode(masterNode);
        }
        catch (Exception e) {
            this.notifyMasterFailure(masterNode, "failed to perform initial connect [" + e.getMessage() + "]");
            return;
        }
        if (this.masterPinger != null) {
            this.masterPinger.stop();
        }
        this.masterPinger = new MasterPinger();
        this.threadPool.schedule(this.pingInterval, "same", this.masterPinger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String reason) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (this.masterNode != null && this.logger.isDebugEnabled()) {
                this.logger.debug("[master] stopping fault detection against master [{}], reason [{}]", this.masterNode, reason);
            }
            this.innerStop();
        }
    }

    private void innerStop() {
        this.retryCount = 0;
        if (this.masterPinger != null) {
            this.masterPinger.stop();
            this.masterPinger = null;
        }
        this.masterNode = null;
    }

    @Override
    public void close() {
        super.close();
        this.stop("closing");
        this.listeners.clear();
        this.transportService.removeHandler(MASTER_PING_ACTION_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTransportDisconnect(DiscoveryNode node) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (!node.equals(this.masterNode)) {
                return;
            }
            if (this.connectOnNetworkDisconnect) {
                try {
                    this.transportService.connectToNode(node);
                    if (this.masterPinger != null) {
                        this.masterPinger.stop();
                    }
                    this.masterPinger = new MasterPinger();
                    this.threadPool.schedule(TimeValue.timeValueMillis(0L), "same", this.masterPinger);
                }
                catch (Exception e) {
                    this.logger.trace("[master] [{}] transport disconnected (with verified connect)", this.masterNode);
                    this.notifyMasterFailure(this.masterNode, "transport disconnected (with verified connect)");
                }
            } else {
                this.logger.trace("[master] [{}] transport disconnected", node);
                this.notifyMasterFailure(node, "transport disconnected");
            }
        }
    }

    private void notifyMasterFailure(final DiscoveryNode masterNode, final String reason) {
        if (this.notifiedMasterFailure.compareAndSet(false, true)) {
            try {
                this.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        for (Listener listener : MasterFaultDetection.this.listeners) {
                            listener.onMasterFailure(masterNode, reason);
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException e) {
                this.logger.error("master failure notification was rejected, it's highly likely the node is shutting down", e, new Object[0]);
            }
            this.stop("master failure, " + reason);
        }
    }

    private static class MasterPingResponseResponse
    extends TransportResponse {
        private MasterPingResponseResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    public static class MasterPingRequest
    extends TransportRequest {
        private String nodeId;
        private String masterNodeId;
        private ClusterName clusterName;

        public MasterPingRequest() {
        }

        private MasterPingRequest(String nodeId, String masterNodeId, ClusterName clusterName) {
            this.nodeId = nodeId;
            this.masterNodeId = masterNodeId;
            this.clusterName = clusterName;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodeId = in.readString();
            this.masterNodeId = in.readString();
            this.clusterName = ClusterName.readClusterName(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            out.writeString(this.masterNodeId);
            this.clusterName.writeTo(out);
        }
    }

    private class MasterPingRequestHandler
    extends TransportRequestHandler<MasterPingRequest> {
        private MasterPingRequestHandler() {
        }

        @Override
        public void messageReceived(final MasterPingRequest request, final TransportChannel channel) throws Exception {
            DiscoveryNodes nodes = MasterFaultDetection.this.clusterService.state().nodes();
            if (!request.masterNodeId.equals(nodes.localNodeId())) {
                throw new ThisIsNotTheMasterYouAreLookingForException();
            }
            if (request.clusterName != null && !request.clusterName.equals(MasterFaultDetection.this.clusterName)) {
                MasterFaultDetection.this.logger.trace("master fault detection ping request is targeted for a different [{}] cluster then us [{}]", request.clusterName, MasterFaultDetection.this.clusterName);
                throw new ThisIsNotTheMasterYouAreLookingForException("master fault detection ping request is targeted for a different [" + request.clusterName + "] cluster then us [" + MasterFaultDetection.this.clusterName + "]");
            }
            if (!nodes.localNodeMaster() || !nodes.nodeExists(request.nodeId)) {
                MasterFaultDetection.this.logger.trace("checking ping from [{}] under a cluster state thread", request.nodeId);
                MasterFaultDetection.this.clusterService.submitStateUpdateTask("master ping (from: [" + request.nodeId + "])", new ClusterStateUpdateTask(){

                    @Override
                    public boolean runOnlyOnMaster() {
                        return false;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) throws Exception {
                        DiscoveryNodes nodes = currentState.nodes();
                        if (!nodes.localNodeMaster()) {
                            throw new NotMasterException("local node is not master");
                        }
                        if (!nodes.nodeExists(request.nodeId)) {
                            throw new NodeDoesNotExistOnMasterException();
                        }
                        return currentState;
                    }

                    @Override
                    public void onFailure(String source, @Nullable Throwable t) {
                        if (t == null) {
                            t = new ElasticsearchException("unknown error while processing ping", new Object[0]);
                        }
                        try {
                            channel.sendResponse(t);
                        }
                        catch (IOException e) {
                            MasterFaultDetection.this.logger.warn("error while sending ping response", e, new Object[0]);
                        }
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        try {
                            channel.sendResponse(new MasterPingResponseResponse());
                        }
                        catch (IOException e) {
                            MasterFaultDetection.this.logger.warn("error while sending ping response", e, new Object[0]);
                        }
                    }
                });
            } else {
                channel.sendResponse(new MasterPingResponseResponse());
            }
        }
    }

    static class NodeDoesNotExistOnMasterException
    extends IllegalStateException {
        NodeDoesNotExistOnMasterException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    static class ThisIsNotTheMasterYouAreLookingForException
    extends IllegalStateException {
        ThisIsNotTheMasterYouAreLookingForException(String msg) {
            super(msg);
        }

        ThisIsNotTheMasterYouAreLookingForException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    private class MasterPinger
    implements Runnable {
        private volatile boolean running = true;

        private MasterPinger() {
        }

        public void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            if (!this.running) {
                return;
            }
            final DiscoveryNode masterToPing = MasterFaultDetection.this.masterNode;
            if (masterToPing == null) {
                MasterFaultDetection.this.threadPool.schedule(MasterFaultDetection.this.pingInterval, "same", this);
                return;
            }
            final MasterPingRequest request = new MasterPingRequest(MasterFaultDetection.this.clusterService.localNode().id(), masterToPing.id(), MasterFaultDetection.this.clusterName);
            final TransportRequestOptions options = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.PING).withTimeout(MasterFaultDetection.this.pingRetryTimeout).build();
            MasterFaultDetection.this.transportService.sendRequest(masterToPing, MasterFaultDetection.MASTER_PING_ACTION_NAME, request, options, new BaseTransportResponseHandler<MasterPingResponseResponse>(){

                @Override
                public MasterPingResponseResponse newInstance() {
                    return new MasterPingResponseResponse();
                }

                @Override
                public void handleResponse(MasterPingResponseResponse response) {
                    if (!MasterPinger.this.running) {
                        return;
                    }
                    MasterFaultDetection.this.retryCount = 0;
                    if (masterToPing.equals(MasterFaultDetection.this.masterNode())) {
                        MasterFaultDetection.this.threadPool.schedule(MasterFaultDetection.this.pingInterval, "same", MasterPinger.this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleException(TransportException exp) {
                    if (!MasterPinger.this.running) {
                        return;
                    }
                    Object object = MasterFaultDetection.this.masterNodeMutex;
                    synchronized (object) {
                        if (masterToPing.equals(MasterFaultDetection.this.masterNode())) {
                            if (exp instanceof ConnectTransportException || exp.getCause() instanceof ConnectTransportException) {
                                MasterFaultDetection.this.handleTransportDisconnect(masterToPing);
                                return;
                            }
                            if (exp.getCause() instanceof NotMasterException) {
                                MasterFaultDetection.this.logger.debug("[master] pinging a master {} that is no longer a master", MasterFaultDetection.this.masterNode);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, "no longer master");
                                return;
                            }
                            if (exp.getCause() instanceof ThisIsNotTheMasterYouAreLookingForException) {
                                MasterFaultDetection.this.logger.debug("[master] pinging a master {} that is not the master", MasterFaultDetection.this.masterNode);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, "not master");
                                return;
                            }
                            if (exp.getCause() instanceof NodeDoesNotExistOnMasterException) {
                                MasterFaultDetection.this.logger.debug("[master] pinging a master {} but we do not exists on it, act as if its master failure", MasterFaultDetection.this.masterNode);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, "do not exists on master, act as master failure");
                                return;
                            }
                            int retryCount = ++MasterFaultDetection.this.retryCount;
                            MasterFaultDetection.this.logger.trace("[master] failed to ping [{}], retry [{}] out of [{}]", exp, MasterFaultDetection.this.masterNode, retryCount, MasterFaultDetection.this.pingRetryCount);
                            if (retryCount >= MasterFaultDetection.this.pingRetryCount) {
                                MasterFaultDetection.this.logger.debug("[master] failed to ping [{}], tried [{}] times, each with maximum [{}] timeout", MasterFaultDetection.this.masterNode, MasterFaultDetection.this.pingRetryCount, MasterFaultDetection.this.pingRetryTimeout);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, "failed to ping, tried [" + MasterFaultDetection.this.pingRetryCount + "] times, each with  maximum [" + MasterFaultDetection.this.pingRetryTimeout + "] timeout");
                            } else {
                                MasterFaultDetection.this.transportService.sendRequest(masterToPing, MasterFaultDetection.MASTER_PING_ACTION_NAME, request, options, this);
                            }
                        }
                    }
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public static interface Listener {
        public void onMasterFailure(DiscoveryNode var1, String var2);
    }
}

