/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class HttpServer
extends AbstractLifecycleComponent<HttpServer> {
    private final Environment environment;
    private final HttpServerTransport transport;
    private final RestController restController;
    private final NodeService nodeService;
    private final boolean disableSites;
    private final PluginSiteFilter pluginSiteFilter = new PluginSiteFilter();
    private final CircuitBreakerService circuitBreakerService;
    public static final Map<String, String> DEFAULT_MIME_TYPES;

    @Inject
    public HttpServer(Settings settings, Environment environment, HttpServerTransport transport, RestController restController, NodeService nodeService, CircuitBreakerService circuitBreakerService) {
        super(settings);
        this.environment = environment;
        this.transport = transport;
        this.restController = restController;
        this.nodeService = nodeService;
        this.circuitBreakerService = circuitBreakerService;
        nodeService.setHttpServer(this);
        this.disableSites = this.settings.getAsBoolean("http.disable_sites", (Boolean)false);
        transport.httpServerAdapter(new Dispatcher(this));
    }

    @Override
    protected void doStart() {
        this.transport.start();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}", this.transport.boundAddress());
        }
        this.nodeService.putAttribute("http_address", this.transport.boundAddress().publishAddress().toString());
    }

    @Override
    protected void doStop() {
        this.nodeService.removeAttribute("http_address");
        this.transport.stop();
    }

    @Override
    protected void doClose() {
        this.transport.close();
    }

    public HttpInfo info() {
        return this.transport.info();
    }

    public HttpStats stats() {
        return this.transport.stats();
    }

    public void internalDispatchRequest(RestRequest request, RestChannel channel) {
        String rawPath = request.rawPath();
        if (rawPath.startsWith("/_plugin/")) {
            RestFilterChain filterChain = this.restController.filterChain(this.pluginSiteFilter);
            filterChain.continueProcessing(request, channel);
            return;
        }
        if (rawPath.equals("/favicon.ico")) {
            this.handleFavicon(request, channel);
            return;
        }
        RestChannel responseChannel = channel;
        try {
            int contentLength = request.content().length();
            if (this.restController.canTripCircuitBreaker(request)) {
                HttpServer.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
            } else {
                HttpServer.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
            }
            responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService);
            this.restController.dispatchRequest(request, responseChannel);
        }
        catch (Throwable t) {
            this.restController.sendErrorResponse(request, responseChannel, t);
        }
    }

    void handleFavicon(RestRequest request, RestChannel channel) {
        if (request.method() == RestRequest.Method.GET) {
            try (InputStream stream = this.getClass().getResourceAsStream("/config/favicon.ico");){
                byte[] content = ByteStreams.toByteArray(stream);
                BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, "image/x-icon", content);
                channel.sendResponse(restResponse);
            }
            catch (IOException e) {
                channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR));
            }
        } else {
            channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN));
        }
    }

    void handlePluginSite(RestRequest request, RestChannel channel) throws IOException {
        if (this.disableSites) {
            channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN));
            return;
        }
        if (request.method() == RestRequest.Method.OPTIONS) {
            channel.sendResponse(new BytesRestResponse(RestStatus.OK));
            return;
        }
        if (request.method() != RestRequest.Method.GET) {
            channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN));
            return;
        }
        String path = request.rawPath().substring("/_plugin/".length());
        int i1 = path.indexOf(47);
        if (i1 == -1) {
            String pluginName = path;
            Object sitePath = null;
            String redirectUrl = request.rawPath() + "/";
            BytesRestResponse restResponse = new BytesRestResponse(RestStatus.MOVED_PERMANENTLY, "text/html", "<head><meta http-equiv=\"refresh\" content=\"0; URL=" + redirectUrl + "\"></head>");
            restResponse.addHeader("Location", redirectUrl);
            channel.sendResponse(restResponse);
            return;
        }
        String pluginName = path.substring(0, i1);
        String sitePath = path.substring(i1 + 1);
        if (sitePath.length() == 0) {
            sitePath = "index.html";
        } else {
            while (sitePath.length() > 0 && sitePath.charAt(0) == '/') {
                sitePath = sitePath.substring(1);
            }
        }
        Path siteFile = this.environment.pluginsFile().resolve(pluginName).resolve("_site");
        String separator = siteFile.getFileSystem().getSeparator();
        sitePath = sitePath.replace("/", separator);
        Path file = siteFile.resolve(sitePath);
        if (!Files.exists(file, new LinkOption[0]) || FileSystemUtils.isHidden(file) || !file.toAbsolutePath().normalize().startsWith(siteFile.toAbsolutePath().normalize())) {
            channel.sendResponse(new BytesRestResponse(RestStatus.NOT_FOUND));
            return;
        }
        BasicFileAttributes attributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        if (!attributes.isRegularFile()) {
            if (!attributes.isDirectory()) {
                channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN));
                return;
            }
            if (!Files.exists(file = file.resolve("index.html"), new LinkOption[0]) || FileSystemUtils.isHidden(file) || !Files.isRegularFile(file, new LinkOption[0])) {
                channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN));
                return;
            }
        }
        try {
            byte[] data = Files.readAllBytes(file);
            channel.sendResponse(new BytesRestResponse(RestStatus.OK, this.guessMimeType(sitePath), data));
        }
        catch (IOException e) {
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR));
        }
    }

    private String guessMimeType(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        String extension = path.substring(lastDot + 1).toLowerCase(Locale.ROOT);
        String mimeType = DEFAULT_MIME_TYPES.get(extension);
        if (mimeType == null) {
            return "";
        }
        return mimeType;
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    static {
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("csv", "text/csv");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("xhtml", "application/xhtml+xml");
        mimeTypes.put("json", "application/json");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("svg", "image/svg+xml");
        mimeTypes.put("ico", "image/vnd.microsoft.icon");
        mimeTypes.put("mp3", "audio/mpeg");
        DEFAULT_MIME_TYPES = ImmutableMap.copyOf(mimeTypes);
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final AtomicBoolean closed = new AtomicBoolean();

        public ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable BytesReference autoDetectSource, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(autoDetectSource, useFiltering);
        }

        @Override
        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            HttpServer.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.request().content().length());
        }
    }

    class PluginSiteFilter
    extends RestFilter {
        PluginSiteFilter() {
        }

        @Override
        public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) throws IOException {
            HttpServer.this.handlePluginSite(request, channel);
        }
    }

    static class Dispatcher
    implements HttpServerAdapter {
        private final HttpServer server;

        Dispatcher(HttpServer server) {
            this.server = server;
        }

        @Override
        public void dispatchRequest(RestRequest request, RestChannel channel) {
            this.server.internalDispatchRequest(request, channel);
        }
    }
}

