/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene54.Lucene54Codec;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettingsService;

public class CodecService
extends AbstractIndexComponent {
    private final MapperService mapperService;
    private final ImmutableMap<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(Index index) {
        this(index, Settings.Builder.EMPTY_SETTINGS);
    }

    public CodecService(Index index, Settings indexSettings) {
        this(index, indexSettings, null);
    }

    @Inject
    public CodecService(Index index, IndexSettingsService indexSettingsService, MapperService mapperService) {
        this(index, indexSettingsService.getSettings(), mapperService);
    }

    private CodecService(Index index, Settings indexSettings, MapperService mapperService) {
        super(index, indexSettings);
        this.mapperService = mapperService;
        MapBuilder<String, Codec> codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put(DEFAULT_CODEC, new Lucene54Codec());
            codecs.put(BEST_COMPRESSION_CODEC, new Lucene54Codec(Lucene50StoredFieldsFormat.Mode.BEST_COMPRESSION));
        } else {
            codecs.put(DEFAULT_CODEC, new PerFieldMappingPostingFormatCodec(Lucene50StoredFieldsFormat.Mode.BEST_SPEED, mapperService, this.logger));
            codecs.put(BEST_COMPRESSION_CODEC, new PerFieldMappingPostingFormatCodec(Lucene50StoredFieldsFormat.Mode.BEST_COMPRESSION, mapperService, this.logger));
        }
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.immutableMap();
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return ((ImmutableCollection)((Object)this.codecs.keySet())).toArray(new String[0]);
    }
}

