/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.OneMergeHelper;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.shard.MergeSchedulerConfig;
import org.elasticsearch.index.shard.ShardId;

class ElasticsearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    protected final ESLogger logger;
    private final Settings indexSettings;
    private final ShardId shardId;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();
    private final CounterMetric totalMergeStoppedTime = new CounterMetric();
    private final CounterMetric totalMergeThrottledTime = new CounterMetric();
    private final Set<OnGoingMerge> onGoingMerges = ConcurrentCollections.newConcurrentSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);
    private final MergeSchedulerConfig config;

    public ElasticsearchConcurrentMergeScheduler(ShardId shardId, Settings indexSettings, MergeSchedulerConfig config) {
        this.config = config;
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, shardId, new String[0]);
        this.refreshConfig();
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMerge(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        long timeNS = System.nanoTime();
        this.currentMerges.inc();
        this.currentMergesNumDocs.inc(totalNumDocs);
        this.currentMergesSizeInBytes.inc(totalSizeInBytes);
        OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
        this.onGoingMerges.add(onGoingMerge);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", OneMergeHelper.getSegmentName(merge), merge.segments.size(), totalNumDocs, new ByteSizeValue(totalSizeInBytes), new ByteSizeValue(merge.estimatedMergeBytes));
        }
        try {
            this.beforeMerge(onGoingMerge);
            super.doMerge(writer, merge);
        }
        catch (Throwable throwable) {
            long tookMS = TimeValue.nsecToMSec(System.nanoTime() - timeNS);
            this.onGoingMerges.remove(onGoingMerge);
            this.afterMerge(onGoingMerge);
            this.currentMerges.dec();
            this.currentMergesNumDocs.dec(totalNumDocs);
            this.currentMergesSizeInBytes.dec(totalSizeInBytes);
            this.totalMergesNumDocs.inc(totalNumDocs);
            this.totalMergesSizeInBytes.inc(totalSizeInBytes);
            this.totalMerges.inc(tookMS);
            long stoppedMS = TimeValue.nsecToMSec(merge.rateLimiter.getTotalStoppedNS());
            long throttledMS = TimeValue.nsecToMSec(merge.rateLimiter.getTotalPausedNS());
            this.totalMergeStoppedTime.inc(stoppedMS);
            this.totalMergeThrottledTime.inc(throttledMS);
            String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled], [%,.1f MB written], [%,.1f MB/sec throttle]", OneMergeHelper.getSegmentName(merge), TimeValue.timeValueMillis(tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis(stoppedMS), TimeValue.timeValueMillis(throttledMS), Float.valueOf((float)merge.rateLimiter.getTotalBytesWritten() / 1024.0f / 1024.0f), merge.rateLimiter.getMBPerSec());
            if (tookMS > 20000L) {
                this.logger.debug(message, new Object[0]);
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace(message, new Object[0]);
            }
            throw throwable;
        }
        long tookMS = TimeValue.nsecToMSec(System.nanoTime() - timeNS);
        this.onGoingMerges.remove(onGoingMerge);
        this.afterMerge(onGoingMerge);
        this.currentMerges.dec();
        this.currentMergesNumDocs.dec(totalNumDocs);
        this.currentMergesSizeInBytes.dec(totalSizeInBytes);
        this.totalMergesNumDocs.inc(totalNumDocs);
        this.totalMergesSizeInBytes.inc(totalSizeInBytes);
        this.totalMerges.inc(tookMS);
        long stoppedMS = TimeValue.nsecToMSec(merge.rateLimiter.getTotalStoppedNS());
        long throttledMS = TimeValue.nsecToMSec(merge.rateLimiter.getTotalPausedNS());
        this.totalMergeStoppedTime.inc(stoppedMS);
        this.totalMergeThrottledTime.inc(throttledMS);
        String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled], [%,.1f MB written], [%,.1f MB/sec throttle]", OneMergeHelper.getSegmentName(merge), TimeValue.timeValueMillis(tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis(stoppedMS), TimeValue.timeValueMillis(throttledMS), Float.valueOf((float)merge.rateLimiter.getTotalBytesWritten() / 1024.0f / 1024.0f), merge.rateLimiter.getMBPerSec());
        if (tookMS > 20000L) {
            this.logger.debug(message, new Object[0]);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace(message, new Object[0]);
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public MergeScheduler clone() {
        return this;
    }

    @Override
    protected boolean maybeStall(IndexWriter writer) {
        return true;
    }

    @Override
    protected ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(writer, merge);
        thread.setName(EsExecutors.threadName(this.indexSettings, "[" + this.shardId.index().name() + "][" + this.shardId.id() + "]: " + thread.getName()));
        return thread;
    }

    MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        mergeStats.add(this.totalMerges.count(), this.totalMerges.sum(), this.totalMergesNumDocs.count(), this.totalMergesSizeInBytes.count(), this.currentMerges.count(), this.currentMergesNumDocs.count(), this.currentMergesSizeInBytes.count(), this.totalMergeStoppedTime.count(), this.totalMergeThrottledTime.count(), this.config.isAutoThrottle() ? this.getIORateLimitMBPerSec() : Double.POSITIVE_INFINITY);
        return mergeStats;
    }

    void refreshConfig() {
        boolean isEnabled;
        if (this.getMaxMergeCount() != this.config.getMaxMergeCount() || this.getMaxThreadCount() != this.config.getMaxThreadCount()) {
            try {
                this.setMaxMergesAndThreads(this.config.getMaxMergeCount(), this.config.getMaxThreadCount());
            }
            catch (IllegalArgumentException ex) {
                this.logger.error("Failed to apply merge scheduler settings", ex, new Object[0]);
            }
        }
        boolean bl = isEnabled = this.getIORateLimitMBPerSec() != Double.POSITIVE_INFINITY;
        if (this.config.isAutoThrottle() && !isEnabled) {
            this.enableAutoIOThrottle();
        } else if (!this.config.isAutoThrottle() && isEnabled) {
            this.disableAutoIOThrottle();
        }
    }
}

