/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.indexing;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.shard.ShardId;

public final class IndexingSlowLog {
    private boolean reformat;
    private long indexWarnThreshold;
    private long indexInfoThreshold;
    private long indexDebugThreshold;
    private long indexTraceThreshold;
    private int maxSourceCharsToLog;
    private String level;
    private final ESLogger indexLogger;
    private final ESLogger deleteLogger;
    private static final String INDEX_INDEXING_SLOWLOG_PREFIX = "index.indexing.slowlog";
    public static final String INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN = "index.indexing.slowlog.threshold.index.warn";
    public static final String INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO = "index.indexing.slowlog.threshold.index.info";
    public static final String INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG = "index.indexing.slowlog.threshold.index.debug";
    public static final String INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE = "index.indexing.slowlog.threshold.index.trace";
    public static final String INDEX_INDEXING_SLOWLOG_REFORMAT = "index.indexing.slowlog.reformat";
    public static final String INDEX_INDEXING_SLOWLOG_LEVEL = "index.indexing.slowlog.level";
    public static final String INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG = "index.indexing.slowlog.source";

    IndexingSlowLog(ShardId shardId, Settings indexSettings) {
        this(indexSettings, Loggers.getLogger("index.indexing.slowlog.index", indexSettings, shardId, new String[0]), Loggers.getLogger("index.indexing.slowlog.delete", indexSettings, shardId, new String[0]));
    }

    IndexingSlowLog(Settings indexSettings, ESLogger indexLogger, ESLogger deleteLogger) {
        this.indexLogger = indexLogger;
        this.deleteLogger = deleteLogger;
        this.reformat = indexSettings.getAsBoolean(INDEX_INDEXING_SLOWLOG_REFORMAT, (Boolean)true);
        this.indexWarnThreshold = indexSettings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN, TimeValue.timeValueNanos(-1L)).nanos();
        this.indexInfoThreshold = indexSettings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO, TimeValue.timeValueNanos(-1L)).nanos();
        this.indexDebugThreshold = indexSettings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG, TimeValue.timeValueNanos(-1L)).nanos();
        this.indexTraceThreshold = indexSettings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE, TimeValue.timeValueNanos(-1L)).nanos();
        this.level = indexSettings.get(INDEX_INDEXING_SLOWLOG_LEVEL, "TRACE").toUpperCase(Locale.ROOT);
        this.maxSourceCharsToLog = this.readSourceToLog(indexSettings);
        indexLogger.setLevel(this.level);
        deleteLogger.setLevel(this.level);
    }

    synchronized void onRefreshSettings(Settings settings) {
        int maxSourceCharsToLog;
        boolean reformat;
        String level;
        long indexTraceThreshold;
        long indexDebugThreshold;
        long indexInfoThreshold;
        long indexWarnThreshold = settings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN, TimeValue.timeValueNanos(this.indexWarnThreshold)).nanos();
        if (indexWarnThreshold != this.indexWarnThreshold) {
            this.indexWarnThreshold = indexWarnThreshold;
        }
        if ((indexInfoThreshold = settings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO, TimeValue.timeValueNanos(this.indexInfoThreshold)).nanos()) != this.indexInfoThreshold) {
            this.indexInfoThreshold = indexInfoThreshold;
        }
        if ((indexDebugThreshold = settings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG, TimeValue.timeValueNanos(this.indexDebugThreshold)).nanos()) != this.indexDebugThreshold) {
            this.indexDebugThreshold = indexDebugThreshold;
        }
        if ((indexTraceThreshold = settings.getAsTime(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE, TimeValue.timeValueNanos(this.indexTraceThreshold)).nanos()) != this.indexTraceThreshold) {
            this.indexTraceThreshold = indexTraceThreshold;
        }
        if (!(level = settings.get(INDEX_INDEXING_SLOWLOG_LEVEL, this.level)).equals(this.level)) {
            this.indexLogger.setLevel(level.toUpperCase(Locale.ROOT));
            this.deleteLogger.setLevel(level.toUpperCase(Locale.ROOT));
            this.level = level;
        }
        if ((reformat = settings.getAsBoolean(INDEX_INDEXING_SLOWLOG_REFORMAT, (Boolean)this.reformat).booleanValue()) != this.reformat) {
            this.reformat = reformat;
        }
        if ((maxSourceCharsToLog = this.readSourceToLog(settings)) != this.maxSourceCharsToLog) {
            this.maxSourceCharsToLog = maxSourceCharsToLog;
        }
    }

    void postIndex(Engine.Index index, long tookInNanos) {
        this.postIndexing(index.parsedDoc(), tookInNanos);
    }

    void postCreate(Engine.Create create, long tookInNanos) {
        this.postIndexing(create.parsedDoc(), tookInNanos);
    }

    private int readSourceToLog(Settings settings) {
        String sourceToLog = settings.get(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG, "1000");
        try {
            return Integer.parseInt(sourceToLog, 10);
        }
        catch (NumberFormatException e) {
            return Booleans.parseBoolean(sourceToLog, true) ? Integer.MAX_VALUE : 0;
        }
    }

    private void postIndexing(ParsedDocument doc, long tookInNanos) {
        if (this.indexWarnThreshold >= 0L && tookInNanos > this.indexWarnThreshold) {
            this.indexLogger.warn("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
        } else if (this.indexInfoThreshold >= 0L && tookInNanos > this.indexInfoThreshold) {
            this.indexLogger.info("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
        } else if (this.indexDebugThreshold >= 0L && tookInNanos > this.indexDebugThreshold) {
            this.indexLogger.debug("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
        } else if (this.indexTraceThreshold >= 0L && tookInNanos > this.indexTraceThreshold) {
            this.indexLogger.trace("{}", new SlowLogParsedDocumentPrinter(doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
        }
    }

    static final class SlowLogParsedDocumentPrinter {
        private final ParsedDocument doc;
        private final long tookInNanos;
        private final boolean reformat;
        private final int maxSourceCharsToLog;

        SlowLogParsedDocumentPrinter(ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            this.doc = doc;
            this.tookInNanos = tookInNanos;
            this.reformat = reformat;
            this.maxSourceCharsToLog = maxSourceCharsToLog;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("took[").append(TimeValue.timeValueNanos(this.tookInNanos)).append("], took_millis[").append(TimeUnit.NANOSECONDS.toMillis(this.tookInNanos)).append("], ");
            sb.append("type[").append(this.doc.type()).append("], ");
            sb.append("id[").append(this.doc.id()).append("], ");
            if (this.doc.routing() == null) {
                sb.append("routing[] ");
            } else {
                sb.append("routing[").append(this.doc.routing()).append("] ");
            }
            if (this.maxSourceCharsToLog == 0 || this.doc.source() == null || this.doc.source().length() == 0) {
                return sb.toString();
            }
            try {
                String source = XContentHelper.convertToJson(this.doc.source(), this.reformat);
                sb.append(", source[").append(Strings.cleanTruncate(source, this.maxSourceCharsToLog)).append("]");
            }
            catch (IOException e) {
                sb.append(", source[_failed_to_convert_]");
            }
            return sb.toString();
        }
    }
}

