/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.spatial.util.GeoHashUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapperLegacy;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;

public abstract class BaseGeoPointFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(BaseGeoPointFieldMapper.class));
    protected DoubleFieldMapper latMapper;
    protected DoubleFieldMapper lonMapper;
    protected final ContentPath.Type pathType;
    protected StringFieldMapper geoHashMapper;
    protected Explicit<Boolean> ignoreMalformed;

    protected BaseGeoPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, ContentPath.Type pathType, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geoHashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.pathType = pathType;
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geoHashMapper = geoHashMapper;
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public GeoPointFieldType fieldType() {
        return (GeoPointFieldType)super.fieldType();
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        BaseGeoPointFieldMapper gpfmMergeWith = (BaseGeoPointFieldMapper)mergeWith;
        if (gpfmMergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gpfmMergeWith.ignoreMalformed;
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> extras = new ArrayList<FieldMapper>();
        if (this.fieldType().isGeoHashEnabled()) {
            extras.add(this.geoHashMapper);
        }
        if (this.fieldType().isLatLonEnabled()) {
            extras.add(this.latMapper);
            extras.add(this.lonMapper);
        }
        return Iterators.concat(super.iterator(), extras.iterator());
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected void parse(ParseContext context, GeoPoint point, String geoHash) throws IOException {
        if (this.fieldType().isGeoHashEnabled()) {
            if (geoHash == null) {
                geoHash = GeoHashUtils.stringEncode(point.lon(), point.lat());
            }
            this.addGeoHashField(context, geoHash);
        }
        if (this.fieldType().isLatLonEnabled()) {
            this.latMapper.parse(context.createExternalValueContext(point.lat()));
            this.lonMapper.parse(context.createExternalValueContext(point.lon()));
        }
        this.multiFields.parse(this, context.createExternalValueContext(point));
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        context.path().add(this.simpleName());
        GeoPoint sparse = context.parseExternalValue(GeoPoint.class);
        if (sparse != null) {
            this.parse(context, sparse, null);
        } else {
            sparse = new GeoPoint();
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                token = context.parser().nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    while (token != XContentParser.Token.END_ARRAY) {
                        this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                        token = context.parser().nextToken();
                    }
                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                    double lon = context.parser().doubleValue();
                    token = context.parser().nextToken();
                    double lat = context.parser().doubleValue();
                    while ((token = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                    }
                    this.parse(context, sparse.reset(lat, lon), null);
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            this.parsePointFromString(context, sparse, context.parser().text());
                        } else {
                            this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                        }
                        token = context.parser().nextToken();
                    }
                }
            } else if (token == XContentParser.Token.VALUE_STRING) {
                this.parsePointFromString(context, sparse, context.parser().text());
            } else if (token != XContentParser.Token.VALUE_NULL) {
                this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
            }
        }
        context.path().remove();
        context.path().pathType(origPathType);
        return null;
    }

    private void addGeoHashField(ParseContext context, String geoHash) throws IOException {
        int len = Math.min(this.fieldType().geoHashPrecision(), geoHash.length());
        int min = this.fieldType().isGeoHashPrefixEnabled() ? 1 : len;
        for (int i = len; i >= min; --i) {
            this.geoHashMapper.parse(context.createExternalValueContext(geoHash.substring(0, i)));
        }
    }

    private void parsePointFromString(ParseContext context, GeoPoint sparse, String point) throws IOException {
        if (point.indexOf(44) < 0) {
            this.parse(context, sparse.resetFromGeoHash(point), point);
        } else {
            this.parse(context, sparse.resetFromString(point), null);
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        if (includeDefaults || this.fieldType().isLatLonEnabled()) {
            builder.field("lat_lon", this.fieldType().isLatLonEnabled());
        }
        if (this.fieldType().isLatLonEnabled() && (includeDefaults || this.fieldType().latFieldType().numericPrecisionStep() != 16)) {
            builder.field("precision_step", this.fieldType().latFieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().isGeoHashEnabled()) {
            builder.field("geohash", this.fieldType().isGeoHashEnabled());
        }
        if (includeDefaults || this.fieldType().isGeoHashPrefixEnabled()) {
            builder.field("geohash_prefix", this.fieldType().isGeoHashPrefixEnabled());
        }
        if (this.fieldType().isGeoHashEnabled() && (includeDefaults || this.fieldType().geoHashPrecision() != 12)) {
            builder.field("geohash_precision", this.fieldType().geoHashPrecision());
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        DoubleFieldMapper lonUpdated;
        BaseGeoPointFieldMapper updated = (BaseGeoPointFieldMapper)super.updateFieldType((Map)fullNameToFieldType);
        StringFieldMapper geoUpdated = this.geoHashMapper == null ? null : (StringFieldMapper)this.geoHashMapper.updateFieldType((Map)fullNameToFieldType);
        DoubleFieldMapper latUpdated = this.latMapper == null ? null : (DoubleFieldMapper)this.latMapper.updateFieldType((Map)fullNameToFieldType);
        DoubleFieldMapper doubleFieldMapper = lonUpdated = this.lonMapper == null ? null : (DoubleFieldMapper)this.lonMapper.updateFieldType((Map)fullNameToFieldType);
        if (updated == this && geoUpdated == this.geoHashMapper && latUpdated == this.latMapper && lonUpdated == this.lonMapper) {
            return this;
        }
        if (updated == this) {
            updated = (BaseGeoPointFieldMapper)updated.clone();
        }
        updated.geoHashMapper = geoUpdated;
        updated.latMapper = latUpdated;
        updated.lonMapper = lonUpdated;
        return updated;
    }

    public static class GeoPointFieldType
    extends MappedFieldType {
        protected MappedFieldType geoHashFieldType;
        protected int geoHashPrecision;
        protected boolean geoHashPrefixEnabled;
        protected MappedFieldType latFieldType;
        protected MappedFieldType lonFieldType;

        GeoPointFieldType() {
        }

        GeoPointFieldType(GeoPointFieldType ref) {
            super(ref);
            this.geoHashFieldType = ref.geoHashFieldType;
            this.geoHashPrecision = ref.geoHashPrecision;
            this.geoHashPrefixEnabled = ref.geoHashPrefixEnabled;
            this.latFieldType = ref.latFieldType;
            this.lonFieldType = ref.lonFieldType;
        }

        @Override
        public MappedFieldType clone() {
            return new GeoPointFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            GeoPointFieldType that = (GeoPointFieldType)o;
            return this.geoHashPrecision == that.geoHashPrecision && this.geoHashPrefixEnabled == that.geoHashPrefixEnabled && Objects.equals(this.geoHashFieldType, that.geoHashFieldType) && Objects.equals(this.latFieldType, that.latFieldType) && Objects.equals(this.lonFieldType, that.lonFieldType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.geoHashFieldType, this.geoHashPrecision, this.geoHashPrefixEnabled, this.latFieldType, this.lonFieldType);
        }

        @Override
        public String typeName() {
            return BaseGeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            GeoPointFieldType other = (GeoPointFieldType)fieldType;
            if (this.isLatLonEnabled() != other.isLatLonEnabled()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [lat_lon]");
            }
            if (this.isLatLonEnabled() && other.isLatLonEnabled() && this.latFieldType().numericPrecisionStep() != other.latFieldType().numericPrecisionStep()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [precision_step]");
            }
            if (this.isGeoHashEnabled() != other.isGeoHashEnabled()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [geohash]");
            }
            if (this.geoHashPrecision() != other.geoHashPrecision()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [geohash_precision]");
            }
            if (this.isGeoHashPrefixEnabled() != other.isGeoHashPrefixEnabled()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [geohash_prefix]");
            }
        }

        public boolean isGeoHashEnabled() {
            return this.geoHashFieldType != null;
        }

        public MappedFieldType geoHashFieldType() {
            return this.geoHashFieldType;
        }

        public int geoHashPrecision() {
            return this.geoHashPrecision;
        }

        public boolean isGeoHashPrefixEnabled() {
            return this.geoHashPrefixEnabled;
        }

        public void setGeoHashEnabled(MappedFieldType geoHashFieldType, int geoHashPrecision, boolean geoHashPrefixEnabled) {
            this.checkIfFrozen();
            this.geoHashFieldType = geoHashFieldType;
            this.geoHashPrecision = geoHashPrecision;
            this.geoHashPrefixEnabled = geoHashPrefixEnabled;
        }

        public boolean isLatLonEnabled() {
            return this.latFieldType != null;
        }

        public MappedFieldType latFieldType() {
            return this.latFieldType;
        }

        public MappedFieldType lonFieldType() {
            return this.lonFieldType;
        }

        public void setLatLonEnabled(MappedFieldType latFieldType, MappedFieldType lonFieldType) {
            this.checkIfFrozen();
            this.latFieldType = latFieldType;
            this.lonFieldType = lonFieldType;
        }
    }

    public static abstract class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = parserContext.indexVersionCreated().before(Version.V_2_2_0) ? new GeoPointFieldMapperLegacy.Builder(name) : new GeoPointFieldMapper.Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("lat_lon")) {
                    deprecationLogger.deprecated("geo_point lat_lon parameter is deprecated and will be removed in the next major release", new Object[0]);
                    builder.enableLatLon(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("precision_step")) {
                    deprecationLogger.deprecated("geo_point precision_step parameter is deprecated and will be removed in the next major release", new Object[0]);
                    builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("geohash")) {
                    deprecationLogger.deprecated("geo_point geohash parameter is deprecated and will be removed in the next major release", new Object[0]);
                    builder.enableGeoHash(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("geohash_prefix")) {
                    deprecationLogger.deprecated("geo_point geohash_prefix parameter is deprecated and will be removed in the next major release", new Object[0]);
                    builder.geoHashPrefix(XContentMapValues.nodeBooleanValue(propNode));
                    if (XContentMapValues.nodeBooleanValue(propNode)) {
                        builder.enableGeoHash(true);
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("geohash_precision")) {
                    deprecationLogger.deprecated("geo_point geohash_precision parameter is deprecated and will be removed in the next major release", new Object[0]);
                    if (propNode instanceof Integer) {
                        builder.geoHashPrecision(XContentMapValues.nodeIntegerValue(propNode));
                    } else {
                        builder.geoHashPrecision(GeoUtils.geoHashLevelsForPrecision(propNode.toString()));
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            if (builder instanceof GeoPointFieldMapperLegacy.Builder) {
                return GeoPointFieldMapperLegacy.parse((GeoPointFieldMapperLegacy.Builder)builder, node, parserContext);
            }
            return (GeoPointFieldMapper.Builder)builder;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends BaseGeoPointFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        protected ContentPath.Type pathType = Defaults.PATH_TYPE;
        protected boolean enableLatLon = false;
        protected Integer precisionStep;
        protected boolean enableGeoHash = false;
        protected boolean enableGeoHashPrefix = false;
        protected int geoHashPrecision = 12;
        protected Boolean ignoreMalformed;

        public Builder(String name, GeoPointFieldType fieldType) {
            super(name, fieldType, fieldType);
        }

        @Override
        public GeoPointFieldType fieldType() {
            return (GeoPointFieldType)this.fieldType;
        }

        @Override
        public T multiFieldPathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return (T)((Builder)this.builder);
        }

        @Override
        public T fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (T)((Builder)this.builder);
        }

        public T enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return (T)((Builder)this.builder);
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return (T)((Builder)this.builder);
        }

        public T geoHashPrefix(boolean enableGeoHashPrefix) {
            this.enableGeoHashPrefix = enableGeoHashPrefix;
            return (T)((Builder)this.builder);
        }

        public T geoHashPrecision(int precision) {
            this.geoHashPrecision = precision;
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public abstract Y build(Mapper.BuilderContext var1, String var2, MappedFieldType var3, MappedFieldType var4, Settings var5, ContentPath.Type var6, DoubleFieldMapper var7, DoubleFieldMapper var8, StringFieldMapper var9, FieldMapper.MultiFields var10, Explicit<Boolean> var11, FieldMapper.CopyTo var12);

        @Override
        public Y build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            GeoPointFieldType geoPointFieldType = (GeoPointFieldType)this.fieldType;
            DoubleFieldMapper latMapper = null;
            DoubleFieldMapper lonMapper = null;
            context.path().add(this.name);
            if (this.enableLatLon) {
                NumberFieldMapper.Builder latMapperBuilder = (NumberFieldMapper.Builder)MapperBuilders.doubleField("lat").includeInAll(false);
                NumberFieldMapper.Builder lonMapperBuilder = (NumberFieldMapper.Builder)MapperBuilders.doubleField("lon").includeInAll(false);
                if (this.precisionStep != null) {
                    latMapperBuilder.precisionStep(this.precisionStep);
                    lonMapperBuilder.precisionStep(this.precisionStep);
                }
                latMapper = (DoubleFieldMapper)((Mapper.Builder)((FieldMapper.Builder)((NumberFieldMapper.Builder)latMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                lonMapper = (DoubleFieldMapper)((Mapper.Builder)((FieldMapper.Builder)((NumberFieldMapper.Builder)lonMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                geoPointFieldType.setLatLonEnabled(latMapper.fieldType(), lonMapper.fieldType());
            }
            StringFieldMapper geoHashMapper = null;
            if (this.enableGeoHash || this.enableGeoHashPrefix) {
                geoHashMapper = ((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)MapperBuilders.stringField("geohash").index(true)).tokenized(false)).includeInAll(false)).store(this.fieldType.stored())).omitNorms(true)).indexOptions(IndexOptions.DOCS)).build(context);
                geoPointFieldType.setGeoHashEnabled(geoHashMapper.fieldType(), this.geoHashPrecision, this.enableGeoHashPrefix);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            return this.build(context, this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), origPathType, latMapper, lonMapper, geoHashMapper, this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final boolean ENABLE_GEOHASH_PREFIX = false;
        public static final int GEO_HASH_PRECISION = 12;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }
}

