/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;

public class IdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_id";
    public static final String CONTENT_TYPE = "_id";
    private final String path;

    private IdFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(IdFieldMapper.idFieldType(indexSettings, existing), Defaults.PATH, indexSettings);
    }

    private IdFieldMapper(MappedFieldType fieldType, String path, Settings indexSettings) {
        super("_id", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.path = path;
    }

    private static MappedFieldType idFieldType(Settings indexSettings, MappedFieldType existing) {
        if (existing != null) {
            return existing.clone();
        }
        MappedFieldType fieldType = Defaults.FIELD_TYPE.clone();
        boolean pre2x = Version.indexCreated(indexSettings).before(Version.V_2_0_0_beta1);
        if (pre2x && !indexSettings.getAsBoolean("index.mapping._id.indexed", (Boolean)true).booleanValue()) {
            fieldType.setTokenized(false);
        }
        return fieldType;
    }

    public String path() {
        return this.path;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentName() != null && parser.currentName().equals("_id") && parser.currentToken().isValue()) {
            String id = parser.text();
            if (context.id() != null && !context.id().equals(id)) {
                throw new MapperParsingException("Provided id [" + context.id() + "] does not match the content one [" + id + "]");
            }
            context.id(id);
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            fields.add(new Field(this.fieldType().names().indexName(), context.id(), (FieldType)this.fieldType()));
        }
        if (this.fieldType().hasDocValues()) {
            fields.add(new BinaryDocValuesField(this.fieldType().names().indexName(), new BytesRef(context.id())));
        }
    }

    @Override
    protected String contentType() {
        return "_id";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.indexCreatedBefore2x) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType().stored() == Defaults.FIELD_TYPE.stored() && this.fieldType().indexOptions() == Defaults.FIELD_TYPE.indexOptions() && this.path == Defaults.PATH && !this.hasCustomFieldDataSettings()) {
            return builder;
        }
        builder.startObject("_id");
        if (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || this.fieldType().indexOptions() != Defaults.FIELD_TYPE.indexOptions()) {
            builder.field("index", IdFieldMapper.indexTokenizeOptionToString(this.fieldType().indexOptions() != IndexOptions.NONE, this.fieldType().tokenized()));
        }
        if (includeDefaults || this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        if (includeDefaults || this.hasCustomFieldDataSettings()) {
            builder.field("fielddata", this.fieldType().fieldDataType().getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class IdFieldType
    extends MappedFieldType {
        public IdFieldType() {
            this.setFieldDataType(new FieldDataType("string"));
        }

        protected IdFieldType(IdFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new IdFieldType(this);
        }

        @Override
        public String typeName() {
            return "_id";
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        @Override
        public boolean useTermQueryWithQueryString() {
            return true;
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryParseContext context) {
            if (this.indexOptions() != IndexOptions.NONE || context == null) {
                return super.termQuery(value, context);
            }
            BytesRef[] uids = Uid.createUidsForTypesAndId(context.queryTypes(), value);
            return new TermsQuery("_uid", uids);
        }

        @Override
        public Query termsQuery(List values, @Nullable QueryParseContext context) {
            if (this.indexOptions() != IndexOptions.NONE || context == null) {
                return super.termsQuery(values, context);
            }
            return new TermsQuery("_uid", Uid.createUidsForTypesAndIds(context.queryTypes(), values));
        }

        @Override
        public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
            if (this.indexOptions() != IndexOptions.NONE || context == null) {
                return super.prefixQuery(value, method, context);
            }
            Collection<String> queryTypes = context.queryTypes();
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String queryType : queryTypes) {
                PrefixQuery prefixQuery = new PrefixQuery(new Term("_uid", Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value))));
                if (method != null) {
                    prefixQuery.setRewriteMethod(method);
                }
                query.add(prefixQuery, BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }

        @Override
        public Query regexpQuery(String value, int flags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
            if (this.indexOptions() != IndexOptions.NONE || context == null) {
                return super.regexpQuery(value, flags, maxDeterminizedStates, method, context);
            }
            Collection<String> queryTypes = context.queryTypes();
            if (queryTypes.size() == 1) {
                RegexpQuery regexpQuery = new RegexpQuery(new Term("_uid", Uid.createUidAsBytes((String)Iterables.getFirst(queryTypes, null), BytesRefs.toBytesRef(value))), flags, maxDeterminizedStates);
                if (method != null) {
                    regexpQuery.setRewriteMethod(method);
                }
                return regexpQuery;
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (String queryType : queryTypes) {
                RegexpQuery regexpQuery = new RegexpQuery(new Term("_uid", Uid.createUidAsBytes(queryType, BytesRefs.toBytesRef(value))), flags, maxDeterminizedStates);
                if (method != null) {
                    regexpQuery.setRewriteMethod(method);
                }
                query.add(regexpQuery, BooleanClause.Occur.SHOULD);
            }
            return query.build();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
                throw new MapperParsingException("_id is not configurable");
            }
            Builder builder = new Builder(parserContext.mapperService().fullName("_id"));
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("path")) continue;
                builder.path(fieldNode.toString());
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new IdFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, IdFieldMapper> {
        private String path = Defaults.PATH;

        public Builder(MappedFieldType existing) {
            super("_id", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
            this.indexName = "_id";
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        @Override
        protected IndexOptions getDefaultIndexOption() {
            return IndexOptions.DOCS;
        }

        @Override
        public IdFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new IdFieldMapper(this.fieldType, this.path, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_id";
        public static final MappedFieldType FIELD_TYPE = new IdFieldType();
        public static final String PATH;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_id"));
            FIELD_TYPE.freeze();
            PATH = null;
        }
    }
}

