/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.elasticsearch.common.io.stream.StreamInput;

public final class BufferedChecksumStreamInput
extends StreamInput {
    private static final int SKIP_BUFFER_SIZE = 1024;
    private byte[] skipBuffer;
    private final StreamInput in;
    private final Checksum digest;

    public BufferedChecksumStreamInput(StreamInput in) {
        this.in = in;
        this.digest = new BufferedChecksum(new CRC32());
    }

    public BufferedChecksumStreamInput(StreamInput in, BufferedChecksumStreamInput reuse) {
        this.in = in;
        if (reuse == null) {
            this.digest = new BufferedChecksum(new CRC32());
        } else {
            this.digest = reuse.digest;
            this.digest.reset();
            this.skipBuffer = reuse.skipBuffer;
        }
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.in.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.digest.reset();
    }

    @Override
    public int read() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public long skip(long numBytes) throws IOException {
        long skipped;
        int step;
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (skipped = 0L; skipped < numBytes; skipped += (long)step) {
            step = (int)Math.min(1024L, numBytes - skipped);
            this.readBytes(this.skipBuffer, 0, step);
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public void resetDigest() {
        this.digest.reset();
    }
}

