/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.plugins.PluginManager;

public class PluginInfo
implements Streamable,
ToXContent {
    public static final String ES_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    public static final String ES_PLUGIN_POLICY = "plugin-security.policy";
    private String name;
    private String description;
    private boolean site;
    private String version;
    private boolean jvm;
    private String classname;
    private boolean isolated;

    public PluginInfo() {
    }

    PluginInfo(String name, String description, boolean site, String version, boolean jvm, String classname, boolean isolated) {
        this.name = name;
        this.description = description;
        this.site = site;
        this.jvm = jvm;
        this.version = version;
        this.classname = classname;
        this.isolated = isolated;
    }

    public static PluginInfo readFromProperties(Path dir) throws IOException {
        Path descriptor = dir.resolve(ES_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        String name = props.getProperty("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property [name] is missing in [" + descriptor + "]");
        }
        PluginManager.checkForForbiddenName(name);
        String description = props.getProperty("description");
        if (description == null) {
            throw new IllegalArgumentException("Property [description] is missing for plugin [" + name + "]");
        }
        String version = props.getProperty("version");
        if (version == null) {
            throw new IllegalArgumentException("Property [version] is missing for plugin [" + name + "]");
        }
        boolean jvm = Boolean.parseBoolean(props.getProperty("jvm"));
        boolean site = Boolean.parseBoolean(props.getProperty("site"));
        if (!jvm && !site) {
            throw new IllegalArgumentException("Plugin [" + name + "] must be at least a jvm or site plugin");
        }
        boolean isolated = true;
        String classname = "NA";
        if (jvm) {
            String esVersionString = props.getProperty("elasticsearch.version");
            if (esVersionString == null) {
                throw new IllegalArgumentException("Property [elasticsearch.version] is missing for jvm plugin [" + name + "]");
            }
            Version esVersion = Version.fromString(esVersionString);
            if (!esVersion.equals(Version.CURRENT)) {
                throw new IllegalArgumentException("Plugin [" + name + "] is incompatible with Elasticsearch [" + Version.CURRENT.toString() + "]. Was designed for version [" + esVersionString + "]");
            }
            String javaVersionString = props.getProperty("java.version");
            if (javaVersionString == null) {
                throw new IllegalArgumentException("Property [java.version] is missing for jvm plugin [" + name + "]");
            }
            JarHell.checkVersionFormat(javaVersionString);
            JarHell.checkJavaVersion(name, javaVersionString);
            isolated = Boolean.parseBoolean(props.getProperty("isolated", "true"));
            classname = props.getProperty("classname");
            if (classname == null) {
                throw new IllegalArgumentException("Property [classname] is missing for jvm plugin [" + name + "]");
            }
        }
        if (site && !Files.exists(dir.resolve("_site"), new LinkOption[0])) {
            throw new IllegalArgumentException("Plugin [" + name + "] is a site plugin but has no '_site/' directory");
        }
        return new PluginInfo(name, description, site, version, jvm, classname, isolated);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSite() {
        return this.site;
    }

    public boolean isJvm() {
        return this.jvm;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getUrl() {
        if (this.site) {
            return "/_plugin/" + this.name + "/";
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public static PluginInfo readFromStream(StreamInput in) throws IOException {
        PluginInfo info = new PluginInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.site = in.readBoolean();
        this.jvm = in.readBoolean();
        this.version = in.readString();
        this.classname = in.readString();
        this.isolated = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeBoolean(this.site);
        out.writeBoolean(this.jvm);
        out.writeString(this.version);
        out.writeString(this.classname);
        out.writeBoolean(this.isolated);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.NAME, this.name);
        builder.field(Fields.VERSION, this.version);
        builder.field(Fields.DESCRIPTION, this.description);
        if (this.site) {
            builder.field(Fields.URL, this.getUrl());
        }
        builder.field(Fields.JVM, this.jvm);
        if (this.jvm) {
            builder.field(Fields.CLASSNAME, this.classname);
            builder.field(Fields.ISOLATED, this.isolated);
        }
        builder.field(Fields.SITE, this.site);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder information = new StringBuilder().append("- Plugin information:\n").append("Name: ").append(this.name).append("\n").append("Description: ").append(this.description).append("\n").append("Site: ").append(this.site).append("\n").append("Version: ").append(this.version).append("\n").append("JVM: ").append(this.jvm).append("\n");
        if (this.jvm) {
            information.append(" * Classname: ").append(this.classname).append("\n");
            information.append(" * Isolated: ").append(this.isolated);
        }
        return information.toString();
    }

    static final class Fields {
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString DESCRIPTION = new XContentBuilderString("description");
        static final XContentBuilderString URL = new XContentBuilderString("url");
        static final XContentBuilderString SITE = new XContentBuilderString("site");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString CLASSNAME = new XContentBuilderString("classname");
        static final XContentBuilderString ISOLATED = new XContentBuilderString("isolated");

        Fields() {
        }
    }
}

