/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg;

import com.google.common.base.Function;
import com.google.common.collect.EvictingQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.movavg.SimulatedAnealingMinimizer;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelStreams;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;
import org.joda.time.DateTime;

public class MovAvgPipelineAggregator
extends PipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("moving_avg");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public MovAvgPipelineAggregator readResult(StreamInput in) throws IOException {
            MovAvgPipelineAggregator result = new MovAvgPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private static final Function<Aggregation, InternalAggregation> FUNCTION = new Function<Aggregation, InternalAggregation>(){

        @Override
        public InternalAggregation apply(Aggregation input) {
            return (InternalAggregation)input;
        }
    };
    private ValueFormatter formatter;
    private BucketHelpers.GapPolicy gapPolicy;
    private int window;
    private MovAvgModel model;
    private int predict;
    private boolean minimize;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    public MovAvgPipelineAggregator() {
    }

    public MovAvgPipelineAggregator(String name, String[] bucketsPaths, ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, int window, int predict, MovAvgModel model, boolean minimize, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.window = window;
        this.model = model;
        this.predict = predict;
        this.minimize = minimize;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalHistogram histo = (InternalHistogram)aggregation;
        List buckets = histo.getBuckets();
        InternalHistogram.Factory factory = histo.getFactory();
        ArrayList<InternalHistogram.Bucket> newBuckets = new ArrayList<InternalHistogram.Bucket>();
        EvictingQueue<Double> values = EvictingQueue.create(this.window);
        long lastValidKey = 0L;
        int lastValidPosition = 0;
        int counter = 0;
        if (this.minimize) {
            assert (this.model.canBeMinimized());
            this.model = this.minimize(buckets, histo, this.model);
        }
        for (InternalHistogram.Bucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, (MultiBucketsAggregation.Bucket)bucket, this.bucketsPaths()[0], this.gapPolicy);
            InternalHistogram.Bucket newBucket = bucket;
            if (thisBucketValue != null && !thisBucketValue.equals(Double.NaN)) {
                if (this.model.hasValue(values.size())) {
                    double movavg = this.model.next(values);
                    ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
                    aggs.add(new InternalSimpleValue(this.name(), movavg, this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                    newBucket = factory.createBucket(bucket.getKey(), bucket.getDocCount(), new InternalAggregations(aggs), bucket.getKeyed(), bucket.getFormatter());
                }
                if (this.predict > 0) {
                    if (bucket.getKey() instanceof Number) {
                        lastValidKey = ((Number)bucket.getKey()).longValue();
                    } else if (bucket.getKey() instanceof DateTime) {
                        lastValidKey = ((DateTime)bucket.getKey()).getMillis();
                    } else {
                        throw new AggregationExecutionException("Expected key of type Number or DateTime but got [" + lastValidKey + "]");
                    }
                    lastValidPosition = counter;
                }
                values.offer(thisBucketValue);
            }
            ++counter;
            newBuckets.add(newBucket);
        }
        if (buckets.size() > 0 && this.predict > 0) {
            boolean keyed = ((InternalHistogram.Bucket)buckets.get(0)).getKeyed();
            ValueFormatter formatter = ((InternalHistogram.Bucket)buckets.get(0)).getFormatter();
            double[] predictions = this.model.predict(values, this.predict);
            for (int i = 0; i < predictions.length; ++i) {
                ArrayList<InternalAggregation> aggs;
                long newKey = histo.getRounding().nextRoundingValue(lastValidKey);
                if (lastValidPosition + i + 1 < newBuckets.size()) {
                    InternalHistogram.Bucket bucket = (InternalHistogram.Bucket)newBuckets.get(lastValidPosition + i + 1);
                    aggs = new ArrayList(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
                    aggs.add(new InternalSimpleValue(this.name(), predictions[i], formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                    Object newBucket = factory.createBucket(newKey, 0L, new InternalAggregations(aggs), keyed, formatter);
                    newBuckets.set(lastValidPosition + i + 1, (InternalHistogram.Bucket)newBucket);
                } else {
                    aggs = new ArrayList<InternalSimpleValue>();
                    aggs.add(new InternalSimpleValue(this.name(), predictions[i], formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                    Object newBucket = factory.createBucket(newKey, 0L, new InternalAggregations(aggs), keyed, formatter);
                    newBuckets.add((InternalHistogram.Bucket)newBucket);
                }
                lastValidKey = newKey;
            }
        }
        return factory.create(newBuckets, histo);
    }

    private MovAvgModel minimize(List<? extends InternalHistogram.Bucket> buckets, InternalHistogram histo, MovAvgModel model) {
        int counter = 0;
        EvictingQueue<Double> values = EvictingQueue.create(this.window);
        double[] test = new double[this.window];
        ListIterator<? extends InternalHistogram.Bucket> iter = buckets.listIterator(buckets.size());
        while (iter.hasPrevious() && counter < this.window) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, (MultiBucketsAggregation.Bucket)iter.previous(), this.bucketsPaths()[0], this.gapPolicy);
            if (thisBucketValue == null || thisBucketValue.equals(Double.NaN)) continue;
            test[this.window - counter - 1] = thisBucketValue;
            ++counter;
        }
        if (counter < this.window) {
            return model;
        }
        counter = 0;
        double[] train = new double[this.window];
        while (iter.hasPrevious() && counter < this.window) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, (MultiBucketsAggregation.Bucket)iter.previous(), this.bucketsPaths()[0], this.gapPolicy);
            if (thisBucketValue == null || thisBucketValue.equals(Double.NaN)) continue;
            train[this.window - counter - 1] = thisBucketValue;
            ++counter;
        }
        if (counter < this.window) {
            return model;
        }
        for (double v : train) {
            values.add(v);
        }
        return SimulatedAnealingMinimizer.minimize(model, values, test);
    }

    @Override
    public void doReadFrom(StreamInput in) throws IOException {
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.window = in.readVInt();
        this.predict = in.readVInt();
        this.model = MovAvgModelStreams.read(in);
        this.minimize = in.readBoolean();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.formatter, out);
        this.gapPolicy.writeTo(out);
        out.writeVInt(this.window);
        out.writeVInt(this.predict);
        this.model.writeTo(out);
        out.writeBoolean(this.minimize);
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;
        private BucketHelpers.GapPolicy gapPolicy;
        private int window;
        private MovAvgModel model;
        private int predict;
        private boolean minimize;

        public Factory(String name, String[] bucketsPaths, ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, int window, int predict, MovAvgModel model, boolean minimize) {
            super(name, TYPE.name(), bucketsPaths);
            this.formatter = formatter;
            this.gapPolicy = gapPolicy;
            this.window = window;
            this.model = model;
            this.predict = predict;
            this.minimize = minimize;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new MovAvgPipelineAggregator(this.name, this.bucketsPaths, this.formatter, this.gapPolicy, this.window, this.predict, this.model, this.minimize, metaData);
        }

        @Override
        public void doValidate(AggregatorFactory parent, AggregatorFactory[] aggFactories, List<PipelineAggregatorFactory> pipelineAggregatoractories) {
            if (this.bucketsPaths.length != 1) {
                throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
            }
            if (!(parent instanceof HistogramAggregator.Factory)) {
                throw new IllegalStateException("moving average aggregation [" + this.name + "] must have a histogram or date_histogram as parent");
            }
            HistogramAggregator.Factory histoParent = (HistogramAggregator.Factory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of moving average aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        }
    }
}

