/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.fielddata;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsContext;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.SearchContext;

public class FieldDataFieldsFetchSubPhase
implements FetchSubPhase {
    public static final String[] NAMES = new String[]{"fielddata_fields", "fielddataFields"};
    public static final FetchSubPhase.ContextFactory<FieldDataFieldsContext> CONTEXT_FACTORY = new FetchSubPhase.ContextFactory<FieldDataFieldsContext>(){

        @Override
        public String getName() {
            return NAMES[0];
        }

        @Override
        public FieldDataFieldsContext newContextInstance() {
            return new FieldDataFieldsContext();
        }
    };

    @Inject
    public FieldDataFieldsFetchSubPhase() {
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, FieldDataFieldsParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("fielddata_fields", new FieldDataFieldsParseElement()).put("fielddataFields", new FieldDataFieldsParseElement());
        return parseElements.build();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.getFetchSubPhaseContext(CONTEXT_FACTORY).hitExecutionNeeded();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        for (FieldDataFieldsContext.FieldDataField field : context.getFetchSubPhaseContext(CONTEXT_FACTORY).fields()) {
            MappedFieldType fieldType;
            SearchHitField hitField;
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(field.name())) == null) {
                hitField = new InternalSearchHitField(field.name(), new ArrayList<Object>(2));
                hitContext.hit().fields().put(field.name(), hitField);
            }
            if ((fieldType = context.mapperService().smartNameFieldType(field.name())) == null) continue;
            Object data = context.fieldData().getForField(fieldType).load(hitContext.readerContext());
            ScriptDocValues values = data.getScriptValues();
            values.setNextDocId(hitContext.docId());
            hitField.values().addAll(values.getValues());
        }
    }
}

