/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.profile.CollectorResult;
import org.elasticsearch.search.profile.ProfileResult;

public final class ProfileShardResult
implements Writeable<ProfileShardResult>,
ToXContent {
    private final List<ProfileResult> profileResults;
    private final CollectorResult profileCollector;
    private final long rewriteTime;

    public ProfileShardResult(List<ProfileResult> profileResults, long rewriteTime, CollectorResult profileCollector) {
        assert (profileCollector != null);
        this.profileResults = profileResults;
        this.profileCollector = profileCollector;
        this.rewriteTime = rewriteTime;
    }

    public ProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.profileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.profileResults.add(new ProfileResult(in));
        }
        this.profileCollector = new CollectorResult(in);
        this.rewriteTime = in.readLong();
    }

    public List<ProfileResult> getQueryResults() {
        return Collections.unmodifiableList(this.profileResults);
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }

    public CollectorResult getCollectorResult() {
        return this.profileCollector;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("query");
        for (ProfileResult p : this.profileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("rewrite_time", this.rewriteTime);
        builder.startArray("collector");
        this.profileCollector.toXContent(builder, params);
        builder.endArray();
        return builder;
    }

    @Override
    public ProfileShardResult readFrom(StreamInput in) throws IOException {
        return new ProfileShardResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.profileResults.size());
        for (ProfileResult p : this.profileResults) {
            p.writeTo(out);
        }
        this.profileCollector.writeTo(out);
        out.writeLong(this.rewriteTime);
    }
}

