/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty.ChannelBufferStreamInputFactory;
import org.elasticsearch.transport.netty.NettyTransport;
import org.elasticsearch.transport.netty.NettyTransportChannel;
import org.elasticsearch.transport.support.TransportStatus;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.WriteCompletionEvent;

public class MessageChannelHandler
extends SimpleChannelUpstreamHandler {
    protected final ESLogger logger;
    protected final ThreadPool threadPool;
    protected final TransportServiceAdapter transportServiceAdapter;
    protected final NettyTransport transport;
    protected final String profileName;

    public MessageChannelHandler(NettyTransport transport, ESLogger logger, String profileName) {
        this.threadPool = transport.threadPool();
        this.transportServiceAdapter = transport.transportServiceAdapter();
        this.transport = transport;
        this.logger = logger;
        this.profileName = profileName;
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        this.transportServiceAdapter.sent(e.getWrittenAmount());
        super.writeComplete(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Transports.assertTransportThread();
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer buffer = (ChannelBuffer)m;
        Marker marker = new Marker(buffer);
        int size = marker.messageSizeWithRemainingHeaders();
        this.transportServiceAdapter.received(marker.messageSizeWithAllHeaders());
        boolean hasMessageBytesToRead = marker.messageSize() != 0;
        StreamInput streamIn = ChannelBufferStreamInputFactory.create(buffer, size);
        boolean success = false;
        try {
            long requestId = streamIn.readLong();
            byte status = streamIn.readByte();
            Version version = Version.fromId(streamIn.readInt());
            if (TransportStatus.isCompress(status) && hasMessageBytesToRead && buffer.readable()) {
                Compressor compressor;
                try {
                    compressor = CompressorFactory.compressor(buffer);
                }
                catch (NotCompressedException ex) {
                    int maxToRead = Math.min(buffer.readableBytes(), 10);
                    int offset = buffer.readerIndex();
                    StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(buffer.readableBytes()).append("] readable bytes with message size [").append(size).append("] ").append("] are [");
                    for (int i = 0; i < maxToRead; ++i) {
                        sb.append(buffer.getByte(offset + i)).append(",");
                    }
                    sb.append("]");
                    throw new IllegalStateException(sb.toString());
                }
                streamIn = compressor.streamInput(streamIn);
            }
            if (!version.onOrAfter(Version.CURRENT.minimumCompatibilityVersion()) || version.major != Version.CURRENT.major) {
                throw new IllegalStateException("Received message from unsupported version: [" + version + "] minimal compatible version is: [" + Version.CURRENT.minimumCompatibilityVersion() + "]");
            }
            streamIn.setVersion(version);
            if (TransportStatus.isRequest(status)) {
                this.handleRequest(ctx.getChannel(), marker, streamIn, requestId, size, version);
            } else {
                TransportResponseHandler handler = this.transportServiceAdapter.onResponseReceived(requestId);
                if (handler != null) {
                    if (TransportStatus.isError(status)) {
                        this.handlerResponseError(streamIn, handler);
                    } else {
                        this.handleResponse(ctx.getChannel(), streamIn, handler);
                    }
                    marker.validateResponse(streamIn, requestId, handler, TransportStatus.isError(status));
                }
            }
            success = true;
        }
        catch (Throwable throwable) {
            try {
                if (success) {
                    IOUtils.close(streamIn);
                } else {
                    IOUtils.closeWhileHandlingException(streamIn);
                }
            }
            finally {
                buffer.readerIndex(marker.expectedReaderIndex());
            }
            throw throwable;
        }
        try {
            if (success) {
                IOUtils.close(streamIn);
            }
            IOUtils.closeWhileHandlingException(streamIn);
        }
        finally {
            buffer.readerIndex(marker.expectedReaderIndex());
        }
    }

    protected void handleResponse(Channel channel, StreamInput buffer, TransportResponseHandler handler) {
        buffer = new NamedWriteableAwareStreamInput(buffer, this.transport.namedWriteableRegistry);
        Object response = handler.newInstance();
        ((TransportMessage)response).remoteAddress(new InetSocketTransportAddress((InetSocketAddress)channel.getRemoteAddress()));
        ((TransportMessage)response).remoteAddress();
        try {
            ((TransportMessage)response).readFrom(buffer);
        }
        catch (Throwable e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + response.getClass().getName() + "]", e));
            return;
        }
        try {
            if ("same".equals(handler.executor())) {
                handler.handleResponse(response);
            } else {
                this.threadPool.executor(handler.executor()).execute(new ResponseHandler(handler, (TransportResponse)response));
            }
        }
        catch (Throwable e) {
            this.handleException(handler, new ResponseHandlerFailureTransportException(e));
        }
    }

    private void handlerResponseError(StreamInput buffer, TransportResponseHandler handler) {
        Object error;
        try {
            error = buffer.readThrowable();
        }
        catch (Throwable e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, (Throwable)error);
    }

    private void handleException(final TransportResponseHandler handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException(error.getMessage(), error);
        }
        final RemoteTransportException rtx = (RemoteTransportException)error;
        if ("same".equals(handler.executor())) {
            try {
                handler.handleException(rtx);
            }
            catch (Throwable e) {
                this.logger.error("failed to handle exception response [{}]", e, handler);
            }
        } else {
            this.threadPool.executor(handler.executor()).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        handler.handleException(rtx);
                    }
                    catch (Throwable e) {
                        MessageChannelHandler.this.logger.error("failed to handle exception response [{}]", e, handler);
                    }
                }
            });
        }
    }

    protected String handleRequest(Channel channel, Marker marker, StreamInput buffer, long requestId, int messageLengthBytes, Version version) throws IOException {
        buffer = new NamedWriteableAwareStreamInput(buffer, this.transport.namedWriteableRegistry);
        String action = buffer.readString();
        this.transportServiceAdapter.onRequestReceived(requestId, action);
        NettyTransportChannel transportChannel = null;
        try {
            RequestHandlerRegistry reg = this.transportServiceAdapter.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException(action);
            }
            if (reg.canTripCircuitBreaker()) {
                this.transport.inFlightRequestsBreaker().addEstimateBytesAndMaybeBreak(messageLengthBytes, "<transport_request>");
            } else {
                this.transport.inFlightRequestsBreaker().addWithoutBreaking(messageLengthBytes);
            }
            transportChannel = new NettyTransportChannel(this.transport, this.transportServiceAdapter, action, channel, requestId, version, this.profileName, messageLengthBytes);
            Object request = reg.newRequest();
            ((TransportMessage)request).remoteAddress(new InetSocketTransportAddress((InetSocketAddress)channel.getRemoteAddress()));
            ((TransportMessage)request).readFrom(buffer);
            this.validateRequest(marker, buffer, requestId, (TransportRequest)request, action);
            if ("same".equals(reg.getExecutor())) {
                reg.processMessageReceived(request, transportChannel);
            } else {
                this.threadPool.executor(reg.getExecutor()).execute(new RequestHandler(reg, (TransportRequest)request, transportChannel));
            }
        }
        catch (Throwable e) {
            if (transportChannel == null) {
                transportChannel = new NettyTransportChannel(this.transport, this.transportServiceAdapter, action, channel, requestId, version, this.profileName, 0L);
            }
            try {
                transportChannel.sendResponse(e);
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send error message back to client for action [" + action + "]", e, new Object[0]);
                this.logger.warn("Actual Exception", e1, new Object[0]);
            }
        }
        return action;
    }

    protected void validateRequest(Marker marker, StreamInput buffer, long requestId, TransportRequest request, String action) throws IOException {
        marker.validateRequest(buffer, requestId, action);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.transport.exceptionCaught(ctx, e);
    }

    protected static final class Marker {
        private final ChannelBuffer buffer;
        private final int remainingMessageSize;
        private final int expectedReaderIndex;

        public Marker(ChannelBuffer buffer) {
            this.buffer = buffer;
            this.remainingMessageSize = buffer.getInt(buffer.readerIndex() - 4);
            this.expectedReaderIndex = buffer.readerIndex() + this.remainingMessageSize;
        }

        public int messageSizeWithRemainingHeaders() {
            return this.remainingMessageSize;
        }

        public int messageSizeWithAllHeaders() {
            return this.remainingMessageSize + 2 + 4;
        }

        public int messageSize() {
            return this.messageSizeWithAllHeaders() - 19;
        }

        public int expectedReaderIndex() {
            return this.expectedReaderIndex;
        }

        public void validateRequest(StreamInput stream, long requestId, String action) throws IOException {
            int nextByte = stream.read();
            if (nextByte != -1) {
                throw new IllegalStateException("Message not fully read (request) for requestId [" + requestId + "], action [" + action + "], readerIndex [" + this.buffer.readerIndex() + "] vs expected [" + this.expectedReaderIndex + "]; resetting");
            }
            if (this.buffer.readerIndex() < this.expectedReaderIndex) {
                throw new IllegalStateException("Message is fully read (request), yet there are " + (this.expectedReaderIndex - this.buffer.readerIndex()) + " remaining bytes; resetting");
            }
            if (this.buffer.readerIndex() > this.expectedReaderIndex) {
                throw new IllegalStateException("Message read past expected size (request) for requestId [" + requestId + "], action [" + action + "], readerIndex [" + this.buffer.readerIndex() + "] vs expected [" + this.expectedReaderIndex + "]; resetting");
            }
        }

        public void validateResponse(StreamInput stream, long requestId, TransportResponseHandler<?> handler, boolean error) throws IOException {
            int nextByte = stream.read();
            if (nextByte != -1) {
                throw new IllegalStateException("Message not fully read (response) for requestId [" + requestId + "], handler [" + handler + "], error [" + error + "]; resetting");
            }
            if (this.buffer.readerIndex() < this.expectedReaderIndex) {
                throw new IllegalStateException("Message is fully read (response), yet there are " + (this.expectedReaderIndex - this.buffer.readerIndex()) + " remaining bytes; resetting");
            }
            if (this.buffer.readerIndex() > this.expectedReaderIndex) {
                throw new IllegalStateException("Message read past expected size (response) for requestId [" + requestId + "], handler [" + handler + "], error [" + error + "]; resetting");
            }
        }
    }

    class RequestHandler
    extends AbstractRunnable {
        private final RequestHandlerRegistry reg;
        private final TransportRequest request;
        private final NettyTransportChannel transportChannel;

        public RequestHandler(RequestHandlerRegistry reg, TransportRequest request, NettyTransportChannel transportChannel) {
            this.reg = reg;
            this.request = request;
            this.transportChannel = transportChannel;
        }

        @Override
        protected void doRun() throws Exception {
            this.reg.processMessageReceived(this.request, this.transportChannel);
        }

        @Override
        public boolean isForceExecution() {
            return this.reg.isForceExecution();
        }

        @Override
        public void onFailure(Throwable e) {
            if (MessageChannelHandler.this.transport.lifecycleState() == Lifecycle.State.STARTED) {
                try {
                    this.transportChannel.sendResponse(e);
                }
                catch (Throwable e1) {
                    MessageChannelHandler.this.logger.warn("Failed to send error message back to client for action [" + this.reg.getAction() + "]", e1, new Object[0]);
                    MessageChannelHandler.this.logger.warn("Actual Exception", e, new Object[0]);
                }
            }
        }
    }

    class ResponseHandler
    implements Runnable {
        private final TransportResponseHandler handler;
        private final TransportResponse response;

        public ResponseHandler(TransportResponseHandler handler, TransportResponse response) {
            this.handler = handler;
            this.response = response;
        }

        @Override
        public void run() {
            try {
                this.handler.handleResponse(this.response);
            }
            catch (Throwable e) {
                MessageChannelHandler.this.handleException(this.handler, new ResponseHandlerFailureTransportException(e));
            }
        }
    }
}

