/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaInitializer;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.impl.DefaultBeanProperty;
import com.thoughtworks.qdox.model.impl.DefaultJavaTypeVariable;
import com.thoughtworks.qdox.model.impl.JavaClassParent;
import com.thoughtworks.qdox.model.impl.JavaMethodDelegate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaClass
extends AbstractInheritableJavaEntity
implements JavaClass {
    private List<JavaConstructor> constructors = new LinkedList<JavaConstructor>();
    private List<JavaMethod> methods = new LinkedList<JavaMethod>();
    private List<JavaField> fields = new LinkedList<JavaField>();
    private List<JavaClass> classes = new LinkedList<JavaClass>();
    private boolean anInterface;
    private boolean anEnum;
    private boolean anAnnotation;
    private JavaType superClass;
    private List<JavaClass> implementz = new LinkedList<JavaClass>();
    private List<JavaInitializer> initializers = new LinkedList<JavaInitializer>();
    private List<DefaultJavaTypeVariable<JavaClass>> typeParameters = new LinkedList<DefaultJavaTypeVariable<JavaClass>>();
    private JavaPackage javaPackage;

    protected DefaultJavaClass() {
    }

    public DefaultJavaClass(String name) {
        this.setName(name);
    }

    public DefaultJavaClass(JavaSource source) {
        this.setSource(source);
    }

    @Override
    public boolean isInterface() {
        return this.anInterface;
    }

    @Override
    public boolean isPrimitive() {
        String name = this.getName();
        return "void".equals(name) || "boolean".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name);
    }

    @Override
    public boolean isVoid() {
        return "void".equals(this.getName());
    }

    @Override
    public boolean isEnum() {
        return this.anEnum;
    }

    @Override
    public boolean isAnnotation() {
        return this.anAnnotation;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public JavaClass getComponentType() {
        return null;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public JavaType getSuperClass() {
        JavaType result = null;
        JavaClass OBJECT_JAVACLASS = this.getJavaClassLibrary().getJavaClass("java.lang.Object");
        JavaClass ENUM_JAVACLASS = this.getJavaClassLibrary().getJavaClass("java.lang.Enum");
        boolean iAmJavaLangObject = OBJECT_JAVACLASS.equals(this);
        result = this.anEnum ? ENUM_JAVACLASS : (!this.anInterface && !this.anAnnotation && this.superClass == null && !iAmJavaLangObject ? OBJECT_JAVACLASS : this.superClass);
        return result;
    }

    @Override
    public JavaClass getSuperJavaClass() {
        JavaClass result = null;
        JavaType superType = this.getSuperClass();
        if (superType instanceof JavaClass) {
            result = (JavaClass)superType;
        }
        return result;
    }

    @Override
    public List<JavaType> getImplements() {
        return new LinkedList<JavaType>(this.implementz);
    }

    @Override
    public List<JavaClass> getImplementedInterfaces() {
        return new LinkedList<JavaClass>(this.implementz);
    }

    @Override
    public List<JavaClass> getInterfaces() {
        return new LinkedList<JavaClass>(this.implementz);
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeClass(this).toString();
    }

    public void setInterface(boolean anInterface) {
        this.anInterface = anInterface;
    }

    public void setEnum(boolean anEnum) {
        this.anEnum = anEnum;
    }

    public void setAnnotation(boolean anAnnotation) {
        this.anAnnotation = anAnnotation;
    }

    public void addConstructor(JavaConstructor constructor) {
        this.constructors.add(constructor);
    }

    public void addMethod(JavaMethod meth) {
        this.methods.add(meth);
    }

    public void setSuperClass(JavaType type) {
        if (this.anEnum) {
            throw new IllegalArgumentException("enums cannot extend other classes");
        }
        this.superClass = type;
    }

    public void setImplementz(List<JavaClass> implementz) {
        this.implementz = implementz;
    }

    public List<DefaultJavaTypeVariable<JavaClass>> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<DefaultJavaTypeVariable<JavaClass>> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public void addField(JavaField javaField) {
        this.fields.add(javaField);
    }

    public void setJavaPackage(JavaPackage javaPackage) {
        this.javaPackage = javaPackage;
    }

    @Override
    public JavaSource getParentSource() {
        return this.getParentClass() != null ? this.getParentClass().getParentSource() : super.getSource();
    }

    @Override
    public JavaSource getSource() {
        return this.getParentSource();
    }

    @Override
    public JavaPackage getPackage() {
        return this.getParentSource() != null ? this.getParentSource().getPackage() : this.javaPackage;
    }

    @Override
    public JavaClassParent getParent() {
        JavaClassParent result = this.getParentClass();
        if (result == null) {
            result = this.getParentSource();
        }
        return result;
    }

    @Override
    public String getPackageName() {
        JavaPackage pckg = this.getPackage();
        return pckg != null && pckg.getName() != null ? pckg.getName() : "";
    }

    @Override
    public String getFullyQualifiedName() {
        return (this.getParentClass() != null ? this.getParentClass().getClassNamePrefix() : (this.getPackage() != null ? this.getPackage().getName() + "." : "")) + this.getName();
    }

    @Override
    public String getGenericFullyQualifiedName() {
        return this.getFullyQualifiedName();
    }

    @Override
    public String getCanonicalName() {
        return this.getFullyQualifiedName().replace('$', '.');
    }

    @Override
    public String getGenericCanonicalName() {
        return this.getCanonicalName();
    }

    @Override
    public String getValue() {
        return this.getCanonicalName().substring(this.getSource().getClassNamePrefix().length());
    }

    @Override
    public String getGenericValue() {
        return this.getValue();
    }

    @Override
    public boolean isInner() {
        return this.getParentClass() != null;
    }

    @Override
    public String resolveType(String typeName) {
        JavaClass resolvedClass = this.getNestedClassByName(typeName);
        String result = resolvedClass != null ? resolvedClass.getFullyQualifiedName() : this.getParent().resolveType(typeName);
        return result;
    }

    @Override
    public String resolveCanonicalName(String name) {
        for (JavaClass innerClass : this.getNestedClasses()) {
            if (!innerClass.getName().equals(name)) continue;
            return innerClass.getName();
        }
        return this.getParent().resolveCanonicalName(name);
    }

    @Override
    public String resolveFullyQualifiedName(String name) {
        for (JavaClass innerClass : this.getNestedClasses()) {
            if (!innerClass.getName().equals(name)) continue;
            return innerClass.getFullyQualifiedName();
        }
        return this.getParent().resolveFullyQualifiedName(name);
    }

    @Override
    public String getClassNamePrefix() {
        return this.getFullyQualifiedName() + "$";
    }

    @Override
    public JavaType asType() {
        return this;
    }

    @Override
    public List<JavaInitializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public List<JavaConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public JavaConstructor getConstructor(List<JavaType> parameterTypes) {
        return this.getConstructor(parameterTypes, false);
    }

    @Override
    public JavaConstructor getConstructor(List<JavaType> parameterTypes, boolean varArgs) {
        for (JavaConstructor constructor : this.getConstructors()) {
            if (!constructor.signatureMatches(parameterTypes, varArgs)) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    @Override
    public List<JavaMethod> getMethods(boolean superclasses) {
        if (superclasses) {
            return new LinkedList<JavaMethod>(DefaultJavaClass.getMethodsFromSuperclassAndInterfaces(this, this).values());
        }
        return this.getMethods();
    }

    private static Map<String, JavaMethod> getMethodsFromSuperclassAndInterfaces(JavaClass rootClass, JavaClass callingClazz) {
        LinkedHashMap<String, JavaMethod> result = new LinkedHashMap<String, JavaMethod>();
        for (JavaMethod method : callingClazz.getMethods()) {
            if (method.isPrivate()) continue;
            String signature = method.getDeclarationSignature(false);
            result.put(signature, method);
        }
        JavaClass superclass = callingClazz.getSuperJavaClass();
        if (superclass != null) {
            Map<String, JavaMethod> superClassMethods = DefaultJavaClass.getMethodsFromSuperclassAndInterfaces(callingClazz, superclass);
            for (Map.Entry<String, JavaMethod> methodEntry : superClassMethods.entrySet()) {
                if (result.containsKey(methodEntry.getKey())) continue;
                JavaMethod method = superclass.equals(rootClass) ? methodEntry.getValue() : new JavaMethodDelegate(callingClazz, methodEntry.getValue());
                result.put(methodEntry.getKey(), method);
            }
        }
        for (JavaClass clazz : callingClazz.getImplementedInterfaces()) {
            Map<String, JavaMethod> interfaceMethods = DefaultJavaClass.getMethodsFromSuperclassAndInterfaces(callingClazz, clazz);
            for (Map.Entry<String, JavaMethod> methodEntry : interfaceMethods.entrySet()) {
                if (result.containsKey(methodEntry.getKey())) continue;
                JavaMethod method = clazz.equals(rootClass) ? methodEntry.getValue() : new JavaMethodDelegate(callingClazz, methodEntry.getValue());
                result.put(methodEntry.getKey(), method);
            }
        }
        return result;
    }

    @Override
    public JavaMethod getMethodBySignature(String name, List<JavaType> parameterTypes) {
        return this.getMethod(name, parameterTypes, false);
    }

    @Override
    public JavaMethod getMethod(String name, List<JavaType> parameterTypes, boolean varArgs) {
        for (JavaMethod method : this.getMethods()) {
            if (!method.signatureMatches(name, parameterTypes, varArgs)) continue;
            return method;
        }
        return null;
    }

    @Override
    public JavaMethod getMethodBySignature(String name, List<JavaType> parameterTypes, boolean superclasses) {
        return this.getMethodBySignature(name, parameterTypes, superclasses, false);
    }

    @Override
    public JavaMethod getMethodBySignature(String name, List<JavaType> parameterTypes, boolean superclasses, boolean varArg) {
        List<JavaMethod> result = this.getMethodsBySignature(name, parameterTypes, superclasses, varArg);
        return result.size() > 0 ? result.get(0) : null;
    }

    @Override
    public List<JavaMethod> getMethodsBySignature(String name, List<JavaType> parameterTypes, boolean superclasses) {
        return this.getMethodsBySignature(name, parameterTypes, superclasses, false);
    }

    @Override
    public List<JavaMethod> getMethodsBySignature(String name, List<JavaType> parameterTypes, boolean superclasses, boolean varArg) {
        LinkedList<JavaMethod> result = new LinkedList<JavaMethod>();
        JavaMethod methodInThisClass = this.getMethod(name, parameterTypes, varArg);
        if (methodInThisClass != null) {
            result.add(methodInThisClass);
        }
        if (superclasses) {
            JavaMethod method;
            JavaClass superclass = this.getSuperJavaClass();
            if (superclass != null && (method = superclass.getMethodBySignature(name, parameterTypes, true, varArg)) != null && !method.isPrivate()) {
                result.add(new JavaMethodDelegate(this, method));
            }
            for (JavaClass clazz : this.getImplementedInterfaces()) {
                JavaMethod method2 = clazz.getMethodBySignature(name, parameterTypes, true, varArg);
                if (method2 == null) continue;
                result.add(new JavaMethodDelegate(this, method2));
            }
        }
        return result;
    }

    @Override
    public List<JavaField> getFields() {
        return this.fields;
    }

    @Override
    public JavaField getFieldByName(String name) {
        for (JavaField field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<JavaField> getEnumConstants() {
        LinkedList<JavaField> result;
        LinkedList<JavaField> linkedList = result = this.isEnum() ? new LinkedList<JavaField>() : null;
        if (this.isEnum()) {
            for (JavaField field : this.getFields()) {
                if (!field.isEnumConstant()) continue;
                result.add(field);
            }
        }
        return result;
    }

    @Override
    public JavaField getEnumConstantByName(String name) {
        JavaField field = this.getFieldByName(name);
        return field.isEnumConstant() ? field : null;
    }

    public void addInitializer(JavaInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addClass(JavaClass cls) {
        this.classes.add(cls);
    }

    @Override
    public List<JavaClass> getClasses() {
        return this.getNestedClasses();
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.classes;
    }

    @Override
    public JavaClass getInnerClassByName(String name) {
        return this.getNestedClassByName(name);
    }

    @Override
    public List<JavaClass> getInnerClasses() {
        return this.getNestedClasses();
    }

    @Override
    public JavaClass getNestedClassByName(String name) {
        int separatorIndex = name.indexOf(46);
        String directInnerClassName = separatorIndex > 0 ? name.substring(0, separatorIndex) : name;
        for (JavaClass jClass : this.getNestedClasses()) {
            if (!jClass.getName().equals(directInnerClassName)) continue;
            if (separatorIndex > 0) {
                return jClass.getNestedClassByName(name.substring(separatorIndex + 1));
            }
            return jClass;
        }
        return null;
    }

    @Override
    public boolean isA(String fullClassName) {
        if (fullClassName == null) {
            return false;
        }
        if (fullClassName.equals(this.getFullyQualifiedName())) {
            return true;
        }
        for (JavaClass implementz : this.getImplementedInterfaces()) {
            if (!implementz.isA(fullClassName)) continue;
            return true;
        }
        JavaClass superClass = this.getSuperJavaClass();
        if (superClass != null) {
            return superClass.isA(fullClassName);
        }
        return false;
    }

    @Override
    public boolean isA(JavaClass javaClass) {
        if (this == javaClass) {
            return true;
        }
        if (this.equals(javaClass)) {
            return true;
        }
        if (javaClass != null) {
            for (JavaClass intrfc : this.getImplementedInterfaces()) {
                if (!intrfc.isA(javaClass)) continue;
                return true;
            }
            JavaClass superClass = this.getSuperJavaClass();
            if (superClass != null) {
                return superClass.isA(javaClass);
            }
        }
        return false;
    }

    @Override
    public List<BeanProperty> getBeanProperties() {
        return this.getBeanProperties(false);
    }

    @Override
    public List<BeanProperty> getBeanProperties(boolean superclasses) {
        Map<String, BeanProperty> beanPropertyMap = this.getBeanPropertyMap(superclasses);
        Collection<BeanProperty> beanPropertyCollection = beanPropertyMap.values();
        return new LinkedList<BeanProperty>(beanPropertyCollection);
    }

    private Map<String, BeanProperty> getBeanPropertyMap(boolean superclasses) {
        List<JavaMethod> superMethods = this.getMethods(superclasses);
        LinkedHashMap<String, DefaultBeanProperty> beanPropertyMap = new LinkedHashMap<String, DefaultBeanProperty>();
        for (JavaMethod superMethod : superMethods) {
            DefaultBeanProperty beanProperty;
            String propertyName;
            if (superMethod.isPropertyAccessor()) {
                propertyName = superMethod.getPropertyName();
                beanProperty = this.getOrCreateProperty(beanPropertyMap, propertyName);
                beanProperty.setAccessor(superMethod);
                beanProperty.setType(superMethod.getPropertyType());
                continue;
            }
            if (!superMethod.isPropertyMutator()) continue;
            propertyName = superMethod.getPropertyName();
            beanProperty = this.getOrCreateProperty(beanPropertyMap, propertyName);
            beanProperty.setMutator(superMethod);
            beanProperty.setType(superMethod.getPropertyType());
        }
        return new LinkedHashMap<String, BeanProperty>(beanPropertyMap);
    }

    private DefaultBeanProperty getOrCreateProperty(Map<String, DefaultBeanProperty> beanPropertyMap, String propertyName) {
        DefaultBeanProperty result = beanPropertyMap.get(propertyName);
        if (result == null) {
            result = new DefaultBeanProperty(propertyName);
            beanPropertyMap.put(propertyName, result);
        }
        return result;
    }

    @Override
    public BeanProperty getBeanProperty(String propertyName) {
        return this.getBeanProperty(propertyName, false);
    }

    @Override
    public BeanProperty getBeanProperty(String propertyName, boolean superclasses) {
        return this.getBeanPropertyMap(superclasses).get(propertyName);
    }

    @Override
    public List<JavaClass> getDerivedClasses() {
        LinkedList<JavaClass> result = new LinkedList<JavaClass>();
        for (JavaClass clazz : this.getSource().getJavaClassLibrary().getJavaClasses()) {
            if (!clazz.isA(this) || clazz == this) continue;
            result.add(clazz);
        }
        return result;
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.getParentClass();
    }

    @Override
    public List<DocletTag> getTagsByName(String name, boolean superclasses) {
        return this.getTagsRecursive(this, name, superclasses);
    }

    private List<DocletTag> getTagsRecursive(JavaClass javaClass, String name, boolean superclasses) {
        LinkedHashSet<DocletTag> result = new LinkedHashSet<DocletTag>();
        result.addAll(javaClass.getTagsByName(name));
        if (superclasses) {
            JavaClass superclass = javaClass.getSuperJavaClass();
            if (superclass != null) {
                result.addAll(this.getTagsRecursive(superclass, name, superclasses));
            }
            for (JavaClass intrfc : javaClass.getImplementedInterfaces()) {
                if (intrfc == null) continue;
                result.addAll(this.getTagsRecursive(intrfc, name, superclasses));
            }
        }
        return new LinkedList<DocletTag>(result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isPrimitive()) {
            sb.append(this.getName());
        } else {
            sb.append(this.isInterface() ? "interface" : "class");
            sb.append(" ");
            sb.append(this.getFullyQualifiedName());
        }
        return sb.toString();
    }

    @Override
    public String toGenericString() {
        return this.toString();
    }

    public int hashCode() {
        return 2 + this.getFullyQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaClass)) {
            return false;
        }
        JavaClass clazz = (JavaClass)obj;
        return this.getFullyQualifiedName().equals(clazz.getFullyQualifiedName());
    }

    @Override
    public ClassLibrary getJavaClassLibrary() {
        return this.getSource().getJavaClassLibrary();
    }
}

