/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluentImpl;
import java.util.Objects;

public class ResourcePolicyRuleBuilder
extends ResourcePolicyRuleFluentImpl<ResourcePolicyRuleBuilder>
implements VisitableBuilder<ResourcePolicyRule, ResourcePolicyRuleBuilder> {
    ResourcePolicyRuleFluent<?> fluent;
    Boolean validationEnabled;

    public ResourcePolicyRuleBuilder() {
        this(false);
    }

    public ResourcePolicyRuleBuilder(Boolean validationEnabled) {
        this(new ResourcePolicyRule(), validationEnabled);
    }

    public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourcePolicyRule(), validationEnabled);
    }

    public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent, ResourcePolicyRule instance) {
        this(fluent, instance, false);
    }

    public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent, ResourcePolicyRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withClusterScope(instance.getClusterScope());
        fluent.withNamespaces(instance.getNamespaces());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ResourcePolicyRuleBuilder(ResourcePolicyRule instance) {
        this(instance, (Boolean)false);
    }

    public ResourcePolicyRuleBuilder(ResourcePolicyRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withClusterScope(instance.getClusterScope());
        this.withNamespaces(instance.getNamespaces());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourcePolicyRule build() {
        ResourcePolicyRule buildable = new ResourcePolicyRule(this.fluent.getApiGroups(), this.fluent.getClusterScope(), this.fluent.getNamespaces(), this.fluent.getResources(), this.fluent.getVerbs());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourcePolicyRuleBuilder that = (ResourcePolicyRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

