/*
 * Decompiled with CFR 0.152.
 */
package jinjava.de.odysseus.el.tree;

import jinjava.de.odysseus.el.tree.Tree;
import jinjava.de.odysseus.el.tree.TreeBuilder;
import jinjava.de.odysseus.el.tree.TreeBuilderException;
import jinjava.de.odysseus.el.tree.TreeCache;

public class TreeStore {
    private final TreeCache cache;
    private final TreeBuilder builder;

    public TreeStore(TreeBuilder builder, TreeCache cache) {
        this.builder = builder;
        this.cache = cache;
    }

    public TreeBuilder getBuilder() {
        return this.builder;
    }

    public Tree get(String expression) throws TreeBuilderException {
        if (this.cache == null) {
            return this.builder.build(expression);
        }
        Tree tree = this.cache.get(expression);
        if (tree == null) {
            tree = this.builder.build(expression);
            this.cache.put(expression, tree);
        }
        return tree;
    }
}

