/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.utils.event.ListenerService;
import io.atomix.utils.net.Address;
import java.util.Set;
import java.util.stream.Collectors;

public interface ClusterMembershipService
extends ListenerService<ClusterMembershipEvent, ClusterMembershipEventListener> {
    public Member getLocalMember();

    public Set<Member> getMembers();

    default public Set<Member> getReachableMembers() {
        return this.getMembers().stream().filter(member -> member.isReachable()).collect(Collectors.toSet());
    }

    default public Member getMember(String memberId) {
        return this.getMember(MemberId.from(memberId));
    }

    public Member getMember(MemberId var1);

    default public Member getMember(Address address) {
        return this.getMembers().stream().filter(member -> member.address().equals((Object)address)).findFirst().orElse(null);
    }
}

