/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import java.util.Collection;
import java.util.Objects;
import jinjava.de.odysseus.el.misc.TypeConverter;
import jinjava.de.odysseus.el.tree.impl.Parser;
import jinjava.de.odysseus.el.tree.impl.Scanner;
import jinjava.de.odysseus.el.tree.impl.ast.AstBinary;
import jinjava.de.odysseus.el.tree.impl.ast.AstNode;
import jinjava.javax.el.ELException;
import org.apache.commons.lang3.StringUtils;

public class CollectionMembershipOperator
extends AstBinary.SimpleOperator {
    public static final CollectionMembershipOperator OP = new CollectionMembershipOperator();
    public static final Scanner.ExtensionToken TOKEN = new Scanner.ExtensionToken("in");
    public static final Parser.ExtensionHandler HANDLER = new Parser.ExtensionHandler(Parser.ExtensionPoint.CMP){

        @Override
        public AstNode createAstNode(AstNode ... children) {
            return new AstBinary(children[0], children[1], OP);
        }
    };

    @Override
    public Object apply(TypeConverter converter, Object o1, Object o2) {
        if (o2 == null) {
            return Boolean.FALSE;
        }
        if (CharSequence.class.isAssignableFrom(o2.getClass())) {
            return StringUtils.contains((CharSequence)((CharSequence)o2), (CharSequence)Objects.toString(o1, ""));
        }
        if (Collection.class.isAssignableFrom(o2.getClass())) {
            Collection collection = (Collection)o2;
            for (Object value : collection) {
                if (value == null) {
                    if (o1 != null) continue;
                    return Boolean.TRUE;
                }
                try {
                    return collection.contains(converter.convert(o1, value.getClass()));
                }
                catch (ELException e) {
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.FALSE;
    }
}

