/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Outputs the tag contents if the given variable has changed since a prior invocation of this tag", hidden=true, snippets={@JinjavaSnippet(code="{% ifchanged var %}\nVariable to test if changed\n{% endifchanged %}")})
public class IfchangedTag
implements Tag {
    public static final String TAG_NAME = "ifchanged";
    private static final long serialVersionUID = 3567908136629704724L;
    private static final String LASTKEY = "'IF\"CHG";

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (StringUtils.isBlank((CharSequence)tagNode.getHelpers())) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'ifchanged' expects a variable parameter", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        boolean isChanged = true;
        String var = tagNode.getHelpers().trim();
        Object older = interpreter.getContext().get(LASTKEY + var);
        Object test = interpreter.retraceVariable(var, tagNode.getLineNumber(), tagNode.getStartPosition());
        if (older == null) {
            if (test == null) {
                isChanged = false;
            }
        } else if (older.equals(test)) {
            isChanged = false;
        }
        interpreter.getContext().put(LASTKEY + var, test);
        if (isChanged) {
            StringBuilder sb = new StringBuilder();
            for (Node node : tagNode.getChildren()) {
                sb.append(node.render(interpreter));
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

