// Implementation file for parser generated by fsyacc
module internal FSharp.Compiler.Parser
#nowarn "64";; // turn off warnings that type variables used in production annotations are instantiated to concrete type
open FSharp.Compiler
open FSharp.Compiler.Syntax
open FSharp.Compiler.Text
open Internal.Utilities.Text.Lexing
open Internal.Utilities.Text.Parsing.ParseHelpers
//# 3 "src/Compiler/pars.fsy"


#nowarn "1182"  // generated code has lots of unused "parseState"

open System

open Internal.Utilities
open Internal.Utilities.Text.Parsing
open Internal.Utilities.Library
open Internal.Utilities.Library.Extras

open FSharp.Compiler
open FSharp.Compiler.AbstractIL
open FSharp.Compiler.AbstractIL
open FSharp.Compiler.DiagnosticsLogger
open FSharp.Compiler.Features
open FSharp.Compiler.ParseHelpers
open FSharp.Compiler.Syntax
open FSharp.Compiler.SyntaxTrivia
open FSharp.Compiler.Syntax.PrettyNaming
open FSharp.Compiler.SyntaxTreeOps
open FSharp.Compiler.Text.Position
open FSharp.Compiler.Text.Range
open FSharp.Compiler.Xml

// This function is called by the generated parser code. Returning initiates error recovery
// It must be called precisely "parse_error_rich"
let parse_error_rich = Some(fun (ctxt: ParseErrorContext<_>) ->
    errorR(SyntaxError(box ctxt, ctxt.ParseState.LexBuffer.LexemeRange)))


//# 41 "pars.fs"
// This type is the type of tokens accepted by the parser
type token = 
  | HASH_IF of (range * string * ParseHelpers.LexerContinuation)
  | HASH_ELSE of (range * string * ParseHelpers.LexerContinuation)
  | HASH_ENDIF of (range * string * ParseHelpers.LexerContinuation)
  | COMMENT of (ParseHelpers.LexerContinuation)
  | WHITESPACE of (ParseHelpers.LexerContinuation)
  | HASH_LINE of (ParseHelpers.LexerContinuation)
  | HASH_LIGHT of (ParseHelpers.LexerContinuation)
  | INACTIVECODE of (ParseHelpers.LexerContinuation)
  | LINE_COMMENT of (ParseHelpers.LexerContinuation)
  | STRING_TEXT of (ParseHelpers.LexerContinuation)
  | EOF of (ParseHelpers.LexerContinuation)
  | LEX_FAILURE of (string)
  | ODUMMY of (token)
  | FIXED
  | OINTERFACE_MEMBER
  | OBLOCKEND_COMING_SOON
  | OBLOCKEND_IS_HERE
  | OBLOCKEND of (range)
  | ORIGHT_BLOCK_END of (range)
  | ODECLEND of (range)
  | OEND
  | OBLOCKSEP
  | OBLOCKBEGIN
  | ORESET
  | OFUN
  | OFUNCTION
  | OWITH
  | OELSE
  | OTHEN
  | ODO_BANG
  | ODO
  | OAND_BANG of (bool)
  | OBINDER of (string)
  | OLET of (bool)
  | HIGH_PRECEDENCE_TYAPP
  | HIGH_PRECEDENCE_PAREN_APP
  | HIGH_PRECEDENCE_BRACK_APP
  | TYPE_COMING_SOON
  | TYPE_IS_HERE
  | MODULE_COMING_SOON
  | MODULE_IS_HERE
  | EXTERN
  | VOID
  | PUBLIC
  | PRIVATE
  | INTERNAL
  | GLOBAL
  | STATIC
  | MEMBER
  | CLASS
  | ABSTRACT
  | OVERRIDE
  | DEFAULT
  | CONSTRUCTOR
  | INHERIT
  | GREATER_RBRACK
  | STRUCT
  | SIG
  | BAR
  | RBRACK
  | RBRACE_COMING_SOON
  | RBRACE_IS_HERE
  | MINUS
  | DOLLAR
  | BAR_RBRACK
  | BAR_RBRACE
  | UNDERSCORE
  | SEMICOLON_SEMICOLON
  | LARROW
  | EQUALS
  | LBRACK
  | LBRACK_BAR
  | LBRACE_BAR
  | LBRACK_LESS
  | QMARK
  | QMARK_QMARK
  | DOT
  | COLON
  | COLON_COLON
  | COLON_GREATER
  | COLON_QMARK_GREATER
  | COLON_QMARK
  | COLON_EQUALS
  | SEMICOLON
  | WHEN
  | WHILE
  | WHILE_BANG
  | WITH
  | HASH
  | AMP
  | AMP_AMP
  | QUOTE
  | LPAREN
  | RPAREN
  | RPAREN_COMING_SOON
  | RPAREN_IS_HERE
  | STAR
  | COMMA
  | RARROW
  | GREATER_BAR_RBRACK
  | LPAREN_STAR_RPAREN
  | OPEN
  | OR
  | REC
  | THEN
  | TO
  | TRUE
  | TRY
  | TYPE
  | VAL
  | INLINE
  | INTERFACE
  | INSTANCE
  | CONST
  | LAZY
  | OLAZY
  | MATCH
  | MATCH_BANG
  | MUTABLE
  | NEW
  | OF
  | EXCEPTION
  | FALSE
  | FOR
  | FUN
  | FUNCTION
  | IF
  | IN
  | JOIN_IN
  | FINALLY
  | DO_BANG
  | AND
  | AS
  | ASSERT
  | OASSERT
  | ASR
  | BEGIN
  | DO
  | DONE
  | DOWNTO
  | ELSE
  | ELIF
  | END
  | DOT_DOT
  | DOT_DOT_HAT
  | BAR_BAR
  | UPCAST
  | DOWNCAST
  | NULL
  | RESERVED
  | MODULE
  | NAMESPACE
  | DELEGATE
  | CONSTRAINT
  | BASE
  | LQUOTE of (string * bool)
  | RQUOTE of (string * bool)
  | RQUOTE_DOT of (string * bool)
  | PERCENT_OP of (string)
  | BINDER of (string)
  | LESS of (bool)
  | GREATER of (bool)
  | LET of (bool)
  | YIELD of (bool)
  | YIELD_BANG of (bool)
  | AND_BANG of (bool)
  | BIGNUM of ((string * string))
  | DECIMAL of (System.Decimal)
  | CHAR of (char)
  | IEEE64 of (double)
  | IEEE32 of (single)
  | UNATIVEINT of (uint64)
  | UINT64 of (uint64)
  | UINT32 of (uint32)
  | UINT16 of (uint16)
  | UINT8 of (byte)
  | NATIVEINT of (int64 * bool)
  | INT64 of (int64 * bool)
  | INT32 of (int32 * bool)
  | INT32_DOT_DOT of (int32 * bool)
  | INT16 of (int16 * bool)
  | INT8 of (sbyte * bool)
  | FUNKY_OPERATOR_NAME of (string)
  | ADJACENT_PREFIX_OP of (string)
  | PLUS_MINUS_OP of (string)
  | INFIX_AMP_OP of (string)
  | INFIX_STAR_DIV_MOD_OP of (string)
  | PREFIX_OP of (string)
  | INFIX_BAR_OP of (string)
  | INFIX_AT_HAT_OP of (string)
  | INFIX_COMPARE_OP of (string)
  | INFIX_STAR_STAR_OP of (string)
  | HASH_IDENT of (string)
  | IDENT of (string)
  | KEYWORD_STRING of (string * string)
  | LBRACE of (ParseHelpers.LexerContinuation)
  | RBRACE of (ParseHelpers.LexerContinuation)
  | INTERP_STRING_END of (string * ParseHelpers.LexerContinuation)
  | INTERP_STRING_PART of (string * ParseHelpers.LexerContinuation)
  | INTERP_STRING_BEGIN_PART of (string * SynStringKind * ParseHelpers.LexerContinuation)
  | INTERP_STRING_BEGIN_END of (string * SynStringKind * ParseHelpers.LexerContinuation)
  | STRING of (string * SynStringKind * ParseHelpers.LexerContinuation)
  | BYTEARRAY of (byte[] * SynByteStringKind * ParseHelpers.LexerContinuation)
// This type is used to give symbolic names to token indexes, useful for error messages
type tokenId = 
    | TOKEN_HASH_IF
    | TOKEN_HASH_ELSE
    | TOKEN_HASH_ENDIF
    | TOKEN_COMMENT
    | TOKEN_WHITESPACE
    | TOKEN_HASH_LINE
    | TOKEN_HASH_LIGHT
    | TOKEN_INACTIVECODE
    | TOKEN_LINE_COMMENT
    | TOKEN_STRING_TEXT
    | TOKEN_EOF
    | TOKEN_LEX_FAILURE
    | TOKEN_ODUMMY
    | TOKEN_FIXED
    | TOKEN_OINTERFACE_MEMBER
    | TOKEN_OBLOCKEND_COMING_SOON
    | TOKEN_OBLOCKEND_IS_HERE
    | TOKEN_OBLOCKEND
    | TOKEN_ORIGHT_BLOCK_END
    | TOKEN_ODECLEND
    | TOKEN_OEND
    | TOKEN_OBLOCKSEP
    | TOKEN_OBLOCKBEGIN
    | TOKEN_ORESET
    | TOKEN_OFUN
    | TOKEN_OFUNCTION
    | TOKEN_OWITH
    | TOKEN_OELSE
    | TOKEN_OTHEN
    | TOKEN_ODO_BANG
    | TOKEN_ODO
    | TOKEN_OAND_BANG
    | TOKEN_OBINDER
    | TOKEN_OLET
    | TOKEN_HIGH_PRECEDENCE_TYAPP
    | TOKEN_HIGH_PRECEDENCE_PAREN_APP
    | TOKEN_HIGH_PRECEDENCE_BRACK_APP
    | TOKEN_TYPE_COMING_SOON
    | TOKEN_TYPE_IS_HERE
    | TOKEN_MODULE_COMING_SOON
    | TOKEN_MODULE_IS_HERE
    | TOKEN_EXTERN
    | TOKEN_VOID
    | TOKEN_PUBLIC
    | TOKEN_PRIVATE
    | TOKEN_INTERNAL
    | TOKEN_GLOBAL
    | TOKEN_STATIC
    | TOKEN_MEMBER
    | TOKEN_CLASS
    | TOKEN_ABSTRACT
    | TOKEN_OVERRIDE
    | TOKEN_DEFAULT
    | TOKEN_CONSTRUCTOR
    | TOKEN_INHERIT
    | TOKEN_GREATER_RBRACK
    | TOKEN_STRUCT
    | TOKEN_SIG
    | TOKEN_BAR
    | TOKEN_RBRACK
    | TOKEN_RBRACE_COMING_SOON
    | TOKEN_RBRACE_IS_HERE
    | TOKEN_MINUS
    | TOKEN_DOLLAR
    | TOKEN_BAR_RBRACK
    | TOKEN_BAR_RBRACE
    | TOKEN_UNDERSCORE
    | TOKEN_SEMICOLON_SEMICOLON
    | TOKEN_LARROW
    | TOKEN_EQUALS
    | TOKEN_LBRACK
    | TOKEN_LBRACK_BAR
    | TOKEN_LBRACE_BAR
    | TOKEN_LBRACK_LESS
    | TOKEN_QMARK
    | TOKEN_QMARK_QMARK
    | TOKEN_DOT
    | TOKEN_COLON
    | TOKEN_COLON_COLON
    | TOKEN_COLON_GREATER
    | TOKEN_COLON_QMARK_GREATER
    | TOKEN_COLON_QMARK
    | TOKEN_COLON_EQUALS
    | TOKEN_SEMICOLON
    | TOKEN_WHEN
    | TOKEN_WHILE
    | TOKEN_WHILE_BANG
    | TOKEN_WITH
    | TOKEN_HASH
    | TOKEN_AMP
    | TOKEN_AMP_AMP
    | TOKEN_QUOTE
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_RPAREN_COMING_SOON
    | TOKEN_RPAREN_IS_HERE
    | TOKEN_STAR
    | TOKEN_COMMA
    | TOKEN_RARROW
    | TOKEN_GREATER_BAR_RBRACK
    | TOKEN_LPAREN_STAR_RPAREN
    | TOKEN_OPEN
    | TOKEN_OR
    | TOKEN_REC
    | TOKEN_THEN
    | TOKEN_TO
    | TOKEN_TRUE
    | TOKEN_TRY
    | TOKEN_TYPE
    | TOKEN_VAL
    | TOKEN_INLINE
    | TOKEN_INTERFACE
    | TOKEN_INSTANCE
    | TOKEN_CONST
    | TOKEN_LAZY
    | TOKEN_OLAZY
    | TOKEN_MATCH
    | TOKEN_MATCH_BANG
    | TOKEN_MUTABLE
    | TOKEN_NEW
    | TOKEN_OF
    | TOKEN_EXCEPTION
    | TOKEN_FALSE
    | TOKEN_FOR
    | TOKEN_FUN
    | TOKEN_FUNCTION
    | TOKEN_IF
    | TOKEN_IN
    | TOKEN_JOIN_IN
    | TOKEN_FINALLY
    | TOKEN_DO_BANG
    | TOKEN_AND
    | TOKEN_AS
    | TOKEN_ASSERT
    | TOKEN_OASSERT
    | TOKEN_ASR
    | TOKEN_BEGIN
    | TOKEN_DO
    | TOKEN_DONE
    | TOKEN_DOWNTO
    | TOKEN_ELSE
    | TOKEN_ELIF
    | TOKEN_END
    | TOKEN_DOT_DOT
    | TOKEN_DOT_DOT_HAT
    | TOKEN_BAR_BAR
    | TOKEN_UPCAST
    | TOKEN_DOWNCAST
    | TOKEN_NULL
    | TOKEN_RESERVED
    | TOKEN_MODULE
    | TOKEN_NAMESPACE
    | TOKEN_DELEGATE
    | TOKEN_CONSTRAINT
    | TOKEN_BASE
    | TOKEN_LQUOTE
    | TOKEN_RQUOTE
    | TOKEN_RQUOTE_DOT
    | TOKEN_PERCENT_OP
    | TOKEN_BINDER
    | TOKEN_LESS
    | TOKEN_GREATER
    | TOKEN_LET
    | TOKEN_YIELD
    | TOKEN_YIELD_BANG
    | TOKEN_AND_BANG
    | TOKEN_BIGNUM
    | TOKEN_DECIMAL
    | TOKEN_CHAR
    | TOKEN_IEEE64
    | TOKEN_IEEE32
    | TOKEN_UNATIVEINT
    | TOKEN_UINT64
    | TOKEN_UINT32
    | TOKEN_UINT16
    | TOKEN_UINT8
    | TOKEN_NATIVEINT
    | TOKEN_INT64
    | TOKEN_INT32
    | TOKEN_INT32_DOT_DOT
    | TOKEN_INT16
    | TOKEN_INT8
    | TOKEN_FUNKY_OPERATOR_NAME
    | TOKEN_ADJACENT_PREFIX_OP
    | TOKEN_PLUS_MINUS_OP
    | TOKEN_INFIX_AMP_OP
    | TOKEN_INFIX_STAR_DIV_MOD_OP
    | TOKEN_PREFIX_OP
    | TOKEN_INFIX_BAR_OP
    | TOKEN_INFIX_AT_HAT_OP
    | TOKEN_INFIX_COMPARE_OP
    | TOKEN_INFIX_STAR_STAR_OP
    | TOKEN_HASH_IDENT
    | TOKEN_IDENT
    | TOKEN_KEYWORD_STRING
    | TOKEN_LBRACE
    | TOKEN_RBRACE
    | TOKEN_INTERP_STRING_END
    | TOKEN_INTERP_STRING_PART
    | TOKEN_INTERP_STRING_BEGIN_PART
    | TOKEN_INTERP_STRING_BEGIN_END
    | TOKEN_STRING
    | TOKEN_BYTEARRAY
    | TOKEN_end_of_input
    | TOKEN_error
// This type is used to give symbolic names to token indexes, useful for error messages
type nonTerminalId = 
    | NONTERM__startsignatureFile
    | NONTERM__startimplementationFile
    | NONTERM__startinteraction
    | NONTERM__starttypedSequentialExprEOF
    | NONTERM__starttypEOF
    | NONTERM_interaction
    | NONTERM_interactiveTerminator
    | NONTERM_interactiveItemsTerminator
    | NONTERM_interactiveDefns
    | NONTERM_interactiveExpr
    | NONTERM_interactiveHash
    | NONTERM_interactiveSeparators
    | NONTERM_interactiveSeparator
    | NONTERM_hashDirective
    | NONTERM_hashDirectiveArgs
    | NONTERM_hashDirectiveArg
    | NONTERM_signatureFile
    | NONTERM_moduleIntro
    | NONTERM_namespaceIntro
    | NONTERM_fileNamespaceSpecs
    | NONTERM_fileNamespaceSpecList
    | NONTERM_fileNamespaceSpec
    | NONTERM_fileModuleSpec
    | NONTERM_moduleSpfnsPossiblyEmptyBlock
    | NONTERM_moduleSpfnsPossiblyEmpty
    | NONTERM_moduleSpfns
    | NONTERM_moduleSpfn
    | NONTERM_valSpfn
    | NONTERM_optLiteralValueSpfn
    | NONTERM_moduleSpecBlock
    | NONTERM_tyconSpfnList
    | NONTERM_tyconSpfn
    | NONTERM_tyconSpfnRhsBlock
    | NONTERM_tyconSpfnRhs
    | NONTERM_tyconClassSpfn
    | NONTERM_classSpfnBlockKindUnspecified
    | NONTERM_classSpfnBlock
    | NONTERM_classSpfnMembers
    | NONTERM_classSpfnMembersAtLeastOne
    | NONTERM_classMemberSpfn
    | NONTERM_classMemberSpfnGetSet
    | NONTERM_classMemberSpfnGetSetElements
    | NONTERM_memberSpecFlags
    | NONTERM_exconSpfn
    | NONTERM_opt_classSpfn
    | NONTERM_implementationFile
    | NONTERM_fileNamespaceImpls
    | NONTERM_fileNamespaceImplList
    | NONTERM_fileNamespaceImpl
    | NONTERM_fileModuleImpl
    | NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock
    | NONTERM_moduleDefnsOrExprPossiblyEmpty
    | NONTERM_moduleDefnsOrExpr
    | NONTERM_moduleDefns
    | NONTERM_moduleDefnOrDirective
    | NONTERM_moduleDefn
    | NONTERM_openDecl
    | NONTERM_namedModuleAbbrevBlock
    | NONTERM_namedModuleDefnBlock
    | NONTERM_wrappedNamedModuleDefn
    | NONTERM_tyconDefnAugmentation
    | NONTERM_opt_attributes
    | NONTERM_attributes
    | NONTERM_attributeList
    | NONTERM_attributeListElements
    | NONTERM_attribute
    | NONTERM_attributeTarget
    | NONTERM_memberFlags
    | NONTERM_typeNameInfo
    | NONTERM_tyconDefnList
    | NONTERM_tyconDefn
    | NONTERM_tyconDefnRhsBlock
    | NONTERM_tyconDefnRhs
    | NONTERM_tyconClassDefn
    | NONTERM_classDefnBlockKindUnspecified
    | NONTERM_classDefnBlock
    | NONTERM_classDefnMembers
    | NONTERM_classDefnMembersAtLeastOne
    | NONTERM_classDefnMemberGetSet
    | NONTERM_classDefnMemberGetSetElements
    | NONTERM_classDefnMemberGetSetElement
    | NONTERM_memberCore
    | NONTERM_abstractMemberFlags
    | NONTERM_classDefnMember
    | NONTERM_valDefnDecl
    | NONTERM_autoPropsDefnDecl
    | NONTERM_opt_typ
    | NONTERM_atomicPatternLongIdent
    | NONTERM_opt_access
    | NONTERM_access
    | NONTERM_opt_interfaceImplDefn
    | NONTERM_opt_classDefn
    | NONTERM_inheritsDefn
    | NONTERM_optAsSpec
    | NONTERM_asSpec
    | NONTERM_optBaseSpec
    | NONTERM_baseSpec
    | NONTERM_objectImplementationBlock
    | NONTERM_objectImplementationMembers
    | NONTERM_objectImplementationMember
    | NONTERM_staticMemberOrMemberOrOverride
    | NONTERM_tyconDefnOrSpfnSimpleRepr
    | NONTERM_braceFieldDeclList
    | NONTERM_anonRecdType
    | NONTERM_braceBarFieldDeclListCore
    | NONTERM_classOrInterfaceOrStruct
    | NONTERM_interfaceMember
    | NONTERM_tyconNameAndTyparDecls
    | NONTERM_prefixTyparDecls
    | NONTERM_typarDeclList
    | NONTERM_typarDecl
    | NONTERM_postfixTyparDecls
    | NONTERM_explicitValTyparDeclsCore
    | NONTERM_explicitValTyparDecls
    | NONTERM_opt_explicitValTyparDecls
    | NONTERM_opt_typeConstraints
    | NONTERM_typeConstraints
    | NONTERM_intersectionConstraints
    | NONTERM_typeConstraint
    | NONTERM_typeAlts
    | NONTERM_unionTypeRepr
    | NONTERM_barAndgrabXmlDoc
    | NONTERM_attrUnionCaseDecls
    | NONTERM_attrUnionCaseDecl
    | NONTERM_unionCaseName
    | NONTERM_firstUnionCaseDeclOfMany
    | NONTERM_firstUnionCaseDecl
    | NONTERM_unionCaseReprElements
    | NONTERM_unionCaseReprElement
    | NONTERM_unionCaseRepr
    | NONTERM_recdFieldDeclList
    | NONTERM_recdFieldDecl
    | NONTERM_fieldDecl
    | NONTERM_exconDefn
    | NONTERM_exconCore
    | NONTERM_exconIntro
    | NONTERM_exconRepr
    | NONTERM_defnBindings
    | NONTERM_doBinding
    | NONTERM_hardwhiteLetBindings
    | NONTERM_hardwhiteDoBinding
    | NONTERM_classDefnBindings
    | NONTERM_hardwhiteDefnBindingsTerminator
    | NONTERM_cPrototype
    | NONTERM_externArgs
    | NONTERM_externMoreArgs
    | NONTERM_externArg
    | NONTERM_cType
    | NONTERM_cRetType
    | NONTERM_localBindings
    | NONTERM_moreLocalBindings
    | NONTERM_attr_localBinding
    | NONTERM_localBinding
    | NONTERM_typedExprWithStaticOptimizationsBlock
    | NONTERM_typedExprWithStaticOptimizations
    | NONTERM_opt_staticOptimizations
    | NONTERM_staticOptimization
    | NONTERM_staticOptimizationConditions
    | NONTERM_staticOptimizationCondition
    | NONTERM_rawConstant
    | NONTERM_rationalConstant
    | NONTERM_atomicUnsignedRationalConstant
    | NONTERM_atomicRationalConstant
    | NONTERM_constant
    | NONTERM_bindingPattern
    | NONTERM_simplePattern
    | NONTERM_simplePatternCommaList
    | NONTERM_opt_simplePatterns
    | NONTERM_simplePatterns
    | NONTERM_headBindingPattern
    | NONTERM_tuplePatternElements
    | NONTERM_conjPatternElements
    | NONTERM_namePatPairs
    | NONTERM_namePatPair
    | NONTERM_constrPattern
    | NONTERM_atomicPatsOrNamePatPairs
    | NONTERM_atomicPatterns
    | NONTERM_atomicPattern
    | NONTERM_parenPatternBody
    | NONTERM_parenPattern
    | NONTERM_tupleParenPatternElements
    | NONTERM_conjParenPatternElements
    | NONTERM_recordPatternElementsAux
    | NONTERM_recordPatternElement
    | NONTERM_listPatternElements
    | NONTERM_typedSequentialExprBlock
    | NONTERM_declExprBlock
    | NONTERM_typedSequentialExprBlockR
    | NONTERM_typedSequentialExpr
    | NONTERM_typedSequentialExprEOF
    | NONTERM_sequentialExpr
    | NONTERM_recover
    | NONTERM_moreBinders
    | NONTERM_declExpr
    | NONTERM_whileExprCore
    | NONTERM_dynamicArg
    | NONTERM_withClauses
    | NONTERM_withPatternClauses
    | NONTERM_patternAndGuard
    | NONTERM_patternClauses
    | NONTERM_patternGuard
    | NONTERM_patternResult
    | NONTERM_ifExprCases
    | NONTERM_ifExprThen
    | NONTERM_ifExprElifs
    | NONTERM_tupleExpr
    | NONTERM_minusExpr
    | NONTERM_appExpr
    | NONTERM_argExpr
    | NONTERM_atomicExpr
    | NONTERM_atomicExprQualification
    | NONTERM_atomicExprAfterType
    | NONTERM_beginEndExpr
    | NONTERM_quoteExpr
    | NONTERM_arrayExpr
    | NONTERM_parenExpr
    | NONTERM_parenExprBody
    | NONTERM_typars
    | NONTERM_typarAlts
    | NONTERM_braceExpr
    | NONTERM_braceExprBody
    | NONTERM_listExprElements
    | NONTERM_arrayExprElements
    | NONTERM_computationExpr
    | NONTERM_arrowThenExprR
    | NONTERM_forLoopBinder
    | NONTERM_forLoopRange
    | NONTERM_forLoopDirection
    | NONTERM_inlineAssemblyExpr
    | NONTERM_optCurriedArgExprs
    | NONTERM_opt_atomicExprAfterType
    | NONTERM_opt_inlineAssemblyTypeArg
    | NONTERM_optInlineAssemblyReturnTypes
    | NONTERM_recdExpr
    | NONTERM_recdExprCore
    | NONTERM_opt_seps_recd
    | NONTERM_seps_recd
    | NONTERM_pathOrUnderscore
    | NONTERM_recdExprBindings
    | NONTERM_recdBinding
    | NONTERM_objExpr
    | NONTERM_objExprBaseCall
    | NONTERM_opt_objExprBindings
    | NONTERM_objExprBindings
    | NONTERM_objExprInterfaces
    | NONTERM_opt_objExprInterfaces
    | NONTERM_objExprInterface
    | NONTERM_braceBarExpr
    | NONTERM_braceBarExprCore
    | NONTERM_anonLambdaExpr
    | NONTERM_anonMatchingExpr
    | NONTERM_typeWithTypeConstraints
    | NONTERM_topTypeWithTypeConstraints
    | NONTERM_opt_topReturnTypeWithTypeConstraints
    | NONTERM_topType
    | NONTERM_topTupleType
    | NONTERM_topTupleTypeElements
    | NONTERM_topAppType
    | NONTERM_invalidUseOfAppTypeFunction
    | NONTERM_typ
    | NONTERM_typEOF
    | NONTERM_tupleType
    | NONTERM_tupleOrQuotTypeElements
    | NONTERM_intersectionType
    | NONTERM_appTypeCon
    | NONTERM_appTypeConPower
    | NONTERM_appType
    | NONTERM_arrayTypeSuffix
    | NONTERM_appTypePrefixArguments
    | NONTERM_typeArgListElements
    | NONTERM_powerType
    | NONTERM_atomTypeNonAtomicDeprecated
    | NONTERM_atomTypeOrAnonRecdType
    | NONTERM_atomType
    | NONTERM_typeArgsNoHpaDeprecated
    | NONTERM_typeArgsActual
    | NONTERM_typeArgActual
    | NONTERM_typeArgActualOrDummyIfEmpty
    | NONTERM_dummyTypeArg
    | NONTERM_measureTypeArg
    | NONTERM_measureTypeAtom
    | NONTERM_measureTypePower
    | NONTERM_measureTypeSeq
    | NONTERM_measureTypeExpr
    | NONTERM_typar
    | NONTERM_ident
    | NONTERM_path
    | NONTERM_opName
    | NONTERM_operatorName
    | NONTERM_activePatternCaseName
    | NONTERM_activePatternCaseNames
    | NONTERM_identOrOp
    | NONTERM_pathOp
    | NONTERM_nameop
    | NONTERM_identExpr
    | NONTERM_topSeparator
    | NONTERM_topSeparators
    | NONTERM_opt_topSeparators
    | NONTERM_seps
    | NONTERM_declEnd
    | NONTERM_opt_declEnd
    | NONTERM_opt_ODECLEND
    | NONTERM_deprecated_opt_equals
    | NONTERM_opt_equals
    | NONTERM_opt_OBLOCKSEP
    | NONTERM_opt_seps
    | NONTERM_opt_rec
    | NONTERM_opt_bar
    | NONTERM_opt_inline
    | NONTERM_opt_mutable
    | NONTERM_doToken
    | NONTERM_doneDeclEnd
    | NONTERM_structOrBegin
    | NONTERM_sigOrBegin
    | NONTERM_colonOrEquals
    | NONTERM_string
    | NONTERM_sourceIdentifier
    | NONTERM_interpolatedStringFill
    | NONTERM_interpolatedStringParts
    | NONTERM_interpolatedString
    | NONTERM_opt_HIGH_PRECEDENCE_APP
    | NONTERM_opt_HIGH_PRECEDENCE_TYAPP
    | NONTERM_typeKeyword
    | NONTERM_moduleKeyword
    | NONTERM_rbrace
    | NONTERM_bar_rbrace
    | NONTERM_rparen
    | NONTERM_oblockend
    | NONTERM_ends_other_than_rparen_coming_soon_or_recover
    | NONTERM_ends_coming_soon_or_recover

// This function maps tokens to integer indexes
let tagOfToken (t:token) = 
  match t with
  | HASH_IF _ -> 0 
  | HASH_ELSE _ -> 1 
  | HASH_ENDIF _ -> 2 
  | COMMENT _ -> 3 
  | WHITESPACE _ -> 4 
  | HASH_LINE _ -> 5 
  | HASH_LIGHT _ -> 6 
  | INACTIVECODE _ -> 7 
  | LINE_COMMENT _ -> 8 
  | STRING_TEXT _ -> 9 
  | EOF _ -> 10 
  | LEX_FAILURE _ -> 11 
  | ODUMMY _ -> 12 
  | FIXED  -> 13 
  | OINTERFACE_MEMBER  -> 14 
  | OBLOCKEND_COMING_SOON  -> 15 
  | OBLOCKEND_IS_HERE  -> 16 
  | OBLOCKEND _ -> 17 
  | ORIGHT_BLOCK_END _ -> 18 
  | ODECLEND _ -> 19 
  | OEND  -> 20 
  | OBLOCKSEP  -> 21 
  | OBLOCKBEGIN  -> 22 
  | ORESET  -> 23 
  | OFUN  -> 24 
  | OFUNCTION  -> 25 
  | OWITH  -> 26 
  | OELSE  -> 27 
  | OTHEN  -> 28 
  | ODO_BANG  -> 29 
  | ODO  -> 30 
  | OAND_BANG _ -> 31 
  | OBINDER _ -> 32 
  | OLET _ -> 33 
  | HIGH_PRECEDENCE_TYAPP  -> 34 
  | HIGH_PRECEDENCE_PAREN_APP  -> 35 
  | HIGH_PRECEDENCE_BRACK_APP  -> 36 
  | TYPE_COMING_SOON  -> 37 
  | TYPE_IS_HERE  -> 38 
  | MODULE_COMING_SOON  -> 39 
  | MODULE_IS_HERE  -> 40 
  | EXTERN  -> 41 
  | VOID  -> 42 
  | PUBLIC  -> 43 
  | PRIVATE  -> 44 
  | INTERNAL  -> 45 
  | GLOBAL  -> 46 
  | STATIC  -> 47 
  | MEMBER  -> 48 
  | CLASS  -> 49 
  | ABSTRACT  -> 50 
  | OVERRIDE  -> 51 
  | DEFAULT  -> 52 
  | CONSTRUCTOR  -> 53 
  | INHERIT  -> 54 
  | GREATER_RBRACK  -> 55 
  | STRUCT  -> 56 
  | SIG  -> 57 
  | BAR  -> 58 
  | RBRACK  -> 59 
  | RBRACE_COMING_SOON  -> 60 
  | RBRACE_IS_HERE  -> 61 
  | MINUS  -> 62 
  | DOLLAR  -> 63 
  | BAR_RBRACK  -> 64 
  | BAR_RBRACE  -> 65 
  | UNDERSCORE  -> 66 
  | SEMICOLON_SEMICOLON  -> 67 
  | LARROW  -> 68 
  | EQUALS  -> 69 
  | LBRACK  -> 70 
  | LBRACK_BAR  -> 71 
  | LBRACE_BAR  -> 72 
  | LBRACK_LESS  -> 73 
  | QMARK  -> 74 
  | QMARK_QMARK  -> 75 
  | DOT  -> 76 
  | COLON  -> 77 
  | COLON_COLON  -> 78 
  | COLON_GREATER  -> 79 
  | COLON_QMARK_GREATER  -> 80 
  | COLON_QMARK  -> 81 
  | COLON_EQUALS  -> 82 
  | SEMICOLON  -> 83 
  | WHEN  -> 84 
  | WHILE  -> 85 
  | WHILE_BANG  -> 86 
  | WITH  -> 87 
  | HASH  -> 88 
  | AMP  -> 89 
  | AMP_AMP  -> 90 
  | QUOTE  -> 91 
  | LPAREN  -> 92 
  | RPAREN  -> 93 
  | RPAREN_COMING_SOON  -> 94 
  | RPAREN_IS_HERE  -> 95 
  | STAR  -> 96 
  | COMMA  -> 97 
  | RARROW  -> 98 
  | GREATER_BAR_RBRACK  -> 99 
  | LPAREN_STAR_RPAREN  -> 100 
  | OPEN  -> 101 
  | OR  -> 102 
  | REC  -> 103 
  | THEN  -> 104 
  | TO  -> 105 
  | TRUE  -> 106 
  | TRY  -> 107 
  | TYPE  -> 108 
  | VAL  -> 109 
  | INLINE  -> 110 
  | INTERFACE  -> 111 
  | INSTANCE  -> 112 
  | CONST  -> 113 
  | LAZY  -> 114 
  | OLAZY  -> 115 
  | MATCH  -> 116 
  | MATCH_BANG  -> 117 
  | MUTABLE  -> 118 
  | NEW  -> 119 
  | OF  -> 120 
  | EXCEPTION  -> 121 
  | FALSE  -> 122 
  | FOR  -> 123 
  | FUN  -> 124 
  | FUNCTION  -> 125 
  | IF  -> 126 
  | IN  -> 127 
  | JOIN_IN  -> 128 
  | FINALLY  -> 129 
  | DO_BANG  -> 130 
  | AND  -> 131 
  | AS  -> 132 
  | ASSERT  -> 133 
  | OASSERT  -> 134 
  | ASR  -> 135 
  | BEGIN  -> 136 
  | DO  -> 137 
  | DONE  -> 138 
  | DOWNTO  -> 139 
  | ELSE  -> 140 
  | ELIF  -> 141 
  | END  -> 142 
  | DOT_DOT  -> 143 
  | DOT_DOT_HAT  -> 144 
  | BAR_BAR  -> 145 
  | UPCAST  -> 146 
  | DOWNCAST  -> 147 
  | NULL  -> 148 
  | RESERVED  -> 149 
  | MODULE  -> 150 
  | NAMESPACE  -> 151 
  | DELEGATE  -> 152 
  | CONSTRAINT  -> 153 
  | BASE  -> 154 
  | LQUOTE _ -> 155 
  | RQUOTE _ -> 156 
  | RQUOTE_DOT _ -> 157 
  | PERCENT_OP _ -> 158 
  | BINDER _ -> 159 
  | LESS _ -> 160 
  | GREATER _ -> 161 
  | LET _ -> 162 
  | YIELD _ -> 163 
  | YIELD_BANG _ -> 164 
  | AND_BANG _ -> 165 
  | BIGNUM _ -> 166 
  | DECIMAL _ -> 167 
  | CHAR _ -> 168 
  | IEEE64 _ -> 169 
  | IEEE32 _ -> 170 
  | UNATIVEINT _ -> 171 
  | UINT64 _ -> 172 
  | UINT32 _ -> 173 
  | UINT16 _ -> 174 
  | UINT8 _ -> 175 
  | NATIVEINT _ -> 176 
  | INT64 _ -> 177 
  | INT32 _ -> 178 
  | INT32_DOT_DOT _ -> 179 
  | INT16 _ -> 180 
  | INT8 _ -> 181 
  | FUNKY_OPERATOR_NAME _ -> 182 
  | ADJACENT_PREFIX_OP _ -> 183 
  | PLUS_MINUS_OP _ -> 184 
  | INFIX_AMP_OP _ -> 185 
  | INFIX_STAR_DIV_MOD_OP _ -> 186 
  | PREFIX_OP _ -> 187 
  | INFIX_BAR_OP _ -> 188 
  | INFIX_AT_HAT_OP _ -> 189 
  | INFIX_COMPARE_OP _ -> 190 
  | INFIX_STAR_STAR_OP _ -> 191 
  | HASH_IDENT _ -> 192 
  | IDENT _ -> 193 
  | KEYWORD_STRING _ -> 194 
  | LBRACE _ -> 195 
  | RBRACE _ -> 196 
  | INTERP_STRING_END _ -> 197 
  | INTERP_STRING_PART _ -> 198 
  | INTERP_STRING_BEGIN_PART _ -> 199 
  | INTERP_STRING_BEGIN_END _ -> 200 
  | STRING _ -> 201 
  | BYTEARRAY _ -> 202 

// This function maps integer indexes to symbolic token ids
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_HASH_IF 
  | 1 -> TOKEN_HASH_ELSE 
  | 2 -> TOKEN_HASH_ENDIF 
  | 3 -> TOKEN_COMMENT 
  | 4 -> TOKEN_WHITESPACE 
  | 5 -> TOKEN_HASH_LINE 
  | 6 -> TOKEN_HASH_LIGHT 
  | 7 -> TOKEN_INACTIVECODE 
  | 8 -> TOKEN_LINE_COMMENT 
  | 9 -> TOKEN_STRING_TEXT 
  | 10 -> TOKEN_EOF 
  | 11 -> TOKEN_LEX_FAILURE 
  | 12 -> TOKEN_ODUMMY 
  | 13 -> TOKEN_FIXED 
  | 14 -> TOKEN_OINTERFACE_MEMBER 
  | 15 -> TOKEN_OBLOCKEND_COMING_SOON 
  | 16 -> TOKEN_OBLOCKEND_IS_HERE 
  | 17 -> TOKEN_OBLOCKEND 
  | 18 -> TOKEN_ORIGHT_BLOCK_END 
  | 19 -> TOKEN_ODECLEND 
  | 20 -> TOKEN_OEND 
  | 21 -> TOKEN_OBLOCKSEP 
  | 22 -> TOKEN_OBLOCKBEGIN 
  | 23 -> TOKEN_ORESET 
  | 24 -> TOKEN_OFUN 
  | 25 -> TOKEN_OFUNCTION 
  | 26 -> TOKEN_OWITH 
  | 27 -> TOKEN_OELSE 
  | 28 -> TOKEN_OTHEN 
  | 29 -> TOKEN_ODO_BANG 
  | 30 -> TOKEN_ODO 
  | 31 -> TOKEN_OAND_BANG 
  | 32 -> TOKEN_OBINDER 
  | 33 -> TOKEN_OLET 
  | 34 -> TOKEN_HIGH_PRECEDENCE_TYAPP 
  | 35 -> TOKEN_HIGH_PRECEDENCE_PAREN_APP 
  | 36 -> TOKEN_HIGH_PRECEDENCE_BRACK_APP 
  | 37 -> TOKEN_TYPE_COMING_SOON 
  | 38 -> TOKEN_TYPE_IS_HERE 
  | 39 -> TOKEN_MODULE_COMING_SOON 
  | 40 -> TOKEN_MODULE_IS_HERE 
  | 41 -> TOKEN_EXTERN 
  | 42 -> TOKEN_VOID 
  | 43 -> TOKEN_PUBLIC 
  | 44 -> TOKEN_PRIVATE 
  | 45 -> TOKEN_INTERNAL 
  | 46 -> TOKEN_GLOBAL 
  | 47 -> TOKEN_STATIC 
  | 48 -> TOKEN_MEMBER 
  | 49 -> TOKEN_CLASS 
  | 50 -> TOKEN_ABSTRACT 
  | 51 -> TOKEN_OVERRIDE 
  | 52 -> TOKEN_DEFAULT 
  | 53 -> TOKEN_CONSTRUCTOR 
  | 54 -> TOKEN_INHERIT 
  | 55 -> TOKEN_GREATER_RBRACK 
  | 56 -> TOKEN_STRUCT 
  | 57 -> TOKEN_SIG 
  | 58 -> TOKEN_BAR 
  | 59 -> TOKEN_RBRACK 
  | 60 -> TOKEN_RBRACE_COMING_SOON 
  | 61 -> TOKEN_RBRACE_IS_HERE 
  | 62 -> TOKEN_MINUS 
  | 63 -> TOKEN_DOLLAR 
  | 64 -> TOKEN_BAR_RBRACK 
  | 65 -> TOKEN_BAR_RBRACE 
  | 66 -> TOKEN_UNDERSCORE 
  | 67 -> TOKEN_SEMICOLON_SEMICOLON 
  | 68 -> TOKEN_LARROW 
  | 69 -> TOKEN_EQUALS 
  | 70 -> TOKEN_LBRACK 
  | 71 -> TOKEN_LBRACK_BAR 
  | 72 -> TOKEN_LBRACE_BAR 
  | 73 -> TOKEN_LBRACK_LESS 
  | 74 -> TOKEN_QMARK 
  | 75 -> TOKEN_QMARK_QMARK 
  | 76 -> TOKEN_DOT 
  | 77 -> TOKEN_COLON 
  | 78 -> TOKEN_COLON_COLON 
  | 79 -> TOKEN_COLON_GREATER 
  | 80 -> TOKEN_COLON_QMARK_GREATER 
  | 81 -> TOKEN_COLON_QMARK 
  | 82 -> TOKEN_COLON_EQUALS 
  | 83 -> TOKEN_SEMICOLON 
  | 84 -> TOKEN_WHEN 
  | 85 -> TOKEN_WHILE 
  | 86 -> TOKEN_WHILE_BANG 
  | 87 -> TOKEN_WITH 
  | 88 -> TOKEN_HASH 
  | 89 -> TOKEN_AMP 
  | 90 -> TOKEN_AMP_AMP 
  | 91 -> TOKEN_QUOTE 
  | 92 -> TOKEN_LPAREN 
  | 93 -> TOKEN_RPAREN 
  | 94 -> TOKEN_RPAREN_COMING_SOON 
  | 95 -> TOKEN_RPAREN_IS_HERE 
  | 96 -> TOKEN_STAR 
  | 97 -> TOKEN_COMMA 
  | 98 -> TOKEN_RARROW 
  | 99 -> TOKEN_GREATER_BAR_RBRACK 
  | 100 -> TOKEN_LPAREN_STAR_RPAREN 
  | 101 -> TOKEN_OPEN 
  | 102 -> TOKEN_OR 
  | 103 -> TOKEN_REC 
  | 104 -> TOKEN_THEN 
  | 105 -> TOKEN_TO 
  | 106 -> TOKEN_TRUE 
  | 107 -> TOKEN_TRY 
  | 108 -> TOKEN_TYPE 
  | 109 -> TOKEN_VAL 
  | 110 -> TOKEN_INLINE 
  | 111 -> TOKEN_INTERFACE 
  | 112 -> TOKEN_INSTANCE 
  | 113 -> TOKEN_CONST 
  | 114 -> TOKEN_LAZY 
  | 115 -> TOKEN_OLAZY 
  | 116 -> TOKEN_MATCH 
  | 117 -> TOKEN_MATCH_BANG 
  | 118 -> TOKEN_MUTABLE 
  | 119 -> TOKEN_NEW 
  | 120 -> TOKEN_OF 
  | 121 -> TOKEN_EXCEPTION 
  | 122 -> TOKEN_FALSE 
  | 123 -> TOKEN_FOR 
  | 124 -> TOKEN_FUN 
  | 125 -> TOKEN_FUNCTION 
  | 126 -> TOKEN_IF 
  | 127 -> TOKEN_IN 
  | 128 -> TOKEN_JOIN_IN 
  | 129 -> TOKEN_FINALLY 
  | 130 -> TOKEN_DO_BANG 
  | 131 -> TOKEN_AND 
  | 132 -> TOKEN_AS 
  | 133 -> TOKEN_ASSERT 
  | 134 -> TOKEN_OASSERT 
  | 135 -> TOKEN_ASR 
  | 136 -> TOKEN_BEGIN 
  | 137 -> TOKEN_DO 
  | 138 -> TOKEN_DONE 
  | 139 -> TOKEN_DOWNTO 
  | 140 -> TOKEN_ELSE 
  | 141 -> TOKEN_ELIF 
  | 142 -> TOKEN_END 
  | 143 -> TOKEN_DOT_DOT 
  | 144 -> TOKEN_DOT_DOT_HAT 
  | 145 -> TOKEN_BAR_BAR 
  | 146 -> TOKEN_UPCAST 
  | 147 -> TOKEN_DOWNCAST 
  | 148 -> TOKEN_NULL 
  | 149 -> TOKEN_RESERVED 
  | 150 -> TOKEN_MODULE 
  | 151 -> TOKEN_NAMESPACE 
  | 152 -> TOKEN_DELEGATE 
  | 153 -> TOKEN_CONSTRAINT 
  | 154 -> TOKEN_BASE 
  | 155 -> TOKEN_LQUOTE 
  | 156 -> TOKEN_RQUOTE 
  | 157 -> TOKEN_RQUOTE_DOT 
  | 158 -> TOKEN_PERCENT_OP 
  | 159 -> TOKEN_BINDER 
  | 160 -> TOKEN_LESS 
  | 161 -> TOKEN_GREATER 
  | 162 -> TOKEN_LET 
  | 163 -> TOKEN_YIELD 
  | 164 -> TOKEN_YIELD_BANG 
  | 165 -> TOKEN_AND_BANG 
  | 166 -> TOKEN_BIGNUM 
  | 167 -> TOKEN_DECIMAL 
  | 168 -> TOKEN_CHAR 
  | 169 -> TOKEN_IEEE64 
  | 170 -> TOKEN_IEEE32 
  | 171 -> TOKEN_UNATIVEINT 
  | 172 -> TOKEN_UINT64 
  | 173 -> TOKEN_UINT32 
  | 174 -> TOKEN_UINT16 
  | 175 -> TOKEN_UINT8 
  | 176 -> TOKEN_NATIVEINT 
  | 177 -> TOKEN_INT64 
  | 178 -> TOKEN_INT32 
  | 179 -> TOKEN_INT32_DOT_DOT 
  | 180 -> TOKEN_INT16 
  | 181 -> TOKEN_INT8 
  | 182 -> TOKEN_FUNKY_OPERATOR_NAME 
  | 183 -> TOKEN_ADJACENT_PREFIX_OP 
  | 184 -> TOKEN_PLUS_MINUS_OP 
  | 185 -> TOKEN_INFIX_AMP_OP 
  | 186 -> TOKEN_INFIX_STAR_DIV_MOD_OP 
  | 187 -> TOKEN_PREFIX_OP 
  | 188 -> TOKEN_INFIX_BAR_OP 
  | 189 -> TOKEN_INFIX_AT_HAT_OP 
  | 190 -> TOKEN_INFIX_COMPARE_OP 
  | 191 -> TOKEN_INFIX_STAR_STAR_OP 
  | 192 -> TOKEN_HASH_IDENT 
  | 193 -> TOKEN_IDENT 
  | 194 -> TOKEN_KEYWORD_STRING 
  | 195 -> TOKEN_LBRACE 
  | 196 -> TOKEN_RBRACE 
  | 197 -> TOKEN_INTERP_STRING_END 
  | 198 -> TOKEN_INTERP_STRING_PART 
  | 199 -> TOKEN_INTERP_STRING_BEGIN_PART 
  | 200 -> TOKEN_INTERP_STRING_BEGIN_END 
  | 201 -> TOKEN_STRING 
  | 202 -> TOKEN_BYTEARRAY 
  | 205 -> TOKEN_end_of_input
  | 203 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: bad token"

/// This function maps production indexes returned in syntax errors to strings representing the non terminal that would be produced by that production
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startsignatureFile 
    | 1 -> NONTERM__startimplementationFile 
    | 2 -> NONTERM__startinteraction 
    | 3 -> NONTERM__starttypedSequentialExprEOF 
    | 4 -> NONTERM__starttypEOF 
    | 5 -> NONTERM_interaction 
    | 6 -> NONTERM_interaction 
    | 7 -> NONTERM_interaction 
    | 8 -> NONTERM_interactiveTerminator 
    | 9 -> NONTERM_interactiveTerminator 
    | 10 -> NONTERM_interactiveItemsTerminator 
    | 11 -> NONTERM_interactiveItemsTerminator 
    | 12 -> NONTERM_interactiveItemsTerminator 
    | 13 -> NONTERM_interactiveItemsTerminator 
    | 14 -> NONTERM_interactiveItemsTerminator 
    | 15 -> NONTERM_interactiveItemsTerminator 
    | 16 -> NONTERM_interactiveItemsTerminator 
    | 17 -> NONTERM_interactiveDefns 
    | 18 -> NONTERM_interactiveDefns 
    | 19 -> NONTERM_interactiveExpr 
    | 20 -> NONTERM_interactiveHash 
    | 21 -> NONTERM_interactiveSeparators 
    | 22 -> NONTERM_interactiveSeparators 
    | 23 -> NONTERM_interactiveSeparator 
    | 24 -> NONTERM_interactiveSeparator 
    | 25 -> NONTERM_hashDirective 
    | 26 -> NONTERM_hashDirectiveArgs 
    | 27 -> NONTERM_hashDirectiveArgs 
    | 28 -> NONTERM_hashDirectiveArg 
    | 29 -> NONTERM_hashDirectiveArg 
    | 30 -> NONTERM_signatureFile 
    | 31 -> NONTERM_signatureFile 
    | 32 -> NONTERM_signatureFile 
    | 33 -> NONTERM_moduleIntro 
    | 34 -> NONTERM_moduleIntro 
    | 35 -> NONTERM_moduleIntro 
    | 36 -> NONTERM_namespaceIntro 
    | 37 -> NONTERM_namespaceIntro 
    | 38 -> NONTERM_fileNamespaceSpecs 
    | 39 -> NONTERM_fileNamespaceSpecs 
    | 40 -> NONTERM_fileNamespaceSpecList 
    | 41 -> NONTERM_fileNamespaceSpecList 
    | 42 -> NONTERM_fileNamespaceSpec 
    | 43 -> NONTERM_fileModuleSpec 
    | 44 -> NONTERM_fileModuleSpec 
    | 45 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 46 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 47 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 48 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 49 -> NONTERM_moduleSpfnsPossiblyEmpty 
    | 50 -> NONTERM_moduleSpfnsPossiblyEmpty 
    | 51 -> NONTERM_moduleSpfnsPossiblyEmpty 
    | 52 -> NONTERM_moduleSpfns 
    | 53 -> NONTERM_moduleSpfns 
    | 54 -> NONTERM_moduleSpfns 
    | 55 -> NONTERM_moduleSpfn 
    | 56 -> NONTERM_moduleSpfn 
    | 57 -> NONTERM_moduleSpfn 
    | 58 -> NONTERM_moduleSpfn 
    | 59 -> NONTERM_moduleSpfn 
    | 60 -> NONTERM_moduleSpfn 
    | 61 -> NONTERM_moduleSpfn 
    | 62 -> NONTERM_moduleSpfn 
    | 63 -> NONTERM_valSpfn 
    | 64 -> NONTERM_optLiteralValueSpfn 
    | 65 -> NONTERM_optLiteralValueSpfn 
    | 66 -> NONTERM_optLiteralValueSpfn 
    | 67 -> NONTERM_moduleSpecBlock 
    | 68 -> NONTERM_moduleSpecBlock 
    | 69 -> NONTERM_moduleSpecBlock 
    | 70 -> NONTERM_tyconSpfnList 
    | 71 -> NONTERM_tyconSpfnList 
    | 72 -> NONTERM_tyconSpfn 
    | 73 -> NONTERM_tyconSpfn 
    | 74 -> NONTERM_tyconSpfnRhsBlock 
    | 75 -> NONTERM_tyconSpfnRhsBlock 
    | 76 -> NONTERM_tyconSpfnRhs 
    | 77 -> NONTERM_tyconSpfnRhs 
    | 78 -> NONTERM_tyconSpfnRhs 
    | 79 -> NONTERM_tyconClassSpfn 
    | 80 -> NONTERM_tyconClassSpfn 
    | 81 -> NONTERM_tyconClassSpfn 
    | 82 -> NONTERM_tyconClassSpfn 
    | 83 -> NONTERM_classSpfnBlockKindUnspecified 
    | 84 -> NONTERM_classSpfnBlockKindUnspecified 
    | 85 -> NONTERM_classSpfnBlockKindUnspecified 
    | 86 -> NONTERM_classSpfnBlockKindUnspecified 
    | 87 -> NONTERM_classSpfnBlock 
    | 88 -> NONTERM_classSpfnBlock 
    | 89 -> NONTERM_classSpfnBlock 
    | 90 -> NONTERM_classSpfnMembers 
    | 91 -> NONTERM_classSpfnMembers 
    | 92 -> NONTERM_classSpfnMembersAtLeastOne 
    | 93 -> NONTERM_classMemberSpfn 
    | 94 -> NONTERM_classMemberSpfn 
    | 95 -> NONTERM_classMemberSpfn 
    | 96 -> NONTERM_classMemberSpfn 
    | 97 -> NONTERM_classMemberSpfn 
    | 98 -> NONTERM_classMemberSpfn 
    | 99 -> NONTERM_classMemberSpfn 
    | 100 -> NONTERM_classMemberSpfn 
    | 101 -> NONTERM_classMemberSpfnGetSet 
    | 102 -> NONTERM_classMemberSpfnGetSet 
    | 103 -> NONTERM_classMemberSpfnGetSet 
    | 104 -> NONTERM_classMemberSpfnGetSet 
    | 105 -> NONTERM_classMemberSpfnGetSetElements 
    | 106 -> NONTERM_classMemberSpfnGetSetElements 
    | 107 -> NONTERM_classMemberSpfnGetSetElements 
    | 108 -> NONTERM_classMemberSpfnGetSetElements 
    | 109 -> NONTERM_memberSpecFlags 
    | 110 -> NONTERM_memberSpecFlags 
    | 111 -> NONTERM_exconSpfn 
    | 112 -> NONTERM_opt_classSpfn 
    | 113 -> NONTERM_opt_classSpfn 
    | 114 -> NONTERM_implementationFile 
    | 115 -> NONTERM_implementationFile 
    | 116 -> NONTERM_implementationFile 
    | 117 -> NONTERM_fileNamespaceImpls 
    | 118 -> NONTERM_fileNamespaceImpls 
    | 119 -> NONTERM_fileNamespaceImplList 
    | 120 -> NONTERM_fileNamespaceImplList 
    | 121 -> NONTERM_fileNamespaceImpl 
    | 122 -> NONTERM_fileModuleImpl 
    | 123 -> NONTERM_fileModuleImpl 
    | 124 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 125 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 126 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 127 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 128 -> NONTERM_moduleDefnsOrExprPossiblyEmpty 
    | 129 -> NONTERM_moduleDefnsOrExprPossiblyEmpty 
    | 130 -> NONTERM_moduleDefnsOrExpr 
    | 131 -> NONTERM_moduleDefnsOrExpr 
    | 132 -> NONTERM_moduleDefnsOrExpr 
    | 133 -> NONTERM_moduleDefnsOrExpr 
    | 134 -> NONTERM_moduleDefnsOrExpr 
    | 135 -> NONTERM_moduleDefns 
    | 136 -> NONTERM_moduleDefns 
    | 137 -> NONTERM_moduleDefns 
    | 138 -> NONTERM_moduleDefns 
    | 139 -> NONTERM_moduleDefns 
    | 140 -> NONTERM_moduleDefnOrDirective 
    | 141 -> NONTERM_moduleDefnOrDirective 
    | 142 -> NONTERM_moduleDefn 
    | 143 -> NONTERM_moduleDefn 
    | 144 -> NONTERM_moduleDefn 
    | 145 -> NONTERM_moduleDefn 
    | 146 -> NONTERM_moduleDefn 
    | 147 -> NONTERM_moduleDefn 
    | 148 -> NONTERM_moduleDefn 
    | 149 -> NONTERM_moduleDefn 
    | 150 -> NONTERM_moduleDefn 
    | 151 -> NONTERM_openDecl 
    | 152 -> NONTERM_openDecl 
    | 153 -> NONTERM_openDecl 
    | 154 -> NONTERM_openDecl 
    | 155 -> NONTERM_namedModuleAbbrevBlock 
    | 156 -> NONTERM_namedModuleAbbrevBlock 
    | 157 -> NONTERM_namedModuleDefnBlock 
    | 158 -> NONTERM_namedModuleDefnBlock 
    | 159 -> NONTERM_namedModuleDefnBlock 
    | 160 -> NONTERM_namedModuleDefnBlock 
    | 161 -> NONTERM_namedModuleDefnBlock 
    | 162 -> NONTERM_namedModuleDefnBlock 
    | 163 -> NONTERM_namedModuleDefnBlock 
    | 164 -> NONTERM_wrappedNamedModuleDefn 
    | 165 -> NONTERM_wrappedNamedModuleDefn 
    | 166 -> NONTERM_wrappedNamedModuleDefn 
    | 167 -> NONTERM_tyconDefnAugmentation 
    | 168 -> NONTERM_opt_attributes 
    | 169 -> NONTERM_opt_attributes 
    | 170 -> NONTERM_attributes 
    | 171 -> NONTERM_attributes 
    | 172 -> NONTERM_attributeList 
    | 173 -> NONTERM_attributeList 
    | 174 -> NONTERM_attributeList 
    | 175 -> NONTERM_attributeList 
    | 176 -> NONTERM_attributeListElements 
    | 177 -> NONTERM_attributeListElements 
    | 178 -> NONTERM_attribute 
    | 179 -> NONTERM_attribute 
    | 180 -> NONTERM_attribute 
    | 181 -> NONTERM_attributeTarget 
    | 182 -> NONTERM_attributeTarget 
    | 183 -> NONTERM_attributeTarget 
    | 184 -> NONTERM_attributeTarget 
    | 185 -> NONTERM_memberFlags 
    | 186 -> NONTERM_memberFlags 
    | 187 -> NONTERM_memberFlags 
    | 188 -> NONTERM_memberFlags 
    | 189 -> NONTERM_memberFlags 
    | 190 -> NONTERM_typeNameInfo 
    | 191 -> NONTERM_tyconDefnList 
    | 192 -> NONTERM_tyconDefnList 
    | 193 -> NONTERM_tyconDefn 
    | 194 -> NONTERM_tyconDefn 
    | 195 -> NONTERM_tyconDefn 
    | 196 -> NONTERM_tyconDefn 
    | 197 -> NONTERM_tyconDefnRhsBlock 
    | 198 -> NONTERM_tyconDefnRhsBlock 
    | 199 -> NONTERM_tyconDefnRhsBlock 
    | 200 -> NONTERM_tyconDefnRhsBlock 
    | 201 -> NONTERM_tyconDefnRhs 
    | 202 -> NONTERM_tyconDefnRhs 
    | 203 -> NONTERM_tyconDefnRhs 
    | 204 -> NONTERM_tyconClassDefn 
    | 205 -> NONTERM_tyconClassDefn 
    | 206 -> NONTERM_tyconClassDefn 
    | 207 -> NONTERM_tyconClassDefn 
    | 208 -> NONTERM_classDefnBlockKindUnspecified 
    | 209 -> NONTERM_classDefnBlockKindUnspecified 
    | 210 -> NONTERM_classDefnBlock 
    | 211 -> NONTERM_classDefnBlock 
    | 212 -> NONTERM_classDefnBlock 
    | 213 -> NONTERM_classDefnMembers 
    | 214 -> NONTERM_classDefnMembers 
    | 215 -> NONTERM_classDefnMembers 
    | 216 -> NONTERM_classDefnMembersAtLeastOne 
    | 217 -> NONTERM_classDefnMemberGetSet 
    | 218 -> NONTERM_classDefnMemberGetSet 
    | 219 -> NONTERM_classDefnMemberGetSet 
    | 220 -> NONTERM_classDefnMemberGetSetElements 
    | 221 -> NONTERM_classDefnMemberGetSetElements 
    | 222 -> NONTERM_classDefnMemberGetSetElement 
    | 223 -> NONTERM_memberCore 
    | 224 -> NONTERM_memberCore 
    | 225 -> NONTERM_memberCore 
    | 226 -> NONTERM_memberCore 
    | 227 -> NONTERM_abstractMemberFlags 
    | 228 -> NONTERM_abstractMemberFlags 
    | 229 -> NONTERM_abstractMemberFlags 
    | 230 -> NONTERM_abstractMemberFlags 
    | 231 -> NONTERM_classDefnMember 
    | 232 -> NONTERM_classDefnMember 
    | 233 -> NONTERM_classDefnMember 
    | 234 -> NONTERM_classDefnMember 
    | 235 -> NONTERM_classDefnMember 
    | 236 -> NONTERM_classDefnMember 
    | 237 -> NONTERM_classDefnMember 
    | 238 -> NONTERM_classDefnMember 
    | 239 -> NONTERM_classDefnMember 
    | 240 -> NONTERM_classDefnMember 
    | 241 -> NONTERM_classDefnMember 
    | 242 -> NONTERM_classDefnMember 
    | 243 -> NONTERM_classDefnMember 
    | 244 -> NONTERM_classDefnMember 
    | 245 -> NONTERM_classDefnMember 
    | 246 -> NONTERM_classDefnMember 
    | 247 -> NONTERM_valDefnDecl 
    | 248 -> NONTERM_valDefnDecl 
    | 249 -> NONTERM_valDefnDecl 
    | 250 -> NONTERM_valDefnDecl 
    | 251 -> NONTERM_autoPropsDefnDecl 
    | 252 -> NONTERM_autoPropsDefnDecl 
    | 253 -> NONTERM_autoPropsDefnDecl 
    | 254 -> NONTERM_autoPropsDefnDecl 
    | 255 -> NONTERM_opt_typ 
    | 256 -> NONTERM_opt_typ 
    | 257 -> NONTERM_opt_typ 
    | 258 -> NONTERM_atomicPatternLongIdent 
    | 259 -> NONTERM_atomicPatternLongIdent 
    | 260 -> NONTERM_atomicPatternLongIdent 
    | 261 -> NONTERM_atomicPatternLongIdent 
    | 262 -> NONTERM_atomicPatternLongIdent 
    | 263 -> NONTERM_opt_access 
    | 264 -> NONTERM_opt_access 
    | 265 -> NONTERM_access 
    | 266 -> NONTERM_access 
    | 267 -> NONTERM_access 
    | 268 -> NONTERM_opt_interfaceImplDefn 
    | 269 -> NONTERM_opt_interfaceImplDefn 
    | 270 -> NONTERM_opt_interfaceImplDefn 
    | 271 -> NONTERM_opt_classDefn 
    | 272 -> NONTERM_opt_classDefn 
    | 273 -> NONTERM_inheritsDefn 
    | 274 -> NONTERM_inheritsDefn 
    | 275 -> NONTERM_inheritsDefn 
    | 276 -> NONTERM_optAsSpec 
    | 277 -> NONTERM_optAsSpec 
    | 278 -> NONTERM_asSpec 
    | 279 -> NONTERM_asSpec 
    | 280 -> NONTERM_optBaseSpec 
    | 281 -> NONTERM_optBaseSpec 
    | 282 -> NONTERM_baseSpec 
    | 283 -> NONTERM_baseSpec 
    | 284 -> NONTERM_objectImplementationBlock 
    | 285 -> NONTERM_objectImplementationBlock 
    | 286 -> NONTERM_objectImplementationBlock 
    | 287 -> NONTERM_objectImplementationMembers 
    | 288 -> NONTERM_objectImplementationMembers 
    | 289 -> NONTERM_objectImplementationMember 
    | 290 -> NONTERM_objectImplementationMember 
    | 291 -> NONTERM_objectImplementationMember 
    | 292 -> NONTERM_objectImplementationMember 
    | 293 -> NONTERM_staticMemberOrMemberOrOverride 
    | 294 -> NONTERM_staticMemberOrMemberOrOverride 
    | 295 -> NONTERM_staticMemberOrMemberOrOverride 
    | 296 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 297 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 298 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 299 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 300 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 301 -> NONTERM_braceFieldDeclList 
    | 302 -> NONTERM_braceFieldDeclList 
    | 303 -> NONTERM_braceFieldDeclList 
    | 304 -> NONTERM_braceFieldDeclList 
    | 305 -> NONTERM_anonRecdType 
    | 306 -> NONTERM_anonRecdType 
    | 307 -> NONTERM_braceBarFieldDeclListCore 
    | 308 -> NONTERM_braceBarFieldDeclListCore 
    | 309 -> NONTERM_braceBarFieldDeclListCore 
    | 310 -> NONTERM_classOrInterfaceOrStruct 
    | 311 -> NONTERM_classOrInterfaceOrStruct 
    | 312 -> NONTERM_classOrInterfaceOrStruct 
    | 313 -> NONTERM_interfaceMember 
    | 314 -> NONTERM_interfaceMember 
    | 315 -> NONTERM_tyconNameAndTyparDecls 
    | 316 -> NONTERM_tyconNameAndTyparDecls 
    | 317 -> NONTERM_tyconNameAndTyparDecls 
    | 318 -> NONTERM_tyconNameAndTyparDecls 
    | 319 -> NONTERM_prefixTyparDecls 
    | 320 -> NONTERM_prefixTyparDecls 
    | 321 -> NONTERM_typarDeclList 
    | 322 -> NONTERM_typarDeclList 
    | 323 -> NONTERM_typarDecl 
    | 324 -> NONTERM_typarDecl 
    | 325 -> NONTERM_postfixTyparDecls 
    | 326 -> NONTERM_explicitValTyparDeclsCore 
    | 327 -> NONTERM_explicitValTyparDeclsCore 
    | 328 -> NONTERM_explicitValTyparDeclsCore 
    | 329 -> NONTERM_explicitValTyparDecls 
    | 330 -> NONTERM_opt_explicitValTyparDecls 
    | 331 -> NONTERM_opt_explicitValTyparDecls 
    | 332 -> NONTERM_opt_typeConstraints 
    | 333 -> NONTERM_opt_typeConstraints 
    | 334 -> NONTERM_typeConstraints 
    | 335 -> NONTERM_typeConstraints 
    | 336 -> NONTERM_intersectionConstraints 
    | 337 -> NONTERM_intersectionConstraints 
    | 338 -> NONTERM_typeConstraint 
    | 339 -> NONTERM_typeConstraint 
    | 340 -> NONTERM_typeConstraint 
    | 341 -> NONTERM_typeConstraint 
    | 342 -> NONTERM_typeConstraint 
    | 343 -> NONTERM_typeConstraint 
    | 344 -> NONTERM_typeConstraint 
    | 345 -> NONTERM_typeConstraint 
    | 346 -> NONTERM_typeConstraint 
    | 347 -> NONTERM_typeConstraint 
    | 348 -> NONTERM_typeConstraint 
    | 349 -> NONTERM_typeAlts 
    | 350 -> NONTERM_typeAlts 
    | 351 -> NONTERM_unionTypeRepr 
    | 352 -> NONTERM_unionTypeRepr 
    | 353 -> NONTERM_unionTypeRepr 
    | 354 -> NONTERM_barAndgrabXmlDoc 
    | 355 -> NONTERM_attrUnionCaseDecls 
    | 356 -> NONTERM_attrUnionCaseDecls 
    | 357 -> NONTERM_attrUnionCaseDecl 
    | 358 -> NONTERM_attrUnionCaseDecl 
    | 359 -> NONTERM_attrUnionCaseDecl 
    | 360 -> NONTERM_attrUnionCaseDecl 
    | 361 -> NONTERM_attrUnionCaseDecl 
    | 362 -> NONTERM_attrUnionCaseDecl 
    | 363 -> NONTERM_attrUnionCaseDecl 
    | 364 -> NONTERM_attrUnionCaseDecl 
    | 365 -> NONTERM_attrUnionCaseDecl 
    | 366 -> NONTERM_unionCaseName 
    | 367 -> NONTERM_unionCaseName 
    | 368 -> NONTERM_unionCaseName 
    | 369 -> NONTERM_firstUnionCaseDeclOfMany 
    | 370 -> NONTERM_firstUnionCaseDeclOfMany 
    | 371 -> NONTERM_firstUnionCaseDeclOfMany 
    | 372 -> NONTERM_firstUnionCaseDecl 
    | 373 -> NONTERM_firstUnionCaseDecl 
    | 374 -> NONTERM_firstUnionCaseDecl 
    | 375 -> NONTERM_firstUnionCaseDecl 
    | 376 -> NONTERM_unionCaseReprElements 
    | 377 -> NONTERM_unionCaseReprElements 
    | 378 -> NONTERM_unionCaseReprElement 
    | 379 -> NONTERM_unionCaseReprElement 
    | 380 -> NONTERM_unionCaseReprElement 
    | 381 -> NONTERM_unionCaseReprElement 
    | 382 -> NONTERM_unionCaseRepr 
    | 383 -> NONTERM_unionCaseRepr 
    | 384 -> NONTERM_recdFieldDeclList 
    | 385 -> NONTERM_recdFieldDeclList 
    | 386 -> NONTERM_recdFieldDecl 
    | 387 -> NONTERM_fieldDecl 
    | 388 -> NONTERM_fieldDecl 
    | 389 -> NONTERM_fieldDecl 
    | 390 -> NONTERM_fieldDecl 
    | 391 -> NONTERM_exconDefn 
    | 392 -> NONTERM_exconCore 
    | 393 -> NONTERM_exconCore 
    | 394 -> NONTERM_exconIntro 
    | 395 -> NONTERM_exconIntro 
    | 396 -> NONTERM_exconIntro 
    | 397 -> NONTERM_exconRepr 
    | 398 -> NONTERM_exconRepr 
    | 399 -> NONTERM_defnBindings 
    | 400 -> NONTERM_defnBindings 
    | 401 -> NONTERM_doBinding 
    | 402 -> NONTERM_hardwhiteLetBindings 
    | 403 -> NONTERM_hardwhiteDoBinding 
    | 404 -> NONTERM_hardwhiteDoBinding 
    | 405 -> NONTERM_classDefnBindings 
    | 406 -> NONTERM_classDefnBindings 
    | 407 -> NONTERM_classDefnBindings 
    | 408 -> NONTERM_classDefnBindings 
    | 409 -> NONTERM_hardwhiteDefnBindingsTerminator 
    | 410 -> NONTERM_hardwhiteDefnBindingsTerminator 
    | 411 -> NONTERM_cPrototype 
    | 412 -> NONTERM_externArgs 
    | 413 -> NONTERM_externArgs 
    | 414 -> NONTERM_externArgs 
    | 415 -> NONTERM_externMoreArgs 
    | 416 -> NONTERM_externMoreArgs 
    | 417 -> NONTERM_externArg 
    | 418 -> NONTERM_externArg 
    | 419 -> NONTERM_cType 
    | 420 -> NONTERM_cType 
    | 421 -> NONTERM_cType 
    | 422 -> NONTERM_cType 
    | 423 -> NONTERM_cType 
    | 424 -> NONTERM_cRetType 
    | 425 -> NONTERM_cRetType 
    | 426 -> NONTERM_localBindings 
    | 427 -> NONTERM_moreLocalBindings 
    | 428 -> NONTERM_moreLocalBindings 
    | 429 -> NONTERM_attr_localBinding 
    | 430 -> NONTERM_attr_localBinding 
    | 431 -> NONTERM_localBinding 
    | 432 -> NONTERM_localBinding 
    | 433 -> NONTERM_localBinding 
    | 434 -> NONTERM_typedExprWithStaticOptimizationsBlock 
    | 435 -> NONTERM_typedExprWithStaticOptimizationsBlock 
    | 436 -> NONTERM_typedExprWithStaticOptimizationsBlock 
    | 437 -> NONTERM_typedExprWithStaticOptimizations 
    | 438 -> NONTERM_opt_staticOptimizations 
    | 439 -> NONTERM_opt_staticOptimizations 
    | 440 -> NONTERM_staticOptimization 
    | 441 -> NONTERM_staticOptimizationConditions 
    | 442 -> NONTERM_staticOptimizationConditions 
    | 443 -> NONTERM_staticOptimizationCondition 
    | 444 -> NONTERM_staticOptimizationCondition 
    | 445 -> NONTERM_rawConstant 
    | 446 -> NONTERM_rawConstant 
    | 447 -> NONTERM_rawConstant 
    | 448 -> NONTERM_rawConstant 
    | 449 -> NONTERM_rawConstant 
    | 450 -> NONTERM_rawConstant 
    | 451 -> NONTERM_rawConstant 
    | 452 -> NONTERM_rawConstant 
    | 453 -> NONTERM_rawConstant 
    | 454 -> NONTERM_rawConstant 
    | 455 -> NONTERM_rawConstant 
    | 456 -> NONTERM_rawConstant 
    | 457 -> NONTERM_rawConstant 
    | 458 -> NONTERM_rawConstant 
    | 459 -> NONTERM_rawConstant 
    | 460 -> NONTERM_rawConstant 
    | 461 -> NONTERM_rawConstant 
    | 462 -> NONTERM_rawConstant 
    | 463 -> NONTERM_rationalConstant 
    | 464 -> NONTERM_rationalConstant 
    | 465 -> NONTERM_rationalConstant 
    | 466 -> NONTERM_rationalConstant 
    | 467 -> NONTERM_atomicUnsignedRationalConstant 
    | 468 -> NONTERM_atomicUnsignedRationalConstant 
    | 469 -> NONTERM_atomicRationalConstant 
    | 470 -> NONTERM_atomicRationalConstant 
    | 471 -> NONTERM_constant 
    | 472 -> NONTERM_constant 
    | 473 -> NONTERM_bindingPattern 
    | 474 -> NONTERM_simplePattern 
    | 475 -> NONTERM_simplePattern 
    | 476 -> NONTERM_simplePattern 
    | 477 -> NONTERM_simplePattern 
    | 478 -> NONTERM_simplePattern 
    | 479 -> NONTERM_simplePatternCommaList 
    | 480 -> NONTERM_simplePatternCommaList 
    | 481 -> NONTERM_opt_simplePatterns 
    | 482 -> NONTERM_opt_simplePatterns 
    | 483 -> NONTERM_simplePatterns 
    | 484 -> NONTERM_simplePatterns 
    | 485 -> NONTERM_simplePatterns 
    | 486 -> NONTERM_simplePatterns 
    | 487 -> NONTERM_simplePatterns 
    | 488 -> NONTERM_headBindingPattern 
    | 489 -> NONTERM_headBindingPattern 
    | 490 -> NONTERM_headBindingPattern 
    | 491 -> NONTERM_headBindingPattern 
    | 492 -> NONTERM_headBindingPattern 
    | 493 -> NONTERM_headBindingPattern 
    | 494 -> NONTERM_tuplePatternElements 
    | 495 -> NONTERM_tuplePatternElements 
    | 496 -> NONTERM_tuplePatternElements 
    | 497 -> NONTERM_tuplePatternElements 
    | 498 -> NONTERM_tuplePatternElements 
    | 499 -> NONTERM_tuplePatternElements 
    | 500 -> NONTERM_conjPatternElements 
    | 501 -> NONTERM_conjPatternElements 
    | 502 -> NONTERM_namePatPairs 
    | 503 -> NONTERM_namePatPairs 
    | 504 -> NONTERM_namePatPairs 
    | 505 -> NONTERM_namePatPair 
    | 506 -> NONTERM_namePatPair 
    | 507 -> NONTERM_namePatPair 
    | 508 -> NONTERM_constrPattern 
    | 509 -> NONTERM_constrPattern 
    | 510 -> NONTERM_constrPattern 
    | 511 -> NONTERM_constrPattern 
    | 512 -> NONTERM_constrPattern 
    | 513 -> NONTERM_constrPattern 
    | 514 -> NONTERM_constrPattern 
    | 515 -> NONTERM_constrPattern 
    | 516 -> NONTERM_constrPattern 
    | 517 -> NONTERM_atomicPatsOrNamePatPairs 
    | 518 -> NONTERM_atomicPatsOrNamePatPairs 
    | 519 -> NONTERM_atomicPatterns 
    | 520 -> NONTERM_atomicPatterns 
    | 521 -> NONTERM_atomicPatterns 
    | 522 -> NONTERM_atomicPatterns 
    | 523 -> NONTERM_atomicPattern 
    | 524 -> NONTERM_atomicPattern 
    | 525 -> NONTERM_atomicPattern 
    | 526 -> NONTERM_atomicPattern 
    | 527 -> NONTERM_atomicPattern 
    | 528 -> NONTERM_atomicPattern 
    | 529 -> NONTERM_atomicPattern 
    | 530 -> NONTERM_atomicPattern 
    | 531 -> NONTERM_atomicPattern 
    | 532 -> NONTERM_atomicPattern 
    | 533 -> NONTERM_atomicPattern 
    | 534 -> NONTERM_atomicPattern 
    | 535 -> NONTERM_atomicPattern 
    | 536 -> NONTERM_atomicPattern 
    | 537 -> NONTERM_atomicPattern 
    | 538 -> NONTERM_atomicPattern 
    | 539 -> NONTERM_atomicPattern 
    | 540 -> NONTERM_atomicPattern 
    | 541 -> NONTERM_atomicPattern 
    | 542 -> NONTERM_atomicPattern 
    | 543 -> NONTERM_parenPatternBody 
    | 544 -> NONTERM_parenPatternBody 
    | 545 -> NONTERM_parenPattern 
    | 546 -> NONTERM_parenPattern 
    | 547 -> NONTERM_parenPattern 
    | 548 -> NONTERM_parenPattern 
    | 549 -> NONTERM_parenPattern 
    | 550 -> NONTERM_parenPattern 
    | 551 -> NONTERM_parenPattern 
    | 552 -> NONTERM_parenPattern 
    | 553 -> NONTERM_parenPattern 
    | 554 -> NONTERM_tupleParenPatternElements 
    | 555 -> NONTERM_tupleParenPatternElements 
    | 556 -> NONTERM_tupleParenPatternElements 
    | 557 -> NONTERM_tupleParenPatternElements 
    | 558 -> NONTERM_tupleParenPatternElements 
    | 559 -> NONTERM_tupleParenPatternElements 
    | 560 -> NONTERM_conjParenPatternElements 
    | 561 -> NONTERM_conjParenPatternElements 
    | 562 -> NONTERM_recordPatternElementsAux 
    | 563 -> NONTERM_recordPatternElementsAux 
    | 564 -> NONTERM_recordPatternElement 
    | 565 -> NONTERM_recordPatternElement 
    | 566 -> NONTERM_recordPatternElement 
    | 567 -> NONTERM_listPatternElements 
    | 568 -> NONTERM_listPatternElements 
    | 569 -> NONTERM_listPatternElements 
    | 570 -> NONTERM_typedSequentialExprBlock 
    | 571 -> NONTERM_typedSequentialExprBlock 
    | 572 -> NONTERM_typedSequentialExprBlock 
    | 573 -> NONTERM_typedSequentialExprBlock 
    | 574 -> NONTERM_declExprBlock 
    | 575 -> NONTERM_declExprBlock 
    | 576 -> NONTERM_declExprBlock 
    | 577 -> NONTERM_typedSequentialExprBlockR 
    | 578 -> NONTERM_typedSequentialExprBlockR 
    | 579 -> NONTERM_typedSequentialExprBlockR 
    | 580 -> NONTERM_typedSequentialExpr 
    | 581 -> NONTERM_typedSequentialExpr 
    | 582 -> NONTERM_typedSequentialExpr 
    | 583 -> NONTERM_typedSequentialExprEOF 
    | 584 -> NONTERM_sequentialExpr 
    | 585 -> NONTERM_sequentialExpr 
    | 586 -> NONTERM_sequentialExpr 
    | 587 -> NONTERM_sequentialExpr 
    | 588 -> NONTERM_sequentialExpr 
    | 589 -> NONTERM_sequentialExpr 
    | 590 -> NONTERM_recover 
    | 591 -> NONTERM_recover 
    | 592 -> NONTERM_moreBinders 
    | 593 -> NONTERM_moreBinders 
    | 594 -> NONTERM_moreBinders 
    | 595 -> NONTERM_declExpr 
    | 596 -> NONTERM_declExpr 
    | 597 -> NONTERM_declExpr 
    | 598 -> NONTERM_declExpr 
    | 599 -> NONTERM_declExpr 
    | 600 -> NONTERM_declExpr 
    | 601 -> NONTERM_declExpr 
    | 602 -> NONTERM_declExpr 
    | 603 -> NONTERM_declExpr 
    | 604 -> NONTERM_declExpr 
    | 605 -> NONTERM_declExpr 
    | 606 -> NONTERM_declExpr 
    | 607 -> NONTERM_declExpr 
    | 608 -> NONTERM_declExpr 
    | 609 -> NONTERM_declExpr 
    | 610 -> NONTERM_declExpr 
    | 611 -> NONTERM_declExpr 
    | 612 -> NONTERM_declExpr 
    | 613 -> NONTERM_declExpr 
    | 614 -> NONTERM_declExpr 
    | 615 -> NONTERM_declExpr 
    | 616 -> NONTERM_declExpr 
    | 617 -> NONTERM_declExpr 
    | 618 -> NONTERM_declExpr 
    | 619 -> NONTERM_declExpr 
    | 620 -> NONTERM_declExpr 
    | 621 -> NONTERM_declExpr 
    | 622 -> NONTERM_declExpr 
    | 623 -> NONTERM_declExpr 
    | 624 -> NONTERM_declExpr 
    | 625 -> NONTERM_declExpr 
    | 626 -> NONTERM_declExpr 
    | 627 -> NONTERM_declExpr 
    | 628 -> NONTERM_declExpr 
    | 629 -> NONTERM_declExpr 
    | 630 -> NONTERM_declExpr 
    | 631 -> NONTERM_declExpr 
    | 632 -> NONTERM_declExpr 
    | 633 -> NONTERM_declExpr 
    | 634 -> NONTERM_declExpr 
    | 635 -> NONTERM_declExpr 
    | 636 -> NONTERM_declExpr 
    | 637 -> NONTERM_declExpr 
    | 638 -> NONTERM_declExpr 
    | 639 -> NONTERM_declExpr 
    | 640 -> NONTERM_declExpr 
    | 641 -> NONTERM_declExpr 
    | 642 -> NONTERM_declExpr 
    | 643 -> NONTERM_declExpr 
    | 644 -> NONTERM_declExpr 
    | 645 -> NONTERM_declExpr 
    | 646 -> NONTERM_declExpr 
    | 647 -> NONTERM_declExpr 
    | 648 -> NONTERM_declExpr 
    | 649 -> NONTERM_declExpr 
    | 650 -> NONTERM_declExpr 
    | 651 -> NONTERM_declExpr 
    | 652 -> NONTERM_declExpr 
    | 653 -> NONTERM_declExpr 
    | 654 -> NONTERM_declExpr 
    | 655 -> NONTERM_declExpr 
    | 656 -> NONTERM_declExpr 
    | 657 -> NONTERM_declExpr 
    | 658 -> NONTERM_declExpr 
    | 659 -> NONTERM_declExpr 
    | 660 -> NONTERM_declExpr 
    | 661 -> NONTERM_declExpr 
    | 662 -> NONTERM_declExpr 
    | 663 -> NONTERM_declExpr 
    | 664 -> NONTERM_declExpr 
    | 665 -> NONTERM_declExpr 
    | 666 -> NONTERM_declExpr 
    | 667 -> NONTERM_declExpr 
    | 668 -> NONTERM_declExpr 
    | 669 -> NONTERM_declExpr 
    | 670 -> NONTERM_declExpr 
    | 671 -> NONTERM_declExpr 
    | 672 -> NONTERM_declExpr 
    | 673 -> NONTERM_declExpr 
    | 674 -> NONTERM_declExpr 
    | 675 -> NONTERM_declExpr 
    | 676 -> NONTERM_declExpr 
    | 677 -> NONTERM_declExpr 
    | 678 -> NONTERM_declExpr 
    | 679 -> NONTERM_declExpr 
    | 680 -> NONTERM_declExpr 
    | 681 -> NONTERM_declExpr 
    | 682 -> NONTERM_declExpr 
    | 683 -> NONTERM_declExpr 
    | 684 -> NONTERM_declExpr 
    | 685 -> NONTERM_declExpr 
    | 686 -> NONTERM_declExpr 
    | 687 -> NONTERM_declExpr 
    | 688 -> NONTERM_declExpr 
    | 689 -> NONTERM_declExpr 
    | 690 -> NONTERM_declExpr 
    | 691 -> NONTERM_declExpr 
    | 692 -> NONTERM_declExpr 
    | 693 -> NONTERM_declExpr 
    | 694 -> NONTERM_declExpr 
    | 695 -> NONTERM_declExpr 
    | 696 -> NONTERM_declExpr 
    | 697 -> NONTERM_declExpr 
    | 698 -> NONTERM_declExpr 
    | 699 -> NONTERM_declExpr 
    | 700 -> NONTERM_declExpr 
    | 701 -> NONTERM_declExpr 
    | 702 -> NONTERM_declExpr 
    | 703 -> NONTERM_declExpr 
    | 704 -> NONTERM_whileExprCore 
    | 705 -> NONTERM_whileExprCore 
    | 706 -> NONTERM_whileExprCore 
    | 707 -> NONTERM_whileExprCore 
    | 708 -> NONTERM_whileExprCore 
    | 709 -> NONTERM_whileExprCore 
    | 710 -> NONTERM_dynamicArg 
    | 711 -> NONTERM_dynamicArg 
    | 712 -> NONTERM_withClauses 
    | 713 -> NONTERM_withClauses 
    | 714 -> NONTERM_withClauses 
    | 715 -> NONTERM_withClauses 
    | 716 -> NONTERM_withPatternClauses 
    | 717 -> NONTERM_withPatternClauses 
    | 718 -> NONTERM_withPatternClauses 
    | 719 -> NONTERM_withPatternClauses 
    | 720 -> NONTERM_patternAndGuard 
    | 721 -> NONTERM_patternClauses 
    | 722 -> NONTERM_patternClauses 
    | 723 -> NONTERM_patternClauses 
    | 724 -> NONTERM_patternClauses 
    | 725 -> NONTERM_patternClauses 
    | 726 -> NONTERM_patternClauses 
    | 727 -> NONTERM_patternGuard 
    | 728 -> NONTERM_patternGuard 
    | 729 -> NONTERM_patternResult 
    | 730 -> NONTERM_ifExprCases 
    | 731 -> NONTERM_ifExprThen 
    | 732 -> NONTERM_ifExprThen 
    | 733 -> NONTERM_ifExprThen 
    | 734 -> NONTERM_ifExprThen 
    | 735 -> NONTERM_ifExprElifs 
    | 736 -> NONTERM_ifExprElifs 
    | 737 -> NONTERM_ifExprElifs 
    | 738 -> NONTERM_ifExprElifs 
    | 739 -> NONTERM_ifExprElifs 
    | 740 -> NONTERM_tupleExpr 
    | 741 -> NONTERM_tupleExpr 
    | 742 -> NONTERM_tupleExpr 
    | 743 -> NONTERM_tupleExpr 
    | 744 -> NONTERM_tupleExpr 
    | 745 -> NONTERM_tupleExpr 
    | 746 -> NONTERM_tupleExpr 
    | 747 -> NONTERM_tupleExpr 
    | 748 -> NONTERM_minusExpr 
    | 749 -> NONTERM_minusExpr 
    | 750 -> NONTERM_minusExpr 
    | 751 -> NONTERM_minusExpr 
    | 752 -> NONTERM_minusExpr 
    | 753 -> NONTERM_minusExpr 
    | 754 -> NONTERM_minusExpr 
    | 755 -> NONTERM_minusExpr 
    | 756 -> NONTERM_minusExpr 
    | 757 -> NONTERM_minusExpr 
    | 758 -> NONTERM_minusExpr 
    | 759 -> NONTERM_minusExpr 
    | 760 -> NONTERM_minusExpr 
    | 761 -> NONTERM_minusExpr 
    | 762 -> NONTERM_appExpr 
    | 763 -> NONTERM_appExpr 
    | 764 -> NONTERM_argExpr 
    | 765 -> NONTERM_argExpr 
    | 766 -> NONTERM_atomicExpr 
    | 767 -> NONTERM_atomicExpr 
    | 768 -> NONTERM_atomicExpr 
    | 769 -> NONTERM_atomicExpr 
    | 770 -> NONTERM_atomicExpr 
    | 771 -> NONTERM_atomicExpr 
    | 772 -> NONTERM_atomicExpr 
    | 773 -> NONTERM_atomicExpr 
    | 774 -> NONTERM_atomicExpr 
    | 775 -> NONTERM_atomicExpr 
    | 776 -> NONTERM_atomicExpr 
    | 777 -> NONTERM_atomicExpr 
    | 778 -> NONTERM_atomicExpr 
    | 779 -> NONTERM_atomicExpr 
    | 780 -> NONTERM_atomicExpr 
    | 781 -> NONTERM_atomicExpr 
    | 782 -> NONTERM_atomicExpr 
    | 783 -> NONTERM_atomicExpr 
    | 784 -> NONTERM_atomicExpr 
    | 785 -> NONTERM_atomicExpr 
    | 786 -> NONTERM_atomicExpr 
    | 787 -> NONTERM_atomicExpr 
    | 788 -> NONTERM_atomicExprQualification 
    | 789 -> NONTERM_atomicExprQualification 
    | 790 -> NONTERM_atomicExprQualification 
    | 791 -> NONTERM_atomicExprQualification 
    | 792 -> NONTERM_atomicExprQualification 
    | 793 -> NONTERM_atomicExprQualification 
    | 794 -> NONTERM_atomicExprQualification 
    | 795 -> NONTERM_atomicExprQualification 
    | 796 -> NONTERM_atomicExprQualification 
    | 797 -> NONTERM_atomicExprQualification 
    | 798 -> NONTERM_atomicExprAfterType 
    | 799 -> NONTERM_atomicExprAfterType 
    | 800 -> NONTERM_atomicExprAfterType 
    | 801 -> NONTERM_atomicExprAfterType 
    | 802 -> NONTERM_atomicExprAfterType 
    | 803 -> NONTERM_atomicExprAfterType 
    | 804 -> NONTERM_atomicExprAfterType 
    | 805 -> NONTERM_atomicExprAfterType 
    | 806 -> NONTERM_atomicExprAfterType 
    | 807 -> NONTERM_atomicExprAfterType 
    | 808 -> NONTERM_atomicExprAfterType 
    | 809 -> NONTERM_beginEndExpr 
    | 810 -> NONTERM_beginEndExpr 
    | 811 -> NONTERM_beginEndExpr 
    | 812 -> NONTERM_beginEndExpr 
    | 813 -> NONTERM_quoteExpr 
    | 814 -> NONTERM_quoteExpr 
    | 815 -> NONTERM_quoteExpr 
    | 816 -> NONTERM_quoteExpr 
    | 817 -> NONTERM_arrayExpr 
    | 818 -> NONTERM_arrayExpr 
    | 819 -> NONTERM_arrayExpr 
    | 820 -> NONTERM_arrayExpr 
    | 821 -> NONTERM_parenExpr 
    | 822 -> NONTERM_parenExpr 
    | 823 -> NONTERM_parenExpr 
    | 824 -> NONTERM_parenExpr 
    | 825 -> NONTERM_parenExpr 
    | 826 -> NONTERM_parenExpr 
    | 827 -> NONTERM_parenExpr 
    | 828 -> NONTERM_parenExpr 
    | 829 -> NONTERM_parenExpr 
    | 830 -> NONTERM_parenExpr 
    | 831 -> NONTERM_parenExprBody 
    | 832 -> NONTERM_parenExprBody 
    | 833 -> NONTERM_parenExprBody 
    | 834 -> NONTERM_typars 
    | 835 -> NONTERM_typars 
    | 836 -> NONTERM_typarAlts 
    | 837 -> NONTERM_typarAlts 
    | 838 -> NONTERM_braceExpr 
    | 839 -> NONTERM_braceExpr 
    | 840 -> NONTERM_braceExpr 
    | 841 -> NONTERM_braceExpr 
    | 842 -> NONTERM_braceExpr 
    | 843 -> NONTERM_braceExprBody 
    | 844 -> NONTERM_braceExprBody 
    | 845 -> NONTERM_braceExprBody 
    | 846 -> NONTERM_listExprElements 
    | 847 -> NONTERM_listExprElements 
    | 848 -> NONTERM_arrayExprElements 
    | 849 -> NONTERM_arrayExprElements 
    | 850 -> NONTERM_computationExpr 
    | 851 -> NONTERM_arrowThenExprR 
    | 852 -> NONTERM_forLoopBinder 
    | 853 -> NONTERM_forLoopBinder 
    | 854 -> NONTERM_forLoopBinder 
    | 855 -> NONTERM_forLoopRange 
    | 856 -> NONTERM_forLoopDirection 
    | 857 -> NONTERM_forLoopDirection 
    | 858 -> NONTERM_inlineAssemblyExpr 
    | 859 -> NONTERM_optCurriedArgExprs 
    | 860 -> NONTERM_optCurriedArgExprs 
    | 861 -> NONTERM_opt_atomicExprAfterType 
    | 862 -> NONTERM_opt_atomicExprAfterType 
    | 863 -> NONTERM_opt_inlineAssemblyTypeArg 
    | 864 -> NONTERM_opt_inlineAssemblyTypeArg 
    | 865 -> NONTERM_optInlineAssemblyReturnTypes 
    | 866 -> NONTERM_optInlineAssemblyReturnTypes 
    | 867 -> NONTERM_optInlineAssemblyReturnTypes 
    | 868 -> NONTERM_recdExpr 
    | 869 -> NONTERM_recdExpr 
    | 870 -> NONTERM_recdExprCore 
    | 871 -> NONTERM_recdExprCore 
    | 872 -> NONTERM_recdExprCore 
    | 873 -> NONTERM_recdExprCore 
    | 874 -> NONTERM_recdExprCore 
    | 875 -> NONTERM_recdExprCore 
    | 876 -> NONTERM_recdExprCore 
    | 877 -> NONTERM_recdExprCore 
    | 878 -> NONTERM_recdExprCore 
    | 879 -> NONTERM_opt_seps_recd 
    | 880 -> NONTERM_opt_seps_recd 
    | 881 -> NONTERM_seps_recd 
    | 882 -> NONTERM_seps_recd 
    | 883 -> NONTERM_seps_recd 
    | 884 -> NONTERM_seps_recd 
    | 885 -> NONTERM_pathOrUnderscore 
    | 886 -> NONTERM_pathOrUnderscore 
    | 887 -> NONTERM_recdExprBindings 
    | 888 -> NONTERM_recdExprBindings 
    | 889 -> NONTERM_recdBinding 
    | 890 -> NONTERM_recdBinding 
    | 891 -> NONTERM_recdBinding 
    | 892 -> NONTERM_recdBinding 
    | 893 -> NONTERM_recdBinding 
    | 894 -> NONTERM_objExpr 
    | 895 -> NONTERM_objExpr 
    | 896 -> NONTERM_objExpr 
    | 897 -> NONTERM_objExprBaseCall 
    | 898 -> NONTERM_objExprBaseCall 
    | 899 -> NONTERM_objExprBaseCall 
    | 900 -> NONTERM_opt_objExprBindings 
    | 901 -> NONTERM_opt_objExprBindings 
    | 902 -> NONTERM_objExprBindings 
    | 903 -> NONTERM_objExprBindings 
    | 904 -> NONTERM_objExprBindings 
    | 905 -> NONTERM_objExprInterfaces 
    | 906 -> NONTERM_opt_objExprInterfaces 
    | 907 -> NONTERM_opt_objExprInterfaces 
    | 908 -> NONTERM_opt_objExprInterfaces 
    | 909 -> NONTERM_objExprInterface 
    | 910 -> NONTERM_braceBarExpr 
    | 911 -> NONTERM_braceBarExpr 
    | 912 -> NONTERM_braceBarExprCore 
    | 913 -> NONTERM_braceBarExprCore 
    | 914 -> NONTERM_braceBarExprCore 
    | 915 -> NONTERM_braceBarExprCore 
    | 916 -> NONTERM_braceBarExprCore 
    | 917 -> NONTERM_anonLambdaExpr 
    | 918 -> NONTERM_anonLambdaExpr 
    | 919 -> NONTERM_anonLambdaExpr 
    | 920 -> NONTERM_anonLambdaExpr 
    | 921 -> NONTERM_anonLambdaExpr 
    | 922 -> NONTERM_anonLambdaExpr 
    | 923 -> NONTERM_anonLambdaExpr 
    | 924 -> NONTERM_anonLambdaExpr 
    | 925 -> NONTERM_anonMatchingExpr 
    | 926 -> NONTERM_anonMatchingExpr 
    | 927 -> NONTERM_typeWithTypeConstraints 
    | 928 -> NONTERM_typeWithTypeConstraints 
    | 929 -> NONTERM_topTypeWithTypeConstraints 
    | 930 -> NONTERM_topTypeWithTypeConstraints 
    | 931 -> NONTERM_opt_topReturnTypeWithTypeConstraints 
    | 932 -> NONTERM_opt_topReturnTypeWithTypeConstraints 
    | 933 -> NONTERM_opt_topReturnTypeWithTypeConstraints 
    | 934 -> NONTERM_topType 
    | 935 -> NONTERM_topType 
    | 936 -> NONTERM_topType 
    | 937 -> NONTERM_topTupleType 
    | 938 -> NONTERM_topTupleType 
    | 939 -> NONTERM_topTupleType 
    | 940 -> NONTERM_topTupleType 
    | 941 -> NONTERM_topTupleTypeElements 
    | 942 -> NONTERM_topTupleTypeElements 
    | 943 -> NONTERM_topTupleTypeElements 
    | 944 -> NONTERM_topTupleTypeElements 
    | 945 -> NONTERM_topAppType 
    | 946 -> NONTERM_topAppType 
    | 947 -> NONTERM_topAppType 
    | 948 -> NONTERM_topAppType 
    | 949 -> NONTERM_topAppType 
    | 950 -> NONTERM_topAppType 
    | 951 -> NONTERM_topAppType 
    | 952 -> NONTERM_topAppType 
    | 953 -> NONTERM_topAppType 
    | 954 -> NONTERM_topAppType 
    | 955 -> NONTERM_invalidUseOfAppTypeFunction 
    | 956 -> NONTERM_invalidUseOfAppTypeFunction 
    | 957 -> NONTERM_invalidUseOfAppTypeFunction 
    | 958 -> NONTERM_invalidUseOfAppTypeFunction 
    | 959 -> NONTERM_typ 
    | 960 -> NONTERM_typ 
    | 961 -> NONTERM_typ 
    | 962 -> NONTERM_typ 
    | 963 -> NONTERM_typEOF 
    | 964 -> NONTERM_tupleType 
    | 965 -> NONTERM_tupleType 
    | 966 -> NONTERM_tupleType 
    | 967 -> NONTERM_tupleType 
    | 968 -> NONTERM_tupleType 
    | 969 -> NONTERM_tupleType 
    | 970 -> NONTERM_tupleType 
    | 971 -> NONTERM_tupleType 
    | 972 -> NONTERM_tupleOrQuotTypeElements 
    | 973 -> NONTERM_tupleOrQuotTypeElements 
    | 974 -> NONTERM_tupleOrQuotTypeElements 
    | 975 -> NONTERM_tupleOrQuotTypeElements 
    | 976 -> NONTERM_tupleOrQuotTypeElements 
    | 977 -> NONTERM_tupleOrQuotTypeElements 
    | 978 -> NONTERM_tupleOrQuotTypeElements 
    | 979 -> NONTERM_intersectionType 
    | 980 -> NONTERM_intersectionType 
    | 981 -> NONTERM_appTypeCon 
    | 982 -> NONTERM_appTypeCon 
    | 983 -> NONTERM_appTypeConPower 
    | 984 -> NONTERM_appTypeConPower 
    | 985 -> NONTERM_appType 
    | 986 -> NONTERM_appType 
    | 987 -> NONTERM_appType 
    | 988 -> NONTERM_appType 
    | 989 -> NONTERM_appType 
    | 990 -> NONTERM_appType 
    | 991 -> NONTERM_appType 
    | 992 -> NONTERM_appType 
    | 993 -> NONTERM_arrayTypeSuffix 
    | 994 -> NONTERM_arrayTypeSuffix 
    | 995 -> NONTERM_arrayTypeSuffix 
    | 996 -> NONTERM_arrayTypeSuffix 
    | 997 -> NONTERM_arrayTypeSuffix 
    | 998 -> NONTERM_arrayTypeSuffix 
    | 999 -> NONTERM_arrayTypeSuffix 
    | 1000 -> NONTERM_arrayTypeSuffix 
    | 1001 -> NONTERM_arrayTypeSuffix 
    | 1002 -> NONTERM_arrayTypeSuffix 
    | 1003 -> NONTERM_arrayTypeSuffix 
    | 1004 -> NONTERM_arrayTypeSuffix 
    | 1005 -> NONTERM_arrayTypeSuffix 
    | 1006 -> NONTERM_arrayTypeSuffix 
    | 1007 -> NONTERM_arrayTypeSuffix 
    | 1008 -> NONTERM_arrayTypeSuffix 
    | 1009 -> NONTERM_arrayTypeSuffix 
    | 1010 -> NONTERM_arrayTypeSuffix 
    | 1011 -> NONTERM_arrayTypeSuffix 
    | 1012 -> NONTERM_arrayTypeSuffix 
    | 1013 -> NONTERM_arrayTypeSuffix 
    | 1014 -> NONTERM_arrayTypeSuffix 
    | 1015 -> NONTERM_arrayTypeSuffix 
    | 1016 -> NONTERM_arrayTypeSuffix 
    | 1017 -> NONTERM_arrayTypeSuffix 
    | 1018 -> NONTERM_arrayTypeSuffix 
    | 1019 -> NONTERM_arrayTypeSuffix 
    | 1020 -> NONTERM_arrayTypeSuffix 
    | 1021 -> NONTERM_arrayTypeSuffix 
    | 1022 -> NONTERM_arrayTypeSuffix 
    | 1023 -> NONTERM_arrayTypeSuffix 
    | 1024 -> NONTERM_arrayTypeSuffix 
    | 1025 -> NONTERM_appTypePrefixArguments 
    | 1026 -> NONTERM_typeArgListElements 
    | 1027 -> NONTERM_typeArgListElements 
    | 1028 -> NONTERM_typeArgListElements 
    | 1029 -> NONTERM_powerType 
    | 1030 -> NONTERM_powerType 
    | 1031 -> NONTERM_atomTypeNonAtomicDeprecated 
    | 1032 -> NONTERM_atomTypeNonAtomicDeprecated 
    | 1033 -> NONTERM_atomTypeOrAnonRecdType 
    | 1034 -> NONTERM_atomTypeOrAnonRecdType 
    | 1035 -> NONTERM_atomType 
    | 1036 -> NONTERM_atomType 
    | 1037 -> NONTERM_atomType 
    | 1038 -> NONTERM_atomType 
    | 1039 -> NONTERM_atomType 
    | 1040 -> NONTERM_atomType 
    | 1041 -> NONTERM_atomType 
    | 1042 -> NONTERM_atomType 
    | 1043 -> NONTERM_atomType 
    | 1044 -> NONTERM_atomType 
    | 1045 -> NONTERM_atomType 
    | 1046 -> NONTERM_atomType 
    | 1047 -> NONTERM_atomType 
    | 1048 -> NONTERM_atomType 
    | 1049 -> NONTERM_atomType 
    | 1050 -> NONTERM_atomType 
    | 1051 -> NONTERM_atomType 
    | 1052 -> NONTERM_atomType 
    | 1053 -> NONTERM_atomType 
    | 1054 -> NONTERM_atomType 
    | 1055 -> NONTERM_typeArgsNoHpaDeprecated 
    | 1056 -> NONTERM_typeArgsNoHpaDeprecated 
    | 1057 -> NONTERM_typeArgsActual 
    | 1058 -> NONTERM_typeArgsActual 
    | 1059 -> NONTERM_typeArgsActual 
    | 1060 -> NONTERM_typeArgsActual 
    | 1061 -> NONTERM_typeArgsActual 
    | 1062 -> NONTERM_typeArgsActual 
    | 1063 -> NONTERM_typeArgsActual 
    | 1064 -> NONTERM_typeArgActual 
    | 1065 -> NONTERM_typeArgActual 
    | 1066 -> NONTERM_typeArgActual 
    | 1067 -> NONTERM_typeArgActualOrDummyIfEmpty 
    | 1068 -> NONTERM_typeArgActualOrDummyIfEmpty 
    | 1069 -> NONTERM_dummyTypeArg 
    | 1070 -> NONTERM_measureTypeArg 
    | 1071 -> NONTERM_measureTypeArg 
    | 1072 -> NONTERM_measureTypeAtom 
    | 1073 -> NONTERM_measureTypeAtom 
    | 1074 -> NONTERM_measureTypeAtom 
    | 1075 -> NONTERM_measureTypePower 
    | 1076 -> NONTERM_measureTypePower 
    | 1077 -> NONTERM_measureTypePower 
    | 1078 -> NONTERM_measureTypeSeq 
    | 1079 -> NONTERM_measureTypeSeq 
    | 1080 -> NONTERM_measureTypeExpr 
    | 1081 -> NONTERM_measureTypeExpr 
    | 1082 -> NONTERM_measureTypeExpr 
    | 1083 -> NONTERM_measureTypeExpr 
    | 1084 -> NONTERM_typar 
    | 1085 -> NONTERM_typar 
    | 1086 -> NONTERM_ident 
    | 1087 -> NONTERM_path 
    | 1088 -> NONTERM_path 
    | 1089 -> NONTERM_path 
    | 1090 -> NONTERM_path 
    | 1091 -> NONTERM_opName 
    | 1092 -> NONTERM_opName 
    | 1093 -> NONTERM_opName 
    | 1094 -> NONTERM_opName 
    | 1095 -> NONTERM_opName 
    | 1096 -> NONTERM_operatorName 
    | 1097 -> NONTERM_operatorName 
    | 1098 -> NONTERM_operatorName 
    | 1099 -> NONTERM_operatorName 
    | 1100 -> NONTERM_operatorName 
    | 1101 -> NONTERM_operatorName 
    | 1102 -> NONTERM_operatorName 
    | 1103 -> NONTERM_operatorName 
    | 1104 -> NONTERM_operatorName 
    | 1105 -> NONTERM_operatorName 
    | 1106 -> NONTERM_operatorName 
    | 1107 -> NONTERM_operatorName 
    | 1108 -> NONTERM_operatorName 
    | 1109 -> NONTERM_operatorName 
    | 1110 -> NONTERM_operatorName 
    | 1111 -> NONTERM_operatorName 
    | 1112 -> NONTERM_operatorName 
    | 1113 -> NONTERM_operatorName 
    | 1114 -> NONTERM_operatorName 
    | 1115 -> NONTERM_operatorName 
    | 1116 -> NONTERM_operatorName 
    | 1117 -> NONTERM_operatorName 
    | 1118 -> NONTERM_operatorName 
    | 1119 -> NONTERM_operatorName 
    | 1120 -> NONTERM_operatorName 
    | 1121 -> NONTERM_operatorName 
    | 1122 -> NONTERM_activePatternCaseName 
    | 1123 -> NONTERM_activePatternCaseNames 
    | 1124 -> NONTERM_activePatternCaseNames 
    | 1125 -> NONTERM_identOrOp 
    | 1126 -> NONTERM_identOrOp 
    | 1127 -> NONTERM_pathOp 
    | 1128 -> NONTERM_pathOp 
    | 1129 -> NONTERM_pathOp 
    | 1130 -> NONTERM_pathOp 
    | 1131 -> NONTERM_nameop 
    | 1132 -> NONTERM_identExpr 
    | 1133 -> NONTERM_identExpr 
    | 1134 -> NONTERM_topSeparator 
    | 1135 -> NONTERM_topSeparator 
    | 1136 -> NONTERM_topSeparator 
    | 1137 -> NONTERM_topSeparators 
    | 1138 -> NONTERM_topSeparators 
    | 1139 -> NONTERM_opt_topSeparators 
    | 1140 -> NONTERM_opt_topSeparators 
    | 1141 -> NONTERM_seps 
    | 1142 -> NONTERM_seps 
    | 1143 -> NONTERM_seps 
    | 1144 -> NONTERM_seps 
    | 1145 -> NONTERM_declEnd 
    | 1146 -> NONTERM_declEnd 
    | 1147 -> NONTERM_declEnd 
    | 1148 -> NONTERM_opt_declEnd 
    | 1149 -> NONTERM_opt_declEnd 
    | 1150 -> NONTERM_opt_declEnd 
    | 1151 -> NONTERM_opt_declEnd 
    | 1152 -> NONTERM_opt_ODECLEND 
    | 1153 -> NONTERM_opt_ODECLEND 
    | 1154 -> NONTERM_deprecated_opt_equals 
    | 1155 -> NONTERM_deprecated_opt_equals 
    | 1156 -> NONTERM_opt_equals 
    | 1157 -> NONTERM_opt_equals 
    | 1158 -> NONTERM_opt_OBLOCKSEP 
    | 1159 -> NONTERM_opt_OBLOCKSEP 
    | 1160 -> NONTERM_opt_seps 
    | 1161 -> NONTERM_opt_seps 
    | 1162 -> NONTERM_opt_rec 
    | 1163 -> NONTERM_opt_rec 
    | 1164 -> NONTERM_opt_bar 
    | 1165 -> NONTERM_opt_bar 
    | 1166 -> NONTERM_opt_inline 
    | 1167 -> NONTERM_opt_inline 
    | 1168 -> NONTERM_opt_mutable 
    | 1169 -> NONTERM_opt_mutable 
    | 1170 -> NONTERM_doToken 
    | 1171 -> NONTERM_doToken 
    | 1172 -> NONTERM_doneDeclEnd 
    | 1173 -> NONTERM_doneDeclEnd 
    | 1174 -> NONTERM_structOrBegin 
    | 1175 -> NONTERM_structOrBegin 
    | 1176 -> NONTERM_sigOrBegin 
    | 1177 -> NONTERM_sigOrBegin 
    | 1178 -> NONTERM_colonOrEquals 
    | 1179 -> NONTERM_colonOrEquals 
    | 1180 -> NONTERM_string 
    | 1181 -> NONTERM_sourceIdentifier 
    | 1182 -> NONTERM_interpolatedStringFill 
    | 1183 -> NONTERM_interpolatedStringFill 
    | 1184 -> NONTERM_interpolatedStringParts 
    | 1185 -> NONTERM_interpolatedStringParts 
    | 1186 -> NONTERM_interpolatedStringParts 
    | 1187 -> NONTERM_interpolatedString 
    | 1188 -> NONTERM_interpolatedString 
    | 1189 -> NONTERM_interpolatedString 
    | 1190 -> NONTERM_opt_HIGH_PRECEDENCE_APP 
    | 1191 -> NONTERM_opt_HIGH_PRECEDENCE_APP 
    | 1192 -> NONTERM_opt_HIGH_PRECEDENCE_APP 
    | 1193 -> NONTERM_opt_HIGH_PRECEDENCE_TYAPP 
    | 1194 -> NONTERM_opt_HIGH_PRECEDENCE_TYAPP 
    | 1195 -> NONTERM_typeKeyword 
    | 1196 -> NONTERM_typeKeyword 
    | 1197 -> NONTERM_typeKeyword 
    | 1198 -> NONTERM_moduleKeyword 
    | 1199 -> NONTERM_moduleKeyword 
    | 1200 -> NONTERM_moduleKeyword 
    | 1201 -> NONTERM_rbrace 
    | 1202 -> NONTERM_rbrace 
    | 1203 -> NONTERM_rbrace 
    | 1204 -> NONTERM_bar_rbrace 
    | 1205 -> NONTERM_rparen 
    | 1206 -> NONTERM_rparen 
    | 1207 -> NONTERM_rparen 
    | 1208 -> NONTERM_oblockend 
    | 1209 -> NONTERM_oblockend 
    | 1210 -> NONTERM_oblockend 
    | 1211 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1212 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1213 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1214 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1215 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1216 -> NONTERM_ends_coming_soon_or_recover 
    | 1217 -> NONTERM_ends_coming_soon_or_recover 
    | 1218 -> NONTERM_ends_coming_soon_or_recover 
    | 1219 -> NONTERM_ends_coming_soon_or_recover 
    | 1220 -> NONTERM_ends_coming_soon_or_recover 
    | 1221 -> NONTERM_ends_coming_soon_or_recover 
    | _ -> failwith "prodIdxToNonTerminal: bad production index"

let _fsyacc_endOfInputTag = 205 
let _fsyacc_tagOfErrorTerminal = 203

// This function gets the name of a token as a string
let token_to_string (t:token) = 
  match t with 
  | HASH_IF _ -> "HASH_IF" 
  | HASH_ELSE _ -> "HASH_ELSE" 
  | HASH_ENDIF _ -> "HASH_ENDIF" 
  | COMMENT _ -> "COMMENT" 
  | WHITESPACE _ -> "WHITESPACE" 
  | HASH_LINE _ -> "HASH_LINE" 
  | HASH_LIGHT _ -> "HASH_LIGHT" 
  | INACTIVECODE _ -> "INACTIVECODE" 
  | LINE_COMMENT _ -> "LINE_COMMENT" 
  | STRING_TEXT _ -> "STRING_TEXT" 
  | EOF _ -> "EOF" 
  | LEX_FAILURE _ -> "LEX_FAILURE" 
  | ODUMMY _ -> "ODUMMY" 
  | FIXED  -> "FIXED" 
  | OINTERFACE_MEMBER  -> "OINTERFACE_MEMBER" 
  | OBLOCKEND_COMING_SOON  -> "OBLOCKEND_COMING_SOON" 
  | OBLOCKEND_IS_HERE  -> "OBLOCKEND_IS_HERE" 
  | OBLOCKEND _ -> "OBLOCKEND" 
  | ORIGHT_BLOCK_END _ -> "ORIGHT_BLOCK_END" 
  | ODECLEND _ -> "ODECLEND" 
  | OEND  -> "OEND" 
  | OBLOCKSEP  -> "OBLOCKSEP" 
  | OBLOCKBEGIN  -> "OBLOCKBEGIN" 
  | ORESET  -> "ORESET" 
  | OFUN  -> "OFUN" 
  | OFUNCTION  -> "OFUNCTION" 
  | OWITH  -> "OWITH" 
  | OELSE  -> "OELSE" 
  | OTHEN  -> "OTHEN" 
  | ODO_BANG  -> "ODO_BANG" 
  | ODO  -> "ODO" 
  | OAND_BANG _ -> "OAND_BANG" 
  | OBINDER _ -> "OBINDER" 
  | OLET _ -> "OLET" 
  | HIGH_PRECEDENCE_TYAPP  -> "HIGH_PRECEDENCE_TYAPP" 
  | HIGH_PRECEDENCE_PAREN_APP  -> "HIGH_PRECEDENCE_PAREN_APP" 
  | HIGH_PRECEDENCE_BRACK_APP  -> "HIGH_PRECEDENCE_BRACK_APP" 
  | TYPE_COMING_SOON  -> "TYPE_COMING_SOON" 
  | TYPE_IS_HERE  -> "TYPE_IS_HERE" 
  | MODULE_COMING_SOON  -> "MODULE_COMING_SOON" 
  | MODULE_IS_HERE  -> "MODULE_IS_HERE" 
  | EXTERN  -> "EXTERN" 
  | VOID  -> "VOID" 
  | PUBLIC  -> "PUBLIC" 
  | PRIVATE  -> "PRIVATE" 
  | INTERNAL  -> "INTERNAL" 
  | GLOBAL  -> "GLOBAL" 
  | STATIC  -> "STATIC" 
  | MEMBER  -> "MEMBER" 
  | CLASS  -> "CLASS" 
  | ABSTRACT  -> "ABSTRACT" 
  | OVERRIDE  -> "OVERRIDE" 
  | DEFAULT  -> "DEFAULT" 
  | CONSTRUCTOR  -> "CONSTRUCTOR" 
  | INHERIT  -> "INHERIT" 
  | GREATER_RBRACK  -> "GREATER_RBRACK" 
  | STRUCT  -> "STRUCT" 
  | SIG  -> "SIG" 
  | BAR  -> "BAR" 
  | RBRACK  -> "RBRACK" 
  | RBRACE_COMING_SOON  -> "RBRACE_COMING_SOON" 
  | RBRACE_IS_HERE  -> "RBRACE_IS_HERE" 
  | MINUS  -> "MINUS" 
  | DOLLAR  -> "DOLLAR" 
  | BAR_RBRACK  -> "BAR_RBRACK" 
  | BAR_RBRACE  -> "BAR_RBRACE" 
  | UNDERSCORE  -> "UNDERSCORE" 
  | SEMICOLON_SEMICOLON  -> "SEMICOLON_SEMICOLON" 
  | LARROW  -> "LARROW" 
  | EQUALS  -> "EQUALS" 
  | LBRACK  -> "LBRACK" 
  | LBRACK_BAR  -> "LBRACK_BAR" 
  | LBRACE_BAR  -> "LBRACE_BAR" 
  | LBRACK_LESS  -> "LBRACK_LESS" 
  | QMARK  -> "QMARK" 
  | QMARK_QMARK  -> "QMARK_QMARK" 
  | DOT  -> "DOT" 
  | COLON  -> "COLON" 
  | COLON_COLON  -> "COLON_COLON" 
  | COLON_GREATER  -> "COLON_GREATER" 
  | COLON_QMARK_GREATER  -> "COLON_QMARK_GREATER" 
  | COLON_QMARK  -> "COLON_QMARK" 
  | COLON_EQUALS  -> "COLON_EQUALS" 
  | SEMICOLON  -> "SEMICOLON" 
  | WHEN  -> "WHEN" 
  | WHILE  -> "WHILE" 
  | WHILE_BANG  -> "WHILE_BANG" 
  | WITH  -> "WITH" 
  | HASH  -> "HASH" 
  | AMP  -> "AMP" 
  | AMP_AMP  -> "AMP_AMP" 
  | QUOTE  -> "QUOTE" 
  | LPAREN  -> "LPAREN" 
  | RPAREN  -> "RPAREN" 
  | RPAREN_COMING_SOON  -> "RPAREN_COMING_SOON" 
  | RPAREN_IS_HERE  -> "RPAREN_IS_HERE" 
  | STAR  -> "STAR" 
  | COMMA  -> "COMMA" 
  | RARROW  -> "RARROW" 
  | GREATER_BAR_RBRACK  -> "GREATER_BAR_RBRACK" 
  | LPAREN_STAR_RPAREN  -> "LPAREN_STAR_RPAREN" 
  | OPEN  -> "OPEN" 
  | OR  -> "OR" 
  | REC  -> "REC" 
  | THEN  -> "THEN" 
  | TO  -> "TO" 
  | TRUE  -> "TRUE" 
  | TRY  -> "TRY" 
  | TYPE  -> "TYPE" 
  | VAL  -> "VAL" 
  | INLINE  -> "INLINE" 
  | INTERFACE  -> "INTERFACE" 
  | INSTANCE  -> "INSTANCE" 
  | CONST  -> "CONST" 
  | LAZY  -> "LAZY" 
  | OLAZY  -> "OLAZY" 
  | MATCH  -> "MATCH" 
  | MATCH_BANG  -> "MATCH_BANG" 
  | MUTABLE  -> "MUTABLE" 
  | NEW  -> "NEW" 
  | OF  -> "OF" 
  | EXCEPTION  -> "EXCEPTION" 
  | FALSE  -> "FALSE" 
  | FOR  -> "FOR" 
  | FUN  -> "FUN" 
  | FUNCTION  -> "FUNCTION" 
  | IF  -> "IF" 
  | IN  -> "IN" 
  | JOIN_IN  -> "JOIN_IN" 
  | FINALLY  -> "FINALLY" 
  | DO_BANG  -> "DO_BANG" 
  | AND  -> "AND" 
  | AS  -> "AS" 
  | ASSERT  -> "ASSERT" 
  | OASSERT  -> "OASSERT" 
  | ASR  -> "ASR" 
  | BEGIN  -> "BEGIN" 
  | DO  -> "DO" 
  | DONE  -> "DONE" 
  | DOWNTO  -> "DOWNTO" 
  | ELSE  -> "ELSE" 
  | ELIF  -> "ELIF" 
  | END  -> "END" 
  | DOT_DOT  -> "DOT_DOT" 
  | DOT_DOT_HAT  -> "DOT_DOT_HAT" 
  | BAR_BAR  -> "BAR_BAR" 
  | UPCAST  -> "UPCAST" 
  | DOWNCAST  -> "DOWNCAST" 
  | NULL  -> "NULL" 
  | RESERVED  -> "RESERVED" 
  | MODULE  -> "MODULE" 
  | NAMESPACE  -> "NAMESPACE" 
  | DELEGATE  -> "DELEGATE" 
  | CONSTRAINT  -> "CONSTRAINT" 
  | BASE  -> "BASE" 
  | LQUOTE _ -> "LQUOTE" 
  | RQUOTE _ -> "RQUOTE" 
  | RQUOTE_DOT _ -> "RQUOTE_DOT" 
  | PERCENT_OP _ -> "PERCENT_OP" 
  | BINDER _ -> "BINDER" 
  | LESS _ -> "LESS" 
  | GREATER _ -> "GREATER" 
  | LET _ -> "LET" 
  | YIELD _ -> "YIELD" 
  | YIELD_BANG _ -> "YIELD_BANG" 
  | AND_BANG _ -> "AND_BANG" 
  | BIGNUM _ -> "BIGNUM" 
  | DECIMAL _ -> "DECIMAL" 
  | CHAR _ -> "CHAR" 
  | IEEE64 _ -> "IEEE64" 
  | IEEE32 _ -> "IEEE32" 
  | UNATIVEINT _ -> "UNATIVEINT" 
  | UINT64 _ -> "UINT64" 
  | UINT32 _ -> "UINT32" 
  | UINT16 _ -> "UINT16" 
  | UINT8 _ -> "UINT8" 
  | NATIVEINT _ -> "NATIVEINT" 
  | INT64 _ -> "INT64" 
  | INT32 _ -> "INT32" 
  | INT32_DOT_DOT _ -> "INT32_DOT_DOT" 
  | INT16 _ -> "INT16" 
  | INT8 _ -> "INT8" 
  | FUNKY_OPERATOR_NAME _ -> "FUNKY_OPERATOR_NAME" 
  | ADJACENT_PREFIX_OP _ -> "ADJACENT_PREFIX_OP" 
  | PLUS_MINUS_OP _ -> "PLUS_MINUS_OP" 
  | INFIX_AMP_OP _ -> "INFIX_AMP_OP" 
  | INFIX_STAR_DIV_MOD_OP _ -> "INFIX_STAR_DIV_MOD_OP" 
  | PREFIX_OP _ -> "PREFIX_OP" 
  | INFIX_BAR_OP _ -> "INFIX_BAR_OP" 
  | INFIX_AT_HAT_OP _ -> "INFIX_AT_HAT_OP" 
  | INFIX_COMPARE_OP _ -> "INFIX_COMPARE_OP" 
  | INFIX_STAR_STAR_OP _ -> "INFIX_STAR_STAR_OP" 
  | HASH_IDENT _ -> "HASH_IDENT" 
  | IDENT _ -> "IDENT" 
  | KEYWORD_STRING _ -> "KEYWORD_STRING" 
  | LBRACE _ -> "LBRACE" 
  | RBRACE _ -> "RBRACE" 
  | INTERP_STRING_END _ -> "INTERP_STRING_END" 
  | INTERP_STRING_PART _ -> "INTERP_STRING_PART" 
  | INTERP_STRING_BEGIN_PART _ -> "INTERP_STRING_BEGIN_PART" 
  | INTERP_STRING_BEGIN_END _ -> "INTERP_STRING_BEGIN_END" 
  | STRING _ -> "STRING" 
  | BYTEARRAY _ -> "BYTEARRAY" 

// This function gets the data carried by a token as an object
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | HASH_IF _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_ELSE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_ENDIF _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | COMMENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | WHITESPACE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_LINE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_LIGHT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INACTIVECODE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LINE_COMMENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | STRING_TEXT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | EOF _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LEX_FAILURE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ODUMMY _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | FIXED  -> (null : System.Object) 
  | OINTERFACE_MEMBER  -> (null : System.Object) 
  | OBLOCKEND_COMING_SOON  -> (null : System.Object) 
  | OBLOCKEND_IS_HERE  -> (null : System.Object) 
  | OBLOCKEND _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ORIGHT_BLOCK_END _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ODECLEND _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | OEND  -> (null : System.Object) 
  | OBLOCKSEP  -> (null : System.Object) 
  | OBLOCKBEGIN  -> (null : System.Object) 
  | ORESET  -> (null : System.Object) 
  | OFUN  -> (null : System.Object) 
  | OFUNCTION  -> (null : System.Object) 
  | OWITH  -> (null : System.Object) 
  | OELSE  -> (null : System.Object) 
  | OTHEN  -> (null : System.Object) 
  | ODO_BANG  -> (null : System.Object) 
  | ODO  -> (null : System.Object) 
  | OAND_BANG _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | OBINDER _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | OLET _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HIGH_PRECEDENCE_TYAPP  -> (null : System.Object) 
  | HIGH_PRECEDENCE_PAREN_APP  -> (null : System.Object) 
  | HIGH_PRECEDENCE_BRACK_APP  -> (null : System.Object) 
  | TYPE_COMING_SOON  -> (null : System.Object) 
  | TYPE_IS_HERE  -> (null : System.Object) 
  | MODULE_COMING_SOON  -> (null : System.Object) 
  | MODULE_IS_HERE  -> (null : System.Object) 
  | EXTERN  -> (null : System.Object) 
  | VOID  -> (null : System.Object) 
  | PUBLIC  -> (null : System.Object) 
  | PRIVATE  -> (null : System.Object) 
  | INTERNAL  -> (null : System.Object) 
  | GLOBAL  -> (null : System.Object) 
  | STATIC  -> (null : System.Object) 
  | MEMBER  -> (null : System.Object) 
  | CLASS  -> (null : System.Object) 
  | ABSTRACT  -> (null : System.Object) 
  | OVERRIDE  -> (null : System.Object) 
  | DEFAULT  -> (null : System.Object) 
  | CONSTRUCTOR  -> (null : System.Object) 
  | INHERIT  -> (null : System.Object) 
  | GREATER_RBRACK  -> (null : System.Object) 
  | STRUCT  -> (null : System.Object) 
  | SIG  -> (null : System.Object) 
  | BAR  -> (null : System.Object) 
  | RBRACK  -> (null : System.Object) 
  | RBRACE_COMING_SOON  -> (null : System.Object) 
  | RBRACE_IS_HERE  -> (null : System.Object) 
  | MINUS  -> (null : System.Object) 
  | DOLLAR  -> (null : System.Object) 
  | BAR_RBRACK  -> (null : System.Object) 
  | BAR_RBRACE  -> (null : System.Object) 
  | UNDERSCORE  -> (null : System.Object) 
  | SEMICOLON_SEMICOLON  -> (null : System.Object) 
  | LARROW  -> (null : System.Object) 
  | EQUALS  -> (null : System.Object) 
  | LBRACK  -> (null : System.Object) 
  | LBRACK_BAR  -> (null : System.Object) 
  | LBRACE_BAR  -> (null : System.Object) 
  | LBRACK_LESS  -> (null : System.Object) 
  | QMARK  -> (null : System.Object) 
  | QMARK_QMARK  -> (null : System.Object) 
  | DOT  -> (null : System.Object) 
  | COLON  -> (null : System.Object) 
  | COLON_COLON  -> (null : System.Object) 
  | COLON_GREATER  -> (null : System.Object) 
  | COLON_QMARK_GREATER  -> (null : System.Object) 
  | COLON_QMARK  -> (null : System.Object) 
  | COLON_EQUALS  -> (null : System.Object) 
  | SEMICOLON  -> (null : System.Object) 
  | WHEN  -> (null : System.Object) 
  | WHILE  -> (null : System.Object) 
  | WHILE_BANG  -> (null : System.Object) 
  | WITH  -> (null : System.Object) 
  | HASH  -> (null : System.Object) 
  | AMP  -> (null : System.Object) 
  | AMP_AMP  -> (null : System.Object) 
  | QUOTE  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | RPAREN_COMING_SOON  -> (null : System.Object) 
  | RPAREN_IS_HERE  -> (null : System.Object) 
  | STAR  -> (null : System.Object) 
  | COMMA  -> (null : System.Object) 
  | RARROW  -> (null : System.Object) 
  | GREATER_BAR_RBRACK  -> (null : System.Object) 
  | LPAREN_STAR_RPAREN  -> (null : System.Object) 
  | OPEN  -> (null : System.Object) 
  | OR  -> (null : System.Object) 
  | REC  -> (null : System.Object) 
  | THEN  -> (null : System.Object) 
  | TO  -> (null : System.Object) 
  | TRUE  -> (null : System.Object) 
  | TRY  -> (null : System.Object) 
  | TYPE  -> (null : System.Object) 
  | VAL  -> (null : System.Object) 
  | INLINE  -> (null : System.Object) 
  | INTERFACE  -> (null : System.Object) 
  | INSTANCE  -> (null : System.Object) 
  | CONST  -> (null : System.Object) 
  | LAZY  -> (null : System.Object) 
  | OLAZY  -> (null : System.Object) 
  | MATCH  -> (null : System.Object) 
  | MATCH_BANG  -> (null : System.Object) 
  | MUTABLE  -> (null : System.Object) 
  | NEW  -> (null : System.Object) 
  | OF  -> (null : System.Object) 
  | EXCEPTION  -> (null : System.Object) 
  | FALSE  -> (null : System.Object) 
  | FOR  -> (null : System.Object) 
  | FUN  -> (null : System.Object) 
  | FUNCTION  -> (null : System.Object) 
  | IF  -> (null : System.Object) 
  | IN  -> (null : System.Object) 
  | JOIN_IN  -> (null : System.Object) 
  | FINALLY  -> (null : System.Object) 
  | DO_BANG  -> (null : System.Object) 
  | AND  -> (null : System.Object) 
  | AS  -> (null : System.Object) 
  | ASSERT  -> (null : System.Object) 
  | OASSERT  -> (null : System.Object) 
  | ASR  -> (null : System.Object) 
  | BEGIN  -> (null : System.Object) 
  | DO  -> (null : System.Object) 
  | DONE  -> (null : System.Object) 
  | DOWNTO  -> (null : System.Object) 
  | ELSE  -> (null : System.Object) 
  | ELIF  -> (null : System.Object) 
  | END  -> (null : System.Object) 
  | DOT_DOT  -> (null : System.Object) 
  | DOT_DOT_HAT  -> (null : System.Object) 
  | BAR_BAR  -> (null : System.Object) 
  | UPCAST  -> (null : System.Object) 
  | DOWNCAST  -> (null : System.Object) 
  | NULL  -> (null : System.Object) 
  | RESERVED  -> (null : System.Object) 
  | MODULE  -> (null : System.Object) 
  | NAMESPACE  -> (null : System.Object) 
  | DELEGATE  -> (null : System.Object) 
  | CONSTRAINT  -> (null : System.Object) 
  | BASE  -> (null : System.Object) 
  | LQUOTE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | RQUOTE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | RQUOTE_DOT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | PERCENT_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | BINDER _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LESS _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | GREATER _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LET _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | YIELD _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | YIELD_BANG _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | AND_BANG _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | BIGNUM _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | DECIMAL _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | CHAR _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | IEEE64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | IEEE32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UNATIVEINT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT16 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT8 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | NATIVEINT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT32_DOT_DOT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT16 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT8 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | FUNKY_OPERATOR_NAME _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ADJACENT_PREFIX_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | PLUS_MINUS_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_AMP_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_STAR_DIV_MOD_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | PREFIX_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_BAR_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_AT_HAT_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_COMPARE_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_STAR_STAR_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_IDENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | IDENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | KEYWORD_STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LBRACE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | RBRACE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_END _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_PART _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_BEGIN_PART _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_BEGIN_END _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | BYTEARRAY _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us;65535us;0us;65535us;0us;65535us;0us;65535us;0us;65535us;1us;65535us;4us;5us;7us;65535us;4us;15us;16us;17us;18us;19us;20us;21us;22us;15us;24us;15us;26us;15us;4us;65535us;4us;10us;22us;23us;24us;25us;26us;27us;5us;65535us;4us;16us;22us;16us;24us;16us;26us;16us;28us;29us;4us;65535us;4us;18us;22us;18us;24us;18us;26us;18us;4us;65535us;4us;20us;22us;20us;24us;20us;26us;20us;4us;65535us;16us;22us;18us;24us;20us;26us;34us;35us;4us;65535us;16us;34us;18us;34us;20us;34us;34us;34us;23us;65535us;0us;90us;2us;268us;4us;33us;22us;33us;24us;33us;26us;33us;66us;90us;70us;90us;74us;90us;85us;90us;88us;90us;120us;90us;123us;90us;127us;90us;234us;268us;238us;268us;241us;268us;253us;268us;257us;268us;259us;268us;265us;268us;296us;268us;306us;268us;1us;65535us;39us;40us;1us;65535us;40us;41us;1us;65535us;0us;1us;6us;65535us;31us;280us;69us;70us;93us;94us;237us;238us;251us;280us;270us;280us;4us;65535us;61us;65us;63us;65us;229us;233us;231us;233us;1us;65535us;0us;44us;2us;65535us;61us;62us;63us;64us;2us;65535us;61us;63us;63us;63us;2us;65535us;0us;61us;66us;67us;3us;65535us;0us;72us;66us;72us;70us;71us;6us;65535us;0us;73us;66us;73us;70us;73us;74us;75us;123us;124us;127us;128us;9us;65535us;0us;81us;66us;81us;70us;81us;74us;81us;85us;86us;88us;89us;120us;121us;123us;81us;127us;81us;9us;65535us;0us;84us;66us;84us;70us;84us;74us;84us;85us;84us;88us;84us;120us;84us;123us;84us;127us;84us;9us;65535us;0us;91us;66us;91us;70us;91us;74us;91us;85us;91us;88us;91us;120us;91us;123us;91us;127us;91us;2us;65535us;112us;113us;186us;187us;1us;65535us;95us;97us;2us;65535us;100us;101us;131us;132us;3us;65535us;99us;100us;130us;131us;198us;199us;1us;65535us;134us;135us;2us;65535us;134us;144us;137us;138us;2us;65535us;134us;147us;137us;147us;2us;65535us;134us;151us;137us;151us;3us;65535us;152us;153us;162us;163us;220us;221us;8us;65535us;137us;159us;139us;140us;152us;170us;158us;159us;162us;170us;166us;167us;173us;174us;220us;170us;8us;65535us;137us;171us;139us;171us;152us;171us;158us;171us;162us;171us;166us;171us;173us;171us;220us;171us;11us;65535us;137us;172us;139us;172us;152us;172us;158us;172us;162us;172us;166us;172us;173us;172us;220us;172us;650us;651us;657us;658us;1507us;1508us;3us;65535us;185us;186us;455us;456us;492us;493us;2us;65535us;203us;204us;205us;206us;2us;65535us;177us;179us;178us;179us;2us;65535us;69us;102us;93us;102us;5us;65535us;133us;136us;140us;141us;142us;143us;144us;145us;218us;219us;1us;65535us;2us;3us;1us;65535us;2us;223us;2us;65535us;229us;230us;231us;232us;2us;65535us;229us;231us;231us;231us;2us;65535us;2us;229us;234us;235us;3us;65535us;2us;240us;234us;240us;238us;239us;5us;65535us;2us;248us;234us;248us;238us;248us;241us;242us;306us;307us;9us;65535us;2us;249us;234us;249us;238us;249us;241us;249us;253us;254us;259us;260us;265us;266us;296us;300us;306us;249us;10us;65535us;2us;255us;234us;255us;238us;255us;241us;255us;253us;255us;257us;258us;259us;255us;265us;255us;296us;255us;306us;255us;10us;65535us;2us;257us;234us;257us;238us;257us;241us;257us;253us;257us;257us;257us;259us;257us;265us;257us;296us;257us;306us;257us;15us;65535us;2us;267us;4us;28us;22us;28us;24us;28us;26us;28us;28us;28us;234us;267us;238us;267us;241us;267us;253us;267us;257us;267us;259us;267us;265us;267us;296us;267us;306us;267us;24us;65535us;0us;103us;2us;286us;4us;286us;22us;286us;24us;286us;26us;286us;28us;286us;66us;103us;70us;103us;74us;103us;85us;103us;88us;103us;120us;103us;123us;103us;127us;103us;234us;286us;238us;286us;241us;286us;253us;286us;257us;286us;259us;286us;265us;286us;296us;286us;306us;286us;1us;65535us;95us;96us;1us;65535us;281us;282us;2us;65535us;281us;304us;296us;297us;1us;65535us;361us;362us;81us;65535us;0us;68us;2us;236us;4us;30us;22us;30us;24us;30us;26us;30us;28us;269us;50us;51us;66us;68us;70us;92us;74us;92us;85us;92us;88us;92us;99us;355us;104us;105us;120us;92us;123us;92us;127us;92us;130us;355us;134us;560us;137us;176us;139us;175us;152us;175us;158us;175us;162us;175us;166us;175us;173us;175us;198us;355us;220us;175us;234us;236us;238us;250us;241us;250us;253us;250us;257us;269us;259us;250us;265us;250us;276us;355us;296us;250us;306us;250us;311us;436us;358us;355us;361us;363us;368us;560us;371us;437us;373us;436us;388us;436us;392us;436us;394us;436us;398us;436us;404us;436us;407us;436us;418us;419us;475us;355us;516us;545us;519us;436us;537us;545us;543us;545us;574us;725us;584us;725us;602us;611us;607us;611us;608us;611us;616us;611us;621us;611us;650us;175us;657us;175us;667us;677us;670us;677us;675us;677us;722us;725us;737us;738us;750us;802us;756us;802us;769us;796us;774us;783us;779us;783us;781us;783us;799us;802us;1507us;175us;1606us;546us;1608us;802us;122us;65535us;0us;314us;2us;284us;4us;284us;22us;284us;24us;284us;26us;284us;28us;284us;50us;314us;66us;314us;70us;314us;74us;314us;85us;314us;88us;314us;99us;314us;104us;314us;111us;1679us;120us;314us;123us;314us;127us;314us;130us;314us;134us;314us;137us;314us;139us;314us;149us;1679us;152us;314us;158us;314us;162us;314us;166us;314us;173us;314us;184us;1679us;198us;314us;201us;1679us;220us;314us;234us;284us;238us;284us;241us;284us;253us;284us;257us;284us;259us;284us;265us;284us;276us;314us;296us;284us;306us;284us;311us;314us;315us;316us;358us;314us;361us;314us;368us;314us;371us;314us;373us;314us;385us;1679us;388us;314us;392us;314us;394us;314us;398us;314us;404us;314us;407us;314us;418us;314us;454us;1679us;475us;314us;516us;314us;519us;314us;537us;314us;543us;314us;574us;314us;584us;314us;602us;314us;607us;314us;608us;314us;616us;314us;621us;314us;650us;314us;657us;314us;667us;314us;670us;314us;675us;314us;688us;1679us;722us;314us;737us;314us;750us;314us;756us;314us;769us;314us;774us;314us;779us;314us;781us;314us;799us;314us;876us;876us;877us;876us;880us;876us;922us;1008us;941us;1008us;957us;1008us;960us;1008us;971us;1008us;979us;1008us;1002us;1008us;1008us;1008us;1009us;1008us;1011us;1008us;1012us;1008us;1015us;1008us;1017us;1008us;1018us;1008us;1024us;1008us;1028us;1008us;1135us;1008us;1305us;1008us;1307us;1008us;1313us;1008us;1320us;1008us;1322us;1008us;1507us;314us;1606us;314us;1608us;314us;1651us;1008us;1653us;1008us;1660us;1679us;1664us;1679us;1668us;1679us;1671us;1679us;1674us;1679us;1677us;1679us;122us;65535us;0us;315us;2us;315us;4us;315us;22us;315us;24us;315us;26us;315us;28us;315us;50us;315us;66us;315us;70us;315us;74us;315us;85us;315us;88us;315us;99us;315us;104us;315us;111us;315us;120us;315us;123us;315us;127us;315us;130us;315us;134us;315us;137us;315us;139us;315us;149us;315us;152us;315us;158us;315us;162us;315us;166us;315us;173us;315us;184us;315us;198us;315us;201us;315us;220us;315us;234us;315us;238us;315us;241us;315us;253us;315us;257us;315us;259us;315us;265us;315us;276us;315us;296us;315us;306us;315us;311us;315us;315us;315us;358us;315us;361us;315us;368us;315us;371us;315us;373us;315us;385us;315us;388us;315us;392us;315us;394us;315us;398us;315us;404us;315us;407us;315us;418us;315us;454us;315us;475us;315us;516us;315us;519us;315us;537us;315us;543us;315us;574us;315us;584us;315us;602us;315us;607us;315us;608us;315us;616us;315us;621us;315us;650us;315us;657us;315us;667us;315us;670us;315us;675us;315us;688us;315us;722us;315us;737us;315us;750us;315us;756us;315us;769us;315us;774us;315us;779us;315us;781us;315us;799us;315us;876us;315us;877us;315us;880us;315us;922us;315us;941us;315us;957us;315us;960us;315us;971us;315us;979us;315us;1002us;315us;1008us;315us;1009us;315us;1011us;315us;1012us;315us;1015us;315us;1017us;315us;1018us;315us;1024us;315us;1028us;315us;1135us;315us;1305us;315us;1307us;315us;1313us;315us;1320us;315us;1322us;315us;1507us;315us;1606us;315us;1608us;315us;1651us;315us;1653us;315us;1660us;315us;1664us;315us;1668us;315us;1671us;315us;1674us;315us;1677us;315us;1us;65535us;317us;318us;2us;65535us;317us;327us;328us;329us;2us;65535us;317us;333us;328us;333us;4us;65535us;177us;216us;178us;216us;438us;442us;439us;442us;6us;65535us;99us;133us;130us;133us;198us;133us;276us;361us;358us;361us;475us;361us;2us;65535us;277us;278us;359us;360us;3us;65535us;276us;277us;358us;359us;475us;476us;1us;65535us;368us;369us;2us;65535us;368us;380us;371us;372us;2us;65535us;368us;383us;371us;383us;2us;65535us;368us;387us;371us;387us;3us;65535us;311us;312us;388us;389us;519us;520us;8us;65535us;311us;402us;373us;374us;388us;402us;392us;405us;398us;399us;404us;405us;407us;408us;519us;402us;10us;65535us;311us;403us;371us;395us;373us;403us;388us;403us;392us;403us;394us;395us;398us;403us;404us;403us;407us;403us;519us;403us;1us;65535us;426us;431us;2us;65535us;409us;410us;411us;412us;3us;65535us;409us;415us;411us;415us;416us;417us;3us;65535us;442us;443us;547us;548us;553us;554us;4us;65535us;177us;217us;178us;217us;438us;450us;439us;450us;10us;65535us;311us;406us;371us;406us;373us;406us;388us;406us;392us;406us;394us;406us;398us;406us;404us;406us;407us;406us;519us;406us;3us;65535us;350us;461us;438us;459us;439us;459us;2us;65535us;442us;463us;547us;550us;1us;65535us;489us;490us;52us;65535us;419us;926us;424us;926us;465us;966us;806us;926us;899us;926us;901us;926us;902us;926us;906us;926us;907us;926us;910us;926us;912us;926us;913us;926us;922us;926us;926us;966us;927us;966us;929us;966us;931us;966us;934us;966us;936us;966us;941us;926us;945us;966us;947us;966us;949us;966us;957us;926us;960us;926us;971us;926us;979us;926us;1000us;926us;1002us;926us;1008us;926us;1009us;926us;1011us;926us;1012us;926us;1015us;926us;1017us;926us;1018us;926us;1024us;926us;1028us;926us;1078us;926us;1083us;926us;1135us;926us;1166us;926us;1173us;926us;1305us;926us;1307us;926us;1313us;926us;1320us;926us;1322us;926us;1634us;966us;1639us;966us;1651us;926us;1653us;926us;22us;65535us;30us;31us;51us;52us;68us;69us;92us;93us;107us;108us;175us;177us;176us;178us;180us;181us;236us;237us;250us;251us;269us;270us;355us;595us;363us;364us;436us;438us;437us;439us;478us;479us;487us;488us;560us;561us;677us;678us;727us;728us;738us;739us;770us;771us;74us;65535us;30us;512us;51us;512us;68us;512us;92us;512us;107us;512us;175us;512us;176us;512us;180us;512us;236us;512us;250us;512us;269us;512us;355us;512us;363us;512us;419us;507us;424us;507us;436us;512us;437us;512us;465us;507us;478us;512us;487us;512us;560us;512us;677us;512us;727us;512us;738us;512us;770us;512us;806us;507us;899us;507us;901us;507us;902us;507us;906us;507us;907us;507us;910us;507us;912us;507us;913us;507us;922us;507us;926us;507us;927us;507us;929us;507us;931us;507us;934us;507us;936us;507us;941us;507us;945us;507us;947us;507us;949us;507us;957us;507us;960us;507us;971us;507us;979us;507us;1000us;507us;1002us;507us;1008us;507us;1009us;507us;1011us;507us;1012us;507us;1015us;507us;1017us;507us;1018us;507us;1024us;507us;1028us;507us;1078us;507us;1083us;507us;1135us;507us;1166us;507us;1173us;507us;1305us;507us;1307us;507us;1313us;507us;1320us;507us;1322us;507us;1634us;507us;1639us;507us;1651us;507us;1653us;507us;1us;65535us;447us;448us;4us;65535us;374us;375us;376us;377us;380us;381us;735us;736us;2us;65535us;438us;458us;439us;458us;2us;65535us;366us;367us;466us;467us;2us;65535us;366us;529us;466us;529us;2us;65535us;523us;524us;526us;527us;3us;65535us;523us;533us;526us;533us;1381us;1604us;2us;65535us;516us;517us;1606us;1611us;4us;65535us;516us;541us;537us;538us;543us;544us;1606us;541us;4us;65535us;516us;542us;537us;542us;543us;542us;1606us;542us;2us;65535us;545us;547us;546us;547us;4us;65535us;134us;146us;137us;146us;368us;382us;371us;382us;9us;65535us;178us;568us;439us;568us;561us;568us;679us;719us;681us;719us;684us;719us;705us;719us;708us;719us;744us;719us;83us;65535us;8us;1843us;111us;1843us;149us;1843us;178us;1843us;184us;1843us;188us;1843us;190us;1843us;201us;1843us;290us;1843us;385us;1843us;439us;1843us;446us;1843us;454us;1843us;481us;1843us;497us;1843us;561us;1843us;569us;1843us;626us;1843us;630us;1843us;640us;1843us;643us;1843us;653us;1843us;664us;1843us;679us;1843us;681us;1843us;684us;1843us;688us;1843us;705us;1843us;708us;1843us;711us;1843us;714us;1843us;730us;1843us;744us;1843us;829us;1843us;873us;1843us;938us;1843us;1005us;1843us;1046us;1843us;1231us;1843us;1234us;1843us;1237us;1843us;1517us;1843us;1550us;1843us;1553us;1843us;1555us;1843us;1619us;1843us;1657us;1843us;1659us;1843us;1660us;1843us;1664us;1843us;1668us;1843us;1671us;1843us;1674us;1843us;1677us;1843us;1679us;1843us;1681us;1843us;1686us;1843us;1690us;1843us;1695us;1843us;1700us;1843us;1703us;1843us;1706us;1843us;1709us;1843us;1714us;1843us;1717us;1843us;1719us;1843us;1722us;1843us;1726us;1843us;1729us;1843us;1731us;1843us;1734us;1843us;1751us;1843us;1757us;1843us;1760us;1843us;1827us;1843us;1831us;1843us;1837us;1843us;1848us;1843us;1854us;1843us;1855us;1843us;1878us;1843us;1880us;1843us;1891us;1843us;84us;65535us;8us;583us;111us;583us;149us;583us;178us;583us;184us;583us;188us;583us;190us;583us;201us;583us;290us;583us;385us;583us;439us;583us;446us;583us;454us;583us;481us;583us;497us;583us;561us;583us;569us;583us;581us;582us;626us;583us;630us;583us;640us;583us;643us;583us;653us;583us;664us;583us;679us;583us;681us;583us;684us;583us;688us;583us;705us;583us;708us;583us;711us;583us;714us;583us;730us;583us;744us;583us;829us;583us;873us;583us;938us;583us;1005us;583us;1046us;583us;1231us;583us;1234us;583us;1237us;583us;1517us;583us;1550us;583us;1553us;583us;1555us;583us;1619us;583us;1657us;583us;1659us;583us;1660us;583us;1664us;583us;1668us;583us;1671us;583us;1674us;583us;1677us;583us;1679us;583us;1681us;583us;1686us;583us;1690us;583us;1695us;583us;1700us;583us;1703us;583us;1706us;583us;1709us;583us;1714us;583us;1717us;583us;1719us;583us;1722us;583us;1726us;583us;1729us;583us;1731us;583us;1734us;583us;1751us;583us;1757us;583us;1760us;583us;1827us;583us;1831us;583us;1837us;583us;1848us;583us;1854us;583us;1855us;583us;1878us;583us;1880us;583us;1891us;583us;4us;65535us;134us;152us;137us;152us;368us;388us;371us;388us;9us;65535us;177us;188us;178us;188us;438us;446us;439us;446us;1600us;1619us;1602us;1619us;1613us;1619us;1615us;1619us;1617us;1619us;1us;65535us;355us;356us;1us;65535us;595us;597us;3us;65535us;602us;603us;616us;605us;621us;606us;5us;65535us;602us;610us;607us;609us;608us;609us;616us;610us;621us;610us;1us;65535us;596us;599us;1us;65535us;621us;622us;4us;65535us;109us;625us;182us;625us;452us;625us;926us;927us;3us;65535us;109us;110us;182us;183us;452us;453us;3us;65535us;356us;357us;605us;617us;622us;623us;3us;65535us;626us;627us;1657us;628us;1659us;629us;3us;65535us;613us;614us;1737us;633us;1739us;634us;4us;65535us;626us;632us;630us;631us;1657us;632us;1659us;632us;1us;65535us;653us;654us;3us;65535us;178us;567us;439us;567us;561us;567us;5us;65535us;178us;667us;439us;667us;561us;667us;669us;670us;674us;675us;3us;65535us;667us;668us;670us;671us;675us;676us;3us;65535us;667us;674us;670us;674us;675us;674us;1us;65535us;678us;679us;3us;65535us;178us;669us;439us;669us;561us;669us;3us;65535us;178us;672us;439us;672us;561us;672us;7us;65535us;679us;720us;681us;720us;684us;720us;705us;720us;708us;720us;711us;712us;744us;720us;7us;65535us;679us;710us;681us;710us;684us;710us;705us;710us;708us;710us;711us;710us;744us;710us;6us;65535us;679us;683us;681us;682us;684us;685us;705us;706us;708us;709us;744us;745us;3us;65535us;574us;575us;584us;585us;722us;723us;3us;65535us;574us;721us;584us;721us;722us;721us;3us;65535us;193us;194us;196us;197us;725us;726us;4us;65535us;31us;279us;237us;279us;251us;279us;270us;279us;6us;65535us;31us;735us;69us;218us;93us;218us;237us;735us;251us;735us;270us;735us;1us;65535us;739us;740us;1us;65535us;740us;741us;120us;65535us;6us;1089us;31us;272us;114us;1089us;116us;1089us;237us;272us;251us;272us;270us;271us;274us;1089us;350us;763us;422us;1089us;427us;1089us;438us;763us;439us;763us;468us;1089us;491us;1089us;753us;1089us;759us;1089us;809us;1089us;813us;1089us;823us;1089us;1030us;1089us;1036us;1089us;1052us;1089us;1054us;1089us;1057us;1089us;1060us;1089us;1079us;1089us;1084us;1089us;1090us;1089us;1093us;1089us;1096us;1089us;1102us;1089us;1106us;1089us;1110us;1089us;1116us;1089us;1118us;1089us;1123us;1089us;1125us;1089us;1127us;1089us;1129us;1089us;1131us;1089us;1133us;1089us;1137us;1089us;1147us;1089us;1154us;1089us;1160us;1089us;1162us;1089us;1167us;1089us;1171us;1089us;1174us;1089us;1178us;1089us;1181us;1089us;1184us;1089us;1186us;1089us;1189us;1089us;1191us;1089us;1240us;1089us;1242us;1089us;1246us;1089us;1248us;1089us;1250us;1089us;1252us;1089us;1254us;1089us;1256us;1089us;1258us;1089us;1260us;1089us;1262us;1089us;1264us;1089us;1266us;1089us;1268us;1089us;1270us;1089us;1272us;1089us;1274us;1089us;1276us;1089us;1278us;1089us;1280us;1089us;1282us;1089us;1284us;1089us;1286us;1089us;1287us;1089us;1288us;1089us;1289us;1089us;1292us;1089us;1302us;1089us;1327us;1089us;1328us;1089us;1332us;1089us;1334us;1089us;1337us;1089us;1338us;1089us;1340us;1089us;1343us;1089us;1345us;1089us;1347us;1089us;1349us;1089us;1431us;1089us;1438us;1089us;1445us;1089us;1452us;1089us;1469us;1089us;1476us;1089us;1477us;1089us;1483us;1089us;1489us;1089us;1490us;1089us;1491us;1089us;1503us;1089us;1509us;1089us;1519us;1089us;1532us;1089us;1534us;1089us;1537us;1089us;1538us;1089us;1564us;1089us;1569us;1089us;1594us;1089us;1636us;1089us;1641us;1089us;2021us;1089us;2025us;1089us;7us;65535us;31us;275us;237us;275us;251us;275us;270us;275us;350us;764us;438us;764us;439us;764us;120us;65535us;6us;1060us;31us;274us;114us;1093us;116us;1093us;237us;274us;251us;274us;270us;273us;274us;1060us;350us;765us;422us;1060us;427us;1060us;438us;765us;439us;765us;468us;1060us;491us;1060us;753us;1060us;759us;1060us;809us;1060us;813us;1060us;823us;1060us;1030us;1060us;1036us;1060us;1052us;1060us;1054us;1060us;1057us;1060us;1060us;1060us;1079us;1060us;1084us;1060us;1090us;1060us;1093us;1060us;1096us;1060us;1102us;1060us;1106us;1060us;1110us;1060us;1116us;1060us;1118us;1093us;1123us;1093us;1125us;1093us;1127us;1093us;1129us;1093us;1131us;1093us;1133us;1093us;1137us;1060us;1147us;1060us;1154us;1060us;1160us;1093us;1162us;1093us;1167us;1060us;1171us;1060us;1174us;1060us;1178us;1060us;1181us;1060us;1184us;1060us;1186us;1060us;1189us;1093us;1191us;1060us;1240us;1093us;1242us;1093us;1246us;1093us;1248us;1093us;1250us;1093us;1252us;1093us;1254us;1093us;1256us;1093us;1258us;1093us;1260us;1093us;1262us;1093us;1264us;1093us;1266us;1093us;1268us;1093us;1270us;1093us;1272us;1093us;1274us;1093us;1276us;1093us;1278us;1093us;1280us;1093us;1282us;1093us;1284us;1093us;1286us;1093us;1287us;1093us;1288us;1093us;1289us;1093us;1292us;1060us;1302us;1060us;1327us;1093us;1328us;1060us;1332us;1093us;1334us;1060us;1337us;1093us;1338us;1060us;1340us;1093us;1343us;1093us;1345us;1093us;1347us;1093us;1349us;1093us;1431us;1060us;1438us;1093us;1445us;1060us;1452us;1060us;1469us;1060us;1476us;1060us;1477us;1060us;1483us;1060us;1489us;1060us;1490us;1060us;1491us;1060us;1503us;1093us;1509us;1060us;1519us;1060us;1532us;1060us;1534us;1093us;1537us;1093us;1538us;1093us;1564us;1093us;1569us;1093us;1594us;1093us;1636us;1060us;1641us;1060us;2021us;1093us;2025us;1093us;119us;65535us;6us;1099us;31us;1099us;114us;1099us;116us;1099us;237us;1099us;251us;1099us;274us;1099us;350us;766us;422us;1099us;427us;1099us;438us;766us;439us;766us;468us;1099us;491us;1099us;753us;1099us;759us;1099us;809us;1099us;813us;1099us;823us;1099us;1030us;1099us;1036us;1099us;1052us;1099us;1054us;1099us;1057us;1099us;1060us;1099us;1079us;1099us;1084us;1099us;1090us;1099us;1093us;1099us;1096us;1099us;1102us;1099us;1106us;1099us;1110us;1099us;1116us;1099us;1118us;1099us;1123us;1099us;1125us;1099us;1127us;1099us;1129us;1099us;1131us;1099us;1133us;1099us;1137us;1099us;1147us;1099us;1154us;1099us;1160us;1099us;1162us;1099us;1167us;1099us;1171us;1099us;1174us;1099us;1178us;1099us;1181us;1099us;1184us;1099us;1186us;1099us;1189us;1099us;1191us;1099us;1240us;1099us;1242us;1099us;1246us;1099us;1248us;1099us;1250us;1099us;1252us;1099us;1254us;1099us;1256us;1099us;1258us;1099us;1260us;1099us;1262us;1099us;1264us;1099us;1266us;1099us;1268us;1099us;1270us;1099us;1272us;1099us;1274us;1099us;1276us;1099us;1278us;1099us;1280us;1099us;1282us;1099us;1284us;1099us;1286us;1099us;1287us;1099us;1288us;1099us;1289us;1099us;1292us;1099us;1302us;1099us;1327us;1099us;1328us;1099us;1332us;1099us;1334us;1099us;1337us;1099us;1338us;1099us;1340us;1099us;1343us;1099us;1345us;1099us;1347us;1099us;1349us;1099us;1431us;1099us;1438us;1099us;1445us;1099us;1452us;1099us;1469us;1099us;1476us;1099us;1477us;1099us;1483us;1099us;1489us;1099us;1490us;1099us;1491us;1099us;1503us;1099us;1509us;1099us;1519us;1099us;1532us;1099us;1534us;1099us;1537us;1099us;1538us;1099us;1564us;1099us;1569us;1099us;1594us;1099us;1636us;1099us;1641us;1099us;2021us;1099us;2025us;1099us;3us;65535us;350us;441us;438us;440us;439us;440us;5us;65535us;757us;758us;760us;761us;1085us;1086us;1175us;1176us;1187us;1188us;120us;65535us;6us;752us;31us;752us;114us;752us;116us;752us;237us;752us;251us;752us;270us;752us;274us;752us;350us;752us;422us;752us;427us;752us;438us;752us;439us;752us;468us;752us;491us;752us;753us;752us;759us;752us;809us;752us;813us;752us;823us;752us;1030us;752us;1036us;752us;1052us;752us;1054us;752us;1057us;752us;1060us;752us;1079us;752us;1084us;752us;1090us;752us;1093us;752us;1096us;752us;1102us;752us;1106us;752us;1110us;752us;1116us;752us;1118us;752us;1123us;752us;1125us;752us;1127us;752us;1129us;752us;1131us;752us;1133us;752us;1137us;752us;1147us;752us;1154us;752us;1160us;752us;1162us;752us;1167us;752us;1171us;752us;1174us;752us;1178us;752us;1181us;752us;1184us;752us;1186us;752us;1189us;752us;1191us;752us;1240us;752us;1242us;752us;1246us;752us;1248us;752us;1250us;752us;1252us;752us;1254us;752us;1256us;752us;1258us;752us;1260us;752us;1262us;752us;1264us;752us;1266us;752us;1268us;752us;1270us;752us;1272us;752us;1274us;752us;1276us;752us;1278us;752us;1280us;752us;1282us;752us;1284us;752us;1286us;752us;1287us;752us;1288us;752us;1289us;752us;1292us;752us;1302us;752us;1327us;752us;1328us;752us;1332us;752us;1334us;752us;1337us;752us;1338us;752us;1340us;752us;1343us;752us;1345us;752us;1347us;752us;1349us;752us;1431us;752us;1438us;752us;1445us;752us;1452us;752us;1469us;752us;1476us;752us;1477us;752us;1483us;752us;1489us;752us;1490us;752us;1491us;752us;1503us;752us;1509us;752us;1519us;752us;1532us;752us;1534us;752us;1537us;752us;1538us;752us;1564us;752us;1569us;752us;1594us;752us;1636us;752us;1641us;752us;2021us;752us;2025us;752us;1us;65535us;774us;775us;1us;65535us;774us;777us;3us;65535us;774us;778us;779us;780us;781us;782us;2us;65535us;783us;784us;796us;787us;1us;65535us;769us;770us;4us;65535us;750us;751us;756us;757us;1606us;1607us;1608us;1609us;2us;65535us;797us;798us;800us;801us;5us;65535us;750us;797us;756us;797us;799us;800us;1606us;797us;1608us;797us;2us;65535us;546us;803us;802us;803us;1us;65535us;809us;810us;2us;65535us;809us;817us;813us;814us;1us;65535us;818us;819us;1us;65535us;819us;820us;1us;65535us;821us;822us;2us;65535us;821us;827us;825us;826us;300us;65535us;6us;864us;8us;1862us;31us;864us;111us;1862us;114us;864us;116us;864us;149us;1862us;178us;1862us;184us;1862us;188us;1862us;190us;1862us;201us;1862us;237us;864us;251us;864us;274us;864us;290us;1862us;331us;864us;335us;864us;340us;864us;385us;1862us;419us;864us;422us;864us;424us;864us;427us;864us;439us;1862us;446us;1862us;454us;1862us;465us;864us;468us;864us;481us;1862us;491us;864us;497us;1862us;522us;1862us;525us;864us;561us;1862us;569us;1862us;570us;1862us;613us;1862us;626us;1862us;630us;1862us;635us;1862us;640us;1862us;643us;1862us;653us;1862us;664us;1862us;679us;1862us;681us;1862us;684us;1862us;688us;1862us;690us;864us;701us;864us;705us;1862us;708us;1862us;711us;1862us;714us;1862us;730us;1862us;744us;1862us;753us;864us;759us;864us;806us;864us;809us;864us;813us;864us;823us;864us;829us;1862us;873us;1862us;899us;864us;901us;864us;902us;864us;906us;864us;907us;864us;910us;864us;912us;864us;913us;864us;922us;864us;926us;864us;927us;864us;929us;864us;931us;864us;934us;864us;936us;864us;938us;1862us;941us;864us;945us;864us;947us;864us;949us;864us;957us;864us;960us;864us;971us;864us;979us;864us;1000us;864us;1002us;864us;1005us;1862us;1008us;864us;1009us;864us;1011us;864us;1012us;864us;1015us;864us;1017us;864us;1018us;864us;1024us;864us;1028us;864us;1030us;864us;1036us;864us;1046us;1862us;1052us;864us;1054us;864us;1057us;864us;1060us;864us;1078us;864us;1079us;864us;1083us;864us;1084us;864us;1090us;864us;1093us;864us;1096us;864us;1102us;864us;1106us;864us;1110us;864us;1116us;864us;1118us;864us;1123us;864us;1125us;864us;1127us;864us;1129us;864us;1131us;864us;1133us;864us;1135us;864us;1137us;864us;1147us;864us;1154us;864us;1160us;864us;1162us;864us;1166us;864us;1167us;864us;1171us;864us;1173us;864us;1174us;864us;1178us;864us;1181us;864us;1184us;864us;1186us;864us;1189us;864us;1191us;864us;1231us;1862us;1234us;1862us;1237us;1862us;1240us;864us;1242us;864us;1246us;864us;1248us;864us;1250us;864us;1252us;864us;1254us;864us;1256us;864us;1258us;864us;1260us;864us;1262us;864us;1264us;864us;1266us;864us;1268us;864us;1270us;864us;1272us;864us;1274us;864us;1276us;864us;1278us;864us;1280us;864us;1282us;864us;1284us;864us;1286us;864us;1287us;864us;1288us;864us;1289us;864us;1292us;864us;1302us;864us;1305us;864us;1307us;864us;1313us;864us;1320us;864us;1322us;864us;1327us;864us;1328us;864us;1332us;864us;1334us;864us;1337us;864us;1338us;864us;1340us;864us;1343us;864us;1345us;864us;1347us;864us;1349us;864us;1351us;864us;1352us;864us;1353us;864us;1354us;864us;1356us;864us;1357us;864us;1359us;864us;1360us;864us;1362us;864us;1363us;864us;1365us;864us;1366us;864us;1368us;864us;1369us;864us;1371us;864us;1372us;864us;1374us;1862us;1375us;1862us;1378us;864us;1379us;864us;1386us;864us;1388us;864us;1390us;864us;1391us;864us;1392us;864us;1395us;864us;1400us;864us;1408us;864us;1409us;864us;1412us;864us;1413us;864us;1431us;864us;1438us;864us;1445us;864us;1452us;864us;1469us;864us;1476us;864us;1477us;864us;1483us;864us;1489us;864us;1490us;864us;1491us;864us;1503us;864us;1509us;864us;1517us;1862us;1519us;864us;1532us;864us;1534us;864us;1537us;864us;1538us;864us;1544us;864us;1550us;1862us;1553us;1862us;1555us;1862us;1557us;1862us;1559us;864us;1564us;864us;1569us;864us;1594us;864us;1619us;1862us;1627us;864us;1634us;864us;1636us;864us;1639us;864us;1641us;864us;1651us;864us;1653us;864us;1657us;1862us;1659us;1862us;1660us;1862us;1664us;1862us;1668us;1862us;1671us;1862us;1674us;1862us;1677us;1862us;1679us;1862us;1681us;1862us;1686us;1862us;1690us;1862us;1695us;1862us;1700us;1862us;1703us;1862us;1706us;1862us;1709us;1862us;1714us;1862us;1717us;1862us;1719us;1862us;1722us;1862us;1726us;1862us;1729us;1862us;1731us;1862us;1734us;1862us;1737us;1862us;1739us;1862us;1751us;1862us;1757us;1862us;1760us;1862us;1827us;1862us;1831us;1862us;1837us;1862us;1844us;1862us;1848us;1862us;1854us;1862us;1855us;1862us;1864us;864us;1878us;1862us;1880us;1862us;1891us;1862us;2021us;864us;2025us;864us;1us;65535us;858us;859us;4us;65535us;862us;863us;1744us;861us;1835us;861us;1906us;861us;3us;65535us;1744us;1745us;1835us;1836us;1906us;1907us;207us;65535us;6us;1458us;31us;1458us;114us;1458us;116us;1458us;237us;1458us;251us;1458us;274us;1458us;331us;1458us;335us;1458us;340us;1458us;419us;967us;422us;1458us;424us;967us;427us;1458us;465us;967us;468us;1458us;491us;1458us;525us;1458us;690us;1458us;701us;1458us;753us;1458us;759us;1458us;806us;967us;809us;1458us;813us;1458us;823us;1458us;899us;967us;901us;967us;902us;967us;906us;967us;907us;967us;910us;967us;912us;967us;913us;967us;922us;967us;926us;967us;927us;967us;929us;967us;931us;967us;934us;967us;936us;967us;941us;967us;945us;967us;947us;967us;949us;967us;957us;967us;960us;967us;971us;967us;979us;967us;1000us;967us;1002us;967us;1008us;967us;1009us;967us;1011us;967us;1012us;967us;1015us;967us;1017us;967us;1018us;967us;1024us;967us;1028us;967us;1030us;1458us;1036us;1458us;1052us;1458us;1054us;1458us;1057us;1458us;1060us;1458us;1078us;967us;1079us;1458us;1083us;967us;1084us;1458us;1090us;1458us;1093us;1458us;1096us;1458us;1102us;1458us;1106us;1458us;1110us;1458us;1116us;1458us;1118us;1458us;1123us;1458us;1125us;1458us;1127us;1458us;1129us;1458us;1131us;1458us;1133us;1458us;1135us;967us;1137us;1458us;1147us;1458us;1154us;1458us;1160us;1458us;1162us;1458us;1166us;967us;1167us;1458us;1171us;1458us;1173us;967us;1174us;1458us;1178us;1458us;1181us;1458us;1184us;1458us;1186us;1458us;1189us;1458us;1191us;1458us;1240us;1458us;1242us;1458us;1246us;1458us;1248us;1458us;1250us;1458us;1252us;1458us;1254us;1458us;1256us;1458us;1258us;1458us;1260us;1458us;1262us;1458us;1264us;1458us;1266us;1458us;1268us;1458us;1270us;1458us;1272us;1458us;1274us;1458us;1276us;1458us;1278us;1458us;1280us;1458us;1282us;1458us;1284us;1458us;1286us;1458us;1287us;1458us;1288us;1458us;1289us;1458us;1292us;1458us;1302us;1458us;1305us;967us;1307us;967us;1313us;967us;1320us;967us;1322us;967us;1327us;1458us;1328us;1458us;1332us;1458us;1334us;1458us;1337us;1458us;1338us;1458us;1340us;1458us;1343us;1458us;1345us;1458us;1347us;1458us;1349us;1458us;1351us;1458us;1352us;1458us;1353us;1458us;1354us;1458us;1356us;1458us;1357us;1458us;1359us;1458us;1360us;1458us;1362us;1458us;1363us;1458us;1365us;1458us;1366us;1458us;1368us;1458us;1369us;1458us;1371us;1458us;1372us;1458us;1378us;1458us;1379us;1458us;1386us;1458us;1388us;1458us;1390us;1458us;1391us;1458us;1392us;1458us;1395us;1458us;1400us;1458us;1408us;1458us;1409us;1458us;1412us;1458us;1413us;1458us;1431us;1458us;1438us;1458us;1445us;1458us;1452us;1458us;1469us;1458us;1476us;1458us;1477us;1458us;1483us;1458us;1489us;1458us;1490us;1458us;1491us;1458us;1503us;1458us;1509us;1458us;1519us;1458us;1532us;1458us;1534us;1458us;1537us;1458us;1538us;1458us;1544us;1458us;1559us;1458us;1564us;1458us;1569us;1458us;1594us;1458us;1627us;1458us;1634us;967us;1636us;1458us;1639us;967us;1641us;1458us;1651us;967us;1653us;967us;1864us;1458us;2021us;1458us;2025us;1458us;3us;65535us;419us;420us;424us;425us;806us;807us;3us;65535us;876us;871us;877us;872us;880us;872us;2us;65535us;877us;878us;880us;881us;1us;65535us;365us;366us;1us;65535us;365us;879us;14us;65535us;419us;867us;424us;867us;806us;867us;901us;888us;902us;889us;906us;890us;907us;891us;910us;892us;912us;893us;913us;894us;1078us;895us;1083us;896us;1166us;897us;1173us;898us;14us;65535us;419us;903us;424us;903us;806us;903us;901us;903us;902us;903us;906us;903us;907us;903us;910us;903us;912us;903us;913us;903us;1078us;903us;1083us;903us;1166us;903us;1173us;903us;14us;65535us;419us;904us;424us;904us;806us;904us;901us;904us;902us;904us;906us;904us;907us;904us;910us;904us;912us;904us;913us;904us;1078us;904us;1083us;904us;1166us;904us;1173us;904us;3us;65535us;916us;917us;918us;919us;941us;942us;3us;65535us;916us;914us;918us;914us;941us;914us;40us;65535us;419us;905us;424us;905us;806us;905us;899us;900us;901us;905us;902us;905us;906us;905us;907us;905us;910us;905us;912us;905us;913us;905us;922us;1010us;941us;1010us;957us;1010us;960us;1010us;971us;1010us;979us;1010us;1000us;1001us;1002us;1010us;1008us;1010us;1009us;1010us;1011us;1010us;1012us;1010us;1015us;1010us;1017us;1010us;1018us;1010us;1024us;1010us;1028us;1010us;1078us;905us;1083us;905us;1135us;1010us;1166us;905us;1173us;905us;1305us;1010us;1307us;1010us;1313us;1010us;1320us;1010us;1322us;1010us;1651us;1010us;1653us;1010us;6us;65535us;926us;933us;927us;928us;929us;930us;931us;932us;934us;935us;936us;937us;11us;65535us;926us;944us;927us;944us;929us;944us;931us;944us;934us;944us;936us;944us;945us;946us;947us;948us;949us;950us;1634us;1635us;1639us;1640us;52us;65535us;419us;940us;424us;940us;465us;466us;806us;940us;899us;940us;901us;940us;902us;940us;906us;940us;907us;940us;910us;940us;912us;940us;913us;940us;922us;940us;926us;945us;927us;945us;929us;945us;931us;945us;934us;945us;936us;945us;941us;940us;945us;945us;947us;945us;949us;945us;957us;940us;960us;940us;971us;940us;979us;940us;1000us;940us;1002us;940us;1008us;940us;1009us;940us;1011us;940us;1012us;940us;1015us;940us;1017us;940us;1018us;940us;1024us;940us;1028us;940us;1078us;940us;1083us;940us;1135us;940us;1166us;940us;1173us;940us;1305us;940us;1307us;940us;1313us;940us;1320us;940us;1322us;940us;1634us;945us;1639us;945us;1651us;940us;1653us;940us;2us;65535us;941us;972us;971us;972us;24us;65535us;922us;923us;941us;986us;957us;997us;960us;997us;971us;986us;979us;994us;1002us;987us;1008us;988us;1009us;989us;1011us;990us;1012us;991us;1015us;992us;1017us;993us;1018us;995us;1024us;996us;1028us;997us;1135us;998us;1305us;999us;1307us;999us;1313us;999us;1320us;999us;1322us;999us;1651us;999us;1653us;999us;24us;65535us;922us;1003us;941us;1003us;957us;1003us;960us;1003us;971us;1003us;979us;980us;1002us;1003us;1008us;1003us;1009us;1003us;1011us;1003us;1012us;1003us;1015us;1003us;1017us;1003us;1018us;1003us;1024us;1003us;1028us;1003us;1135us;1003us;1305us;1003us;1307us;1003us;1313us;1003us;1320us;1003us;1322us;1003us;1651us;1003us;1653us;1003us;24us;65535us;922us;1004us;941us;1004us;957us;1004us;960us;1004us;971us;1004us;979us;1004us;1002us;1004us;1008us;1004us;1009us;1004us;1011us;1004us;1012us;1004us;1015us;1004us;1017us;1004us;1018us;1004us;1024us;1004us;1028us;1004us;1135us;1004us;1305us;1004us;1307us;1004us;1313us;1004us;1320us;1004us;1322us;1004us;1651us;1004us;1653us;1004us;2us;65535us;952us;953us;1021us;1022us;2us;65535us;952us;1019us;1021us;1019us;3us;65535us;957us;958us;960us;961us;1028us;1029us;27us;65535us;274us;1094us;422us;423us;427us;428us;468us;469us;491us;492us;753us;754us;759us;760us;823us;824us;1060us;1094us;1079us;1080us;1084us;1085us;1093us;1094us;1096us;1097us;1116us;1117us;1137us;1138us;1147us;1148us;1154us;1155us;1167us;1168us;1171us;1172us;1174us;1175us;1178us;1179us;1184us;1185us;1186us;1187us;1292us;1293us;1334us;1335us;1338us;1339us;1636us;1637us;6us;65535us;1127us;1128us;1129us;1130us;1242us;1243us;1564us;1565us;1569us;1570us;1594us;1595us;5us;65535us;1110us;1111us;1191us;1192us;1328us;1329us;1532us;1533us;1641us;1642us;52us;65535us;6us;1049us;274us;1035us;422us;1035us;427us;1035us;468us;1035us;491us;1035us;753us;1035us;759us;1035us;809us;818us;813us;818us;823us;1035us;1030us;1031us;1036us;1037us;1057us;1058us;1060us;1035us;1079us;1035us;1084us;1035us;1090us;1091us;1093us;1035us;1096us;1035us;1102us;1103us;1106us;1107us;1110us;1041us;1116us;1035us;1137us;1035us;1147us;1035us;1154us;1035us;1167us;1035us;1171us;1035us;1174us;1035us;1178us;1035us;1181us;1182us;1184us;1035us;1186us;1035us;1191us;1041us;1292us;1035us;1302us;1303us;1328us;1041us;1334us;1035us;1338us;1035us;1445us;1450us;1452us;1453us;1469us;1470us;1476us;1478us;1477us;1478us;1489us;1511us;1490us;1511us;1491us;1511us;1509us;1510us;1532us;1041us;1636us;1035us;1641us;1041us;1us;65535us;6us;7us;57us;65535us;6us;1045us;274us;1045us;422us;1045us;427us;1045us;468us;1045us;491us;1045us;753us;1045us;759us;1045us;809us;1045us;813us;1045us;823us;1045us;1030us;1045us;1036us;1045us;1052us;1053us;1054us;1055us;1057us;1045us;1060us;1045us;1079us;1045us;1084us;1045us;1090us;1045us;1093us;1045us;1096us;1045us;1102us;1045us;1106us;1045us;1110us;1045us;1116us;1045us;1137us;1045us;1147us;1045us;1154us;1045us;1167us;1045us;1171us;1045us;1174us;1045us;1178us;1045us;1181us;1045us;1184us;1045us;1186us;1045us;1191us;1045us;1292us;1045us;1302us;1045us;1328us;1045us;1334us;1045us;1338us;1045us;1431us;1529us;1445us;1045us;1452us;1045us;1469us;1045us;1476us;1045us;1477us;1045us;1483us;1530us;1489us;1045us;1490us;1045us;1491us;1045us;1509us;1045us;1519us;1531us;1532us;1045us;1636us;1045us;1641us;1045us;196us;65535us;53us;56us;58us;60us;75us;78us;153us;155us;159us;161us;163us;165us;167us;169us;190us;192us;210us;212us;242us;245us;284us;285us;287us;289us;290us;292us;297us;299us;300us;302us;307us;309us;317us;2066us;319us;2066us;367us;370us;375us;378us;389us;2066us;395us;396us;399us;400us;426us;430us;442us;445us;446us;449us;465us;473us;467us;2066us;479us;485us;480us;484us;481us;483us;488us;496us;490us;2066us;497us;499us;522us;2066us;530us;532us;538us;540us;564us;565us;575us;577us;585us;587us;595us;600us;678us;680us;681us;687us;684us;686us;705us;707us;728us;734us;729us;733us;730us;732us;739us;742us;744us;746us;757us;768us;760us;768us;808us;812us;814us;816us;873us;875us;880us;887us;881us;884us;906us;2066us;907us;2066us;910us;2066us;920us;925us;921us;925us;922us;924us;941us;977us;971us;977us;972us;974us;979us;985us;980us;982us;998us;1159us;1005us;1007us;1011us;2066us;1012us;2066us;1015us;2066us;1023us;1026us;1024us;1025us;1031us;1033us;1046us;1048us;1085us;768us;1103us;1105us;1107us;1109us;1110us;1043us;1111us;1113us;1118us;1122us;1119us;1121us;1131us;1299us;1133us;1299us;1135us;2066us;1136us;2066us;1137us;2066us;1138us;2066us;1146us;1153us;1147us;1152us;1148us;1150us;1160us;1164us;1162us;1165us;1175us;768us;1187us;768us;1191us;1043us;1216us;1298us;1220us;1342us;1231us;1233us;1234us;1236us;1237us;1239us;1245us;1440us;1246us;2066us;1248us;2066us;1250us;2066us;1252us;2066us;1254us;2066us;1256us;2066us;1258us;2066us;1260us;2066us;1262us;2066us;1264us;2066us;1266us;2066us;1268us;2066us;1270us;2066us;1272us;2066us;1274us;2066us;1276us;2066us;1278us;2066us;1280us;2066us;1282us;2066us;1284us;2066us;1293us;1295us;1307us;1311us;1308us;1310us;1318us;1326us;1319us;1325us;1320us;1324us;1328us;1043us;1332us;1333us;1334us;1336us;1343us;2066us;1345us;2066us;1347us;2066us;1349us;2066us;1382us;1444us;1398us;1403us;1399us;1403us;1400us;1402us;1419us;1444us;1422us;1444us;1431us;1436us;1432us;1434us;1452us;1457us;1453us;1455us;1470us;1472us;1476us;1482us;1477us;1482us;1478us;1480us;1483us;1488us;1484us;1486us;1489us;1502us;1490us;1502us;1491us;1502us;1493us;2060us;1519us;1524us;1520us;1522us;1532us;1043us;1534us;2066us;1564us;1568us;1593us;2066us;1594us;2066us;1627us;1632us;1628us;1630us;1641us;1044us;1642us;1644us;1660us;1662us;1664us;1666us;1668us;1670us;1674us;1676us;1681us;1683us;1686us;1688us;1690us;1692us;1695us;1697us;1700us;1702us;1706us;1708us;1714us;1716us;1719us;1721us;1722us;1724us;1726us;1728us;1731us;1733us;1746us;1860us;1830us;1883us;1849us;1852us;1850us;1852us;1854us;1861us;1855us;1859us;1856us;1858us;1873us;2066us;1878us;1889us;1880us;2066us;1885us;2066us;1926us;2066us;1976us;2066us;4us;65535us;1081us;1082us;1087us;1088us;1170us;1171us;1177us;1178us;116us;65535us;6us;1051us;31us;32us;114us;115us;116us;117us;237us;252us;251us;252us;274us;1051us;422us;1051us;427us;1051us;468us;1051us;491us;1051us;753us;1051us;759us;1051us;809us;1051us;813us;1051us;823us;1051us;1030us;1051us;1036us;1051us;1052us;1051us;1054us;1051us;1057us;1051us;1060us;1051us;1079us;1051us;1084us;1051us;1090us;1051us;1093us;1051us;1096us;1051us;1102us;1051us;1106us;1051us;1110us;1051us;1116us;1051us;1118us;1119us;1123us;1124us;1125us;1126us;1127us;1040us;1129us;1040us;1131us;1216us;1133us;1216us;1137us;1051us;1147us;1051us;1154us;1051us;1160us;1161us;1162us;1163us;1167us;1051us;1171us;1051us;1174us;1051us;1178us;1051us;1181us;1051us;1184us;1051us;1186us;1051us;1189us;1190us;1191us;1051us;1240us;1193us;1242us;1040us;1246us;1194us;1248us;1195us;1250us;1196us;1252us;1197us;1254us;1198us;1256us;1199us;1258us;1200us;1260us;1201us;1262us;1202us;1264us;1203us;1266us;1204us;1268us;1205us;1270us;1206us;1272us;1207us;1274us;1208us;1276us;1209us;1278us;1210us;1280us;1211us;1282us;1212us;1284us;1213us;1286us;1214us;1287us;1215us;1288us;1215us;1289us;1215us;1292us;1051us;1302us;1051us;1327us;1217us;1328us;1051us;1332us;1218us;1334us;1051us;1337us;1219us;1338us;1051us;1340us;1220us;1343us;1221us;1345us;1222us;1347us;1223us;1349us;1225us;1431us;1051us;1438us;1224us;1445us;1051us;1452us;1051us;1469us;1051us;1476us;1051us;1477us;1051us;1483us;1051us;1489us;1051us;1490us;1051us;1491us;1051us;1503us;1226us;1509us;1051us;1519us;1051us;1532us;1051us;1534us;1227us;1537us;1228us;1538us;1229us;1564us;1040us;1569us;1040us;1594us;1040us;1636us;1051us;1641us;1051us;2021us;1230us;2025us;1230us;2us;65535us;1131us;1132us;1133us;1134us;1us;65535us;1427us;1428us;4us;65535us;1103us;1104us;1107us;1108us;1111us;1112us;1114us;1115us;4us;65535us;1305us;1306us;1307us;1308us;1651us;1652us;1653us;1654us;7us;65535us;1305us;1318us;1307us;1318us;1313us;1318us;1320us;1318us;1322us;1318us;1651us;1318us;1653us;1318us;7us;65535us;1305us;1312us;1307us;1312us;1313us;1314us;1320us;1321us;1322us;1323us;1651us;1312us;1653us;1312us;1us;65535us;999us;1317us;1us;65535us;1318us;1319us;2us;65535us;1119us;1120us;1220us;1341us;2us;65535us;1119us;1330us;1220us;1330us;1us;65535us;1330us;1331us;116us;65535us;6us;1244us;31us;1244us;114us;1244us;116us;1244us;237us;1244us;251us;1244us;274us;1244us;422us;1244us;427us;1244us;468us;1244us;491us;1244us;753us;1244us;759us;1244us;809us;1244us;813us;1244us;823us;1244us;1030us;1244us;1036us;1244us;1052us;1244us;1054us;1244us;1057us;1244us;1060us;1244us;1079us;1244us;1084us;1244us;1090us;1244us;1093us;1244us;1096us;1244us;1102us;1244us;1106us;1244us;1110us;1244us;1116us;1244us;1118us;1244us;1123us;1244us;1125us;1244us;1127us;1244us;1129us;1244us;1131us;1244us;1133us;1244us;1137us;1244us;1147us;1244us;1154us;1244us;1160us;1244us;1162us;1244us;1167us;1244us;1171us;1244us;1174us;1244us;1178us;1244us;1181us;1244us;1184us;1244us;1186us;1244us;1189us;1244us;1191us;1244us;1240us;1244us;1242us;1244us;1246us;1244us;1248us;1244us;1250us;1244us;1252us;1244us;1254us;1244us;1256us;1244us;1258us;1244us;1260us;1244us;1262us;1244us;1264us;1244us;1266us;1244us;1268us;1244us;1270us;1244us;1272us;1244us;1274us;1244us;1276us;1244us;1278us;1244us;1280us;1244us;1282us;1244us;1284us;1244us;1286us;1244us;1287us;1244us;1288us;1244us;1289us;1244us;1292us;1244us;1302us;1244us;1327us;1244us;1328us;1244us;1332us;1244us;1334us;1244us;1337us;1244us;1338us;1244us;1340us;1244us;1343us;1244us;1345us;1244us;1347us;1244us;1349us;1244us;1431us;1244us;1438us;1245us;1445us;1244us;1452us;1244us;1469us;1244us;1476us;1244us;1477us;1244us;1483us;1244us;1489us;1244us;1490us;1244us;1491us;1244us;1503us;1244us;1509us;1244us;1519us;1244us;1532us;1244us;1534us;1244us;1537us;1244us;1538us;1244us;1564us;1244us;1569us;1244us;1594us;1244us;1636us;1244us;1641us;1244us;2021us;1244us;2025us;1244us;134us;65535us;6us;1241us;31us;1241us;114us;1241us;116us;1241us;237us;1241us;251us;1241us;274us;1241us;422us;1241us;427us;1241us;468us;1241us;491us;1241us;753us;1241us;759us;1241us;809us;1241us;813us;1241us;823us;1241us;1030us;1241us;1036us;1241us;1052us;1241us;1054us;1241us;1057us;1241us;1060us;1241us;1079us;1241us;1084us;1241us;1090us;1241us;1093us;1241us;1096us;1241us;1102us;1241us;1106us;1241us;1110us;1241us;1116us;1241us;1118us;1241us;1123us;1241us;1125us;1241us;1127us;1241us;1129us;1241us;1131us;1241us;1133us;1241us;1137us;1241us;1147us;1241us;1154us;1241us;1160us;1241us;1162us;1241us;1167us;1241us;1171us;1241us;1174us;1241us;1178us;1241us;1181us;1241us;1184us;1241us;1186us;1241us;1189us;1241us;1191us;1241us;1240us;1241us;1242us;1241us;1246us;1241us;1248us;1241us;1250us;1241us;1252us;1241us;1254us;1241us;1256us;1241us;1258us;1241us;1260us;1241us;1262us;1241us;1264us;1241us;1266us;1241us;1268us;1241us;1270us;1241us;1272us;1241us;1274us;1241us;1276us;1241us;1278us;1241us;1280us;1241us;1282us;1241us;1284us;1241us;1286us;1241us;1287us;1241us;1288us;1241us;1289us;1241us;1292us;1241us;1302us;1241us;1327us;1241us;1328us;1241us;1332us;1241us;1334us;1241us;1337us;1241us;1338us;1241us;1340us;1241us;1343us;1241us;1345us;1241us;1347us;1241us;1349us;1241us;1351us;1355us;1352us;1355us;1353us;1355us;1354us;1355us;1356us;1358us;1357us;1358us;1359us;1361us;1360us;1361us;1362us;1364us;1363us;1364us;1365us;1367us;1366us;1367us;1368us;1370us;1369us;1370us;1371us;1373us;1372us;1373us;1386us;1387us;1388us;1389us;1431us;1241us;1438us;1241us;1445us;1241us;1452us;1241us;1469us;1241us;1476us;1241us;1477us;1241us;1483us;1241us;1489us;1241us;1490us;1241us;1491us;1241us;1503us;1241us;1509us;1241us;1519us;1241us;1532us;1241us;1534us;1241us;1537us;1241us;1538us;1241us;1564us;1241us;1569us;1241us;1594us;1241us;1636us;1241us;1641us;1241us;2021us;1241us;2025us;1241us;135us;65535us;6us;1390us;31us;1390us;114us;1390us;116us;1390us;237us;1390us;251us;1390us;274us;1390us;422us;1390us;427us;1390us;468us;1390us;491us;1390us;753us;1390us;759us;1390us;809us;1390us;813us;1390us;823us;1390us;1030us;1390us;1036us;1390us;1052us;1390us;1054us;1390us;1057us;1390us;1060us;1390us;1079us;1390us;1084us;1390us;1090us;1390us;1093us;1390us;1096us;1390us;1102us;1390us;1106us;1390us;1110us;1390us;1116us;1390us;1118us;1390us;1123us;1390us;1125us;1390us;1127us;1390us;1129us;1390us;1131us;1390us;1133us;1390us;1137us;1390us;1147us;1390us;1154us;1390us;1160us;1390us;1162us;1390us;1167us;1390us;1171us;1390us;1174us;1390us;1178us;1390us;1181us;1390us;1184us;1390us;1186us;1390us;1189us;1390us;1191us;1390us;1240us;1390us;1242us;1390us;1246us;1390us;1248us;1390us;1250us;1390us;1252us;1390us;1254us;1390us;1256us;1390us;1258us;1390us;1260us;1390us;1262us;1390us;1264us;1390us;1266us;1390us;1268us;1390us;1270us;1390us;1272us;1390us;1274us;1390us;1276us;1390us;1278us;1390us;1280us;1390us;1282us;1390us;1284us;1390us;1286us;1390us;1287us;1390us;1288us;1390us;1289us;1390us;1292us;1390us;1302us;1390us;1327us;1390us;1328us;1390us;1332us;1390us;1334us;1390us;1337us;1390us;1338us;1390us;1340us;1390us;1343us;1390us;1345us;1390us;1347us;1390us;1349us;1390us;1351us;1390us;1352us;1390us;1353us;1390us;1354us;1390us;1356us;1390us;1357us;1390us;1359us;1390us;1360us;1390us;1362us;1390us;1363us;1390us;1365us;1390us;1366us;1390us;1368us;1390us;1369us;1390us;1371us;1390us;1372us;1390us;1386us;1390us;1388us;1390us;1431us;1390us;1438us;1390us;1445us;1390us;1452us;1390us;1469us;1390us;1476us;1390us;1477us;1390us;1483us;1390us;1489us;1390us;1490us;1390us;1491us;1390us;1503us;1390us;1509us;1390us;1519us;1391us;1532us;1390us;1534us;1390us;1537us;1390us;1538us;1390us;1564us;1390us;1569us;1390us;1594us;1390us;1627us;1392us;1636us;1390us;1641us;1390us;2021us;1390us;2025us;1390us;4us;65535us;1390us;1393us;1391us;1393us;1392us;1393us;1544us;1547us;148us;65535us;6us;1394us;31us;1394us;114us;1394us;116us;1394us;237us;1394us;251us;1394us;274us;1394us;422us;1394us;427us;1394us;468us;1394us;491us;1394us;690us;691us;701us;702us;753us;1394us;759us;1394us;809us;1394us;813us;1394us;823us;1394us;1030us;1394us;1036us;1394us;1052us;1394us;1054us;1394us;1057us;1394us;1060us;1394us;1079us;1394us;1084us;1394us;1090us;1394us;1093us;1394us;1096us;1394us;1102us;1394us;1106us;1394us;1110us;1394us;1116us;1394us;1118us;1394us;1123us;1394us;1125us;1394us;1127us;1394us;1129us;1394us;1131us;1394us;1133us;1394us;1137us;1394us;1147us;1394us;1154us;1394us;1160us;1394us;1162us;1394us;1167us;1394us;1171us;1394us;1174us;1394us;1178us;1394us;1181us;1394us;1184us;1394us;1186us;1394us;1189us;1394us;1191us;1394us;1240us;1394us;1242us;1394us;1246us;1394us;1248us;1394us;1250us;1394us;1252us;1394us;1254us;1394us;1256us;1394us;1258us;1394us;1260us;1394us;1262us;1394us;1264us;1394us;1266us;1394us;1268us;1394us;1270us;1394us;1272us;1394us;1274us;1394us;1276us;1394us;1278us;1394us;1280us;1394us;1282us;1394us;1284us;1394us;1286us;1394us;1287us;1394us;1288us;1394us;1289us;1394us;1292us;1394us;1302us;1394us;1327us;1394us;1328us;1394us;1332us;1394us;1334us;1394us;1337us;1394us;1338us;1394us;1340us;1394us;1343us;1394us;1345us;1394us;1347us;1394us;1349us;1394us;1351us;1394us;1352us;1394us;1353us;1394us;1354us;1394us;1356us;1394us;1357us;1394us;1359us;1394us;1360us;1394us;1362us;1394us;1363us;1394us;1365us;1394us;1366us;1394us;1368us;1394us;1369us;1394us;1371us;1394us;1372us;1394us;1386us;1394us;1388us;1394us;1390us;1397us;1391us;1397us;1392us;1397us;1395us;1396us;1400us;1401us;1408us;1404us;1409us;1405us;1412us;1406us;1413us;1406us;1431us;1394us;1438us;1394us;1445us;1394us;1452us;1394us;1469us;1394us;1476us;1394us;1477us;1394us;1483us;1394us;1489us;1394us;1490us;1394us;1491us;1394us;1503us;1394us;1509us;1394us;1519us;1394us;1532us;1394us;1534us;1394us;1537us;1394us;1538us;1394us;1544us;1397us;1564us;1394us;1569us;1394us;1594us;1394us;1627us;1394us;1636us;1394us;1641us;1394us;1864us;1407us;2021us;1394us;2025us;1394us;3us;65535us;1382us;1383us;1419us;1420us;1422us;1423us;155us;65535us;6us;1441us;31us;1441us;114us;1441us;116us;1441us;237us;1441us;251us;1441us;274us;1441us;331us;1548us;335us;1548us;340us;1548us;422us;1441us;427us;1441us;468us;1441us;491us;1441us;525us;526us;690us;1441us;701us;1441us;753us;1441us;759us;1441us;809us;1441us;813us;1441us;823us;1441us;1030us;1441us;1036us;1441us;1052us;1441us;1054us;1441us;1057us;1441us;1060us;1441us;1079us;1441us;1084us;1441us;1090us;1441us;1093us;1441us;1096us;1441us;1102us;1441us;1106us;1441us;1110us;1441us;1116us;1441us;1118us;1441us;1123us;1441us;1125us;1441us;1127us;1441us;1129us;1441us;1131us;1441us;1133us;1441us;1137us;1441us;1147us;1441us;1154us;1441us;1160us;1441us;1162us;1441us;1167us;1441us;1171us;1441us;1174us;1441us;1178us;1441us;1181us;1441us;1184us;1441us;1186us;1441us;1189us;1441us;1191us;1441us;1240us;1441us;1242us;1441us;1246us;1441us;1248us;1441us;1250us;1441us;1252us;1441us;1254us;1441us;1256us;1441us;1258us;1441us;1260us;1441us;1262us;1441us;1264us;1441us;1266us;1441us;1268us;1441us;1270us;1441us;1272us;1441us;1274us;1441us;1276us;1441us;1278us;1441us;1280us;1441us;1282us;1441us;1284us;1441us;1286us;1441us;1287us;1441us;1288us;1441us;1289us;1441us;1292us;1441us;1302us;1441us;1327us;1441us;1328us;1441us;1332us;1441us;1334us;1441us;1337us;1441us;1338us;1441us;1340us;1441us;1343us;1441us;1345us;1441us;1347us;1441us;1349us;1441us;1351us;1441us;1352us;1441us;1353us;1441us;1354us;1441us;1356us;1441us;1357us;1441us;1359us;1441us;1360us;1441us;1362us;1441us;1363us;1441us;1365us;1441us;1366us;1441us;1368us;1441us;1369us;1441us;1371us;1441us;1372us;1441us;1378us;1380us;1379us;1381us;1386us;1441us;1388us;1441us;1390us;1441us;1391us;1441us;1392us;1441us;1395us;1441us;1400us;1441us;1408us;1441us;1409us;1441us;1412us;1441us;1413us;1441us;1431us;1441us;1438us;1441us;1445us;1441us;1452us;1441us;1469us;1441us;1476us;1441us;1477us;1441us;1483us;1441us;1489us;1441us;1490us;1441us;1491us;1441us;1503us;1441us;1509us;1441us;1519us;1441us;1532us;1441us;1534us;1441us;1537us;1441us;1538us;1441us;1544us;1441us;1559us;1548us;1564us;1441us;1569us;1441us;1594us;1441us;1627us;1441us;1636us;1441us;1641us;1441us;1864us;1441us;2021us;1441us;2025us;1441us;155us;65535us;6us;1468us;31us;1468us;114us;1468us;116us;1468us;237us;1468us;251us;1468us;274us;1468us;331us;1468us;335us;1468us;340us;1468us;422us;1468us;427us;1468us;468us;1468us;491us;1468us;525us;1468us;690us;1468us;701us;1468us;753us;1468us;759us;1468us;809us;1468us;813us;1468us;823us;1468us;1030us;1468us;1036us;1468us;1052us;1468us;1054us;1468us;1057us;1468us;1060us;1468us;1079us;1468us;1084us;1468us;1090us;1468us;1093us;1468us;1096us;1468us;1102us;1468us;1106us;1468us;1110us;1468us;1116us;1468us;1118us;1468us;1123us;1468us;1125us;1468us;1127us;1468us;1129us;1468us;1131us;1468us;1133us;1468us;1137us;1468us;1147us;1468us;1154us;1468us;1160us;1468us;1162us;1468us;1167us;1468us;1171us;1468us;1174us;1468us;1178us;1468us;1181us;1468us;1184us;1468us;1186us;1468us;1189us;1468us;1191us;1468us;1240us;1468us;1242us;1468us;1246us;1468us;1248us;1468us;1250us;1468us;1252us;1468us;1254us;1468us;1256us;1468us;1258us;1468us;1260us;1468us;1262us;1468us;1264us;1468us;1266us;1468us;1268us;1468us;1270us;1468us;1272us;1468us;1274us;1468us;1276us;1468us;1278us;1468us;1280us;1468us;1282us;1468us;1284us;1468us;1286us;1468us;1287us;1468us;1288us;1468us;1289us;1468us;1292us;1468us;1302us;1468us;1327us;1468us;1328us;1468us;1332us;1468us;1334us;1468us;1337us;1468us;1338us;1468us;1340us;1468us;1343us;1468us;1345us;1468us;1347us;1468us;1349us;1468us;1351us;1468us;1352us;1468us;1353us;1468us;1354us;1468us;1356us;1468us;1357us;1468us;1359us;1468us;1360us;1468us;1362us;1468us;1363us;1468us;1365us;1468us;1366us;1468us;1368us;1468us;1369us;1468us;1371us;1468us;1372us;1468us;1378us;1468us;1379us;1468us;1386us;1468us;1388us;1468us;1390us;1468us;1391us;1468us;1392us;1468us;1395us;1468us;1400us;1468us;1408us;1468us;1409us;1468us;1412us;1468us;1413us;1468us;1431us;1468us;1438us;1468us;1445us;1468us;1452us;1468us;1469us;1468us;1476us;1468us;1477us;1468us;1483us;1468us;1489us;1468us;1490us;1468us;1491us;1468us;1503us;1468us;1509us;1468us;1519us;1468us;1532us;1468us;1534us;1468us;1537us;1468us;1538us;1468us;1544us;1468us;1559us;1468us;1564us;1468us;1569us;1468us;1594us;1468us;1627us;1468us;1636us;1468us;1641us;1468us;1864us;1468us;2021us;1468us;2025us;1468us;207us;65535us;6us;1466us;31us;1466us;114us;1466us;116us;1466us;237us;1466us;251us;1466us;274us;1466us;331us;1466us;335us;1466us;340us;1466us;419us;951us;422us;1466us;424us;951us;427us;1466us;465us;951us;468us;1466us;491us;1466us;525us;1466us;690us;1466us;701us;1466us;753us;1466us;759us;1466us;806us;951us;809us;1466us;813us;1466us;823us;1466us;899us;951us;901us;951us;902us;951us;906us;951us;907us;951us;910us;951us;912us;951us;913us;951us;922us;951us;926us;951us;927us;951us;929us;951us;931us;951us;934us;951us;936us;951us;941us;951us;945us;951us;947us;951us;949us;951us;957us;951us;960us;951us;971us;951us;979us;951us;1000us;951us;1002us;951us;1008us;951us;1009us;951us;1011us;951us;1012us;951us;1015us;951us;1017us;951us;1018us;951us;1024us;951us;1028us;951us;1030us;1466us;1036us;1466us;1052us;1466us;1054us;1466us;1057us;1466us;1060us;1466us;1078us;951us;1079us;1466us;1083us;951us;1084us;1466us;1090us;1466us;1093us;1466us;1096us;1466us;1102us;1466us;1106us;1466us;1110us;1466us;1116us;1466us;1118us;1466us;1123us;1466us;1125us;1466us;1127us;1466us;1129us;1466us;1131us;1466us;1133us;1466us;1135us;951us;1137us;1466us;1147us;1466us;1154us;1466us;1160us;1466us;1162us;1466us;1166us;951us;1167us;1466us;1171us;1466us;1173us;951us;1174us;1466us;1178us;1466us;1181us;1466us;1184us;1466us;1186us;1466us;1189us;1466us;1191us;1466us;1240us;1466us;1242us;1466us;1246us;1466us;1248us;1466us;1250us;1466us;1252us;1466us;1254us;1466us;1256us;1466us;1258us;1466us;1260us;1466us;1262us;1466us;1264us;1466us;1266us;1466us;1268us;1466us;1270us;1466us;1272us;1466us;1274us;1466us;1276us;1466us;1278us;1466us;1280us;1466us;1282us;1466us;1284us;1466us;1286us;1466us;1287us;1466us;1288us;1466us;1289us;1466us;1292us;1466us;1302us;1466us;1305us;951us;1307us;951us;1313us;951us;1320us;951us;1322us;951us;1327us;1466us;1328us;1466us;1332us;1466us;1334us;1466us;1337us;1466us;1338us;1466us;1340us;1466us;1343us;1466us;1345us;1466us;1347us;1466us;1349us;1466us;1351us;1466us;1352us;1466us;1353us;1466us;1354us;1466us;1356us;1466us;1357us;1466us;1359us;1466us;1360us;1466us;1362us;1466us;1363us;1466us;1365us;1466us;1366us;1466us;1368us;1466us;1369us;1466us;1371us;1466us;1372us;1466us;1378us;1466us;1379us;1466us;1386us;1466us;1388us;1466us;1390us;1466us;1391us;1466us;1392us;1466us;1395us;1466us;1400us;1466us;1408us;1466us;1409us;1466us;1412us;1466us;1413us;1466us;1431us;1466us;1438us;1466us;1445us;1466us;1452us;1466us;1469us;1466us;1476us;1466us;1477us;1466us;1483us;1466us;1489us;1466us;1490us;1466us;1491us;1466us;1503us;1466us;1509us;1466us;1519us;1466us;1532us;1466us;1534us;1466us;1537us;1466us;1538us;1466us;1544us;1466us;1559us;1466us;1564us;1466us;1569us;1466us;1594us;1466us;1627us;1466us;1634us;951us;1636us;1466us;1639us;951us;1641us;1466us;1651us;951us;1653us;951us;1864us;1466us;2021us;1466us;2025us;1466us;155us;65535us;6us;1467us;31us;1467us;114us;1467us;116us;1467us;237us;1467us;251us;1467us;274us;1467us;331us;1467us;335us;1467us;340us;1467us;422us;1467us;427us;1467us;468us;1467us;491us;1467us;525us;1467us;690us;1467us;701us;1467us;753us;1467us;759us;1467us;809us;1467us;813us;1467us;823us;1467us;1030us;1467us;1036us;1467us;1052us;1467us;1054us;1467us;1057us;1467us;1060us;1467us;1079us;1467us;1084us;1467us;1090us;1467us;1093us;1467us;1096us;1467us;1102us;1467us;1106us;1467us;1110us;1467us;1116us;1467us;1118us;1467us;1123us;1467us;1125us;1467us;1127us;1467us;1129us;1467us;1131us;1467us;1133us;1467us;1137us;1467us;1147us;1467us;1154us;1467us;1160us;1467us;1162us;1467us;1167us;1467us;1171us;1467us;1174us;1467us;1178us;1467us;1181us;1467us;1184us;1467us;1186us;1467us;1189us;1467us;1191us;1467us;1240us;1467us;1242us;1467us;1246us;1467us;1248us;1467us;1250us;1467us;1252us;1467us;1254us;1467us;1256us;1467us;1258us;1467us;1260us;1467us;1262us;1467us;1264us;1467us;1266us;1467us;1268us;1467us;1270us;1467us;1272us;1467us;1274us;1467us;1276us;1467us;1278us;1467us;1280us;1467us;1282us;1467us;1284us;1467us;1286us;1467us;1287us;1467us;1288us;1467us;1289us;1467us;1292us;1467us;1302us;1467us;1327us;1467us;1328us;1467us;1332us;1467us;1334us;1467us;1337us;1467us;1338us;1467us;1340us;1467us;1343us;1467us;1345us;1467us;1347us;1467us;1349us;1467us;1351us;1467us;1352us;1467us;1353us;1467us;1354us;1467us;1356us;1467us;1357us;1467us;1359us;1467us;1360us;1467us;1362us;1467us;1363us;1467us;1365us;1467us;1366us;1467us;1368us;1467us;1369us;1467us;1371us;1467us;1372us;1467us;1378us;1467us;1379us;1467us;1386us;1467us;1388us;1467us;1390us;1467us;1391us;1467us;1392us;1467us;1395us;1467us;1400us;1467us;1408us;1467us;1409us;1467us;1412us;1467us;1413us;1467us;1431us;1467us;1438us;1467us;1445us;1467us;1452us;1467us;1469us;1467us;1476us;1467us;1477us;1467us;1483us;1467us;1489us;1467us;1490us;1467us;1491us;1467us;1503us;1467us;1509us;1467us;1519us;1467us;1532us;1467us;1534us;1467us;1537us;1467us;1538us;1467us;1544us;1467us;1559us;1467us;1564us;1467us;1569us;1467us;1594us;1467us;1627us;1467us;1636us;1467us;1641us;1467us;1864us;1467us;2021us;1467us;2025us;1467us;155us;65535us;6us;1459us;31us;1459us;114us;1459us;116us;1459us;237us;1459us;251us;1459us;274us;1459us;331us;1459us;335us;1459us;340us;1459us;422us;1459us;427us;1459us;468us;1459us;491us;1459us;525us;1459us;690us;1459us;701us;1459us;753us;1459us;759us;1459us;809us;1459us;813us;1459us;823us;1459us;1030us;1459us;1036us;1459us;1052us;1459us;1054us;1459us;1057us;1459us;1060us;1459us;1079us;1459us;1084us;1459us;1090us;1459us;1093us;1459us;1096us;1459us;1102us;1459us;1106us;1459us;1110us;1459us;1116us;1459us;1118us;1459us;1123us;1459us;1125us;1459us;1127us;1459us;1129us;1459us;1131us;1459us;1133us;1459us;1137us;1459us;1147us;1459us;1154us;1459us;1160us;1459us;1162us;1459us;1167us;1459us;1171us;1459us;1174us;1459us;1178us;1459us;1181us;1459us;1184us;1459us;1186us;1459us;1189us;1459us;1191us;1459us;1240us;1459us;1242us;1459us;1246us;1459us;1248us;1459us;1250us;1459us;1252us;1459us;1254us;1459us;1256us;1459us;1258us;1459us;1260us;1459us;1262us;1459us;1264us;1459us;1266us;1459us;1268us;1459us;1270us;1459us;1272us;1459us;1274us;1459us;1276us;1459us;1278us;1459us;1280us;1459us;1282us;1459us;1284us;1459us;1286us;1459us;1287us;1459us;1288us;1459us;1289us;1459us;1292us;1459us;1302us;1459us;1327us;1459us;1328us;1459us;1332us;1459us;1334us;1459us;1337us;1459us;1338us;1459us;1340us;1459us;1343us;1459us;1345us;1459us;1347us;1459us;1349us;1459us;1351us;1459us;1352us;1459us;1353us;1459us;1354us;1459us;1356us;1459us;1357us;1459us;1359us;1459us;1360us;1459us;1362us;1459us;1363us;1459us;1365us;1459us;1366us;1459us;1368us;1459us;1369us;1459us;1371us;1459us;1372us;1459us;1378us;1459us;1379us;1459us;1386us;1459us;1388us;1459us;1390us;1459us;1391us;1459us;1392us;1459us;1395us;1459us;1400us;1459us;1408us;1459us;1409us;1459us;1412us;1459us;1413us;1459us;1431us;1459us;1438us;1459us;1445us;1459us;1452us;1459us;1469us;1459us;1476us;1459us;1477us;1459us;1483us;1459us;1489us;1459us;1490us;1459us;1491us;1459us;1503us;1459us;1509us;1459us;1519us;1459us;1532us;1459us;1534us;1459us;1537us;1459us;1538us;1459us;1544us;1459us;1559us;1459us;1564us;1459us;1569us;1459us;1594us;1459us;1627us;1459us;1636us;1459us;1641us;1459us;1864us;1459us;2021us;1459us;2025us;1459us;3us;65535us;1489us;1493us;1490us;1493us;1491us;1493us;3us;65535us;1489us;1505us;1490us;1505us;1491us;1505us;1us;65535us;1490us;1515us;155us;65535us;6us;1460us;31us;1460us;114us;1460us;116us;1460us;237us;1460us;251us;1460us;274us;1460us;331us;1460us;335us;1460us;340us;1460us;422us;1460us;427us;1460us;468us;1460us;491us;1460us;525us;1460us;690us;1460us;701us;1460us;753us;1460us;759us;1460us;809us;1460us;813us;1460us;823us;1460us;1030us;1460us;1036us;1460us;1052us;1460us;1054us;1460us;1057us;1460us;1060us;1460us;1079us;1460us;1084us;1460us;1090us;1460us;1093us;1460us;1096us;1460us;1102us;1460us;1106us;1460us;1110us;1460us;1116us;1460us;1118us;1460us;1123us;1460us;1125us;1460us;1127us;1460us;1129us;1460us;1131us;1460us;1133us;1460us;1137us;1460us;1147us;1460us;1154us;1460us;1160us;1460us;1162us;1460us;1167us;1460us;1171us;1460us;1174us;1460us;1178us;1460us;1181us;1460us;1184us;1460us;1186us;1460us;1189us;1460us;1191us;1460us;1240us;1460us;1242us;1460us;1246us;1460us;1248us;1460us;1250us;1460us;1252us;1460us;1254us;1460us;1256us;1460us;1258us;1460us;1260us;1460us;1262us;1460us;1264us;1460us;1266us;1460us;1268us;1460us;1270us;1460us;1272us;1460us;1274us;1460us;1276us;1460us;1278us;1460us;1280us;1460us;1282us;1460us;1284us;1460us;1286us;1460us;1287us;1460us;1288us;1460us;1289us;1460us;1292us;1460us;1302us;1460us;1327us;1460us;1328us;1460us;1332us;1460us;1334us;1460us;1337us;1460us;1338us;1460us;1340us;1460us;1343us;1460us;1345us;1460us;1347us;1460us;1349us;1460us;1351us;1460us;1352us;1460us;1353us;1460us;1354us;1460us;1356us;1460us;1357us;1460us;1359us;1460us;1360us;1460us;1362us;1460us;1363us;1460us;1365us;1460us;1366us;1460us;1368us;1460us;1369us;1460us;1371us;1460us;1372us;1460us;1378us;1460us;1379us;1460us;1386us;1460us;1388us;1460us;1390us;1460us;1391us;1460us;1392us;1460us;1395us;1460us;1400us;1460us;1408us;1460us;1409us;1460us;1412us;1460us;1413us;1460us;1431us;1460us;1438us;1460us;1445us;1460us;1452us;1460us;1469us;1460us;1476us;1460us;1477us;1460us;1483us;1460us;1489us;1460us;1490us;1460us;1491us;1460us;1503us;1460us;1509us;1460us;1519us;1460us;1532us;1460us;1534us;1460us;1537us;1460us;1538us;1460us;1544us;1460us;1559us;1460us;1564us;1460us;1569us;1460us;1594us;1460us;1627us;1460us;1636us;1460us;1641us;1460us;1864us;1460us;2021us;1460us;2025us;1460us;1us;65535us;1519us;1520us;1us;65535us;1431us;1432us;1us;65535us;1483us;1484us;1us;65535us;1519us;1528us;1us;65535us;1144us;1145us;1us;65535us;1135us;1136us;1us;65535us;1135us;1146us;1us;65535us;1228us;1538us;3us;65535us;1489us;1512us;1490us;1512us;1491us;1512us;1us;65535us;1543us;1544us;4us;65535us;331us;332us;335us;336us;340us;341us;1559us;1560us;1us;65535us;1542us;1543us;1us;65535us;1544us;1545us;1us;65535us;1519us;1526us;2us;65535us;1519us;1563us;1627us;1628us;6us;65535us;1561us;1562us;1566us;1567us;1571us;1572us;1575us;1576us;1577us;1578us;1581us;1582us;6us;65535us;1561us;1585us;1566us;1585us;1571us;1585us;1575us;1585us;1577us;1584us;1581us;1585us;3us;65535us;1573us;1593us;1577us;1593us;1585us;1593us;5us;65535us;1560us;1561us;1565us;1566us;1570us;1571us;1574us;1575us;1580us;1581us;3us;65535us;1573us;1574us;1577us;1580us;1585us;1592us;1us;65535us;1519us;1527us;1us;65535us;1519us;1598us;1us;65535us;1620us;1621us;2us;65535us;1598us;1599us;1620us;1605us;1us;65535us;1602us;1603us;4us;65535us;1600us;1601us;1613us;1614us;1615us;1616us;1617us;1618us;5us;65535us;1600us;1615us;1602us;1613us;1613us;1615us;1615us;1615us;1617us;1615us;155us;65535us;6us;1461us;31us;1461us;114us;1461us;116us;1461us;237us;1461us;251us;1461us;274us;1461us;331us;1461us;335us;1461us;340us;1461us;422us;1461us;427us;1461us;468us;1461us;491us;1461us;525us;1461us;690us;1461us;701us;1461us;753us;1461us;759us;1461us;809us;1461us;813us;1461us;823us;1461us;1030us;1461us;1036us;1461us;1052us;1461us;1054us;1461us;1057us;1461us;1060us;1461us;1079us;1461us;1084us;1461us;1090us;1461us;1093us;1461us;1096us;1461us;1102us;1461us;1106us;1461us;1110us;1461us;1116us;1461us;1118us;1461us;1123us;1461us;1125us;1461us;1127us;1461us;1129us;1461us;1131us;1461us;1133us;1461us;1137us;1461us;1147us;1461us;1154us;1461us;1160us;1461us;1162us;1461us;1167us;1461us;1171us;1461us;1174us;1461us;1178us;1461us;1181us;1461us;1184us;1461us;1186us;1461us;1189us;1461us;1191us;1461us;1240us;1461us;1242us;1461us;1246us;1461us;1248us;1461us;1250us;1461us;1252us;1461us;1254us;1461us;1256us;1461us;1258us;1461us;1260us;1461us;1262us;1461us;1264us;1461us;1266us;1461us;1268us;1461us;1270us;1461us;1272us;1461us;1274us;1461us;1276us;1461us;1278us;1461us;1280us;1461us;1282us;1461us;1284us;1461us;1286us;1461us;1287us;1461us;1288us;1461us;1289us;1461us;1292us;1461us;1302us;1461us;1327us;1461us;1328us;1461us;1332us;1461us;1334us;1461us;1337us;1461us;1338us;1461us;1340us;1461us;1343us;1461us;1345us;1461us;1347us;1461us;1349us;1461us;1351us;1461us;1352us;1461us;1353us;1461us;1354us;1461us;1356us;1461us;1357us;1461us;1359us;1461us;1360us;1461us;1362us;1461us;1363us;1461us;1365us;1461us;1366us;1461us;1368us;1461us;1369us;1461us;1371us;1461us;1372us;1461us;1378us;1461us;1379us;1461us;1386us;1461us;1388us;1461us;1390us;1461us;1391us;1461us;1392us;1461us;1395us;1461us;1400us;1461us;1408us;1461us;1409us;1461us;1412us;1461us;1413us;1461us;1431us;1461us;1438us;1461us;1445us;1461us;1452us;1461us;1469us;1461us;1476us;1461us;1477us;1461us;1483us;1461us;1489us;1461us;1490us;1461us;1491us;1461us;1503us;1461us;1509us;1461us;1519us;1461us;1532us;1461us;1534us;1461us;1537us;1461us;1538us;1461us;1544us;1461us;1559us;1461us;1564us;1461us;1569us;1461us;1594us;1461us;1627us;1461us;1636us;1461us;1641us;1461us;1864us;1461us;2021us;1461us;2025us;1461us;157us;65535us;6us;1626us;31us;1626us;114us;1626us;116us;1626us;237us;1626us;251us;1626us;274us;1626us;331us;1626us;335us;1626us;340us;1626us;422us;1626us;427us;1626us;468us;1626us;491us;1626us;525us;1626us;690us;1626us;701us;1626us;753us;1626us;759us;1626us;809us;1626us;813us;1626us;823us;1626us;1030us;1626us;1036us;1626us;1052us;1626us;1054us;1626us;1057us;1626us;1060us;1626us;1079us;1626us;1084us;1626us;1090us;1626us;1093us;1626us;1096us;1626us;1102us;1626us;1106us;1626us;1110us;1626us;1116us;1626us;1118us;1626us;1123us;1626us;1125us;1626us;1127us;1626us;1129us;1626us;1131us;1626us;1133us;1626us;1137us;1626us;1147us;1626us;1154us;1626us;1160us;1626us;1162us;1626us;1167us;1626us;1171us;1626us;1174us;1626us;1178us;1626us;1181us;1626us;1184us;1626us;1186us;1626us;1189us;1626us;1191us;1626us;1240us;1626us;1242us;1626us;1246us;1626us;1248us;1626us;1250us;1626us;1252us;1626us;1254us;1626us;1256us;1626us;1258us;1626us;1260us;1626us;1262us;1626us;1264us;1626us;1266us;1626us;1268us;1626us;1270us;1626us;1272us;1626us;1274us;1626us;1276us;1626us;1278us;1626us;1280us;1626us;1282us;1626us;1284us;1626us;1286us;1626us;1287us;1626us;1288us;1626us;1289us;1626us;1292us;1626us;1302us;1626us;1327us;1626us;1328us;1626us;1332us;1626us;1334us;1626us;1337us;1626us;1338us;1626us;1340us;1626us;1343us;1626us;1345us;1626us;1347us;1626us;1349us;1626us;1351us;1626us;1352us;1626us;1353us;1626us;1354us;1626us;1356us;1626us;1357us;1626us;1359us;1626us;1360us;1626us;1362us;1626us;1363us;1626us;1365us;1626us;1366us;1626us;1368us;1626us;1369us;1626us;1371us;1626us;1372us;1626us;1378us;1626us;1379us;1626us;1386us;1626us;1388us;1626us;1390us;1626us;1391us;1626us;1392us;1626us;1395us;1626us;1400us;1626us;1408us;1626us;1409us;1626us;1412us;1626us;1413us;1626us;1431us;1626us;1437us;1625us;1438us;1626us;1445us;1626us;1452us;1626us;1469us;1626us;1476us;1626us;1477us;1626us;1483us;1626us;1489us;1626us;1490us;1626us;1491us;1626us;1503us;1626us;1509us;1626us;1519us;1626us;1532us;1626us;1534us;1626us;1537us;1626us;1538us;1626us;1544us;1626us;1559us;1626us;1564us;1626us;1569us;1626us;1594us;1626us;1624us;1625us;1627us;1626us;1636us;1626us;1641us;1626us;1864us;1626us;2021us;1626us;2025us;1626us;116us;65535us;6us;1101us;31us;1101us;114us;1101us;116us;1101us;237us;1101us;251us;1101us;274us;1101us;422us;1101us;427us;1101us;468us;1101us;491us;1101us;753us;1101us;759us;1101us;809us;1101us;813us;1101us;823us;1101us;1030us;1101us;1036us;1101us;1052us;1101us;1054us;1101us;1057us;1101us;1060us;1101us;1079us;1101us;1084us;1101us;1090us;1101us;1093us;1101us;1096us;1101us;1102us;1101us;1106us;1101us;1110us;1101us;1116us;1101us;1118us;1101us;1123us;1101us;1125us;1101us;1127us;1101us;1129us;1101us;1131us;1101us;1133us;1101us;1137us;1101us;1147us;1101us;1154us;1101us;1160us;1101us;1162us;1101us;1167us;1101us;1171us;1101us;1174us;1101us;1178us;1101us;1181us;1101us;1184us;1101us;1186us;1101us;1189us;1101us;1191us;1101us;1240us;1101us;1242us;1101us;1246us;1101us;1248us;1101us;1250us;1101us;1252us;1101us;1254us;1101us;1256us;1101us;1258us;1101us;1260us;1101us;1262us;1101us;1264us;1101us;1266us;1101us;1268us;1101us;1270us;1101us;1272us;1101us;1274us;1101us;1276us;1101us;1278us;1101us;1280us;1101us;1282us;1101us;1284us;1101us;1286us;1101us;1287us;1101us;1288us;1101us;1289us;1101us;1292us;1101us;1302us;1101us;1327us;1101us;1328us;1101us;1332us;1101us;1334us;1101us;1337us;1101us;1338us;1101us;1340us;1101us;1343us;1101us;1345us;1101us;1347us;1101us;1349us;1101us;1431us;1101us;1438us;1101us;1445us;1101us;1452us;1101us;1469us;1101us;1476us;1101us;1477us;1101us;1483us;1101us;1489us;1101us;1490us;1101us;1491us;1101us;1503us;1101us;1509us;1101us;1519us;1101us;1532us;1101us;1534us;1101us;1537us;1101us;1538us;1101us;1564us;1101us;1569us;1101us;1594us;1101us;1636us;1101us;1641us;1101us;2021us;1101us;2025us;1101us;116us;65535us;6us;1100us;31us;1100us;114us;1100us;116us;1100us;237us;1100us;251us;1100us;274us;1100us;422us;1100us;427us;1100us;468us;1100us;491us;1100us;753us;1100us;759us;1100us;809us;1100us;813us;1100us;823us;1100us;1030us;1100us;1036us;1100us;1052us;1100us;1054us;1100us;1057us;1100us;1060us;1100us;1079us;1100us;1084us;1100us;1090us;1100us;1093us;1100us;1096us;1100us;1102us;1100us;1106us;1100us;1110us;1100us;1116us;1100us;1118us;1100us;1123us;1100us;1125us;1100us;1127us;1100us;1129us;1100us;1131us;1100us;1133us;1100us;1137us;1100us;1147us;1100us;1154us;1100us;1160us;1100us;1162us;1100us;1167us;1100us;1171us;1100us;1174us;1100us;1178us;1100us;1181us;1100us;1184us;1100us;1186us;1100us;1189us;1100us;1191us;1100us;1240us;1100us;1242us;1100us;1246us;1100us;1248us;1100us;1250us;1100us;1252us;1100us;1254us;1100us;1256us;1100us;1258us;1100us;1260us;1100us;1262us;1100us;1264us;1100us;1266us;1100us;1268us;1100us;1270us;1100us;1272us;1100us;1274us;1100us;1276us;1100us;1278us;1100us;1280us;1100us;1282us;1100us;1284us;1100us;1286us;1100us;1287us;1100us;1288us;1100us;1289us;1100us;1292us;1100us;1302us;1100us;1327us;1100us;1328us;1100us;1332us;1100us;1334us;1100us;1337us;1100us;1338us;1100us;1340us;1100us;1343us;1100us;1345us;1100us;1347us;1100us;1349us;1100us;1431us;1100us;1438us;1100us;1445us;1100us;1452us;1100us;1469us;1100us;1476us;1100us;1477us;1100us;1483us;1100us;1489us;1100us;1490us;1100us;1491us;1100us;1503us;1100us;1509us;1100us;1519us;1100us;1532us;1100us;1534us;1100us;1537us;1100us;1538us;1100us;1564us;1100us;1569us;1100us;1594us;1100us;1636us;1100us;1641us;1100us;2021us;1100us;2025us;1100us;3us;65535us;873us;874us;1005us;1006us;1046us;1047us;5us;65535us;111us;112us;184us;185us;201us;202us;454us;455us;1660us;1661us;3us;65535us;420us;421us;425us;426us;807us;808us;9us;65535us;111us;1658us;149us;150us;184us;1658us;201us;1658us;385us;386us;454us;1658us;688us;689us;1660us;1658us;1664us;1665us;9us;65535us;111us;1663us;149us;1663us;184us;1663us;201us;1663us;385us;1663us;454us;1663us;688us;1663us;1660us;1663us;1664us;1663us;4us;65535us;1668us;1669us;1671us;1672us;1674us;1675us;1677us;1678us;13us;65535us;111us;1667us;149us;1667us;184us;1667us;201us;1667us;385us;1667us;454us;1667us;688us;1667us;1660us;1667us;1664us;1667us;1668us;1673us;1671us;1673us;1674us;1673us;1677us;1673us;10us;65535us;679us;718us;681us;718us;684us;718us;705us;718us;708us;718us;711us;718us;714us;717us;744us;718us;1700us;1701us;1703us;1704us;33us;65535us;8us;1711us;178us;566us;439us;566us;481us;482us;497us;498us;561us;566us;569us;1850us;640us;641us;643us;644us;653us;1850us;730us;731us;829us;830us;873us;1656us;1005us;1656us;1046us;1656us;1231us;1232us;1234us;1235us;1237us;1238us;1550us;1551us;1553us;1554us;1555us;1850us;1706us;1707us;1709us;1710us;1751us;1850us;1757us;1758us;1760us;1761us;1827us;1890us;1831us;1890us;1837us;1850us;1848us;1849us;1878us;1890us;1880us;1890us;1891us;1892us;1us;65535us;8us;9us;33us;65535us;8us;1705us;178us;1705us;439us;1705us;481us;1705us;497us;1705us;561us;1705us;569us;1705us;640us;1705us;643us;1705us;653us;1705us;730us;1705us;829us;1705us;873us;1705us;1005us;1705us;1046us;1705us;1231us;1705us;1234us;1705us;1237us;1705us;1550us;1705us;1553us;1705us;1555us;1705us;1706us;1705us;1709us;1705us;1751us;1705us;1757us;1705us;1760us;1705us;1827us;1705us;1831us;1705us;1837us;1705us;1848us;1705us;1878us;1705us;1880us;1705us;1891us;1705us;9us;65535us;1714us;1715us;1717us;1718us;1719us;1720us;1722us;1723us;1726us;1727us;1729us;1730us;1731us;1732us;1734us;1735us;1855us;1856us;82us;65535us;8us;1756us;111us;1756us;149us;1756us;178us;1756us;184us;1756us;188us;1756us;190us;1756us;201us;1756us;290us;1756us;385us;1756us;439us;1756us;446us;1756us;454us;1756us;481us;1756us;497us;1756us;561us;1756us;569us;1756us;626us;1756us;630us;1756us;640us;1756us;643us;1756us;653us;1756us;664us;1756us;679us;1756us;681us;1756us;684us;1756us;688us;1756us;705us;1756us;708us;1756us;711us;1756us;714us;1756us;730us;1756us;744us;1756us;829us;1756us;873us;1756us;1005us;1756us;1046us;1756us;1231us;1756us;1234us;1756us;1237us;1756us;1517us;1756us;1550us;1756us;1553us;1756us;1555us;1756us;1619us;1756us;1657us;1756us;1659us;1756us;1660us;1756us;1664us;1756us;1668us;1756us;1671us;1756us;1674us;1756us;1677us;1756us;1679us;1756us;1681us;1756us;1686us;1756us;1690us;1756us;1695us;1756us;1700us;1756us;1703us;1756us;1706us;1756us;1709us;1756us;1714us;1756us;1717us;1756us;1719us;1756us;1722us;1756us;1726us;1756us;1729us;1756us;1731us;1756us;1734us;1756us;1751us;1756us;1757us;1756us;1760us;1756us;1827us;1756us;1831us;1756us;1837us;1756us;1848us;1756us;1854us;1756us;1855us;1756us;1878us;1756us;1880us;1756us;1891us;1756us;117us;65535us;8us;1743us;111us;1743us;149us;1743us;178us;1743us;184us;1743us;188us;1743us;189us;1742us;190us;1743us;191us;1742us;201us;1743us;290us;1743us;291us;1742us;385us;1743us;439us;1743us;446us;1743us;447us;1742us;454us;1743us;481us;1743us;497us;1743us;522us;1743us;561us;1743us;569us;1743us;570us;1743us;613us;1743us;626us;1743us;630us;1743us;635us;1743us;640us;1743us;643us;1743us;653us;1743us;663us;1742us;664us;1743us;665us;1742us;666us;1742us;679us;1743us;681us;1743us;684us;1743us;688us;1743us;705us;1743us;708us;1743us;711us;1743us;714us;1743us;715us;1742us;716us;1742us;730us;1743us;744us;1743us;829us;1743us;873us;1743us;938us;1743us;1005us;1743us;1046us;1743us;1231us;1743us;1234us;1743us;1237us;1743us;1374us;1743us;1375us;1743us;1517us;1743us;1518us;1742us;1550us;1743us;1553us;1743us;1555us;1743us;1557us;1743us;1619us;1743us;1620us;1742us;1657us;1743us;1659us;1743us;1660us;1743us;1664us;1743us;1668us;1743us;1671us;1743us;1674us;1743us;1677us;1743us;1679us;1743us;1680us;1742us;1681us;1743us;1682us;1742us;1686us;1743us;1687us;1742us;1689us;1742us;1690us;1743us;1691us;1742us;1695us;1743us;1696us;1742us;1698us;1742us;1699us;1742us;1700us;1743us;1703us;1743us;1706us;1743us;1709us;1743us;1713us;1742us;1714us;1743us;1717us;1743us;1719us;1743us;1722us;1743us;1725us;1742us;1726us;1743us;1729us;1743us;1731us;1743us;1734us;1743us;1737us;1743us;1739us;1743us;1746us;1742us;1751us;1743us;1753us;1742us;1757us;1743us;1760us;1743us;1827us;1743us;1831us;1743us;1837us;1743us;1839us;1742us;1844us;1743us;1848us;1743us;1854us;1743us;1855us;1743us;1878us;1743us;1880us;1743us;1891us;1743us;117us;65535us;8us;1846us;111us;1846us;149us;1846us;178us;1846us;184us;1846us;188us;1846us;189us;1750us;190us;1846us;191us;1750us;201us;1846us;290us;1846us;291us;1750us;385us;1846us;439us;1846us;446us;1846us;447us;1750us;454us;1846us;481us;1846us;497us;1846us;522us;1846us;561us;1846us;569us;1846us;570us;1846us;613us;1846us;626us;1846us;630us;1846us;635us;1846us;640us;1846us;643us;1846us;653us;1846us;663us;1750us;664us;1846us;665us;1750us;666us;1750us;679us;1846us;681us;1846us;684us;1846us;688us;1846us;705us;1846us;708us;1846us;711us;1846us;714us;1846us;715us;1750us;716us;1750us;730us;1846us;744us;1846us;829us;1846us;873us;1846us;938us;1846us;1005us;1846us;1046us;1846us;1231us;1846us;1234us;1846us;1237us;1846us;1374us;1846us;1375us;1846us;1517us;1846us;1518us;1750us;1550us;1846us;1553us;1846us;1555us;1846us;1557us;1846us;1619us;1846us;1620us;1750us;1657us;1846us;1659us;1846us;1660us;1846us;1664us;1846us;1668us;1846us;1671us;1846us;1674us;1846us;1677us;1846us;1679us;1846us;1680us;1750us;1681us;1846us;1682us;1750us;1686us;1846us;1687us;1750us;1689us;1750us;1690us;1846us;1691us;1750us;1695us;1846us;1696us;1750us;1698us;1750us;1699us;1750us;1700us;1846us;1703us;1846us;1706us;1846us;1709us;1846us;1713us;1750us;1714us;1846us;1717us;1846us;1719us;1846us;1722us;1846us;1725us;1750us;1726us;1846us;1729us;1846us;1731us;1846us;1734us;1846us;1737us;1846us;1739us;1846us;1746us;1750us;1751us;1846us;1753us;1754us;1757us;1846us;1760us;1846us;1827us;1846us;1831us;1846us;1837us;1846us;1839us;1840us;1844us;1846us;1848us;1846us;1854us;1846us;1855us;1846us;1878us;1846us;1880us;1846us;1891us;1846us;82us;65535us;8us;1713us;111us;1689us;149us;1689us;178us;1713us;184us;1689us;188us;189us;190us;191us;201us;1689us;290us;291us;385us;1689us;439us;1713us;446us;447us;454us;1689us;481us;1713us;497us;1713us;561us;1713us;569us;1713us;626us;663us;630us;663us;640us;1713us;643us;1713us;653us;666us;664us;665us;679us;716us;681us;716us;684us;716us;688us;1689us;705us;716us;708us;716us;711us;716us;714us;715us;730us;1713us;744us;716us;829us;1713us;873us;1713us;1005us;1713us;1046us;1713us;1231us;1713us;1234us;1713us;1237us;1713us;1517us;1518us;1550us;1713us;1553us;1713us;1555us;1713us;1619us;1620us;1657us;663us;1659us;663us;1660us;1689us;1664us;1689us;1668us;1689us;1671us;1689us;1674us;1689us;1677us;1689us;1679us;1680us;1681us;1682us;1686us;1687us;1690us;1691us;1695us;1696us;1700us;1698us;1703us;1699us;1706us;1713us;1709us;1713us;1714us;1725us;1717us;1725us;1719us;1725us;1722us;1725us;1726us;1725us;1729us;1725us;1731us;1725us;1734us;1725us;1751us;1713us;1757us;1713us;1760us;1713us;1827us;1713us;1831us;1713us;1837us;1713us;1848us;1713us;1854us;1746us;1855us;1725us;1878us;1713us;1880us;1713us;1891us;1713us;23us;65535us;189us;1747us;191us;1747us;291us;1747us;447us;1747us;663us;1747us;665us;1747us;666us;1747us;715us;1747us;716us;1747us;1518us;1747us;1620us;1747us;1680us;1747us;1682us;1747us;1687us;1747us;1689us;1747us;1691us;1747us;1696us;1747us;1698us;1747us;1699us;1747us;1713us;1747us;1725us;1747us;1746us;1747us;1748us;1749us;5us;65535us;569us;1752us;653us;1752us;1555us;1752us;1751us;1752us;1837us;1838us;2us;65535us;1828us;1829us;1881us;1830us;82us;65535us;8us;1755us;111us;1755us;149us;1755us;178us;1755us;184us;1755us;188us;1755us;190us;1755us;201us;1755us;290us;1755us;385us;1755us;439us;1755us;446us;1755us;454us;1755us;481us;1755us;497us;1755us;561us;1755us;569us;1755us;626us;1755us;630us;1755us;640us;1755us;643us;1755us;653us;1755us;664us;1755us;679us;1755us;681us;1755us;684us;1755us;688us;1755us;705us;1755us;708us;1755us;711us;1755us;714us;1755us;730us;1755us;744us;1755us;829us;1755us;873us;1755us;1005us;1755us;1046us;1755us;1231us;1755us;1234us;1755us;1237us;1755us;1517us;1755us;1550us;1755us;1553us;1755us;1555us;1755us;1619us;1755us;1657us;1755us;1659us;1755us;1660us;1755us;1664us;1755us;1668us;1755us;1671us;1755us;1674us;1755us;1677us;1755us;1679us;1755us;1681us;1755us;1686us;1755us;1690us;1755us;1695us;1755us;1700us;1755us;1703us;1755us;1706us;1755us;1709us;1755us;1714us;1755us;1717us;1755us;1719us;1755us;1722us;1755us;1726us;1755us;1729us;1755us;1731us;1755us;1734us;1755us;1751us;1755us;1757us;1755us;1760us;1755us;1827us;1755us;1831us;1755us;1837us;1755us;1848us;1755us;1854us;1755us;1855us;1755us;1878us;1755us;1880us;1755us;1891us;1755us;4us;65535us;522us;523us;1374us;1376us;1375us;1377us;1557us;1558us;83us;65535us;8us;1834us;111us;1834us;149us;1834us;178us;1834us;184us;1834us;188us;1834us;190us;1834us;201us;1834us;290us;1834us;385us;1834us;439us;1834us;446us;1834us;454us;1834us;481us;1834us;497us;1834us;561us;1834us;569us;1834us;626us;1834us;630us;1834us;640us;1834us;643us;1834us;653us;1834us;664us;1834us;679us;1834us;681us;1834us;684us;1834us;688us;1834us;705us;1834us;708us;1834us;711us;1834us;714us;1834us;730us;1834us;744us;1834us;829us;1834us;873us;1834us;938us;939us;1005us;1834us;1046us;1834us;1231us;1834us;1234us;1834us;1237us;1834us;1517us;1834us;1550us;1834us;1553us;1834us;1555us;1834us;1619us;1834us;1657us;1834us;1659us;1834us;1660us;1834us;1664us;1834us;1668us;1834us;1671us;1834us;1674us;1834us;1677us;1834us;1679us;1834us;1681us;1834us;1686us;1834us;1690us;1834us;1695us;1834us;1700us;1834us;1703us;1834us;1706us;1834us;1709us;1834us;1714us;1834us;1717us;1834us;1719us;1834us;1722us;1834us;1726us;1834us;1729us;1834us;1731us;1834us;1734us;1834us;1751us;1834us;1757us;1834us;1760us;1834us;1827us;1834us;1831us;1834us;1837us;1834us;1848us;1834us;1854us;1834us;1855us;1834us;1878us;1834us;1880us;1834us;1891us;1834us;93us;65535us;8us;1738us;111us;1738us;149us;1738us;178us;1738us;184us;1738us;188us;1738us;190us;1738us;201us;1738us;290us;1738us;385us;1738us;439us;1738us;446us;1738us;454us;1738us;481us;1738us;497us;1738us;522us;1841us;561us;1738us;569us;1738us;570us;1845us;613us;637us;626us;1738us;630us;1738us;635us;636us;640us;1738us;643us;1738us;653us;1738us;664us;1738us;679us;1738us;681us;1738us;684us;1738us;688us;1738us;705us;1738us;708us;1738us;711us;1738us;714us;1738us;730us;1738us;744us;1738us;829us;1738us;873us;1738us;938us;1842us;1005us;1738us;1046us;1738us;1231us;1738us;1234us;1738us;1237us;1738us;1374us;1841us;1375us;1841us;1517us;1738us;1550us;1738us;1553us;1738us;1555us;1738us;1557us;1841us;1619us;1738us;1657us;1738us;1659us;1738us;1660us;1738us;1664us;1738us;1668us;1738us;1671us;1738us;1674us;1738us;1677us;1738us;1679us;1738us;1681us;1738us;1686us;1738us;1690us;1738us;1695us;1738us;1700us;1738us;1703us;1738us;1706us;1738us;1709us;1738us;1714us;1738us;1717us;1738us;1719us;1738us;1722us;1738us;1726us;1738us;1729us;1738us;1731us;1738us;1734us;1738us;1737us;637us;1739us;637us;1751us;1738us;1757us;1738us;1760us;1738us;1827us;1738us;1831us;1738us;1837us;1738us;1844us;1845us;1848us;1738us;1854us;1738us;1855us;1738us;1878us;1738us;1880us;1738us;1891us;1738us;4us;65535us;647us;662us;660us;661us;1743us;1869us;1871us;1872us;6us;65535us;647us;1875us;660us;1875us;1410us;1411us;1743us;1875us;1871us;1875us;1876us;1877us;9us;65535us;569us;1826us;653us;1826us;1555us;1826us;1751us;1826us;1827us;1828us;1831us;1832us;1837us;1826us;1878us;1885us;1880us;1893us;2us;65535us;1878us;1879us;1880us;1881us;3us;65535us;1831us;1833us;1878us;1894us;1880us;1894us;1us;65535us;865us;866us;6us;65535us;1895us;1905us;1902us;1905us;1909us;1905us;1915us;1905us;1916us;1905us;1917us;1905us;6us;65535us;1895us;1909us;1902us;1909us;1909us;1909us;1915us;1909us;1916us;1909us;1917us;1909us;6us;65535us;1895us;1911us;1902us;1911us;1909us;1910us;1915us;1911us;1916us;1911us;1917us;1911us;5us;65535us;1895us;1896us;1902us;1903us;1915us;1912us;1916us;1913us;1917us;1914us;131us;65535us;8us;1736us;111us;1736us;149us;1736us;178us;1736us;184us;1736us;188us;1736us;189us;1741us;190us;1736us;191us;1741us;201us;1736us;290us;1736us;291us;1741us;385us;1736us;439us;1736us;446us;1736us;447us;1741us;454us;1736us;481us;1736us;497us;1736us;522us;1741us;561us;1736us;569us;1736us;570us;1741us;595us;601us;611us;612us;613us;1741us;626us;642us;630us;642us;635us;1741us;638us;639us;640us;1736us;643us;1736us;653us;1736us;663us;1741us;664us;1736us;665us;1741us;666us;1741us;679us;1736us;681us;1736us;684us;1736us;688us;1736us;705us;1736us;708us;1736us;711us;1736us;714us;1736us;715us;1741us;716us;1741us;730us;1736us;744us;1736us;821us;828us;825us;828us;829us;1736us;873us;1736us;938us;1741us;1005us;1736us;1046us;1736us;1231us;1736us;1234us;1736us;1237us;1736us;1374us;1741us;1375us;1741us;1489us;1513us;1490us;1514us;1491us;1513us;1517us;1736us;1518us;1741us;1550us;1736us;1553us;1736us;1555us;1736us;1557us;1741us;1619us;1736us;1620us;1741us;1657us;642us;1659us;642us;1660us;1736us;1664us;1736us;1668us;1736us;1671us;1736us;1674us;1736us;1677us;1736us;1679us;1736us;1680us;1741us;1681us;1736us;1682us;1741us;1686us;1736us;1687us;1741us;1689us;1741us;1690us;1736us;1691us;1741us;1695us;1736us;1696us;1741us;1698us;1741us;1699us;1741us;1700us;1736us;1703us;1736us;1706us;1736us;1709us;1736us;1713us;1741us;1714us;1736us;1717us;1736us;1719us;1736us;1722us;1736us;1725us;1741us;1726us;1736us;1729us;1736us;1731us;1736us;1734us;1736us;1737us;1741us;1739us;1741us;1746us;1741us;1751us;1736us;1753us;1741us;1757us;1736us;1760us;1736us;1827us;1736us;1831us;1736us;1837us;1736us;1839us;1741us;1844us;1741us;1848us;1736us;1854us;1736us;1855us;1736us;1878us;1736us;1880us;1736us;1891us;1736us;1895us;1901us;1902us;1901us;1909us;1901us;1915us;1901us;1916us;1901us;1917us;1901us;385us;65535us;6us;1980us;8us;1925us;31us;1980us;53us;1925us;58us;1925us;95us;1925us;108us;1972us;111us;1925us;114us;1980us;116us;1980us;120us;1925us;149us;1925us;178us;699us;181us;1972us;184us;1925us;188us;1925us;189us;1925us;190us;1925us;191us;1925us;201us;1925us;203us;1972us;205us;1972us;210us;1972us;237us;1980us;251us;1980us;274us;1980us;281us;1925us;287us;1925us;290us;1925us;291us;1925us;317us;346us;328us;346us;333us;1925us;337us;1925us;385us;1925us;419us;1974us;422us;1980us;424us;1974us;427us;1980us;439us;699us;446us;1925us;447us;1925us;451us;1972us;454us;1925us;465us;1974us;468us;1980us;479us;480us;481us;1925us;488us;489us;491us;1980us;497us;1925us;501us;1974us;504us;1974us;507us;1974us;509us;1974us;522us;1925us;530us;531us;534us;535us;561us;699us;569us;1925us;570us;1925us;595us;1925us;597us;1925us;613us;1925us;626us;1925us;630us;1925us;635us;1925us;640us;1925us;643us;1925us;653us;1925us;663us;1925us;664us;1925us;665us;1925us;666us;1925us;678us;1972us;679us;713us;681us;713us;684us;713us;688us;1925us;690us;1980us;701us;1980us;705us;713us;708us;713us;711us;713us;714us;1925us;715us;1925us;716us;1925us;728us;729us;730us;1925us;739us;743us;744us;713us;747us;1925us;753us;1980us;759us;1980us;771us;772us;783us;1925us;784us;785us;796us;1925us;806us;1974us;809us;1980us;813us;1980us;823us;1980us;829us;1925us;869us;870us;873us;1925us;876us;868us;877us;868us;880us;868us;899us;1974us;901us;1974us;902us;1974us;906us;1974us;907us;1974us;910us;1974us;912us;1974us;913us;1974us;916us;920us;918us;920us;922us;1974us;926us;1974us;927us;1974us;929us;1974us;931us;1974us;934us;1974us;936us;1974us;938us;1925us;941us;921us;945us;1974us;947us;1974us;949us;1974us;952us;1925us;957us;1974us;960us;1974us;963us;965us;964us;965us;971us;1974us;979us;1974us;1000us;1974us;1002us;1974us;1005us;1925us;1008us;1974us;1009us;1974us;1011us;1974us;1012us;1974us;1015us;1974us;1017us;1974us;1018us;1974us;1021us;1925us;1024us;1974us;1028us;1974us;1030us;1980us;1036us;1980us;1046us;1925us;1052us;1980us;1054us;1980us;1057us;1980us;1060us;1980us;1078us;1974us;1079us;1980us;1083us;1974us;1084us;1980us;1090us;1980us;1093us;1980us;1096us;1980us;1102us;1980us;1106us;1980us;1110us;1980us;1116us;1980us;1118us;1980us;1123us;1980us;1125us;1980us;1127us;1980us;1129us;1980us;1131us;1980us;1133us;1980us;1135us;1974us;1137us;1980us;1147us;1980us;1154us;1980us;1160us;1980us;1162us;1980us;1166us;1974us;1167us;1980us;1171us;1980us;1173us;1974us;1174us;1980us;1178us;1980us;1181us;1980us;1184us;1980us;1186us;1980us;1189us;1980us;1191us;1980us;1231us;1925us;1234us;1925us;1237us;1925us;1240us;1980us;1242us;1980us;1246us;1980us;1248us;1980us;1250us;1980us;1252us;1980us;1254us;1980us;1256us;1980us;1258us;1980us;1260us;1980us;1262us;1980us;1264us;1980us;1266us;1980us;1268us;1980us;1270us;1980us;1272us;1980us;1274us;1980us;1276us;1980us;1278us;1980us;1280us;1980us;1282us;1980us;1284us;1980us;1286us;1980us;1287us;1980us;1288us;1980us;1289us;1980us;1292us;1980us;1302us;1980us;1305us;1974us;1307us;1974us;1313us;1974us;1320us;1974us;1322us;1974us;1327us;1980us;1328us;1980us;1332us;1980us;1334us;1980us;1337us;1980us;1338us;1980us;1340us;1980us;1343us;1980us;1345us;1980us;1347us;1980us;1349us;1980us;1351us;1980us;1352us;1922us;1353us;1922us;1354us;1980us;1356us;1980us;1357us;1980us;1359us;1980us;1360us;1980us;1362us;1980us;1363us;1980us;1365us;1980us;1366us;1980us;1368us;1980us;1369us;1980us;1371us;1980us;1372us;1980us;1374us;1925us;1375us;1925us;1382us;1972us;1386us;1980us;1388us;1980us;1390us;1980us;1391us;1980us;1392us;1980us;1395us;1980us;1400us;1980us;1408us;1980us;1409us;1980us;1412us;1980us;1413us;1980us;1414us;1416us;1415us;1417us;1419us;1972us;1422us;1972us;1424us;1972us;1425us;1972us;1431us;1980us;1438us;1980us;1445us;1980us;1452us;1980us;1469us;1980us;1476us;1980us;1477us;1980us;1483us;1980us;1489us;1980us;1490us;1980us;1491us;1980us;1503us;1980us;1509us;1980us;1517us;1925us;1518us;1925us;1519us;1980us;1532us;1980us;1534us;1980us;1537us;1980us;1538us;1980us;1544us;1980us;1550us;1925us;1553us;1925us;1555us;1925us;1557us;1925us;1564us;1980us;1569us;1980us;1573us;1925us;1577us;1925us;1585us;1925us;1594us;1980us;1619us;1925us;1620us;1925us;1627us;1980us;1634us;1974us;1636us;1980us;1639us;1974us;1641us;1980us;1651us;1974us;1653us;1974us;1657us;1925us;1659us;1925us;1660us;1925us;1664us;1925us;1668us;1925us;1671us;1925us;1674us;1925us;1677us;1925us;1679us;1925us;1680us;1925us;1681us;1925us;1682us;1925us;1684us;1685us;1686us;1925us;1687us;1925us;1689us;1925us;1690us;1925us;1691us;1925us;1693us;1694us;1695us;1925us;1696us;1925us;1698us;1925us;1699us;1925us;1700us;1925us;1703us;1925us;1706us;1925us;1709us;1925us;1713us;1925us;1714us;1925us;1717us;1925us;1719us;1925us;1722us;1925us;1725us;1925us;1726us;1925us;1729us;1925us;1731us;1925us;1734us;1925us;1737us;1925us;1739us;1925us;1746us;1925us;1751us;1925us;1753us;1925us;1757us;1925us;1760us;1925us;1827us;1925us;1831us;1925us;1837us;1925us;1839us;1925us;1844us;1925us;1848us;1925us;1854us;1925us;1855us;1925us;1864us;1980us;1870us;1925us;1878us;1925us;1880us;1925us;1891us;1925us;1895us;1925us;1902us;1925us;1909us;1925us;1915us;1925us;1916us;1925us;1917us;1925us;1918us;1919us;1920us;1921us;1926us;1927us;1976us;1974us;2018us;2019us;2021us;1980us;2025us;1980us;144us;65535us;8us;1740us;53us;54us;58us;59us;95us;295us;111us;1740us;120us;293us;149us;1740us;178us;562us;184us;1740us;188us;1740us;189us;1740us;190us;1740us;191us;1740us;201us;1740us;281us;305us;287us;288us;290us;1740us;291us;1740us;317us;330us;328us;330us;333us;334us;337us;338us;385us;1740us;439us;562us;446us;1740us;447us;1740us;454us;1740us;481us;1740us;497us;1740us;522us;1740us;561us;562us;569us;1740us;570us;1740us;595us;596us;597us;598us;613us;1740us;626us;1740us;630us;1740us;635us;1740us;640us;1740us;643us;1740us;653us;1740us;663us;1740us;664us;1740us;665us;1740us;666us;1740us;679us;1740us;681us;1740us;684us;1740us;688us;1740us;705us;1740us;708us;1740us;711us;1740us;714us;1740us;715us;1740us;716us;1740us;730us;1740us;744us;1740us;747us;748us;783us;786us;796us;786us;829us;1740us;873us;1740us;938us;1740us;952us;1023us;1005us;1740us;1021us;1023us;1046us;1740us;1231us;1740us;1234us;1740us;1237us;1740us;1374us;1740us;1375us;1740us;1517us;1740us;1518us;1740us;1550us;1740us;1553us;1740us;1555us;1740us;1557us;1740us;1573us;1590us;1577us;1590us;1585us;1590us;1619us;1740us;1620us;1740us;1657us;1740us;1659us;1740us;1660us;1740us;1664us;1740us;1668us;1740us;1671us;1740us;1674us;1740us;1677us;1740us;1679us;1740us;1680us;1740us;1681us;1740us;1682us;1740us;1686us;1740us;1687us;1740us;1689us;1740us;1690us;1740us;1691us;1740us;1695us;1740us;1696us;1740us;1698us;1740us;1699us;1740us;1700us;1740us;1703us;1740us;1706us;1740us;1709us;1740us;1713us;1740us;1714us;1740us;1717us;1740us;1719us;1740us;1722us;1740us;1725us;1740us;1726us;1740us;1729us;1740us;1731us;1740us;1734us;1740us;1737us;1740us;1739us;1740us;1746us;1740us;1751us;1740us;1753us;1740us;1757us;1740us;1760us;1740us;1827us;1740us;1831us;1740us;1837us;1740us;1839us;1740us;1844us;1740us;1848us;1740us;1854us;1740us;1855us;1740us;1870us;1871us;1878us;1740us;1880us;1740us;1891us;1740us;1895us;1900us;1902us;1900us;1909us;1900us;1915us;1900us;1916us;1900us;1917us;1900us;217us;65535us;6us;1981us;31us;1981us;108us;1973us;114us;1981us;116us;1981us;181us;1973us;203us;1973us;205us;1973us;210us;1973us;237us;1981us;251us;1981us;274us;1981us;419us;1975us;422us;1981us;424us;1975us;427us;1981us;451us;1973us;465us;1975us;468us;1981us;491us;1981us;501us;1975us;504us;1975us;507us;1975us;509us;1975us;678us;1973us;690us;1981us;701us;1981us;753us;1981us;759us;1981us;806us;1975us;809us;1981us;813us;1981us;823us;1981us;899us;1975us;901us;1975us;902us;1975us;906us;1975us;907us;1975us;910us;1975us;912us;1975us;913us;1975us;922us;1975us;926us;1975us;927us;1975us;929us;1975us;931us;1975us;934us;1975us;936us;1975us;941us;1975us;945us;1975us;947us;1975us;949us;1975us;957us;1975us;960us;1975us;971us;1975us;979us;1975us;1000us;1975us;1002us;1975us;1008us;1975us;1009us;1975us;1011us;1975us;1012us;1975us;1015us;1975us;1017us;1975us;1018us;1975us;1024us;1975us;1028us;1975us;1030us;1981us;1036us;1981us;1052us;1981us;1054us;1981us;1057us;1981us;1060us;1981us;1078us;1975us;1079us;1981us;1083us;1975us;1084us;1981us;1090us;1981us;1093us;1981us;1096us;1981us;1102us;1981us;1106us;1981us;1110us;1981us;1116us;1981us;1118us;1981us;1123us;1981us;1125us;1981us;1127us;1981us;1129us;1981us;1131us;1981us;1133us;1981us;1135us;1975us;1137us;1981us;1147us;1981us;1154us;1981us;1160us;1981us;1162us;1981us;1166us;1975us;1167us;1981us;1171us;1981us;1173us;1975us;1174us;1981us;1178us;1981us;1181us;1981us;1184us;1981us;1186us;1981us;1189us;1981us;1191us;1981us;1240us;1981us;1242us;1981us;1246us;1981us;1248us;1981us;1250us;1981us;1252us;1981us;1254us;1981us;1256us;1981us;1258us;1981us;1260us;1981us;1262us;1981us;1264us;1981us;1266us;1981us;1268us;1981us;1270us;1981us;1272us;1981us;1274us;1981us;1276us;1981us;1278us;1981us;1280us;1981us;1282us;1981us;1284us;1981us;1286us;1981us;1287us;1981us;1288us;1981us;1289us;1981us;1292us;1981us;1302us;1981us;1305us;1975us;1307us;1975us;1313us;1975us;1320us;1975us;1322us;1975us;1327us;1981us;1328us;1981us;1332us;1981us;1334us;1981us;1337us;1981us;1338us;1981us;1340us;1981us;1343us;1981us;1345us;1981us;1347us;1981us;1349us;1981us;1351us;1981us;1352us;1981us;1353us;1981us;1354us;1981us;1356us;1981us;1357us;1981us;1359us;1981us;1360us;1981us;1362us;1981us;1363us;1981us;1365us;1981us;1366us;1981us;1368us;1981us;1369us;1981us;1371us;1981us;1372us;1981us;1382us;1973us;1386us;1981us;1388us;1981us;1390us;1981us;1391us;1981us;1392us;1981us;1395us;1981us;1400us;1981us;1408us;1981us;1409us;1981us;1412us;1981us;1413us;1981us;1419us;1973us;1422us;1973us;1424us;1973us;1425us;1973us;1431us;1981us;1438us;1981us;1445us;1981us;1452us;1981us;1469us;1981us;1476us;1981us;1477us;1981us;1483us;1981us;1489us;1981us;1490us;1981us;1491us;1981us;1503us;1981us;1509us;1981us;1519us;1981us;1532us;1981us;1534us;1981us;1537us;1981us;1538us;1981us;1544us;1981us;1564us;1981us;1569us;1981us;1594us;1981us;1627us;1981us;1634us;1975us;1636us;1981us;1639us;1975us;1641us;1981us;1651us;1975us;1653us;1975us;1864us;1981us;1976us;1975us;2021us;1981us;2025us;1981us;7us;65535us;693us;1930us;941us;1930us;971us;1930us;1445us;1930us;1490us;1930us;1491us;1930us;1929us;1930us;2us;65535us;1936us;1971us;1969us;1970us;7us;65535us;693us;1935us;941us;1935us;971us;1935us;1445us;1935us;1490us;1935us;1491us;1935us;1929us;1935us;12us;65535us;108us;1979us;181us;1979us;203us;1979us;205us;1979us;210us;1979us;451us;1979us;678us;1979us;1382us;1442us;1419us;1442us;1422us;1442us;1424us;1979us;1425us;1979us;57us;65535us;419us;506us;424us;506us;465us;506us;501us;502us;504us;505us;507us;511us;509us;510us;806us;506us;899us;506us;901us;506us;902us;506us;906us;506us;907us;506us;910us;506us;912us;506us;913us;506us;922us;506us;926us;506us;927us;506us;929us;506us;931us;506us;934us;506us;936us;506us;941us;506us;945us;506us;947us;506us;949us;506us;957us;506us;960us;506us;971us;506us;979us;506us;1000us;506us;1002us;506us;1008us;506us;1009us;506us;1011us;506us;1012us;506us;1015us;506us;1017us;506us;1018us;506us;1024us;506us;1028us;506us;1078us;506us;1083us;506us;1135us;506us;1166us;506us;1173us;506us;1305us;506us;1307us;506us;1313us;506us;1320us;506us;1322us;506us;1634us;506us;1639us;506us;1651us;506us;1653us;506us;1976us;1977us;9us;65535us;108us;109us;181us;182us;203us;209us;205us;209us;210us;211us;451us;452us;678us;692us;1424us;1426us;1425us;1426us;148us;65535us;6us;1430us;31us;1430us;114us;1430us;116us;1430us;237us;1430us;251us;1430us;274us;1430us;422us;1430us;427us;1430us;468us;1430us;491us;1430us;690us;1430us;701us;1430us;753us;1430us;759us;1430us;809us;1430us;813us;1430us;823us;1430us;1030us;1430us;1036us;1430us;1052us;1430us;1054us;1430us;1057us;1430us;1060us;1430us;1079us;1430us;1084us;1430us;1090us;1430us;1093us;1430us;1096us;1430us;1102us;1430us;1106us;1430us;1110us;1430us;1116us;1430us;1118us;1430us;1123us;1430us;1125us;1430us;1127us;1430us;1129us;1430us;1131us;1430us;1133us;1430us;1137us;1430us;1147us;1430us;1154us;1430us;1160us;1430us;1162us;1430us;1167us;1430us;1171us;1430us;1174us;1430us;1178us;1430us;1181us;1430us;1184us;1430us;1186us;1430us;1189us;1430us;1191us;1430us;1240us;1430us;1242us;1430us;1246us;1430us;1248us;1430us;1250us;1430us;1252us;1430us;1254us;1430us;1256us;1430us;1258us;1430us;1260us;1430us;1262us;1430us;1264us;1430us;1266us;1430us;1268us;1430us;1270us;1430us;1272us;1430us;1274us;1430us;1276us;1430us;1278us;1430us;1280us;1430us;1282us;1430us;1284us;1430us;1286us;1430us;1287us;1430us;1288us;1430us;1289us;1430us;1292us;1430us;1302us;1430us;1327us;1430us;1328us;1430us;1332us;1430us;1334us;1430us;1337us;1430us;1338us;1430us;1340us;1430us;1343us;1430us;1345us;1430us;1347us;1430us;1349us;1430us;1351us;1430us;1352us;1430us;1353us;1430us;1354us;1430us;1356us;1430us;1357us;1430us;1359us;1430us;1360us;1430us;1362us;1430us;1363us;1430us;1365us;1430us;1366us;1430us;1368us;1430us;1369us;1430us;1371us;1430us;1372us;1430us;1386us;1430us;1388us;1430us;1390us;1430us;1391us;1430us;1392us;1430us;1395us;1430us;1400us;1430us;1408us;1430us;1409us;1430us;1412us;1430us;1413us;1430us;1431us;1430us;1438us;1430us;1445us;1430us;1452us;1430us;1469us;1430us;1476us;1430us;1477us;1430us;1483us;1430us;1489us;1430us;1490us;1430us;1491us;1430us;1503us;1430us;1509us;1430us;1519us;1430us;1532us;1430us;1534us;1430us;1537us;1430us;1538us;1430us;1544us;1430us;1564us;1430us;1569us;1430us;1594us;1430us;1627us;1430us;1636us;1430us;1641us;1430us;1864us;1430us;2021us;1430us;2025us;1430us;16us;65535us;48us;1985us;79us;1985us;82us;1985us;83us;1985us;84us;1987us;87us;1985us;227us;1985us;246us;1985us;252us;1985us;257us;1985us;261us;1985us;262us;1985us;263us;1985us;264us;1985us;1985us;1985us;1987us;1987us;14us;65535us;48us;88us;79us;88us;82us;88us;83us;88us;87us;88us;227us;265us;246us;265us;252us;253us;257us;259us;261us;265us;262us;265us;263us;265us;264us;265us;1985us;1986us;2us;65535us;84us;85us;1987us;1988us;10us;65535us;172us;2002us;318us;328us;406us;2002us;542us;2002us;721us;722us;914us;916us;916us;918us;997us;1028us;1019us;1021us;1051us;1052us;4us;65535us;221us;222us;312us;313us;517us;518us;520us;521us;2us;65535us;1611us;1612us;1621us;1622us;10us;65535us;118us;119us;443us;444us;456us;457us;459us;460us;461us;462us;463us;464us;469us;470us;548us;549us;550us;551us;554us;555us;2us;65535us;65us;66us;233us;234us;0us;65535us;18us;65535us;76us;77us;138us;139us;243us;244us;320us;321us;323us;324us;372us;373us;473us;474us;672us;704us;699us;700us;702us;703us;1086us;1087us;1136us;1144us;1169us;1170us;1176us;1177us;1183us;1184us;1598us;1602us;1599us;1600us;1622us;1623us;8us;65535us;172us;173us;318us;319us;406us;407us;542us;543us;721us;724us;914us;915us;997us;1027us;1019us;1020us;4us;65535us;52us;53us;57us;58us;749us;750us;755us;756us;0us;65535us;11us;65535us;105us;106us;179us;180us;409us;418us;411us;418us;416us;418us;442us;424us;450us;451us;546us;805us;547us;424us;553us;424us;802us;805us;7us;65535us;106us;107us;193us;727us;196us;727us;477us;478us;486us;487us;725us;727us;805us;806us;4us;65535us;1064us;1154us;1136us;1137us;1146us;1147us;1216us;1292us;9us;65535us;1062us;1141us;1063us;1151us;1065us;1158us;1066us;1300us;1138us;1139us;1148us;1149us;1155us;1156us;1293us;1294us;1296us;1297us;2us;65535us;281us;306us;296us;306us;2us;65535us;95us;127us;120us;123us;2us;65535us;70us;95us;94us;95us;302us;65535us;6us;847us;8us;847us;31us;847us;40us;42us;111us;847us;114us;847us;116us;847us;149us;847us;178us;847us;184us;847us;188us;847us;190us;847us;201us;847us;237us;847us;251us;847us;274us;847us;290us;847us;331us;847us;335us;847us;340us;847us;385us;847us;419us;847us;422us;847us;424us;847us;427us;847us;439us;847us;446us;847us;454us;847us;465us;847us;468us;847us;481us;847us;491us;847us;497us;847us;522us;847us;525us;847us;561us;847us;569us;847us;570us;571us;613us;847us;626us;847us;630us;847us;635us;847us;640us;847us;643us;847us;653us;847us;664us;847us;679us;847us;681us;847us;684us;847us;688us;847us;690us;847us;701us;847us;705us;847us;708us;847us;711us;847us;714us;847us;730us;847us;744us;847us;753us;847us;759us;847us;806us;847us;809us;847us;813us;847us;823us;847us;829us;847us;873us;847us;899us;847us;901us;847us;902us;847us;906us;847us;907us;847us;910us;847us;912us;847us;913us;847us;922us;847us;926us;847us;927us;847us;929us;847us;931us;847us;934us;847us;936us;847us;938us;847us;941us;847us;945us;847us;947us;847us;949us;847us;957us;847us;960us;847us;971us;847us;979us;847us;1000us;847us;1002us;847us;1005us;847us;1008us;847us;1009us;847us;1011us;847us;1012us;847us;1015us;847us;1017us;847us;1018us;847us;1024us;847us;1028us;847us;1030us;847us;1036us;847us;1046us;847us;1052us;847us;1054us;847us;1057us;847us;1060us;847us;1078us;847us;1079us;847us;1083us;847us;1084us;847us;1090us;847us;1093us;847us;1096us;847us;1102us;847us;1106us;847us;1110us;847us;1116us;847us;1118us;847us;1123us;847us;1125us;847us;1127us;847us;1129us;847us;1131us;847us;1133us;847us;1135us;847us;1137us;847us;1147us;847us;1154us;847us;1160us;847us;1162us;847us;1166us;847us;1167us;847us;1171us;847us;1173us;847us;1174us;847us;1178us;847us;1181us;847us;1184us;847us;1186us;847us;1189us;847us;1191us;847us;1231us;847us;1234us;847us;1237us;847us;1240us;847us;1242us;847us;1246us;847us;1248us;847us;1250us;847us;1252us;847us;1254us;847us;1256us;847us;1258us;847us;1260us;847us;1262us;847us;1264us;847us;1266us;847us;1268us;847us;1270us;847us;1272us;847us;1274us;847us;1276us;847us;1278us;847us;1280us;847us;1282us;847us;1284us;847us;1286us;847us;1287us;847us;1288us;847us;1289us;847us;1292us;847us;1302us;847us;1305us;847us;1307us;847us;1313us;847us;1320us;847us;1322us;847us;1327us;847us;1328us;847us;1332us;847us;1334us;847us;1337us;847us;1338us;847us;1340us;847us;1343us;847us;1345us;847us;1347us;847us;1349us;847us;1351us;847us;1352us;847us;1353us;847us;1354us;847us;1356us;847us;1357us;847us;1359us;847us;1360us;847us;1362us;847us;1363us;847us;1365us;847us;1366us;847us;1368us;847us;1369us;847us;1371us;847us;1372us;847us;1374us;847us;1375us;847us;1378us;847us;1379us;847us;1386us;847us;1388us;847us;1390us;847us;1391us;847us;1392us;847us;1395us;847us;1400us;847us;1408us;847us;1409us;847us;1412us;847us;1413us;847us;1431us;847us;1438us;847us;1445us;847us;1452us;847us;1469us;847us;1476us;847us;1477us;847us;1483us;847us;1489us;847us;1490us;847us;1491us;847us;1503us;847us;1509us;847us;1517us;847us;1519us;847us;1532us;847us;1534us;847us;1537us;847us;1538us;847us;1541us;1542us;1544us;847us;1550us;847us;1553us;847us;1555us;847us;1557us;847us;1559us;847us;1564us;847us;1569us;847us;1594us;847us;1619us;847us;1627us;847us;1634us;847us;1636us;847us;1639us;847us;1641us;847us;1651us;847us;1653us;847us;1657us;847us;1659us;847us;1660us;847us;1664us;847us;1668us;847us;1671us;847us;1674us;847us;1677us;847us;1679us;847us;1681us;847us;1686us;847us;1690us;847us;1695us;847us;1700us;847us;1703us;847us;1706us;847us;1709us;847us;1714us;847us;1717us;847us;1719us;847us;1722us;847us;1726us;847us;1729us;847us;1731us;847us;1734us;847us;1737us;847us;1739us;847us;1751us;847us;1757us;847us;1760us;847us;1827us;847us;1831us;847us;1837us;847us;1844us;847us;1848us;847us;1854us;847us;1855us;847us;1864us;847us;1878us;847us;1880us;847us;1891us;847us;2021us;847us;2025us;847us;301us;65535us;6us;848us;8us;848us;31us;848us;40us;43us;111us;848us;114us;848us;116us;848us;149us;848us;178us;848us;184us;848us;188us;848us;190us;848us;201us;848us;237us;848us;251us;848us;274us;848us;290us;848us;331us;848us;335us;848us;340us;848us;385us;848us;419us;848us;422us;848us;424us;848us;427us;848us;439us;848us;446us;848us;454us;848us;465us;848us;468us;848us;481us;848us;491us;848us;497us;848us;522us;848us;525us;848us;561us;848us;569us;848us;570us;848us;613us;848us;626us;848us;630us;848us;635us;848us;640us;848us;643us;848us;653us;848us;664us;848us;679us;848us;681us;848us;684us;848us;688us;848us;690us;848us;701us;848us;705us;848us;708us;848us;711us;848us;714us;848us;730us;848us;744us;848us;753us;848us;759us;848us;806us;848us;809us;848us;813us;848us;823us;848us;829us;848us;873us;848us;899us;848us;901us;848us;902us;848us;906us;848us;907us;848us;910us;848us;912us;848us;913us;848us;922us;848us;926us;848us;927us;848us;929us;848us;931us;848us;934us;848us;936us;848us;938us;848us;941us;848us;945us;848us;947us;848us;949us;848us;957us;848us;960us;848us;971us;848us;979us;848us;1000us;848us;1002us;848us;1005us;848us;1008us;848us;1009us;848us;1011us;848us;1012us;848us;1015us;848us;1017us;848us;1018us;848us;1024us;848us;1028us;848us;1030us;848us;1036us;848us;1046us;848us;1052us;848us;1054us;848us;1057us;848us;1060us;848us;1078us;848us;1079us;848us;1083us;848us;1084us;848us;1090us;848us;1093us;848us;1096us;848us;1102us;848us;1106us;848us;1110us;848us;1116us;848us;1118us;848us;1123us;848us;1125us;848us;1127us;848us;1129us;848us;1131us;848us;1133us;848us;1135us;848us;1137us;848us;1147us;848us;1154us;848us;1160us;848us;1162us;848us;1166us;848us;1167us;848us;1171us;848us;1173us;848us;1174us;848us;1178us;848us;1181us;848us;1184us;848us;1186us;848us;1189us;848us;1191us;848us;1231us;848us;1234us;848us;1237us;848us;1240us;848us;1242us;848us;1246us;848us;1248us;848us;1250us;848us;1252us;848us;1254us;848us;1256us;848us;1258us;848us;1260us;848us;1262us;848us;1264us;848us;1266us;848us;1268us;848us;1270us;848us;1272us;848us;1274us;848us;1276us;848us;1278us;848us;1280us;848us;1282us;848us;1284us;848us;1286us;848us;1287us;848us;1288us;848us;1289us;848us;1292us;848us;1302us;848us;1305us;848us;1307us;848us;1313us;848us;1320us;848us;1322us;848us;1327us;848us;1328us;848us;1332us;848us;1334us;848us;1337us;848us;1338us;848us;1340us;848us;1343us;848us;1345us;848us;1347us;848us;1349us;848us;1351us;848us;1352us;848us;1353us;848us;1354us;848us;1356us;848us;1357us;848us;1359us;848us;1360us;848us;1362us;848us;1363us;848us;1365us;848us;1366us;848us;1368us;848us;1369us;848us;1371us;848us;1372us;848us;1374us;848us;1375us;848us;1378us;848us;1379us;848us;1386us;848us;1388us;848us;1390us;848us;1391us;848us;1392us;848us;1395us;848us;1400us;848us;1408us;848us;1409us;848us;1412us;848us;1413us;848us;1431us;848us;1438us;848us;1445us;848us;1452us;848us;1469us;848us;1476us;848us;1477us;848us;1483us;848us;1489us;848us;1490us;848us;1491us;848us;1503us;848us;1509us;848us;1517us;848us;1519us;848us;1532us;848us;1534us;848us;1537us;848us;1538us;848us;1544us;848us;1550us;848us;1553us;848us;1555us;848us;1557us;848us;1559us;848us;1564us;848us;1569us;848us;1594us;848us;1619us;848us;1627us;848us;1634us;848us;1636us;848us;1639us;848us;1641us;848us;1651us;848us;1653us;848us;1657us;848us;1659us;848us;1660us;848us;1664us;848us;1668us;848us;1671us;848us;1674us;848us;1677us;848us;1679us;848us;1681us;848us;1686us;848us;1690us;848us;1695us;848us;1700us;848us;1703us;848us;1706us;848us;1709us;848us;1714us;848us;1717us;848us;1719us;848us;1722us;848us;1726us;848us;1729us;848us;1731us;848us;1734us;848us;1737us;848us;1739us;848us;1751us;848us;1757us;848us;1760us;848us;1827us;848us;1831us;848us;1837us;848us;1844us;848us;1848us;848us;1854us;848us;1855us;848us;1864us;848us;1878us;848us;1880us;848us;1891us;848us;2021us;848us;2025us;848us;2us;65535us;2021us;2022us;2025us;2026us;4us;65535us;2021us;2024us;2022us;2023us;2025us;2029us;2026us;2027us;155us;65535us;6us;1462us;31us;1462us;114us;1462us;116us;1462us;237us;1462us;251us;1462us;274us;1462us;331us;1462us;335us;1462us;340us;1462us;422us;1462us;427us;1462us;468us;1462us;491us;1462us;525us;1462us;690us;1462us;701us;1462us;753us;1462us;759us;1462us;809us;1462us;813us;1462us;823us;1462us;1030us;1462us;1036us;1462us;1052us;1462us;1054us;1462us;1057us;1462us;1060us;1462us;1079us;1462us;1084us;1462us;1090us;1462us;1093us;1462us;1096us;1462us;1102us;1462us;1106us;1462us;1110us;1462us;1116us;1462us;1118us;1462us;1123us;1462us;1125us;1462us;1127us;1462us;1129us;1462us;1131us;1462us;1133us;1462us;1137us;1462us;1147us;1462us;1154us;1462us;1160us;1462us;1162us;1462us;1167us;1462us;1171us;1462us;1174us;1462us;1178us;1462us;1181us;1462us;1184us;1462us;1186us;1462us;1189us;1462us;1191us;1462us;1240us;1462us;1242us;1462us;1246us;1462us;1248us;1462us;1250us;1462us;1252us;1462us;1254us;1462us;1256us;1462us;1258us;1462us;1260us;1462us;1262us;1462us;1264us;1462us;1266us;1462us;1268us;1462us;1270us;1462us;1272us;1462us;1274us;1462us;1276us;1462us;1278us;1462us;1280us;1462us;1282us;1462us;1284us;1462us;1286us;1462us;1287us;1462us;1288us;1462us;1289us;1462us;1292us;1462us;1302us;1462us;1327us;1462us;1328us;1462us;1332us;1462us;1334us;1462us;1337us;1462us;1338us;1462us;1340us;1462us;1343us;1462us;1345us;1462us;1347us;1462us;1349us;1462us;1351us;1462us;1352us;1462us;1353us;1462us;1354us;1462us;1356us;1462us;1357us;1462us;1359us;1462us;1360us;1462us;1362us;1462us;1363us;1462us;1365us;1462us;1366us;1462us;1368us;1462us;1369us;1462us;1371us;1462us;1372us;1462us;1378us;1462us;1379us;1462us;1386us;1462us;1388us;1462us;1390us;1462us;1391us;1462us;1392us;1462us;1395us;1462us;1400us;1462us;1408us;1462us;1409us;1462us;1412us;1462us;1413us;1462us;1431us;1462us;1438us;1462us;1445us;1462us;1452us;1462us;1469us;1462us;1476us;1462us;1477us;1462us;1483us;1462us;1489us;1462us;1490us;1462us;1491us;1462us;1503us;1462us;1509us;1462us;1519us;1462us;1532us;1462us;1534us;1462us;1537us;1462us;1538us;1462us;1544us;1462us;1559us;1462us;1564us;1462us;1569us;1462us;1594us;1462us;1627us;1462us;1636us;1462us;1641us;1462us;1864us;1462us;2021us;1462us;2025us;1462us;11us;65535us;330us;331us;334us;335us;339us;340us;364us;365us;523us;525us;772us;773us;784us;788us;787us;788us;1376us;1378us;1377us;1379us;1558us;1559us;5us;65535us;109us;620us;182us;620us;452us;620us;596us;615us;926us;620us;14us;65535us;31us;276us;69us;99us;93us;99us;195us;198us;237us;276us;251us;276us;270us;276us;287us;290us;317us;344us;328us;344us;350us;475us;1542us;1549us;2033us;2035us;2034us;2035us;10us;65535us;31us;50us;69us;50us;93us;50us;237us;50us;251us;50us;270us;50us;317us;342us;328us;342us;2038us;2040us;2039us;2040us;9us;65535us;574us;580us;575us;576us;578us;579us;953us;954us;955us;956us;1075us;1523us;1519us;1525us;1520us;1521us;2043us;2044us;5us;65535us;585us;586us;588us;589us;1076us;1631us;1627us;1633us;1628us;1629us;44us;65535us;572us;573us;603us;604us;651us;652us;654us;655us;658us;659us;694us;695us;697us;698us;775us;776us;859us;860us;880us;883us;881us;882us;885us;886us;942us;943us;972us;973us;975us;976us;980us;981us;983us;984us;1073us;1496us;1074us;1497us;1226us;1504us;1245us;1439us;1303us;1304us;1446us;1447us;1450us;1451us;1489us;1492us;1490us;1492us;1491us;1492us;1493us;1494us;1508us;1509us;1515us;1516us;1551us;1552us;1555us;1556us;1752us;1753us;1838us;1839us;1849us;1851us;1850us;1851us;1856us;1857us;1867us;1868us;1903us;1904us;1930us;1931us;1932us;1933us;1936us;1937us;1939us;1940us;2048us;2049us;28us;65535us;75us;76us;79us;80us;117us;118us;121us;122us;125us;126us;141us;142us;159us;160us;167us;168us;213us;214us;242us;243us;246us;247us;263us;303us;293us;294us;297us;298us;300us;301us;338us;339us;371us;379us;375us;376us;395us;397us;399us;401us;538us;539us;814us;815us;1030us;1034us;1031us;1032us;1036us;1039us;1037us;1038us;1058us;1059us;2052us;2053us;1us;65535us;1493us;1495us;49us;65535us;317us;326us;319us;325us;389us;391us;467us;471us;490us;494us;522us;528us;906us;908us;907us;909us;910us;911us;998us;1536us;1011us;1013us;1012us;1014us;1015us;1016us;1135us;1157us;1136us;1143us;1137us;1142us;1138us;1140us;1246us;1247us;1248us;1249us;1250us;1251us;1252us;1253us;1254us;1255us;1256us;1257us;1258us;1259us;1260us;1261us;1262us;1263us;1264us;1265us;1266us;1267us;1268us;1269us;1270us;1271us;1272us;1273us;1274us;1275us;1276us;1277us;1278us;1279us;1280us;1281us;1282us;1283us;1284us;1285us;1343us;1344us;1345us;1346us;1347us;1348us;1349us;1350us;1534us;1535us;1593us;1597us;1594us;1596us;1873us;1874us;1880us;1884us;1885us;1887us;1926us;1928us;1976us;1978us;|]
let _fsyacc_sparseGotoTableRowOffsets = [|0us;1us;2us;3us;4us;5us;7us;15us;20us;26us;31us;36us;41us;46us;70us;72us;74us;76us;83us;88us;90us;93us;96us;99us;103us;110us;120us;130us;140us;143us;145us;148us;152us;154us;157us;160us;163us;167us;176us;185us;197us;201us;204us;207us;210us;216us;218us;220us;223us;226us;229us;233us;239us;249us;260us;271us;287us;312us;314us;316us;319us;321us;403us;526us;649us;651us;654us;657us;662us;669us;672us;676us;678us;681us;684us;687us;691us;700us;711us;713us;716us;720us;724us;729us;740us;744us;747us;749us;802us;825us;900us;902us;907us;910us;913us;916us;919us;923us;926us;931us;936us;939us;944us;954us;1038us;1123us;1128us;1138us;1140us;1142us;1146us;1152us;1154us;1156us;1161us;1165us;1169us;1173us;1177us;1182us;1184us;1188us;1194us;1198us;1202us;1204us;1208us;1212us;1220us;1228us;1235us;1239us;1243us;1247us;1252us;1259us;1261us;1263us;1384us;1392us;1513us;1633us;1637us;1643us;1764us;1766us;1768us;1772us;1775us;1777us;1782us;1785us;1791us;1794us;1796us;1799us;1801us;1803us;1805us;1808us;2109us;2111us;2116us;2120us;2328us;2332us;2336us;2339us;2341us;2343us;2358us;2373us;2388us;2392us;2396us;2437us;2444us;2456us;2509us;2512us;2537us;2562us;2587us;2590us;2593us;2597us;2625us;2632us;2638us;2691us;2693us;2751us;2948us;2953us;3070us;3073us;3075us;3080us;3085us;3093us;3101us;3103us;3105us;3108us;3111us;3113us;3230us;3365us;3501us;3506us;3655us;3659us;3815us;3971us;4179us;4335us;4491us;4495us;4499us;4501us;4657us;4659us;4661us;4663us;4665us;4667us;4669us;4671us;4673us;4677us;4679us;4684us;4686us;4688us;4690us;4693us;4700us;4707us;4711us;4717us;4721us;4723us;4725us;4727us;4730us;4732us;4737us;4743us;4899us;5057us;5174us;5291us;5295us;5301us;5305us;5315us;5325us;5330us;5344us;5355us;5389us;5391us;5425us;5435us;5518us;5636us;5754us;5837us;5861us;5867us;5870us;5953us;5958us;6042us;6136us;6141us;6148us;6158us;6161us;6165us;6167us;6174us;6181us;6188us;6194us;6326us;6712us;6857us;7075us;7083us;7086us;7094us;7107us;7165us;7175us;7324us;7341us;7356us;7359us;7370us;7375us;7378us;7389us;7392us;7393us;7412us;7421us;7426us;7427us;7439us;7447us;7452us;7462us;7465us;7468us;7471us;7774us;8076us;8079us;8084us;8240us;8252us;8258us;8273us;8284us;8294us;8300us;8345us;8374us;8376us;|]
let _fsyacc_stateToProdIdxsTableElements = [| 1us;0us;1us;0us;1us;1us;1us;1us;1us;2us;1us;2us;1us;3us;1us;3us;1us;4us;1us;4us;1us;5us;1us;6us;1us;7us;1us;8us;1us;9us;1us;10us;2us;11us;14us;1us;11us;2us;12us;15us;1us;12us;2us;13us;16us;1us;13us;1us;14us;1us;14us;1us;15us;1us;15us;1us;16us;1us;16us;2us;17us;18us;1us;18us;8us;19us;142us;143us;144us;145us;146us;147us;148us;8us;19us;142us;143us;144us;145us;146us;147us;148us;54us;19us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;20us;2us;21us;22us;1us;22us;1us;23us;1us;24us;1us;25us;1us;25us;2us;25us;27us;1us;27us;1us;28us;1us;29us;2us;30us;31us;1us;30us;1us;31us;1us;31us;3us;32us;50us;53us;1us;32us;3us;33us;34us;35us;3us;33us;34us;35us;3us;33us;34us;35us;3us;33us;34us;35us;3us;33us;1089us;1090us;1us;34us;1us;35us;2us;36us;37us;2us;36us;37us;3us;36us;1089us;1090us;1us;37us;2us;38us;39us;1us;39us;2us;40us;41us;1us;40us;1us;42us;1us;42us;1us;42us;7us;43us;57us;58us;59us;60us;61us;63us;7us;43us;57us;58us;59us;60us;61us;63us;4us;43us;57us;58us;59us;1us;43us;1us;44us;1us;45us;3us;46us;47us;48us;2us;46us;47us;1us;46us;1us;46us;1us;47us;3us;48us;50us;53us;1us;48us;1us;49us;2us;50us;53us;3us;50us;53us;59us;2us;52us;54us;2us;52us;54us;1us;52us;1us;53us;1us;53us;1us;53us;1us;55us;1us;56us;6us;57us;58us;59us;60us;61us;63us;6us;57us;58us;59us;60us;61us;63us;3us;57us;58us;59us;2us;57us;58us;1us;57us;1us;58us;1us;59us;1us;60us;1us;60us;1us;60us;1us;61us;1us;62us;1us;63us;1us;63us;1us;63us;1us;63us;1us;63us;1us;63us;1us;63us;1us;63us;1us;63us;1us;63us;2us;65us;66us;54us;65us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;66us;54us;66us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;66us;1us;66us;3us;67us;68us;155us;1us;67us;1us;67us;1us;68us;1us;68us;1us;68us;1us;68us;1us;69us;1us;69us;1us;69us;1us;70us;1us;70us;1us;70us;2us;72us;73us;1us;72us;1us;72us;1us;73us;3us;74us;83us;84us;1us;74us;1us;74us;1us;74us;1us;74us;1us;74us;1us;74us;1us;75us;1us;75us;1us;76us;1us;77us;1us;78us;1us;78us;1us;78us;1us;79us;3us;80us;81us;82us;2us;80us;81us;1us;80us;1us;81us;1us;82us;1us;82us;2us;83us;84us;2us;83us;84us;1us;83us;1us;84us;2us;85us;86us;2us;85us;86us;1us;85us;1us;86us;2us;87us;88us;2us;87us;88us;1us;87us;1us;88us;1us;89us;1us;90us;1us;92us;1us;92us;1us;92us;8us;93us;94us;95us;96us;97us;98us;99us;100us;13us;93us;94us;95us;96us;97us;98us;99us;100us;296us;297us;298us;299us;300us;8us;93us;94us;95us;96us;97us;98us;99us;100us;13us;93us;94us;95us;96us;97us;98us;99us;100us;296us;297us;298us;299us;300us;1us;93us;1us;93us;1us;93us;1us;93us;1us;93us;1us;93us;1us;93us;1us;93us;1us;93us;1us;94us;4us;94us;985us;986us;987us;2us;95us;96us;4us;95us;985us;986us;987us;1us;96us;1us;97us;1us;97us;6us;98us;99us;185us;186us;229us;230us;1us;98us;1us;98us;1us;99us;1us;99us;1us;100us;1us;100us;1us;100us;1us;102us;1us;102us;2us;103us;104us;2us;103us;104us;1us;103us;1us;104us;3us;105us;106us;107us;2us;106us;107us;1us;106us;1us;107us;1us;108us;1us;108us;1us;108us;1us;109us;1us;110us;1us;111us;1us;111us;1us;112us;1us;112us;1us;112us;2us;114us;115us;1us;114us;1us;115us;1us;115us;2us;116us;139us;1us;116us;2us;117us;118us;1us;118us;2us;119us;120us;1us;119us;1us;121us;1us;121us;1us;121us;12us;122us;130us;131us;132us;134us;142us;143us;144us;145us;146us;147us;148us;11us;122us;130us;131us;132us;142us;143us;144us;145us;146us;147us;148us;3us;122us;147us;148us;1us;122us;1us;123us;3us;124us;125us;126us;2us;124us;125us;1us;124us;1us;124us;1us;125us;2us;126us;139us;1us;126us;1us;127us;1us;128us;11us;130us;131us;132us;134us;142us;143us;144us;145us;146us;147us;148us;10us;130us;131us;132us;142us;143us;144us;145us;146us;147us;148us;56us;130us;131us;132us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;2us;130us;131us;1us;130us;1us;133us;1us;134us;4us;135us;136us;137us;138us;1us;135us;2us;136us;138us;1us;136us;1us;139us;2us;139us;148us;2us;139us;161us;2us;139us;166us;1us;139us;1us;139us;1us;140us;1us;141us;7us;142us;143us;144us;145us;146us;147us;148us;7us;142us;143us;144us;145us;146us;147us;148us;1us;142us;3us;142us;595us;596us;1us;143us;5us;143us;597us;598us;599us;600us;1us;144us;1us;145us;1us;145us;1us;145us;1us;146us;2us;147us;148us;1us;147us;1us;147us;1us;148us;2us;149us;168us;1us;149us;1us;150us;4us;151us;152us;153us;154us;3us;151us;1089us;1090us;1us;152us;2us;153us;154us;4us;153us;985us;986us;987us;1us;154us;3us;155us;1089us;1090us;1us;155us;3us;156us;1089us;1090us;5us;157us;158us;159us;160us;161us;2us;157us;158us;1us;157us;1us;158us;2us;159us;160us;1us;159us;1us;160us;1us;161us;1us;162us;3us;163us;1089us;1090us;3us;164us;165us;166us;2us;164us;165us;1us;164us;1us;165us;1us;166us;1us;167us;1us;167us;1us;167us;1us;168us;2us;170us;171us;1us;171us;4us;172us;173us;174us;175us;3us;172us;174us;177us;2us;172us;174us;1us;172us;1us;172us;2us;173us;590us;1us;173us;1us;173us;1us;174us;1us;175us;1us;176us;2us;177us;1160us;1us;177us;3us;178us;1089us;1090us;1us;178us;1us;178us;2us;179us;180us;3us;179us;1089us;1090us;1us;179us;1us;179us;1us;180us;3us;180us;1089us;1090us;1us;180us;1us;180us;1us;180us;1us;181us;1us;181us;1us;182us;1us;182us;2us;183us;1088us;1us;183us;1us;184us;1us;184us;7us;185us;186us;229us;230us;232us;240us;246us;1us;185us;1us;187us;1us;188us;1us;189us;1us;190us;1us;190us;1us;190us;1us;191us;1us;191us;1us;191us;4us;193us;194us;195us;196us;1us;194us;2us;195us;196us;2us;195us;196us;2us;195us;196us;2us;195us;196us;2us;195us;196us;1us;195us;1us;195us;1us;196us;5us;197us;198us;199us;208us;209us;2us;197us;198us;2us;197us;198us;2us;197us;198us;2us;197us;198us;1us;197us;1us;197us;1us;198us;1us;199us;1us;200us;1us;200us;1us;201us;1us;202us;1us;203us;1us;203us;1us;203us;1us;204us;3us;205us;206us;207us;2us;205us;206us;1us;205us;1us;206us;2us;207us;214us;1us;207us;2us;208us;209us;2us;208us;209us;1us;208us;1us;209us;2us;210us;211us;2us;210us;211us;1us;210us;1us;211us;1us;212us;1us;213us;1us;214us;1us;214us;1us;216us;1us;216us;1us;216us;1us;217us;1us;217us;2us;218us;219us;2us;218us;219us;1us;218us;1us;219us;2us;220us;221us;1us;221us;1us;221us;1us;222us;1us;222us;1us;222us;1us;222us;1us;222us;1us;222us;4us;223us;224us;225us;226us;4us;223us;224us;225us;226us;4us;223us;224us;225us;226us;1us;223us;1us;223us;1us;224us;1us;225us;1us;226us;2us;227us;228us;1us;228us;2us;229us;230us;1us;230us;16us;231us;232us;233us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;21us;231us;232us;233us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;296us;297us;298us;299us;300us;16us;231us;232us;233us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;21us;231us;232us;233us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;296us;297us;298us;299us;300us;1us;231us;1us;232us;3us;233us;234us;241us;1us;233us;1us;233us;1us;234us;2us;235us;236us;4us;235us;985us;986us;987us;1us;235us;1us;236us;1us;237us;1us;237us;1us;237us;1us;237us;1us;237us;1us;237us;1us;237us;1us;237us;1us;238us;1us;239us;1us;239us;1us;240us;1us;240us;1us;241us;1us;241us;4us;242us;243us;244us;245us;3us;242us;243us;244us;3us;242us;243us;244us;1us;242us;1us;242us;1us;242us;1us;243us;1us;244us;1us;245us;1us;245us;1us;246us;1us;246us;4us;247us;248us;249us;250us;4us;247us;248us;249us;250us;4us;247us;248us;249us;250us;3us;247us;248us;249us;2us;247us;248us;1us;247us;1us;248us;1us;249us;1us;250us;4us;251us;252us;253us;254us;4us;251us;252us;253us;254us;4us;251us;252us;253us;254us;3us;251us;252us;253us;3us;251us;252us;253us;1us;251us;1us;251us;1us;251us;1us;252us;1us;253us;1us;254us;2us;256us;257us;1us;256us;1us;257us;2us;258us;528us;1us;258us;1us;258us;1us;259us;1us;259us;1us;259us;1us;260us;2us;261us;262us;1us;261us;1us;261us;1us;261us;1us;262us;1us;264us;1us;265us;1us;266us;1us;267us;2us;268us;269us;1us;268us;1us;268us;1us;271us;1us;271us;1us;271us;3us;273us;274us;275us;2us;273us;274us;1us;273us;1us;274us;1us;274us;1us;274us;1us;275us;1us;276us;2us;278us;279us;1us;278us;1us;279us;1us;280us;2us;282us;283us;1us;282us;1us;283us;2us;284us;285us;2us;284us;285us;1us;284us;1us;285us;1us;286us;2us;287us;288us;2us;287us;288us;1us;287us;4us;289us;290us;291us;292us;5us;289us;290us;291us;292us;429us;3us;289us;290us;291us;1us;289us;1us;289us;1us;290us;1us;290us;1us;291us;1us;292us;1us;292us;1us;292us;1us;293us;1us;293us;1us;294us;1us;295us;5us;296us;297us;298us;299us;300us;5us;296us;297us;298us;299us;300us;4us;296us;981us;1089us;1090us;1us;296us;1us;296us;1us;296us;1us;297us;1us;298us;1us;299us;5us;300us;988us;1038us;1039us;1050us;2us;300us;1035us;2us;300us;460us;1us;300us;1us;300us;4us;301us;302us;303us;304us;2us;301us;302us;1us;301us;1us;302us;1us;303us;1us;303us;1us;304us;6us;305us;1040us;1041us;1042us;1043us;1044us;1us;305us;1us;306us;3us;307us;308us;309us;2us;307us;308us;1us;307us;1us;308us;1us;309us;1us;309us;1us;310us;1us;311us;1us;312us;1us;313us;1us;314us;4us;315us;316us;317us;318us;4us;315us;317us;1089us;1090us;1us;316us;3us;316us;1089us;1090us;1us;317us;1us;318us;1us;319us;1us;320us;2us;320us;321us;1us;320us;2us;321us;325us;3us;321us;326us;327us;1us;321us;2us;321us;326us;1us;321us;1us;322us;2us;323us;324us;2us;323us;324us;1us;324us;2us;324us;336us;1us;325us;1us;325us;1us;325us;1us;325us;1us;326us;1us;329us;1us;329us;1us;329us;1us;329us;1us;329us;1us;330us;1us;333us;2us;333us;334us;2us;334us;928us;2us;334us;930us;1us;334us;1us;334us;1us;335us;2us;336us;979us;2us;336us;980us;1us;336us;3us;336us;1052us;1053us;3us;337us;1052us;1053us;1us;338us;1us;338us;1us;338us;1us;338us;11us;339us;340us;341us;342us;343us;345us;346us;347us;979us;982us;991us;2us;339us;991us;2us;339us;991us;7us;340us;341us;342us;343us;345us;346us;347us;1us;340us;3us;341us;346us;347us;1us;341us;1us;342us;1us;343us;1us;343us;1us;343us;5us;344us;988us;1038us;1039us;1050us;2us;344us;349us;1us;344us;1us;344us;1us;344us;1us;344us;1us;344us;1us;345us;1us;345us;1us;346us;4us;348us;985us;986us;987us;1us;349us;4us;349us;985us;986us;987us;9us;350us;964us;965us;969us;970us;971us;985us;986us;987us;1us;351us;1us;351us;1us;352us;1us;352us;1us;352us;2us;353us;371us;1us;354us;2us;355us;356us;1us;355us;1us;355us;9us;357us;358us;359us;360us;361us;362us;363us;364us;365us;9us;357us;358us;359us;360us;361us;362us;363us;364us;365us;6us;357us;359us;360us;363us;364us;365us;1us;358us;2us;359us;363us;1us;359us;1us;360us;2us;361us;362us;1us;361us;1us;362us;1us;363us;1us;364us;1us;364us;1us;365us;6us;365us;769us;770us;771us;775us;778us;1us;366us;6us;367us;368us;1091us;1092us;1094us;1095us;1us;367us;1us;367us;1us;368us;1us;368us;1us;368us;6us;369us;370us;372us;373us;375us;1088us;1us;369us;2us;370us;375us;7us;370us;375us;769us;770us;771us;775us;778us;2us;370us;375us;1us;371us;2us;372us;373us;1us;372us;1us;373us;1us;374us;1us;374us;2us;376us;377us;1us;376us;1us;376us;3us;378us;380us;1088us;2us;378us;380us;8us;378us;955us;956us;957us;958us;985us;986us;987us;8us;379us;955us;956us;957us;958us;985us;986us;987us;1us;380us;1us;381us;1us;382us;1us;383us;2us;384us;385us;2us;384us;1160us;1us;384us;1us;385us;1us;386us;1us;386us;4us;387us;388us;389us;390us;4us;387us;388us;389us;390us;3us;387us;388us;389us;2us;387us;388us;1us;387us;1us;388us;1us;389us;1us;390us;1us;391us;1us;391us;2us;392us;393us;2us;392us;393us;2us;392us;393us;1us;392us;1us;392us;1us;393us;3us;394us;395us;396us;2us;395us;396us;1us;395us;1us;396us;1us;398us;3us;398us;1089us;1090us;1us;399us;1us;399us;1us;399us;1us;400us;1us;401us;1us;401us;1us;402us;1us;402us;1us;402us;1us;402us;2us;403us;404us;1us;403us;1us;403us;1us;404us;1us;405us;1us;406us;1us;407us;1us;408us;1us;409us;1us;410us;1us;411us;1us;411us;1us;411us;1us;411us;1us;411us;1us;411us;1us;411us;1us;411us;2us;412us;415us;2us;413us;416us;1us;415us;1us;415us;1us;416us;1us;416us;2us;417us;418us;5us;417us;418us;420us;421us;422us;1us;418us;3us;419us;1089us;1090us;4us;420us;421us;422us;424us;1us;420us;1us;420us;1us;420us;1us;421us;1us;422us;1us;423us;2us;423us;425us;1us;423us;2us;424us;425us;1us;426us;1us;426us;1us;427us;1us;427us;1us;427us;1us;429us;1us;429us;1us;430us;3us;431us;432us;433us;3us;431us;432us;433us;3us;431us;432us;433us;3us;431us;432us;433us;2us;431us;432us;1us;431us;1us;432us;1us;433us;2us;434us;435us;2us;434us;435us;1us;434us;1us;435us;1us;436us;1us;437us;2us;437us;438us;1us;438us;1us;440us;2us;440us;441us;1us;440us;1us;440us;1us;441us;1us;441us;1us;442us;2us;443us;444us;1us;443us;1us;443us;1us;444us;1us;445us;1us;446us;1us;447us;1us;448us;1us;449us;1us;450us;1us;451us;1us;452us;1us;453us;1us;454us;1us;455us;1us;456us;1us;457us;1us;458us;1us;459us;1us;460us;1us;461us;1us;462us;2us;463us;465us;1us;463us;1us;463us;2us;464us;466us;2us;464us;466us;1us;464us;1us;464us;1us;467us;1us;468us;1us;468us;1us;468us;1us;469us;1us;470us;1us;470us;2us;471us;472us;1us;472us;1us;472us;7us;473us;488us;489us;490us;495us;497us;501us;1us;474us;1us;475us;1us;475us;3us;476us;477us;478us;4us;476us;477us;479us;480us;2us;476us;477us;1us;476us;1us;477us;1us;478us;1us;480us;1us;480us;1us;481us;5us;483us;484us;485us;486us;487us;2us;483us;485us;1us;483us;1us;484us;1us;485us;2us;486us;590us;1us;486us;1us;487us;7us;488us;489us;489us;490us;495us;497us;501us;7us;488us;489us;490us;490us;495us;497us;501us;7us;488us;489us;490us;494us;495us;497us;501us;7us;488us;489us;490us;495us;495us;497us;501us;7us;488us;489us;490us;495us;497us;498us;501us;7us;488us;489us;490us;495us;497us;500us;501us;7us;488us;489us;490us;495us;497us;501us;501us;7us;488us;489us;490us;495us;497us;501us;592us;7us;488us;489us;490us;495us;497us;501us;593us;7us;488us;489us;490us;495us;497us;501us;643us;8us;488us;489us;490us;495us;497us;501us;644us;645us;1us;488us;1us;488us;1us;489us;1us;490us;3us;491us;494us;496us;2us;492us;500us;1us;493us;2us;494us;496us;2us;495us;497us;1us;496us;1us;497us;2us;498us;499us;1us;499us;1us;500us;1us;501us;3us;502us;503us;504us;1us;502us;3us;503us;504us;1160us;1us;503us;1us;504us;1us;504us;3us;505us;506us;507us;6us;505us;506us;507us;1127us;1129us;1130us;2us;505us;506us;9us;505us;545us;546us;549us;550us;552us;555us;557us;561us;1us;506us;1us;507us;8us;508us;509us;510us;511us;512us;513us;514us;530us;4us;508us;509us;510us;511us;1us;509us;1us;510us;1us;510us;1us;511us;1us;511us;1us;512us;1us;513us;1us;513us;1us;514us;1us;514us;1us;515us;1us;515us;1us;516us;9us;517us;535us;536us;537us;538us;1091us;1092us;1094us;1095us;1us;517us;1us;517us;1us;518us;4us;519us;520us;521us;522us;1us;519us;1us;520us;1us;520us;1us;521us;1us;521us;1us;523us;2us;524us;525us;1us;524us;1us;524us;1us;525us;1us;525us;1us;526us;1us;526us;1us;526us;1us;527us;1us;527us;1us;527us;1us;529us;2us;529us;1112us;1us;529us;1us;530us;1us;531us;1us;532us;1us;533us;1us;534us;8us;535us;536us;537us;538us;1091us;1092us;1094us;1095us;2us;535us;536us;1us;535us;1us;536us;3us;537us;590us;1092us;2us;537us;1092us;1us;538us;4us;539us;540us;541us;542us;4us;539us;540us;541us;542us;5us;539us;540us;547us;554us;556us;1us;539us;1us;540us;2us;541us;590us;1us;541us;1us;542us;9us;543us;545us;546us;549us;550us;552us;555us;557us;561us;9us;545us;546us;546us;549us;550us;552us;555us;557us;561us;9us;545us;546us;549us;550us;551us;552us;555us;557us;561us;9us;545us;546us;549us;550us;552us;552us;555us;557us;561us;9us;545us;546us;549us;550us;552us;554us;555us;557us;561us;9us;545us;546us;549us;550us;552us;555us;555us;557us;561us;9us;545us;546us;549us;550us;552us;555us;557us;558us;561us;9us;545us;546us;549us;550us;552us;555us;557us;560us;561us;8us;545us;546us;549us;550us;552us;555us;557us;561us;9us;545us;546us;549us;550us;552us;555us;557us;561us;561us;9us;545us;546us;549us;550us;552us;555us;557us;561us;564us;10us;545us;546us;549us;550us;552us;555us;557us;561us;568us;569us;14us;545us;546us;549us;550us;552us;555us;557us;561us;637us;638us;852us;853us;854us;855us;9us;545us;546us;549us;550us;552us;555us;557us;561us;720us;1us;545us;1us;545us;1us;546us;3us;547us;554us;556us;2us;548us;560us;2us;549us;550us;1us;549us;1us;550us;1us;551us;1us;552us;1us;553us;2us;554us;556us;2us;555us;557us;1us;556us;1us;557us;2us;558us;559us;1us;559us;1us;560us;1us;561us;2us;562us;563us;1us;562us;2us;563us;1160us;1us;563us;5us;564us;565us;566us;1089us;1090us;2us;564us;565us;1us;565us;1us;566us;1us;568us;2us;569us;1160us;1us;569us;3us;570us;571us;572us;2us;570us;571us;1us;570us;1us;571us;1us;572us;1us;573us;2us;574us;575us;1us;574us;1us;574us;1us;575us;54us;576us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;2us;577us;578us;1us;577us;1us;579us;2us;579us;922us;3us;580us;581us;582us;2us;580us;581us;1us;580us;1us;581us;1us;583us;1us;583us;58us;584us;585us;586us;587us;588us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;2us;584us;585us;1us;584us;1us;587us;1us;587us;1us;588us;1us;588us;1us;588us;1us;588us;5us;589us;597us;598us;599us;600us;1us;590us;2us;590us;626us;2us;590us;632us;2us;590us;635us;2us;590us;637us;2us;590us;709us;2us;590us;719us;2us;590us;723us;2us;590us;783us;2us;590us;796us;2us;590us;815us;2us;590us;819us;2us;590us;824us;3us;590us;824us;1092us;2us;590us;840us;2us;590us;914us;1us;591us;1us;592us;1us;592us;1us;592us;1us;592us;1us;592us;1us;593us;1us;593us;1us;593us;1us;593us;1us;593us;1us;593us;2us;595us;596us;2us;595us;596us;1us;595us;1us;596us;4us;597us;598us;599us;600us;1us;597us;1us;598us;2us;599us;600us;1us;599us;1us;600us;1us;601us;1us;602us;1us;603us;2us;604us;605us;2us;604us;605us;1us;604us;1us;605us;2us;606us;607us;2us;606us;607us;1us;606us;1us;607us;5us;608us;609us;610us;611us;612us;3us;608us;609us;612us;1us;608us;1us;609us;2us;610us;611us;1us;611us;1us;612us;1us;612us;3us;613us;614us;615us;55us;613us;614us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;613us;1us;614us;1us;615us;1us;616us;54us;616us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;2us;617us;618us;54us;617us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;619us;1us;619us;2us;620us;621us;1us;620us;1us;622us;1us;622us;1us;623us;1us;623us;15us;624us;625us;626us;627us;628us;629us;630us;631us;632us;633us;634us;635us;636us;637us;638us;6us;624us;625us;626us;627us;628us;629us;4us;624us;625us;626us;627us;2us;624us;625us;1us;624us;1us;625us;1us;626us;1us;627us;1us;628us;1us;629us;1us;629us;5us;630us;631us;632us;633us;634us;4us;630us;631us;632us;633us;2us;630us;631us;1us;630us;1us;631us;1us;632us;1us;633us;1us;634us;1us;635us;1us;635us;1us;635us;1us;636us;1us;637us;2us;638us;1221us;2us;639us;641us;54us;639us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;2us;640us;642us;54us;640us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;641us;1us;642us;1us;643us;1us;643us;1us;643us;1us;643us;1us;643us;1us;643us;1us;643us;2us;644us;645us;2us;644us;645us;2us;644us;645us;2us;644us;645us;2us;644us;645us;1us;644us;1us;644us;1us;645us;1us;646us;1us;646us;1us;646us;1us;646us;1us;646us;1us;647us;1us;647us;1us;647us;1us;648us;54us;648us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1us;649us;1us;649us;54us;650us;651us;652us;653us;654us;655us;656us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;744us;745us;746us;747us;57us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;704us;705us;706us;707us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;727us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;731us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;736us;744us;745us;746us;747us;55us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;738us;739us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;740us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;742us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;745us;746us;747us;53us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;747us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;830us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;852us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;855us;54us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;855us;55us;650us;651us;652us;653us;654us;655us;656us;659us;660us;661us;662us;663us;664us;665us;666us;667us;668us;669us;670us;671us;672us;673us;674us;675us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;744us;745us;746us;747us;1182us;1183us;2us;650us;651us;1us;650us;1us;651us;2us;652us;653us;1us;652us;1us;653us;2us;654us;655us;1us;654us;1us;655us;1us;656us;2us;657us;703us;1us;657us;1us;657us;5us;658us;740us;741us;742us;743us;7us;658us;740us;741us;742us;743us;785us;786us;2us;659us;660us;1us;660us;2us;661us;662us;1us;662us;2us;663us;664us;1us;664us;2us;665us;666us;1us;666us;2us;667us;668us;1us;668us;2us;669us;670us;1us;670us;2us;671us;672us;1us;672us;2us;673us;674us;1us;674us;2us;675us;676us;1us;676us;2us;677us;678us;1us;678us;2us;679us;680us;1us;680us;2us;681us;682us;1us;682us;2us;683us;684us;1us;684us;2us;685us;686us;1us;686us;2us;687us;688us;1us;688us;2us;689us;690us;1us;690us;2us;691us;692us;1us;692us;2us;693us;694us;1us;694us;2us;695us;696us;1us;696us;2us;697us;698us;1us;698us;2us;699us;700us;1us;701us;3us;701us;1119us;1120us;2us;701us;1120us;1us;702us;2us;702us;1107us;3us;704us;705us;706us;2us;704us;705us;1us;704us;1us;705us;1us;706us;1us;706us;1us;707us;1us;708us;1us;709us;1us;710us;1us;711us;1us;711us;1us;711us;1us;712us;1us;712us;3us;713us;714us;715us;2us;713us;714us;1us;713us;1us;714us;1us;715us;1us;716us;2us;717us;718us;1us;717us;1us;718us;1us;719us;1us;720us;6us;721us;722us;723us;724us;725us;726us;4us;721us;722us;724us;725us;2us;722us;724us;1us;722us;1us;723us;1us;723us;1us;724us;1us;725us;1us;726us;1us;727us;1us;729us;1us;729us;1us;730us;1us;730us;2us;731us;732us;1us;732us;2us;733us;734us;1us;733us;1us;734us;1us;736us;1us;737us;1us;737us;2us;738us;739us;1us;738us;1us;739us;4us;740us;741us;742us;743us;1us;741us;2us;742us;743us;1us;743us;4us;744us;745us;746us;747us;1us;744us;2us;746us;747us;1us;746us;1us;748us;2us;748us;1085us;3us;748us;1085us;1099us;2us;748us;1099us;1us;748us;1us;749us;2us;749us;1106us;1us;749us;1us;750us;2us;750us;1102us;1us;750us;1us;751us;2us;751us;1105us;1us;751us;1us;752us;2us;752us;1118us;1us;752us;1us;753us;2us;753us;1113us;1us;753us;1us;754us;2us;754us;1114us;1us;754us;4us;755us;756us;757us;758us;8us;755us;756us;757us;758us;896us;897us;898us;899us;3us;755us;756us;757us;7us;755us;756us;757us;896us;897us;898us;899us;3us;755us;756us;757us;5us;755us;756us;757us;897us;898us;2us;755us;756us;4us;755us;756us;897us;898us;1us;755us;1us;755us;1us;757us;1us;758us;1us;759us;1us;759us;1us;760us;1us;760us;2us;761us;762us;8us;761us;762us;870us;871us;872us;876us;877us;878us;7us;762us;870us;871us;872us;876us;877us;878us;1us;762us;6us;763us;769us;770us;771us;775us;778us;1us;764us;6us;764us;769us;770us;771us;775us;778us;6us;765us;769us;770us;771us;775us;778us;3us;766us;767us;768us;6us;766us;767us;768us;873us;874us;875us;2us;766us;767us;6us;766us;769us;770us;771us;775us;778us;1us;767us;1us;768us;6us;769us;769us;770us;771us;775us;778us;6us;769us;770us;770us;771us;775us;778us;6us;769us;770us;771us;772us;775us;778us;6us;769us;770us;771us;775us;778us;1047us;1us;769us;1us;770us;1us;771us;1us;771us;1us;772us;2us;772us;1096us;1us;773us;2us;773us;1084us;1us;773us;2us;773us;1084us;1us;774us;1us;775us;1us;775us;1us;776us;1us;776us;1us;776us;1us;777us;2us;777us;1112us;1us;777us;1us;778us;1us;778us;1us;779us;1us;780us;4us;781us;782us;783us;784us;2us;781us;782us;1us;781us;1us;782us;1us;783us;1us;784us;3us;785us;786us;910us;2us;785us;786us;1us;785us;1us;786us;1us;787us;1us;788us;1us;789us;1us;791us;6us;792us;793us;1091us;1092us;1094us;1095us;1us;792us;1us;792us;1us;792us;1us;792us;1us;793us;1us;793us;4us;794us;795us;796us;797us;2us;794us;795us;1us;794us;1us;795us;1us;796us;1us;797us;1us;798us;1us;799us;1us;800us;1us;801us;1us;802us;1us;803us;1us;804us;1us;805us;1us;806us;1us;807us;1us;808us;4us;809us;810us;811us;812us;2us;809us;810us;1us;809us;1us;810us;1us;811us;1us;811us;1us;812us;4us;813us;814us;815us;816us;5us;813us;814us;815us;816us;1121us;2us;813us;814us;1us;813us;1us;814us;1us;815us;1us;816us;4us;817us;818us;819us;820us;2us;817us;818us;1us;817us;1us;818us;1us;819us;1us;820us;10us;821us;822us;823us;824us;825us;826us;827us;828us;829us;830us;15us;821us;822us;823us;824us;825us;826us;827us;828us;829us;830us;835us;1091us;1092us;1094us;1095us;14us;821us;822us;823us;824us;825us;826us;827us;828us;829us;830us;1091us;1092us;1094us;1095us;1us;821us;2us;822us;823us;1us;822us;1us;823us;1us;824us;2us;824us;1092us;1us;825us;1us;826us;1us;827us;1us;828us;1us;829us;1us;830us;1us;830us;1us;831us;1us;831us;1us;831us;1us;831us;1us;831us;1us;831us;1us;832us;1us;833us;1us;834us;2us;834us;837us;2us;835us;836us;1us;835us;1us;836us;4us;836us;985us;986us;987us;5us;838us;839us;840us;841us;842us;2us;838us;839us;1us;838us;1us;839us;1us;840us;1us;841us;1us;842us;1us;843us;1us;844us;1us;845us;1us;846us;1us;848us;1us;850us;1us;851us;1us;851us;2us;852us;853us;1us;853us;1us;854us;1us;855us;1us;855us;1us;856us;1us;857us;1us;858us;1us;858us;1us;858us;2us;858us;859us;1us;858us;1us;858us;1us;859us;1us;862us;1us;864us;1us;864us;1us;864us;1us;864us;2us;866us;867us;1us;866us;5us;867us;988us;1038us;1039us;1050us;1us;867us;1us;868us;1us;868us;1us;868us;1us;868us;2us;868us;887us;1us;868us;1us;869us;2us;870us;871us;1us;870us;2us;870us;887us;1us;870us;1us;871us;2us;874us;875us;1us;875us;2us;875us;887us;1us;875us;1us;876us;1us;876us;2us;876us;887us;1us;876us;2us;877us;878us;1us;877us;1us;877us;1us;878us;2us;878us;887us;1us;878us;1us;878us;1us;879us;2us;879us;887us;2us;881us;884us;2us;882us;883us;1us;883us;1us;884us;3us;885us;1089us;1090us;1us;886us;1us;887us;5us;889us;890us;891us;892us;893us;3us;889us;890us;891us;1us;889us;1us;891us;1us;893us;2us;894us;895us;1us;894us;1us;894us;1us;894us;1us;895us;1us;895us;1us;897us;1us;900us;2us;902us;904us;1us;902us;1us;903us;1us;903us;1us;903us;1us;904us;1us;904us;1us;905us;1us;905us;1us;907us;1us;907us;1us;908us;1us;908us;1us;909us;4us;909us;985us;986us;987us;1us;909us;1us;909us;1us;909us;1us;910us;1us;910us;1us;911us;5us;912us;913us;914us;915us;916us;2us;912us;913us;1us;912us;1us;913us;1us;914us;1us;915us;1us;916us;2us;917us;918us;2us;917us;918us;2us;917us;918us;1us;917us;1us;918us;6us;919us;920us;921us;922us;923us;924us;5us;919us;920us;921us;922us;923us;4us;919us;920us;921us;922us;2us;919us;920us;1us;919us;1us;920us;1us;921us;1us;921us;1us;923us;1us;923us;1us;924us;1us;924us;1us;925us;1us;925us;1us;926us;1us;926us;1us;926us;2us;927us;928us;1us;928us;2us;929us;930us;1us;930us;2us;932us;933us;1us;932us;1us;933us;3us;934us;935us;936us;2us;934us;935us;1us;934us;1us;935us;3us;937us;938us;940us;2us;937us;938us;1us;937us;1us;938us;1us;939us;1us;939us;3us;941us;942us;944us;2us;941us;942us;1us;941us;1us;942us;1us;943us;1us;943us;5us;945us;946us;947us;948us;949us;6us;945us;946us;949us;985us;986us;987us;2us;945us;946us;4us;945us;985us;986us;987us;1us;946us;2us;947us;948us;2us;947us;948us;2us;947us;948us;4us;947us;985us;986us;987us;1us;948us;6us;950us;951us;954us;985us;986us;987us;2us;950us;951us;4us;950us;985us;986us;987us;1us;951us;2us;952us;953us;2us;952us;953us;2us;952us;953us;4us;952us;985us;986us;987us;1us;953us;8us;955us;956us;957us;958us;958us;985us;986us;987us;7us;955us;956us;957us;958us;985us;986us;987us;4us;955us;956us;957us;958us;1us;955us;1us;956us;1us;957us;1us;957us;4us;959us;960us;961us;962us;3us;959us;960us;961us;1us;959us;1us;960us;1us;961us;1us;961us;1us;963us;1us;963us;8us;964us;965us;969us;970us;971us;985us;986us;987us;2us;964us;965us;1us;964us;1us;965us;1us;966us;1us;966us;2us;967us;968us;1us;967us;1us;968us;2us;969us;970us;1us;969us;1us;970us;8us;972us;973us;975us;976us;978us;985us;986us;987us;2us;972us;973us;1us;972us;1us;973us;1us;974us;1us;974us;2us;975us;976us;1us;975us;1us;976us;1us;977us;1us;977us;3us;979us;982us;991us;1us;979us;4us;980us;1033us;1052us;1053us;1us;980us;3us;981us;1089us;1090us;1us;982us;2us;983us;984us;4us;983us;984us;1051us;1054us;1us;983us;1us;983us;7us;985us;986us;987us;1040us;1041us;1042us;1043us;1us;985us;1us;986us;1us;986us;1us;987us;4us;988us;1038us;1039us;1050us;1us;988us;1us;988us;1us;988us;1us;989us;1us;990us;1us;991us;1us;991us;2us;992us;1037us;1us;992us;1us;992us;32us;993us;994us;995us;996us;997us;998us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;993us;31us;994us;995us;996us;997us;998us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;994us;30us;995us;996us;997us;998us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;995us;29us;996us;997us;998us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;996us;28us;997us;998us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;997us;27us;998us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;998us;26us;999us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;999us;25us;1000us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1000us;24us;1001us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1001us;23us;1002us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1002us;22us;1003us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1003us;21us;1004us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1004us;20us;1005us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1005us;19us;1006us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1006us;18us;1007us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1007us;17us;1008us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1008us;16us;1009us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1009us;15us;1010us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1010us;14us;1011us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1011us;13us;1012us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1012us;12us;1013us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1013us;11us;1014us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1014us;10us;1015us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1015us;9us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1016us;8us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1017us;7us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1018us;6us;1019us;1020us;1021us;1022us;1023us;1024us;1us;1019us;5us;1020us;1021us;1022us;1023us;1024us;1us;1020us;4us;1021us;1022us;1023us;1024us;1us;1021us;3us;1022us;1023us;1024us;1us;1022us;2us;1023us;1024us;1us;1023us;1us;1024us;1us;1024us;1us;1025us;1us;1025us;1us;1025us;3us;1025us;1026us;1027us;4us;1026us;1027us;1057us;1058us;2us;1026us;1027us;1us;1026us;1us;1027us;2us;1029us;1030us;1us;1030us;1us;1030us;4us;1031us;1038us;1039us;1050us;1us;1031us;1us;1031us;1us;1031us;3us;1032us;1052us;1053us;3us;1033us;1052us;1053us;1us;1034us;1us;1035us;3us;1035us;1052us;1053us;1us;1036us;1us;1037us;3us;1038us;1039us;1050us;2us;1038us;1039us;5us;1038us;1039us;1064us;1065us;1066us;1us;1038us;1us;1039us;5us;1040us;1041us;1042us;1043us;1044us;5us;1040us;1041us;1042us;1043us;1044us;3us;1040us;1041us;1042us;2us;1040us;1041us;1us;1040us;1us;1041us;1us;1042us;1us;1043us;1us;1044us;1us;1045us;1us;1046us;1us;1047us;1us;1048us;1us;1049us;1us;1050us;1us;1050us;1us;1051us;2us;1052us;1053us;4us;1052us;1053us;1089us;1090us;1us;1053us;1us;1054us;1us;1054us;1us;1055us;1us;1056us;1us;1056us;7us;1057us;1058us;1059us;1060us;1061us;1062us;1063us;3us;1057us;1058us;1059us;3us;1057us;1058us;1059us;2us;1057us;1058us;1us;1057us;1us;1058us;1us;1059us;3us;1060us;1061us;1067us;1us;1060us;1us;1061us;1us;1062us;1us;1063us;3us;1064us;1065us;1066us;2us;1065us;1066us;1us;1065us;1us;1067us;1us;1068us;2us;1070us;1071us;3us;1070us;1081us;1082us;1us;1070us;1us;1071us;1us;1071us;3us;1072us;1089us;1090us;1us;1073us;1us;1074us;3us;1074us;1081us;1082us;1us;1074us;2us;1075us;1076us;1us;1076us;1us;1076us;1us;1077us;2us;1078us;1079us;1us;1079us;1us;1080us;3us;1081us;1081us;1082us;3us;1081us;1082us;1082us;3us;1081us;1082us;1083us;1us;1081us;1us;1082us;1us;1083us;1us;1084us;1us;1084us;1us;1085us;1us;1085us;2us;1085us;1132us;1us;1086us;1us;1087us;1us;1088us;2us;1089us;1090us;1us;1089us;1us;1090us;4us;1091us;1092us;1094us;1095us;1us;1091us;1us;1091us;1us;1092us;1us;1092us;1us;1093us;3us;1094us;1095us;1124us;3us;1094us;1095us;1124us;1us;1094us;1us;1095us;1us;1095us;1us;1095us;1us;1096us;1us;1097us;1us;1098us;1us;1099us;1us;1100us;1us;1101us;1us;1102us;1us;1103us;1us;1104us;1us;1105us;1us;1106us;1us;1107us;1us;1108us;1us;1109us;1us;1110us;1us;1111us;1us;1112us;1us;1113us;1us;1114us;1us;1115us;1us;1116us;1us;1117us;1us;1118us;2us;1119us;1120us;1us;1120us;1us;1121us;1us;1121us;1us;1122us;1us;1123us;1us;1123us;1us;1124us;1us;1125us;1us;1126us;3us;1127us;1129us;1130us;1us;1128us;2us;1129us;1130us;1us;1129us;1us;1130us;1us;1131us;1us;1132us;1us;1133us;1us;1134us;1us;1135us;1us;1136us;2us;1137us;1138us;1us;1138us;1us;1139us;1us;1139us;2us;1141us;1143us;2us;1142us;1144us;1us;1143us;1us;1144us;1us;1145us;1us;1146us;1us;1147us;1us;1148us;1us;1149us;1us;1150us;1us;1152us;1us;1154us;1us;1158us;1us;1160us;1us;1162us;1us;1166us;1us;1168us;1us;1170us;1us;1171us;1us;1172us;1us;1173us;1us;1174us;1us;1175us;1us;1176us;1us;1177us;1us;1178us;1us;1179us;1us;1180us;1us;1181us;1us;1183us;1us;1183us;1us;1184us;2us;1185us;1186us;1us;1185us;1us;1185us;1us;1186us;2us;1187us;1189us;1us;1187us;1us;1187us;1us;1188us;1us;1189us;1us;1190us;1us;1191us;1us;1193us;1us;1195us;2us;1195us;1216us;1us;1195us;1us;1196us;1us;1197us;1us;1198us;2us;1198us;1217us;1us;1198us;1us;1199us;1us;1200us;1us;1201us;1us;1201us;1us;1202us;1us;1203us;1us;1204us;1us;1205us;1us;1205us;1us;1206us;1us;1207us;1us;1208us;1us;1208us;1us;1209us;1us;1210us;1us;1211us;1us;1212us;1us;1213us;1us;1214us;1us;1215us;1us;1216us;1us;1217us;1us;1218us;1us;1219us;1us;1220us;1us;1221us;|]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us;2us;4us;6us;8us;10us;12us;14us;16us;18us;20us;22us;24us;26us;28us;30us;32us;35us;37us;40us;42us;45us;47us;49us;51us;53us;55us;57us;59us;62us;64us;73us;82us;137us;139us;142us;144us;146us;148us;150us;152us;155us;157us;159us;161us;164us;166us;168us;170us;174us;176us;180us;184us;188us;192us;196us;198us;200us;203us;206us;210us;212us;215us;217us;220us;222us;224us;226us;228us;236us;244us;249us;251us;253us;255us;259us;262us;264us;266us;268us;272us;274us;276us;279us;283us;286us;289us;291us;293us;295us;297us;299us;301us;308us;315us;319us;322us;324us;326us;328us;330us;332us;334us;336us;338us;340us;342us;344us;346us;348us;350us;352us;354us;356us;358us;361us;416us;418us;473us;475us;477us;481us;483us;485us;487us;489us;491us;493us;495us;497us;499us;501us;503us;505us;508us;510us;512us;514us;518us;520us;522us;524us;526us;528us;530us;532us;534us;536us;538us;540us;542us;544us;546us;550us;553us;555us;557us;559us;561us;564us;567us;569us;571us;574us;577us;579us;581us;584us;587us;589us;591us;593us;595us;597us;599us;601us;610us;624us;633us;647us;649us;651us;653us;655us;657us;659us;661us;663us;665us;667us;672us;675us;680us;682us;684us;686us;693us;695us;697us;699us;701us;703us;705us;707us;709us;711us;714us;717us;719us;721us;725us;728us;730us;732us;734us;736us;738us;740us;742us;744us;746us;748us;750us;752us;755us;757us;759us;761us;764us;766us;769us;771us;774us;776us;778us;780us;782us;795us;807us;811us;813us;815us;819us;822us;824us;826us;828us;831us;833us;835us;837us;849us;860us;917us;920us;922us;924us;926us;931us;933us;936us;938us;940us;943us;946us;949us;951us;953us;955us;957us;965us;973us;975us;979us;981us;987us;989us;991us;993us;995us;997us;1000us;1002us;1004us;1006us;1009us;1011us;1013us;1018us;1022us;1024us;1027us;1032us;1034us;1038us;1040us;1044us;1050us;1053us;1055us;1057us;1060us;1062us;1064us;1066us;1068us;1072us;1076us;1079us;1081us;1083us;1085us;1087us;1089us;1091us;1093us;1096us;1098us;1103us;1107us;1110us;1112us;1114us;1117us;1119us;1121us;1123us;1125us;1127us;1130us;1132us;1136us;1138us;1140us;1143us;1147us;1149us;1151us;1153us;1157us;1159us;1161us;1163us;1165us;1167us;1169us;1171us;1174us;1176us;1178us;1180us;1188us;1190us;1192us;1194us;1196us;1198us;1200us;1202us;1204us;1206us;1208us;1213us;1215us;1218us;1221us;1224us;1227us;1230us;1232us;1234us;1236us;1242us;1245us;1248us;1251us;1254us;1256us;1258us;1260us;1262us;1264us;1266us;1268us;1270us;1272us;1274us;1276us;1278us;1282us;1285us;1287us;1289us;1292us;1294us;1297us;1300us;1302us;1304us;1307us;1310us;1312us;1314us;1316us;1318us;1320us;1322us;1324us;1326us;1328us;1330us;1332us;1335us;1338us;1340us;1342us;1345us;1347us;1349us;1351us;1353us;1355us;1357us;1359us;1361us;1366us;1371us;1376us;1378us;1380us;1382us;1384us;1386us;1389us;1391us;1394us;1396us;1413us;1435us;1452us;1474us;1476us;1478us;1482us;1484us;1486us;1488us;1491us;1496us;1498us;1500us;1502us;1504us;1506us;1508us;1510us;1512us;1514us;1516us;1518us;1520us;1522us;1524us;1526us;1528us;1530us;1535us;1539us;1543us;1545us;1547us;1549us;1551us;1553us;1555us;1557us;1559us;1561us;1566us;1571us;1576us;1580us;1583us;1585us;1587us;1589us;1591us;1596us;1601us;1606us;1610us;1614us;1616us;1618us;1620us;1622us;1624us;1626us;1629us;1631us;1633us;1636us;1638us;1640us;1642us;1644us;1646us;1648us;1651us;1653us;1655us;1657us;1659us;1661us;1663us;1665us;1667us;1670us;1672us;1674us;1676us;1678us;1680us;1684us;1687us;1689us;1691us;1693us;1695us;1697us;1699us;1702us;1704us;1706us;1708us;1711us;1713us;1715us;1718us;1721us;1723us;1725us;1727us;1730us;1733us;1735us;1740us;1746us;1750us;1752us;1754us;1756us;1758us;1760us;1762us;1764us;1766us;1768us;1770us;1772us;1774us;1780us;1786us;1791us;1793us;1795us;1797us;1799us;1801us;1803us;1809us;1812us;1815us;1817us;1819us;1824us;1827us;1829us;1831us;1833us;1835us;1837us;1844us;1846us;1848us;1852us;1855us;1857us;1859us;1861us;1863us;1865us;1867us;1869us;1871us;1873us;1878us;1883us;1885us;1889us;1891us;1893us;1895us;1897us;1900us;1902us;1905us;1909us;1911us;1914us;1916us;1918us;1921us;1924us;1926us;1929us;1931us;1933us;1935us;1937us;1939us;1941us;1943us;1945us;1947us;1949us;1951us;1953us;1956us;1959us;1962us;1964us;1966us;1968us;1971us;1974us;1976us;1980us;1984us;1986us;1988us;1990us;1992us;2004us;2007us;2010us;2018us;2020us;2024us;2026us;2028us;2030us;2032us;2034us;2040us;2043us;2045us;2047us;2049us;2051us;2053us;2055us;2057us;2059us;2064us;2066us;2071us;2081us;2083us;2085us;2087us;2089us;2091us;2094us;2096us;2099us;2101us;2103us;2113us;2123us;2130us;2132us;2135us;2137us;2139us;2142us;2144us;2146us;2148us;2150us;2152us;2154us;2161us;2163us;2170us;2172us;2174us;2176us;2178us;2180us;2187us;2189us;2192us;2200us;2203us;2205us;2208us;2210us;2212us;2214us;2216us;2219us;2221us;2223us;2227us;2230us;2239us;2248us;2250us;2252us;2254us;2256us;2259us;2262us;2264us;2266us;2268us;2270us;2275us;2280us;2284us;2287us;2289us;2291us;2293us;2295us;2297us;2299us;2302us;2305us;2308us;2310us;2312us;2314us;2318us;2321us;2323us;2325us;2327us;2331us;2333us;2335us;2337us;2339us;2341us;2343us;2345us;2347us;2349us;2351us;2354us;2356us;2358us;2360us;2362us;2364us;2366us;2368us;2370us;2372us;2374us;2376us;2378us;2380us;2382us;2384us;2386us;2388us;2391us;2394us;2396us;2398us;2400us;2402us;2405us;2411us;2413us;2417us;2422us;2424us;2426us;2428us;2430us;2432us;2434us;2437us;2439us;2442us;2444us;2446us;2448us;2450us;2452us;2454us;2456us;2458us;2462us;2466us;2470us;2474us;2477us;2479us;2481us;2483us;2486us;2489us;2491us;2493us;2495us;2497us;2500us;2502us;2504us;2507us;2509us;2511us;2513us;2515us;2517us;2520us;2522us;2524us;2526us;2528us;2530us;2532us;2534us;2536us;2538us;2540us;2542us;2544us;2546us;2548us;2550us;2552us;2554us;2556us;2558us;2560us;2562us;2565us;2567us;2569us;2572us;2575us;2577us;2579us;2581us;2583us;2585us;2587us;2589us;2591us;2593us;2596us;2598us;2600us;2608us;2610us;2612us;2614us;2618us;2623us;2626us;2628us;2630us;2632us;2634us;2636us;2638us;2644us;2647us;2649us;2651us;2653us;2656us;2658us;2660us;2668us;2676us;2684us;2692us;2700us;2708us;2716us;2724us;2732us;2740us;2749us;2751us;2753us;2755us;2757us;2761us;2764us;2766us;2769us;2772us;2774us;2776us;2779us;2781us;2783us;2785us;2789us;2791us;2795us;2797us;2799us;2801us;2805us;2812us;2815us;2825us;2827us;2829us;2838us;2843us;2845us;2847us;2849us;2851us;2853us;2855us;2857us;2859us;2861us;2863us;2865us;2867us;2869us;2879us;2881us;2883us;2885us;2890us;2892us;2894us;2896us;2898us;2900us;2902us;2905us;2907us;2909us;2911us;2913us;2915us;2917us;2919us;2921us;2923us;2925us;2927us;2930us;2932us;2934us;2936us;2938us;2940us;2942us;2951us;2954us;2956us;2958us;2962us;2965us;2967us;2972us;2977us;2983us;2985us;2987us;2990us;2992us;2994us;3004us;3014us;3024us;3034us;3044us;3054us;3064us;3074us;3083us;3093us;3103us;3114us;3129us;3139us;3141us;3143us;3145us;3149us;3152us;3155us;3157us;3159us;3161us;3163us;3165us;3168us;3171us;3173us;3175us;3178us;3180us;3182us;3184us;3187us;3189us;3192us;3194us;3200us;3203us;3205us;3207us;3209us;3212us;3214us;3218us;3221us;3223us;3225us;3227us;3229us;3232us;3234us;3236us;3238us;3293us;3296us;3298us;3300us;3303us;3307us;3310us;3312us;3314us;3316us;3318us;3377us;3380us;3382us;3384us;3386us;3388us;3390us;3392us;3394us;3400us;3402us;3405us;3408us;3411us;3414us;3417us;3420us;3423us;3426us;3429us;3432us;3435us;3438us;3442us;3445us;3448us;3450us;3452us;3454us;3456us;3458us;3460us;3462us;3464us;3466us;3468us;3470us;3472us;3475us;3478us;3480us;3482us;3487us;3489us;3491us;3494us;3496us;3498us;3500us;3502us;3504us;3507us;3510us;3512us;3514us;3517us;3520us;3522us;3524us;3530us;3534us;3536us;3538us;3541us;3543us;3545us;3547us;3551us;3607us;3609us;3611us;3613us;3615us;3670us;3673us;3728us;3730us;3732us;3735us;3737us;3739us;3741us;3743us;3745us;3761us;3768us;3773us;3776us;3778us;3780us;3782us;3784us;3786us;3788us;3790us;3796us;3801us;3804us;3806us;3808us;3810us;3812us;3814us;3816us;3818us;3820us;3822us;3824us;3827us;3830us;3885us;3888us;3943us;3945us;3947us;3949us;3951us;3953us;3955us;3957us;3959us;3961us;3964us;3967us;3970us;3973us;3976us;3978us;3980us;3982us;3984us;3986us;3988us;3990us;3992us;3994us;3996us;3998us;4000us;4055us;4057us;4059us;4114us;4169us;4224us;4279us;4334us;4389us;4444us;4499us;4554us;4609us;4664us;4719us;4774us;4829us;4884us;4939us;4994us;5049us;5104us;5159us;5214us;5269us;5324us;5382us;5437us;5492us;5547us;5603us;5658us;5713us;5768us;5822us;5877us;5932us;5987us;6042us;6097us;6153us;6156us;6158us;6160us;6163us;6165us;6167us;6170us;6172us;6174us;6176us;6179us;6181us;6183us;6189us;6197us;6200us;6202us;6205us;6207us;6210us;6212us;6215us;6217us;6220us;6222us;6225us;6227us;6230us;6232us;6235us;6237us;6240us;6242us;6245us;6247us;6250us;6252us;6255us;6257us;6260us;6262us;6265us;6267us;6270us;6272us;6275us;6277us;6280us;6282us;6285us;6287us;6290us;6292us;6295us;6297us;6300us;6302us;6306us;6309us;6311us;6314us;6318us;6321us;6323us;6325us;6327us;6329us;6331us;6333us;6335us;6337us;6339us;6341us;6343us;6345us;6347us;6351us;6354us;6356us;6358us;6360us;6362us;6365us;6367us;6369us;6371us;6373us;6380us;6385us;6388us;6390us;6392us;6394us;6396us;6398us;6400us;6402us;6404us;6406us;6408us;6410us;6413us;6415us;6418us;6420us;6422us;6424us;6426us;6428us;6431us;6433us;6435us;6440us;6442us;6445us;6447us;6452us;6454us;6457us;6459us;6461us;6464us;6468us;6471us;6473us;6475us;6478us;6480us;6482us;6485us;6487us;6489us;6492us;6494us;6496us;6499us;6501us;6503us;6506us;6508us;6510us;6513us;6515us;6520us;6529us;6533us;6541us;6545us;6551us;6554us;6559us;6561us;6563us;6565us;6567us;6569us;6571us;6573us;6575us;6578us;6587us;6595us;6597us;6604us;6606us;6613us;6620us;6624us;6631us;6634us;6641us;6643us;6645us;6652us;6659us;6666us;6673us;6675us;6677us;6679us;6681us;6683us;6686us;6688us;6691us;6693us;6696us;6698us;6700us;6702us;6704us;6706us;6708us;6710us;6713us;6715us;6717us;6719us;6721us;6723us;6728us;6731us;6733us;6735us;6737us;6739us;6743us;6746us;6748us;6750us;6752us;6754us;6756us;6758us;6765us;6767us;6769us;6771us;6773us;6775us;6777us;6782us;6785us;6787us;6789us;6791us;6793us;6795us;6797us;6799us;6801us;6803us;6805us;6807us;6809us;6811us;6813us;6815us;6820us;6823us;6825us;6827us;6829us;6831us;6833us;6838us;6844us;6847us;6849us;6851us;6853us;6855us;6860us;6863us;6865us;6867us;6869us;6871us;6882us;6898us;6913us;6915us;6918us;6920us;6922us;6924us;6927us;6929us;6931us;6933us;6935us;6937us;6939us;6941us;6943us;6945us;6947us;6949us;6951us;6953us;6955us;6957us;6959us;6962us;6965us;6967us;6969us;6974us;6980us;6983us;6985us;6987us;6989us;6991us;6993us;6995us;6997us;6999us;7001us;7003us;7005us;7007us;7009us;7012us;7014us;7016us;7018us;7020us;7022us;7024us;7026us;7028us;7030us;7033us;7035us;7037us;7039us;7041us;7043us;7045us;7047us;7049us;7052us;7054us;7060us;7062us;7064us;7066us;7068us;7070us;7073us;7075us;7077us;7080us;7082us;7085us;7087us;7089us;7092us;7094us;7097us;7099us;7101us;7103us;7106us;7108us;7111us;7113us;7115us;7117us;7120us;7122us;7124us;7126us;7129us;7132us;7135us;7137us;7139us;7143us;7145us;7147us;7153us;7157us;7159us;7161us;7163us;7166us;7168us;7170us;7172us;7174us;7176us;7178us;7180us;7183us;7185us;7187us;7189us;7191us;7193us;7195us;7197us;7199us;7201us;7203us;7205us;7207us;7209us;7214us;7216us;7218us;7220us;7222us;7224us;7226us;7232us;7235us;7237us;7239us;7241us;7243us;7245us;7248us;7251us;7254us;7256us;7258us;7265us;7271us;7276us;7279us;7281us;7283us;7285us;7287us;7289us;7291us;7293us;7295us;7297us;7299us;7301us;7303us;7305us;7308us;7310us;7313us;7315us;7318us;7320us;7322us;7326us;7329us;7331us;7333us;7337us;7340us;7342us;7344us;7346us;7348us;7352us;7355us;7357us;7359us;7361us;7363us;7369us;7376us;7379us;7384us;7386us;7389us;7392us;7395us;7400us;7402us;7409us;7412us;7417us;7419us;7422us;7425us;7428us;7433us;7435us;7444us;7452us;7457us;7459us;7461us;7463us;7465us;7470us;7474us;7476us;7478us;7480us;7482us;7484us;7486us;7495us;7498us;7500us;7502us;7504us;7506us;7509us;7511us;7513us;7516us;7518us;7520us;7529us;7532us;7534us;7536us;7538us;7540us;7543us;7545us;7547us;7549us;7551us;7555us;7557us;7562us;7564us;7568us;7570us;7573us;7578us;7580us;7582us;7590us;7592us;7594us;7596us;7598us;7603us;7605us;7607us;7609us;7611us;7613us;7615us;7617us;7620us;7622us;7624us;7657us;7659us;7691us;7693us;7724us;7726us;7756us;7758us;7787us;7789us;7817us;7819us;7846us;7848us;7874us;7876us;7901us;7903us;7927us;7929us;7952us;7954us;7976us;7978us;7999us;8001us;8021us;8023us;8042us;8044us;8062us;8064us;8081us;8083us;8099us;8101us;8116us;8118us;8132us;8134us;8147us;8149us;8161us;8163us;8174us;8176us;8186us;8188us;8197us;8199us;8207us;8209us;8216us;8218us;8224us;8226us;8231us;8233us;8237us;8239us;8242us;8244us;8246us;8248us;8250us;8252us;8254us;8258us;8263us;8266us;8268us;8270us;8273us;8275us;8277us;8282us;8284us;8286us;8288us;8292us;8296us;8298us;8300us;8304us;8306us;8308us;8312us;8315us;8321us;8323us;8325us;8331us;8337us;8341us;8344us;8346us;8348us;8350us;8352us;8354us;8356us;8358us;8360us;8362us;8364us;8366us;8368us;8370us;8373us;8378us;8380us;8382us;8384us;8386us;8388us;8390us;8398us;8402us;8406us;8409us;8411us;8413us;8415us;8419us;8421us;8423us;8425us;8427us;8431us;8434us;8436us;8438us;8440us;8443us;8447us;8449us;8451us;8453us;8457us;8459us;8461us;8465us;8467us;8470us;8472us;8474us;8476us;8479us;8481us;8483us;8487us;8491us;8495us;8497us;8499us;8501us;8503us;8505us;8507us;8509us;8512us;8514us;8516us;8518us;8521us;8523us;8525us;8530us;8532us;8534us;8536us;8538us;8540us;8544us;8548us;8550us;8552us;8554us;8556us;8558us;8560us;8562us;8564us;8566us;8568us;8570us;8572us;8574us;8576us;8578us;8580us;8582us;8584us;8586us;8588us;8590us;8592us;8594us;8596us;8598us;8600us;8602us;8605us;8607us;8609us;8611us;8613us;8615us;8617us;8619us;8621us;8623us;8627us;8629us;8632us;8634us;8636us;8638us;8640us;8642us;8644us;8646us;8648us;8651us;8653us;8655us;8657us;8660us;8663us;8665us;8667us;8669us;8671us;8673us;8675us;8677us;8679us;8681us;8683us;8685us;8687us;8689us;8691us;8693us;8695us;8697us;8699us;8701us;8703us;8705us;8707us;8709us;8711us;8713us;8715us;8717us;8719us;8721us;8723us;8726us;8728us;8730us;8732us;8735us;8737us;8739us;8741us;8743us;8745us;8747us;8749us;8751us;8754us;8756us;8758us;8760us;8762us;8765us;8767us;8769us;8771us;8773us;8775us;8777us;8779us;8781us;8783us;8785us;8787us;8789us;8791us;8793us;8795us;8797us;8799us;8801us;8803us;8805us;8807us;8809us;8811us;8813us;8815us;8817us;|]
let _fsyacc_action_rows = 2067
let _fsyacc_actionTableElements = [|16us;16435us;22us;74us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;48us;0us;49152us;95us;16513us;13us;16553us;22us;241us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;227us;0us;49152us;7us;16553us;10us;14us;21us;12us;67us;13us;73us;317us;83us;11us;88us;38us;101us;287us;0us;49152us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;49152us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;49152us;0us;16389us;0us;16390us;0us;16391us;0us;16392us;0us;16393us;0us;16394us;4us;32768us;10us;14us;21us;37us;67us;13us;83us;36us;0us;16395us;4us;32768us;10us;14us;21us;37us;67us;13us;83us;36us;0us;16396us;4us;32768us;10us;14us;21us;37us;67us;13us;83us;36us;0us;16397us;5us;16553us;10us;14us;67us;13us;73us;317us;88us;38us;101us;287us;0us;16398us;5us;16553us;10us;14us;67us;13us;73us;317us;88us;38us;101us;287us;0us;16399us;5us;16553us;10us;14us;67us;13us;73us;317us;88us;38us;101us;287us;0us;16400us;16us;16401us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;101us;287us;108us;16553us;121us;16553us;137us;16553us;150us;16553us;162us;16553us;0us;16402us;3us;16647us;43us;514us;44us;513us;45us;515us;87us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;108us;2037us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;121us;737us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;137us;753us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;150us;2042us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;26us;16403us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;0us;16404us;2us;16405us;21us;37us;83us;36us;0us;16406us;0us;16407us;0us;16408us;1us;32768us;193us;39us;0us;16410us;2us;16409us;194us;2017us;201us;2016us;0us;16411us;0us;16412us;0us;16413us;2us;32768us;10us;45us;203us;46us;0us;16414us;1us;32768us;10us;47us;0us;16415us;4us;16434us;10us;49us;21us;1984us;67us;1983us;83us;1982us;0us;16416us;1us;16553us;73us;317us;3us;16647us;43us;514us;44us;513us;45us;515us;1us;17547us;103us;2003us;5us;32768us;10us;1077us;21us;55us;46us;1924us;193us;1923us;203us;1061us;1us;16417us;76us;1926us;0us;16418us;0us;16419us;1us;17547us;103us;2003us;4us;32768us;10us;1077us;46us;1924us;193us;1923us;203us;1061us;1us;16420us;76us;1926us;0us;16421us;1us;16422us;151us;57us;0us;16423us;1us;16425us;151us;57us;0us;16424us;1us;17539us;69us;2000us;16us;16435us;22us;74us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;82us;0us;16426us;3us;16647us;43us;514us;44us;513us;45us;515us;8us;32768us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;108us;2037us;109us;104us;121us;737us;150us;2042us;18us;16435us;22us;74us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;69us;2015us;73us;317us;77us;2014us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;83us;0us;16427us;0us;16428us;0us;16429us;15us;16435us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;79us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;1us;17543us;21us;2001us;0us;16430us;0us;16431us;6us;16434us;15us;2052us;16us;2054us;17us;2055us;21us;1984us;67us;1983us;83us;1982us;0us;16432us;0us;16433us;3us;16434us;21us;1984us;67us;1983us;83us;1982us;17us;16434us;21us;1984us;37us;16443us;38us;16443us;39us;16443us;40us;16443us;43us;16443us;44us;16443us;45us;16443us;67us;1983us;73us;16443us;83us;1982us;88us;16443us;101us;16443us;108us;16443us;109us;16443us;121us;16443us;150us;16443us;3us;17524us;21us;1984us;67us;1983us;83us;1982us;15us;16438us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;87us;0us;16436us;3us;32768us;21us;1984us;67us;1983us;83us;1982us;4us;16553us;73us;317us;88us;38us;101us;287us;203us;87us;0us;16437us;0us;16439us;0us;16440us;3us;16647us;43us;514us;44us;513us;45us;515us;8us;32768us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;108us;2037us;109us;104us;121us;737us;150us;2042us;3us;32768us;69us;2015us;77us;2014us;203us;98us;5us;32768us;22us;120us;46us;1924us;57us;2012us;136us;2013us;193us;1923us;0us;16441us;0us;16442us;0us;16443us;1us;16553us;73us;317us;1us;16455us;131us;130us;0us;16444us;0us;16445us;0us;16446us;1us;16553us;73us;317us;1us;17551us;110us;2004us;1us;17553us;118us;2005us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;2us;16715us;34us;2032us;160us;17578us;1us;32768us;77us;111us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;16448us;69us;114us;0us;16447us;80us;32768us;13us;1189us;22us;116us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;26us;16449us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;29us;32768us;15us;2052us;16us;2054us;17us;2055us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;1us;17537us;19us;1999us;0us;16450us;8us;16553us;46us;1924us;57us;2012us;73us;317us;88us;38us;101us;287us;136us;2013us;193us;1923us;203us;87us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;0us;16451us;15us;16435us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;82us;1us;32768us;142us;125us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;0us;16452us;15us;16435us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;43us;16553us;44us;16553us;45us;16553us;73us;317us;88us;38us;101us;287us;108us;16553us;109us;16553us;121us;16553us;150us;16553us;203us;82us;1us;32768us;142us;129us;0us;16453us;1us;16553us;73us;317us;1us;16455us;131us;130us;0us;16454us;2us;16497us;69us;134us;87us;220us;7us;16553us;22us;137us;49us;590us;56us;592us;73us;317us;111us;591us;136us;162us;152us;148us;0us;16456us;0us;16457us;54us;16475us;14us;16553us;22us;158us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;47us;16553us;48us;16553us;49us;590us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;56us;592us;58us;16553us;66us;16553us;72us;16553us;73us;317us;88us;16553us;91us;16553us;92us;16553us;96us;16553us;106us;16553us;109us;16553us;111us;591us;113us;16553us;119us;16553us;120us;16553us;122us;16553us;136us;162us;148us;16553us;152us;148us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;186us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;201us;16553us;202us;16553us;1us;17543us;21us;2001us;14us;16475us;14us;16553us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;1us;16497us;87us;220us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;1us;16497us;87us;220us;0us;16458us;1us;16497us;87us;220us;0us;16459us;0us;16460us;0us;16461us;1us;32768us;120us;149us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16462us;0us;16463us;16us;16475us;14us;16553us;22us;166us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;203us;156us;3us;32768us;10us;1077us;142us;154us;203us;1061us;0us;16464us;0us;16465us;1us;32768us;142us;157us;0us;16466us;14us;16475us;14us;16553us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16467us;0us;16468us;15us;16475us;14us;16553us;22us;166us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;3us;32768us;10us;1077us;142us;164us;203us;1061us;0us;16469us;0us;16470us;14us;16475us;14us;16553us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16471us;0us;16472us;0us;16473us;0us;16474us;2us;17545us;21us;1989us;83us;1990us;14us;16475us;14us;16553us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;0us;16476us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;16647us;43us;514us;44us;513us;45us;515us;10us;32768us;14us;594us;47us;195us;48us;352us;50us;432us;51us;353us;52us;354us;54us;190us;109us;193us;111us;593us;119us;200us;46us;32768us;14us;594us;46us;1924us;47us;195us;48us;352us;50us;432us;51us;353us;52us;354us;54us;190us;56us;581us;58us;673us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;569us;96us;1717us;106us;1866us;109us;193us;111us;593us;113us;1864us;119us;200us;120us;708us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;1us;17551us;110us;2004us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;2us;16715us;34us;2032us;160us;17578us;1us;32768us;77us;184us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;2us;16485us;26us;205us;87us;203us;1us;16448us;69us;114us;0us;16477us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;6us;16478us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;6us;16479us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;0us;16480us;1us;17553us;118us;2005us;0us;16481us;6us;16570us;37us;2033us;38us;2036us;48us;351us;50us;434us;108us;2037us;109us;196us;1us;17553us;118us;2005us;0us;16482us;1us;16553us;73us;317us;0us;16483us;1us;32768us;77us;201us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16484us;4us;32768us;22us;213us;92us;1929us;100us;1934us;193us;1923us;0us;16486us;4us;32768us;22us;213us;92us;1929us;100us;1934us;193us;1923us;2us;32768us;20us;207us;203us;208us;0us;16487us;0us;16488us;1us;16489us;97us;210us;5us;32768us;10us;1077us;92us;1929us;100us;1934us;193us;1923us;203us;1061us;0us;16490us;0us;16491us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;1us;32768us;19us;215us;0us;16492us;0us;16493us;0us;16494us;1us;16497us;87us;220us;0us;16495us;15us;16475us;14us;16553us;22us;166us;43us;16553us;44us;16553us;45us;16553us;47us;16553us;48us;16553us;50us;16553us;51us;16553us;52us;16553us;54us;16553us;73us;317us;109us;16553us;111us;16553us;119us;16553us;3us;32768us;19us;1993us;20us;1994us;142us;1995us;0us;16496us;2us;32768us;10us;224us;203us;225us;0us;16498us;1us;32768us;10us;226us;0us;16499us;4us;32768us;10us;228us;21us;1984us;67us;1983us;83us;1982us;0us;16500us;1us;16501us;151us;57us;0us;16502us;1us;16504us;151us;57us;0us;16503us;1us;17539us;69us;2000us;95us;16513us;13us;16553us;22us;241us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;261us;0us;16505us;4us;16647us;43us;514us;44us;513us;45us;515us;203us;256us;87us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;108us;2037us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;121us;737us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;137us;753us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;150us;2042us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;96us;16513us;13us;16553us;22us;241us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;69us;281us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;262us;0us;16506us;0us;16507us;94us;16513us;13us;16553us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;246us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;1us;17543us;21us;2001us;0us;16508us;0us;16509us;6us;32768us;15us;2052us;16us;2054us;17us;2055us;21us;1984us;67us;1983us;83us;1982us;0us;16510us;0us;16511us;0us;16512us;4us;16647us;43us;514us;44us;513us;45us;515us;203us;256us;87us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;108us;2037us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;121us;737us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;137us;753us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;150us;2042us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;29us;16516us;21us;1984us;62us;1278us;63us;1264us;67us;1983us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;83us;1982us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;94us;16515us;13us;16553us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;261us;0us;16514us;0us;16517us;0us;16518us;21us;16521us;21us;1984us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;67us;1983us;73us;317us;83us;1982us;88us;38us;101us;287us;108us;16553us;121us;16553us;137us;16553us;150us;16553us;162us;16553us;203us;261us;0us;16519us;94us;16522us;13us;16553us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;261us;0us;16520us;3us;32768us;21us;1984us;67us;1983us;83us;1982us;3us;16532us;21us;1984us;67us;1983us;83us;1982us;6us;32768us;15us;2052us;16us;2054us;17us;2055us;21us;1984us;67us;1983us;83us;1982us;4us;32768us;21us;1984us;67us;1983us;83us;1982us;142us;310us;4us;16553us;73us;317us;88us;38us;101us;287us;203us;261us;0us;16523us;0us;16524us;0us;16525us;3us;16647us;43us;514us;44us;513us;45us;515us;11us;32768us;33us;755us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;41us;769us;108us;2037us;121us;737us;137us;753us;150us;2042us;162us;749us;0us;16526us;1us;16526us;127us;1090us;0us;16527us;80us;16527us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1095us;0us;16528us;1us;16553us;73us;317us;1us;16576us;131us;358us;0us;16529us;0us;16530us;2us;32768us;69us;281us;203us;283us;5us;32768us;22us;296us;46us;1924us;56us;2010us;136us;2011us;193us;1923us;0us;16531us;0us;16532us;2us;16552us;10us;1077us;203us;1061us;0us;16533us;0us;16534us;7us;32768us;10us;1077us;37us;2033us;38us;2036us;46us;1924us;108us;2037us;193us;1923us;203us;1061us;1us;16535us;76us;1926us;0us;16536us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;6us;16537us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;0us;16538us;4us;32768us;15us;2052us;16us;2054us;17us;2055us;76us;1926us;0us;16539us;1us;16540us;76us;1926us;6us;16553us;56us;2010us;73us;317us;88us;38us;101us;287us;136us;2011us;203us;263us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16541us;0us;16542us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16543us;0us;16544us;0us;16545us;0us;16546us;1us;16547us;76us;1926us;94us;16513us;13us;16553us;24us;16553us;25us;16553us;29us;16553us;30us;16553us;32us;16553us;33us;16553us;37us;16553us;38us;16553us;39us;16553us;40us;16553us;41us;16553us;43us;16553us;44us;16553us;45us;16553us;46us;16553us;56us;16553us;62us;16553us;66us;16553us;70us;16553us;71us;16553us;72us;16553us;73us;317us;74us;16553us;85us;16553us;86us;16553us;88us;38us;89us;16553us;90us;16553us;91us;16553us;92us;16553us;96us;16553us;98us;16553us;100us;16553us;101us;287us;106us;16553us;107us;16553us;108us;16553us;114us;16553us;115us;16553us;116us;16553us;117us;16553us;119us;16553us;121us;16553us;122us;16553us;123us;16553us;124us;16553us;125us;16553us;126us;16553us;130us;16553us;133us;16553us;134us;16553us;136us;16553us;137us;16553us;143us;16553us;146us;16553us;147us;16553us;148us;16553us;149us;16553us;150us;16553us;154us;16553us;155us;16553us;158us;16553us;159us;16553us;162us;16553us;163us;16553us;164us;16553us;166us;16553us;167us;16553us;168us;16553us;169us;16553us;170us;16553us;171us;16553us;172us;16553us;173us;16553us;174us;16553us;175us;16553us;176us;16553us;177us;16553us;178us;16553us;180us;16553us;181us;16553us;183us;16553us;184us;16553us;187us;16553us;189us;16553us;193us;16553us;194us;16553us;195us;16553us;199us;16553us;200us;16553us;201us;16553us;202us;16553us;203us;264us;3us;32768us;10us;1077us;142us;308us;203us;1061us;0us;16548us;0us;16549us;0us;16550us;6us;16553us;19us;16599us;20us;16599us;22us;398us;73us;317us;142us;16599us;203us;404us;3us;32768us;19us;1993us;20us;1994us;142us;1995us;0us;16551us;0us;16552us;1us;16554us;73us;317us;0us;16555us;14us;32768us;10us;1077us;15us;2065us;37us;2034us;38us;2036us;39us;2039us;40us;2041us;46us;1924us;60us;2063us;94us;2064us;108us;2037us;150us;2042us;163us;348us;193us;1923us;203us;322us;2us;17545us;21us;1989us;83us;1990us;8us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;55us;320us;60us;2063us;94us;2064us;203us;1061us;1us;17543us;21us;2001us;0us;16556us;1us;16974us;55us;323us;1us;17543us;21us;2001us;0us;16557us;0us;16558us;0us;16559us;0us;16560us;9us;17544us;37us;2033us;38us;2036us;39us;2038us;40us;2041us;46us;1924us;108us;2037us;150us;2042us;163us;348us;193us;1923us;0us;16561us;3us;17576us;35us;2031us;36us;2030us;76us;1926us;30us;17245us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16562us;3us;32768us;22us;337us;46us;1924us;193us;1923us;3us;17576us;35us;2031us;36us;2030us;76us;1926us;30us;17245us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16563us;2us;32768us;46us;1924us;193us;1923us;4us;32768us;15us;2052us;16us;2054us;17us;2055us;76us;1926us;2us;17576us;35us;2031us;36us;2030us;30us;17245us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16564us;1us;32768us;77us;343us;0us;16565us;1us;32768us;77us;345us;0us;16566us;1us;17472us;77us;347us;0us;16567us;1us;32768us;77us;349us;0us;16568us;11us;16570us;30us;759us;33us;755us;37us;2033us;38us;2036us;41us;769us;48us;351us;50us;434us;108us;2037us;109us;477us;137us;753us;162us;749us;0us;16569us;0us;16571us;0us;16572us;0us;16573us;3us;16647us;43us;514us;44us;513us;45us;515us;1us;16716us;84us;626us;0us;16574us;1us;16553us;73us;317us;1us;16576us;131us;358us;0us;16575us;39us;16553us;14us;16577us;15us;16577us;16us;16577us;17us;16577us;19us;16577us;20us;16577us;21us;16577us;30us;16577us;33us;16577us;37us;16577us;38us;16577us;39us;16577us;40us;16577us;41us;16577us;47us;16577us;48us;16577us;50us;16577us;51us;16577us;52us;16577us;54us;16577us;60us;16577us;67us;16577us;73us;317us;83us;16577us;87us;311us;88us;16577us;94us;16577us;101us;16577us;108us;16577us;109us;16577us;111us;16577us;119us;16577us;121us;16577us;131us;16577us;137us;16577us;142us;16577us;150us;16577us;151us;16577us;162us;16577us;0us;16578us;3us;16647us;43us;514us;44us;513us;45us;515us;2us;17576us;35us;2031us;36us;2030us;1us;16866us;92us;880us;1us;16661us;132us;530us;3us;32768us;10us;1077us;69us;368us;203us;1061us;6us;16553us;22us;371us;49us;590us;56us;592us;73us;317us;111us;591us;152us;384us;0us;16579us;0us;16580us;9us;16553us;15us;2052us;16us;2054us;17us;2055us;22us;394us;49us;590us;56us;592us;73us;317us;111us;591us;152us;384us;1us;17543us;21us;2001us;7us;16553us;10us;16599us;15us;16599us;16us;16599us;17us;16599us;73us;317us;87us;16599us;203us;404us;1us;16656us;87us;519us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;1us;16656us;87us;519us;0us;16581us;0us;16582us;0us;16583us;1us;16656us;87us;519us;0us;16584us;0us;16585us;0us;16586us;1us;32768us;120us;385us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16587us;0us;16588us;10us;16553us;10us;16599us;15us;16599us;22us;398us;37us;16599us;39us;16599us;60us;16599us;73us;317us;94us;16599us;142us;16599us;203us;392us;8us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;60us;2063us;94us;2064us;142us;390us;203us;1061us;0us;16589us;0us;16590us;9us;16553us;10us;16599us;15us;16599us;37us;16599us;39us;16599us;60us;16599us;73us;317us;94us;16599us;142us;393us;203us;404us;0us;16591us;1us;16553us;73us;317us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16592us;0us;16593us;6us;16553us;10us;16599us;15us;16599us;16us;16599us;17us;16599us;73us;317us;203us;404us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16594us;0us;16595us;0us;16596us;0us;16597us;14us;16553us;10us;16599us;15us;16599us;16us;16599us;17us;16599us;19us;16599us;20us;16599us;37us;16599us;39us;16599us;60us;16599us;73us;317us;87us;16599us;94us;16599us;142us;16599us;203us;404us;0us;16598us;2us;17545us;21us;1989us;83us;1990us;14us;16553us;10us;16599us;15us;16599us;16us;16599us;17us;16599us;19us;16599us;20us;16599us;37us;16599us;39us;16599us;60us;16599us;73us;317us;87us;16599us;94us;16599us;142us;16599us;203us;404us;0us;16600us;1us;17551us;110us;2004us;0us;16601us;1us;17551us;110us;2004us;2us;32768us;20us;413us;203us;414us;0us;16602us;0us;16603us;1us;16604us;131us;416us;1us;17551us;110us;2004us;0us;16605us;1us;16553us;73us;317us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;17315us;77us;1660us;1us;32768us;69us;422us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16606us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;17315us;77us;1660us;6us;32768us;10us;1077us;21us;429us;26us;411us;69us;427us;87us;409us;203us;1061us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16607us;0us;16608us;0us;16609us;0us;16610us;1us;16611us;48us;433us;0us;16612us;1us;16613us;48us;435us;0us;16614us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;16647us;43us;514us;44us;513us;45us;515us;15us;32768us;14us;594us;30us;759us;33us;755us;41us;769us;47us;350us;48us;352us;50us;432us;51us;353us;52us;354us;54us;522us;109us;477us;111us;593us;119us;465us;137us;753us;162us;749us;51us;32768us;14us;594us;30us;759us;33us;755us;41us;769us;46us;1924us;47us;350us;48us;352us;50us;432us;51us;353us;52us;354us;54us;522us;56us;581us;58us;673us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;569us;96us;1717us;106us;1866us;109us;477us;111us;593us;113us;1864us;119us;465us;120us;708us;122us;1865us;137us;753us;148us;1863us;162us;749us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;0us;16615us;0us;16616us;4us;17551us;10us;1077us;109us;486us;110us;2004us;203us;1061us;1us;17537us;19us;1999us;0us;16617us;0us;16618us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;7us;16654us;36us;1748us;46us;1924us;70us;1762us;87us;516us;91us;1918us;189us;1920us;193us;1923us;0us;16619us;0us;16620us;1us;17551us;110us;2004us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;2us;16715us;34us;2032us;160us;17578us;1us;32768us;77us;454us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;2us;16485us;26us;205us;87us;203us;1us;17537us;19us;1999us;0us;16621us;0us;16622us;1us;17537us;19us;1999us;0us;16623us;1us;17537us;19us;1999us;0us;16624us;1us;17537us;19us;1999us;0us;16625us;37us;32768us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;1us;16661us;132us;530us;9us;32768us;10us;1077us;15us;2065us;21us;472us;37us;2061us;39us;2062us;60us;2063us;69us;468us;94us;2064us;203us;1061us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;17537us;19us;1999us;0us;16626us;0us;16627us;0us;16628us;1us;17543us;21us;2001us;0us;16629us;1us;16553us;73us;317us;0us;16630us;1us;17553us;118us;2005us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;32768us;10us;1077us;193us;1923us;203us;1061us;3us;32768us;10us;1077us;77us;481us;203us;1061us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;16631us;0us;16632us;0us;16633us;0us;16634us;1us;17553us;118us;2005us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;32768us;10us;1077us;193us;1923us;203us;1061us;1us;16639us;77us;497us;9us;32768us;10us;1077us;15us;2065us;21us;495us;37us;2061us;39us;2062us;60us;2063us;69us;491us;94us;2064us;203us;1061us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;2us;16485us;26us;205us;87us;203us;0us;16635us;0us;16636us;0us;16637us;0us;16638us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;16640us;0us;16641us;1us;16912us;76us;501us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;0us;16642us;1us;32768us;76us;504us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;0us;16643us;0us;16644us;4us;32768us;66us;508us;92us;1929us;100us;1934us;193us;1923us;1us;32768us;76us;509us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;0us;16645us;0us;16646us;0us;16648us;0us;16649us;0us;16650us;0us;16651us;31us;16553us;10us;16653us;14us;16653us;15us;16653us;16us;16653us;17us;16653us;19us;16653us;20us;16653us;21us;16653us;22us;537us;30us;16653us;33us;16653us;37us;16653us;39us;16653us;41us;16653us;43us;16653us;44us;16653us;45us;16653us;50us;16653us;52us;16653us;54us;16653us;60us;16653us;73us;317us;83us;16653us;87us;16653us;94us;16653us;109us;16653us;111us;16653us;119us;16653us;137us;16653us;142us;16653us;162us;16653us;3us;32768us;19us;1993us;20us;1994us;142us;1995us;0us;16652us;6us;16553us;19us;16599us;20us;16599us;22us;398us;73us;317us;142us;16599us;203us;404us;3us;32768us;19us;1993us;20us;1994us;142us;1995us;0us;16655us;37us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;46us;1924us;56us;1853us;60us;2063us;66us;1847us;88us;1844us;91us;1918us;92us;1837us;94us;2064us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;33us;16665us;35us;2031us;36us;2030us;56us;17576us;71us;17576us;72us;17576us;92us;17576us;106us;17576us;122us;17576us;132us;534us;136us;17576us;148us;17576us;155us;17576us;166us;17576us;167us;17576us;168us;17576us;169us;17576us;170us;17576us;171us;17576us;172us;17576us;173us;17576us;174us;17576us;175us;17576us;176us;17576us;177us;17576us;178us;17576us;180us;17576us;181us;17576us;194us;17576us;195us;17576us;199us;17576us;200us;17576us;201us;17576us;202us;17576us;0us;16657us;30us;32768us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;16665us;132us;534us;0us;16658us;0us;16659us;0us;16660us;3us;32768us;10us;1077us;193us;1923us;203us;1061us;0us;16662us;0us;16663us;0us;16664us;2us;32768us;154us;536us;193us;1923us;0us;16666us;0us;16667us;1us;16553us;73us;317us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16668us;0us;16669us;0us;16670us;2us;17545us;21us;1989us;83us;1990us;14us;16553us;10us;16672us;14us;16672us;15us;16672us;16us;16672us;17us;16672us;19us;16672us;20us;16672us;21us;16672us;60us;16672us;61us;16672us;73us;317us;111us;16672us;142us;16672us;196us;16672us;0us;16671us;4us;32768us;47us;556us;48us;558us;51us;559us;203us;553us;5us;17551us;47us;556us;48us;558us;51us;559us;110us;2004us;203us;553us;3us;17551us;109us;486us;110us;2004us;203us;552us;1us;17537us;19us;1999us;0us;16673us;1us;17537us;19us;1999us;0us;16674us;0us;16675us;1us;17551us;110us;2004us;1us;17537us;19us;1999us;0us;16676us;1us;32768us;48us;557us;0us;16677us;0us;16678us;0us;16679us;3us;16647us;43us;514us;44us;513us;45us;515us;36us;32768us;46us;1924us;56us;581us;58us;673us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;569us;96us;1717us;106us;1866us;113us;1864us;120us;708us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;2us;17365us;76us;1926us;155us;563us;1us;32768us;201us;564us;2us;32768us;10us;1077us;203us;1061us;0us;16680us;0us;16681us;0us;16682us;0us;16683us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;570us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1867us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;16844us;88us;572us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16684us;5us;16553us;60us;2043us;61us;2045us;73us;317us;196us;2046us;203us;578us;5us;32768us;10us;1077us;60us;2043us;61us;2045us;196us;2046us;203us;1061us;0us;16685us;0us;16686us;3us;32768us;60us;2043us;61us;2045us;196us;2046us;0us;16687us;0us;16688us;2us;32768us;72us;584us;92us;1854us;0us;16689us;0us;16690us;2us;16553us;73us;317us;203us;588us;3us;32768us;10us;1077us;65us;2047us;203us;1061us;0us;16691us;0us;16692us;1us;32768us;65us;2047us;0us;16693us;0us;16694us;0us;16695us;0us;16696us;0us;16697us;0us;16698us;7us;32768us;10us;1077us;46us;1924us;91us;1918us;92us;602us;189us;1920us;193us;1923us;203us;1061us;3us;16699us;34us;2032us;76us;1926us;160us;17578us;2us;32768us;46us;1924us;193us;1923us;1us;16700us;76us;1926us;0us;16701us;0us;16702us;0us;16703us;1us;16553us;73us;317us;4us;32768us;93us;2051us;94us;2048us;95us;2050us;97us;607us;0us;16704us;2us;16716us;84us;626us;97us;607us;1us;16711us;97us;608us;1us;16553us;73us;317us;2us;16553us;73us;317us;143us;619us;0us;16705us;0us;16706us;2us;32768us;91us;1918us;189us;1920us;1us;16707us;89us;613us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;16708us;89us;635us;1us;32768us;160us;616us;1us;16553us;73us;317us;1us;32768us;161us;618us;0us;16709us;0us;16710us;1us;32768us;160us;621us;3us;16553us;73us;317us;84us;16712us;161us;16712us;1us;16716us;84us;626us;1us;32768us;161us;624us;0us;16713us;0us;16714us;32us;32768us;46us;1924us;52us;638us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;653us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;16717us;131us;630us;1us;17312us;131us;630us;1us;17314us;131us;630us;32us;32768us;46us;1924us;52us;638us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;653us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16718us;0us;16719us;1us;17363us;89us;635us;1us;17364us;89us;635us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;16720us;76us;1870us;1us;16721us;76us;1870us;2us;32768us;91us;1918us;189us;1920us;1us;32768us;77us;640us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16722us;3us;17366us;77us;645us;79us;643us;89us;1737us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;4us;16723us;46us;17375us;70us;17375us;91us;17375us;193us;17375us;5us;32768us;56us;646us;92us;650us;148us;649us;152us;660us;193us;647us;0us;16724us;3us;16731us;34us;1876us;56us;648us;160us;1878us;0us;16725us;0us;16726us;1us;16553us;73us;317us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16727us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1867us;4us;32768us;93us;2051us;94us;2048us;95us;2050us;102us;664us;1us;32768us;77us;656us;1us;32768us;92us;657us;1us;16553us;73us;317us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16728us;2us;32768us;34us;1876us;160us;1878us;0us;16729us;0us;16730us;6us;16732us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;6us;16733us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;13us;16734us;10us;17355us;36us;1748us;46us;1924us;69us;17355us;70us;1762us;91us;1918us;96us;1714us;97us;17355us;98us;17355us;186us;1722us;189us;1920us;193us;1923us;203us;17355us;1us;16553us;73us;317us;0us;16735us;1us;32768us;58us;673us;1us;16553us;73us;317us;0us;16736us;2us;16737us;21us;2001us;58us;17543us;0us;16738us;1us;16740us;58us;673us;1us;16553us;73us;317us;0us;16739us;3us;16647us;43us;514us;44us;513us;45us;515us;6us;32768us;10us;1077us;92us;693us;100us;1934us;120us;684us;193us;1923us;203us;1061us;35us;16741us;46us;1924us;56us;581us;66us;1759us;69us;690us;72us;584us;77us;688us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;120us;681us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;0us;16742us;34us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;203us;1061us;0us;16743us;0us;16744us;34us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;203us;1061us;0us;16745us;0us;16746us;0us;16747us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16748us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;5us;16749us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;0us;16750us;29us;32768us;58us;1969us;62us;1951us;63us;1949us;69us;1953us;70us;696us;74us;1957us;78us;694us;82us;1961us;89us;1958us;90us;1959us;96us;1952us;102us;1954us;143us;1964us;145us;1960us;155us;1966us;158us;1963us;160us;1955us;161us;1956us;182us;1962us;183us;1950us;184us;1947us;185us;1946us;186us;1948us;187us;1941us;188us;1945us;189us;1944us;190us;1943us;191us;1942us;203us;1932us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16751us;1us;32768us;59us;697us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16752us;4us;17472us;21us;2001us;58us;17543us;69us;701us;120us;705us;0us;16753us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;6us;17543us;21us;2001us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;46us;16754us;10us;16759us;14us;16759us;15us;16759us;16us;16759us;17us;16759us;19us;16759us;20us;16759us;21us;16759us;30us;16759us;33us;16759us;37us;16759us;38us;16759us;39us;16759us;40us;16759us;41us;16759us;43us;16759us;44us;16759us;45us;16759us;47us;16759us;48us;16759us;50us;16759us;51us;16759us;52us;16759us;54us;16759us;60us;16759us;67us;16759us;73us;16759us;83us;16759us;87us;16759us;88us;16759us;93us;16759us;94us;16759us;95us;16759us;101us;16759us;108us;16759us;109us;16759us;111us;16759us;119us;16759us;121us;16759us;131us;16759us;137us;16759us;142us;16759us;150us;16759us;151us;16759us;162us;16759us;203us;16759us;0us;16755us;34us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;203us;1061us;0us;16756us;0us;16757us;32us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;0us;16758us;1us;16761us;96us;711us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16760us;1us;17472us;77us;714us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;7us;16762us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;98us;1700us;189us;1920us;193us;1923us;7us;16763us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;98us;1700us;189us;1920us;193us;1923us;0us;16764us;0us;16765us;0us;16766us;0us;16767us;2us;17545us;21us;1989us;83us;1990us;5us;16553us;60us;17544us;61us;17544us;65us;17544us;73us;317us;196us;17544us;0us;16768us;0us;16769us;1us;17553us;118us;2005us;0us;16770us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;32768us;10us;1077us;193us;1923us;203us;1061us;3us;32768us;10us;1077us;77us;730us;203us;1061us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;16771us;0us;16772us;0us;16773us;0us;16774us;1us;16656us;87us;519us;0us;16775us;1us;16553us;73us;317us;3us;16647us;43us;514us;44us;513us;45us;515us;3us;32768us;10us;1077us;193us;1923us;203us;1061us;1us;16781us;69us;747us;0us;16776us;0us;16777us;1us;16778us;120us;744us;34us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;195us;574us;201us;2016us;202us;849us;203us;1061us;0us;16779us;0us;16780us;2us;32768us;46us;1924us;193us;1923us;1us;16782us;76us;1926us;1us;17547us;103us;2003us;2us;16553us;73us;317us;203us;804us;0us;16783us;0us;16784us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16785us;1us;17547us;103us;2003us;2us;16553us;73us;317us;203us;804us;3us;32768us;10us;1077us;19us;767us;203us;1061us;0us;16786us;81us;32768us;13us;1189us;19us;762us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;10us;1077us;19us;767us;203us;1061us;0us;16787us;0us;16788us;0us;16789us;0us;16790us;0us;16791us;0us;16792us;0us;16793us;0us;16794us;1us;16553us;73us;317us;3us;16647us;43us;514us;44us;513us;45us;515us;1us;32768us;193us;1923us;2us;17576us;35us;2031us;36us;2030us;1us;32768us;92us;774us;4us;16553us;73us;317us;93us;16798us;94us;16798us;95us;16798us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16795us;1us;16796us;97us;779us;1us;16797us;97us;781us;1us;16553us;73us;317us;0us;16799us;1us;16553us;73us;317us;0us;16800us;3us;32768us;42us;793us;46us;1924us;193us;1923us;6us;16801us;35us;2031us;36us;2030us;70us;17576us;89us;792us;96us;791us;193us;1923us;0us;16802us;1us;16803us;76us;1926us;5us;16808us;35us;2031us;36us;2030us;70us;17576us;89us;792us;96us;791us;1us;32768us;70us;789us;1us;32768us;59us;790us;0us;16804us;0us;16805us;0us;16806us;1us;32768us;96us;795us;1us;16809us;96us;795us;0us;16807us;3us;32768us;42us;794us;46us;1924us;193us;1923us;1us;16812us;131us;799us;0us;16810us;2us;16553us;73us;317us;203us;804us;1us;16812us;131us;799us;0us;16811us;1us;17551us;110us;2004us;0us;16813us;0us;16814us;1us;17553us;118us;2005us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;17315us;77us;1660us;3us;32768us;10us;1077us;69us;809us;203us;1061us;81us;32768us;13us;1189us;22us;813us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;811us;0us;16815us;0us;16816us;0us;16817us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16818us;0us;16819us;0us;16820us;0us;16823us;1us;16821us;84us;821us;0us;16822us;2us;32768us;91us;1918us;189us;1920us;2us;32768us;69us;823us;131us;825us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16824us;2us;32768us;91us;1918us;189us;1920us;0us;16825us;0us;16826us;2us;32768us;56us;831us;77us;829us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16827us;0us;16828us;0us;16829us;0us;16830us;0us;16831us;0us;16832us;0us;16833us;0us;16834us;0us;16835us;0us;16836us;0us;16837us;0us;16838us;0us;16839us;0us;16840us;0us;16841us;0us;16842us;0us;16843us;0us;16844us;0us;16845us;0us;16846us;1us;16849us;186us;851us;1us;32768us;178us;852us;0us;16847us;1us;32768us;178us;854us;1us;16850us;186us;855us;1us;32768us;178us;856us;0us;16848us;0us;16851us;2us;32768us;62us;853us;178us;850us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16852us;0us;16853us;2us;32768us;92us;858us;178us;857us;0us;16854us;1us;16855us;34us;865us;1us;32768us;160us;1895us;0us;16856us;5us;16857us;58us;901us;78us;902us;89us;913us;97us;907us;132us;899us;0us;16858us;1us;32768us;193us;1923us;0us;16859us;1us;16862us;77us;873us;2us;16863us;77us;873us;97us;877us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;16860us;0us;16861us;3us;32768us;73us;317us;74us;869us;193us;1923us;3us;32768us;73us;317us;74us;869us;193us;1923us;0us;16864us;0us;16865us;8us;32768us;10us;1077us;73us;317us;74us;869us;93us;2051us;94us;2048us;95us;2050us;193us;1923us;203us;885us;5us;32768us;10us;1077us;93us;2051us;94us;2048us;95us;2050us;203us;1061us;0us;16867us;0us;16868us;0us;16869us;3us;16974us;93us;2051us;94us;2048us;95us;2050us;0us;16870us;0us;16871us;3us;16873us;78us;902us;89us;913us;97us;907us;1us;16874us;78us;902us;2us;16878us;78us;902us;89us;913us;2us;16879us;78us;902us;89us;913us;2us;16882us;78us;902us;89us;913us;1us;16884us;78us;902us;1us;16885us;78us;902us;6us;32768us;58us;901us;69us;1079us;78us;902us;89us;913us;97us;907us;132us;899us;6us;32768us;58us;901us;69us;1084us;78us;902us;89us;913us;97us;907us;132us;899us;6us;32768us;58us;901us;69us;1167us;78us;902us;89us;913us;97us;907us;132us;899us;6us;32768us;58us;901us;69us;1174us;78us;902us;89us;913us;97us;907us;132us;899us;36us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16872us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;16875us;97us;906us;0us;16876us;0us;16877us;44us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;44us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;0us;16880us;0us;16881us;44us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;0us;16883us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;2us;17545us;21us;1989us;83us;1990us;0us;16886us;3us;17544us;21us;1989us;83us;1990us;193us;1923us;0us;16887us;1us;32768us;193us;1923us;0us;16888us;3us;32768us;10us;1077us;69us;922us;203us;1061us;4us;17511us;10us;1077us;69us;922us;76us;1976us;203us;1061us;40us;32768us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;6us;16889us;58us;1002us;77us;1005us;78us;1009us;89us;1018us;97us;1012us;132us;1000us;0us;16890us;0us;16891us;39us;16914us;34us;2032us;35us;934us;36us;936us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;941us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;160us;17578us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;37us;16892us;35us;929us;36us;931us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;941us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16893us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;941us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16894us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;941us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16895us;0us;16896us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;941us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16897us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;941us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16898us;31us;32768us;46us;1924us;56us;581us;66us;1847us;72us;584us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;16899us;0us;16900us;64us;16928us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;58us;1969us;62us;1951us;63us;1949us;66us;500us;69us;1953us;70us;957us;71us;960us;73us;317us;74us;964us;81us;938us;82us;1961us;89us;1958us;90us;1959us;92us;971us;96us;1952us;97us;1015us;100us;1934us;102us;1954us;106us;969us;122us;968us;143us;1964us;145us;1960us;148us;970us;155us;1477us;158us;1963us;160us;1955us;161us;1956us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;182us;1962us;183us;1950us;184us;1947us;185us;1946us;186us;1948us;187us;1941us;188us;1945us;189us;1944us;190us;1943us;191us;1942us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;975us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;16901us;0us;16902us;37us;16906us;35us;949us;36us;947us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16903us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16904us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16905us;0us;16907us;3us;32768us;46us;1924us;193us;1923us;203us;955us;3us;32768us;60us;2043us;61us;2045us;196us;2046us;0us;16908us;3us;32768us;60us;2043us;61us;2045us;196us;2046us;0us;16909us;38us;16951us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;32768us;59us;959us;0us;16910us;38us;16951us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;32768us;64us;962us;0us;16911us;1us;32768us;193us;1923us;1us;17496us;193us;1923us;0us;16913us;0us;16914us;0us;16915us;0us;16916us;0us;16917us;0us;16918us;64us;16928us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;58us;1969us;62us;1951us;63us;1949us;66us;500us;69us;1953us;70us;957us;71us;960us;73us;317us;74us;964us;81us;938us;82us;1961us;89us;1958us;90us;1959us;92us;971us;96us;1952us;97us;1015us;100us;1934us;102us;1954us;106us;969us;122us;968us;143us;1964us;145us;1960us;148us;970us;155us;1477us;158us;1963us;160us;1955us;161us;1956us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;182us;1962us;183us;1950us;184us;1947us;185us;1946us;186us;1948us;187us;1941us;188us;1945us;189us;1944us;190us;1943us;191us;1942us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;975us;5us;32768us;10us;1077us;93us;2051us;94us;2048us;95us;2050us;203us;1061us;0us;16919us;0us;16920us;3us;16974us;93us;2051us;94us;2048us;95us;2050us;2us;16921us;34us;17476us;160us;17476us;0us;16922us;1us;32768us;92us;979us;40us;32768us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;983us;6us;16931us;10us;1077us;93us;2051us;94us;2048us;95us;2050us;97us;1011us;203us;1061us;0us;16923us;0us;16924us;3us;16974us;93us;2051us;94us;2048us;95us;2050us;0us;16925us;0us;16926us;6us;16927us;58us;1002us;77us;1005us;78us;1009us;89us;1018us;97us;1012us;132us;1000us;4us;16930us;77us;1005us;78us;1009us;89us;1018us;97us;1012us;3us;16935us;77us;1005us;78us;1009us;89us;1018us;2us;16936us;77us;1005us;78us;1009us;3us;16938us;77us;1005us;78us;1009us;89us;1018us;3us;16939us;77us;1005us;78us;1009us;89us;1018us;3us;16942us;77us;1005us;78us;1009us;89us;1018us;2us;16944us;77us;1005us;78us;1009us;6us;32768us;58us;1002us;77us;1005us;78us;1009us;89us;1018us;97us;1012us;132us;1000us;2us;16945us;77us;1005us;78us;1009us;6us;16948us;58us;1002us;77us;1005us;78us;1009us;89us;1018us;97us;1012us;132us;1000us;8us;17545us;21us;1989us;58us;1002us;77us;1005us;78us;1009us;83us;1990us;89us;1018us;97us;1012us;132us;1000us;15us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;58us;1002us;60us;2063us;69us;1537us;77us;1005us;78us;1009us;89us;1018us;94us;2064us;97us;1012us;127us;1534us;132us;1000us;203us;1065us;7us;17112us;58us;1002us;77us;1005us;78us;1009us;84us;1327us;89us;1018us;97us;1012us;132us;1000us;36us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16929us;38us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;16931us;97us;1011us;1us;16932us;89us;1017us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;16933us;0us;16934us;38us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;38us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16937us;45us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;45us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;0us;16940us;0us;16941us;45us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;0us;16943us;38us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;38us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;2us;17545us;21us;1989us;83us;1990us;0us;16946us;2us;17544us;46us;1924us;193us;1923us;0us;16947us;4us;32768us;10us;1077us;69us;1024us;76us;1926us;203us;1061us;40us;32768us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;0us;16949us;0us;16950us;0us;16952us;38us;16951us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;16953us;82us;32768us;13us;1189us;15us;2052us;16us;2054us;17us;2055us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;5us;32768us;10us;1077us;15us;2052us;16us;2054us;17us;2055us;203us;1061us;0us;16954us;0us;16955us;0us;16956us;0us;16957us;82us;32768us;13us;1189us;15us;2052us;16us;2054us;17us;2055us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;0us;16958us;0us;16959us;26us;16960us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;1us;16962us;18us;1042us;0us;16961us;0us;16963us;93us;16963us;14us;17306us;15us;17306us;16us;17306us;17us;17306us;18us;17306us;19us;17306us;21us;17306us;26us;17306us;27us;17306us;28us;17306us;30us;17306us;33us;17306us;37us;17306us;38us;17306us;39us;17306us;40us;17306us;41us;17306us;43us;17306us;44us;17306us;45us;17306us;47us;17306us;48us;17306us;50us;17306us;51us;17306us;52us;17306us;54us;17306us;58us;17306us;59us;17306us;60us;17306us;61us;17306us;62us;17306us;63us;17306us;64us;17306us;65us;17306us;67us;17306us;69us;17306us;73us;17306us;77us;17306us;78us;17306us;79us;17306us;80us;17306us;81us;17306us;82us;17306us;83us;17306us;84us;17306us;87us;17306us;88us;17306us;89us;17306us;90us;17306us;93us;17306us;94us;17306us;95us;17306us;96us;17306us;97us;17306us;98us;17306us;101us;17306us;102us;17306us;104us;17306us;105us;17306us;108us;17306us;109us;17306us;111us;17306us;119us;17306us;121us;17306us;127us;17306us;128us;17306us;129us;17306us;131us;17306us;137us;17306us;138us;17306us;139us;17306us;140us;17306us;141us;17306us;142us;17306us;143us;17306us;145us;17306us;150us;17306us;151us;17306us;156us;17306us;158us;17306us;160us;17306us;161us;17306us;162us;17306us;184us;17306us;185us;17306us;186us;17306us;188us;17306us;189us;17306us;190us;17306us;191us;17306us;196us;17306us;197us;17306us;198us;17306us;1us;16966us;77us;1046us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;16964us;0us;16965us;1us;32768us;10us;1050us;0us;16967us;30us;16970us;21us;1989us;28us;1056us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;83us;1990us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;104us;1054us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;79us;16969us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16968us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16971us;1us;32768us;22us;1057us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;0us;16972us;82us;16973us;13us;1189us;21us;1096us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1095us;0us;16974us;2us;16974us;19us;2009us;138us;2008us;2us;16974us;19us;2009us;138us;2008us;2us;16974us;30us;2007us;137us;2006us;2us;16974us;19us;2009us;138us;2008us;2us;16974us;19us;2009us;138us;2008us;0us;16974us;1us;16974us;58us;1322us;1us;16974us;59us;1435us;1us;16974us;59us;1456us;1us;16974us;156us;1481us;1us;16974us;64us;1487us;3us;16974us;93us;2051us;94us;2048us;95us;2050us;3us;16974us;93us;2051us;94us;2048us;95us;2050us;3us;16974us;60us;2043us;61us;2045us;196us;2046us;1us;16974us;65us;2047us;0us;16975us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;32768us;127us;1081us;2us;16978us;31us;1083us;165us;1078us;0us;16976us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;10us;1077us;19us;767us;203us;1061us;1us;17543us;21us;2001us;2us;16978us;31us;1083us;165us;1078us;0us;16977us;1us;32768us;127us;1090us;80us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1092us;0us;16979us;0us;16980us;82us;32768us;13us;1189us;21us;1096us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1095us;0us;16981us;0us;16982us;81us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1098us;0us;16983us;0us;16984us;0us;16985us;0us;16986us;0us;16987us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;4us;32768us;10us;1077us;26us;1307us;87us;1305us;203us;1061us;0us;16988us;0us;16989us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;4us;32768us;10us;1077us;26us;1307us;87us;1305us;203us;1061us;0us;16990us;0us;16991us;82us;32768us;10us;1077us;13us;1189us;18us;1114us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;5us;32768us;10us;1077us;26us;1307us;87us;1305us;129us;1116us;203us;1061us;0us;16992us;0us;16993us;2us;16994us;26us;1307us;87us;1305us;0us;16995us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;16996us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;30us;32768us;10us;1077us;28us;1334us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;104us;1332us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;203us;1061us;0us;16997us;0us;16998us;0us;16999us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17000us;68us;17002us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;159us;1166us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17001us;80us;32768us;13us;1189us;22us;1036us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17003us;69us;17005us;13us;1189us;22us;1036us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;159us;1166us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17004us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1066us;0us;17006us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1066us;0us;17007us;45us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;60us;2063us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;94us;2064us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1064us;10us;17543us;10us;1077us;15us;2065us;21us;2001us;30us;2007us;37us;2061us;39us;2062us;60us;2063us;94us;2064us;137us;2006us;203us;1061us;87us;32768us;10us;1077us;13us;1189us;15us;2065us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1062us;9us;32768us;10us;1077us;15us;2065us;19us;2009us;37us;2061us;39us;2062us;60us;2063us;94us;2064us;138us;2008us;203us;1061us;0us;17008us;0us;17009us;0us;17010us;0us;17011us;0us;17012us;1us;32768us;98us;1532us;0us;17013us;4us;32768us;10us;1077us;30us;2007us;137us;2006us;203us;1061us;82us;32768us;10us;1077us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1063us;4us;32768us;10us;1077us;19us;2009us;138us;2008us;203us;1061us;0us;17014us;0us;17015us;0us;17016us;0us;17017us;0us;17018us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;2us;32768us;19us;2009us;138us;2008us;0us;17019us;0us;17020us;0us;17021us;0us;17022us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;26us;17023us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;26us;17024us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;0us;17025us;0us;17026us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;32768us;127us;1169us;1us;17543us;21us;2001us;2us;16978us;31us;1083us;165us;1078us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17027us;37us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;81us;938us;92us;971us;97us;910us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;10us;1077us;19us;767us;203us;1061us;1us;17543us;21us;2001us;3us;16978us;31us;1083us;165us;1078us;203us;1180us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17028us;0us;17029us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;32768us;127us;1183us;1us;17543us;21us;2001us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17030us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;10us;1077us;19us;767us;203us;1061us;0us;17031us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;26us;17032us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17033us;26us;17040us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;20us;17043us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;20us;17045us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;9us;17047us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;20us;17049us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;18us;17051us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;96us;1280us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;18us;17053us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;96us;1280us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;9us;17055us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;9us;17057us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;9us;17059us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;9us;17061us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;9us;17063us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;9us;17065us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;9us;17067us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;189us;1270us;191us;1284us;1us;17069us;191us;1284us;8us;17071us;62us;1278us;78us;1274us;81us;1231us;96us;1280us;158us;1272us;184us;1276us;186us;1282us;191us;1284us;4us;17073us;96us;1280us;158us;1272us;186us;1282us;191us;1284us;4us;17075us;96us;1280us;158us;1272us;186us;1282us;191us;1284us;1us;17077us;191us;1284us;1us;17079us;191us;1284us;1us;17081us;191us;1284us;23us;17083us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;102us;1252us;128us;1246us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;24us;17085us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;30us;32768us;10us;1077us;30us;2007us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;137us;2006us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;203us;1061us;26us;17111us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;26us;17115us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;26us;17120us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;30us;32768us;10us;1077us;28us;1334us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;104us;1332us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;203us;1061us;24us;17124us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;24us;17126us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;24us;17129us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;26us;32768us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;24us;17131us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;89us;1254us;90us;1256us;96us;1280us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;29us;32768us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;93us;2051us;94us;2048us;95us;2050us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;26us;17236us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;28us;32768us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;105us;1539us;128us;1246us;139us;1540us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;26us;17239us;62us;1278us;63us;1264us;69us;1260us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;27us;17566us;62us;1278us;63us;1264us;69us;1260us;77us;2018us;78us;1274us;79us;1234us;80us;1237us;81us;1231us;82us;1240us;89us;1254us;90us;1256us;96us;1280us;97us;1347us;102us;1252us;128us;1246us;143us;1286us;145us;1248us;158us;1272us;160us;1266us;161us;1268us;184us;1276us;185us;1258us;186us;1282us;188us;1250us;189us;1270us;190us;1262us;191us;1284us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17034us;0us;17035us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17036us;0us;17037us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17038us;0us;17039us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;17087us;68us;1242us;80us;32768us;13us;1189us;22us;1036us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17041us;1us;17042us;97us;1343us;6us;17042us;10us;1077us;93us;2051us;94us;2048us;95us;2050us;97us;1343us;203us;1061us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17044us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17046us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17048us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17050us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17052us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17054us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17056us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17058us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17060us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17062us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17064us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17066us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17068us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17070us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17072us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17074us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17076us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17078us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17080us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17082us;76us;17084us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;79us;17503us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1289us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;79us;17504us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17086us;0us;17086us;81us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1296us;4us;32768us;10us;1077us;19us;2009us;138us;2008us;203us;1061us;0us;17088us;0us;17089us;2us;32768us;19us;2009us;138us;2008us;0us;17090us;0us;17091us;0us;17092us;0us;17093us;0us;17094us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17095us;40us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;58us;1313us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1316us;0us;17096us;41us;32768us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;58us;1313us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1067us;3us;32768us;10us;1077us;20us;1309us;203us;1061us;0us;17097us;0us;17098us;0us;17099us;0us;17100us;39us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1315us;0us;17101us;0us;17102us;0us;17103us;0us;17104us;3us;32768us;10us;1077us;98us;1328us;203us;1068us;3us;17105us;10us;1077us;58us;1320us;203us;1061us;40us;32768us;10us;1077us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1061us;0us;17106us;38us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;0us;17107us;0us;17108us;0us;17109us;0us;17110us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17113us;3us;17119us;27us;1338us;140us;1337us;141us;1340us;0us;17114us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17116us;82us;32768us;10us;1077us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17117us;0us;17118us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;80us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17121us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17122us;0us;17123us;87us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;97us;1345us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17125us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17127us;87us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;97us;1349us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17128us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17130us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17483us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17483us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17132us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17490us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17133us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17486us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17134us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17489us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17135us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17502us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17136us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17497us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17137us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;50us;17498us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17138us;31us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1837us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1385us;31us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1837us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1385us;2us;17576us;35us;2031us;36us;2030us;37us;17280us;14us;17283us;21us;17283us;26us;17283us;35us;2031us;36us;2030us;56us;17576us;71us;17576us;72us;17576us;87us;17283us;92us;17576us;106us;17576us;111us;17283us;122us;17576us;136us;17576us;148us;17576us;155us;17576us;166us;17576us;167us;17576us;168us;17576us;169us;17576us;170us;17576us;171us;17576us;172us;17576us;173us;17576us;174us;17576us;175us;17576us;176us;17576us;177us;17576us;178us;17576us;180us;17576us;181us;17576us;194us;17576us;195us;17576us;199us;17576us;200us;17576us;201us;17576us;202us;17576us;31us;32768us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1384us;31us;32768us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1384us;1us;17140us;76us;1382us;6us;17140us;14us;17282us;26us;17282us;76us;1382us;87us;17282us;111us;17282us;132us;534us;7us;17174us;10us;1077us;46us;1443us;70us;1452us;92us;1445us;100us;1934us;193us;1923us;203us;1061us;0us;17139us;0us;17141us;0us;17142us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17143us;50us;32768us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;119us;1374us;122us;1464us;136us;1469us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17144us;41us;17145us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1395us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;44us;17145us;26us;1577us;46us;1429us;56us;1437us;66us;1398us;69us;1564us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;87us;1573us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1395us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;44us;17256us;26us;1577us;46us;1429us;56us;1437us;66us;1398us;69us;1564us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;87us;1573us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1395us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17146us;5us;17147us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;5us;17148us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;5us;17149us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;3us;32768us;10us;1077us;76us;1400us;203us;1061us;4us;17257us;10us;1077us;69us;1569us;76us;1400us;203us;1061us;42us;32768us;10us;1077us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;5us;17150us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;0us;17151us;0us;17152us;2us;17153us;34us;1410us;35us;1409us;1us;17154us;34us;1410us;5us;17156us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;5us;17431us;34us;1410us;35us;1409us;36us;1408us;74us;1427us;76us;1419us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;32768us;160us;1878us;0us;17155us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;40us;17480us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;32768us;193us;1923us;1us;32768us;193us;1923us;0us;17157us;0us;17157us;0us;17158us;7us;17174us;10us;1077us;46us;1443us;70us;1452us;92us;1445us;100us;1934us;193us;1923us;203us;1061us;0us;17159us;1us;32768us;76us;1422us;7us;17174us;10us;1077us;46us;1443us;70us;1452us;92us;1445us;100us;1934us;193us;1923us;203us;1061us;0us;17160us;3us;32768us;92us;1929us;100us;1934us;193us;1923us;3us;17496us;92us;1929us;100us;1934us;193us;1923us;0us;17161us;2us;32768us;92us;1302us;193us;1301us;0us;17162us;0us;17163us;0us;17164us;81us;17231us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1069us;3us;32768us;10us;1077us;59us;1433us;203us;1061us;0us;17165us;0us;17166us;0us;17167us;0us;17168us;2us;32768us;72us;1627us;92us;1438us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17169us;0us;17170us;0us;17171us;0us;17172us;0us;17173us;0us;17175us;95us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;58us;1969us;62us;1357us;63us;1949us;66us;1398us;69us;1953us;70us;1431us;71us;1483us;72us;1627us;74us;1425us;78us;1446us;82us;1961us;85us;1131us;86us;1133us;89us;1369us;90us;1372us;91us;1414us;92us;1491us;96us;1291us;98us;1191us;100us;1934us;102us;1954us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1288us;145us;1960us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1477us;158us;1366us;159us;1166us;160us;1955us;161us;1956us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;182us;1962us;183us;1363us;184us;1360us;185us;1946us;186us;1948us;187us;1413us;188us;1945us;189us;1354us;190us;1943us;191us;1942us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1932us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;1us;32768us;76us;1448us;1us;32768us;178us;1449us;0us;17176us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17177us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1070us;3us;32768us;10us;1077us;59us;1454us;203us;1061us;0us;17178us;0us;17179us;0us;17180us;0us;17181us;0us;17182us;0us;17183us;0us;17184us;0us;17185us;0us;17186us;0us;17187us;0us;17188us;0us;17189us;0us;17190us;0us;17191us;0us;17192us;81us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;142us;1475us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1473us;3us;32768us;10us;1077us;142us;1471us;203us;1061us;0us;17193us;0us;17194us;1us;32768us;142us;1474us;0us;17195us;0us;17196us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1071us;82us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;156us;1967us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1071us;3us;32768us;10us;1077us;156us;1479us;203us;1061us;0us;17197us;0us;17198us;0us;17199us;0us;17200us;81us;17233us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1072us;3us;32768us;10us;1077us;64us;1485us;203us;1061us;0us;17201us;0us;17202us;0us;17203us;0us;17204us;90us;32768us;10us;1077us;13us;1189us;15us;1501us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;1498us;39us;1499us;41us;769us;46us;1429us;56us;1437us;60us;1500us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;88us;1541us;89us;1368us;90us;1371us;91us;1415us;92us;1490us;93us;2051us;94us;2048us;95us;2050us;96us;1290us;97us;1503us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1352us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1073us;104us;32768us;10us;1077us;13us;1189us;15us;1501us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;1498us;39us;1499us;41us;769us;46us;1429us;56us;1437us;58us;1969us;60us;1500us;62us;1357us;63us;1949us;66us;1398us;69us;1953us;70us;1431us;71us;1483us;72us;1627us;74us;1425us;82us;1961us;85us;1131us;86us;1133us;88us;1541us;89us;1369us;90us;1372us;91us;1415us;92us;1490us;93us;2051us;94us;2048us;95us;2050us;96us;1291us;97us;1503us;98us;1191us;100us;1934us;102us;1954us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1288us;145us;1960us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1477us;158us;1366us;159us;1166us;160us;1955us;161us;1956us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;182us;1962us;183us;1363us;184us;1360us;185us;1946us;186us;1948us;187us;1413us;188us;1945us;189us;1353us;190us;1943us;191us;1942us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1074us;104us;32768us;10us;1077us;13us;1189us;15us;1501us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;1498us;39us;1499us;41us;769us;46us;1429us;56us;1437us;58us;1969us;60us;1500us;62us;1357us;63us;1949us;66us;1398us;69us;1953us;70us;1431us;71us;1483us;72us;1627us;74us;1425us;82us;1961us;85us;1131us;86us;1133us;88us;1541us;89us;1369us;90us;1372us;91us;1415us;92us;1490us;93us;2051us;94us;2048us;95us;2050us;96us;1291us;97us;1503us;98us;1191us;100us;1934us;102us;1954us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1288us;145us;1960us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1477us;158us;1366us;159us;1166us;160us;1955us;161us;1956us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;182us;1962us;183us;1363us;184us;1360us;185us;1946us;186us;1948us;187us;1413us;188us;1945us;189us;1353us;190us;1943us;191us;1942us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1074us;0us;17205us;9us;32768us;10us;1077us;15us;2059us;37us;2056us;39us;2057us;60us;2058us;93us;2051us;94us;2048us;95us;2050us;203us;1061us;0us;17206us;0us;17207us;0us;17208us;0us;17208us;0us;17209us;0us;17210us;0us;17211us;0us;17212us;0us;17213us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17214us;1us;32768us;77us;1506us;1us;32768us;92us;1507us;1us;16553us;73us;317us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17215us;0us;17216us;0us;17217us;0us;17218us;4us;17218us;93us;17221us;94us;17221us;95us;17221us;102us;17221us;4us;32768us;93us;2051us;94us;2048us;95us;2050us;102us;1517us;0us;17219us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;6us;17220us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;85us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;54us;1557us;56us;1437us;60us;2043us;61us;2045us;62us;1356us;66us;1399us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1375us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;196us;2046us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1075us;5us;32768us;10us;1077us;60us;2043us;61us;2045us;196us;2046us;203us;1061us;0us;17222us;0us;17223us;0us;17224us;0us;17225us;0us;17226us;0us;17227us;0us;17228us;0us;17229us;0us;17230us;0us;17232us;0us;17234us;81us;32768us;10us;1077us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17235us;86us;32768us;10us;1077us;13us;1189us;15us;2065us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17237us;0us;17238us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;79us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17240us;0us;17241us;1us;32768us;201us;2016us;3us;17247us;37us;2033us;38us;2036us;108us;2037us;0us;17244us;42us;17249us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;77us;1553us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1395us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;1us;32768us;88us;1546us;0us;17242us;0us;17243us;0us;17246us;1us;32768us;92us;1550us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17248us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1555us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17250us;37us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;93us;2051us;94us;2048us;95us;2050us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1867us;0us;17251us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1837us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;2us;17576us;35us;2031us;36us;2030us;30us;17245us;56us;1624us;71us;1483us;72us;1627us;92us;1489us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17272us;2us;17264us;21us;1586us;83us;1587us;0us;17252us;0us;17253us;82us;32768us;10us;1077us;13us;1189us;22us;1036us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17272us;2us;17264us;21us;1586us;83us;1587us;0us;17254us;0us;17255us;80us;17258us;13us;1189us;22us;1036us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17272us;2us;17264us;21us;1586us;83us;1587us;0us;17259us;3us;32768us;46us;1924us;66us;1591us;193us;1923us;0us;17272us;2us;17264us;21us;1586us;83us;1587us;0us;17260us;5us;17264us;21us;1586us;46us;1924us;66us;1591us;83us;1587us;193us;1923us;1us;32768us;20us;1579us;0us;17261us;0us;17272us;2us;17264us;21us;1586us;83us;1587us;1us;32768us;20us;1583us;0us;17262us;0us;17263us;3us;17263us;46us;1924us;66us;1591us;193us;1923us;1us;17265us;83us;1589us;1us;17266us;21us;1588us;0us;17267us;0us;17268us;1us;17269us;76us;1926us;0us;17270us;0us;17271us;8us;17276us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;60us;2063us;69us;1594us;94us;2064us;203us;1061us;87us;17274us;10us;1077us;13us;1189us;15us;2065us;22us;1036us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;37us;2061us;39us;2062us;41us;769us;46us;1429us;56us;1437us;60us;2063us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;94us;2064us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;0us;17273us;0us;17275us;0us;17277us;3us;17543us;21us;2001us;26us;1608us;87us;1606us;1us;17543us;21us;2001us;3us;17290us;14us;594us;111us;593us;203us;1617us;0us;17278us;2us;32768us;14us;594us;111us;593us;0us;17279us;0us;17281us;0us;17284us;3us;16553us;22us;537us;73us;317us;203us;804us;0us;17286us;2us;16553us;73us;317us;203us;804us;1us;32768us;20us;1610us;0us;17287us;3us;17535us;19us;1996us;20us;1997us;142us;1998us;0us;17288us;3us;17290us;14us;594us;111us;593us;203us;1617us;0us;17289us;3us;17290us;14us;594us;111us;593us;203us;1617us;0us;17291us;3us;17290us;14us;594us;111us;593us;203us;1617us;0us;17292us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;8us;17285us;26us;1608us;36us;1748us;46us;1924us;70us;1762us;87us;1606us;91us;1918us;189us;1920us;193us;1923us;3us;17535us;19us;1996us;20us;1997us;142us;1998us;1us;17543us;21us;2001us;0us;17293us;1us;32768us;72us;1627us;0us;17294us;0us;17295us;43us;32768us;10us;1077us;46us;1429us;56us;1437us;65us;2047us;66us;1399us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1076us;3us;32768us;10us;1077us;65us;2047us;203us;1061us;0us;17296us;0us;17297us;0us;17298us;0us;17299us;0us;17300us;35us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;1us;32768us;98us;1636us;81us;32768us;13us;1189us;22us;1030us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1638us;0us;17301us;0us;17302us;36us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;66us;500us;70us;957us;71us;960us;74us;963us;92us;971us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1649us;2us;32768us;98us;1641us;203us;1647us;82us;32768us;10us;1077us;13us;1189us;18us;1645us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;203us;1061us;3us;32768us;10us;1077us;20us;1643us;203us;1061us;0us;17303us;0us;17304us;1us;32768us;20us;1646us;0us;17305us;1us;32768us;20us;1648us;0us;17307us;1us;32768us;20us;1650us;0us;17308us;40us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;58us;1313us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1316us;0us;17309us;40us;32768us;43us;514us;44us;513us;45us;515us;46us;503us;56us;978us;58us;1313us;66us;500us;70us;957us;71us;960us;73us;317us;74us;963us;81us;938us;92us;971us;97us;1015us;100us;1934us;106us;969us;122us;968us;148us;970us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;193us;1923us;194us;2017us;195us;952us;201us;2016us;202us;849us;203us;1316us;1us;32768us;20us;1655us;0us;17310us;1us;17311us;84us;1657us;32us;32768us;46us;1924us;52us;638us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;653us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;17313us;84us;1659us;32us;32768us;46us;1924us;52us;638us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;653us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;36us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17316us;0us;17317us;1us;17320us;98us;1664us;36us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1671us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17318us;0us;17319us;1us;17324us;96us;1668us;36us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1677us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17321us;0us;17322us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1677us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17323us;1us;17328us;96us;1674us;36us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1677us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17325us;0us;17326us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;73us;317us;74us;1693us;88us;1844us;91us;1918us;92us;1751us;96us;1677us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17327us;32us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;74us;1684us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;7us;17333us;36us;1748us;46us;1924us;70us;1762us;77us;1681us;91us;1918us;189us;1920us;193us;1923us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;6us;17329us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;0us;17330us;1us;32768us;193us;1923us;1us;32768us;77us;1686us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;6us;17331us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;0us;17332us;7us;17338us;36us;1748us;46us;1924us;70us;1762us;77us;1690us;91us;1918us;189us;1920us;193us;1923us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;6us;17334us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;0us;17335us;1us;32768us;193us;1923us;1us;32768us;77us;1695us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;6us;17336us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;189us;1920us;193us;1923us;0us;17337us;7us;17342us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;98us;1700us;189us;1920us;193us;1923us;7us;32768us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;98us;1700us;189us;1920us;193us;1923us;34us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;98us;1703us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17339us;0us;17340us;31us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17341us;1us;17346us;98us;1706us;36us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;98us;1709us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17343us;0us;17344us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17345us;1us;32768us;10us;1712us;0us;17347us;8us;17355us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;96us;1714us;186us;1722us;189us;1920us;193us;1923us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17348us;0us;17349us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17350us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17351us;0us;17352us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17353us;0us;17354us;8us;17362us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;96us;1726us;186us;1731us;189us;1920us;193us;1923us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17356us;0us;17357us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17358us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17359us;0us;17360us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17361us;2us;17366us;79us;1757us;89us;1737us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;2us;17417us;76us;1870us;89us;1739us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;17365us;76us;1926us;0us;17366us;1us;17368us;189us;1744us;4us;17368us;34us;1876us;76us;1873us;160us;1878us;189us;1744us;3us;32768us;62us;862us;92us;858us;178us;857us;0us;17367us;9us;32768us;10us;1077us;36us;1748us;46us;1924us;70us;1762us;91us;1918us;96us;1855us;189us;1920us;193us;1923us;203us;1061us;0us;17369us;1us;32768us;70us;1762us;0us;17370us;0us;17371us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1867us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;4us;32768us;46us;1924us;91us;1918us;189us;1920us;193us;1923us;0us;17372us;0us;17373us;0us;17374us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17375us;1us;17421us;79us;1760us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17376us;2us;32768us;59us;1763us;97us;1764us;0us;17377us;2us;32768us;59us;1765us;97us;1766us;0us;17378us;2us;32768us;59us;1767us;97us;1768us;0us;17379us;2us;32768us;59us;1769us;97us;1770us;0us;17380us;2us;32768us;59us;1771us;97us;1772us;0us;17381us;2us;32768us;59us;1773us;97us;1774us;0us;17382us;2us;32768us;59us;1775us;97us;1776us;0us;17383us;2us;32768us;59us;1777us;97us;1778us;0us;17384us;2us;32768us;59us;1779us;97us;1780us;0us;17385us;2us;32768us;59us;1781us;97us;1782us;0us;17386us;2us;32768us;59us;1783us;97us;1784us;0us;17387us;2us;32768us;59us;1785us;97us;1786us;0us;17388us;2us;32768us;59us;1787us;97us;1788us;0us;17389us;2us;32768us;59us;1789us;97us;1790us;0us;17390us;2us;32768us;59us;1791us;97us;1792us;0us;17391us;2us;32768us;59us;1793us;97us;1794us;0us;17392us;2us;32768us;59us;1795us;97us;1796us;0us;17393us;2us;32768us;59us;1797us;97us;1798us;0us;17394us;2us;32768us;59us;1799us;97us;1800us;0us;17395us;2us;32768us;59us;1801us;97us;1802us;0us;17396us;2us;32768us;59us;1803us;97us;1804us;0us;17397us;2us;32768us;59us;1805us;97us;1806us;0us;17398us;2us;32768us;59us;1807us;97us;1808us;0us;17399us;2us;32768us;59us;1809us;97us;1810us;0us;17400us;2us;32768us;59us;1811us;97us;1812us;0us;17401us;2us;32768us;59us;1813us;97us;1814us;0us;17402us;2us;32768us;59us;1815us;97us;1816us;0us;17403us;2us;32768us;59us;1817us;97us;1818us;0us;17404us;2us;32768us;59us;1819us;97us;1820us;0us;17405us;2us;32768us;59us;1821us;97us;1822us;0us;17406us;2us;32768us;59us;1823us;97us;1824us;0us;17407us;1us;32768us;59us;1825us;0us;17408us;1us;32768us;97us;1827us;33us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17412us;1us;17409us;97us;1831us;4us;32768us;10us;1077us;97us;1831us;161us;1882us;203us;1061us;33us;17453us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17410us;0us;17411us;1us;17413us;189us;1835us;3us;32768us;62us;862us;92us;858us;178us;857us;0us;17414us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1867us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;4us;32768us;46us;1924us;91us;1918us;189us;1920us;193us;1923us;0us;17415us;1us;17416us;76us;1870us;1us;17417us;76us;1870us;0us;17418us;30us;32768us;46us;1924us;56us;1853us;66us;1847us;88us;1844us;91us;1918us;92us;1848us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;1us;17419us;76us;1870us;0us;17420us;0us;17421us;34us;32768us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1867us;5us;32768us;10us;1077us;93us;2051us;94us;2048us;95us;2050us;203us;1061us;6us;17448us;10us;1077us;69us;1891us;93us;2051us;94us;2048us;95us;2050us;203us;1061us;0us;17422us;0us;17423us;1us;32768us;92us;1854us;33us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;35us;32768us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1729us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1734us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;5us;32768us;10us;1077us;93us;2051us;94us;2048us;95us;2050us;203us;1061us;0us;17424us;0us;17425us;0us;17426us;0us;17427us;0us;17428us;0us;17429us;0us;17430us;40us;32768us;46us;1429us;56us;1437us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;91us;1414us;92us;1491us;100us;1934us;106us;1465us;122us;1464us;136us;1469us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;187us;1412us;193us;1923us;194us;2017us;195us;1519us;199us;2025us;200us;2028us;201us;2016us;202us;849us;0us;17432us;0us;17433us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17434us;0us;17435us;2us;32768us;46us;1924us;193us;1923us;3us;17436us;34us;1876us;76us;1926us;160us;1878us;0us;17437us;7us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;60us;2063us;94us;2064us;203us;1061us;0us;17438us;0us;17439us;1us;32768us;160us;1878us;0us;17440us;36us;17453us;10us;1077us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;161us;1888us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;1us;32768us;97us;1880us;40us;17453us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;46us;1924us;56us;581us;60us;2063us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;94us;2064us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;203us;1061us;0us;17412us;0us;17441us;0us;17442us;0us;17443us;8us;17451us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;60us;2063us;94us;2064us;161us;1886us;203us;1061us;0us;17444us;0us;17445us;0us;17446us;0us;17447us;1us;17448us;69us;1891us;33us;17450us;46us;1924us;56us;581us;66us;1759us;72us;584us;88us;1844us;91us;1918us;92us;1751us;96us;1717us;106us;1866us;113us;1864us;122us;1865us;148us;1863us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;186us;1719us;189us;1920us;193us;1923us;194us;2017us;201us;2016us;202us;849us;0us;17449us;0us;17451us;0us;17452us;8us;32768us;46us;1924us;66us;1898us;91us;1918us;92us;1902us;178us;1908us;186us;1917us;189us;1920us;193us;1923us;3us;32768us;96us;1915us;161us;1897us;186us;1916us;0us;17454us;1us;32768us;161us;1899us;0us;17455us;1us;17456us;76us;1926us;0us;17457us;7us;32768us;46us;1924us;91us;1918us;92us;1902us;178us;1908us;186us;1917us;189us;1920us;193us;1923us;5us;32768us;93us;2051us;94us;2048us;95us;2050us;96us;1915us;186us;1916us;0us;17458us;1us;17459us;189us;1906us;3us;32768us;62us;862us;92us;858us;178us;857us;0us;17460us;0us;17461us;6us;17462us;46us;1924us;91us;1918us;92us;1902us;178us;1908us;189us;1920us;193us;1923us;0us;17463us;0us;17464us;0us;17465us;0us;17466us;0us;17467us;7us;32768us;46us;1924us;91us;1918us;92us;1902us;178us;1908us;186us;1917us;189us;1920us;193us;1923us;7us;32768us;46us;1924us;91us;1918us;92us;1902us;178us;1908us;186us;1917us;189us;1920us;193us;1923us;7us;32768us;46us;1924us;91us;1918us;92us;1902us;178us;1908us;186us;1917us;189us;1920us;193us;1923us;1us;32768us;193us;1923us;0us;17468us;1us;32768us;193us;1923us;0us;17469us;81us;17469us;10us;17516us;15us;17516us;21us;17516us;28us;17516us;34us;17516us;35us;17516us;36us;17516us;37us;17516us;39us;17516us;46us;17516us;56us;17516us;60us;17516us;62us;17516us;63us;17516us;66us;17516us;68us;17516us;69us;17516us;70us;17516us;71us;17516us;72us;17516us;74us;17516us;76us;17516us;78us;17516us;79us;17516us;80us;17516us;81us;17516us;82us;17516us;83us;17516us;89us;17516us;90us;17516us;91us;17516us;92us;17516us;96us;17516us;97us;17516us;100us;17516us;104us;17516us;106us;17516us;122us;17516us;128us;17516us;136us;17516us;143us;17516us;145us;17516us;148us;17516us;149us;17516us;154us;17516us;155us;17516us;158us;17516us;160us;17516us;161us;17516us;166us;17516us;167us;17516us;168us;17516us;169us;17516us;170us;17516us;171us;17516us;172us;17516us;173us;17516us;174us;17516us;175us;17516us;176us;17516us;177us;17516us;178us;17516us;180us;17516us;181us;17516us;183us;17516us;184us;17516us;185us;17516us;186us;17516us;187us;17516us;188us;17516us;189us;17516us;190us;17516us;191us;17516us;193us;17516us;194us;17516us;195us;17516us;199us;17516us;200us;17516us;201us;17516us;202us;17516us;203us;17516us;0us;17470us;0us;17471us;0us;17472us;8us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;60us;2063us;94us;2064us;193us;1923us;203us;1061us;0us;17473us;0us;17474us;27us;32768us;58us;1969us;62us;1951us;63us;1949us;69us;1953us;74us;1957us;82us;1961us;89us;1958us;90us;1959us;96us;1952us;102us;1954us;143us;1964us;145us;1960us;155us;1966us;158us;1963us;160us;1955us;161us;1956us;182us;1962us;183us;1950us;184us;1947us;185us;1946us;186us;1948us;187us;1941us;188us;1945us;189us;1944us;190us;1943us;191us;1942us;203us;1932us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17475us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17476us;0us;17477us;1us;32768us;58us;1936us;5us;32768us;66us;1938us;93us;2051us;94us;2048us;95us;2050us;193us;1968us;0us;17478us;1us;32768us;58us;1939us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17479us;0us;17480us;0us;17481us;0us;17482us;0us;17483us;0us;17484us;0us;17485us;0us;17486us;0us;17487us;0us;17488us;0us;17489us;0us;17490us;0us;17491us;0us;17492us;0us;17493us;0us;17494us;0us;17495us;0us;17496us;0us;17497us;0us;17498us;0us;17499us;0us;17500us;0us;17501us;0us;17502us;1us;17503us;143us;1965us;0us;17504us;1us;32768us;156us;1967us;0us;17505us;0us;17506us;1us;32768us;193us;1968us;0us;17507us;0us;17508us;0us;17509us;0us;17510us;1us;17511us;76us;1976us;0us;17512us;10us;32768us;10us;1077us;15us;2065us;37us;2061us;39us;2062us;60us;2063us;92us;1929us;94us;2064us;100us;1934us;193us;1923us;203us;1061us;0us;17513us;0us;17514us;0us;17515us;0us;17516us;0us;17517us;0us;17518us;0us;17519us;0us;17520us;3us;17521us;21us;1984us;67us;1983us;83us;1982us;0us;17522us;3us;17524us;21us;1984us;67us;1983us;83us;1982us;0us;17523us;1us;17525us;83us;1991us;1us;17526us;21us;1992us;0us;17527us;0us;17528us;0us;17529us;0us;17530us;0us;17531us;0us;17532us;0us;17533us;0us;17534us;0us;17536us;0us;17538us;0us;17542us;0us;17544us;0us;17546us;0us;17550us;0us;17552us;0us;17554us;0us;17555us;0us;17556us;0us;17557us;0us;17558us;0us;17559us;0us;17560us;0us;17561us;0us;17562us;0us;17563us;0us;17564us;0us;17565us;1us;32768us;193us;1923us;0us;17567us;0us;17568us;81us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;197us;2020us;198us;2021us;199us;2025us;200us;2028us;201us;2016us;202us;849us;2us;32768us;197us;2020us;198us;2021us;0us;17569us;0us;17570us;81us;32768us;13us;1189us;24us;1639us;25us;1653us;29us;1186us;30us;759us;32us;1173us;33us;755us;41us;769us;46us;1429us;56us;1437us;62us;1356us;66us;1398us;70us;1431us;71us;1483us;72us;1627us;74us;1424us;85us;1131us;86us;1133us;89us;1368us;90us;1371us;91us;1414us;92us;1491us;96us;1290us;98us;1191us;100us;1934us;106us;1465us;107us;1110us;114us;1123us;115us;1127us;116us;1102us;117us;1106us;119us;1374us;122us;1464us;123us;1135us;124us;1634us;125us;1651us;126us;1118us;130us;1181us;133us;1125us;134us;1129us;136us;1469us;143us;1287us;146us;1386us;147us;1388us;148us;1463us;149us;1418us;154us;1421us;155us;1476us;158us;1365us;159us;1166us;162us;749us;163us;1160us;164us;1162us;166us;846us;167us;845us;168us;844us;169us;843us;170us;842us;171us;841us;172us;839us;173us;837us;174us;835us;175us;833us;176us;840us;177us;838us;178us;836us;180us;834us;181us;832us;183us;1362us;184us;1359us;187us;1412us;189us;1351us;193us;1923us;194us;2017us;195us;1519us;197us;2020us;198us;2021us;199us;2025us;200us;2028us;201us;2016us;202us;849us;2us;32768us;197us;2020us;198us;2021us;0us;17571us;0us;17572us;0us;17573us;0us;17574us;0us;17575us;0us;17577us;3us;32768us;37us;2033us;38us;2036us;108us;2037us;3us;17600us;37us;2033us;38us;2036us;108us;2037us;0us;17579us;0us;17580us;0us;17581us;3us;32768us;39us;2038us;40us;2041us;150us;2042us;3us;17601us;39us;2038us;40us;2041us;150us;2042us;0us;17582us;0us;17583us;0us;17584us;3us;32768us;60us;2043us;61us;2045us;196us;2046us;0us;17585us;0us;17586us;0us;17587us;0us;17588us;3us;32768us;93us;2051us;94us;2048us;95us;2050us;0us;17589us;0us;17590us;0us;17591us;3us;32768us;15us;2052us;16us;2054us;17us;2055us;0us;17592us;0us;17593us;0us;17594us;0us;17595us;0us;17596us;0us;17597us;0us;17598us;0us;17599us;0us;17600us;0us;17601us;0us;17602us;0us;17603us;0us;17604us;0us;17605us;|]
let _fsyacc_actionTableRowOffsets = [|0us;17us;18us;114us;115us;123us;124us;204us;205us;239us;240us;241us;242us;243us;244us;245us;246us;251us;252us;257us;258us;263us;264us;270us;271us;277us;278us;284us;285us;302us;303us;307us;395us;422us;423us;426us;427us;428us;429us;431us;432us;435us;436us;437us;438us;441us;442us;444us;445us;450us;451us;453us;457us;459us;465us;467us;468us;469us;471us;476us;478us;479us;481us;482us;484us;485us;487us;504us;505us;509us;518us;537us;538us;539us;540us;556us;562us;564us;565us;566us;573us;574us;575us;579us;597us;601us;617us;618us;622us;627us;628us;629us;630us;634us;643us;647us;653us;654us;655us;656us;658us;660us;661us;662us;663us;665us;667us;669us;673us;677us;680us;682us;717us;719us;720us;801us;828us;908us;938us;940us;941us;950us;954us;955us;971us;973us;977us;978us;994us;996us;997us;999us;1001us;1002us;1005us;1013us;1014us;1015us;1070us;1072us;1087us;1089us;1093us;1095us;1096us;1098us;1099us;1100us;1101us;1103us;1138us;1139us;1140us;1157us;1161us;1162us;1163us;1165us;1166us;1181us;1187us;1188us;1189us;1205us;1209us;1210us;1211us;1226us;1232us;1233us;1234us;1235us;1236us;1239us;1254us;1255us;1259us;1263us;1274us;1321us;1323us;1327us;1331us;1334us;1336us;1371us;1374us;1376us;1377us;1409us;1416us;1450us;1457us;1458us;1460us;1461us;1468us;1470us;1471us;1473us;1474us;1476us;1511us;1512us;1517us;1518us;1523us;1526us;1527us;1528us;1530us;1536us;1537us;1538us;1542us;1544us;1545us;1546us;1547us;1549us;1550us;1566us;1570us;1571us;1574us;1575us;1577us;1578us;1583us;1584us;1586us;1587us;1589us;1590us;1592us;1688us;1689us;1694us;1782us;1879us;1880us;1881us;1976us;1982us;1984us;1985us;1986us;1993us;1994us;1995us;1996us;2001us;2089us;2119us;2214us;2215us;2216us;2217us;2239us;2240us;2335us;2336us;2340us;2344us;2351us;2356us;2361us;2362us;2363us;2364us;2368us;2380us;2381us;2383us;2384us;2465us;2466us;2468us;2470us;2471us;2472us;2475us;2481us;2482us;2483us;2486us;2487us;2488us;2496us;2498us;2499us;2533us;2540us;2541us;2546us;2547us;2549us;2556us;2562us;2563us;2564us;2570us;2571us;2572us;2573us;2574us;2576us;2671us;2675us;2676us;2677us;2678us;2685us;2689us;2690us;2691us;2693us;2694us;2709us;2712us;2721us;2723us;2724us;2726us;2728us;2729us;2730us;2731us;2732us;2742us;2743us;2747us;2778us;2779us;2783us;2787us;2818us;2819us;2822us;2827us;2830us;2861us;2862us;2864us;2865us;2867us;2868us;2870us;2871us;2873us;2874us;2886us;2887us;2888us;2889us;2890us;2894us;2896us;2897us;2899us;2901us;2902us;2942us;2943us;2947us;2950us;2952us;2954us;2958us;2965us;2966us;2967us;2977us;2979us;2987us;2989us;2995us;2997us;2998us;2999us;3000us;3002us;3003us;3004us;3005us;3007us;3042us;3043us;3044us;3055us;3064us;3065us;3066us;3076us;3077us;3079us;3085us;3086us;3087us;3094us;3100us;3101us;3102us;3103us;3104us;3119us;3120us;3123us;3138us;3139us;3141us;3142us;3144us;3147us;3148us;3149us;3151us;3153us;3154us;3156us;3194us;3196us;3198us;3279us;3280us;3318us;3320us;3327us;3408us;3409us;3410us;3411us;3412us;3414us;3415us;3417us;3418us;3422us;3426us;3442us;3494us;3495us;3496us;3501us;3503us;3504us;3505us;3539us;3547us;3548us;3549us;3551us;3555us;3558us;3560us;3595us;3598us;3600us;3601us;3602us;3604us;3605us;3607us;3608us;3610us;3611us;3649us;3651us;3661us;3742us;3744us;3745us;3746us;3747us;3749us;3750us;3752us;3753us;3755us;3759us;3763us;3767us;3803us;3804us;3805us;3806us;3807us;3809us;3813us;3817us;3819us;3829us;3910us;3913us;3914us;3915us;3916us;3917us;3953us;3954us;3955us;3957us;3961us;3962us;3964us;3968us;3969us;3970us;3975us;3977us;3981us;3982us;3983us;3984us;3985us;3986us;3987us;4019us;4023us;4024us;4031us;4035us;4036us;4074us;4108us;4109us;4140us;4142us;4143us;4144us;4145us;4149us;4150us;4151us;4152us;4155us;4156us;4157us;4159us;4165us;4166us;4167us;4168us;4171us;4186us;4187us;4192us;4198us;4202us;4204us;4205us;4207us;4208us;4209us;4211us;4213us;4214us;4216us;4217us;4218us;4219us;4223us;4260us;4263us;4265us;4268us;4269us;4270us;4271us;4272us;4307us;4338us;4340us;4344us;4345us;4351us;4357us;4358us;4359us;4363us;4364us;4365us;4368us;4369us;4370us;4373us;4377us;4378us;4379us;4381us;4382us;4383us;4384us;4385us;4386us;4387us;4395us;4399us;4402us;4404us;4405us;4406us;4407us;4409us;4414us;4415us;4418us;4420us;4422us;4425us;4426us;4427us;4430us;4432us;4463us;4465us;4467us;4469us;4471us;4472us;4473us;4475us;4479us;4481us;4483us;4484us;4485us;4518us;4520us;4522us;4524us;4557us;4558us;4559us;4561us;4563us;4594us;4596us;4598us;4601us;4603us;4637us;4638us;4642us;4676us;4681us;4687us;4688us;4692us;4693us;4694us;4696us;4700us;4701us;4736us;4741us;4743us;4745us;4747us;4751us;4752us;4755us;4756us;4757us;4764us;4796us;4803us;4817us;4819us;4820us;4822us;4824us;4825us;4828us;4829us;4831us;4833us;4834us;4838us;4845us;4881us;4882us;4917us;4918us;4919us;4954us;4955us;4956us;4957us;4992us;4993us;5034us;5040us;5041us;5071us;5075us;5076us;5078us;5082us;5083us;5088us;5089us;5130us;5137us;5184us;5185us;5220us;5221us;5222us;5255us;5256us;5258us;5290us;5291us;5293us;5325us;5333us;5341us;5342us;5343us;5344us;5345us;5348us;5354us;5355us;5356us;5358us;5359us;5363us;5367us;5371us;5407us;5408us;5409us;5410us;5411us;5413us;5414us;5416us;5420us;5424us;5426us;5427us;5428us;5430us;5465us;5466us;5467us;5470us;5472us;5474us;5477us;5478us;5479us;5560us;5561us;5563us;5566us;5570us;5571us;5653us;5657us;5658us;5659us;5660us;5661us;5662us;5663us;5664us;5665us;5667us;5671us;5673us;5676us;5678us;5683us;5687us;5688us;5690us;5692us;5694us;5695us;5697us;5698us;5702us;5709us;5710us;5712us;5718us;5720us;5722us;5723us;5724us;5725us;5727us;5729us;5730us;5734us;5736us;5737us;5740us;5742us;5743us;5745us;5746us;5747us;5749us;5787us;5789us;5793us;5875us;5876us;5877us;5878us;5958us;5964us;5965us;5966us;5967us;5968us;5970us;5971us;5974us;5977us;6058us;6059us;6062us;6063us;6064us;6067us;6101us;6102us;6103us;6104us;6105us;6106us;6107us;6108us;6109us;6110us;6111us;6112us;6113us;6114us;6115us;6116us;6117us;6118us;6119us;6120us;6121us;6123us;6125us;6126us;6128us;6130us;6132us;6133us;6134us;6137us;6141us;6142us;6143us;6146us;6147us;6149us;6151us;6152us;6158us;6159us;6161us;6162us;6164us;6167us;6203us;6204us;6205us;6209us;6213us;6214us;6215us;6224us;6230us;6231us;6232us;6233us;6237us;6238us;6239us;6243us;6245us;6248us;6251us;6254us;6256us;6258us;6265us;6272us;6279us;6286us;6323us;6324us;6362us;6400us;6402us;6403us;6404us;6449us;6494us;6495us;6496us;6541us;6542us;6580us;6618us;6621us;6622us;6626us;6627us;6629us;6630us;6634us;6639us;6680us;6687us;6688us;6689us;6729us;6767us;6768us;6804us;6805us;6841us;6842us;6843us;6879us;6880us;6916us;6917us;6949us;6950us;6951us;7016us;7020us;7021us;7022us;7060us;7061us;7097us;7098us;7134us;7135us;7136us;7140us;7144us;7145us;7149us;7150us;7189us;7191us;7192us;7231us;7233us;7234us;7236us;7238us;7239us;7240us;7241us;7242us;7243us;7244us;7309us;7315us;7316us;7317us;7321us;7324us;7325us;7327us;7368us;7375us;7376us;7377us;7381us;7382us;7383us;7390us;7395us;7399us;7402us;7406us;7410us;7414us;7417us;7424us;7427us;7434us;7443us;7459us;7467us;7504us;7505us;7544us;7546us;7548us;7584us;7585us;7586us;7625us;7664us;7665us;7711us;7757us;7758us;7759us;7805us;7806us;7845us;7884us;7887us;7888us;7891us;7892us;7897us;7938us;7939us;7940us;7941us;7980us;7981us;8064us;8070us;8071us;8072us;8073us;8074us;8157us;8161us;8162us;8163us;8190us;8192us;8193us;8194us;8288us;8290us;8326us;8327us;8328us;8330us;8331us;8362us;8442us;8443us;8523us;8524us;8526us;8606us;8610us;8611us;8694us;8695us;8698us;8701us;8704us;8707us;8710us;8711us;8713us;8715us;8717us;8719us;8721us;8725us;8729us;8733us;8735us;8736us;8774us;8855us;8857us;8860us;8861us;8899us;8980us;8984us;8986us;8989us;8990us;8992us;9073us;9074us;9075us;9158us;9159us;9160us;9242us;9243us;9244us;9245us;9246us;9247us;9327us;9332us;9333us;9334us;9414us;9419us;9420us;9421us;9504us;9510us;9511us;9512us;9515us;9516us;9597us;9598us;9680us;9711us;9712us;9713us;9714us;9794us;9795us;9864us;9865us;9946us;9947us;10017us;10018us;10100us;10101us;10183us;10184us;10230us;10241us;10329us;10339us;10340us;10341us;10342us;10343us;10344us;10346us;10347us;10352us;10435us;10440us;10441us;10442us;10443us;10444us;10445us;10526us;10529us;10530us;10531us;10532us;10533us;10615us;10642us;10724us;10751us;10752us;10753us;10791us;10872us;10874us;10876us;10879us;10960us;10961us;10999us;11080us;11084us;11086us;11090us;11171us;11172us;11173us;11253us;11255us;11257us;11338us;11339us;11420us;11424us;11425us;11505us;11532us;11614us;11615us;11642us;11663us;11684us;11694us;11715us;11734us;11753us;11763us;11773us;11783us;11793us;11803us;11813us;11823us;11825us;11834us;11839us;11844us;11846us;11848us;11850us;11874us;11899us;11930us;11957us;11984us;12011us;12042us;12067us;12092us;12117us;12144us;12169us;12199us;12226us;12255us;12282us;12310us;12346us;12347us;12348us;12384us;12385us;12386us;12422us;12423us;12424us;12504us;12506us;12587us;12588us;12590us;12597us;12684us;12685us;12772us;12773us;12860us;12861us;12948us;12949us;13036us;13037us;13124us;13125us;13212us;13213us;13300us;13301us;13388us;13389us;13476us;13477us;13564us;13565us;13652us;13653us;13740us;13741us;13828us;13829us;13916us;13917us;14004us;14005us;14092us;14093us;14180us;14181us;14268us;14269us;14356us;14357us;14434us;14514us;14594us;14674us;14675us;14676us;14758us;14763us;14764us;14765us;14768us;14769us;14770us;14771us;14772us;14773us;14853us;14857us;14858us;14899us;14900us;14942us;14946us;14947us;14948us;14949us;14950us;14990us;14991us;14992us;14993us;14994us;14998us;15002us;15043us;15044us;15083us;15084us;15085us;15086us;15087us;15167us;15249us;15250us;15254us;15255us;15337us;15338us;15421us;15422us;15423us;15503us;15584us;15585us;15665us;15666us;15667us;15755us;15756us;15843us;15844us;15932us;15933us;16020us;16021us;16072us;16123us;16174us;16225us;16226us;16277us;16328us;16329us;16380us;16431us;16432us;16483us;16534us;16535us;16586us;16637us;16638us;16689us;16740us;16741us;16792us;16843us;16844us;16876us;16908us;16911us;16949us;16981us;17013us;17015us;17022us;17030us;17031us;17032us;17033us;17084us;17085us;17136us;17137us;17179us;17224us;17269us;17270us;17276us;17317us;17323us;17329us;17333us;17338us;17381us;17387us;17388us;17389us;17392us;17394us;17400us;17406us;17447us;17488us;17490us;17491us;17532us;17573us;17575us;17577us;17578us;17579us;17580us;17588us;17589us;17591us;17599us;17600us;17604us;17608us;17609us;17612us;17613us;17614us;17615us;17697us;17701us;17702us;17703us;17704us;17705us;17708us;17788us;17789us;17790us;17791us;17792us;17793us;17794us;17890us;17894us;17896us;17898us;17899us;17903us;17904us;17986us;17990us;17991us;17992us;17993us;17994us;17995us;17996us;17997us;17998us;17999us;18000us;18001us;18002us;18003us;18004us;18005us;18087us;18091us;18092us;18093us;18095us;18096us;18097us;18179us;18262us;18266us;18267us;18268us;18269us;18270us;18352us;18356us;18357us;18358us;18359us;18360us;18451us;18556us;18661us;18662us;18672us;18673us;18674us;18675us;18676us;18677us;18678us;18679us;18680us;18681us;18761us;18762us;18764us;18766us;18768us;18772us;18852us;18853us;18854us;18855us;18856us;18861us;18866us;18867us;18899us;18906us;18992us;18998us;18999us;19000us;19001us;19002us;19003us;19004us;19005us;19006us;19007us;19008us;19009us;19091us;19092us;19179us;19180us;19181us;19261us;19341us;19342us;19343us;19345us;19349us;19350us;19393us;19395us;19396us;19397us;19398us;19400us;19434us;19438us;19439us;19473us;19474us;19512us;19513us;19544us;19547us;19578us;19579us;19582us;19583us;19584us;19667us;19668us;19671us;19672us;19673us;19754us;19755us;19758us;19759us;19763us;19764us;19767us;19768us;19774us;19776us;19777us;19778us;19781us;19783us;19784us;19785us;19789us;19791us;19793us;19794us;19795us;19797us;19798us;19799us;19808us;19896us;19897us;19898us;19899us;19903us;19905us;19909us;19910us;19913us;19914us;19915us;19916us;19920us;19921us;19924us;19926us;19927us;19931us;19932us;19936us;19937us;19941us;19942us;19946us;19947us;19979us;19988us;19992us;19994us;19995us;19997us;19998us;19999us;20043us;20047us;20048us;20049us;20050us;20051us;20052us;20088us;20090us;20172us;20173us;20174us;20211us;20214us;20297us;20301us;20302us;20303us;20305us;20306us;20308us;20309us;20311us;20312us;20353us;20354us;20395us;20397us;20398us;20400us;20433us;20435us;20468us;20505us;20506us;20507us;20509us;20546us;20547us;20548us;20550us;20587us;20588us;20589us;20624us;20625us;20627us;20664us;20665us;20666us;20701us;20702us;20735us;20743us;20777us;20784us;20785us;20787us;20789us;20823us;20830us;20831us;20839us;20873us;20880us;20881us;20883us;20885us;20919us;20926us;20927us;20935us;20943us;20978us;20979us;20980us;21012us;21013us;21015us;21052us;21053us;21054us;21088us;21089us;21091us;21092us;21101us;21137us;21138us;21139us;21173us;21174us;21210us;21211us;21212us;21248us;21249us;21250us;21259us;21295us;21296us;21297us;21331us;21332us;21368us;21369us;21370us;21404us;21405us;21408us;21439us;21442us;21473us;21475us;21476us;21478us;21483us;21487us;21488us;21498us;21499us;21501us;21502us;21503us;21538us;21542us;21547us;21548us;21549us;21550us;21584us;21585us;21587us;21621us;21622us;21625us;21626us;21629us;21630us;21633us;21634us;21637us;21638us;21641us;21642us;21645us;21646us;21649us;21650us;21653us;21654us;21657us;21658us;21661us;21662us;21665us;21666us;21669us;21670us;21673us;21674us;21677us;21678us;21681us;21682us;21685us;21686us;21689us;21690us;21693us;21694us;21697us;21698us;21701us;21702us;21705us;21706us;21709us;21710us;21713us;21714us;21717us;21718us;21721us;21722us;21725us;21726us;21729us;21730us;21733us;21734us;21737us;21738us;21741us;21742us;21745us;21746us;21748us;21749us;21751us;21785us;21786us;21788us;21793us;21827us;21828us;21829us;21831us;21835us;21836us;21871us;21875us;21880us;21881us;21883us;21885us;21886us;21917us;21919us;21920us;21921us;21956us;21962us;21969us;21970us;21971us;21973us;22007us;22043us;22049us;22050us;22051us;22052us;22053us;22054us;22055us;22056us;22097us;22098us;22099us;22103us;22104us;22105us;22108us;22112us;22113us;22121us;22122us;22123us;22125us;22126us;22163us;22165us;22206us;22207us;22208us;22209us;22210us;22219us;22220us;22221us;22222us;22223us;22225us;22259us;22260us;22261us;22262us;22271us;22275us;22276us;22278us;22279us;22281us;22282us;22290us;22296us;22297us;22299us;22303us;22304us;22305us;22312us;22313us;22314us;22315us;22316us;22317us;22325us;22333us;22341us;22343us;22344us;22346us;22347us;22429us;22430us;22431us;22432us;22441us;22442us;22443us;22471us;22475us;22476us;22480us;22481us;22482us;22484us;22490us;22491us;22493us;22497us;22498us;22499us;22500us;22501us;22502us;22503us;22504us;22505us;22506us;22507us;22508us;22509us;22510us;22511us;22512us;22513us;22514us;22515us;22516us;22517us;22518us;22519us;22520us;22521us;22523us;22524us;22526us;22527us;22528us;22530us;22531us;22532us;22533us;22534us;22536us;22537us;22548us;22549us;22550us;22551us;22552us;22553us;22554us;22555us;22556us;22560us;22561us;22565us;22566us;22568us;22570us;22571us;22572us;22573us;22574us;22575us;22576us;22577us;22578us;22579us;22580us;22581us;22582us;22583us;22584us;22585us;22586us;22587us;22588us;22589us;22590us;22591us;22592us;22593us;22594us;22595us;22596us;22597us;22599us;22600us;22601us;22683us;22686us;22687us;22688us;22770us;22773us;22774us;22775us;22776us;22777us;22778us;22779us;22783us;22787us;22788us;22789us;22790us;22794us;22798us;22799us;22800us;22801us;22805us;22806us;22807us;22808us;22809us;22813us;22814us;22815us;22816us;22820us;22821us;22822us;22823us;22824us;22825us;22826us;22827us;22828us;22829us;22830us;22831us;22832us;22833us;|]
let _fsyacc_reductionSymbolCounts = [|1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;2us;2us;2us;3us;3us;3us;1us;2us;3us;1us;1us;2us;1us;1us;3us;0us;2us;1us;1us;2us;3us;2us;5us;5us;5us;3us;3us;1us;2us;2us;1us;3us;4us;1us;1us;4us;3us;3us;1us;1us;0us;3us;3us;2us;1us;1us;5us;5us;4us;5us;3us;1us;12us;0us;2us;5us;3us;5us;3us;3us;0us;3us;2us;7us;2us;1us;1us;3us;1us;3us;3us;3us;3us;3us;3us;3us;3us;3us;1us;1us;0us;3us;11us;4us;4us;4us;4us;5us;5us;5us;0us;2us;3us;3us;1us;3us;3us;3us;1us;1us;2us;3us;0us;2us;3us;2us;1us;2us;2us;1us;3us;4us;1us;4us;3us;3us;1us;1us;0us;5us;4us;3us;1us;2us;2us;3us;1us;2us;3us;1us;1us;3us;3us;3us;5us;3us;5us;4us;2us;1us;2us;2us;3us;3us;3us;1us;3us;3us;3us;3us;3us;1us;1us;3us;3us;3us;3us;1us;0us;1us;2us;5us;4us;4us;2us;1us;3us;3us;4us;6us;2us;2us;2us;2us;2us;1us;1us;1us;1us;3us;3us;0us;1us;2us;8us;7us;7us;6us;2us;2us;1us;1us;3us;1us;3us;3us;3us;3us;3us;3us;3us;1us;1us;2us;0us;3us;2us;3us;3us;1us;3us;6us;5us;4us;4us;4us;1us;2us;2us;3us;3us;4us;5us;4us;5us;4us;10us;3us;4us;5us;5us;8us;6us;6us;5us;5us;6us;6us;5us;4us;8us;6us;6us;4us;0us;2us;2us;3us;3us;1us;4us;2us;0us;1us;1us;1us;1us;3us;1us;0us;3us;0us;3us;5us;2us;1us;0us;2us;2us;1us;0us;2us;2us;3us;3us;1us;3us;2us;4us;4us;3us;4us;2us;1us;1us;6us;3us;3us;3us;7us;3us;3us;3us;2us;2us;1us;3us;3us;3us;1us;1us;1us;1us;1us;2us;3us;3us;2us;1us;3us;3us;1us;2us;4us;5us;3us;1us;0us;5us;1us;0us;0us;2us;3us;1us;3us;1us;4us;3us;3us;4us;3us;5us;7us;4us;4us;3us;1us;3us;1us;2us;3us;1us;1us;3us;1us;3us;3us;5us;4us;4us;4us;5us;5us;5us;1us;3us;4us;2us;4us;2us;3us;3us;2us;4us;3us;1us;3us;1us;3us;1us;1us;1us;3us;2us;2us;5us;5us;4us;3us;2us;5us;4us;1us;3us;3us;0us;2us;3us;1us;2us;4us;3us;2us;1us;1us;1us;1us;1us;1us;8us;1us;1us;0us;3us;3us;2us;3us;1us;4us;2us;2us;2us;2us;2us;2us;3us;0us;2us;1us;6us;6us;5us;3us;3us;1us;2us;2us;0us;4us;3us;1us;3us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;3us;4us;1us;2us;1us;3us;1us;2us;1us;3us;1us;1us;2us;3us;3us;2us;1us;3us;1us;0us;3us;2us;3us;3us;2us;3us;3us;3us;1us;1us;1us;3us;3us;3us;3us;2us;2us;3us;3us;2us;3us;4us;3us;3us;2us;2us;3us;4us;4us;2us;3us;3us;2us;1us;3us;1us;2us;3us;3us;1us;1us;3us;3us;3us;3us;1us;2us;1us;1us;1us;1us;1us;3us;3us;3us;2us;4us;4us;4us;3us;1us;0us;3us;3us;1us;1us;3us;3us;2us;3us;1us;3us;3us;3us;3us;2us;2us;3us;3us;2us;3us;3us;3us;2us;0us;2us;3us;3us;3us;2us;1us;3us;2us;1us;2us;1us;1us;3us;3us;1us;2us;3us;2us;1us;3us;5us;1us;1us;1us;6us;7us;0us;3us;3us;2us;2us;3us;3us;1us;1us;1us;3us;3us;3us;3us;3us;3us;2us;3us;4us;3us;3us;2us;2us;2us;1us;2us;2us;1us;2us;2us;5us;5us;5us;4us;3us;4us;5us;5us;5us;4us;3us;5us;2us;4us;3us;2us;2us;2us;2us;8us;8us;7us;5us;3us;2us;2us;3us;3us;3us;3us;3us;3us;3us;3us;1us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;2us;2us;1us;1us;4us;4us;4us;2us;1us;2us;1us;3us;2us;3us;3us;2us;1us;2us;2us;1us;2us;2us;4us;4us;4us;3us;2us;2us;0us;2us;2us;2us;2us;2us;2us;0us;2us;2us;3us;3us;3us;3us;4us;4us;3us;3us;4us;4us;2us;2us;2us;2us;2us;2us;2us;6us;4us;4us;2us;2us;2us;1us;2us;1us;2us;1us;3us;3us;2us;3us;3us;3us;2us;2us;1us;3us;3us;2us;3us;1us;1us;3us;3us;3us;2us;4us;4us;1us;1us;1us;0us;1us;5us;3us;3us;3us;3us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;3us;3us;3us;2us;3us;3us;3us;2us;3us;3us;3us;2us;2us;3us;3us;3us;2us;2us;2us;2us;2us;4us;6us;1us;1us;1us;3us;3us;1us;3us;3us;3us;2us;2us;1us;1us;1us;1us;0us;1us;0us;1us;2us;3us;3us;2us;5us;1us;1us;6us;2us;0us;0us;1us;0us;4us;0us;2us;3us;6us;1us;5us;3us;1us;1us;2us;5us;5us;4us;6us;1us;0us;1us;1us;2us;2us;1us;1us;3us;0us;3us;2us;3us;1us;2us;4us;3us;2us;5us;4us;2us;1us;0us;2us;3us;3us;2us;0us;2us;2us;5us;2us;1us;3us;3us;3us;2us;2us;4us;4us;5us;5us;5us;4us;4us;3us;2us;3us;1us;3us;1us;3us;0us;2us;2us;3us;3us;1us;3us;3us;2us;1us;3us;3us;2us;1us;4us;4us;5us;5us;2us;3us;3us;4us;4us;1us;3us;3us;4us;3us;3us;3us;4us;1us;2us;3us;3us;2us;2us;2us;3us;3us;1us;3us;3us;2us;3us;3us;2us;1us;3us;3us;1us;1us;3us;1us;2us;3us;2us;4us;1us;1us;3us;3us;2us;3us;4us;5us;6us;7us;8us;9us;10us;11us;12us;13us;14us;15us;16us;17us;18us;19us;20us;21us;22us;23us;24us;25us;26us;27us;28us;29us;30us;31us;32us;33us;4us;3us;3us;0us;1us;3us;4us;1us;1us;1us;2us;1us;1us;3us;3us;6us;6us;5us;4us;3us;1us;1us;2us;1us;1us;3us;2us;3us;4us;3us;1us;2us;6us;6us;4us;3us;3us;2us;2us;1us;3us;2us;1us;1us;0us;3us;3us;1us;1us;3us;1us;3us;1us;1us;2us;1us;3us;3us;2us;2us;2us;1us;1us;1us;3us;3us;3us;3us;1us;4us;6us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;2us;2us;1us;2us;3us;1us;1us;1us;1us;3us;3us;1us;1us;1us;1us;1us;1us;1us;2us;2us;0us;1us;1us;2us;2us;1us;1us;1us;1us;1us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;3us;1us;3us;2us;3us;1us;2us;1us;1us;0us;1us;0us;2us;1us;1us;2us;1us;1us;2us;1us;1us;1us;2us;1us;1us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;|]
let _fsyacc_productionToNonTerminalTable = [|0us;1us;2us;3us;4us;5us;5us;5us;6us;6us;7us;7us;7us;7us;7us;7us;7us;8us;8us;9us;10us;11us;11us;12us;12us;13us;14us;14us;15us;15us;16us;16us;16us;17us;17us;17us;18us;18us;19us;19us;20us;20us;21us;22us;22us;23us;23us;23us;23us;24us;24us;24us;25us;25us;25us;26us;26us;26us;26us;26us;26us;26us;26us;27us;28us;28us;28us;29us;29us;29us;30us;30us;31us;31us;32us;32us;33us;33us;33us;34us;34us;34us;34us;35us;35us;35us;35us;36us;36us;36us;37us;37us;38us;39us;39us;39us;39us;39us;39us;39us;39us;40us;40us;40us;40us;41us;41us;41us;41us;42us;42us;43us;44us;44us;45us;45us;45us;46us;46us;47us;47us;48us;49us;49us;50us;50us;50us;50us;51us;51us;52us;52us;52us;52us;52us;53us;53us;53us;53us;53us;54us;54us;55us;55us;55us;55us;55us;55us;55us;55us;55us;56us;56us;56us;56us;57us;57us;58us;58us;58us;58us;58us;58us;58us;59us;59us;59us;60us;61us;61us;62us;62us;63us;63us;63us;63us;64us;64us;65us;65us;65us;66us;66us;66us;66us;67us;67us;67us;67us;67us;68us;69us;69us;70us;70us;70us;70us;71us;71us;71us;71us;72us;72us;72us;73us;73us;73us;73us;74us;74us;75us;75us;75us;76us;76us;76us;77us;78us;78us;78us;79us;79us;80us;81us;81us;81us;81us;82us;82us;82us;82us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;84us;84us;84us;84us;85us;85us;85us;85us;86us;86us;86us;87us;87us;87us;87us;87us;88us;88us;89us;89us;89us;90us;90us;90us;91us;91us;92us;92us;92us;93us;93us;94us;94us;95us;95us;96us;96us;97us;97us;97us;98us;98us;99us;99us;99us;99us;100us;100us;100us;101us;101us;101us;101us;101us;102us;102us;102us;102us;103us;103us;104us;104us;104us;105us;105us;105us;106us;106us;107us;107us;107us;107us;108us;108us;109us;109us;110us;110us;111us;112us;112us;112us;113us;114us;114us;115us;115us;116us;116us;117us;117us;118us;118us;118us;118us;118us;118us;118us;118us;118us;118us;118us;119us;119us;120us;120us;120us;121us;122us;122us;123us;123us;123us;123us;123us;123us;123us;123us;123us;124us;124us;124us;125us;125us;125us;126us;126us;126us;126us;127us;127us;128us;128us;128us;128us;129us;129us;130us;130us;131us;132us;132us;132us;132us;133us;134us;134us;135us;135us;135us;136us;136us;137us;137us;138us;139us;140us;140us;141us;141us;141us;141us;142us;142us;143us;144us;144us;144us;145us;145us;146us;146us;147us;147us;147us;147us;147us;148us;148us;149us;150us;150us;151us;151us;152us;152us;152us;153us;153us;153us;154us;155us;155us;156us;157us;157us;158us;158us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;159us;160us;160us;160us;160us;161us;161us;162us;162us;163us;163us;164us;165us;165us;165us;165us;165us;166us;166us;167us;167us;168us;168us;168us;168us;168us;169us;169us;169us;169us;169us;169us;170us;170us;170us;170us;170us;170us;171us;171us;172us;172us;172us;173us;173us;173us;174us;174us;174us;174us;174us;174us;174us;174us;174us;175us;175us;176us;176us;176us;176us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;178us;178us;179us;179us;179us;179us;179us;179us;179us;179us;179us;180us;180us;180us;180us;180us;180us;181us;181us;182us;182us;183us;183us;183us;184us;184us;184us;185us;185us;185us;185us;186us;186us;186us;187us;187us;187us;188us;188us;188us;189us;190us;190us;190us;190us;190us;190us;191us;191us;192us;192us;192us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;194us;194us;194us;194us;194us;194us;195us;195us;196us;196us;196us;196us;197us;197us;197us;197us;198us;199us;199us;199us;199us;199us;199us;200us;200us;201us;202us;203us;203us;203us;203us;204us;204us;204us;204us;204us;205us;205us;205us;205us;205us;205us;205us;205us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;207us;207us;208us;208us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;210us;210us;210us;210us;210us;210us;210us;210us;210us;210us;211us;211us;211us;211us;211us;211us;211us;211us;211us;211us;211us;212us;212us;212us;212us;213us;213us;213us;213us;214us;214us;214us;214us;215us;215us;215us;215us;215us;215us;215us;215us;215us;215us;216us;216us;216us;217us;217us;218us;218us;219us;219us;219us;219us;219us;220us;220us;220us;221us;221us;222us;222us;223us;224us;225us;225us;225us;226us;227us;227us;228us;229us;229us;230us;230us;231us;231us;232us;232us;232us;233us;233us;234us;234us;234us;234us;234us;234us;234us;234us;234us;235us;235us;236us;236us;236us;236us;237us;237us;238us;238us;239us;239us;239us;239us;239us;240us;240us;240us;241us;241us;241us;242us;242us;243us;243us;243us;244us;245us;245us;245us;246us;247us;247us;248us;248us;248us;248us;248us;249us;249us;249us;249us;249us;249us;249us;249us;250us;250us;251us;251us;252us;252us;253us;253us;253us;254us;254us;254us;255us;255us;255us;255us;256us;256us;256us;256us;257us;257us;257us;257us;257us;257us;257us;257us;257us;257us;258us;258us;258us;258us;259us;259us;259us;259us;260us;261us;261us;261us;261us;261us;261us;261us;261us;262us;262us;262us;262us;262us;262us;262us;263us;263us;264us;264us;265us;265us;266us;266us;266us;266us;266us;266us;266us;266us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;267us;268us;269us;269us;269us;270us;270us;271us;271us;272us;272us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;273us;274us;274us;275us;275us;275us;275us;275us;275us;275us;276us;276us;276us;277us;277us;278us;279us;279us;280us;280us;280us;281us;281us;281us;282us;282us;283us;283us;283us;283us;284us;284us;285us;286us;286us;286us;286us;287us;287us;287us;287us;287us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;288us;289us;290us;290us;291us;291us;292us;292us;292us;292us;293us;294us;294us;295us;295us;295us;296us;296us;297us;297us;298us;298us;298us;298us;299us;299us;299us;300us;300us;300us;300us;301us;301us;302us;302us;303us;303us;304us;304us;305us;305us;306us;306us;307us;307us;308us;308us;309us;309us;310us;310us;311us;311us;312us;312us;313us;313us;314us;314us;315us;316us;317us;317us;318us;318us;318us;319us;319us;319us;320us;320us;320us;321us;321us;322us;322us;322us;323us;323us;323us;324us;324us;324us;325us;326us;326us;326us;327us;327us;327us;328us;328us;328us;328us;328us;329us;329us;329us;329us;329us;329us;|]
let _fsyacc_immediateActions = [|65535us;49152us;65535us;49152us;65535us;49152us;65535us;49152us;65535us;49152us;16389us;16390us;16391us;16392us;16393us;16394us;65535us;16395us;65535us;16396us;65535us;16397us;65535us;16398us;65535us;16399us;65535us;16400us;65535us;16402us;65535us;65535us;65535us;16404us;65535us;16406us;16407us;16408us;65535us;65535us;65535us;16411us;16412us;16413us;65535us;16414us;65535us;16415us;65535us;16416us;65535us;65535us;65535us;65535us;65535us;16418us;16419us;65535us;65535us;65535us;16421us;65535us;16423us;65535us;16424us;65535us;65535us;16426us;65535us;65535us;65535us;16427us;16428us;16429us;65535us;65535us;65535us;16430us;16431us;65535us;16432us;16433us;65535us;65535us;65535us;65535us;16436us;65535us;65535us;16437us;16439us;16440us;65535us;65535us;65535us;65535us;16441us;16442us;16443us;65535us;65535us;16444us;16445us;16446us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16447us;65535us;65535us;65535us;65535us;65535us;16450us;65535us;65535us;16451us;65535us;65535us;65535us;16452us;65535us;65535us;16453us;65535us;65535us;16454us;65535us;65535us;16456us;16457us;65535us;65535us;65535us;65535us;65535us;65535us;16458us;65535us;16459us;16460us;16461us;65535us;65535us;16462us;16463us;65535us;65535us;16464us;16465us;65535us;16466us;65535us;65535us;16467us;16468us;65535us;65535us;16469us;16470us;65535us;65535us;16471us;16472us;16473us;16474us;65535us;65535us;16476us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16477us;65535us;65535us;65535us;65535us;16480us;65535us;16481us;65535us;65535us;16482us;65535us;16483us;65535us;65535us;16484us;65535us;16486us;65535us;65535us;16487us;16488us;65535us;65535us;16490us;16491us;65535us;65535us;16492us;16493us;16494us;65535us;16495us;65535us;65535us;16496us;65535us;16498us;65535us;16499us;65535us;16500us;65535us;16502us;65535us;16503us;65535us;65535us;16505us;65535us;65535us;65535us;16506us;16507us;65535us;65535us;65535us;16508us;16509us;65535us;16510us;16511us;16512us;65535us;65535us;65535us;65535us;16514us;16517us;16518us;65535us;16519us;65535us;16520us;65535us;65535us;65535us;65535us;65535us;16523us;16524us;16525us;65535us;65535us;16526us;65535us;16527us;65535us;16528us;65535us;65535us;16529us;16530us;65535us;65535us;16531us;16532us;65535us;16533us;16534us;65535us;65535us;16536us;65535us;65535us;16538us;65535us;16539us;65535us;65535us;65535us;16541us;16542us;65535us;16543us;16544us;16545us;16546us;65535us;65535us;65535us;16548us;16549us;16550us;65535us;65535us;16551us;16552us;65535us;16555us;65535us;65535us;65535us;65535us;16556us;65535us;65535us;16557us;16558us;16559us;16560us;65535us;16561us;65535us;65535us;16562us;65535us;65535us;65535us;16563us;65535us;65535us;65535us;65535us;16564us;65535us;16565us;65535us;16566us;65535us;16567us;65535us;16568us;65535us;16569us;16571us;16572us;16573us;65535us;65535us;16574us;65535us;65535us;16575us;65535us;16578us;65535us;65535us;65535us;65535us;65535us;65535us;16579us;16580us;65535us;65535us;65535us;65535us;65535us;65535us;16581us;16582us;16583us;65535us;16584us;16585us;16586us;65535us;65535us;16587us;16588us;65535us;65535us;16589us;16590us;65535us;16591us;65535us;65535us;16592us;16593us;65535us;65535us;16594us;16595us;16596us;16597us;65535us;16598us;65535us;65535us;16600us;65535us;16601us;65535us;65535us;16602us;16603us;65535us;65535us;16605us;65535us;65535us;65535us;65535us;65535us;16606us;65535us;65535us;65535us;65535us;16607us;16608us;16609us;16610us;65535us;16612us;65535us;16614us;65535us;65535us;65535us;65535us;16615us;16616us;65535us;65535us;16617us;16618us;65535us;65535us;16619us;16620us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16621us;16622us;65535us;16623us;65535us;16624us;65535us;16625us;65535us;65535us;65535us;65535us;65535us;16626us;16627us;16628us;65535us;16629us;65535us;16630us;65535us;65535us;65535us;65535us;65535us;16631us;16632us;16633us;16634us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16635us;16636us;16637us;16638us;65535us;16640us;16641us;65535us;65535us;16642us;65535us;65535us;16643us;16644us;65535us;65535us;65535us;16645us;16646us;16648us;16649us;16650us;16651us;65535us;65535us;16652us;65535us;65535us;16655us;65535us;65535us;16657us;65535us;65535us;16658us;16659us;16660us;65535us;16662us;16663us;16664us;65535us;16666us;16667us;65535us;65535us;16668us;16669us;16670us;65535us;65535us;16671us;65535us;65535us;65535us;65535us;16673us;65535us;16674us;16675us;65535us;65535us;16676us;65535us;16677us;16678us;16679us;65535us;65535us;65535us;65535us;65535us;16680us;16681us;16682us;16683us;65535us;65535us;65535us;65535us;16684us;65535us;65535us;16685us;16686us;65535us;16687us;16688us;65535us;16689us;16690us;65535us;65535us;16691us;16692us;65535us;16693us;16694us;16695us;16696us;16697us;16698us;65535us;65535us;65535us;65535us;16701us;16702us;16703us;65535us;65535us;16704us;65535us;65535us;65535us;65535us;16705us;16706us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16709us;16710us;65535us;65535us;65535us;65535us;16713us;16714us;65535us;65535us;65535us;65535us;65535us;16718us;16719us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16722us;65535us;65535us;65535us;65535us;16724us;65535us;16725us;16726us;65535us;65535us;16727us;65535us;65535us;65535us;65535us;65535us;65535us;16728us;65535us;16729us;16730us;65535us;65535us;65535us;65535us;65535us;16735us;65535us;65535us;16736us;65535us;16738us;65535us;65535us;16739us;65535us;65535us;65535us;16742us;65535us;16743us;16744us;65535us;16745us;16746us;16747us;65535us;16748us;65535us;65535us;16750us;65535us;65535us;16751us;65535us;65535us;16752us;65535us;16753us;65535us;65535us;65535us;16755us;65535us;16756us;16757us;65535us;16758us;65535us;65535us;16760us;65535us;65535us;65535us;65535us;16764us;16765us;16766us;16767us;65535us;65535us;16768us;16769us;65535us;16770us;65535us;65535us;65535us;65535us;16771us;16772us;16773us;16774us;65535us;16775us;65535us;65535us;65535us;65535us;16776us;16777us;65535us;65535us;16779us;16780us;65535us;65535us;65535us;65535us;16783us;16784us;65535us;16785us;65535us;65535us;65535us;16786us;65535us;65535us;16787us;16788us;16789us;16790us;16791us;16792us;16793us;16794us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16795us;65535us;65535us;65535us;16799us;65535us;16800us;65535us;65535us;16802us;65535us;65535us;65535us;65535us;16804us;16805us;16806us;65535us;65535us;16807us;65535us;65535us;16810us;65535us;65535us;16811us;65535us;16813us;16814us;65535us;65535us;65535us;65535us;65535us;16815us;16816us;16817us;65535us;65535us;16818us;16819us;16820us;65535us;65535us;16822us;65535us;65535us;65535us;16824us;65535us;16825us;16826us;65535us;65535us;16827us;16828us;16829us;16830us;16831us;16832us;16833us;16834us;16835us;16836us;16837us;16838us;16839us;16840us;16841us;16842us;16843us;16844us;16845us;16846us;65535us;65535us;16847us;65535us;65535us;65535us;16848us;16851us;65535us;65535us;16852us;16853us;65535us;16854us;65535us;65535us;16856us;65535us;16858us;65535us;16859us;65535us;65535us;65535us;16860us;16861us;65535us;65535us;16864us;16865us;65535us;65535us;16867us;16868us;16869us;65535us;16870us;16871us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16872us;65535us;65535us;65535us;65535us;16877us;65535us;65535us;16880us;16881us;65535us;16883us;65535us;65535us;65535us;16886us;65535us;16887us;65535us;16888us;65535us;65535us;65535us;65535us;16890us;16891us;65535us;65535us;16893us;65535us;16894us;65535us;16895us;16896us;65535us;16897us;65535us;16898us;65535us;16899us;16900us;65535us;65535us;16901us;16902us;65535us;16903us;65535us;16904us;65535us;16905us;16907us;65535us;65535us;16908us;65535us;16909us;65535us;65535us;16910us;65535us;65535us;16911us;65535us;65535us;16913us;16914us;16915us;16916us;16917us;16918us;65535us;65535us;16919us;16920us;65535us;65535us;16922us;65535us;65535us;65535us;16923us;16924us;65535us;16925us;16926us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16929us;65535us;65535us;65535us;65535us;16933us;16934us;65535us;65535us;16937us;65535us;65535us;16940us;16941us;65535us;16943us;65535us;65535us;65535us;16946us;65535us;16947us;65535us;65535us;16949us;16950us;16952us;65535us;16953us;65535us;65535us;16954us;16955us;16956us;16957us;65535us;65535us;16958us;16959us;65535us;65535us;16961us;16963us;65535us;65535us;65535us;16964us;16965us;65535us;16967us;65535us;65535us;16968us;65535us;16971us;65535us;65535us;65535us;16972us;65535us;16974us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16975us;65535us;65535us;65535us;65535us;16976us;65535us;65535us;65535us;65535us;65535us;16977us;65535us;65535us;16979us;16980us;65535us;16981us;16982us;65535us;16983us;16984us;16985us;16986us;16987us;65535us;65535us;16988us;16989us;65535us;65535us;16990us;16991us;65535us;65535us;16992us;16993us;65535us;16995us;65535us;16996us;65535us;65535us;16997us;16998us;16999us;65535us;65535us;65535us;65535us;65535us;17003us;65535us;17004us;65535us;17006us;65535us;17007us;65535us;65535us;65535us;65535us;17008us;17009us;17010us;17011us;17012us;65535us;17013us;65535us;65535us;65535us;17014us;17015us;17016us;17017us;17018us;65535us;65535us;17019us;17020us;17021us;65535us;65535us;65535us;65535us;65535us;17025us;17026us;65535us;65535us;65535us;65535us;65535us;65535us;17027us;65535us;65535us;65535us;65535us;65535us;65535us;17028us;17029us;65535us;65535us;65535us;65535us;17030us;65535us;65535us;17031us;65535us;65535us;65535us;17033us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17034us;17035us;65535us;17036us;17037us;65535us;17038us;17039us;65535us;65535us;65535us;17041us;65535us;65535us;65535us;17044us;65535us;17046us;65535us;17048us;65535us;17050us;65535us;17052us;65535us;17054us;65535us;17056us;65535us;17058us;65535us;17060us;65535us;17062us;65535us;17064us;65535us;17066us;65535us;17068us;65535us;17070us;65535us;17072us;65535us;17074us;65535us;17076us;65535us;17078us;65535us;17080us;65535us;17082us;65535us;65535us;65535us;65535us;17086us;65535us;65535us;65535us;17088us;17089us;65535us;17090us;17091us;17092us;17093us;17094us;65535us;65535us;17095us;65535us;17096us;65535us;65535us;17097us;17098us;17099us;17100us;65535us;17101us;17102us;17103us;17104us;65535us;65535us;65535us;17106us;65535us;17107us;17108us;17109us;17110us;65535us;65535us;17113us;65535us;17114us;65535us;17116us;65535us;17117us;17118us;65535us;65535us;17121us;65535us;17122us;17123us;65535us;17125us;65535us;17127us;65535us;17128us;65535us;17130us;65535us;65535us;65535us;65535us;17132us;65535us;65535us;17133us;65535us;65535us;17134us;65535us;65535us;17135us;65535us;65535us;17136us;65535us;65535us;17137us;65535us;65535us;17138us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17139us;17141us;17142us;65535us;17143us;65535us;17144us;65535us;65535us;65535us;17146us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17151us;17152us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17155us;65535us;65535us;65535us;65535us;17157us;65535us;17158us;65535us;17159us;65535us;65535us;17160us;65535us;65535us;17161us;65535us;17162us;17163us;17164us;65535us;65535us;17165us;17166us;17167us;17168us;65535us;65535us;17169us;17170us;17171us;17172us;17173us;17175us;65535us;65535us;65535us;65535us;17176us;65535us;17177us;65535us;65535us;17178us;17179us;17180us;17181us;17182us;17183us;17184us;17185us;17186us;17187us;17188us;17189us;17190us;17191us;17192us;65535us;65535us;17193us;17194us;65535us;17195us;17196us;65535us;65535us;65535us;17197us;17198us;17199us;17200us;65535us;65535us;17201us;17202us;17203us;17204us;65535us;65535us;65535us;17205us;65535us;17206us;17207us;17208us;65535us;17209us;17210us;17211us;17212us;17213us;65535us;17214us;65535us;65535us;65535us;65535us;65535us;17215us;17216us;17217us;17218us;65535us;65535us;17219us;65535us;65535us;65535us;65535us;17222us;17223us;17224us;17225us;17226us;17227us;17228us;17229us;17230us;17232us;17234us;65535us;17235us;65535us;17237us;17238us;65535us;65535us;17240us;17241us;65535us;65535us;65535us;65535us;65535us;17242us;17243us;17246us;65535us;65535us;65535us;17248us;65535us;17250us;65535us;17251us;65535us;65535us;65535us;65535us;65535us;17252us;17253us;65535us;65535us;65535us;17254us;17255us;65535us;65535us;65535us;17259us;65535us;65535us;65535us;17260us;65535us;65535us;17261us;65535us;65535us;65535us;17262us;17263us;65535us;65535us;65535us;17267us;17268us;65535us;17270us;17271us;65535us;65535us;17273us;17275us;17277us;65535us;65535us;65535us;17278us;65535us;17279us;17281us;17284us;65535us;17286us;65535us;65535us;17287us;65535us;17288us;65535us;17289us;65535us;17291us;65535us;17292us;65535us;65535us;65535us;65535us;17293us;65535us;17294us;17295us;65535us;65535us;17296us;17297us;17298us;17299us;17300us;65535us;65535us;65535us;17301us;17302us;65535us;65535us;65535us;65535us;17303us;17304us;65535us;17305us;65535us;17307us;65535us;17308us;65535us;17309us;65535us;65535us;17310us;65535us;65535us;65535us;65535us;65535us;17316us;17317us;65535us;65535us;17318us;17319us;65535us;65535us;17321us;17322us;65535us;17323us;65535us;65535us;17325us;17326us;65535us;17327us;65535us;65535us;65535us;65535us;17330us;65535us;65535us;65535us;65535us;17332us;65535us;65535us;65535us;17335us;65535us;65535us;65535us;65535us;17337us;65535us;65535us;65535us;17339us;17340us;65535us;17341us;65535us;65535us;17343us;17344us;65535us;17345us;65535us;17347us;65535us;65535us;17348us;17349us;65535us;17350us;65535us;17351us;17352us;65535us;17353us;17354us;65535us;65535us;17356us;17357us;65535us;17358us;65535us;17359us;17360us;65535us;17361us;65535us;65535us;65535us;65535us;65535us;17366us;65535us;65535us;65535us;17367us;65535us;17369us;65535us;17370us;17371us;65535us;65535us;65535us;17372us;17373us;17374us;65535us;17375us;65535us;65535us;17376us;65535us;17377us;65535us;17378us;65535us;17379us;65535us;17380us;65535us;17381us;65535us;17382us;65535us;17383us;65535us;17384us;65535us;17385us;65535us;17386us;65535us;17387us;65535us;17388us;65535us;17389us;65535us;17390us;65535us;17391us;65535us;17392us;65535us;17393us;65535us;17394us;65535us;17395us;65535us;17396us;65535us;17397us;65535us;17398us;65535us;17399us;65535us;17400us;65535us;17401us;65535us;17402us;65535us;17403us;65535us;17404us;65535us;17405us;65535us;17406us;65535us;17407us;65535us;17408us;65535us;65535us;65535us;65535us;65535us;65535us;17410us;17411us;65535us;65535us;17414us;65535us;65535us;65535us;17415us;65535us;65535us;17418us;65535us;65535us;17420us;17421us;65535us;65535us;65535us;17422us;17423us;65535us;65535us;65535us;65535us;17424us;17425us;17426us;17427us;17428us;17429us;17430us;65535us;17432us;17433us;65535us;17434us;17435us;65535us;65535us;17437us;65535us;17438us;17439us;65535us;17440us;65535us;65535us;65535us;65535us;17441us;17442us;17443us;65535us;17444us;17445us;17446us;17447us;65535us;65535us;17449us;17451us;17452us;65535us;65535us;17454us;65535us;17455us;65535us;17457us;65535us;65535us;17458us;65535us;65535us;17460us;17461us;65535us;17463us;17464us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17468us;65535us;17469us;65535us;17470us;17471us;17472us;65535us;17473us;17474us;65535us;65535us;17475us;65535us;17476us;17477us;65535us;65535us;17478us;65535us;65535us;17479us;17480us;17481us;17482us;17483us;17484us;17485us;17486us;17487us;17488us;17489us;17490us;17491us;17492us;17493us;17494us;17495us;17496us;17497us;17498us;17499us;17500us;17501us;17502us;65535us;17504us;65535us;17505us;17506us;65535us;17507us;17508us;17509us;17510us;65535us;17512us;65535us;17513us;17514us;17515us;17516us;17517us;17518us;17519us;17520us;65535us;17522us;65535us;17523us;65535us;65535us;17527us;17528us;17529us;17530us;17531us;17532us;17533us;17534us;17536us;17538us;17542us;17544us;17546us;17550us;17552us;17554us;17555us;17556us;17557us;17558us;17559us;17560us;17561us;17562us;17563us;17564us;17565us;65535us;17567us;17568us;65535us;65535us;17569us;17570us;65535us;65535us;17571us;17572us;17573us;17574us;17575us;17577us;65535us;65535us;17579us;17580us;17581us;65535us;65535us;17582us;17583us;17584us;65535us;17585us;17586us;17587us;17588us;65535us;17589us;17590us;17591us;65535us;17592us;17593us;17594us;17595us;17596us;17597us;17598us;17599us;17600us;17601us;17602us;17603us;17604us;17605us;|]
let _fsyacc_reductions = lazy [|
//# 2858 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParsedSigFile in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startsignatureFile));
//# 2867 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParsedImplFile in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startimplementationFile));
//# 2876 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParsedScriptInteraction in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startinteraction));
//# 2885 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__starttypedSequentialExprEOF));
//# 2894 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__starttypEOF));
//# 2903 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 388 "src/Compiler/pars.fsy"
                            ParsedScriptInteraction.Definitions(_1, lhs parseState) 
                   )
//# 388 "src/Compiler/pars.fsy"
                 : ParsedScriptInteraction));
//# 2914 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 391 "src/Compiler/pars.fsy"
                            warning(Error(FSComp.SR.parsUnexpectedSemicolon(), rhs parseState 1))
                            ParsedScriptInteraction.Definitions([], lhs parseState) 
                   )
//# 391 "src/Compiler/pars.fsy"
                 : ParsedScriptInteraction));
//# 2925 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 395 "src/Compiler/pars.fsy"
                            ParsedScriptInteraction.Definitions([], lhs parseState) 
                   )
//# 395 "src/Compiler/pars.fsy"
                 : ParsedScriptInteraction));
//# 2935 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 399 "src/Compiler/pars.fsy"
                                              
                   )
//# 399 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveTerminator));
//# 2945 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 400 "src/Compiler/pars.fsy"
                               checkEndOfFileError _1 
                   )
//# 400 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveTerminator));
//# 2956 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 414 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 414 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 2967 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveDefns in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 417 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 417 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 2979 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveExpr in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 420 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 420 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 2991 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveHash in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 423 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 423 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3003 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveDefns in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 426 "src/Compiler/pars.fsy"
                            _1 @ _3 
                   )
//# 426 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3016 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveExpr in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 429 "src/Compiler/pars.fsy"
                            _1 @ _3 
                   )
//# 429 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3029 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveHash in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 432 "src/Compiler/pars.fsy"
                            _1 @ _3 
                   )
//# 432 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3042 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 438 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 438 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveDefns));
//# 3053 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefn in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 441 "src/Compiler/pars.fsy"
                             _1 @ _2 
                   )
//# 441 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveDefns));
//# 3065 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 447 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ [ mkSynExprDecl _3 ] 
                   )
//# 447 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveExpr));
//# 3082 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 456 "src/Compiler/pars.fsy"
                             [SynModuleDecl.HashDirective(_1, rhs parseState 1)] 
                   )
//# 456 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveHash));
//# 3093 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveSeparator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 460 "src/Compiler/pars.fsy"
                                                
                   )
//# 460 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparators));
//# 3104 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveSeparator in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 462 "src/Compiler/pars.fsy"
                                                                      
                   )
//# 462 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparators));
//# 3116 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 466 "src/Compiler/pars.fsy"
                                     
                   )
//# 466 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparator));
//# 3126 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 467 "src/Compiler/pars.fsy"
                                     
                   )
//# 467 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparator));
//# 3136 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> string in
            let _3 = parseState.GetInput(3) :?> 'gentype_hashDirectiveArgs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 476 "src/Compiler/pars.fsy"
                            let m = match _3 with [] -> rhs2  parseState 1 2 | _ -> rhs2  parseState 1 3
                            ParsedHashDirective(_2, _3, m) 
                   )
//# 476 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirective));
//# 3149 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 483 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 483 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArgs));
//# 3159 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirectiveArgs in
            let _2 = parseState.GetInput(2) :?> 'gentype_hashDirectiveArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 486 "src/Compiler/pars.fsy"
                            _1 @ [_2] 
                   )
//# 486 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArgs));
//# 3171 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 492 "src/Compiler/pars.fsy"
                             let s, kind = _1
                             ParsedHashDirectiveArgument.String(s, kind, lhs parseState) 
                   )
//# 492 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3183 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_sourceIdentifier in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 495 "src/Compiler/pars.fsy"
                             let c, v = _1
                             ParsedHashDirectiveArgument.SourceIdentifier(c, v, lhs parseState) 
                   )
//# 495 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3195 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpecs in
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 505 "src/Compiler/pars.fsy"
                            checkEndOfFileError _2; _1 
                   )
//# 505 "src/Compiler/pars.fsy"
                 : ParsedSigFile));
//# 3207 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpecs in
            let _3 = parseState.GetInput(3) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 508 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 508 "src/Compiler/pars.fsy"
                 : ParsedSigFile));
//# 3219 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 514 "src/Compiler/pars.fsy"
                            let emptySigFileFrag = ParsedSigFileFragment.AnonModule([], rhs parseState 1)
                            ParsedSigFile([], [emptySigFileFrag]) 
                   )
//# 514 "src/Compiler/pars.fsy"
                 : ParsedSigFile));
//# 3231 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_rec in
            let _5 = parseState.GetInput(5) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 521 "src/Compiler/pars.fsy"
                             if not (isNil _2) then
                                 parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.AttributesToRightOfModuleKeyword (rhs parseState 4)
                             let mModule = rhs parseState 1
                             mModule, _4, _5.LongIdent, _3, _2 
                   )
//# 521 "src/Compiler/pars.fsy"
                 : 'gentype_moduleIntro));
//# 3249 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_rec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 527 "src/Compiler/pars.fsy"
                             if not (isNil _2) then
                                 parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.AttributesToRightOfModuleKeyword (rhs parseState 4)
                             let mModule = rhs parseState 1
                             mModule, _4, [], _3, _2 
                   )
//# 527 "src/Compiler/pars.fsy"
                 : 'gentype_moduleIntro));
//# 3266 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_rec in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 533 "src/Compiler/pars.fsy"
                             if not (isNil _2) then
                                 parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.AttributesToRightOfModuleKeyword (rhs parseState 4)
                             let mModule = rhs parseState 1
                             mModule, _4, [], _3, _2 
                   )
//# 533 "src/Compiler/pars.fsy"
                 : 'gentype_moduleIntro));
//# 3284 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 541 "src/Compiler/pars.fsy"
                             let mNamespace = rhs parseState 1
                             mNamespace, _2, _3.LongIdent, grabXmlDoc(parseState, [], 1) 
                   )
//# 541 "src/Compiler/pars.fsy"
                 : 'gentype_namespaceIntro));
//# 3297 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 545 "src/Compiler/pars.fsy"
                             let mNamespace = rhs parseState 1
                             mNamespace, _2, [], grabXmlDoc(parseState, [], 1) 
                   )
//# 545 "src/Compiler/pars.fsy"
                 : 'gentype_namespaceIntro));
//# 3310 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 552 "src/Compiler/pars.fsy"
                             ParsedSigFile([], [ (_1 (None, false, [], PreXmlDoc.Empty)) ]) 
                   )
//# 552 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecs));
//# 3321 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleSpec in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceSpecList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 555 "src/Compiler/pars.fsy"
                             // If there are namespaces, the first fileModuleImpl may only contain # directives
                             let decls =
                                 match (_1 (None, false, [], PreXmlDoc.Empty)) with
                                 | ParsedSigFileFragment.AnonModule(decls, m) -> decls
                                 | ParsedSigFileFragment.NamespaceFragment(decls = decls) -> decls
                                 | ParsedSigFileFragment.NamedModule(SynModuleOrNamespaceSig(range = m)) ->
                                     raiseParseErrorAt m (FSComp.SR.parsOnlyHashDirectivesAllowed())
                             let decls =
                                 decls |> List.collect (function
                                     | (SynModuleSigDecl.HashDirective(hd, _)) -> [hd]
                                     | d ->
                                          reportParseErrorAt d.Range (FSComp.SR.parsOnlyHashDirectivesAllowed())
                                          [])
                             ParsedSigFile(decls, _2) 
                   )
//# 555 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecs));
//# 3346 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpec in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceSpecList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 573 "src/Compiler/pars.fsy"
                            _1 :: _2 
                   )
//# 573 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecList));
//# 3358 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 576 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 576 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecList));
//# 3369 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namespaceIntro in
            let _2 = parseState.GetInput(2) :?> 'gentype_deprecated_opt_equals in
            let _3 = parseState.GetInput(3) :?> 'gentype_fileModuleSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 580 "src/Compiler/pars.fsy"
                            let mNamespace, isRec, path, xml = _1
                            _3 (Some mNamespace, isRec, path, xml) 
                   )
//# 580 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpec));
//# 3383 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> 'gentype_moduleSpfnsPossiblyEmptyBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 587 "src/Compiler/pars.fsy"
                           if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                           let m2 = rhs parseState 3
                           let mDeclsAndAttrs = (List.map (fun (a: SynAttributeList) -> a.Range) _1) @ (List.map (fun (d: SynModuleSigDecl) -> d.Range) _4)
                           let mModule, isRec, path2, vis, attribs2 = _3
                           let xmlDoc = grabXmlDoc(parseState, _1, 1)
                           let m = (m2, mDeclsAndAttrs) ||> unionRangeWithListBy id |> unionRangeWithXmlDoc xmlDoc
                           (fun (mNamespaceOpt, isRec2, path, _) ->
                             if not (isNil path) then errorR(Error(FSComp.SR.parsNamespaceOrModuleNotBoth(), m2))
                             let lid = path@path2
                             let trivia: SynModuleOrNamespaceSigTrivia = { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Module mModule }
                             ParsedSigFileFragment.NamedModule(SynModuleOrNamespaceSig(lid, (isRec || isRec2), SynModuleOrNamespaceKind.NamedModule, _4, xmlDoc, _1 @ attribs2, vis, m, trivia))) 
                   )
//# 587 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleSpec));
//# 3407 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfnsPossiblyEmptyBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 600 "src/Compiler/pars.fsy"
                           let m = (rhs parseState 1)
                           (fun (mNamespaceOpt, isRec, path, xml) ->
                             match path with
                             | [] -> ParsedSigFileFragment.AnonModule(_1, m)
                             | _ ->
                                 let lastDeclRange = List.tryLast _1 |> Option.map (fun decl -> decl.Range) |> Option.defaultValue (rhs parseState 1)
                                 let m = withStart (lhs parseState).Start lastDeclRange
                                 xml.MarkAsInvalid()
                                 let trivia: SynModuleOrNamespaceSigTrivia =
                                     match mNamespaceOpt with
                                     | None -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.None }
                                     | Some mNamespace -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Namespace mNamespace }
                                 ParsedSigFileFragment.NamespaceFragment(path, isRec, SynModuleOrNamespaceKind.DeclaredNamespace, _1, PreXmlDoc.Empty, [], m, trivia)) 
                   )
//# 600 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleSpec));
//# 3430 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 617 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 617 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3441 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 620 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 620 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3454 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 623 "src/Compiler/pars.fsy"
                              // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                              // reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnClosedBlockInHashLight())
                              _2
                            
                   )
//# 623 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3469 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 629 "src/Compiler/pars.fsy"
                              [] 
                   )
//# 629 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3480 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 634 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 634 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmpty));
//# 3491 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 637 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 637 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmpty));
//# 3501 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 640 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 640 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmpty));
//# 3511 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfn in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleSpfns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 645 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 645 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfns));
//# 3524 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleSpfns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 648 "src/Compiler/pars.fsy"
                            (* silent recovery *) _3 
                   )
//# 648 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfns));
//# 3536 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfn in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_topSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 651 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 651 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfns));
//# 3548 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 656 "src/Compiler/pars.fsy"
                             SynModuleSigDecl.HashDirective(_1, rhs2 parseState 1 1) 
                   )
//# 656 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3559 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_valSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 659 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 659 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3570 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> 'gentype_colonOrEquals in
            let _5 = parseState.GetInput(5) :?> 'gentype_namedModuleAbbrevBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 662 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let mModule, isRec, path, vis, attribs2 = _3
                             if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                             if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleAbbreviationMustBeSimpleName())
                             if not (isNil _1) then raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                             if not (isNil attribs2) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                             match vis with
                             | Some vis -> raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreVisibilityOnModuleAbbreviationAlwaysPrivate(vis.ToString()))
                             | _ ->
                                 let lid: SynLongIdent = _5
                                 let m = unionRanges mModule lid.Range
                                 SynModuleSigDecl.ModuleAbbrev(List.head path, lid.LongIdent, m) 
                   )
//# 662 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3596 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> 'gentype_colonOrEquals in
            let _5 = parseState.GetInput(5) :?> 'gentype_moduleSpecBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 676 "src/Compiler/pars.fsy"
                             let mModule, isRec, path, vis, attribs2 = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleDefnMustBeSimpleName())
                             if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                             let info = SynComponentInfo(_1 @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let decls, mOptEnd = _5
                             let m = (rhs2 parseState 1 4, decls)
                                     ||> unionRangeWithListBy (fun (d: SynModuleSigDecl) -> d.Range)
                                     |> unionRangeWithXmlDoc xmlDoc
                             let m = match mOptEnd with | None -> m | Some mEnd -> unionRanges m mEnd
                             let trivia: SynModuleSigDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = _4 }
                             SynModuleSigDecl.NestedModule(info, isRec, decls, m, trivia) 
                   )
//# 676 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3623 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 691 "src/Compiler/pars.fsy"
                             let mModule, isRec, path, vis, attribs2 = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleDefnMustBeSimpleName())
                             if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                             let info = SynComponentInfo(_1 @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                             let trivia: SynModuleSigDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = None }
                             SynModuleSigDecl.NestedModule(info, isRec, [], mWhole, trivia) 
                   )
//# 691 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3644 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeKeyword in
            let _4 = parseState.GetInput(4) :?> 'gentype_tyconSpfn in
            let _5 = parseState.GetInput(5) :?> SynTypeDefnSig list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 702 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                             let leadingKeyword = SynTypeDefnLeadingKeyword.Type(rhs parseState 3)
                             let (SynTypeDefnSig (SynComponentInfo (cas, a, cs, b, _xmlDoc, d, d2, d3), typeRepr, members, range, trivia)) = _4 leadingKeyword
                             _xmlDoc.MarkAsInvalid()
                             let attrs = _1 @ cas
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let mDefn =
                                 (d3, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 |> unionRanges range
                                 |> unionRangeWithXmlDoc xmlDoc
                             let tc = (SynTypeDefnSig(SynComponentInfo(attrs, a, cs, b, xmlDoc, d, d2, d3), typeRepr, members, mDefn, trivia))
                             let m = (mDefn, _5) ||> unionRangeWithListBy (fun (a: SynTypeDefnSig) -> a.Range) |> unionRanges (rhs parseState 3)
                             SynModuleSigDecl.Types(tc :: _5, m) 
                   )
//# 702 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3671 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_exconSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 717 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let (SynExceptionSig(SynExceptionDefnRepr(cas, a, b, c, d, d2), withKeyword, members, range)) = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let mDefnReprWithAttributes = (d2, _1) ||> unionRangeWithListBy (fun a -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let mWhole = (mDefnReprWithAttributes, members) ||> unionRangeWithListBy (fun (m: SynMemberSig) -> m.Range)
                             let synExnDefn = SynExceptionSig(SynExceptionDefnRepr(_1@cas, a, b, xmlDoc, d, mDefnReprWithAttributes), withKeyword, members, mWhole)
                             SynModuleSigDecl.Exception(synExnDefn, mWhole) 
                   )
//# 717 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3690 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_openDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 726 "src/Compiler/pars.fsy"
                             SynModuleSigDecl.Open _1 
                   )
//# 726 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3701 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_attributes in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_inline in
            let _6 = parseState.GetInput(6) :?> 'gentype_opt_mutable in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_access in
            let _8 = parseState.GetInput(8) :?> 'gentype_nameop in
            let _9 = parseState.GetInput(9) :?> 'gentype_opt_explicitValTyparDecls in
            let _11 = parseState.GetInput(11) :?> 'gentype_topTypeWithTypeConstraints in
            let _12 = parseState.GetInput(12) :?> 'gentype_optLiteralValueSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 730 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let attr1, attr2, isInline, isMutable, vis2, id, doc, explicitValTyparDecls, (ty, arity), (mEquals, konst: SynExpr option) = (_1), (_4), (Option.isSome _5), (Option.isSome _6), (_7), (_8), grabXmlDoc(parseState, _1, 1), (_9), (_11), (_12)
                             if not (isNil attr2) then errorR(Deprecated(FSComp.SR.parsAttributesMustComeBeforeVal(), rhs parseState 4))
                             let m =
                                 rhs2 parseState 1 11
                                 |> unionRangeWithXmlDoc doc
                                 |> fun m ->
                                     match konst with
                                     | None -> m
                                     | Some e -> unionRanges m e.Range
                             let mVal = rhs parseState 3
                             let trivia: SynValSigTrivia = { LeadingKeyword = SynLeadingKeyword.Val mVal; InlineKeyword = _5; WithKeyword = None; EqualsRange = mEquals }
                             let valSpfn = SynValSig((attr1@attr2), id, explicitValTyparDecls, ty, arity, isInline, isMutable, doc, vis2, konst, m, trivia)
                             SynModuleSigDecl.Val(valSpfn, m)
                           
                   )
//# 730 "src/Compiler/pars.fsy"
                 : 'gentype_valSpfn));
//# 3735 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 749 "src/Compiler/pars.fsy"
                             None, None 
                   )
//# 749 "src/Compiler/pars.fsy"
                 : 'gentype_optLiteralValueSpfn));
//# 3745 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 752 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 1
                             Some(mEquals), Some(_2) 
                   )
//# 752 "src/Compiler/pars.fsy"
                 : 'gentype_optLiteralValueSpfn));
//# 3757 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> SynExpr in
            let _4 = parseState.GetInput(4) :?> 'gentype_oblockend in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 756 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 1
                             Some(mEquals), Some(_3) 
                   )
//# 756 "src/Compiler/pars.fsy"
                 : 'gentype_optLiteralValueSpfn));
//# 3771 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfns in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 765 "src/Compiler/pars.fsy"
                             _2, None 
                   )
//# 765 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpecBlock));
//# 3783 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_sigOrBegin in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            let _5 = parseState.GetInput(5) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 769 "src/Compiler/pars.fsy"
                             let mEnd = rhs parseState 4
                             _3, Some mEnd 
                   )
//# 769 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpecBlock));
//# 3797 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_sigOrBegin in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 774 "src/Compiler/pars.fsy"
                             let mEnd = rhs parseState 3
                             _2, Some mEnd 
                   )
//# 774 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpecBlock));
//# 3810 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconSpfn in
            let _3 = parseState.GetInput(3) :?> SynTypeDefnSig list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 780 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            let tyconSpfn =
                                let leadingKeyword = SynTypeDefnLeadingKeyword.And(rhs parseState 1)
                                let (SynTypeDefnSig(componentInfo, typeRepr, members, range, trivia) as typeDefnSig) = _2 leadingKeyword
                                let (SynComponentInfo(a, typars, c, lid, _xmlDoc, fixity, vis, mLongId)) = componentInfo
                                if xmlDoc.IsEmpty then
                                    if _xmlDoc.IsEmpty then typeDefnSig else
                                    let range = unionRangeWithXmlDoc _xmlDoc range
                                    SynTypeDefnSig(componentInfo, typeRepr, members, range, trivia)
                                else
                                    _xmlDoc.MarkAsInvalid()
                                    let range = unionRangeWithXmlDoc xmlDoc range
                                    let componentInfo = SynComponentInfo (a, typars, c, lid, xmlDoc, fixity, vis, mLongId)
                                    SynTypeDefnSig(componentInfo, typeRepr, members, range, trivia)
                            tyconSpfn :: _3 
                   )
//# 780 "src/Compiler/pars.fsy"
                 : SynTypeDefnSig list));
//# 3836 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 798 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 798 "src/Compiler/pars.fsy"
                 : SynTypeDefnSig list));
//# 3846 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _3 = parseState.GetInput(3) :?> 'gentype_tyconSpfnRhsBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 804 "src/Compiler/pars.fsy"
                             let mLhs = rhs parseState 1
                             let mEquals = rhs parseState 2
                             fun leadingKeyword -> _3 leadingKeyword mLhs _1 (Some mEquals) 
                   )
//# 804 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfn));
//# 3860 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 808 "src/Compiler/pars.fsy"
                             let mWithKwd, members = _2
                             let (SynComponentInfo(range = range)) = _1
                             let m =
                                 match members with
                                 | [] ->
                                     match mWithKwd with
                                     | None -> range
                                     | Some mWithKwd -> unionRanges range mWithKwd
                                 | decls ->
                                     (range, decls) ||> unionRangeWithListBy (fun (s: SynMemberSig) -> s.Range)
                             fun leadingKeyword ->
                                 let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = None; WithKeyword = mWithKwd }
                                 SynTypeDefnSig(_1, SynTypeDefnSigRepr.Simple(SynTypeDefnSimpleRepr.None m, m), members, m, trivia) 
                   )
//# 808 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfn));
//# 3884 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconSpfnRhs in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_OBLOCKSEP in
            let _4 = parseState.GetInput(4) :?> 'gentype_classSpfnMembers in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_classSpfn in
            let _6 = parseState.GetInput(6) :?> 'gentype_oblockend in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 834 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            (fun leadingKeyword mLhs nameInfo mEquals ->
                                let members = _4 @ (snd _5)
                                _2 leadingKeyword mLhs nameInfo mEquals (checkForMultipleAugmentations m members (snd _7))) 
                   )
//# 834 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhsBlock));
//# 3903 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconSpfnRhs in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 840 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            (fun leadingKeyword mLhs nameInfo mEquals ->
                                let _, members = _2
                                _1 leadingKeyword mLhs nameInfo mEquals members) 
                   )
//# 840 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhsBlock));
//# 3918 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypeDefnSimpleRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 849 "src/Compiler/pars.fsy"
                            (fun leadingKeyword mLhs nameInfo mEquals augmentation ->
                                let declRange = unionRanges mLhs _1.Range
                                let mWhole = (declRange, augmentation) ||> unionRangeWithListBy (fun (mem: SynMemberSig) -> mem.Range)
                                let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; WithKeyword = None; EqualsRange = mEquals }
                                SynTypeDefnSig(nameInfo, SynTypeDefnSigRepr.Simple(_1, _1.Range), augmentation, mWhole, trivia)) 
                   )
//# 849 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhs));
//# 3933 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconClassSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 856 "src/Compiler/pars.fsy"
                            let needsCheck, (kind, decls) = _1
                            let objectModelRange =
                                match decls with
                                | [] -> lhs parseState
                                | decls ->
                                    let start = mkSynRange parseState.ResultStartPosition parseState.ResultStartPosition
                                    (start, decls) ||> unionRangeWithListBy (fun (s: SynMemberSig) -> s.Range)
                            (fun leadingKeyword nameRange nameInfo mEquals augmentation ->
                                if needsCheck && isNil decls then
                                   reportParseErrorAt nameRange (FSComp.SR.parsEmptyTypeDefinition())
                                let declRange = unionRanges nameRange objectModelRange
                                let mWhole = (declRange, augmentation) ||> unionRangeWithListBy (fun (mem: SynMemberSig) -> mem.Range)
                                let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; WithKeyword = None; EqualsRange = mEquals }
                                SynTypeDefnSig(nameInfo, SynTypeDefnSigRepr.ObjectModel(kind, decls, objectModelRange), augmentation, mWhole, trivia)) 
                   )
//# 856 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhs));
//# 3957 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 874 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            let ty, arity = _3
                            let flags = AbstractMemberFlags true SynMemberKind.Member
                            let valSig = SynValSig([], (SynIdent(mkSynId m "Invoke", None)), inferredTyparDecls, ty, arity, false, false, PreXmlDoc.Empty, None, None, m, SynValSigTrivia.Zero)
                            let invoke = SynMemberSig.Member(valSig, flags, m, SynMemberSigMemberTrivia.Zero)
                            (fun leadingKeyword nameRange nameInfo mEquals augmentation ->
                                if not (isNil augmentation) then raiseParseErrorAt m (FSComp.SR.parsAugmentationsIllegalOnDelegateType())
                                let mWhole = unionRanges nameRange m
                                let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; WithKeyword = None; EqualsRange = mEquals }
                                SynTypeDefnSig(nameInfo, SynTypeDefnSigRepr.ObjectModel(SynTypeDefnKind.Delegate(ty, arity), [invoke], m), [], mWhole, trivia)) 
                   )
//# 874 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhs));
//# 3977 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classSpfnBlockKindUnspecified in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 889 "src/Compiler/pars.fsy"
                            let needsCheck, decls = _1
                            needsCheck, (SynTypeDefnKind.Unspecified, decls) 
                   )
//# 889 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 3989 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 893 "src/Compiler/pars.fsy"
                            false, (_1, _2) 
                   )
//# 893 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4001 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 896 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedClassInterfaceOrStruct())
                            false, (_1, _2) 
                   )
//# 896 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4015 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 900 "src/Compiler/pars.fsy"
                            // silent recovery
                            false, (_1, []) 
                   )
//# 900 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4027 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 907 "src/Compiler/pars.fsy"
                            true, _2 
                   )
//# 907 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4039 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 910 "src/Compiler/pars.fsy"
                            if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeSignature())
                            false, _2 
                   )
//# 910 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4052 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 915 "src/Compiler/pars.fsy"
                            false, _2 
                   )
//# 915 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4063 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 918 "src/Compiler/pars.fsy"
                            false, _2 
                   )
//# 918 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4075 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 924 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 924 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlock));
//# 4087 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 927 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeSignature())
                             _2 
                   )
//# 927 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlock));
//# 4100 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classSpfnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 930 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 930 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlock));
//# 4111 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classSpfnMembersAtLeastOne in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 935 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 935 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnMembers));
//# 4122 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 938 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 938 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnMembers));
//# 4132 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classMemberSpfn in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_classSpfnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 944 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 944 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnMembersAtLeastOne));
//# 4145 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberSpecFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_inline in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_access in
            let _6 = parseState.GetInput(6) :?> 'gentype_nameop in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_explicitValTyparDecls in
            let _9 = parseState.GetInput(9) :?> 'gentype_topTypeWithTypeConstraints in
            let _10 = parseState.GetInput(10) :?> 'gentype_classMemberSpfnGetSet in
            let _11 = parseState.GetInput(11) :?> 'gentype_optLiteralValueSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 950 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let isInline, doc, vis2, id, explicitValTyparDecls, (ty, arity), (mEquals, optLiteralValue) = (Option.isSome _4), grabXmlDoc(parseState, _1, 1), _5, _6, _7, _9, _11
                            let mWith, (getSet, getSetRangeOpt) = _10
                            let getSetAdjuster arity = match arity, getSet with SynValInfo([], _), SynMemberKind.Member -> SynMemberKind.PropertyGet | _ -> getSet
                            let mWhole =
                                let m = rhs parseState 3
                                match getSetRangeOpt with
                                | None -> unionRanges m ty.Range
                                | Some gs -> unionRanges m (gs: GetSetKeywords).Range
                                |> fun m -> (m, _1) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                |> unionRangeWithXmlDoc doc
                                |> fun m ->
                                    match optLiteralValue with
                                    | None -> m
                                    | Some e -> unionRanges m e.Range
                            let flags, leadingKeyword = _3
                            let flags = flags (getSetAdjuster arity)
                            let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _4; WithKeyword = mWith; EqualsRange = mEquals }
                            let valSpfn = SynValSig(_1, id, explicitValTyparDecls, ty, arity, isInline, false, doc, vis2, optLiteralValue, mWhole, trivia)
                            let trivia: SynMemberSigMemberTrivia = { GetSetKeywords = getSetRangeOpt }
                            SynMemberSig.Member(valSpfn, flags, mWhole, trivia) 
                   )
//# 950 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4185 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_interfaceMember in
            let _4 = parseState.GetInput(4) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 974 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            SynMemberSig.Interface(_4, unionRanges (rhs parseState 3) (_4).Range) 
                   )
//# 974 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4200 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 978 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR (Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            SynMemberSig.Inherit(_4, unionRanges (rhs parseState 1) _4.Range) 
                   )
//# 978 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4214 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 982 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR (Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let mInherit = rhs parseState 3
                            let ty = SynType.FromParseError(mInherit.EndRange)
                            SynMemberSig.Inherit(ty, unionRanges (rhs parseState 1) mInherit) 
                   )
//# 982 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4230 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_fieldDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 988 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then
                                errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let mStart = rhs parseState 1
                            let mVal = rhs parseState 3
                            let leadingKeyword = Some(SynLeadingKeyword.Val mVal)
                            let (SynField(xmlDoc = xmlDoc; range = range)) as field = _4 _1 None mStart leadingKeyword
                            SynMemberSig.ValField(field, range) 
                   )
//# 988 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4249 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_fieldDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 997 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then
                                errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let mStart = rhs parseState 1
                            let mStatic = rhs parseState 3
                            let mVal = rhs parseState 4
                            let leadingKeyword = Some(SynLeadingKeyword.StaticVal(mStatic, mVal))
                            let (SynField(xmlDoc = xmlDoc; range = range)) as field = _5 _1 (Some mStatic) mStart leadingKeyword
                            SynMemberSig.ValField(field, range) 
                   )
//# 997 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4269 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_typeKeyword in
            let _5 = parseState.GetInput(5) :?> 'gentype_tyconSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1007 "src/Compiler/pars.fsy"
                            let leadingKeyword = SynTypeDefnLeadingKeyword.StaticType(rhs parseState 3, rhs parseState 4)
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            SynMemberSig.NestedType(_5 leadingKeyword, rhs2 parseState 1 5) 
                   )
//# 1007 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4285 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_topTypeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1012 "src/Compiler/pars.fsy"
                            let vis, doc, (ty, valSynInfo) = _2, grabXmlDoc(parseState, _1, 1), _5
                            let mNew = rhs parseState 3
                            let m = unionRanges (rhs parseState 1) ty.Range |> unionRangeWithXmlDoc doc
                            let isInline = false
                            let trivia: SynValSigTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; WithKeyword = None; EqualsRange = None }
                            let valSpfn = SynValSig (_1, (SynIdent(mkSynId (rhs parseState 3) "new", None)), noInferredTypars, ty, valSynInfo, isInline, false, doc, vis, None, m, trivia)
                            SynMemberSig.Member(valSpfn, CtorMemberFlags, m, SynMemberSigMemberTrivia.Zero) 
                   )
//# 1012 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4304 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1024 "src/Compiler/pars.fsy"
                           None, (SynMemberKind.Member, None) 
                   )
//# 1024 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4314 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classMemberSpfnGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1027 "src/Compiler/pars.fsy"
                           let mWith = rhs parseState 1
                           Some mWith, _2 
                   )
//# 1027 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4326 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classMemberSpfnGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1031 "src/Compiler/pars.fsy"
                           let mWith = rhs parseState 1
                           Some mWith, _2 
                   )
//# 1031 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4338 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classMemberSpfnGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1035 "src/Compiler/pars.fsy"
                           let mWith = rhs parseState 1
                           reportParseErrorAt mWith (FSComp.SR.parsUnmatchedWith())
                           Some mWith, _2 
                   )
//# 1035 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4351 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_nameop in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1043 "src/Compiler/pars.fsy"
                           (let (SynIdent(id:Ident, _)) = _1
                            if id.idText = "get" then
                                SynMemberKind.PropertyGet, Some(GetSetKeywords.Get id.idRange)
                            else if id.idText = "set" then
                                SynMemberKind.PropertySet, Some(GetSetKeywords.Set id.idRange)
                            else
                                raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsGetOrSetRequired())) 
                   )
//# 1043 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4368 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_nameop in
            let _3 = parseState.GetInput(3) :?> 'gentype_nameop in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1052 "src/Compiler/pars.fsy"
                           let (SynIdent(id, _)) = _1
                           let (SynIdent(id2, _)) = _3
                           if not ((id.idText = "get" && id2.idText = "set") ||
                                   (id.idText = "set" && id2.idText = "get")) then
                              raiseParseErrorAt (rhs2 parseState 1 3) (FSComp.SR.parsGetOrSetRequired())
                           if id.idText = "get" then
                               SynMemberKind.PropertyGetSet, Some(GetSetKeywords.GetSet(id.idRange, id2.idRange))
                           else
                               SynMemberKind.PropertyGetSet, Some(GetSetKeywords.GetSet(id2.idRange, id.idRange)) 
                   )
//# 1052 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4388 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_nameop in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1064 "src/Compiler/pars.fsy"
                           (let (SynIdent(id:Ident, _)) = _1
                            if id.idText = "get" then
                                SynMemberKind.PropertyGet, Some(GetSetKeywords.Get id.idRange)
                            else if id.idText = "set" then
                                SynMemberKind.PropertySet, Some(GetSetKeywords.Set id.idRange)
                            else
                                raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsGetOrSetRequired())) 
                   )
//# 1064 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4406 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_oblockend in
            let _3 = parseState.GetInput(3) :?> range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1073 "src/Compiler/pars.fsy"
                           reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsIdentifierExpected())
                           SynMemberKind.Member, None 
                   )
//# 1073 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4419 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_memberFlags in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1077 "src/Compiler/pars.fsy"
                                       _1 
                   )
//# 1077 "src/Compiler/pars.fsy"
                 : 'gentype_memberSpecFlags));
//# 4430 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_abstractMemberFlags in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1078 "src/Compiler/pars.fsy"
                                               _1 
                   )
//# 1078 "src/Compiler/pars.fsy"
                 : 'gentype_memberSpecFlags));
//# 4441 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynExceptionDefnRepr in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1084 "src/Compiler/pars.fsy"
                            let mWithKwd, members = _2
                            SynExceptionSig(_1, mWithKwd, members, lhs parseState) 
                   )
//# 1084 "src/Compiler/pars.fsy"
                 : 'gentype_exconSpfn));
//# 4454 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1091 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            (Some mWithKwd), _2 
                   )
//# 1091 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classSpfn));
//# 4467 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1095 "src/Compiler/pars.fsy"
                            None, [] 
                   )
//# 1095 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classSpfn));
//# 4477 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpls in
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1104 "src/Compiler/pars.fsy"
                            checkEndOfFileError _2; _1 
                   )
//# 1104 "src/Compiler/pars.fsy"
                 : ParsedImplFile));
//# 4489 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpls in
            let _3 = parseState.GetInput(3) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1107 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1107 "src/Compiler/pars.fsy"
                 : ParsedImplFile));
//# 4501 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1113 "src/Compiler/pars.fsy"
                            let emptyImplFileFrag = ParsedImplFileFragment.AnonModule([], rhs parseState 1)
                            ParsedImplFile ([], [emptyImplFileFrag]) 
                   )
//# 1113 "src/Compiler/pars.fsy"
                 : ParsedImplFile));
//# 4513 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleImpl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1120 "src/Compiler/pars.fsy"
                             ParsedImplFile ([], [ (_1 (None, false, [], PreXmlDoc.Empty)) ]) 
                   )
//# 1120 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImpls));
//# 4524 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleImpl in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceImplList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1123 "src/Compiler/pars.fsy"
                             // If there are namespaces, the first fileModuleImpl may only contain # directives
                             let decls =
                                 match (_1 (None, false, [], PreXmlDoc.Empty)) with
                                 | ParsedImplFileFragment.AnonModule(decls, m) -> decls
                                 | ParsedImplFileFragment.NamespaceFragment(decls = decls) -> decls
                                 | ParsedImplFileFragment.NamedModule(SynModuleOrNamespace(range = m)) ->
                                     raiseParseErrorAt m (FSComp.SR.parsOnlyHashDirectivesAllowed())
                             let decls =
                                 decls |> List.collect (function
                                     | (SynModuleDecl.HashDirective(hd, _)) -> [hd]
                                     | d ->
                                          reportParseErrorAt d.Range (FSComp.SR.parsOnlyHashDirectivesAllowed())
                                          [])
                             ParsedImplFile (decls, _2) 
                   )
//# 1123 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImpls));
//# 4549 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpl in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceImplList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1142 "src/Compiler/pars.fsy"
                            _1 :: _2 
                   )
//# 1142 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImplList));
//# 4561 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1145 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 1145 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImplList));
//# 4572 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namespaceIntro in
            let _2 = parseState.GetInput(2) :?> 'gentype_deprecated_opt_equals in
            let _3 = parseState.GetInput(3) :?> 'gentype_fileModuleImpl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1151 "src/Compiler/pars.fsy"
                            let mNamespace, isRec, path, xml = _1
                            _3 (Some mNamespace, isRec, path, xml) 
                   )
//# 1151 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImpl));
//# 4586 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> SynModuleDecl list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1158 "src/Compiler/pars.fsy"
                           if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                           let m2 = rhs parseState 3
                           let mDeclsAndAttrs = (List.map (fun (a: SynAttributeList) -> a.Range) _1) @ (List.map (fun (d: SynModuleDecl) -> d.Range) _4)
                           let xmlDoc = grabXmlDoc(parseState, _1, 1)
                           let m = (m2, mDeclsAndAttrs) ||> unionRangeWithListBy id |> unionRangeWithXmlDoc xmlDoc
                           let mModule, isRec2, path2, vis, attribs2 = _3
                           (fun (mNamespaceOpt, isRec, path, _) ->
                             if not (isNil path) then errorR(Error(FSComp.SR.parsNamespaceOrModuleNotBoth(), m2))
                             let lid = path@path2
                             let trivia: SynModuleOrNamespaceTrivia = { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Module mModule }
                             ParsedImplFileFragment.NamedModule(SynModuleOrNamespace(lid, (isRec || isRec2), SynModuleOrNamespaceKind.NamedModule, _4, xmlDoc, _1@attribs2, vis, m, trivia))) 
                   )
//# 1158 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleImpl));
//# 4610 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynModuleDecl list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1171 "src/Compiler/pars.fsy"
                           let m = (rhs parseState 1)
                           (fun (mNamespaceOpt, isRec, path, xml) ->
                             match path, mNamespaceOpt with
                             | [], None -> ParsedImplFileFragment.AnonModule(_1, m)
                             | _ ->
                                 let lastDeclRange = List.tryLast _1 |> Option.map (fun decl -> decl.Range) |> Option.defaultValue (rhs parseState 1)
                                 let m = withStart (lhs parseState).Start lastDeclRange
                                 xml.MarkAsInvalid()
                                 let trivia: SynModuleOrNamespaceTrivia =
                                     match mNamespaceOpt with
                                      | None -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.None }
                                      | Some mNamespace -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Namespace mNamespace }
                                 ParsedImplFileFragment.NamespaceFragment(path, isRec, SynModuleOrNamespaceKind.DeclaredNamespace, _1, PreXmlDoc.Empty, [], m, trivia)) 
                   )
//# 1171 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleImpl));
//# 4633 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1189 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 1189 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4646 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1192 "src/Compiler/pars.fsy"
                            // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                            // reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnClosedBlockInHashLight())
                            _2 
                   )
//# 1192 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4660 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1197 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1197 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4671 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1200 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1200 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4682 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1206 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1206 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExprPossiblyEmpty));
//# 4693 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1209 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1209 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExprPossiblyEmpty));
//# 4703 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            let _4 = parseState.GetInput(4) :?> 'gentype_topSeparators in
            let _5 = parseState.GetInput(5) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1216 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ mkSynExprDecl _3 :: _5 
                   )
//# 1216 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4722 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            let _4 = parseState.GetInput(4) :?> 'gentype_topSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1223 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ [ mkSynExprDecl _3 ] 
                   )
//# 1223 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4740 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1230 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ [ mkSynExprDecl _3 ] 
                   )
//# 1230 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4757 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1237 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1237 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4768 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1240 "src/Compiler/pars.fsy"
                            if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else [] 
                   )
//# 1240 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4779 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1246 "src/Compiler/pars.fsy"
                             _1 @ _2 
                   )
//# 1246 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4791 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1249 "src/Compiler/pars.fsy"
                             _1 @ _3 
                   )
//# 1249 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4804 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1252 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1252 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4815 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1255 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1255 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4827 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1258 "src/Compiler/pars.fsy"
                             _3 
                   )
//# 1258 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4839 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1264 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1264 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnOrDirective));
//# 4850 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1267 "src/Compiler/pars.fsy"
                             [ SynModuleDecl.HashDirective(_1, rhs2 parseState 1 1) ] 
                   )
//# 1267 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnOrDirective));
//# 4861 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_defnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1276 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             parseState.ResetSynArgNameGenerator()
                             let (BindingSetPreAttrs(_, _, _, _, mWhole)) = _3
                             mkDefnBindings (mWhole, _3, _1, _2, mWhole) 
                   )
//# 1276 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4877 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_hardwhiteLetBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1283 "src/Compiler/pars.fsy"
                             let hwlb, m, _ = _3
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             parseState.ResetSynArgNameGenerator()
                             mkDefnBindings (m, hwlb, _1, _2, m) 
                   )
//# 1283 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4893 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_doBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1290 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let mWhole = rhs parseState 3
                             mkDefnBindings (mWhole, _3, _1, _2, mWhole) 
                   )
//# 1290 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4908 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeKeyword in
            let _4 = parseState.GetInput(4) :?> 'gentype_tyconDefn in
            let _5 = parseState.GetInput(5) :?> 'gentype_tyconDefnList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1296 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let leadingKeyword = SynTypeDefnLeadingKeyword.Type(rhs parseState 3)
                             let (SynTypeDefn(SynComponentInfo(cas, a, cs, b, _xmlDoc, d, d2, d3), e, f, g, h, trivia)) = _4 leadingKeyword
                             _xmlDoc.MarkAsInvalid()
                             let attrs = _1@cas
                             let mDefn = (h, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let tc = SynTypeDefn(SynComponentInfo(attrs, a, cs, b, xmlDoc, d, d2, d3), e, f, g, mDefn, trivia)
                             let types = tc :: _5
                             [ SynModuleDecl.Types(types, (rhs parseState 3, types) ||> unionRangeWithListBy (fun t -> t.Range)) ] 
                   )
//# 1296 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4932 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExceptionDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1309 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let (SynExceptionDefn(SynExceptionDefnRepr(cas, a, b, c, d, d2), withKeyword, e, f)) = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let defnReprRange = (d2, _1) ||> unionRangeWithListBy (fun a -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let mWhole = (f, _1) ||> unionRangeWithListBy (fun a -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let synExnDefn = SynExceptionDefn(SynExceptionDefnRepr(_1@cas, a, b, xmlDoc, d, defnReprRange), withKeyword, e, mWhole)
                             [ SynModuleDecl.Exception(synExnDefn, mWhole) ] 
                   )
//# 1309 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4951 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _5 = parseState.GetInput(5) :?> 'gentype_namedModuleDefnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1319 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let attribs, (mModule, isRec, path, vis, attribs2) = _1, _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             match _5 with
                             | Choice1Of2 eqn ->
                                 if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                                 if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                                 if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleAbbreviationMustBeSimpleName())
                                 if not (isNil attribs) then raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                                 if not (isNil attribs2) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                                 match vis with
                                 | Some vis -> raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviationAlwaysPrivate(vis.ToString()))
                                 | None -> ()
                                 [ SynModuleDecl.ModuleAbbrev(List.head path, eqn, (rhs parseState 3, eqn) ||> unionRangeWithListBy (fun id -> id.idRange)) ]
                             | Choice2Of2 (def, mEndOpt) ->
                                 if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleAbbreviationMustBeSimpleName())
                                 let info = SynComponentInfo(attribs @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                                 let mEquals = rhs parseState 4
                                 let trivia: SynModuleDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = Some mEquals }
                                 let m =
                                     (rhs2 parseState 1 4, def)
                                     ||> unionRangeWithListBy (fun (d: SynModuleDecl) -> d.Range)
                                     |> unionRangeWithXmlDoc xmlDoc
                                 let m = match mEndOpt with | None -> m | Some mEnd -> unionRanges m mEnd
                                 [ SynModuleDecl.NestedModule(info, isRec, def, false, m, trivia) ] 
                   )
//# 1319 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4989 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1347 "src/Compiler/pars.fsy"
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                             let attribs, (mModule, isRec, path, vis, attribs2) = _1, _3
                             let info = SynComponentInfo(attribs @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                             let trivia: SynModuleDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = None }
                             [ SynModuleDecl.NestedModule(info, isRec, [], false, mWhole, trivia) ] 
                   )
//# 1347 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5007 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1356 "src/Compiler/pars.fsy"
                             errorR(Error(FSComp.SR.parsAttributeOnIncompleteCode(), rhs parseState 1))
                             [ SynModuleDecl.Attributes(_1, rhs parseState 1) ] 
                   )
//# 1356 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5020 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_openDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1361 "src/Compiler/pars.fsy"
                             [ SynModuleDecl.Open _1 ] 
                   )
//# 1361 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5031 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1365 "src/Compiler/pars.fsy"
                             let mOpen = rhs parseState 1
                             let mPath = _2.Range
                             SynOpenDeclTarget.ModuleOrNamespace(_2, mPath), unionRanges mOpen mPath 
                   )
//# 1365 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5044 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1370 "src/Compiler/pars.fsy"
                             let mOpen = rhs parseState 1
                             SynOpenDeclTarget.ModuleOrNamespace(SynLongIdent([], [], []), mOpen.EndRange), mOpen 
                   )
//# 1370 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5056 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeKeyword in
            let _3 = parseState.GetInput(3) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1374 "src/Compiler/pars.fsy"
                             let mOpen = rhs parseState 1
                             let mPath = _3.Range
                             SynOpenDeclTarget.Type(_3, mPath), unionRanges mOpen mPath 
                   )
//# 1374 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5070 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeKeyword in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1379 "src/Compiler/pars.fsy"
                             let m = rhs2 parseState 1 2
                             SynOpenDeclTarget.ModuleOrNamespace(SynLongIdent([], [], []), m.EndRange), m 
                   )
//# 1379 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5083 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1387 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 1387 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleAbbrevBlock));
//# 5095 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1390 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1390 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleAbbrevBlock));
//# 5106 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_wrappedNamedModuleDefn in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1396 "src/Compiler/pars.fsy"
                            Choice2Of2 _2 
                   )
//# 1396 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5118 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_wrappedNamedModuleDefn in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1399 "src/Compiler/pars.fsy"
                            // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                            Choice2Of2 _2 
                   )
//# 1399 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5131 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExpr in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1403 "src/Compiler/pars.fsy"
                              // There is an ambiguity here
                              // In particular, consider the following two:
                              //
                              // module M2 =
                              //    System.DateTime.Now
                              // module M2 =
                              //    Microsoft.FSharp.Core.List
                              // The second is a module abbreviation, the first a module containing a single expression.
                              // The resolution is in favour of the module abbreviation, i.e. anything of the form
                              //    module M2 = ID.ID.ID.ID
                              // will be taken as a module abbreviation, regardles of the identifiers themselves.
                              //
                              // This is similar to the ambiguitty between
                              //    type X = int
                              // and
                              //    type X = OneValue
                              // However in that case we do use type name lookup to make the resolution.
                              match _2 with
                              | [ SynModuleDecl.Expr(LongOrSingleIdent(false, SynLongIdent(path, _, _), None, _), _) ] ->
                                  Choice1Of2  path
                              | _ ->
                                  Choice2Of2 (_2, None)
                            
                   )
//# 1403 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5165 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExpr in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1429 "src/Compiler/pars.fsy"
                            // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                            // reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnClosedBlockInHashLight())
                            Choice2Of2 (_2, None) 
                   )
//# 1429 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5179 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1434 "src/Compiler/pars.fsy"
                            let mEnd = rhs parseState 3
                            Choice2Of2 ([], Some mEnd) 
                   )
//# 1434 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5191 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_wrappedNamedModuleDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1438 "src/Compiler/pars.fsy"
                            Choice2Of2 _1 
                   )
//# 1438 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5202 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1441 "src/Compiler/pars.fsy"
                            Choice1Of2 _1.LongIdent 
                   )
//# 1441 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5213 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_structOrBegin in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1447 "src/Compiler/pars.fsy"
                            let mEnd = rhs parseState 3
                            _2, Some mEnd 
                   )
//# 1447 "src/Compiler/pars.fsy"
                 : 'gentype_wrappedNamedModuleDefn));
//# 5226 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_structOrBegin in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1451 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedBeginOrStruct())
                            _2, None 
                   )
//# 1451 "src/Compiler/pars.fsy"
                 : 'gentype_wrappedNamedModuleDefn));
//# 5240 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_structOrBegin in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1455 "src/Compiler/pars.fsy"
                            let mEnd = rhs parseState 3
                            [], Some mEnd 
                   )
//# 1455 "src/Compiler/pars.fsy"
                 : 'gentype_wrappedNamedModuleDefn));
//# 5252 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1461 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            mWithKwd, _2 
                   )
//# 1461 "src/Compiler/pars.fsy"
                 : range * SynMemberDefns));
//# 5265 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1468 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1468 "src/Compiler/pars.fsy"
                 : 'gentype_opt_attributes));
//# 5276 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1471 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 1471 "src/Compiler/pars.fsy"
                 : 'gentype_opt_attributes));
//# 5286 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1476 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1476 "src/Compiler/pars.fsy"
                 : 'gentype_attributes));
//# 5297 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeList in
            let _2 = parseState.GetInput(2) :?> 'gentype_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1479 "src/Compiler/pars.fsy"
                            _1 @ _2 
                   )
//# 1479 "src/Compiler/pars.fsy"
                 : 'gentype_attributes));
//# 5309 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_attributeListElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_seps in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1485 "src/Compiler/pars.fsy"
                             mkAttributeList _2 (rhs2 parseState 1 4) 
                   )
//# 1485 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5322 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1488 "src/Compiler/pars.fsy"
                             mkAttributeList [] (rhs2 parseState 1 3) 
                   )
//# 1488 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5333 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_attributeListElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_seps in
            let _4 = parseState.GetInput(4) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1491 "src/Compiler/pars.fsy"
                             if not _4 then reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedLBrackLess())
                             mkAttributeList _2 (rhs2 parseState 1 2) 
                   )
//# 1491 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5347 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1495 "src/Compiler/pars.fsy"
                             if not _2 then reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedLBrackLess())
                             mkAttributeList [] (rhs parseState 1) 
                   )
//# 1495 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5359 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attribute in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1502 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 1502 "src/Compiler/pars.fsy"
                 : 'gentype_attributeListElements));
//# 5370 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeListElements in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_attribute in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1505 "src/Compiler/pars.fsy"
                            _1 @ [_3] 
                   )
//# 1505 "src/Compiler/pars.fsy"
                 : 'gentype_attributeListElements));
//# 5383 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_atomicExprAfterType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1512 "src/Compiler/pars.fsy"
                            let arg = match _3 with None -> mkSynUnit _1.Range | Some e -> e
                            let m = unionRanges _1.Range arg.Range
                            ({ TypeName = _1; ArgExpr = arg; Target = None; AppliesToGetterAndSetter = false; Range = m }: SynAttribute) 
                   )
//# 1512 "src/Compiler/pars.fsy"
                 : 'gentype_attribute));
//# 5398 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeTarget in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_atomicExprAfterType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1518 "src/Compiler/pars.fsy"
                            let arg = match _4 with None -> mkSynUnit _2.Range | Some e -> e
                            let startRange = match _1 with Some(ident:Ident) -> ident.idRange | None -> _2.Range
                            let m = unionRanges startRange arg.Range
                            ({ TypeName = _2; ArgExpr = arg; Target = _1; AppliesToGetterAndSetter = false; Range = m }: SynAttribute) 
                   )
//# 1518 "src/Compiler/pars.fsy"
                 : 'gentype_attribute));
//# 5415 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeTarget in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            let _4 = parseState.GetInput(4) :?> 'gentype_oblockend in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _6 = parseState.GetInput(6) :?> 'gentype_opt_atomicExprAfterType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1525 "src/Compiler/pars.fsy"
                            let arg = match _6 with None -> mkSynUnit _3.Range | Some e -> e
                            let startRange = match _1 with Some ident -> ident.idRange | None -> _3.Range
                            let m = unionRanges startRange arg.Range
                            ({ TypeName = _3; ArgExpr = arg; Target = _1; AppliesToGetterAndSetter = false; Range = m }: SynAttribute) 
                   )
//# 1525 "src/Compiler/pars.fsy"
                 : 'gentype_attribute));
//# 5433 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1534 "src/Compiler/pars.fsy"
                             Some(ident("module", (rhs parseState 1))) 
                   )
//# 1534 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5444 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeKeyword in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1537 "src/Compiler/pars.fsy"
                             Some(ident("type", (rhs parseState 1))) 
                   )
//# 1537 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5455 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1539 "src/Compiler/pars.fsy"
                                       Some(_1) 
                   )
//# 1539 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5466 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1543 "src/Compiler/pars.fsy"
                             if _1 then reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsSyntaxError())
                             Some(ident("return", (rhs parseState 1))) 
                   )
//# 1543 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5478 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1549 "src/Compiler/pars.fsy"
                             let mStatic = rhs parseState 1
                             let mMember = rhs parseState 2
                             StaticMemberFlags, SynLeadingKeyword.StaticMember(mStatic, mMember) 
                   )
//# 1549 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5490 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1554 "src/Compiler/pars.fsy"
                             let mStatic = rhs parseState 1
                             // todo: it should be possible to make it work better for both `abstract` and `member` in the type checker
                             StaticMemberFlags, SynLeadingKeyword.Static(mStatic) 
                   )
//# 1554 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5502 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1559 "src/Compiler/pars.fsy"
                             let mMember = rhs parseState 1
                             NonVirtualMemberFlags, SynLeadingKeyword.Member mMember 
                   )
//# 1559 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5513 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1563 "src/Compiler/pars.fsy"
                             let mOverride = rhs parseState 1
                             OverrideMemberFlags, SynLeadingKeyword.Override mOverride 
                   )
//# 1563 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5524 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1567 "src/Compiler/pars.fsy"
                             let mDefault = rhs parseState 1
                             OverrideMemberFlags, SynLeadingKeyword.Default mDefault 
                   )
//# 1567 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5535 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconNameAndTyparDecls in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_typeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1573 "src/Compiler/pars.fsy"
                            let typars, lid, fixity, vis = _2
                            let xmlDoc = grabXmlDoc(parseState, _1, 1)
                            let m = match lid with [] -> rhs parseState 2 | _ -> rangeOfLid lid
                            SynComponentInfo (_1, typars, _3, lid, xmlDoc, fixity, vis, m) 
                   )
//# 1573 "src/Compiler/pars.fsy"
                 : 'gentype_typeNameInfo));
//# 5551 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconDefn in
            let _3 = parseState.GetInput(3) :?> 'gentype_tyconDefnList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1581 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            let tyconDefn =
                                let leadingKeyword = SynTypeDefnLeadingKeyword.And(rhs parseState 1)
                                let (SynTypeDefn(componentInfo, typeRepr, members, implicitConstructor, range, trivia) as typeDefn) = _2 leadingKeyword
                                let (SynComponentInfo(a, typars, c, lid, _xmlDoc, fixity, vis, mLongId)) = componentInfo
                                if xmlDoc.IsEmpty then
                                    if _xmlDoc.IsEmpty then typeDefn else
                                    let range = unionRangeWithXmlDoc _xmlDoc range
                                    SynTypeDefn(componentInfo, typeRepr, members, implicitConstructor, range, trivia)
                                else
                                    _xmlDoc.MarkAsInvalid()
                                    let range = unionRangeWithXmlDoc xmlDoc range
                                    let componentInfo = SynComponentInfo (a, typars, c, lid, xmlDoc, fixity, vis, mLongId)
                                    SynTypeDefn(componentInfo, typeRepr, members, implicitConstructor, range, trivia)
                            tyconDefn :: _3 
                   )
//# 1581 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnList));
//# 5577 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1598 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1598 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnList));
//# 5587 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1603 "src/Compiler/pars.fsy"
                            fun leadingKeyword ->
                                let trivia: SynTypeDefnTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = None; WithKeyword = None }
                                SynTypeDefn(_1, SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None(_1.Range), _1.Range), [], None, _1.Range, trivia) 
                   )
//# 1603 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5600 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> range * SynMemberDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1608 "src/Compiler/pars.fsy"
                            let mWithKwd, classDefns = _2
                            let m = (rhs parseState 1, classDefns) ||> unionRangeWithListBy (fun mem -> mem.Range)
                            fun leadingKeyword ->
                                let trivia: SynTypeDefnTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = None; WithKeyword = None }
                                SynTypeDefn(_1, SynTypeDefnRepr.ObjectModel(SynTypeDefnKind.Augmentation mWithKwd, [], m), classDefns, None, m, trivia) 
                   )
//# 1608 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5616 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_simplePatterns in
            let _6 = parseState.GetInput(6) :?> 'gentype_optAsSpec in
            let _8 = parseState.GetInput(8) :?> 'gentype_tyconDefnRhsBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1615 "src/Compiler/pars.fsy"
                            let vis, spats, az = _3, _5, _6
                            let nameRange = rhs parseState 1
                            let (tcDefRepr, mWith, members) = _8 nameRange
                            let (SynComponentInfo(_, _, _, lid, _, _, _, _)) = _1
                            let mEquals = rhs parseState 7
                            // Gets the XML doc comments prior to the implicit constructor
                            let xmlDoc = grabXmlDoc (parseState, _2, 2)
                            let m = match lid with [] -> rhs parseState 1 | _ -> rangeOfLid lid
                            let memberCtorPattern =
                                spats |> Option.map (fun spats ->
                                    SynMemberDefn.ImplicitCtor(vis, _2, spats, Option.bind snd az, xmlDoc, m, { AsKeyword = Option.map fst az })
                                )
                            let tcDefRepr =
                              match tcDefRepr, memberCtorPattern with
                              | SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None _, m), Some ctor ->
                                  reportParseErrorAt m (FSComp.SR.parsEmptyTypeDefinition())
                                  SynTypeDefnRepr.ObjectModel(SynTypeDefnKind.Unspecified, [ctor], unionRanges m mEquals)
                              | SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None mName, m), _ ->
                                  reportParseErrorAt m (FSComp.SR.parsEmptyTypeDefinition())
                                  tcDefRepr
                              | SynTypeDefnRepr.ObjectModel(k, cspec, m), Some ctor ->
                                  SynTypeDefnRepr.ObjectModel(k, ctor :: cspec, m)
                              | _, Some ctor ->
                                  reportParseErrorAt (rhs2 parseState 1 5) (FSComp.SR.parsOnlyClassCanTakeValueArguments ())
                                  tcDefRepr
                              | _ ->
                                  match az with
                                  | Some(_, Some id) ->
                                      reportParseErrorAt (rhs parseState 6) (FSComp.SR.tcLetAndDoRequiresImplicitConstructionSequence ())
                                  | _ -> ()
                                  tcDefRepr
                            let declRange = unionRanges (rhs parseState 1) tcDefRepr.Range
                            let mWhole = (declRange, members)
                                         ||> unionRangeWithListBy (fun (mem: SynMemberDefn) -> mem.Range)
                                         |> unionRangeWithXmlDoc xmlDoc
                            fun leadingKeyword ->
                                let trivia: SynTypeDefnTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = Some mEquals; WithKeyword = mWith }
                                SynTypeDefn(_1, tcDefRepr, members, memberCtorPattern, mWhole, trivia) 
                   )
//# 1615 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5670 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_simplePatterns in
            let _6 = parseState.GetInput(6) :?> 'gentype_optAsSpec in
            let _7 = parseState.GetInput(7) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1666 "src/Compiler/pars.fsy"
                            let vis, spats, az = _3, _5, _6
                            let (SynComponentInfo(longId = lid)) = _1
                            // Gets the XML doc comments prior to the implicit constructor
                            let xmlDoc = grabXmlDoc (parseState, _2, 2)
                            let m = match lid with [] -> rhs parseState 1 | _ -> rangeOfLid lid
                            let mName = _1.Range
                            let members, mWhole =
                                match spats, vis, az with
                                | Some spats, _, _ ->
                                    let memberCtorPattern = SynMemberDefn.ImplicitCtor(vis, _2, spats, Option.bind snd az, xmlDoc, m, { AsKeyword = Option.map fst az })
                                    [memberCtorPattern], unionRanges mName memberCtorPattern.Range
                                | _, _, Some(mAs, asId) ->
                                    let mAs =
                                        asId |> Option.map (fun id ->
                                            reportParseErrorAt (rhs parseState 6) (FSComp.SR.tcLetAndDoRequiresImplicitConstructionSequence ())
                                            id.idRange
                                        )
                                        |> Option.defaultValue mAs
                                    [], unionRanges mName mAs
                                | _, Some vis, _ ->
                                    [], unionRanges mName vis.Range
                                | _ ->
                                    [], mName
                            fun leadingKeyword ->
                                let trivia = { SynTypeDefnTrivia.Zero with LeadingKeyword = leadingKeyword }
                                SynTypeDefn(_1, SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None(mName), mName), members, None, mWhole, trivia) 
                   )
//# 1666 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5712 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconDefnRhs in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_OBLOCKSEP in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnMembers in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_classDefn in
            let _6 = parseState.GetInput(6) :?> 'gentype_oblockend in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_classDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1710 "src/Compiler/pars.fsy"
                            let mWith, optClassDefn = _5
                            let mWith2, optClassDefn2 = _7
                            let m = unionRanges (rhs parseState 1) (match optClassDefn2 with [] -> (match optClassDefn with [] -> (rhs parseState 4) | _ -> (rhs parseState 5)) | _ -> (rhs parseState 7))
                            (fun nameRange ->
                                let tcDefRepr, members = _2 nameRange (checkForMultipleAugmentations m (_4 @ optClassDefn) optClassDefn2)
                                let mWith = Option.orElse mWith2 mWith
                                tcDefRepr, mWith, members) 
                   )
//# 1710 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5734 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconDefnRhs in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_OBLOCKSEP in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnMembers in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_classDefn in
            let _6 = parseState.GetInput(6) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1719 "src/Compiler/pars.fsy"
                            if not _6 then reportParseErrorAt (rhs parseState 6) (FSComp.SR.parsUnexpectedEndOfFileTypeDefinition())
                            let mWith, optClassDefn = _5
                            let m = unionRanges (rhs parseState 1) (match optClassDefn with [] -> (rhs parseState 4) | _ -> (rhs parseState 5))
                            (fun nameRange ->
                                let tcDefRepr, members = _2 nameRange (checkForMultipleAugmentations m (_4 @ optClassDefn) [])
                                tcDefRepr, mWith, members) 
                   )
//# 1719 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5754 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1727 "src/Compiler/pars.fsy"
                            fun mName ->
                                SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None mName, mName), None, [] 
                   )
//# 1727 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5766 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconDefnRhs in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1731 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            let mWith, optClassDefn = _2
                            (fun nameRange ->
                                let tcDefRepr, members = _1 nameRange optClassDefn
                                tcDefRepr, mWith, members) 
                   )
//# 1731 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5782 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypeDefnSimpleRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1743 "src/Compiler/pars.fsy"
                            let m = _1.Range
                            (fun nameRange augmentation -> SynTypeDefnRepr.Simple(_1, m), augmentation) 
                   )
//# 1743 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhs));
//# 5794 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconClassDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1748 "src/Compiler/pars.fsy"
                            let needsCheck, (kind, decls), mopt = _1
                            let m = match mopt with
                                    | None -> (lhs parseState).StartRange // create a zero-width range
                                    | Some m -> m
                            (fun nameRange augmentation ->
                                if needsCheck && isNil decls then
                                    reportParseErrorAt nameRange (FSComp.SR.parsEmptyTypeDefinition())
                                SynTypeDefnRepr.ObjectModel(kind, decls, m), augmentation) 
                   )
//# 1748 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhs));
//# 5812 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1759 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            let ty, arity = _3
                            (fun nameRange augmentation ->
                                let valSig = SynValSig([], (SynIdent(mkSynId m "Invoke", None)), inferredTyparDecls, ty, arity, false, false, PreXmlDoc.Empty, None, None, m, SynValSigTrivia.Zero)
                                let flags = AbstractMemberFlags true SynMemberKind.Member
                                let invoke = SynMemberDefn.AbstractSlot(valSig, flags, m, SynMemberDefnAbstractSlotTrivia.Zero)
                                if not (isNil augmentation) then raiseParseErrorAt m (FSComp.SR.parsAugmentationsIllegalOnDelegateType())
                                SynTypeDefnRepr.ObjectModel(SynTypeDefnKind.Delegate(ty, arity), [invoke], m), []) 
                   )
//# 1759 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhs));
//# 5830 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnBlockKindUnspecified in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1772 "src/Compiler/pars.fsy"
                            let needsCheck, decls, mopt = _1
                            needsCheck, (SynTypeDefnKind.Unspecified, decls), mopt 
                   )
//# 1772 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5842 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1776 "src/Compiler/pars.fsy"
                            false, (_1, _2), Some(rhs2 parseState 1 3) 
                   )
//# 1776 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5854 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1779 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedClassInterfaceOrStruct())
                            let m = (rhs parseState 1, _2) ||> unionRangeWithListBy (fun (d: SynMemberDefn) -> d.Range)
                            false, (_1, _2), Some(m) 
                   )
//# 1779 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5869 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1784 "src/Compiler/pars.fsy"
                            // silent recovery
                            false, (_1, []), Some(rhs2 parseState 1 3) 
                   )
//# 1784 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5881 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembersAtLeastOne in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1791 "src/Compiler/pars.fsy"
                            if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeDefinition())
                            let mopt =
                                match _2 with
                                | _ :: _ -> Some((rhs parseState 1, _2) ||> unionRangeWithListBy (fun (d: SynMemberDefn) -> d.Range))
                                | _ -> None
                            false, _2, mopt 
                   )
//# 1791 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlockKindUnspecified));
//# 5898 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembersAtLeastOne in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1799 "src/Compiler/pars.fsy"
                            let mopt =
                                match _2 with
                                | _ :: _ -> Some((rhs parseState 1, _2) ||> unionRangeWithListBy (fun (d: SynMemberDefn) -> d.Range))
                                | _ -> None
                            true, _2, mopt 
                   )
//# 1799 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlockKindUnspecified));
//# 5914 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1809 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeDefinition())
                             _2 
                   )
//# 1809 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlock));
//# 5927 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1813 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 1813 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlock));
//# 5939 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1816 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1816 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlock));
//# 5950 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMembersAtLeastOne in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1822 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1822 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembers));
//# 5961 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1826 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 1826 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembers));
//# 5972 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1829 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1829 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembers));
//# 5982 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMember in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_classDefnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1835 "src/Compiler/pars.fsy"
                            match _1, _3 with
                            | [ SynMemberDefn.Interface(members=Some []; range=m) ], nextMember :: _ ->
                                let strictIndentation = parseState.LexBuffer.SupportsFeature LanguageFeature.StrictIndentation
                                let warnF = if strictIndentation then errorR else warning 
                                warnF(IndentationProblem(FSComp.SR.lexfltTokenIsOffsideOfContextStartedEarlier(warningStringOfPos m.Start), nextMember.Range))
                            | _ -> ()
                            _1 @ _3 
                   )
//# 1835 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembersAtLeastOne));
//# 6001 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMemberGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1847 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            mWithKwd, _2 
                   )
//# 1847 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSet));
//# 6013 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMemberGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1851 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            mWithKwd, _2 
                   )
//# 1851 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSet));
//# 6025 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMemberGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1855 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedWith())
                            mWithKwd, _2 
                   )
//# 1855 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSet));
//# 6038 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMemberGetSetElement in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1862 "src/Compiler/pars.fsy"
                            [_1], None 
                   )
//# 1862 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSetElements));
//# 6049 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMemberGetSetElement in
            let _3 = parseState.GetInput(3) :?> 'gentype_classDefnMemberGetSetElement in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1865 "src/Compiler/pars.fsy"
                            let mAnd = rhs parseState 2
                            [_1;_3], Some mAnd 
                   )
//# 1865 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSetElements));
//# 6062 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _6 = parseState.GetInput(6) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1870 "src/Compiler/pars.fsy"
                            let mEquals = rhs parseState 5
                            let mRhs = (_6: SynExpr).Range
                            (_1, _2, _3, _4, Some mEquals, _6, mRhs) 
                   )
//# 1870 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSetElement));
//# 6079 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _5 = parseState.GetInput(5) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1879 "src/Compiler/pars.fsy"
                            let mRhs = _5.Range
                            let optReturnType = _3
                            let mEquals = rhs parseState 4
                            let bindingPat, mBindLhs = _2
                            (fun vis flagsBuilderAndLeadingKeyword attrs rangeStart ->
                                 let xmlDoc = grabXmlDocAtRangeStart(parseState, attrs, rangeStart)
                                 let memFlagsBuilder, leadingKeyword = flagsBuilderAndLeadingKeyword
                                 let memberFlags = memFlagsBuilder SynMemberKind.Member
                                 let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = Some mEquals }
                                 let binding = mkSynBinding (xmlDoc, bindingPat) (vis, (Option.isSome _1), false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, optReturnType, _5, mRhs, [], attrs, Some memberFlags, trivia)
                                 let memberRange = unionRanges rangeStart mRhs |> unionRangeWithXmlDoc xmlDoc
                                 [ SynMemberDefn.Member(binding, memberRange) ]) 
                   )
//# 1879 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6105 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1894 "src/Compiler/pars.fsy"
                            let optReturnType = _3
                            let bindingPat, mBindLhs = _2
                            let mEnd =
                                match optReturnType with
                                | Some(_, ty) -> ty.Range.EndRange
                                | _ -> bindingPat.Range.EndRange
                            let expr = arbExpr ("memberCore1", mEnd)
                            errorR (Error(FSComp.SR.parsMissingMemberBody(), rhs parseState 4))
                            fun vis flagsBuilderAndLeadingKeyword attrs rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart(parseState, attrs, rangeStart)
                                let memFlagsBuilder, leadingKeyword = flagsBuilderAndLeadingKeyword
                                let memberFlags = memFlagsBuilder SynMemberKind.Member
                                let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = None }
                                let binding = mkSynBinding (xmlDoc, bindingPat) (vis, (Option.isSome _1), false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, optReturnType, expr, mEnd, [], attrs, Some memberFlags, trivia)
                                let memberRange = unionRanges rangeStart mEnd |> unionRangeWithXmlDoc xmlDoc
                                [ SynMemberDefn.Member (binding, memberRange) ] 
                   )
//# 1894 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6134 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1914 "src/Compiler/pars.fsy"
                            let optReturnType = _3
                            let bindingPat, mBindLhs = _2
                            let mEnd =
                                match optReturnType with
                                | Some(_, ty) -> ty.Range.EndRange
                                | _ -> bindingPat.Range.EndRange
                            let expr = arbExpr ("memberCore2", mEnd)
                            fun vis flagsBuilderAndLeadingKeyword attrs rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart(parseState, attrs, rangeStart)
                                let memFlagsBuilder, leadingKeyword = flagsBuilderAndLeadingKeyword
                                let memberFlags = memFlagsBuilder SynMemberKind.Member
                                let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = None }
                                let binding = mkSynBinding (xmlDoc, bindingPat) (vis, (Option.isSome _1), false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, optReturnType, expr, mEnd, [], attrs, Some memberFlags, trivia)
                                let memberRange = unionRanges rangeStart mEnd |> unionRangeWithXmlDoc xmlDoc
                                [ SynMemberDefn.Member (binding, memberRange) ] 
                   )
//# 1914 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6163 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnMemberGetSet in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1934 "src/Compiler/pars.fsy"
                            let mWith, (classDefnMemberGetSetElements, mAnd) = _4
                            let mWhole = (rhs parseState 2, classDefnMemberGetSetElements) ||> unionRangeWithListBy (fun (_, _, _, _, _, _, m2) -> m2)
                            let propertyNameBindingPat, _ = _2
                            let optPropertyType = _3
                            mkSynMemberDefnGetSet
                                parseState
                                _1
                                mWith
                                classDefnMemberGetSetElements
                                mAnd
                                mWhole
                                propertyNameBindingPat
                                optPropertyType 
                   )
//# 1934 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6189 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1951 "src/Compiler/pars.fsy"
                             let mAbstract = rhs parseState 1
                             AbstractMemberFlags true, SynLeadingKeyword.Abstract mAbstract 
                   )
//# 1951 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6200 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1955 "src/Compiler/pars.fsy"
                             let mAbstract = rhs parseState 1
                             let mMember = rhs parseState 2
                             AbstractMemberFlags true, SynLeadingKeyword.AbstractMember(mAbstract, mMember) 
                   )
//# 1955 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6212 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1960 "src/Compiler/pars.fsy"
                             let mWhole = rhs2 parseState 1 2
                             parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.InterfacesWithAbstractStaticMembers mWhole
                             if parseState.LexBuffer.SupportsFeature LanguageFeature.InterfacesWithAbstractStaticMembers then
                                 warning(Error(FSComp.SR.tcUsingInterfacesWithStaticAbstractMethods(), mWhole))
                             let mStatic = rhs parseState 1
                             let mAbstract = rhs parseState 2
                             AbstractMemberFlags false, SynLeadingKeyword.StaticAbstract(mStatic, mAbstract) 
                   )
//# 1960 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6228 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1969 "src/Compiler/pars.fsy"
                             let mWhole = rhs2 parseState 1 2
                             parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.InterfacesWithAbstractStaticMembers mWhole
                             if parseState.LexBuffer.SupportsFeature LanguageFeature.InterfacesWithAbstractStaticMembers then
                                 warning(Error(FSComp.SR.tcUsingInterfacesWithStaticAbstractMethods(), mWhole))
                             let mStatic = rhs parseState 1
                             let mAbstract = rhs parseState 2
                             let mMember = rhs parseState 3
                             AbstractMemberFlags false, SynLeadingKeyword.StaticAbstractMember(mStatic, mAbstract, mMember) 
                   )
//# 1969 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6245 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_classDefnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1981 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            [mkClassMemberLocalBindings(false, None, _1, _2, _3)] 
                   )
//# 1981 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6259 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1985 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            [mkClassMemberLocalBindings(true, Some(rhs parseState 3), _1, _2, _4)] 
                   )
//# 1985 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6273 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_memberCore in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1989 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            if Option.isSome _2 then
                                errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let flags = _3
                            match flags with
                            | _, SynLeadingKeyword.Static(mStatic) -> errorR (Error (FSComp.SR.parsStaticMemberImcompleteSyntax (), mStatic))
                            | _ -> ()
                            _4 _2 flags _1 rangeStart 
                   )
//# 1989 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6295 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1999 "src/Compiler/pars.fsy"
                             let rangeStart = rhs parseState 1
                             if Option.isSome _2 then
                                 errorR (Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                             let memFlagsBuilder, leadingKeyword = _3
                             let flags = Some(memFlagsBuilder SynMemberKind.Member)
                             let xmlDoc = grabXmlDocAtRangeStart (parseState, _1, rangeStart)
                             let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = None; EqualsRange = None }
                             let mMember = rhs parseState 3
                             let mEnd = mMember.EndRange
                             let bindingPat = patFromParseError (SynPat.Wild(mEnd))
                             let expr = arbExpr ("classDefnMember1", mEnd)
                             let mWhole = rhs2 parseState 1 3
                             let binding =
                                 mkSynBinding
                                     (xmlDoc, bindingPat)
                                     (_2, (Option.isSome _2), false, mWhole, DebugPointAtBinding.NoneAtInvisible, None, expr, mEnd, [], _1, flags, trivia)
                             [SynMemberDefn.Member(binding, mWhole)] 
                   )
//# 1999 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6325 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_interfaceMember in
            let _4 = parseState.GetInput(4) :?> 'gentype_appType in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_interfaceImplDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2019 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesAreNotPermittedOnInterfaceImplementations(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsInterfacesHaveSameVisibilityAsEnclosingType(), rhs parseState 3))
                            let mWithKwd, members, mWhole =
                                match _5 with
                                | None -> None, None, rhs2 parseState 1 4
                                | Some(mWithKwd, members, m) -> Some mWithKwd, Some members, unionRanges (rhs2 parseState 1 4) m
                            [ SynMemberDefn.Interface(_4, mWithKwd, members, mWhole) ] 
                   )
//# 2019 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6346 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_interfaceMember in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2028 "src/Compiler/pars.fsy"
                            let mInterface = rhs parseState 3
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesAreNotPermittedOnInterfaceImplementations(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsInterfacesHaveSameVisibilityAsEnclosingType(), mInterface))
                            let ty = SynType.FromParseError(mInterface.EndRange)
                            [ SynMemberDefn.Interface(ty, None, None, rhs2 parseState 1 3) ] 
                   )
//# 2028 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6364 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_abstractMemberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_inline in
            let _5 = parseState.GetInput(5) :?> 'gentype_nameop in
            let _6 = parseState.GetInput(6) :?> 'gentype_opt_explicitValTyparDecls in
            let _8 = parseState.GetInput(8) :?> 'gentype_topTypeWithTypeConstraints in
            let _9 = parseState.GetInput(9) :?> 'gentype_classMemberSpfnGetSet in
            let _10 = parseState.GetInput(10) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2035 "src/Compiler/pars.fsy"
                            let ty, arity = _8
                            let isInline, doc, id, explicitValTyparDecls = (Option.isSome _4), grabXmlDoc(parseState, _1, 1), _5, _6
                            let mWith, (getSet, getSetRangeOpt) = _9
                            let getSetAdjuster arity = match arity, getSet with SynValInfo([], _), SynMemberKind.Member -> SynMemberKind.PropertyGet | _ -> getSet
                            let mWhole =
                                let m = rhs parseState 1
                                match getSetRangeOpt with
                                | None -> unionRanges m ty.Range
                                | Some gs -> unionRanges m gs.Range
                                |> unionRangeWithXmlDoc doc
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsAccessibilityModsIllegalForAbstract(), mWhole))
                            let mkFlags, leadingKeyword = _3
                            let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _4; WithKeyword = mWith; EqualsRange = None }
                            let valSpfn = SynValSig(_1, id, explicitValTyparDecls, ty, arity, isInline, false, doc, None, None, mWhole, trivia)
                            let trivia: SynMemberDefnAbstractSlotTrivia = { GetSetKeywords = getSetRangeOpt }
                            [ SynMemberDefn.AbstractSlot(valSpfn, mkFlags (getSetAdjuster arity), mWhole, trivia) ] 
                   )
//# 2035 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6398 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_inheritsDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2053 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalOnInherit(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityIllegalOnInherit(), rhs parseState 1))
                            [ _3 ] 
                   )
//# 2053 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6413 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_valDefnDecl in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2058 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let rangeStart = rhs parseState 1
                            _3 rangeStart _1 None 
                   )
//# 2058 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6429 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_valDefnDecl in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2063 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let mStatic = rhs parseState 3
                            let rangeStart = rhs parseState 1
                            _4 rangeStart _1 (Some mStatic) 
                   )
//# 2063 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6446 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_autoPropsDefnDecl in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2069 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            if Option.isSome _2 then
                                errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let flags = _3
                            _4 _1 flags rangeStart 
                   )
//# 2069 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6465 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_atomicPattern in
            let _5 = parseState.GetInput(5) :?> 'gentype_optAsSpec in
            let _7 = parseState.GetInput(7) :?> SynExpr in
            let _8 = parseState.GetInput(8) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2076 "src/Compiler/pars.fsy"
                            let mWholeBindLhs = rhs2 parseState 1 (if Option.isSome _5 then 5 else 4)
                            let mNew = rhs parseState 3
                            let xmlDoc = grabXmlDoc(parseState, _1, 1)
                            let m = unionRanges mWholeBindLhs _7.Range |> unionRangeWithXmlDoc xmlDoc
                            let mEquals = rhs parseState 6
                            let expr = _7
                            let valSynData = SynValData (Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat _4], SynInfo.unnamedRetVal), Option.bind snd _5)
                            let vis = _2
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [_4], vis, rhs parseState 3)
                            // Check that 'SynPatForConstructorDecl' matches this correctly
                            assert (match declPat with SynPatForConstructorDecl _ -> true | _ -> false)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = Some mEquals }
                            [ SynMemberDefn.Member(SynBinding (None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2076 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6493 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_atomicPattern in
            let _5 = parseState.GetInput(5) :?> 'gentype_optAsSpec in
            let _6 = parseState.GetInput(6) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2091 "src/Compiler/pars.fsy"
                            if not _6 then reportParseErrorAt (rhs parseState 6) (FSComp.SR.parsMissingMemberBody ())
                            let mNew = rhs parseState 3
                            let mAs = _5 |> Option.map (fun (mAs, id) -> id |> Option.map (fun id -> id.idRange) |> Option.defaultValue mAs)
                            let mEnd = mAs |> Option.defaultValue _4.Range
                            let xmlDoc = grabXmlDoc (parseState, _1, 1)
                            let m = unionRanges (rhs parseState 1) mEnd |> unionRangeWithXmlDoc xmlDoc
                            let expr = arbExpr ("new1", mEnd.EndRange)
                            let valSynData = SynValData (Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat _4], SynInfo.unnamedRetVal), Option.bind snd _5)
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [_4], _2, rhs parseState 3)
                            assert (match declPat with SynPatForConstructorDecl _ -> true | _ -> false)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = None }
                            [ SynMemberDefn.Member(SynBinding(None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, m, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2091 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6519 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_atomicPattern in
            let _5 = parseState.GetInput(5) :?> 'gentype_optAsSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2105 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 5) (FSComp.SR.parsMissingMemberBody ())
                            let mNew = rhs parseState 3
                            let mAs = _5 |> Option.map (fun (mAs, id) -> id |> Option.map (fun id -> id.idRange) |> Option.defaultValue mAs)
                            let mEnd = mAs |> Option.defaultValue _4.Range
                            let xmlDoc = grabXmlDoc (parseState, _1, 1)
                            let m = unionRanges (rhs parseState 1) mEnd |> unionRangeWithXmlDoc xmlDoc
                            let expr = arbExpr ("new2", mEnd.EndRange)
                            let valSynData = SynValData(Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat _4], SynInfo.unnamedRetVal), Option.bind snd _5)
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [_4], _2, rhs parseState 3)
                            assert (match declPat with SynPatForConstructorDecl _ -> true | _ -> false)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = None }
                            [ SynMemberDefn.Member(SynBinding (None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, m, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2105 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6544 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2119 "src/Compiler/pars.fsy"
                            let m = rhs2 parseState 1 3
                            let mNew = rhs parseState 3
                            let xmlDoc = grabXmlDoc (parseState, _1, 1)
                            let pat = patFromParseError (SynPat.Wild(mNew.EndRange))
                            let expr = arbExpr ("new3", mNew.EndRange)
                            let valSynData = SynValData(Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat pat], SynInfo.unnamedRetVal), None)
                            let vis = _2
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [pat], vis, rhs parseState 3)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = None }
                            [ SynMemberDefn.Member(SynBinding(None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, m, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2119 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6567 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_typeKeyword in
            let _5 = parseState.GetInput(5) :?> 'gentype_tyconDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2131 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let leadingKeyword = SynTypeDefnLeadingKeyword.StaticType(rhs parseState 3, rhs parseState 4)
                            [ SynMemberDefn.NestedType(_5 leadingKeyword, None, rhs2 parseState 1 5) ] 
                   )
//# 2131 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6583 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _6 = parseState.GetInput(6) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2139 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 (Some _4) (Some _6) rangeStart attribs mStaticOpt ] 
                   )
//# 2139 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6599 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _6 = parseState.GetInput(6) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2144 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mColon = rhs parseState 5
                            let ty = SynType.FromParseError(mColon.EndRange)
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 (Some _4) (Some ty) rangeStart attribs mStaticOpt ] 
                   )
//# 2144 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6617 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2151 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let ty = SynType.FromParseError(_4.idRange.EndRange)
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 (Some _4) (Some ty) rangeStart attribs mStaticOpt ] 
                   )
//# 2151 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6634 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2157 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 None None rangeStart attribs mStaticOpt ] 
                   )
//# 2157 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6649 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_typ in
            let _7 = parseState.GetInput(7) :?> SynExpr in
            let _8 = parseState.GetInput(8) :?> 'gentype_classMemberSpfnGetSet in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2165 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mEquals = rhs parseState 6
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart (parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 _4 _5 (Some mEquals) _7 _8 xmlDoc attribs flags rangeStart ] 
                   )
//# 2165 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6671 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_typ in
            let _6 = parseState.GetInput(6) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2174 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mEnd =
                                match _5 with
                                | Some t -> t.Range
                                | _ -> _4.idRange
                            let expr = arbExpr ("autoProp1", mEnd.EndRange)
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart (parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 _4 _5 None expr (None, (SynMemberKind.Member, None)) xmlDoc attribs flags rangeStart ] 
                   )
//# 2174 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6696 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_typ in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2187 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mEnd =
                                match _5 with
                                | Some t -> t.Range
                                | _ -> _4.idRange
                            let expr = arbExpr ("autoProp2", mEnd.EndRange)
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart (parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 _4 _5 None expr (None, (SynMemberKind.Member, None)) xmlDoc attribs flags rangeStart ] 
                   )
//# 2187 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6720 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2200 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let id = mkSynId mVal.EndRange ""
                            let expr = arbExpr ("autoProp3", mVal.EndRange)
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart(parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 id None None expr (None, (SynMemberKind.Member, None)) xmlDoc attribs flags rangeStart ] 
                   )
//# 2200 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6740 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2212 "src/Compiler/pars.fsy"
                              None 
                   )
//# 2212 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typ));
//# 6750 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2215 "src/Compiler/pars.fsy"
                              Some _2 
                   )
//# 2215 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typ));
//# 6761 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2218 "src/Compiler/pars.fsy"
                              let mColon = rhs parseState 1
                              let ty = SynType.FromParseError(mColon.EndRange)
                              Some ty 
                   )
//# 2218 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typ));
//# 6774 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2225 "src/Compiler/pars.fsy"
                            if not (parseState.LexBuffer.SupportsFeature LanguageFeature.SingleUnderscorePattern) then
                               raiseParseErrorAt (rhs parseState 2) (FSComp.SR.parsUnexpectedSymbolDot())
                            let underscore = ident("_", rhs parseState 1)
                            let mDot = rhs parseState 2
                            None, prependIdentInLongIdentWithTrivia (SynIdent(underscore, None)) mDot _3 
                   )
//# 2225 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6789 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2233 "src/Compiler/pars.fsy"
                            let globalIdent = ident(MangledGlobalName, rhs parseState 1)
                            let mDot = rhs parseState 2
                            None, prependIdentInLongIdentWithTrivia (SynIdent(globalIdent, (Some(IdentTrivia.OriginalNotation "global")))) mDot _3 
                   )
//# 2233 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6802 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2238 "src/Compiler/pars.fsy"
                            (None, _1) 
                   )
//# 2238 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6813 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_access in
            let _4 = parseState.GetInput(4) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2241 "src/Compiler/pars.fsy"
                            if not (parseState.LexBuffer.SupportsFeature LanguageFeature.SingleUnderscorePattern) then
                               raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedSymbolDot())
                            let underscore = ident("_", rhs parseState 2)
                            let mDot = rhs parseState 3
                            Some(_1), prependIdentInLongIdentWithTrivia (SynIdent(underscore, None)) mDot _4 
                   )
//# 2241 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6829 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_access in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2249 "src/Compiler/pars.fsy"
                            (Some(_1), _2) 
                   )
//# 2249 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6841 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2254 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2254 "src/Compiler/pars.fsy"
                 : 'gentype_opt_access));
//# 6851 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_access in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2257 "src/Compiler/pars.fsy"
                            Some(_1) 
                   )
//# 2257 "src/Compiler/pars.fsy"
                 : 'gentype_opt_access));
//# 6862 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2262 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            SynAccess.Private m 
                   )
//# 2262 "src/Compiler/pars.fsy"
                 : 'gentype_access));
//# 6873 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2266 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            SynAccess.Public m 
                   )
//# 2266 "src/Compiler/pars.fsy"
                 : 'gentype_access));
//# 6884 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2270 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            SynAccess.Internal m 
                   )
//# 2270 "src/Compiler/pars.fsy"
                 : 'gentype_access));
//# 6895 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_objectImplementationBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2276 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            let members = _2
                            let m = (rhs parseState 1, members) ||> unionRangeWithListBy (fun (mem: SynMemberDefn) -> mem.Range)
                            Some(mWithKwd, members, m) 
                   )
//# 2276 "src/Compiler/pars.fsy"
                 : 'gentype_opt_interfaceImplDefn));
//# 6910 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2282 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            Some(mWithKwd, [], mWithKwd) 
                   )
//# 2282 "src/Compiler/pars.fsy"
                 : 'gentype_opt_interfaceImplDefn));
//# 6921 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2286 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2286 "src/Compiler/pars.fsy"
                 : 'gentype_opt_interfaceImplDefn));
//# 6931 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2291 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            (Some mWithKwd), _2 
                   )
//# 2291 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classDefn));
//# 6944 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2295 "src/Compiler/pars.fsy"
                            None, [] 
                   )
//# 2295 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classDefn));
//# 6954 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            let _3 = parseState.GetInput(3) :?> 'gentype_optBaseSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2301 "src/Compiler/pars.fsy"
                            let mDecl = unionRanges (rhs parseState 1) _2.Range
                            SynMemberDefn.Inherit(_2, _3, mDecl) 
                   )
//# 2301 "src/Compiler/pars.fsy"
                 : 'gentype_inheritsDefn));
//# 6967 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _4 = parseState.GetInput(4) :?> SynExpr in
            let _5 = parseState.GetInput(5) :?> 'gentype_optBaseSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2305 "src/Compiler/pars.fsy"
                            let mDecl = unionRanges (rhs parseState 1) _4.Range
                            SynMemberDefn.ImplicitInherit(_2, _4, _5, mDecl) 
                   )
//# 2305 "src/Compiler/pars.fsy"
                 : 'gentype_inheritsDefn));
//# 6982 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2309 "src/Compiler/pars.fsy"
                            let mDecl = (rhs parseState 1)
                            if not _2 then errorR (Error(FSComp.SR.parsTypeNameCannotBeEmpty (), mDecl))
                            SynMemberDefn.Inherit(SynType.LongIdent(SynLongIdent([], [], [])), None, mDecl) 
                   )
//# 2309 "src/Compiler/pars.fsy"
                 : 'gentype_inheritsDefn));
//# 6995 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_asSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2315 "src/Compiler/pars.fsy"
                             Some(_1) 
                   )
//# 2315 "src/Compiler/pars.fsy"
                 : 'gentype_optAsSpec));
//# 7006 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2318 "src/Compiler/pars.fsy"
                             None 
                   )
//# 2318 "src/Compiler/pars.fsy"
                 : 'gentype_optAsSpec));
//# 7016 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2322 "src/Compiler/pars.fsy"
                            rhs parseState 1, Some _2 
                   )
//# 2322 "src/Compiler/pars.fsy"
                 : 'gentype_asSpec));
//# 7027 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2325 "src/Compiler/pars.fsy"
                            rhs parseState 1, None 
                   )
//# 2325 "src/Compiler/pars.fsy"
                 : 'gentype_asSpec));
//# 7038 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_baseSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2329 "src/Compiler/pars.fsy"
                            Some(_1) 
                   )
//# 2329 "src/Compiler/pars.fsy"
                 : 'gentype_optBaseSpec));
//# 7049 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2332 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2332 "src/Compiler/pars.fsy"
                 : 'gentype_optBaseSpec));
//# 7059 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2336 "src/Compiler/pars.fsy"
                             if (_2).idText <> "base" then
                                  errorR(Error(FSComp.SR.parsInheritDeclarationsCannotHaveAsBindings(), rhs2 parseState 1 2))
                             ident("base", rhs parseState 2) 
                   )
//# 2336 "src/Compiler/pars.fsy"
                 : 'gentype_baseSpec));
//# 7072 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2341 "src/Compiler/pars.fsy"
                             errorR(Error(FSComp.SR.parsInheritDeclarationsCannotHaveAsBindings(), rhs2 parseState 1 2))
                             ident("base", rhs parseState 2) 
                   )
//# 2341 "src/Compiler/pars.fsy"
                 : 'gentype_baseSpec));
//# 7083 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_objectImplementationMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2348 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 2348 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationBlock));
//# 7095 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_objectImplementationMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2351 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileObjectMembers())
                             _2 
                   )
//# 2351 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationBlock));
//# 7108 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_objectImplementationMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2355 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2355 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationBlock));
//# 7119 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_objectImplementationMember in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_objectImplementationMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2361 "src/Compiler/pars.fsy"
                             _1 @  _3 
                   )
//# 2361 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMembers));
//# 7132 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_objectImplementationMember in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2364 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2364 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMembers));
//# 7144 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticMemberOrMemberOrOverride in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberCore in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2370 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            _3 None _2 _1 rangeStart 
                   )
//# 2370 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7159 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticMemberOrMemberOrOverride in
            let _3 = parseState.GetInput(3) :?> 'gentype_autoPropsDefnDecl in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2374 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            _3 _1 _2 rangeStart 
                   )
//# 2374 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7174 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticMemberOrMemberOrOverride in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2378 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 2378 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7186 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberCore in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2381 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 2381 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7199 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2386 "src/Compiler/pars.fsy"
                             let mStatic = rhs parseState 1
                             let mMember = rhs parseState 2
                             ImplementStaticMemberFlags, (SynLeadingKeyword.StaticMember(mStatic, mMember)) 
                   )
//# 2386 "src/Compiler/pars.fsy"
                 : 'gentype_staticMemberOrMemberOrOverride));
//# 7211 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2390 "src/Compiler/pars.fsy"
                             let mMember = rhs parseState 1
                             OverrideMemberFlags, (SynLeadingKeyword.Member mMember) 
                   )
//# 2390 "src/Compiler/pars.fsy"
                 : 'gentype_staticMemberOrMemberOrOverride));
//# 7222 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2393 "src/Compiler/pars.fsy"
                             let mOverride = rhs parseState 1
                             OverrideMemberFlags, (SynLeadingKeyword.Override mOverride) 
                   )
//# 2393 "src/Compiler/pars.fsy"
                 : 'gentype_staticMemberOrMemberOrOverride));
//# 7233 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            let _4 = parseState.GetInput(4) :?> string * bool in
            let _5 = parseState.GetInput(5) :?> string * SynStringKind * ParseHelpers.LexerContinuation in
            let _6 = parseState.GetInput(6) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2402 "src/Compiler/pars.fsy"
                            errorR(Error(FSComp.SR.parsUnexpectedQuotationOperatorInTypeAliasDidYouMeanVerbatimString(), rhs parseState 4))
                            SynTypeDefnSimpleRepr.TypeAbbrev(ParserDetail.ErrorRecovery, SynType.LongIdent(_3), unionRanges (rhs parseState 1) _3.Range) 
                   )
//# 2402 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7250 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2407 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsTypeAbbreviationsCannotHaveVisibilityDeclarations(), rhs parseState 2))
                            SynTypeDefnSimpleRepr.TypeAbbrev(ParserDetail.Ok, _3, unionRanges (rhs parseState 1) _3.Range) 
                   )
//# 2407 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7265 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Choice<SynEnumCase, SynUnionCase> list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2413 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            let rangesOf3 = _3 |> List.map (function Choice1Of2 ec -> ec.Range | Choice2Of2 uc -> uc.Range)
                            let mWhole = (rhs2 parseState 1 2, rangesOf3) ||> List.fold unionRanges
                            if _3 |> List.exists (function Choice1Of2 _ -> true | _ -> false) then (
                                if Option.isSome _2 then errorR(Error(FSComp.SR.parsEnumTypesCannotHaveVisibilityDeclarations(), rhs parseState 2))
                                SynTypeDefnSimpleRepr.Enum(_3 |> List.choose (function
                                                                   | Choice1Of2 data ->
                                                                     Some(data)
                                                                   | Choice2Of2(SynUnionCase(range=m)) ->
                                                                     errorR(Error(FSComp.SR.parsAllEnumFieldsRequireValues(), m)); None),
                                                mWhole)
                            ) else
                                SynTypeDefnSimpleRepr.Union(_2,
                                                 _3 |> List.choose (function Choice2Of2 data -> Some(data) | Choice1Of2 _ -> failwith "huh?"),
                                                 mWhole) 
                   )
//# 2413 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7292 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_braceFieldDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2431 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            SynTypeDefnSimpleRepr.Record(_2, _3, lhs parseState) 
                   )
//# 2431 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7306 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_string in
            let _7 = parseState.GetInput(7) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2436 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            let mLhs = lhs parseState
                            if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyError mLhs
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsInlineAssemblyCannotHaveVisibilityDeclarations(), rhs parseState 2))
                            let s, _ = _5
                            let ilType = ParseAssemblyCodeType s parseState.LexBuffer.ReportLibraryOnlyFeatures parseState.LexBuffer.LanguageVersion parseState.LexBuffer.StrictIndentation (rhs parseState 5)
                            SynTypeDefnSimpleRepr.LibraryOnlyILAssembly(box ilType, mLhs) 
                   )
//# 2436 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7326 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2448 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 2448 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7339 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2451 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedBrace())
                            _2 
                   )
//# 2451 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7353 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _3 = parseState.GetInput(3) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2455 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 2455 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7365 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2458 "src/Compiler/pars.fsy"
                            errorR (Error(FSComp.SR.parsExpectingField(), rhs parseState 2))
                            [] 
                   )
//# 2458 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7378 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_braceBarFieldDeclListCore in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2463 "src/Compiler/pars.fsy"
                               _2, true 
                   )
//# 2463 "src/Compiler/pars.fsy"
                 : 'gentype_anonRecdType));
//# 7389 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_braceBarFieldDeclListCore in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2465 "src/Compiler/pars.fsy"
                               _1, false 
                   )
//# 2465 "src/Compiler/pars.fsy"
                 : 'gentype_anonRecdType));
//# 7400 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_bar_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2470 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 2470 "src/Compiler/pars.fsy"
                 : 'gentype_braceBarFieldDeclListCore));
//# 7412 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2473 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedBraceBar())
                            _2 
                   )
//# 2473 "src/Compiler/pars.fsy"
                 : 'gentype_braceBarFieldDeclListCore));
//# 7425 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_bar_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2477 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 2477 "src/Compiler/pars.fsy"
                 : 'gentype_braceBarFieldDeclListCore));
//# 7436 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2481 "src/Compiler/pars.fsy"
                            SynTypeDefnKind.Class 
                   )
//# 2481 "src/Compiler/pars.fsy"
                 : 'gentype_classOrInterfaceOrStruct));
//# 7446 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2484 "src/Compiler/pars.fsy"
                            SynTypeDefnKind.Interface 
                   )
//# 2484 "src/Compiler/pars.fsy"
                 : 'gentype_classOrInterfaceOrStruct));
//# 7456 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2487 "src/Compiler/pars.fsy"
                            SynTypeDefnKind.Struct 
                   )
//# 2487 "src/Compiler/pars.fsy"
                 : 'gentype_classOrInterfaceOrStruct));
//# 7466 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2490 "src/Compiler/pars.fsy"
                                     
                   )
//# 2490 "src/Compiler/pars.fsy"
                 : 'gentype_interfaceMember));
//# 7476 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2491 "src/Compiler/pars.fsy"
                                             
                   )
//# 2491 "src/Compiler/pars.fsy"
                 : 'gentype_interfaceMember));
//# 7486 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2495 "src/Compiler/pars.fsy"
                             None, _2.LongIdent, false, _1 
                   )
//# 2495 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7498 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_prefixTyparDecls in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2498 "src/Compiler/pars.fsy"
                             Some _2, _3.LongIdent, false, _1 
                   )
//# 2498 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7511 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_postfixTyparDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2501 "src/Compiler/pars.fsy"
                             Some _3, _2.LongIdent, true, _1 
                   )
//# 2501 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7524 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2504 "src/Compiler/pars.fsy"
                             None, [], false, _1 
                   )
//# 2504 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7536 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2508 "src/Compiler/pars.fsy"
                             SynTyparDecls.SinglePrefix(SynTyparDecl([], _1, [], SynTyparDeclTrivia.Zero), rhs parseState 1) 
                   )
//# 2508 "src/Compiler/pars.fsy"
                 : 'gentype_prefixTyparDecls));
//# 7547 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typarDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2511 "src/Compiler/pars.fsy"
                             SynTyparDecls.PrefixList(List.rev _2, rhs2 parseState 1 3) 
                   )
//# 2511 "src/Compiler/pars.fsy"
                 : 'gentype_prefixTyparDecls));
//# 7559 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_typarDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2514 "src/Compiler/pars.fsy"
                                                         _3 :: _1 
                   )
//# 2514 "src/Compiler/pars.fsy"
                 : 'gentype_typarDeclList));
//# 7571 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2515 "src/Compiler/pars.fsy"
                                     [_1] 
                   )
//# 2515 "src/Compiler/pars.fsy"
                 : 'gentype_typarDeclList));
//# 7582 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2519 "src/Compiler/pars.fsy"
                             SynTyparDecl(_1, _2, [], SynTyparDeclTrivia.Zero) 
                   )
//# 2519 "src/Compiler/pars.fsy"
                 : 'gentype_typarDecl));
//# 7594 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> 'gentype_intersectionConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2522 "src/Compiler/pars.fsy"
                             parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.ConstraintIntersectionOnFlexibleTypes (rhs2 parseState 3 4)
                             let constraints, mAmpersands = _4
                             SynTyparDecl(_1, _2, List.rev constraints, { AmpersandRanges = rhs parseState 3 :: List.rev mAmpersands }) 
                   )
//# 2522 "src/Compiler/pars.fsy"
                 : 'gentype_typarDecl));
//# 7609 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_HIGH_PRECEDENCE_TYAPP in
            let _2 = parseState.GetInput(2) :?> bool in
            let _3 = parseState.GetInput(3) :?> 'gentype_typarDeclList in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_typeConstraints in
            let _5 = parseState.GetInput(5) :?> bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2530 "src/Compiler/pars.fsy"
                             let m = rhs2 parseState 2 5
                             if not _2 then warning(Error(FSComp.SR.parsNonAdjacentTypars(), m))
                             SynTyparDecls.PostfixList(List.rev _3, _4, m) 
                   )
//# 2530 "src/Compiler/pars.fsy"
                 : 'gentype_postfixTyparDecls));
//# 7626 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2538 "src/Compiler/pars.fsy"
                             (List.rev _1, true) 
                   )
//# 2538 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDeclsCore));
//# 7637 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2541 "src/Compiler/pars.fsy"
                             (List.rev _1, false) 
                   )
//# 2541 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDeclsCore));
//# 7648 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2544 "src/Compiler/pars.fsy"
                             ([], false) 
                   )
//# 2544 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDeclsCore));
//# 7658 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_HIGH_PRECEDENCE_TYAPP in
            let _2 = parseState.GetInput(2) :?> bool in
            let _3 = parseState.GetInput(3) :?> 'gentype_explicitValTyparDeclsCore in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_typeConstraints in
            let _5 = parseState.GetInput(5) :?> bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2548 "src/Compiler/pars.fsy"
                             let m = rhs2 parseState 2 5
                             if not _2 then warning(Error(FSComp.SR.parsNonAdjacentTypars(), m))
                             let tps, flex = _3
                             let tps = SynTyparDecls.PostfixList(tps, _4, m)
                             SynValTyparDecls(Some tps, flex) 
                   )
//# 2548 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDecls));
//# 7677 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_explicitValTyparDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2556 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2556 "src/Compiler/pars.fsy"
                 : 'gentype_opt_explicitValTyparDecls));
//# 7688 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2558 "src/Compiler/pars.fsy"
                             SynValTyparDecls(None, true) 
                   )
//# 2558 "src/Compiler/pars.fsy"
                 : 'gentype_opt_explicitValTyparDecls));
//# 7698 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2564 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 2564 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typeConstraints));
//# 7708 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2567 "src/Compiler/pars.fsy"
                            List.rev _2 
                   )
//# 2567 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typeConstraints));
//# 7719 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeConstraints in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeConstraint in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2573 "src/Compiler/pars.fsy"
                            _3 :: _1 
                   )
//# 2573 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraints));
//# 7731 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeConstraint in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2576 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2576 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraints));
//# 7742 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_intersectionConstraints in
            let _3 = parseState.GetInput(3) :?> 'gentype_atomType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2582 "src/Compiler/pars.fsy"
                             let constraints, mAmpersands = _1
                             match _3 with
                             | SynType.HashConstraint _ -> ()
                             | ty -> errorR(Error(FSComp.SR.parsConstraintIntersectionSyntaxUsedWithNonFlexibleType(), ty.Range))
                             (_3 :: constraints), (rhs parseState 2 :: mAmpersands) 
                   )
//# 2582 "src/Compiler/pars.fsy"
                 : 'gentype_intersectionConstraints));
//# 7758 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2591 "src/Compiler/pars.fsy"
                             match _1 with
                             | SynType.HashConstraint _ -> ()
                             | ty -> errorR(Error(FSComp.SR.parsConstraintIntersectionSyntaxUsedWithNonFlexibleType(), ty.Range))
                             [ _1 ], [] 
                   )
//# 2591 "src/Compiler/pars.fsy"
                 : 'gentype_intersectionConstraints));
//# 7772 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2601 "src/Compiler/pars.fsy"
                            if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyError (lhs parseState)
                            SynTypeConstraint.WhereTyparDefaultsToType(_2, _4, lhs parseState) 
                   )
//# 2601 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7785 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2605 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereTyparSubtypeOfType(_1, _3, lhs parseState) 
                   )
//# 2605 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7797 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2608 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereTyparIsValueType(_1, lhs parseState) 
                   )
//# 2608 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7808 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2611 "src/Compiler/pars.fsy"
                            if _3 <> "not" then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(_3))
                            SynTypeConstraint.WhereTyparIsReferenceType(_1, lhs parseState) 
                   )
//# 2611 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7821 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2615 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereTyparSupportsNull(_1, lhs parseState) 
                   )
//# 2615 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7832 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> 'gentype_classMemberSpfn in
            let _5 = parseState.GetInput(5) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2618 "src/Compiler/pars.fsy"
                            let tp = _1
                            SynTypeConstraint.WhereTyparSupportsMember(SynType.Var(tp, tp.Range), _4, lhs parseState) 
                   )
//# 2618 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7846 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeAlts in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            let _6 = parseState.GetInput(6) :?> 'gentype_classMemberSpfn in
            let _7 = parseState.GetInput(7) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2622 "src/Compiler/pars.fsy"
                            let mParen = rhs2 parseState 1 3
                            let t = SynType.Paren(_2, mParen)
                            SynTypeConstraint.WhereTyparSupportsMember(t, _6, lhs parseState) 
                   )
//# 2622 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7862 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> range * range option * SynType list * range list * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2627 "src/Compiler/pars.fsy"
                            let _ltm, _gtm, args, _commas, mWhole = _4
                            SynTypeConstraint.WhereTyparIsDelegate(_1, args, unionRanges _1.Range mWhole) 
                   )
//# 2627 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7875 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            let _4 = parseState.GetInput(4) :?> range * range option * SynType list * range list * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2631 "src/Compiler/pars.fsy"
                            match _3 with
                            | "enum" ->
                                let _ltm, _gtm, args, _commas, mWhole = _4
                                SynTypeConstraint.WhereTyparIsEnum(_1, args, unionRanges _1.Range mWhole)
                            | nm -> raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(nm)) 
                   )
//# 2631 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7892 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2638 "src/Compiler/pars.fsy"
                            match _3 with
                            | "comparison" -> SynTypeConstraint.WhereTyparIsComparable(_1, lhs parseState)
                            | "equality" -> SynTypeConstraint.WhereTyparIsEquatable(_1, lhs parseState)
                            | "unmanaged" -> SynTypeConstraint.WhereTyparIsUnmanaged(_1, lhs parseState)
                            | nm -> raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(nm)) 
                   )
//# 2638 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7908 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2645 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereSelfConstrained(_1, lhs parseState) 
                   )
//# 2645 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7919 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeAlts in
            let _3 = parseState.GetInput(3) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2649 "src/Compiler/pars.fsy"
                            let mOr = rhs parseState 2
                            let m = unionRanges _1.Range _3.Range
                            SynType.Or(_1, _3, m, { OrKeyword = mOr }) 
                   )
//# 2649 "src/Compiler/pars.fsy"
                 : 'gentype_typeAlts));
//# 7933 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2654 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 2654 "src/Compiler/pars.fsy"
                 : 'gentype_typeAlts));
//# 7944 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_barAndgrabXmlDoc in
            let _2 = parseState.GetInput(2) :?> 'gentype_attrUnionCaseDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2661 "src/Compiler/pars.fsy"
                            _2 _1 
                   )
//# 2661 "src/Compiler/pars.fsy"
                 : Choice<SynEnumCase, SynUnionCase> list));
//# 7956 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_firstUnionCaseDeclOfMany in
            let _2 = parseState.GetInput(2) :?> 'gentype_barAndgrabXmlDoc in
            let _3 = parseState.GetInput(3) :?> 'gentype_attrUnionCaseDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2664 "src/Compiler/pars.fsy"
                            _1 :: _3 _2 
                   )
//# 2664 "src/Compiler/pars.fsy"
                 : Choice<SynEnumCase, SynUnionCase> list));
//# 7969 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_firstUnionCaseDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2667 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2667 "src/Compiler/pars.fsy"
                 : Choice<SynEnumCase, SynUnionCase> list));
//# 7980 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2671 "src/Compiler/pars.fsy"
                            let mBar = rhs parseState 1
                            grabXmlDoc(parseState, [], 1), mBar 
                   )
//# 2671 "src/Compiler/pars.fsy"
                 : 'gentype_barAndgrabXmlDoc));
//# 7991 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attrUnionCaseDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_barAndgrabXmlDoc in
            let _3 = parseState.GetInput(3) :?> 'gentype_attrUnionCaseDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2676 "src/Compiler/pars.fsy"
                            (fun xmlDocAndBar -> _1 xmlDocAndBar :: _3 _2) 
                   )
//# 2676 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecls));
//# 8004 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attrUnionCaseDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2679 "src/Compiler/pars.fsy"
                            (fun xmlDocAndBar -> [ _1 xmlDocAndBar ]) 
                   )
//# 2679 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecls));
//# 8015 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2684 "src/Compiler/pars.fsy"
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields []) (rhs2 parseState 1 3) >> Choice2Of2 
                   )
//# 2684 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8028 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2687 "src/Compiler/pars.fsy"
                             fun (xmlDoc, mBar) -> mkSynUnionCase _1 _2 (SynIdent(mkSynId mBar.EndRange "", None)) (SynUnionCaseKind.Fields []) mBar (xmlDoc, mBar) |> Choice2Of2 
                   )
//# 2687 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8041 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2690 "src/Compiler/pars.fsy"
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields _5) (rhs2 parseState 1 5) >> Choice2Of2 
                   )
//# 2690 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8055 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _4 = parseState.GetInput(4) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2693 "src/Compiler/pars.fsy"
                             errorR (Error(FSComp.SR.parsMissingKeyword("of"), rhs2 parseState 3 4))
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields _4) (rhs2 parseState 1 4) >> Choice2Of2 
                   )
//# 2693 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8070 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2697 "src/Compiler/pars.fsy"
                             let mOf = rhs parseState 3
                             let mId = mOf.StartRange
                             errorR (Error(FSComp.SR.parsMissingUnionCaseName(), mOf))
                             mkSynUnionCase _1 _2 (SynIdent(mkSynId mId "", None)) (SynUnionCaseKind.Fields _4) (rhs2 parseState 1 4) >> Choice2Of2 
                   )
//# 2697 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8086 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2703 "src/Compiler/pars.fsy"
                             let mOf = rhs parseState 3
                             let mId = mOf.StartRange
                             errorR (Error(FSComp.SR.parsMissingUnionCaseName(), mOf))
                             mkSynUnionCase _1 _2 (SynIdent(mkSynId mId "", None)) (SynUnionCaseKind.Fields []) (rhs2 parseState 1 3) >> Choice2Of2 
                   )
//# 2703 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8102 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2709 "src/Compiler/pars.fsy"
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields []) (rhs2 parseState 1 4) >> Choice2Of2 
                   )
//# 2709 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8116 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2712 "src/Compiler/pars.fsy"
                             if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyWarning(lhs parseState)
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.FullType _5) (rhs2 parseState 1 5) >> Choice2Of2 
                   )
//# 2712 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8131 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> SynExpr * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2716 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsEnumFieldsCannotHaveVisibilityDeclarations(), rhs parseState 2))
                             let mEquals = rhs parseState 4
                             let mDecl = rhs2 parseState 1 5
                             (fun (xmlDoc, mBar) ->
                                 let trivia: SynEnumCaseTrivia = { BarRange = Some mBar; EqualsRange = mEquals }
                                 let mDecl = unionRangeWithXmlDoc xmlDoc mDecl
                                 Choice1Of2 (SynEnumCase (_1, _3, fst _5, xmlDoc, mDecl, trivia))) 
                   )
//# 2716 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8151 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_nameop in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2727 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2727 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseName));
//# 8162 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2730 "src/Compiler/pars.fsy"
                             let lpr = rhs parseState 1
                             let rpr = rhs parseState 3
                             SynIdent(ident(opNameCons, rhs parseState 2), Some(IdentTrivia.OriginalNotationWithParen(lpr, "::", rpr))) 
                   )
//# 2730 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseName));
//# 8175 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _4 = parseState.GetInput(4) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2735 "src/Compiler/pars.fsy"
                             let lpr = rhs parseState 1
                             let rpr = rhs parseState 3
                             SynIdent(ident(opNameNil, rhs2 parseState 2 3), Some(IdentTrivia.OriginalNotationWithParen(lpr, "[]", rpr))) 
                   )
//# 2735 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseName));
//# 8188 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2741 "src/Compiler/pars.fsy"
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc(parseState, [], 1)
                             let mDecl = (rhs parseState 1) |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2 (SynUnionCase ([], (SynIdent(_1, None)), SynUnionCaseKind.Fields [], xmlDoc, None, mDecl, trivia)) 
                   )
//# 2741 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8203 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> SynExpr * bool in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2747 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 2
                             let trivia: SynEnumCaseTrivia = { BarRange = None; EqualsRange = mEquals }
                             let xmlDoc = grabXmlDoc(parseState, [], 1)
                             let mDecl = (rhs2 parseState 1 3) |> unionRangeWithXmlDoc xmlDoc
                             Choice1Of2 (SynEnumCase ([], SynIdent(_1, None), fst _3, xmlDoc, mDecl, trivia)) 
                   )
//# 2747 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8220 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_firstUnionCaseDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2754 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2754 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8232 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2758 "src/Compiler/pars.fsy"
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mDecl = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2(SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields _3, xmlDoc, None, mDecl, trivia)) 
                   )
//# 2758 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8247 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2764 "src/Compiler/pars.fsy"
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mDecl = rhs2 parseState 1 2 |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2(SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields [], xmlDoc, None, mDecl, trivia)) 
                   )
//# 2764 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8262 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2770 "src/Compiler/pars.fsy"
                            let mOf = rhs parseState 1
                            let mId = mOf.StartRange
                            errorR (Error(FSComp.SR.parsMissingUnionCaseName(), mOf))
                            let id = SynIdent(mkSynId mId "", None)
                            let trivia: SynUnionCaseTrivia = { BarRange = None }
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            let mDecl = rhs2 parseState 1 2 |> unionRangeWithXmlDoc xmlDoc
                            Choice2Of2(SynUnionCase([], id, SynUnionCaseKind.Fields _2, xmlDoc, None, mDecl, trivia)) 
                   )
//# 2770 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8280 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> SynExpr * bool in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2780 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 2
                             let trivia: SynEnumCaseTrivia = { BarRange = None; EqualsRange = mEquals }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mDecl = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                             Choice1Of2(SynEnumCase([], SynIdent(_1, None), fst _3, xmlDoc, mDecl, trivia)) 
                   )
//# 2780 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8297 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElement in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseReprElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2788 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 2788 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElements));
//# 8309 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElement in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2791 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2791 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElements));
//# 8320 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2795 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                            mkSynNamedField (_1, _3, xmlDoc, mWhole) 
                   )
//# 2795 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8334 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_appType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2800 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            mkSynAnonField (_1, xmlDoc) 
                   )
//# 2800 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8346 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_invalidUseOfAppTypeFunction in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2804 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                            reportParseErrorAt (_3 : SynType).Range (FSComp.SR.tcUnexpectedFunTypeInUnionCaseField())
                            mkSynNamedField (_1, _3, xmlDoc, mWhole) 
                   )
//# 2804 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8361 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_invalidUseOfAppTypeFunction in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2810 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            reportParseErrorAt (_1 : SynType).Range (FSComp.SR.tcUnexpectedFunTypeInUnionCaseField())
                            mkSynAnonField (_1, xmlDoc) 
                   )
//# 2810 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8374 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_braceFieldDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2816 "src/Compiler/pars.fsy"
                            errorR(Deprecated(FSComp.SR.parsConsiderUsingSeparateRecordType(), lhs parseState))
                            _1 
                   )
//# 2816 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseRepr));
//# 8386 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2820 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 2820 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseRepr));
//# 8397 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recdFieldDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_recdFieldDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2825 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 2825 "src/Compiler/pars.fsy"
                 : 'gentype_recdFieldDeclList));
//# 8410 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recdFieldDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2828 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2828 "src/Compiler/pars.fsy"
                 : 'gentype_recdFieldDeclList));
//# 8422 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_fieldDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2833 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            let fld = _2 _1 None rangeStart None
                            let (SynField (a, b, c, d, e, xmlDoc, vis, mWhole, trivia)) = fld
                            if Option.isSome vis then errorR (Error (FSComp.SR.parsRecordFieldsCannotHaveVisibilityDeclarations (), rhs parseState 2))
                            let mWhole = unionRangeWithXmlDoc xmlDoc mWhole
                            SynField (a, b, c, d, e, xmlDoc, None, mWhole, trivia) 
                   )
//# 2833 "src/Compiler/pars.fsy"
                 : 'gentype_recdFieldDecl));
//# 8439 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Ident in
            let _5 = parseState.GetInput(5) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2843 "src/Compiler/pars.fsy"
                            mkSynField parseState (Some _3) (Some _5) _1 _2 
                   )
//# 2843 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8453 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2846 "src/Compiler/pars.fsy"
                            let mColon = rhs parseState 4
                            let t = SynType.FromParseError(mColon.EndRange)
                            mkSynField parseState (Some _3) (Some t) _1 _2 
                   )
//# 2846 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8469 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Ident in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2851 "src/Compiler/pars.fsy"
                            let t = SynType.FromParseError(_3.idRange.EndRange)
                            mkSynField parseState (Some _3) (Some t) _1 _2 
                   )
//# 2851 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8484 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2855 "src/Compiler/pars.fsy"
                            mkSynField parseState None None _1 _2 
                   )
//# 2855 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8497 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynExceptionDefnRepr in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2860 "src/Compiler/pars.fsy"
                            let mWith, optClassDefn = _2
                            SynExceptionDefn(_1, mWith, optClassDefn, (_1.Range, optClassDefn) ||> unionRangeWithListBy (fun cd -> cd.Range)) 
                   )
//# 2860 "src/Compiler/pars.fsy"
                 : SynExceptionDefn));
//# 8510 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_exconIntro in
            let _5 = parseState.GetInput(5) :?> 'gentype_exconRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2866 "src/Compiler/pars.fsy"
                             let m =
                                 match _5 with
                                 | None -> rhs2 parseState 1 4
                                 | Some p -> unionRanges (rangeOfLongIdent p) (rhs2 parseState 1 4)
                             SynExceptionDefnRepr(_2, _4, _5, PreXmlDoc.Empty, _3, m) 
                   )
//# 2866 "src/Compiler/pars.fsy"
                 : SynExceptionDefnRepr));
//# 8528 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2873 "src/Compiler/pars.fsy"
                             let m =
                                 match _3 with
                                 | Some access -> unionRanges (rhs parseState 1) access.Range
                                 | _ ->
                                 match _2 with
                                 | [] -> rhs parseState 1
                                 | attrs -> ((rhs parseState 1), attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                             let id = SynIdent(mkSynId m.EndRange "", None)
                             let unionCase = SynUnionCase([], id, SynUnionCaseKind.Fields [], PreXmlDoc.Empty, None, m, { BarRange = None })
                             SynExceptionDefnRepr(_2, unionCase, None, PreXmlDoc.Empty, _3, m) 
                   )
//# 2873 "src/Compiler/pars.fsy"
                 : SynExceptionDefnRepr));
//# 8550 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2890 "src/Compiler/pars.fsy"
                             SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields [], PreXmlDoc.Empty, None, lhs parseState, { BarRange = None }) 
                   )
//# 2890 "src/Compiler/pars.fsy"
                 : 'gentype_exconIntro));
//# 8561 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2893 "src/Compiler/pars.fsy"
                             SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields _3, PreXmlDoc.Empty, None, lhs parseState, { BarRange = None }) 
                   )
//# 2893 "src/Compiler/pars.fsy"
                 : 'gentype_exconIntro));
//# 8573 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2896 "src/Compiler/pars.fsy"
                             SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields [], PreXmlDoc.Empty, None, lhs parseState, { BarRange = None }) 
                   )
//# 2896 "src/Compiler/pars.fsy"
                 : 'gentype_exconIntro));
//# 8585 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2900 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2900 "src/Compiler/pars.fsy"
                 : 'gentype_exconRepr));
//# 8595 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2903 "src/Compiler/pars.fsy"
                            Some(_2.LongIdent) 
                   )
//# 2903 "src/Compiler/pars.fsy"
                 : 'gentype_exconRepr));
//# 8606 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> bool in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> 'gentype_localBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2911 "src/Compiler/pars.fsy"
                             let mLetKwd = rhs parseState 1
                             let isUse = _1
                             let isRec = _2
                             let leadingKeyword =
                                 if isRec then
                                     SynLeadingKeyword.LetRec(mLetKwd, rhs parseState 2)
                                 else
                                     SynLeadingKeyword.Let(mLetKwd)
                             let localBindingsLastRangeOpt, localBindingsBuilder = _3
                             // Calculate the precise range of the binding set, up to the end of the last r.h.s. expression
                             let bindingSetRange =
                                 match localBindingsLastRangeOpt with
                                 | None -> rhs2 parseState 1 2 (* there was some error - this will be an approximate range *)
                                 | Some lastRange -> unionRanges mLetKwd lastRange
                             // The first binding swallows any attributes prior to the 'let'
                             BindingSetPreAttrs(mLetKwd, isRec, isUse,
                                 (fun attrs vis ->
                                     let xmlDoc = grabXmlDoc(parseState, attrs, 1)
                                     // apply the builder
                                     let binds = localBindingsBuilder xmlDoc attrs vis leadingKeyword
                                     if not isRec && not (isNilOrSingleton binds) then
                                           reportParseErrorAt mLetKwd (FSComp.SR.parsLetAndForNonRecBindings())
                                     [], binds),
                                 bindingSetRange) 
                   )
//# 2911 "src/Compiler/pars.fsy"
                 : 'gentype_defnBindings));
//# 8642 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cPrototype in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2940 "src/Compiler/pars.fsy"
                             let bindRange = lhs parseState
                             BindingSetPreAttrs(bindRange, false, false, _1, bindRange) 
                   )
//# 2940 "src/Compiler/pars.fsy"
                 : 'gentype_defnBindings));
//# 8654 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2947 "src/Compiler/pars.fsy"
                             let mDoKwd = rhs parseState 1
                             let mWhole = unionRanges mDoKwd _2.Range
                             // any attributes prior to the 'let' are left free, e.g. become top-level attributes
                             // associated with the module, 'main' function or assembly depending on their target
                             BindingSetPreAttrs(mDoKwd, false, false, (fun attrs vis -> attrs, [mkSynDoBinding (vis, mDoKwd, _2, mWhole)]), mWhole) 
                   )
//# 2947 "src/Compiler/pars.fsy"
                 : 'gentype_doBinding));
//# 8669 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> bool in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> 'gentype_localBindings in
            let _4 = parseState.GetInput(4) :?> 'gentype_hardwhiteDefnBindingsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2957 "src/Compiler/pars.fsy"
                             let mLetKwd = rhs parseState 1
                             let isUse = _1
                             let isRec = _2
                             let leadingKeyword =
                                 if not isUse && isRec then
                                     SynLeadingKeyword.LetRec(mLetKwd, rhs parseState 2)
                                 elif isUse && not isRec then
                                     SynLeadingKeyword.Use mLetKwd
                                 elif isUse && isRec then
                                     SynLeadingKeyword.UseRec(mLetKwd, rhs parseState 2)
                                 else
                                     SynLeadingKeyword.Let(mLetKwd)
                             let report, mIn, _ = _4
                             report (if isUse then "use" else "let") mLetKwd // report unterminated error
                             let localBindingsLastRangeOpt, localBindingsBuilder = _3
                             // Calculate the precise range of the binding set, up to the end of the last r.h.s. expression
                             let bindingSetRange =
                                 match localBindingsLastRangeOpt with
                                 | None -> rhs parseState 1 (* there was some error - this will be an approximate range *)
                                 | Some lastRange -> unionRanges mLetKwd lastRange
                             // the first binding swallow any attributes prior to the 'let'
                             BindingSetPreAttrs(mLetKwd, isRec, isUse,
                               (fun attrs vis ->
                                 let xmlDoc = grabXmlDoc(parseState, attrs, 1)
                                 let binds = localBindingsBuilder xmlDoc attrs vis leadingKeyword
                                 if not isRec && not (isNilOrSingleton binds) then
                                     reportParseErrorAt mLetKwd (FSComp.SR.parsLetAndForNonRecBindings())
                                 [], binds),
                               bindingSetRange),
                               (unionRanges mLetKwd bindingSetRange),
                               mIn 
                   )
//# 2957 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteLetBindings));
//# 8713 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynExpr in
            let _3 = parseState.GetInput(3) :?> 'gentype_hardwhiteDefnBindingsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2997 "src/Compiler/pars.fsy"
                             let mDo = rhs parseState 1
                             let _, _, mDone = _3
                             let mAll = unionRanges mDo _2.Range
                             let seqPt = DebugPointAtBinding.NoneAtDo
                             // any attributes prior to the 'let' are left free, e.g. become top-level attributes
                             // associated with the module, 'main' function or assembly depending on their target
                             BindingSetPreAttrs(mDo, false, false, (fun attrs vis -> attrs, [mkSynDoBinding (vis, mDo, _2, mAll)]), mAll), _2 
                   )
//# 2997 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDoBinding));
//# 8731 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3006 "src/Compiler/pars.fsy"
                             let mDo = rhs parseState 1
                             reportParseErrorAt (rhs parseState 2) (FSComp.SR.parsExpectingExpression ())
                             let seqPt = DebugPointAtBinding.NoneAtDo
                             let expr = arbExpr ("hardwhiteDoBinding1", mDo.EndRange)
                             BindingSetPreAttrs(mDo, false, false, (fun attrs vis -> attrs, [mkSynDoBinding (vis, mDo, expr, mDo)]), mDo), expr 
                   )
//# 3006 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDoBinding));
//# 8746 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_defnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3015 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 3015 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 8757 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_doBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3018 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 3018 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 8768 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hardwhiteLetBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3021 "src/Compiler/pars.fsy"
                            let b, m, _ = _1
                            b 
                   )
//# 3021 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 8780 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hardwhiteDoBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3025 "src/Compiler/pars.fsy"
                            fst _1 
                   )
//# 3025 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 8791 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3031 "src/Compiler/pars.fsy"
                            let mToken = rhs parseState 1
                            // In LexFilter.fs the IN token could have been transformed to an ODECLEND one.
                            let mIn = if (mToken.EndColumn - mToken.StartColumn) = 2 then Some mToken else None
                            (fun _ m -> ()), mIn, Some _1 
                   )
//# 3031 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDefnBindingsTerminator));
//# 8805 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3037 "src/Compiler/pars.fsy"
                            (fun kwd m ->
                              let msg =
                                  match kwd with
                                  | "let!" -> FSComp.SR.parsUnmatchedLetBang()
                                  | "use!" -> FSComp.SR.parsUnmatchedUseBang()
                                  | "use" -> FSComp.SR.parsUnmatchedUse()
                                  | _ (*"let" *) -> FSComp.SR.parsUnmatchedLet()
                              reportParseErrorAt m msg), None, None 
                   )
//# 3037 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDefnBindingsTerminator));
//# 8823 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_cRetType in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _7 = parseState.GetInput(7) :?> 'gentype_externArgs in
            let _8 = parseState.GetInput(8) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3049 "src/Compiler/pars.fsy"
                             let mExtern = rhs parseState 1
                             let rty, vis, nm, (args, commas) = _2, _3, _4, _7
                             let nmm = rhs parseState 3
                             let argsm = rhs parseState 6
                             let mBindLhs = lhs parseState
                             let mWhole = lhs parseState
                             let mRhs = lhs parseState
                             let rhsExpr =
                                 SynExpr.App(
                                     ExprAtomicFlag.NonAtomic,
                                     false,
                                     SynExpr.Ident(ident("failwith", rhs parseState 6)),
                                     SynExpr.Const(SynConst.String("extern was not given a DllImport attribute", SynStringKind.Regular, rhs parseState 8), rhs parseState 8),
                                     mRhs)
                             (fun attrs _ ->
                                 let bindingPat = SynPat.LongIdent(SynLongIdent([nm], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [SynPat.Tuple(false, args, commas, argsm)], vis, nmm)
                                 let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let xmlDoc = grabXmlDoc(parseState, attrs, 1)
                                 let trivia = { LeadingKeyword = SynLeadingKeyword.Extern mExtern; InlineKeyword = None; EqualsRange = None }
                                 let binding =
                                     mkSynBinding
                                         (xmlDoc, bindingPat)
                                         (vis, false, false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, Some(None, rty), rhsExpr, mRhs, [], attrs, None, trivia)
                                 [], [binding]) 
                   )
//# 3049 "src/Compiler/pars.fsy"
                 : 'gentype_cPrototype));
//# 8862 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externMoreArgs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3077 "src/Compiler/pars.fsy"
                            let args, commas = _1
                            List.rev args, (List.rev commas) 
                   )
//# 3077 "src/Compiler/pars.fsy"
                 : 'gentype_externArgs));
//# 8874 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3081 "src/Compiler/pars.fsy"
                            [_1], [] 
                   )
//# 3081 "src/Compiler/pars.fsy"
                 : 'gentype_externArgs));
//# 8885 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3083 "src/Compiler/pars.fsy"
                            [], [] 
                   )
//# 3083 "src/Compiler/pars.fsy"
                 : 'gentype_externArgs));
//# 8895 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externMoreArgs in
            let _3 = parseState.GetInput(3) :?> 'gentype_externArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3089 "src/Compiler/pars.fsy"
                            let args, commas = _1
                            let mComma = rhs parseState 2
                            _3 :: args, (mComma :: commas) 
                   )
//# 3089 "src/Compiler/pars.fsy"
                 : 'gentype_externMoreArgs));
//# 8909 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externArg in
            let _3 = parseState.GetInput(3) :?> 'gentype_externArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3094 "src/Compiler/pars.fsy"
                            let mComma = rhs parseState 2
                            [_3; _1], [mComma] 
                   )
//# 3094 "src/Compiler/pars.fsy"
                 : 'gentype_externMoreArgs));
//# 8922 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3101 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynPat.Typed(SynPat.Wild m, _2, m) |> addAttribs _1 
                   )
//# 3101 "src/Compiler/pars.fsy"
                 : 'gentype_externArg));
//# 8935 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_cType in
            let _3 = parseState.GetInput(3) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3105 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynPat.Typed(SynPat.Named(SynIdent(_3, None), false, None, m), _2, m) |> addAttribs _1 
                   )
//# 3105 "src/Compiler/pars.fsy"
                 : 'gentype_externArg));
//# 8949 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3111 "src/Compiler/pars.fsy"
                            let m = _1.Range
                            SynType.App(SynType.LongIdent(_1), None, [], [], None, false, m) 
                   )
//# 3111 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 8961 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3115 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("[]", m)], [], [None])), None, [_1], [], None, true, m) 
                   )
//# 3115 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 8974 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3119 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("nativeptr", m)], [], [ Some(IdentTrivia.OriginalNotation "*") ])), None, [_1], [], None, true, m) 
                   )
//# 3119 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 8986 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3123 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("byref", m)], [], [ Some(IdentTrivia.OriginalNotation "&") ])), None, [_1], [], None, true, m) 
                   )
//# 3123 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 8998 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3127 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("nativeint", m)], [], [ Some(IdentTrivia.OriginalNotation "void*") ])), None, [], [], None, true, m) 
                   )
//# 3127 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9009 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3134 "src/Compiler/pars.fsy"
                            SynReturnInfo((_2, SynArgInfo(_1, false, None)), rhs parseState 2) 
                   )
//# 3134 "src/Compiler/pars.fsy"
                 : 'gentype_cRetType));
//# 9021 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3137 "src/Compiler/pars.fsy"
                            let m = rhs parseState 2
                            SynReturnInfo((SynType.App(SynType.LongIdent(SynLongIdent([ident("unit", m)], [], [ Some(IdentTrivia.OriginalNotation "void") ])), None, [], [], None, false, m), SynArgInfo(_1, false, None)), m) 
                   )
//# 3137 "src/Compiler/pars.fsy"
                 : 'gentype_cRetType));
//# 9033 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attr_localBinding in
            let _2 = parseState.GetInput(2) :?> 'gentype_moreLocalBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3143 "src/Compiler/pars.fsy"
                             let (moreBindings, moreBindingRanges) = List.unzip _2
                             let moreLocalBindingsLastRange = if moreBindingRanges.IsEmpty then None else Some(List.last moreBindingRanges)
                             match _1 with
                             | Some(localBindingRange, attrLocalBindingBuilder) ->
                                let lastRange =
                                    match moreLocalBindingsLastRange with
                                    | None -> localBindingRange
                                    | Some m -> m
                                Some lastRange, (fun xmlDoc attrs vis leadingKeyword -> attrLocalBindingBuilder xmlDoc attrs vis leadingKeyword true :: moreBindings)
                             | None ->
                                moreLocalBindingsLastRange, (fun _xmlDoc _attrs _vis _leadingKeyword -> moreBindings) 
                   )
//# 3143 "src/Compiler/pars.fsy"
                 : 'gentype_localBindings));
//# 9055 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_attr_localBinding in
            let _3 = parseState.GetInput(3) :?> 'gentype_moreLocalBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3158 "src/Compiler/pars.fsy"
                             let leadingKeyword = SynLeadingKeyword.And(rhs parseState 1)
                             (match _2 with
                              | Some(localBindingRange, attrLocalBindingBuilder) ->
                                 let xmlDoc = grabXmlDoc(parseState, [], 1)
                                 let xmlDoc = if xmlDoc.IsEmpty then grabXmlDoc(parseState, [], 2) else xmlDoc
                                 (attrLocalBindingBuilder xmlDoc [] None leadingKeyword false, localBindingRange) :: _3
                              | None -> _3) 
                   )
//# 3158 "src/Compiler/pars.fsy"
                 : 'gentype_moreLocalBindings));
//# 9073 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3167 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 3167 "src/Compiler/pars.fsy"
                 : 'gentype_moreLocalBindings));
//# 9083 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_localBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3173 "src/Compiler/pars.fsy"
                             let attrs2 = _1
                             let localBindingRange, localBindingBuilder = _2
                             let attrLocalBindingBuilder = (fun xmlDoc attrs vis leadingKeyword _ -> localBindingBuilder xmlDoc (attrs@attrs2) vis leadingKeyword)
                             Some(localBindingRange, attrLocalBindingBuilder) 
                   )
//# 3173 "src/Compiler/pars.fsy"
                 : 'gentype_attr_localBinding));
//# 9098 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3179 "src/Compiler/pars.fsy"
                             None 
                   )
//# 3179 "src/Compiler/pars.fsy"
                 : 'gentype_attr_localBinding));
//# 9108 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _6 = parseState.GetInput(6) :?> 'gentype_typedExprWithStaticOptimizationsBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3185 "src/Compiler/pars.fsy"
                             let (expr: SynExpr), opts = _6
                             let mEquals = rhs parseState 5
                             let mRhs = expr.Range
                             let optReturnType = _4
                             let bindingPat, mBindLhs = _3
                             let localBindingRange = unionRanges (rhs2 parseState 1 5) mRhs
                             let localBindingBuilder =
                               (fun xmlDoc attrs vis (leadingKeyword: SynLeadingKeyword) ->
                                 let mWhole = (unionRanges leadingKeyword.Range mRhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let spBind = if IsDebugPointBinding bindingPat expr then DebugPointAtBinding.Yes mWhole else DebugPointAtBinding.NoneAtLet
                                 let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = Some mEquals }
                                 mkSynBinding (xmlDoc, bindingPat) (vis, Option.isSome _1, Option.isSome _2, mWholeBindLhs, spBind, optReturnType, expr, mRhs, opts, attrs, None, trivia))
                             localBindingRange, localBindingBuilder 
                   )
//# 3185 "src/Compiler/pars.fsy"
                 : 'gentype_localBinding));
//# 9136 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3201 "src/Compiler/pars.fsy"
                             let mWhole = rhs2 parseState 1 5
                             let mRhs = rhs parseState 5
                             let optReturnType = _4
                             let bindingPat, mBindLhs = _3
                             let localBindingBuilder =
                               (fun xmlDoc attrs vis leadingKeyword ->
                                 let mEquals = rhs parseState 5
                                 let zeroWidthAtEnd = mEquals.EndRange
                                 let rhsExpr = arbExpr ("localBinding1", zeroWidthAtEnd)
                                 let spBind = if IsDebugPointBinding bindingPat rhsExpr then DebugPointAtBinding.Yes mWhole else DebugPointAtBinding.NoneAtLet
                                 let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = Some mEquals }
                                 mkSynBinding (xmlDoc, bindingPat) (vis, Option.isSome _1, Option.isSome _2, mBindLhs, spBind, optReturnType, rhsExpr, mRhs, [], attrs, None, trivia))
                             mWhole, localBindingBuilder 
                   )
//# 3201 "src/Compiler/pars.fsy"
                 : 'gentype_localBinding));
//# 9162 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3216 "src/Compiler/pars.fsy"
                             if not _5 then reportParseErrorAt (rhs parseState 5) (FSComp.SR.parsUnexpectedEndOfFileDefinition())
                             let optReturnType = _4
                             let mWhole = rhs2 parseState 1 (match optReturnType with None -> 3 | _ -> 4)
                             let mRhs = mWhole.EndRange // zero-width range at end of last good token
                             let bindingPat, mBindLhs = _3
                             let localBindingBuilder =
                               (fun xmlDoc attrs vis (leadingKeyword: SynLeadingKeyword) ->
                                 let spBind = DebugPointAtBinding.Yes(unionRanges leadingKeyword.Range mRhs)
                                 let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = None }
                                 let rhsExpr = arbExpr ("localBinding2", mRhs)
                                 mkSynBinding (xmlDoc, bindingPat) (vis, Option.isSome _1, Option.isSome _2, mBindLhs, spBind, optReturnType, rhsExpr, mRhs, [], attrs, None, trivia))
                             mWhole, localBindingBuilder 
                   )
//# 3216 "src/Compiler/pars.fsy"
                 : 'gentype_localBinding));
//# 9188 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typedExprWithStaticOptimizations in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3232 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 3232 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizationsBlock));
//# 9200 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typedExprWithStaticOptimizations in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3235 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFile())
                             let a, b = _2
                             (exprFromParseError a, b) 
                   )
//# 3235 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizationsBlock));
//# 9214 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typedExprWithStaticOptimizations in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3240 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3240 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizationsBlock));
//# 9225 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typedSequentialExpr in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_staticOptimizations in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3244 "src/Compiler/pars.fsy"
                             _1, List.rev _2 
                   )
//# 3244 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizations));
//# 9237 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_staticOptimizations in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticOptimization in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3248 "src/Compiler/pars.fsy"
                             _2 :: _1 
                   )
//# 3248 "src/Compiler/pars.fsy"
                 : 'gentype_opt_staticOptimizations));
//# 9249 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3251 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 3251 "src/Compiler/pars.fsy"
                 : 'gentype_opt_staticOptimizations));
//# 9259 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_staticOptimizationConditions in
            let _4 = parseState.GetInput(4) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3255 "src/Compiler/pars.fsy"
                             (_2, _4) 
                   )
//# 3255 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimization));
//# 9271 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_staticOptimizationConditions in
            let _3 = parseState.GetInput(3) :?> 'gentype_staticOptimizationCondition in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3259 "src/Compiler/pars.fsy"
                             _3 :: _1 
                   )
//# 3259 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationConditions));
//# 9283 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_staticOptimizationCondition in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3262 "src/Compiler/pars.fsy"
                             [_1 ] 
                   )
//# 3262 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationConditions));
//# 9294 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3266 "src/Compiler/pars.fsy"
                             SynStaticOptimizationConstraint.WhenTyparTyconEqualsTycon(_1, _3, lhs parseState) 
                   )
//# 3266 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationCondition));
//# 9306 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3269 "src/Compiler/pars.fsy"
                             SynStaticOptimizationConstraint.WhenTyparIsStruct(_1, lhs parseState) 
                   )
//# 3269 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationCondition));
//# 9317 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> sbyte * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3273 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideEightBitSigned(), lhs parseState))
                           SynConst.SByte(fst _1) 
                   )
//# 3273 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9329 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> byte in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3277 "src/Compiler/pars.fsy"
                           SynConst.Byte _1 
                   )
//# 3277 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9340 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int16 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3280 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideSixteenBitSigned(), lhs parseState))
                           SynConst.Int16 (fst _1) 
                   )
//# 3280 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9352 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint16 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3284 "src/Compiler/pars.fsy"
                           SynConst.UInt16 _1 
                   )
//# 3284 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9363 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3287 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynConst.Int32 (fst _1) 
                   )
//# 3287 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9375 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3291 "src/Compiler/pars.fsy"
                           SynConst.UInt32 _1 
                   )
//# 3291 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9386 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int64 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3294 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideSixtyFourBitSigned(), lhs parseState))
                           SynConst.Int64 (fst _1) 
                   )
//# 3294 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9398 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3298 "src/Compiler/pars.fsy"
                           SynConst.UInt64 _1 
                   )
//# 3298 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9409 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int64 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3301 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideNativeSigned(), lhs parseState))
                           SynConst.IntPtr(fst _1) 
                   )
//# 3301 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9421 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3305 "src/Compiler/pars.fsy"
                           SynConst.UIntPtr _1 
                   )
//# 3305 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9432 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> single in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3308 "src/Compiler/pars.fsy"
                           SynConst.Single _1 
                   )
//# 3308 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9443 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> double in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3311 "src/Compiler/pars.fsy"
                           SynConst.Double _1 
                   )
//# 3311 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9454 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> char in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3314 "src/Compiler/pars.fsy"
                           SynConst.Char _1 
                   )
//# 3314 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9465 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> System.Decimal in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3317 "src/Compiler/pars.fsy"
                           SynConst.Decimal _1 
                   )
//# 3317 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9476 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> (string * string) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3320 "src/Compiler/pars.fsy"
                           SynConst.UserNum _1 
                   )
//# 3320 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9487 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3323 "src/Compiler/pars.fsy"
                           let s, synStringKind = _1
                           SynConst.String(s, synStringKind, lhs parseState) 
                   )
//# 3323 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9499 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_sourceIdentifier in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3327 "src/Compiler/pars.fsy"
                           let c, v = _1
                           SynConst.SourceIdentifier(c, v, lhs parseState) 
                   )
//# 3327 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9511 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> byte[] * SynByteStringKind * ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3331 "src/Compiler/pars.fsy"
                           let (v, synByteStringKind, _) = _1
                           SynConst.Bytes(v, synByteStringKind, lhs parseState) 
                   )
//# 3331 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9523 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            let _2 = parseState.GetInput(2) :?> string in
            let _3 = parseState.GetInput(3) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3336 "src/Compiler/pars.fsy"
                           if _2 <> "/" then reportParseErrorAt (rhs parseState 2) (FSComp.SR.parsUnexpectedOperatorForUnitOfMeasure())
                           if fst _3 = 0 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsIllegalDenominatorForMeasureExponent())
                           if (snd _1) || (snd _3) then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Rational(fst _1, rhs parseState 1, rhs parseState 2, fst _3, rhs parseState 3, lhs parseState) 
                   )
//# 3336 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9539 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> int32 * bool in
            let _3 = parseState.GetInput(3) :?> string in
            let _4 = parseState.GetInput(4) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3342 "src/Compiler/pars.fsy"
                           if _3 <> "/" then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedOperatorForUnitOfMeasure())
                           if fst _4 = 0 then reportParseErrorAt (rhs parseState 4) (FSComp.SR.parsIllegalDenominatorForMeasureExponent())
                           if (snd _2) || (snd _4) then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Negate(SynRationalConst.Rational(fst _2, rhs parseState 2, rhs parseState 3, fst _4, rhs parseState 4, lhs parseState), lhs parseState) 
                   )
//# 3342 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9555 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3348 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Integer(fst _1, lhs parseState) 
                   )
//# 3348 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9567 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3352 "src/Compiler/pars.fsy"
                           if snd _2 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Negate(SynRationalConst.Integer(fst _2, rhs parseState 2), lhs parseState) 
                   )
//# 3352 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9579 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3356 "src/Compiler/pars.fsy"
                                 if snd _1 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                                 SynRationalConst.Integer(fst _1, lhs parseState) 
                   )
//# 3356 "src/Compiler/pars.fsy"
                 : 'gentype_atomicUnsignedRationalConstant));
//# 9591 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_rationalConstant in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3360 "src/Compiler/pars.fsy"
                           SynRationalConst.Paren(_2, rhs2 parseState 1 3) 
                   )
//# 3360 "src/Compiler/pars.fsy"
                 : 'gentype_atomicUnsignedRationalConstant));
//# 9603 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicUnsignedRationalConstant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3363 "src/Compiler/pars.fsy"
                                                          _1 
                   )
//# 3363 "src/Compiler/pars.fsy"
                 : 'gentype_atomicRationalConstant));
//# 9614 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_atomicUnsignedRationalConstant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3366 "src/Compiler/pars.fsy"
                           SynRationalConst.Negate(_2, lhs parseState) 
                   )
//# 3366 "src/Compiler/pars.fsy"
                 : 'gentype_atomicRationalConstant));
//# 9625 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_rawConstant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3370 "src/Compiler/pars.fsy"
                           _1, rhs parseState 1 
                   )
//# 3370 "src/Compiler/pars.fsy"
                 : 'gentype_constant));
//# 9636 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_rawConstant in
            let _3 = parseState.GetInput(3) :?> 'gentype_measureTypeArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3373 "src/Compiler/pars.fsy"
                           let synMeasure, trivia = _3 
                           let mConstant = rhs parseState 1
                           let m = unionRanges mConstant trivia.GreaterRange
                           SynConst.Measure(_1, rhs parseState 1, synMeasure, trivia), m 
                   )
//# 3373 "src/Compiler/pars.fsy"
                 : 'gentype_constant));
//# 9651 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3380 "src/Compiler/pars.fsy"
                           _1, rhs parseState 1 
                   )
//# 3380 "src/Compiler/pars.fsy"
                 : 'gentype_bindingPattern));
//# 9662 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3387 "src/Compiler/pars.fsy"
                             let m = rhs parseState 1
                             SynPat.Named(SynIdent(_1, None), false, None, m) 
                   )
//# 3387 "src/Compiler/pars.fsy"
                 : 'gentype_simplePattern));
//# 9674 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3391 "src/Compiler/pars.fsy"
                             SynPat.OptionalVal(_2, rhs parseState 2) 
                   )
//# 3391 "src/Compiler/pars.fsy"
                 : 'gentype_simplePattern));
//# 9685 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_simplePattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3394 "src/Compiler/pars.fsy"
                             SynPat.Typed(_1, _3, lhs parseState) 
                   )
//# 3394 "src/Compiler/pars.fsy"
                 : 'gentype_simplePattern));
//# 9697 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_simplePattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3397 "src/Compiler/pars.fsy"
                             let mColon = rhs parseState 2
                             let ty = SynType.FromParseError(mColon.EndRange)
                             SynPat.Typed(_1, ty, unionRanges _1.Range mColon) 
                   )
//# 3397 "src/Compiler/pars.fsy"
                 : 'gentype_simplePattern));
//# 9711 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_simplePattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3402 "src/Compiler/pars.fsy"
                             SynPat.Attrib(_2, _1, lhs parseState) 
                   )
//# 3402 "src/Compiler/pars.fsy"
                 : 'gentype_simplePattern));
//# 9723 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_simplePattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3406 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3406 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatternCommaList));
//# 9734 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_simplePattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_simplePatternCommaList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3409 "src/Compiler/pars.fsy"
                             let mComma = rhs parseState 2
                             match _3 with
                             | SynPat.Tuple(_, pats, commas, _) -> SynPat.Tuple(false, _1 :: pats, mComma :: commas, rhs2 parseState 1 3)
                             | _ -> SynPat.Tuple(false, [_1; _3], [mComma], rhs2 parseState 1 3) 
                   )
//# 3409 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatternCommaList));
//# 9749 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_simplePatterns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3416 "src/Compiler/pars.fsy"
                             Some _1 
                   )
//# 3416 "src/Compiler/pars.fsy"
                 : 'gentype_opt_simplePatterns));
//# 9760 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3418 "src/Compiler/pars.fsy"
                           None 
                   )
//# 3418 "src/Compiler/pars.fsy"
                 : 'gentype_opt_simplePatterns));
//# 9770 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_simplePatternCommaList in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3422 "src/Compiler/pars.fsy"
                             let parenPat = SynPat.Paren(_2, rhs2 parseState 1 3)
                             let simplePats, _ = SimplePatsOfPat parseState.SynArgNameGenerator parenPat
                             simplePats 
                   )
//# 3422 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 9784 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3427 "src/Compiler/pars.fsy"
                             let pat = SynPat.Const(SynConst.Unit, rhs2 parseState 1 2)
                             let simplePats, _ = SimplePatsOfPat parseState.SynArgNameGenerator pat
                             simplePats 
                   )
//# 3427 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 9797 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_simplePatternCommaList in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3432 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedParen())
                             let parenPat = SynPat.Paren(SynPat.Tuple(false, [], [], rhs2 parseState 1 2), rhs2 parseState 1 2) // todo: report parsed pats anyway?
                             let simplePats, _ = SimplePatsOfPat parseState.SynArgNameGenerator parenPat
                             simplePats 
                   )
//# 3432 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 9812 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3438 "src/Compiler/pars.fsy"
                             let parenPat = SynPat.Paren(SynPat.Wild(rhs parseState 2), rhs2 parseState 1 3) // silent recovery
                             let simplePats, _ = SimplePatsOfPat parseState.SynArgNameGenerator parenPat
                             simplePats 
                   )
//# 3438 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 9825 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3443 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedParen())
                             let pat = SynPat.Wild(lhs parseState)
                             let simplePats, _ = SimplePatsOfPat parseState.SynArgNameGenerator pat
                             simplePats 
                   )
//# 3443 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 9839 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> 'gentype_constrPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3451 "src/Compiler/pars.fsy"
                             SynPat.As(_1, _3, rhs2 parseState 1 3) 
                   )
//# 3451 "src/Compiler/pars.fsy"
                 : SynPat));
//# 9851 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3454 "src/Compiler/pars.fsy"
                             let mBar = rhs parseState 2
                             SynPat.Or(_1, _3, rhs2 parseState 1 3, { BarRange = mBar }) 
                   )
//# 3454 "src/Compiler/pars.fsy"
                 : SynPat));
//# 9864 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3458 "src/Compiler/pars.fsy"
                             let mColonColon = rhs parseState 2
                             SynPat.ListCons(_1, _3, rhs2 parseState 1 3, { ColonColonRange = mColonColon }) 
                   )
//# 3458 "src/Compiler/pars.fsy"
                 : SynPat));
//# 9877 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tuplePatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3462 "src/Compiler/pars.fsy"
                             let pats, commas = _1
                             let pats, commas = normalizeTuplePat pats commas
                             let m = (rhs parseState 1, pats) ||> unionRangeWithListBy (fun p -> p.Range)
                             SynPat.Tuple(false, List.rev pats, List.rev commas, m) 
                   )
//# 3462 "src/Compiler/pars.fsy"
                 : SynPat));
//# 9891 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_conjPatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3468 "src/Compiler/pars.fsy"
                             SynPat.Ands(List.rev _1, lhs parseState) 
                   )
//# 3468 "src/Compiler/pars.fsy"
                 : SynPat));
//# 9902 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_constrPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3471 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3471 "src/Compiler/pars.fsy"
                 : SynPat));
//# 9913 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tuplePatternElements in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3475 "src/Compiler/pars.fsy"
                             let pats, commas = _1
                             _3 :: pats, (rhs parseState 2 :: commas) 
                   )
//# 3475 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 9926 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3479 "src/Compiler/pars.fsy"
                             [_3; _1], [rhs parseState 2] 
                   )
//# 3479 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 9938 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tuplePatternElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3482 "src/Compiler/pars.fsy"
                               let pats, commas = _1
                               let commaRange = rhs parseState 2
                               reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern ())
                               let pat2 = SynPat.Wild(commaRange.EndRange)
                               pat2 :: pats, (commaRange :: commas) 
                   )
//# 3482 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 9954 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3489 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 2
                             reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern ())
                             let pat2 = SynPat.Wild(commaRange.EndRange)
                             [pat2; _1], [commaRange] 
                   )
//# 3489 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 9969 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3495 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 1
                             reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern ())
                             let pat1 = SynPat.Wild(commaRange.StartRange)
                             [_2; pat1], [commaRange] 
                   )
//# 3495 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 9983 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3501 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 1
                             if not _2 then reportParseErrorAt commaRange (FSComp.SR.parsExpectedPatternAfterToken ())
                             let pat1 = SynPat.Wild(commaRange.StartRange)
                             let pat2 = SynPat.Wild(commaRange.EndRange)
                             [pat2; pat1], [commaRange] 
                   )
//# 3501 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 9998 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_conjPatternElements in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3509 "src/Compiler/pars.fsy"
                            _3 :: _1 
                   )
//# 3509 "src/Compiler/pars.fsy"
                 : 'gentype_conjPatternElements));
//# 10010 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3512 "src/Compiler/pars.fsy"
                            _3 :: _1 :: [] 
                   )
//# 3512 "src/Compiler/pars.fsy"
                 : 'gentype_conjPatternElements));
//# 10022 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namePatPair in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3516 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 3516 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPairs));
//# 10034 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namePatPair in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_namePatPairs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3519 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 3519 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPairs));
//# 10047 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namePatPair in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_seps in
            let _4 = parseState.GetInput(4) :?> 'gentype_namePatPairs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3522 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsExpectingPattern ())
                             (_1 :: _4) 
                   )
//# 3522 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPairs));
//# 10062 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3527 "src/Compiler/pars.fsy"
                            let mEquals = rhs parseState 2
                            _1, Some mEquals, _3 
                   )
//# 3527 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPair));
//# 10075 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3531 "src/Compiler/pars.fsy"
                            let mEquals = rhs parseState 2
                            _1, Some mEquals, patFromParseError (SynPat.Wild mEquals.EndRange) 
                   )
//# 3531 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPair));
//# 10088 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3535 "src/Compiler/pars.fsy"
                            _1, None, patFromParseError (SynPat.Wild _1.idRange.EndRange) 
                   )
//# 3535 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPair));
//# 10100 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3539 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             SynPat.LongIdent(lid, None, Some _2, SynArgPats.Pats [], vis, lhs parseState) 
                   )
//# 3539 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10113 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            let _3 = parseState.GetInput(3) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3543 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _3
                             let m = unionRanges (rhs2 parseState 1 2) argsM
                             SynPat.LongIdent(lid, None, Some _2, args, vis, m) 
                   )
//# 3543 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10129 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            let _4 = parseState.GetInput(4) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3549 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _4
                             let m = unionRanges (rhs2 parseState 1 2) argsM
                             SynPat.LongIdent(lid, None, Some _2, args, vis, m) 
                   )
//# 3549 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10145 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            let _4 = parseState.GetInput(4) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3555 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _4
                             let m = unionRanges (rhs2 parseState 1 2) argsM
                             SynPat.LongIdent(lid, None, Some _2, args, vis, m) 
                   )
//# 3555 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10161 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3561 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _2
                             let m = unionRanges (rhs parseState 1) argsM
                             SynPat.LongIdent(lid, None, None, args, vis, m) 
                   )
//# 3561 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10176 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _3 = parseState.GetInput(3) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3567 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _3
                             let m = unionRanges (rhs parseState 1) argsM
                             SynPat.LongIdent(lid, None, None, args, vis, m) 
                   )
//# 3567 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10191 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _3 = parseState.GetInput(3) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3573 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _3
                             let m = unionRanges (rhs parseState 1) argsM
                             SynPat.LongIdent(lid, None, None, args, vis, m) 
                   )
//# 3573 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10206 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_atomTypeOrAnonRecdType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3579 "src/Compiler/pars.fsy"
                             SynPat.IsInst(_2, lhs parseState) 
                   )
//# 3579 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10217 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3582 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3582 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10228 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_namePatPairs in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3586 "src/Compiler/pars.fsy"
                             let mParen = rhs2 parseState 1 3
                             let trivia = { ParenRange = mParen }
                             SynArgPats.NamePatPairs(_2, rhs parseState 2, trivia), mParen 
                   )
//# 3586 "src/Compiler/pars.fsy"
                 : SynArgPats * range));
//# 10242 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3591 "src/Compiler/pars.fsy"
                             let mParsed = rhs parseState 1
                             let mAll = (mParsed.StartRange, _1) ||> unionRangeWithListBy (fun p -> p.Range)
                             SynArgPats.Pats _1, mAll 
                   )
//# 3591 "src/Compiler/pars.fsy"
                 : SynArgPats * range));
//# 10255 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPattern in
            let _2 = parseState.GetInput(2) :?> SynPat list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3597 "src/Compiler/pars.fsy"
                             _1 :: _2 
                   )
//# 3597 "src/Compiler/pars.fsy"
                 : SynPat list));
//# 10267 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPattern in
            let _3 = parseState.GetInput(3) :?> SynPat list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3600 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsSuccessivePatternsShouldBeSpacedOrTupled())
                             _1 :: _3 
                   )
//# 3600 "src/Compiler/pars.fsy"
                 : SynPat list));
//# 10280 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPattern in
            let _3 = parseState.GetInput(3) :?> SynPat list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3604 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsSuccessivePatternsShouldBeSpacedOrTupled())
                             _1 :: _3 
                   )
//# 3604 "src/Compiler/pars.fsy"
                 : SynPat list));
//# 10293 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3608 "src/Compiler/pars.fsy"
                             [_1] 
                   )
//# 3608 "src/Compiler/pars.fsy"
                 : SynPat list));
//# 10304 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_quoteExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3613 "src/Compiler/pars.fsy"
                             SynPat.QuoteExpr(_1, lhs parseState) 
                   )
//# 3613 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10315 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_recordPatternElementsAux in
            let _3 = parseState.GetInput(3) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3616 "src/Compiler/pars.fsy"
                             SynPat.Record(_2, rhs2 parseState 1 3) 
                   )
//# 3616 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10328 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _3 = parseState.GetInput(3) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3619 "src/Compiler/pars.fsy"
                             SynPat.Record([], rhs2 parseState 1 3) 
                   )
//# 3619 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10340 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_listPatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3622 "src/Compiler/pars.fsy"
                             SynPat.ArrayOrList(false, _2, lhs parseState) 
                   )
//# 3622 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10351 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_listPatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3625 "src/Compiler/pars.fsy"
                             SynPat.ArrayOrList(true, _2, lhs parseState) 
                   )
//# 3625 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10362 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3628 "src/Compiler/pars.fsy"
                             SynPat.Wild(lhs parseState) 
                   )
//# 3628 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10372 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3631 "src/Compiler/pars.fsy"
                             SynPat.OptionalVal(_2, lhs parseState) 
                   )
//# 3631 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10383 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3634 "src/Compiler/pars.fsy"
                             let vis, lidwd = _1
                             if not (isNilOrSingleton lidwd.LongIdent) || String.isLeadingIdentifierCharacterUpperCase (List.head lidwd.LongIdent).idText then
                                 mkSynPatMaybeVar lidwd vis (lhs parseState)
                             else
                                let synIdent = List.head lidwd.IdentsWithTrivia
                                let (SynIdent(id, _)) = synIdent
                                SynPat.Named(synIdent, false, vis, id.idRange) 
                   )
//# 3634 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10400 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_constant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3643 "src/Compiler/pars.fsy"
                             SynPat.Const(fst _1, snd _1) 
                   )
//# 3643 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10411 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3646 "src/Compiler/pars.fsy"
                             SynPat.Const(SynConst.Bool false, lhs parseState) 
                   )
//# 3646 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10421 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3649 "src/Compiler/pars.fsy"
                             SynPat.Const(SynConst.Bool true, lhs parseState) 
                   )
//# 3649 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10431 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3652 "src/Compiler/pars.fsy"
                             SynPat.Null(lhs parseState) 
                   )
//# 3652 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10441 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_parenPatternBody in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3655 "src/Compiler/pars.fsy"
                             let m = lhs parseState
                             SynPat.Paren(_2 m, m) 
                   )
//# 3655 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10454 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_parenPatternBody in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3659 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedParen())
                             let m = rhs2 parseState 1 2
                             let parenPat = SynPat.Paren(_2 m, m)
                             patFromParseError parenPat 
                   )
//# 3659 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10469 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3665 "src/Compiler/pars.fsy"
                             let innerPat = patFromParseError (SynPat.Wild(rhs parseState 2))
                             SynPat.Paren(innerPat, lhs parseState) 
                   )
//# 3665 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10481 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3669 "src/Compiler/pars.fsy"
                             let parenM = rhs parseState 1
                             reportParseErrorAt parenM (FSComp.SR.parsUnmatchedParen())
                             let innerPat = patFromParseError (SynPat.Wild parenM.EndRange)
                             let parenPat = SynPat.Paren(innerPat, parenM)
                             patFromParseError parenPat 
                   )
//# 3669 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10496 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_tupleParenPatternElements in
            let _4 = parseState.GetInput(4) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3676 "src/Compiler/pars.fsy"
                             let pats, commas = _3
                             SynPat.Tuple(true, List.rev pats, List.rev commas, lhs parseState) 
                   )
//# 3676 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10509 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_tupleParenPatternElements in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3680 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 2) (FSComp.SR.parsUnmatchedParen())
                             let pats, commas = _3
                             SynPat.Tuple(true, List.rev pats, List.rev commas, lhs parseState) 
                   )
//# 3680 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10523 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _4 = parseState.GetInput(4) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3685 "src/Compiler/pars.fsy"
                             (* silent recovery *) SynPat.Wild(lhs parseState) 
                   )
//# 3685 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10534 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3688 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 2) (FSComp.SR.parsUnmatchedParen())
                             SynPat.Wild(lhs parseState) 
                   )
//# 3688 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPattern));
//# 10546 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3693 "src/Compiler/pars.fsy"
                             (fun m -> _1) 
                   )
//# 3693 "src/Compiler/pars.fsy"
                 : 'gentype_parenPatternBody));
//# 10557 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3696 "src/Compiler/pars.fsy"
                             (fun m -> SynPat.Const(SynConst.Unit, m)) 
                   )
//# 3696 "src/Compiler/pars.fsy"
                 : 'gentype_parenPatternBody));
//# 10567 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_constrPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3725 "src/Compiler/pars.fsy"
                             SynPat.As(_1, _3, rhs2 parseState 1 3) 
                   )
//# 3725 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10579 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3728 "src/Compiler/pars.fsy"
                             let mBar = rhs parseState 2
                             SynPat.Or(_1, _3, rhs2 parseState 1 3, { BarRange = mBar }) 
                   )
//# 3728 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10592 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tupleParenPatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3732 "src/Compiler/pars.fsy"
                             let pats, commas = _1
                             let pats, commas = normalizeTuplePat pats commas
                             let m = (rhs parseState 1, pats) ||> unionRangeWithListBy (fun p -> p.Range)
                             SynPat.Tuple(false, List.rev pats, List.rev commas, m) 
                   )
//# 3732 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10606 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_conjParenPatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3738 "src/Compiler/pars.fsy"
                             SynPat.Ands(List.rev _1, rhs2 parseState 1 3) 
                   )
//# 3738 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10617 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3741 "src/Compiler/pars.fsy"
                             let mLhs = lhs parseState
                             SynPat.Typed(_1, _3, mLhs) 
                   )
//# 3741 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10630 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3745 "src/Compiler/pars.fsy"
                             let mColon = rhs parseState 2
                             let ty = SynType.FromParseError(mColon.EndRange)
                             SynPat.Typed(_1, ty, unionRanges _1.Range mColon) 
                   )
//# 3745 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10644 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3750 "src/Compiler/pars.fsy"
                             let mLhs = lhs parseState
                             SynPat.Attrib(_2, _1, mLhs) 
                   )
//# 3750 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10657 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3754 "src/Compiler/pars.fsy"
                             let mColonColon = rhs parseState 2
                             SynPat.ListCons(_1, _3, rhs2 parseState 1 3, { ColonColonRange = mColonColon }) 
                   )
//# 3754 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10670 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_constrPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3757 "src/Compiler/pars.fsy"
                                         _1 
                   )
//# 3757 "src/Compiler/pars.fsy"
                 : 'gentype_parenPattern));
//# 10681 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tupleParenPatternElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3761 "src/Compiler/pars.fsy"
                             let pats, commas = _1
                             let mComma = rhs parseState 2
                             _3 :: pats, (mComma :: commas) 
                   )
//# 3761 "src/Compiler/pars.fsy"
                 : 'gentype_tupleParenPatternElements));
//# 10695 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3766 "src/Compiler/pars.fsy"
                             let mComma = rhs parseState 2
                             [_3; _1], [mComma] 
                   )
//# 3766 "src/Compiler/pars.fsy"
                 : 'gentype_tupleParenPatternElements));
//# 10708 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tupleParenPatternElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3770 "src/Compiler/pars.fsy"
                               let pats, commas = _1
                               let commaRange = rhs parseState 2
                               reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern())
                               let pat2 = SynPat.Wild(commaRange.EndRange)
                               pat2 :: pats, (commaRange :: commas) 
                   )
//# 3770 "src/Compiler/pars.fsy"
                 : 'gentype_tupleParenPatternElements));
//# 10724 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3777 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 2
                             reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern())
                             let pat2 = SynPat.Wild(commaRange.EndRange)
                             [pat2; _1], [commaRange] 
                   )
//# 3777 "src/Compiler/pars.fsy"
                 : 'gentype_tupleParenPatternElements));
//# 10739 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3783 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 1
                             reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern())
                             let pat1 = SynPat.Wild(commaRange.StartRange)
                             [_2; pat1], [commaRange] 
                   )
//# 3783 "src/Compiler/pars.fsy"
                 : 'gentype_tupleParenPatternElements));
//# 10753 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3789 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 1
                             if not _2 then reportParseErrorAt commaRange (FSComp.SR.parsExpectedPatternAfterToken ())
                             let pat1 = SynPat.Wild(commaRange.StartRange)
                             let pat2 = SynPat.Wild(commaRange.EndRange)
                             [pat2; pat1], [commaRange] 
                   )
//# 3789 "src/Compiler/pars.fsy"
                 : 'gentype_tupleParenPatternElements));
//# 10768 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_conjParenPatternElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3797 "src/Compiler/pars.fsy"
                             _3 :: _1 
                   )
//# 3797 "src/Compiler/pars.fsy"
                 : 'gentype_conjParenPatternElements));
//# 10780 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3800 "src/Compiler/pars.fsy"
                             _3 :: _1 :: [] 
                   )
//# 3800 "src/Compiler/pars.fsy"
                 : 'gentype_conjParenPatternElements));
//# 10792 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recordPatternElement in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3804 "src/Compiler/pars.fsy"
                             [_1] 
                   )
//# 3804 "src/Compiler/pars.fsy"
                 : 'gentype_recordPatternElementsAux));
//# 10804 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recordPatternElement in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_recordPatternElementsAux in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3807 "src/Compiler/pars.fsy"
                             _1 :: _3 
                   )
//# 3807 "src/Compiler/pars.fsy"
                 : 'gentype_recordPatternElementsAux));
//# 10817 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3811 "src/Compiler/pars.fsy"
                           let mPath = _1.Range
                           let mEquals = rhs parseState 2
                           let mPat = _3.Range
                           List.frontAndBack _1.LongIdent, Some mEquals, _3 
                   )
//# 3811 "src/Compiler/pars.fsy"
                 : 'gentype_recordPatternElement));
//# 10832 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongId