/* clrngd.c
 *
 * $Id: clrngd.c,v 1.2 2002/12/16 23:45:02 kravietz Exp $
 *
 * Copyright Pawel Krawczyk <kravietz at aba.krakow.pl> 2002
*/

#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdlib.h>
#include <syslog.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <linux/types.h>
#include <linux/random.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/resource.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "truerand.h"
#include "fips.h"

int
main (int argc, char **argv)
{
  unsigned char buff[FIPS_THRESHOLD];
  int rand_fd = -1;
  int fips = -1;
  int r = -1;
  unsigned long frequency = 240; /* how often to run, seconds */
  unsigned int fips_failures = 0; /* how many times FIPS has failed */
  struct
  {
    int ent_count;
    int size;
    unsigned char data[FIPS_THRESHOLD];
  }
  entropy;

  if(argc == 2) {
	  frequency = atol(argv[1]);
	  if(frequency < 60) {
		  fprintf(stderr,
"Running clrngd more often than 60 seconds is pointless as the random data\n"
" is bufferred in 2500 byte blocks and gathering this much takes\n"
"approximately one minute. Recommended is 240 second, which is default.\n");
		  exit(1);
	  }
  }

  entropy.ent_count = FIPS_THRESHOLD * 8;
  entropy.size = FIPS_THRESHOLD;

  /* Renice to the lowest priority so we don't eat all the
   * CPU. This won't hurt entropy collection, will it?
   */
#ifdef HAVE_SETPRIORITY
  setpriority(PRIO_PROCESS, 0, 20);
#endif

  /* That's the reason why clrngd should run as root */
  rand_fd = open ("/dev/random", O_WRONLY);
  if (rand_fd < 0)
    {
      fprintf (stderr, "unable to open random device, exit: %s\n",
	       strerror (errno));
      fprintf (stderr, "maybe you should run clrngd as root?\n");
      return 1;
    }

  openlog ("clrngd", LOG_CONS | LOG_PID, LOG_DAEMON);

  /* First we feed /dev/random with small unchecked data
   * as a yet additional help for the fresh system
   * after reboot. This is BLOCKING operation, i.e. the daemon
   * will go into background AFTER feeding the bytes.
   */

#define INITIAL_BYTES	32
  VonNeumannBytes (entropy.data, INITIAL_BYTES);
  entropy.ent_count = INITIAL_BYTES * 8;
  entropy.size = INITIAL_BYTES;
  r = ioctl (rand_fd, RNDADDENTROPY, &entropy);
  if(r == 0) {
	  syslog(LOG_INFO, "correctly added %d entropy bytes", INITIAL_BYTES);
  }
  close(rand_fd);

  /* Finished playing, time to start real work. Now we become a daemon. */
  if (daemon (0, 0) < 0)
    {
      fprintf (stderr, "unable to daemonize, exit: %s\n", strerror (errno));
      return 1;
    }
  close(3);

  syslog(LOG_INFO, "started correctly");

  entropy.ent_count = FIPS_THRESHOLD * 8;
  entropy.size = FIPS_THRESHOLD;

  while (1)
    {
      VonNeumannBytes (entropy.data, FIPS_THRESHOLD);
      fips = rng_run_fips_test (entropy.data);
      if (!fips)
	{
	  syslog (LOG_WARNING, "FIPS test failed");
	  fips_failures++;
	  if( fips_failures > FIPS_FAILURES_MAX) {
		syslog(LOG_ERR, "Too many FIPS tests failed, apparently "
				"mainboard timers are too good or too few "
				"to provide real entropy");
		syslog(LOG_ERR, "Exiting.");
		return(1);
	  }
	  sleep (1);
	  continue;
	} else {
	  fips_failures = 0;
	}
      rand_fd = open ("/dev/random", O_WRONLY);
      if(rand_fd < 0) {
	      syslog(LOG_ERR, "open random failed: %s",
			      strerror(errno));
	      return(1);
      }
      syslog(LOG_INFO, "correctly added %d entropy bytes", FIPS_THRESHOLD);
      r = ioctl (rand_fd, RNDADDENTROPY, &entropy);
      if (r != 0)
	{
	  syslog (LOG_ERR, "entropy adding failed (returned %d), trying another way", r);
	  r = write (rand_fd, &entropy.data, FIPS_THRESHOLD);
	  if (r < 0)
	    {
	      syslog (LOG_ERR, "which also failed: %s", strerror (errno));
	    } else {
		    syslog(LOG_ERR, "which worked OK");
	    }
	}
      close(rand_fd);
      sleep(frequency);
    }				/* main loop end */
}
