
#include "check-rarian.h"
#include <check.h>
#include <stdlib.h>

int main(void) {
    int number_failed;
    SRunner *sr;

    sr = srunner_create(rarian_utils_suite());
    srunner_add_suite(sr, rarian_reg_utils_suite());
    srunner_add_suite(sr, rarian_list_utils_suite());
    srunner_add_suite(sr, rarian_man_suite());
    srunner_add_suite(sr, rarian_language_suite());
    srunner_add_suite(sr, rarian_info_suite());
    srunner_add_suite(sr, rarian_ht_utils_suite());
    srunner_add_suite(sr, rarian_main_suite());

    srunner_run_all(sr, CK_NORMAL);
    number_failed = srunner_ntests_failed(sr);
    srunner_free(sr);
    return (number_failed == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
