/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.emboss.jemboss.editor.GraphicSequenceCollection;

public class PrintAlignment {
    public PrintAlignment(GraphicSequenceCollection gsc) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat format = new PageFormat();
        format = printerJob.pageDialog(format);
        int nresPerPage = this.showOptions(gsc, format);
        gsc.setNumberOfResiduesPerLine(nresPerPage);
        book.append(gsc, format, gsc.getNumberPages(format, nresPerPage));
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException exception) {
                System.err.println("Printing error: " + exception);
            }
        }
    }

    private int showOptions(GraphicSequenceCollection gsc, PageFormat format) {
        JPanel joptions = new JPanel();
        Box XBox = Box.createHorizontalBox();
        String mres = Integer.toString(gsc.getResiduesPerLine(format));
        JLabel jres = new JLabel("Residues per line: [max:" + mres + "]");
        JTextField maxResiduesField = new JTextField(mres);
        XBox.add(jres);
        XBox.add(maxResiduesField);
        XBox.add(Box.createHorizontalGlue());
        joptions.add(XBox);
        JOptionPane.showMessageDialog(null, joptions, "Options", -1);
        return Integer.parseInt(maxResiduesField.getText());
    }
}

