/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.run.QodanaConverterInput;
import org.jetbrains.qodana.run.QodanaConverterResults;
import org.jetbrains.qodana.sarif.QodanaReportConverter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runQodanaConverter", "Lorg/jetbrains/qodana/run/QodanaConverterResults;", "input", "Lorg/jetbrains/qodana/run/QodanaConverterInput;", "(Lorg/jetbrains/qodana/run/QodanaConverterInput;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChildByRelativePath", "Ljava/nio/file/Path;", "childRelativePath", "", "intellij.qodana"})
public final class Qodana_converterKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Object runQodanaConverter(@NotNull QodanaConverterInput input, @NotNull Continuation<? super QodanaConverterResults> $completion) {
        return InterruptibleKt.runInterruptible((CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getIO(), () -> Qodana_converterKt.runQodanaConverter$lambda$0(input), $completion);
    }

    private static final Path getChildByRelativePath(Path $this$getChildByRelativePath, String childRelativePath) {
        try {
            Path childFullPath = $this$getChildByRelativePath.resolve(childRelativePath).toAbsolutePath().normalize();
            return childFullPath.startsWith($this$getChildByRelativePath.toAbsolutePath().normalize()) ? childFullPath : null;
        }
        catch (IOException iOException) {
            LOG.warn("Failed to load child file: " + childRelativePath + ", parent " + $this$getChildByRelativePath);
            return null;
        }
    }

    private static final QodanaConverterResults runQodanaConverter$lambda$0(QodanaConverterInput $input) {
        Path converterOutTempDir = FileUtilRt.createTempDirectory((String)"qodana-converter", (String)"", (boolean)true).toPath();
        Path converterInputTempDir = FileUtilRt.createTempDirectory((String)"qodana-converter-input", (String)"", (boolean)true).toPath();
        QodanaConverterInput qodanaConverterInput = $input;
        if (qodanaConverterInput instanceof QodanaConverterInput.FullQodanaOutput) {
            Path path = ((QodanaConverterInput.FullQodanaOutput)$input).getQodanaOutput();
            Intrinsics.checkNotNull((Object)converterInputTempDir);
            PathKt.copyRecursively((Path)path, (Path)converterInputTempDir);
        } else if (qodanaConverterInput instanceof QodanaConverterInput.SarifFileOnly) {
            Path path = ((QodanaConverterInput.SarifFileOnly)$input).getSarifFile();
            Path path2 = converterInputTempDir.resolve("qodana.sarif.json");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            PathKt.copyRecursively((Path)path, (Path)path2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        File file2 = converterInputTempDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        File file3 = converterOutTempDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        QodanaReportConverter.Options options = new QodanaReportConverter.Options(Integer.MAX_VALUE, file2, file3);
        new QodanaReportConverter(options).convert();
        LOG.info("Ran Qodana converter, results directory: " + converterOutTempDir);
        Intrinsics.checkNotNull((Object)converterOutTempDir);
        return new QodanaConverterResults(converterOutTempDir);
    }

    public static final /* synthetic */ Path access$getChildByRelativePath(Path $receiver, String childRelativePath) {
        return Qodana_converterKt.getChildByRelativePath($receiver, childRelativePath);
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.qodana.run");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

