//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//           Distributed.cpp - distributed scanning protocol                //
//                                                                          //
//  This is basically a very cheap implementation of distributed            //
//  scanning. A better protocol will be coming later, depending on          //
//  how strong the requests for one will be...                              //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "Distributed.h"
#include "SockSet.h"

extern ProgressIndicator pi;
extern Logging Logger;

#ifdef EBUG
extern ofstream dbug;

#endif

int
Distributed::Connections(void)
{
 char ver[8];
 int i;

 memset(ver,0,8);
 for(i=0;i<nodecount;i++)
  {
   struct sockaddr_in sin;
   sin.sin_family = AF_INET;
   sin.sin_port = htons(DISTRIBUTED_DEFAULT_PORT);
   sin.sin_addr.s_addr = clientaddrs[i];
   int fd = tsock();
   if ((connect(fd, (struct sockaddr *)&sin, sizeof(sin)) >= 0) &&
       (read(fd, ver, 4) == 4))
    {
#ifdef EBUG
     dbug << "Connect to agent " << inet_ntoa(sin.sin_addr) << " OK, version: " << ver << "\n";
#endif
     clientsockets[concount] = fd;
     concount++;
    }
   else
    {
#ifdef EBUG
     dbug << "Connect to agent " << inet_ntoa(sin.sin_addr) << " failing...\n";
#endif
     close(fd);
    }
  }

 concount--;
 return concount;
}

void
Distributed::Accept(void)
{
 struct sockaddr_in sin;
#ifdef DARWIN
 int slen = sizeof(sin);
#else
 unsigned int slen = sizeof(sin);
#endif
 int newfd = accept(mastersocket, (struct sockaddr *)&sin, &slen);

 if(newfd < 0)
  {
#ifdef EBUG
   dbug << "Distributed::Accept error: returned " << newfd << "\n";
#endif
   return;
  }

 curfd = newfd;

 (void) write(newfd, VERSION, 4);

 unsigned int target;
 SockSet *scan;
 while(read(newfd,&target,4) == 4)
  {
#ifdef EBUG
   dbug << "Me (Agent " << ntoa(pi.vhostip);
   dbug << ") got target " << ntoa(target) << "\n";
   dbug.flush();
#endif
   scan = new SockSet;
   scan->con(target);
   sleep(1);
   delete scan;
  }

 close(newfd);
}

int
Distributed::SendRequests(int num, unsigned int *addrs)
{
 int i;
 for(i=0;i<num;i++)
  {
   if (write(clientsockets[nxt], &addrs[i], 4) < 0)
    {
#ifdef EBUG
     dbug << "Writing to agent #" << nxt << " ...write error!!!\n";
#endif
     i--;
    }

   nxt++;

   if (nxt > concount)
    nxt = 0;
  }

 return num;
}

int
Distributed::GetResponses(void)
{
 int i, num = 0;
 fd_set rfds;
 struct timeval tv;
 char buf[8192];

 FD_ZERO(&rfds);

 for(i=0;i<concount;i++)
  FD_SET(clientsockets[i],&rfds);

 tv.tv_sec = 20;
 tv.tv_usec = 0;

#ifdef EBUG
  dbug << "getresp START, concount = " << concount << "\n";
  dbug << "first=" << clientsockets[0] << ", biggest=" << clientsockets[concount] << "\n";
#endif

 while(select(clientsockets[concount]+1, &rfds, NULL, NULL, &tv) > 0)
 {
  for(i=0;i<concount;i++)
   {
    if(FD_ISSET(clientsockets[i], &rfds))
     {
      memset(buf,0,8192);
      read(clientsockets[i],buf,8192);
      Logger.msg(L_DISTRIB, "", "", "%s", buf);
      num++;
     }
   }

  FD_ZERO(&rfds);
  for(i=0;i<concount;i++)
   FD_SET(clientsockets[i],&rfds);
  tv.tv_sec = 15;
  tv.tv_usec = 0;
 }

#ifdef EBUG
  dbug << "getresp END\n";
#endif

 return num;
}

int
Distributed::WriteToMaster(char *buf, int len)
{
 if(write(curfd, buf, len) < 0)
  {
#ifdef EBUG
     dbug << "Writing to agent #" << nxt << " ...write error!!!\n";
#endif
   return 0;
  }

 return 1;
}

Distributed::Distributed()
{
 mymode = 1;
 nodecount = 0;
 concount = 0;
 nxt = 0;
 mastersocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

 struct sockaddr_in sin;
 memset(&sin, 0, sizeof(sin));
 sin.sin_family = AF_INET;
 sin.sin_port = htons(DISTRIBUTED_DEFAULT_PORT);

 if (pi.vhostip)
   sin.sin_addr.s_addr = pi.vhostip;
  else
   sin.sin_addr.s_addr = INADDR_ANY;

 if (bind(mastersocket, (struct sockaddr *) &sin, sizeof(sin)) < 0)
 {
  cout << " [*] Fatal: bind() error!!!\n";
  exit(-1);
 }
 
 listen(mastersocket, 3);
}

Distributed::Distributed(FILE *list)
{
 char buf[512];
 mymode = 2;
 nodecount = 0;
 concount = 0;
 nxt = 0;
 while((fgets(buf,512,list) != NULL) && (!feof(list)))
  {
   unsigned int tmpaddr = resolve(buf);
   if((!tmpaddr) || (tmpaddr == INADDR_ANY))
    continue;
   clientaddrs[nodecount] = tmpaddr;
   nodecount++;
  }

 cout << "[distributed master: added " << nodecount << " agents]\n";
}

Distributed::~Distributed()
{
 int i;

 if (mymode == 2)
  for(i=0;i<concount;i++)
   close(clientsockets[i]);

 if (mymode == 1)
  close(mastersocket);
}
