%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
      "XMM0": ["0x0868C3F30AED56E0", "0x80FCE9E284E6E6DE", "0x8DDDDDDD8DDDDDDD", "0x0CCCCCCC0CCCCCCC"],
      "XMM1": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
      "XMM2": ["0x8000000080000000", "0x8000000080000000", "0x8000000080000000", "0x8000000080000000"],
      "XMM3": ["0xA76C4F06A12BFCE0", "0x9B80767F1E6A060F", "0xDDDDDDDDDDDDDDDD", "0xEEEEEEEEEEEEEEEE"],
      "XMM4": ["0xFFFFFFFFFFFFFFFF", "0x9B80767F1E6A060F", "0xDDDDDDDDDDDDDDDD", "0xFFFFFFFFFFFFFFFF"],
      "XMM5": ["0xFFFFFFFFFFFFFFFF", "0x9B80767F1E6A060F", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF"],
      "XMM6": ["0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF"],
      "XMM7": ["0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF"],
      "XMM8": ["0xA76C4F06A12BFCE0", "0x9B80767F1E6A060F", "0xDDDDDDDDDDDDDDDD", "0xEEEEEEEEEEEEEEEE"],
      "XMM9": ["0xA76C4F06A12BFCE0", "0x9B80767F1E6A060F", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF"]
  }
}
%endif

lea rdx, [rel .data]

vmovaps ymm0, [rdx + 32]
vmovaps ymm1, [rdx + 64]
vmovaps ymm2, [rdx + 96]
vmovaps ymm3, [rdx]

vmaskmovps [rel .scratch1], ymm0, ymm3
vmaskmovps [rel .scratch2], xmm0, xmm3

vmaskmovps [rel .scratch3], ymm1, ymm3
vmaskmovps [rel .scratch4], xmm1, xmm3

vmaskmovps [rel .scratch5], ymm2, ymm3
vmaskmovps [rel .scratch6], xmm2, xmm3

; Now reload to verify results
vmovaps ymm4, [rel .scratch1]
vmovaps ymm5, [rel .scratch2]
vmovaps ymm6, [rel .scratch3]
vmovaps ymm7, [rel .scratch4]
vmovaps ymm8, [rel .scratch5]
vmovaps ymm9, [rel .scratch6]

hlt

align 32
.data:
dq 0xA76C4F06A12BFCE0
dq 0x9B80767F1E6A060F
dq 0xDDDDDDDDDDDDDDDD
dq 0xEEEEEEEEEEEEEEEE

; Disastrously organized mask (sign mask [0, 0, 1, 1, 1, 1, 0, 0])
dq 0x0868C3F30AED56E0
dq 0x80FCE9E284E6E6DE
dq 0x8DDDDDDD8DDDDDDD
dq 0x0CCCCCCC0CCCCCCC

; No masking at all. Should not touch memory at all.
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000

; Select all elements
dq 0x8000000080000000
dq 0x8000000080000000
dq 0x8000000080000000
dq 0x8000000080000000

.scratch1:
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

.scratch2:
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

.scratch3:
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

.scratch4:
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

.scratch5:
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

.scratch6:
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
