/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public class FONTXBitmapFontExporter
implements BitmapFontExporter {
    private int flag;
    private GlyphList singleByteEncoding;
    private String doubleByteEncoding;

    public FONTXBitmapFontExporter(boolean bl) {
        this.flag = bl ? 1 : 0;
        this.singleByteEncoding = null;
        this.doubleByteEncoding = "CP943";
    }

    public FONTXBitmapFontExporter(GlyphList glyphList) {
        this.flag = 0;
        this.singleByteEncoding = glyphList;
        this.doubleByteEncoding = "CP943";
    }

    public FONTXBitmapFontExporter(String string) {
        this.flag = 1;
        this.singleByteEncoding = null;
        this.doubleByteEncoding = string;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontImpl(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFontImpl(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontImpl(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFontImpl(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(1179602516);
        dataOutputStream.writeShort(22578);
        String string = bitmapFont.getName(1);
        byte[] byArray = string != null ? string.getBytes("US-ASCII") : new byte[]{};
        for (n = 0; n < byArray.length && n < 8; ++n) {
            dataOutputStream.writeByte(byArray[n]);
        }
        for (n = byArray.length; n < 8; ++n) {
            dataOutputStream.writeByte(32);
        }
        n = bitmapFont.getLineAscent();
        int n2 = n + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        if (this.flag == 0) {
            int n3 = 0;
            BitmapFontGlyph[] bitmapFontGlyphArray = new BitmapFontGlyph[256];
            for (int i = 0; i < 256; ++i) {
                BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(this.fromSingleByte(i));
                if (bitmapFontGlyph == null) continue;
                int n4 = bitmapFontGlyph.getCharacterWidth();
                if (n4 > n3) {
                    n3 = n4;
                }
                bitmapFontGlyphArray[i] = bitmapFontGlyph;
            }
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeByte(this.flag);
            for (BitmapFontGlyph bitmapFontGlyph : bitmapFontGlyphArray) {
                this.writeGlyph(dataOutputStream, n3, n2, n, bitmapFontGlyph);
            }
        } else {
            int n5;
            int n6 = -1;
            int[] nArray = new int[256];
            int[] nArray2 = new int[256];
            int n7 = 0;
            LinkedList<BitmapFontGlyph> linkedList = new LinkedList<BitmapFontGlyph>();
            for (n5 = 0; n5 < 65536; ++n5) {
                BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(this.fromDoubleByte(n5));
                if (bitmapFontGlyph == null) continue;
                if (n6 < 0 || nArray2[n6] + 1 != n5) {
                    if (n6 >= 254) break;
                    nArray[++n6] = n5;
                }
                nArray2[n6] = n5;
                int n8 = bitmapFontGlyph.getCharacterWidth();
                if (n8 > n7) {
                    n7 = n8;
                }
                linkedList.add(bitmapFontGlyph);
            }
            dataOutputStream.writeByte(n7);
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeByte(this.flag);
            dataOutputStream.writeByte(n6 + 1);
            for (n5 = 0; n5 <= n6; ++n5) {
                dataOutputStream.writeShort(Short.reverseBytes((short)nArray[n5]));
                dataOutputStream.writeShort(Short.reverseBytes((short)nArray2[n5]));
            }
            for (BitmapFontGlyph bitmapFontGlyph : linkedList) {
                this.writeGlyph(dataOutputStream, n7, n2, n, bitmapFontGlyph);
            }
        }
    }

    private void writeGlyph(DataOutputStream dataOutputStream, int n, int n2, int n3, BitmapFontGlyph bitmapFontGlyph) throws IOException {
        if (bitmapFontGlyph == null) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; j += 8) {
                    dataOutputStream.writeByte(0);
                }
            }
        } else {
            byte[][] byArray = bitmapFontGlyph.getGlyph();
            int n4 = bitmapFontGlyph.getGlyphAscent() - n3;
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                if (n4 >= 0 && n4 < byArray.length) {
                    n6 = -bitmapFontGlyph.getGlyphOffset();
                    int n7 = 0;
                    while (n7 < n) {
                        int n8 = 0;
                        int n9 = 128;
                        while (n9 != 0 && n7 < n) {
                            if (n6 >= 0 && n6 < byArray[n4].length && byArray[n4][n6] < 0) {
                                n8 |= n9;
                            }
                            n9 >>= 1;
                            ++n7;
                            ++n6;
                        }
                        dataOutputStream.writeByte(n8);
                    }
                } else {
                    for (n6 = 0; n6 < n; n6 += 8) {
                        dataOutputStream.writeByte(0);
                    }
                }
                ++n5;
                ++n4;
            }
        }
    }

    private int fromSingleByte(int n) {
        int n2;
        if (this.singleByteEncoding != null && (n2 = this.singleByteEncoding.get(n).intValue()) >= 0) {
            return n2;
        }
        return 61440 + n;
    }

    private int fromDoubleByte(int n) {
        if (this.doubleByteEncoding != null) {
            try {
                int n2;
                byte[] byArray = new byte[]{(byte)(n >> 8), (byte)n};
                String string = new String(byArray, this.doubleByteEncoding);
                if (string.codePointCount(0, string.length()) == 1 && (n2 = string.codePointAt(0)) != 65533) {
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 983040 + n;
    }
}

