/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos.mover;

import com.kreative.bitsnpicas.datatransfer.ClearMenuItem;
import com.kreative.bitsnpicas.datatransfer.CopyMenuItem;
import com.kreative.bitsnpicas.datatransfer.CutMenuItem;
import com.kreative.bitsnpicas.datatransfer.PasteMenuItem;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.geos.mover.GEOSFontPointSizeTable;
import com.kreative.bitsnpicas.geos.mover.SaveManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GEOSMoverMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;

    public GEOSMoverMenuBar(Window window, SaveManager saveManager, GEOSFontPointSizeTable gEOSFontPointSizeTable) {
        this.add(new FileMenu(window, saveManager));
        this.add(new EditMenu(gEOSFontPointSizeTable));
    }

    public static class OpenItemsMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public OpenItemsMenuItem(final GEOSFontPointSizeTable gEOSFontPointSizeTable) {
            super("Open Items");
            this.setAccelerator(KeyStroke.getKeyStroke(73, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    gEOSFontPointSizeTable.doOpen();
                }
            });
        }
    }

    public static class EditMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public EditMenu(GEOSFontPointSizeTable gEOSFontPointSizeTable) {
            super("Edit");
            this.add(new CutMenuItem());
            this.add(new CopyMenuItem());
            this.add(new PasteMenuItem());
            this.add(new ClearMenuItem());
            this.addSeparator();
            this.add(new OpenItemsMenuItem(gEOSFontPointSizeTable));
        }
    }

    public static class FileMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public FileMenu(Window window, SaveManager saveManager) {
            super("File");
            this.add(new CommonMenuItems.NewMenu());
            this.add(new CommonMenuItems.OpenMenuItem());
            this.add(new CommonMenuItems.CloseMenuItem(window));
            this.addSeparator();
            this.add(new CommonMenuItems.SaveMenuItem(saveManager));
            this.add(new CommonMenuItems.SaveAsMenuItem(saveManager));
            if (!CommonMenuItems.IS_MAC_OS) {
                this.addSeparator();
                this.add(new CommonMenuItems.ExitMenuItem());
            }
        }
    }
}

