/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.FileProxy;
import com.kreative.bitsnpicas.importer.BDFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.CybikoBitmapFontImporter;
import com.kreative.bitsnpicas.importer.DSFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.FNTBitmapFontImporter;
import com.kreative.bitsnpicas.importer.FONTXBitmapFontImporter;
import com.kreative.bitsnpicas.importer.FZXBitmapFontImporter;
import com.kreative.bitsnpicas.importer.GEOSBitmapFontImporter;
import com.kreative.bitsnpicas.importer.HMZKBitmapFontImporter;
import com.kreative.bitsnpicas.importer.HexBitmapFontImporter;
import com.kreative.bitsnpicas.importer.KbitsBitmapFontImporter;
import com.kreative.bitsnpicas.importer.KbitxBitmapFontImporter;
import com.kreative.bitsnpicas.importer.NFNTBitmapFontImporter;
import com.kreative.bitsnpicas.importer.PSFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.PlaydateBitmapFontImporter;
import com.kreative.bitsnpicas.importer.RockboxBitmapFontImporter;
import com.kreative.bitsnpicas.importer.S10BitmapFontImporter;
import com.kreative.bitsnpicas.importer.SBFBitmapFontImporter;
import com.kreative.bitsnpicas.importer.SFDBitmapFontImporter;
import com.kreative.bitsnpicas.importer.SRFontBitmapFontImporter;
import com.kreative.bitsnpicas.importer.U8MBitmapFontImporter;
import com.kreative.bitsnpicas.main.BitmapInputOptions;
import com.kreative.unicode.data.EncodingList;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BitmapInputFormat {
    KBITX(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".kbitx");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new KbitxBitmapFontImporter();
        }
    }
    ,
    KBITS(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".kbits");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new KbitsBitmapFontImporter();
        }
    }
    ,
    SFD(6){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".sfd");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new SFDBitmapFontImporter();
        }
    }
    ,
    BDF(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".bdf");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new BDFBitmapFontImporter();
        }
    }
    ,
    PSF(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".psf", ".psfu");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new PSFBitmapFontImporter(bitmapInputOptions.getPsfLowEncoding(), bitmapInputOptions.getPsfHighEncoding(), bitmapInputOptions.psfPuaBase, false);
        }
    }
    ,
    PSFGZ(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".psf.gz", ".psfu.gz");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new PSFBitmapFontImporter(bitmapInputOptions.getPsfLowEncoding(), bitmapInputOptions.getPsfHighEncoding(), bitmapInputOptions.psfPuaBase, true);
        }
    }
    ,
    SUIT(4, true){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".suit");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new NFNTBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    }
    ,
    DFONT(4, false){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".dfont");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new NFNTBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    }
    ,
    SRFONT(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".png") && fileProxy.isImage() && new SRFontBitmapFontImporter().canImportFont(fileProxy.getImage());
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new SRFontBitmapFontImporter();
        }
    }
    ,
    HEX(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".hex");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new HexBitmapFontImporter();
        }
    }
    ,
    CVT(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".cvt");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new GEOSBitmapFontImporter();
        }
    }
    ,
    FZX(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".fzx");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new FZXBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    }
    ,
    U8M(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".u8m");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new U8MBitmapFontImporter();
        }
    }
    ,
    FNT(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".fnt") && fileProxy.startsWith(0);
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new FNTBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    }
    ,
    FONTX(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".ftx", ".fnt") && fileProxy.startsWith(70);
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            String string;
            String string2 = bitmapInputOptions.encodingName;
            if (string2 == null || string2.length() == 0) {
                string2 = "CP437";
            }
            if ((string = bitmapInputOptions.fontxDoubleByteEncoding) == null || string.length() == 0) {
                string = "CP943";
            }
            return new FONTXBitmapFontImporter(EncodingList.instance().getGlyphList(string2), string);
        }
    }
    ,
    ROCKBOX(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".rbf", ".rb11", ".rb12", ".fnt") && fileProxy.startsWith(82);
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new RockboxBitmapFontImporter();
        }
    }
    ,
    CYBIKO(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".cyf", ".fntz", ".fnty", ".fnt") && fileProxy.startsWith(1);
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new CybikoBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    }
    ,
    PLAYDATE(4){

        public boolean recognize(FileProxy fileProxy) {
            return PlaydateBitmapFontImporter.canImportFont(fileProxy);
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new PlaydateBitmapFontImporter();
        }
    }
    ,
    HMZK(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".hmzk");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new HMZKBitmapFontImporter();
        }
    }
    ,
    DSF(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".dsf");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new DSFBitmapFontImporter();
        }
    }
    ,
    SBF(1){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".sbf");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new SBFBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    }
    ,
    S10(4){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasExtension(".s10");
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new S10BitmapFontImporter();
        }
    }
    ,
    DMOV(4, true){

        public boolean recognize(FileProxy fileProxy) {
            return fileProxy.hasMacCreator("DMOV") || fileProxy.hasMacCreator("movr") || (fileProxy.hasMacCreator("MACS") || fileProxy.hasMacCreator("macs")) && (fileProxy.hasMacType("ZSYS") || fileProxy.hasMacType("zsys"));
        }

        public BitmapFontImporter createImporter(BitmapInputOptions bitmapInputOptions) {
            return new NFNTBitmapFontImporter(bitmapInputOptions.getEncoding());
        }
    };

    public final int nameType;
    public final boolean macResFork;

    private BitmapInputFormat(int n2) {
        this.nameType = n2;
        this.macResFork = false;
    }

    private BitmapInputFormat(int n2, boolean bl) {
        this.nameType = n2;
        this.macResFork = bl;
    }

    public abstract boolean recognize(FileProxy var1);

    public abstract BitmapFontImporter createImporter(BitmapInputOptions var1);

    public static BitmapInputFormat forFile(File file) {
        FileProxy fileProxy = new FileProxy(file);
        for (BitmapInputFormat bitmapInputFormat : BitmapInputFormat.values()) {
            if (!bitmapInputFormat.recognize(fileProxy)) continue;
            return bitmapInputFormat;
        }
        return null;
    }
}

