/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CpalTable
extends TrueTypeTable {
    public static final int USABLE_WITH_LIGHT_BACKGROUND = 1;
    public static final int USABLE_WITH_DARK_BACKGROUND = 2;
    public int version = 0;
    public int numPaletteEntries = 0;
    public int[] colorRecordIndices = new int[0];
    public int[] colorRecordsArray = new int[0];
    public int[] paletteTypesArray = null;
    public int[] paletteLabelsArray = null;
    public int[] paletteEntryLabelsArray = null;

    public String tableName() {
        return "CPAL";
    }

    public String[] dependencyNames() {
        return new String[0];
    }

    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n = this.colorRecordIndices.length * 2 + 12;
        if (this.version >= 1) {
            n += 12;
        }
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeShort(this.numPaletteEntries);
        dataOutputStream.writeShort(this.colorRecordIndices.length);
        dataOutputStream.writeShort(this.colorRecordsArray.length);
        dataOutputStream.writeInt(n);
        n += this.colorRecordsArray.length * 4;
        for (int n2 : this.colorRecordIndices) {
            dataOutputStream.writeShort(n2);
        }
        if (this.version >= 1) {
            if (this.paletteTypesArray != null) {
                dataOutputStream.writeInt(n);
                n += this.paletteTypesArray.length * 4;
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.paletteLabelsArray != null) {
                dataOutputStream.writeInt(n);
                n += this.paletteLabelsArray.length * 2;
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.paletteEntryLabelsArray != null) {
                dataOutputStream.writeInt(n);
                n += this.paletteEntryLabelsArray.length * 2;
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        for (int n2 : this.colorRecordsArray) {
            dataOutputStream.writeInt(Integer.reverseBytes(n2));
        }
        if (this.version >= 1) {
            if (this.paletteTypesArray != null) {
                for (int n2 : this.paletteTypesArray) {
                    dataOutputStream.writeInt(n2);
                }
            }
            if (this.paletteLabelsArray != null) {
                for (int n2 : this.paletteLabelsArray) {
                    dataOutputStream.writeShort(n2);
                }
            }
            if (this.paletteEntryLabelsArray != null) {
                for (int n2 : this.paletteEntryLabelsArray) {
                    dataOutputStream.writeShort(n2);
                }
            }
        }
    }

    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n2;
        int n3;
        this.version = dataInputStream.readUnsignedShort();
        this.numPaletteEntries = dataInputStream.readUnsignedShort();
        this.colorRecordIndices = new int[dataInputStream.readUnsignedShort()];
        this.colorRecordsArray = new int[dataInputStream.readUnsignedShort()];
        int n4 = dataInputStream.readInt();
        for (n3 = 0; n3 < this.colorRecordIndices.length; ++n3) {
            this.colorRecordIndices[n3] = dataInputStream.readUnsignedShort();
        }
        n3 = this.version < 1 ? 0 : dataInputStream.readInt();
        int n5 = this.version < 1 ? 0 : dataInputStream.readInt();
        int n6 = this.version < 1 ? 0 : dataInputStream.readInt();
        dataInputStream.reset();
        dataInputStream.skipBytes(n4);
        for (n2 = 0; n2 < this.colorRecordsArray.length; ++n2) {
            this.colorRecordsArray[n2] = Integer.reverseBytes(dataInputStream.readInt());
        }
        if (n3 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n3);
            this.paletteTypesArray = new int[this.colorRecordIndices.length];
            for (n2 = 0; n2 < this.colorRecordIndices.length; ++n2) {
                this.paletteTypesArray[n2] = dataInputStream.readInt();
            }
        } else {
            this.paletteTypesArray = null;
        }
        if (n5 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n5);
            this.paletteLabelsArray = new int[this.colorRecordIndices.length];
            for (n2 = 0; n2 < this.colorRecordIndices.length; ++n2) {
                this.paletteLabelsArray[n2] = dataInputStream.readUnsignedShort();
            }
        } else {
            this.paletteLabelsArray = null;
        }
        if (n6 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n6);
            this.paletteEntryLabelsArray = new int[this.colorRecordsArray.length];
            for (n2 = 0; n2 < this.colorRecordsArray.length; ++n2) {
                this.paletteEntryLabelsArray[n2] = dataInputStream.readUnsignedShort();
            }
        } else {
            this.paletteEntryLabelsArray = null;
        }
    }
}

