/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.CbdtEntryFormat17;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat18;
import com.kreative.bitsnpicas.truetype.CbdtEntryFormat19;
import com.kreative.bitsnpicas.truetype.EbdtEntry;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat1;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat2;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat5;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat6;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat7;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat8;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat9;
import com.kreative.bitsnpicas.truetype.EblcBitmapSize;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable;
import com.kreative.bitsnpicas.truetype.EblcTable;
import com.kreative.bitsnpicas.truetype.MapBasedTable;
import com.kreative.bitsnpicas.truetype.SbitTableType;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EbdtTable
extends MapBasedTable<Integer, EbdtEntry> {
    public SbitTableType type;
    public int version;

    public EbdtTable(SbitTableType sbitTableType) {
        this.type = sbitTableType;
        this.version = sbitTableType.version;
    }

    @Override
    public String tableName() {
        return this.type.dataTableName;
    }

    @Override
    public String[] dependencyNames() {
        return new String[]{this.type.locTableName};
    }

    public int getNextKey() {
        int n = 4;
        for (Map.Entry entry : this.entrySet()) {
            int n2 = (Integer)entry.getKey() + ((EbdtEntry)entry.getValue()).length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void recalculate(EblcTable eblcTable) {
        TreeSet treeSet = new TreeSet();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        int n = 4;
        treeSet.addAll(this.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            EbdtEntry ebdtEntry = (EbdtEntry)this.get(n2);
            treeMap.put(n2, n);
            hashMap.put(n, ebdtEntry);
            n += ebdtEntry.length();
        }
        for (EblcBitmapSize eblcBitmapSize : eblcTable) {
            for (EblcIndexSubtable eblcIndexSubtable : eblcBitmapSize) {
                int[] nArray = eblcIndexSubtable.getOffsets();
                int[] nArray2 = new int[nArray.length];
                int n3 = -1;
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[i] = EbdtTable.remap(treeMap, nArray[i]);
                    if (n3 >= 0 && nArray2[i] >= n3) continue;
                    n3 = nArray2[i];
                }
                eblcIndexSubtable.header.imageDataOffset = n3;
                eblcIndexSubtable.setOffsets(nArray2);
            }
        }
        this.clear();
        this.putAll(hashMap);
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(this.version);
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        hashMap.put(0, byArray);
        int n = byArray.length;
        for (Map.Entry object : this.entrySet()) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            ((EbdtEntry)object.getValue()).write(dataOutputStream2);
            dataOutputStream2.flush();
            dataOutputStream2.close();
            byArray = byteArrayOutputStream.toByteArray();
            hashMap.put((Integer)object.getKey(), byArray);
            int entry = (Integer)object.getKey() + byArray.length;
            if (entry <= n) continue;
            n = entry;
        }
        Object object = new byte[n];
        for (Map.Entry entry : hashMap.entrySet()) {
            byte[] byArray2 = (byte[])entry.getValue();
            int n2 = (Integer)entry.getKey();
            int n3 = 0;
            while (n3 < byArray2.length) {
                object[n2] = byArray2[n3];
                ++n3;
                ++n2;
            }
        }
        dataOutputStream.write((byte[])object);
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        this.version = dataInputStream.readInt();
        EblcTable eblcTable = (EblcTable)trueTypeTableArray[0];
        for (EblcBitmapSize eblcBitmapSize : eblcTable) {
            for (EblcIndexSubtable eblcIndexSubtable : eblcBitmapSize) {
                int[] nArray = eblcIndexSubtable.getOffsets();
                for (int i = 1; i < nArray.length; ++i) {
                    int n2 = nArray[i - 1];
                    int n3 = nArray[i] - n2;
                    if (n3 <= 0 || this.containsKey(n2)) continue;
                    dataInputStream.reset();
                    dataInputStream.skip(n2);
                    EbdtEntry ebdtEntry = EbdtTable.createEbdtEntry(eblcIndexSubtable.header.imageFormat);
                    ebdtEntry.read(dataInputStream, n3);
                    this.put(n2, ebdtEntry);
                }
            }
        }
    }

    private static final EbdtEntry createEbdtEntry(int n) throws IOException {
        switch (n) {
            case 1: {
                return new EbdtEntryFormat1();
            }
            case 2: {
                return new EbdtEntryFormat2();
            }
            case 5: {
                return new EbdtEntryFormat5();
            }
            case 6: {
                return new EbdtEntryFormat6();
            }
            case 7: {
                return new EbdtEntryFormat7();
            }
            case 8: {
                return new EbdtEntryFormat8();
            }
            case 9: {
                return new EbdtEntryFormat9();
            }
            case 17: {
                return new CbdtEntryFormat17();
            }
            case 18: {
                return new CbdtEntryFormat18();
            }
            case 19: {
                return new CbdtEntryFormat19();
            }
        }
        throw new IOException("invalid imageFormat: " + n);
    }

    private static final int remap(SortedMap<Integer, Integer> sortedMap, int n) {
        int n2 = 0;
        int n3 = 0;
        for (Map.Entry<Integer, Integer> entry : sortedMap.entrySet()) {
            int n4 = entry.getKey();
            int n5 = entry.getValue();
            if (n < n4) {
                return n3 + (n - n2);
            }
            n2 = n4;
            n3 = n5;
        }
        return n3 + (n - n2);
    }
}

