/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.SvgTableEntry;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgTable
extends ListBasedTable<SvgTableEntry> {
    @Override
    public String tableName() {
        return "SVG ";
    }

    @Override
    public String[] dependencyNames() {
        return new String[0];
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt(10);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeShort(this.size());
        HashMap<byte[], Integer> hashMap = new HashMap<byte[], Integer>();
        int n = 2 + this.size() * 12;
        for (SvgTableEntry svgTableEntry : this) {
            dataOutputStream.writeShort(svgTableEntry.startGlyphID);
            dataOutputStream.writeShort(svgTableEntry.endGlyphID);
            if (hashMap.containsKey(svgTableEntry.svgDocument)) {
                dataOutputStream.writeInt((Integer)hashMap.get(svgTableEntry.svgDocument));
            } else {
                dataOutputStream.writeInt(n);
                hashMap.put(svgTableEntry.svgDocument, n);
                n += svgTableEntry.svgDocument.length;
            }
            dataOutputStream.writeInt(svgTableEntry.svgDocument.length);
        }
        for (SvgTableEntry svgTableEntry : this) {
            if (!hashMap.containsKey(svgTableEntry.svgDocument)) continue;
            dataOutputStream.write(svgTableEntry.svgDocument);
            hashMap.remove(svgTableEntry.svgDocument);
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        Object object;
        int n2;
        dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readInt();
        dataInputStream.reset();
        dataInputStream.skipBytes(n3);
        int n4 = dataInputStream.readUnsignedShort();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        long[] lArray = new long[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = dataInputStream.readUnsignedShort();
            nArray2[i] = dataInputStream.readUnsignedShort();
            nArray3[i] = dataInputStream.readInt();
            nArray4[i] = dataInputStream.readInt();
            lArray[i] = (long)nArray3[i] << 32 | (long)nArray4[i];
        }
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        for (n2 = 0; n2 < n4; ++n2) {
            if (hashMap.containsKey(lArray[n2])) continue;
            object = new byte[nArray4[n2]];
            dataInputStream.reset();
            dataInputStream.skipBytes(n3 + nArray3[n2]);
            dataInputStream.readFully((byte[])object);
            hashMap.put(lArray[n2], object);
        }
        this.clear();
        for (n2 = 0; n2 < n4; ++n2) {
            object = new SvgTableEntry();
            ((SvgTableEntry)object).startGlyphID = nArray[n2];
            ((SvgTableEntry)object).endGlyphID = nArray2[n2];
            ((SvgTableEntry)object).svgDocument = (byte[])hashMap.get(lArray[n2]);
            this.add(object);
        }
    }
}

