/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.PuaaCache;
import com.kreative.unicode.fontmap.FontMapController;
import com.kreative.unicode.fontmap.FontMapEntry;
import com.kreative.unicode.ttflib.PuaaTable;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;

public class NameResolver {
    private static NameResolver baseInstance = null;
    private static Map<Font, NameResolver> fontInstances = null;
    private final Map<Integer, String> baseCategoryMap;
    private final Map<Integer, String> baseCombClassMap;
    private final SortedMap<Integer, String> baseNameMap;
    private final Map<Integer, String> baseUni1NameMap;
    private final Map<Integer, String> categoryMap;
    private final Map<Integer, String> combClassMap;
    private final Map<Integer, String> nameMap;
    private final Map<Integer, String> uni1NameMap;

    public static NameResolver instance() {
        if (baseInstance == null) {
            baseInstance = new NameResolver();
        }
        return baseInstance;
    }

    public static NameResolver instance(Font font) {
        if (font == null) {
            return NameResolver.instance();
        }
        if (fontInstances == null) {
            fontInstances = new HashMap<Font, NameResolver>();
        }
        if (fontInstances.containsKey(font)) {
            return fontInstances.get(font);
        }
        NameResolver nameResolver = new NameResolver(NameResolver.instance(), font);
        fontInstances.put(font, nameResolver);
        return nameResolver;
    }

    public static NameResolver instance(String string) {
        FontMapEntry fontMapEntry = FontMapController.getInstance().entryForString(string);
        return fontMapEntry == null ? NameResolver.instance() : NameResolver.instance(fontMapEntry.getFont());
    }

    public static NameResolver instance(int n) {
        FontMapEntry fontMapEntry = FontMapController.getInstance().entryForCodePoint(n);
        return fontMapEntry == null ? NameResolver.instance() : NameResolver.instance(fontMapEntry.getFont());
    }

    private NameResolver() {
        PuaaTable puaaTable = PuaaCache.getPuaaTable("unidata.ucd");
        this.baseCategoryMap = puaaTable.getPropertyMap("General_Category");
        this.baseCombClassMap = puaaTable.getPropertyMap("Canonical_Combining_Class");
        this.baseNameMap = puaaTable.getPropertySortedMap("Name");
        this.baseUni1NameMap = puaaTable.getPropertyMap("Unicode_1_Name");
        this.categoryMap = this.baseCategoryMap;
        this.combClassMap = this.baseCombClassMap;
        this.nameMap = this.baseNameMap;
        this.uni1NameMap = this.baseUni1NameMap;
    }

    private NameResolver(NameResolver nameResolver, Font font) {
        this.baseCategoryMap = nameResolver.baseCategoryMap;
        this.baseCombClassMap = nameResolver.baseCombClassMap;
        this.baseNameMap = nameResolver.baseNameMap;
        this.baseUni1NameMap = nameResolver.baseUni1NameMap;
        PuaaTable puaaTable = PuaaCache.getPuaaTable(font);
        if (puaaTable == null) {
            this.categoryMap = this.baseCategoryMap;
            this.combClassMap = this.baseCombClassMap;
            this.nameMap = this.baseNameMap;
            this.uni1NameMap = this.baseUni1NameMap;
        } else {
            this.categoryMap = new HashMap<Integer, String>();
            this.combClassMap = new HashMap<Integer, String>();
            this.nameMap = new HashMap<Integer, String>();
            this.uni1NameMap = new HashMap<Integer, String>();
            if (this.baseCategoryMap != null) {
                this.categoryMap.putAll(this.baseCategoryMap);
            }
            if (this.baseCombClassMap != null) {
                this.combClassMap.putAll(this.baseCombClassMap);
            }
            if (this.baseNameMap != null) {
                this.nameMap.putAll(this.baseNameMap);
            }
            if (this.baseUni1NameMap != null) {
                this.uni1NameMap.putAll(this.baseUni1NameMap);
            }
            Map<Integer, String> map = puaaTable.getPropertyMap("General_Category");
            Map<Integer, String> map2 = puaaTable.getPropertyMap("Canonical_Combining_Class");
            Map<Integer, String> map3 = puaaTable.getPropertyMap("Name");
            Map<Integer, String> map4 = puaaTable.getPropertyMap("Unicode_1_Name");
            if (map != null) {
                this.categoryMap.putAll(map);
            }
            if (map2 != null) {
                this.combClassMap.putAll(map2);
            }
            if (map3 != null) {
                this.nameMap.putAll(map3);
            }
            if (map4 != null) {
                this.uni1NameMap.putAll(map4);
            }
        }
    }

    public String getCategory(int n) {
        if (this.categoryMap == null) {
            return null;
        }
        String string = this.categoryMap.get(n);
        if (string != null) {
            return string;
        }
        try {
            String string2;
            String string3;
            int n2 = this.baseNameMap.headMap(n).lastKey();
            int n3 = this.baseNameMap.tailMap(n).firstKey();
            String string4 = (String)this.baseNameMap.get(n2);
            String string5 = (String)this.baseNameMap.get(n3);
            if (NameResolver.isRangePair(string4, string5) && (string3 = this.baseCategoryMap.get(n2)).equals(string2 = this.baseCategoryMap.get(n3))) {
                return string3;
            }
            return "Cn";
        }
        catch (Exception exception) {
            return "Cn";
        }
    }

    public String getCombiningClass(int n) {
        if (this.combClassMap == null) {
            return null;
        }
        String string = this.combClassMap.get(n);
        if (string != null) {
            return string;
        }
        try {
            String string2;
            String string3;
            int n2 = this.baseNameMap.headMap(n).lastKey();
            int n3 = this.baseNameMap.tailMap(n).firstKey();
            String string4 = (String)this.baseNameMap.get(n2);
            String string5 = (String)this.baseNameMap.get(n3);
            if (NameResolver.isRangePair(string4, string5) && (string3 = this.baseCombClassMap.get(n2)).equals(string2 = this.baseCombClassMap.get(n3))) {
                return string3;
            }
            return "0";
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public String getName(int n) {
        if (this.nameMap == null) {
            return null;
        }
        String string = this.nameMap.get(n);
        if (string != null) {
            if (!string.startsWith("<") || !string.endsWith(">")) {
                return string;
            }
            if (string.equals("<control>")) {
                string = this.uni1NameMap.get(n);
                if (string != null) {
                    return string;
                }
                return "CONTROL-" + NameResolver.toHexString(n);
            }
        } else {
            try {
                int n2 = this.baseNameMap.headMap(n).lastKey();
                int n3 = this.baseNameMap.tailMap(n).firstKey();
                String string2 = (String)this.baseNameMap.get(n2);
                String string3 = (String)this.baseNameMap.get(n3);
                if (!NameResolver.isRangePair(string2, string3)) {
                    return "UNDEFINED-" + NameResolver.toHexString(n);
                }
                string = string2;
            }
            catch (Exception exception) {
                return "UNDEFINED-" + NameResolver.toHexString(n);
            }
        }
        if (string.contains("CJK Ideograph")) {
            return "CJK UNIFIED IDEOGRAPH-" + NameResolver.toHexString(n);
        }
        if (string.contains("Tangut Ideograph")) {
            return "TANGUT IDEOGRAPH-" + NameResolver.toHexString(n);
        }
        if (string.contains("High Surrogate")) {
            return "HIGH SURROGATE-" + NameResolver.toHexString(n);
        }
        if (string.contains("Private Use")) {
            return "PRIVATE USE-" + NameResolver.toHexString(n);
        }
        return string.replaceAll("^<|, (Fir|La)st>$", "").toUpperCase() + "-" + NameResolver.toHexString(n);
    }

    private static boolean isRangePair(String string, String string2) {
        return string.startsWith("<") && string.endsWith(", First>") && string2.startsWith("<") && string2.endsWith(", Last>") && string.substring(0, string.length() - 6).equals(string2.substring(0, string2.length() - 5));
    }

    private static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 4) {
            string = ("0000" + string).substring(string.length());
        }
        return string;
    }
}

