﻿<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
    <title>LAME MP3 Encoder :: Related Links</title>
    <meta name="author" content="Roberto Amorim - rjamorim@yahoo.com" />
    <meta name="generator" content="jEdit 5.4" />
    <meta name="cvs-version" content="$Id: links.php,v 1.37 2014/10/01 19:21:01 robert Exp" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <link rel="stylesheet" type="text/css" href="styles/lame.css" />
    <!--[if IE 6]>
    <link rel="stylesheet" type="text/css" href="styles/ie.css" />
    <![endif]-->
</head>
<body>

<?php include("menu.html") ?>

<div id="container">
<div id="content">

<div align="center">
    <img src="images/logo.gif" width="358" height="231" alt="LAME Official Logo" />
    <h1>LAME and MP3-related Links</h1>
</div>

<h3><a name="Contents">Quick Links:</a></h3>

<ul>
    <li><a href="#OpenSource">Free (open source) software which supports or uses
    LAME</a>
    <ul>
        <li><a href="#Multiplatform">Multiplatform</a></li>
        <li><a href="#Posix">Posix (UNIX-like)</a></li>
        <li><a href="#MacOS">MacOS Classic</a></li>
        <li><a href="#Windows">Windows</a></li>
    </ul>
    </li>

    <li><a href="#ClosedSource">Free (closed source) software which supports or
    uses LAME</a></li>
    <li><a href="#Commercial">Commercial software which supports or uses
    LAME</a></li>
    <!--<li><a href="#Shame">Hall of Shame</a></li>-->
    <li><a href="#Binaries">LAME Binaries (for Windows, *nix, Amiga...)</a></li>
    <li><a href="#Alternatives">Alternative MP3 encoders</a></li>
    <!--<li><a href="#Comparisons">Comparisons based on listening tests</a></li>-->
    <li><a href="#MP3_sites">MP3 encoding web sites</a></li>
    <li><a href="#MP3_general">General MP3 Web Sites</a></li>
    <li><a href="#Soft_hard">MP3 Related Software and Hardware</a></li>
    <li><a href="#Line_in">MP3 Encoding direct from line-in</a></li>
    <li><a href="#Patents">Patent Information</a></li>
</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="OpenSource">Free (open source) software
which supports or uses LAME:</a></h3>

<p><b>&nbsp;&nbsp;<a name="Multiplatform">Multiplatform:</a></b></p>

<ul>

    <li>
        <a href="https://ffmpeg.org/">FFmpeg</a> An awesome collection of codecs 
        (libavcodec) for pretty much all popular audio and video formats.
    </li>
    
    <li>
        <a href="http://www.freac.org/">fre:ac - free audio converter</a> Yet 
        another CD ripper, encoder &amp; converter that uses LAME for MP3 encoding.
   </li>

    <li>
        <a href="http://traverso-daw.org/">Traverso</a>, a cross-platform Digital
        Audio Workstation (DAW).
    </li>

    <li>
        <a href="http://www.turnstyle.com/andromeda/">andromeda</a> (PHP and ASP)
        Dynamically presents collections of mp3s as streaming web sites.
    </li>

    <li>
        <a href="http://www.getid3.org">getID3()</a> (PHP) PHP5 script that
        extracts useful information from MP3s &amp; other multimedia file formats.
        Reads LAME tags.
    </li>
    
    <li>
        <a href="https://github.com/chrisstaite/lameenc">lameenc</a> (Python) A 
        Python module to access the LAME encoding functions.
    </li>

    <li>
        <a href="http://rip.sourceforge.net">rip</a> (Perl) Script for ripping
        and encoding.
    </li>

    <li>
        <a href="http://www.videolan.org">VideoLAN</a> A powerful multimedia
        player and streaming solution for Win32, Linux, MacOS, BeOS...
    </li>

    <li>
        <a href="http://www.audacityteam.org/">Audacity</a> Open source
        multiplatform audio editor.
    </li>

    <li>
        <a href="http://www.rbri.org/jripper">jRipper</a> (Java) CD ripper 
        frontend.
    </li>

</ul>

<p><b>&nbsp;&nbsp;<a name="Posix">UNIX and UNIX-like (Linux, MacOS X, BSD, Solaris,
etc.): </a></b></p>

<ul>

    <li>
        <a href="https://userbase.kde.org/K3b">k3b</a> An exceptional CD burning
        and ripping frontend for KDE.
    </li>

    <li>
        <a href="https://sourceforge.net/projects/ripperx/">ripperX</a> GTK 
        frontend for rippers and several encoders featuring CDDB support.
    </li>

    <li>
        <a href="http://tear.sourceforge.net/">T.E.A.R.</a> frontend to LAME,
        cdparanoia and CDDB.
    </li>

    <li>
        <a href="http://www.amb.org/xmcd/">XMCD</a> CD Player with CDDB and
        ripping to MP3 and OGG.
    </li>

    <li>
        <a href="http://www.agouros.de/dlame/">DLame</a> Perl script to
        distribute the LAME encoding task among several machines in a network.
    </li>

    <li>
        <a href="http://scara.com/strec/">Strec</a> Stream recorder - A perl
        wrapper for dsproxy, realplayer and LAME.
    </li>

    <li>
        <a href="http://tcdr.sourceforge.net/">TCDR</a> a menu-driven console
        frontend for CD recording and ripping that uses LAME to rip CDs into MP3
        files.
    </li>

    <li>
        <a href="http://www.darkice.org/">DarkIce</a> Live streamer for IceCast.
    </li>

    <li>
        <a href="http://star.arm.ac.uk/%7Espm/software/liveice.html">LiveIce</a>
        Real time streaming of mp3s. Works with <a
        href="http://www.icecast.org">IceCast</a>.
    </li>

    <li>
        <a href="http://muse.dyne.org">MuSE</a> A mixing, encoding and streaming
        engine.
    </li>

    <li>
        <a href="http://f4l.sourceforge.net/">Flash For Linux</a> a Flash-like
        development library.
    </li>

    <li>
        <a href="http://lly.org/~rcw/abcde/page/">ABCDE</a> "A Better CD Encoder"
        - Shell script to automatize ripping, encoding and tagging process.
    </li>

    <li>
        <a href="http://arson.sourceforge.net">Arson</a> - a KDE fronted to CD
        burning and ripping tools.
    </li>

</ul>

<p><b>&nbsp;&nbsp;<a name="MacOS">MacOS Classic:</a></b></p>

<ul>

    <li>
        <a href="http://philippe.laval.free.fr/DropMP3/index_en.php">DropMP3</a> 
        includes LAME binaries.
    </li>

</ul>

<p><b>&nbsp;&nbsp;<a name="Windows">Windows:</a></b></p>

<ul>

    <li>
        <a href="http://www.rarewares.org/mp3-lamedrop.php">LameDropXPd</a>
        OggDrop style drag'n'drop frontend.
    </li>

    <li>
        <a href="http://www.labdv.com/dvdx/">DVDx</a> DVD to VCD/SVCD/AVI(XviD...)
        one-step converter.
    </li>

    <li>
        <a href="https://github.com/dswigger/lamex">LAMEX</a> An activex control
        for LAME, and a GUI. Source code only, includes LAME.
    </li>

    <li>
        <a href="http://m3w.sourceforge.net/">m3w</a> A live mp3 streamer for 
        the WWW. Works with LAME, icecast, soundcard input.
    </li>

    <li>
        <a href="http://out-lame.sourceforge.net/">out_lame</a> Winamp output
        plug-in. Create MP3 files directly from Winamp! (this functionality is 
        built-in since Winamp 5)
    </li>

    <li>
        <a href="http://www.dors.de/razorlame/index.php">RazorLame</a> The
        RazorBlade front end now supports LAME.
    </li>

    <li>
        <a href="https://winlame.sourceforge.io/">winLAME</a> The only *nice*
        windows UI for LAME, according to the author :-)
    </li>

    <li>
        <a href="https://sourceforge.net/projects/bbc2mp3/">bbc2mp3</a> a tool for
        saving BBC "Listen Again" programmes as MP3 files.
    </li>

    <li>
        <a href="https://autohotkey.com/board/topic/66927-aarons-sonar-mp3-patch-v564/">Aaron's 
        Sonar Mp3 Patch</a> a Cakewalk Sonar plugin written in AutoHotkey.
    </li>

</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="ClosedSource">Free (closed source) software
which supports or uses LAME:</a></h3>

<ul>

    <li>
        <a href="http://www.winamp.com">WinAmp</a> (Win) probably the most
        famous audio player. Can rip CDs and encode files using LAME.
    </li>

    <li>
        <a href="http://www.foobar2000.org">Foobar2000</a> (Win) an audio
        player with spartan interface but lots of components and an almost
        fanatical focus on audio quality.
    </li>

    <li>
        <a href="http://www.audiograbber.org/">Audiograbber</a> (Win) CD 
        ripper/encoder.
    </li>

    <li>
        <a href="http://www.exactaudiocopy.de">EAC</a> (Win) Exact Audio
        Copy: High quality CD ripper.
    </li>
    
    <li>
        <a href="http://www.zlurp.com">ZLURP</a> (Win, Mac) Ripper and
        encoder. Includes LAME binaries.
    </li>

    <li>
       <a href="http://www.wavosaur.com/">Wavosaur</a> (Win) Free audio editor 
       and batch processor.
    </li>
    
    <li>
       <a href="https://www.batch-mp3-converter.com">Batch MP3 Audio Converter</a>
       (Win) is a featureful LAME batch encoding and decoding frontend.
    </li>
    
    <li>
       <a href="https://www.batch-mp3-concatenator.com">Batch MP3 Audio 
       Concatenator</a> (Win) is a batch MP3 file merger.
    </li>

    <li>
        <a href="http://www.fridgesoft.de/harddiskogg.php">Hard Disk Ogg</a> 
        (Win) a line-in recorder that can encode directly to MP3, among other 
        formats.
    </li>

    <li>
        <a href="http://freshmeat.net/projects/wlame/">WORM MP3 Encoder</a>
        (Win) MP3 encoder based on LAME with reported improvements.
    </li>
  
    <li>
        <a href="https://www.batch-slideshow-creator.com">Batch Slideshow 
        Creator</a> (Win) a program that creates slide show videos from 
        sequences of images. Can use LAME to add a soundtrack.
    </li>

    <li>
        <a href="https://www.macupdate.com/app/mac/8837/itunes-lame-encoder">
        iTunes-LAME</a> (Mac) Integrates LAME into Apple iTunes, as an 
        alternative to the default (rather poor) encoder.
    </li>

    <li>
        <a href="https://funkatron.com/posts/lamebrain_a_lame_based_mp3_encoder_and_cd_ripper.html">LameBrain</a>
        (Mac) LAME frontend for MacOS X.
    </li>

    <li>
        <a href="http://www.helsinki.fi/~lakahone/amiga/secondspin/">SecondSpin</a>
        (Amiga) ripper &amp; encoder.
    </li>

</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font size="-1">^</font>
</sup></a> <a name="Commercial">Commercial software which supports or uses 
LAME:</a></h3>

<ul>

    <li>
        <a href="https://www.steinberg.net/en/products/wavelab/start.html">WaveLab</a> 
        (Win) digital audio editing software.
    </li>

   <li>
        <a href="https://www.tracktion.com/">Tracktion WaveForm</a> (Win/Mac/Linux) 
        a sequencer that uses LAME to export to MP3.
   </li>

    <li>
        <a href="http://www.goldwave.com/">Goldwave</a> (Win) audio editor.
    </li>

   <li>
        <a href="http://www.dbpoweramp.com">dBpowerAMP</a> (Win) Rip and encode 
        to/from MP3, WMA, Vorbis and other audio formats.
    </li>

    <li>
        <a href="http://www.ezbsystems.com/ultraiso/">UltraISO</a> (Win) ISO CD 
        image builder, editor and extractor.
    </li>

    <li>
        <a href="https://jriver.com/">J. River Media Center</a> (Win) a media center 
        software that supports LAME for ripping, transcoding, and gapless playback.
    </li>

    <li>
        <a href="https://acondigital.com/products/acoustica-audio-editor/">Acoustica</a>
        (Win/Mac) digital audio editor
    </li>

    <li>
        <a href="http://audioedit.mystikmedia.com">AudioEdit Deluxe</a> (Win)
        sound editor.
    </li>

    <li>
        <a href="http://www.blazemp.com/">Blaze Media Pro</a> (Win) audio/video
        converter, editor, CD/DVD burner, and more.
    </li>

    <li>
        <a href="http://www.audioease.com/index.php">Audio Ease BarbaBatch</a> 
        (Mac) batch audio file converter.
    </li>

    <li>
        <a href="http://www.hairersoft.com/index.html">Amadeus</a> (Mac)
        manipulate, create and analyze sounds.
    </li>

    <li>
        <a href="http://nextup.com/">Text Aloud MP3</a> (Win) converts text 
        into speech.
    </li>

    <li>
        <a href="http://www.highcriteria.com/">TotalRecorder</a> (Win) universal 
        sound recoder.
    </li>

    <li>
        <a href="http://www.ejay.com/">eJay DJ Mix Station / Dance eJay</a> (Win)
        a variety of DJ software, using Gogo.
    </li>

    <li>
        <a href="https://www.poikosoft.com">Easy CD-DA Extractor</a> (Win)
        ripper/encoder, includes LAME binaries.
    </li>

    <li>
        <a href="http://www.mp3observer.com">MP3 Observer</a> (Win) MP3 file-manager,
        ID3 tag editor, playlist creator and CD-archiving tool.
    </li>

    <li>
        <a href="http://www.iprogramdev.com/">Visual MP3</a> (Win) jukebox
        software with Karaoke support.
    </li>

    <li>
        <a href="http://www.flashdig.com/">Flash Digger Plus</a> (Win) a Shockwave
        Flash decompiler.
    </li>

</ul>

<hr />

<!--<h3><a href="#Contents"><sup><font size="-1">^</font></sup></a> <a name="Shame">
HALL OF SHAME</a></h3>

<h4>The following companies/products have been known to infringe LAME copyright
by not respecting the terms and conditions of our license.</h4>

<ul>

    <li>
        <a href="http://www.smart-soft.net/">Smart-Soft</a> - all of their producs
        that encode to MP3 use LAME or GOGO without abiding to the license. That
        includes <a href="http://www.smartcdripper.com/"> Smart CD Ripper</a>, <a
        href="http://www.smartmp3converter.com/">Smart MP3 converter</a> and <a
        href="http://www.smartwavconverter.com/">Smart WAV converter</a>.
    </li>

</ul>

<p><strong>If you want your company name to be removed from this list because
you are now complying with the LAME license, please contact us.</strong></p>

<hr />-->

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="Binaries">LAME Binaries:</a></h3>

<h4>Windows:</h4>

<ul>

   <li>
        <a href="http://www.rarewares.org/index.php">RareWares</a> offers several
        compiled LAME versions, including modified versions featuring special
        functionality.
   </li>

</ul>

<h4>Linux:</h4>

<ul>

    <li>
        Ever since the MP3 patents <a href="#Patents">expired</a>, most Linux 
        distros provide LAME from their online repositories or installation 
        media. Otherwise, you can still locate installation packages at search 
        engines such as <a href="https://pkgs.org/download/lame">pkgs.org</a>
        or <a href="https://rpm.pbone.net/">RPM search</a>.
    </li>

</ul>

<h4>MacOS X:</h4>

<ul>

    <li>
        <a href="http://karaoke.kjams.com/wiki/Lame">KJams</a> has a QuickTime
        component, which allows you to export audio from QuickTime and related
        apps to MP3 using LAME.
    </li>

    <li>
        The <a href="http://pdb.finkproject.org/pdb/package.php/lame">FINK</a> 
        project provides LAME binaries compiled for MacOS X.
    </li>

</ul>

<h4>Etc.:</h4>

<ul>

    <li>
        <a href="https://www.opencsw.org/packages/CSWlame/">OpenCSW</a> 
        provides up-to-date binaries for several versions of Sun Solaris, both
        SPARC and x86 architectures.
    </li>

    <li>
        <a href="http://www.perzl.org/aix/index.php?n=Main.Lame">Michael Perlz</a>
        provides RPM packages with AIX binaries for several versions of LAME.
    </li>

    <li>
        <a href="http://www2.arnes.si/~mmilut/Lame.html">LAME Binary Distribution
        Point</a> - outdated, but with compiles for several obscure systems like 
        HP-UX, Irix, VMS, Tru64, etc.
    </li>

    <li>
        For those of you that just won't give up on your Amiga, check <a
        href="https://honeypot.net/the-amiga-alternative-audio-page/">The Amiga
        Alternative Audio Page</a> or <a
        href="http://amiga.sourceforge.net/">Amiga.SF</a>.
    </li>

</ul>

<hr />

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="Alternatives">Other MP3 Encoders:</a></h3>

<ul>

    <li>
        George Kotorlis created a multithreaded version of LAME called <a
        href="http://www.fiberpool.de/en/fiberpool_case_studies_fpmp3enc_overview.html">fpMP3Enc</a>
        based on his multicore framework <a href="http://www.fiberpool.de/en/fiberpool_overview.html">
        Fiber Pool</a>.
    </li>

    <li>
        <a href="http://www.marinecat.net/free/windows/mct_free.htm">GOGO-no-coda
        MP3 encoder</a> A forked version of LAME with many key routines rewritten
        in assembly (I.E, it's much faster). Uses the <a 
        href="http://www.nasm.us/">NASM assembler.</a>
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/mp3enc.php">FhG MP3enc</a> 3.1. The
        gold standard of encoders. All other encoders strive to sound this good.
        Demo version only encodes up to 30 seconds.<br />
        <i>Update: according to several listening tests, LAME already surpassed
        FhG encoders in quality at most bitrates. :-)</i>
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/l3enc.php">FhG l3enc</a>. The older
        brother of MP3enc. Very slow, but with quite decent quality.
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/fastencc.php">FhG Fastencc</a> this
        "free" encoder was created with libraries stolen from Fraunhofer. It is
        the faster brother of MP3enc, and also the only FhG encoder to offer VBR
        encoding. The stereo encoding is buggy and quality is not on par with 
        MP3enc or LAME.
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/blade.php">BladeEnc</a> One of the 
        first free encoders for Linux. Development stopped at version 0.94.2. 
        Quality is not satisfactory. Compiles for a myriad of platforms are 
        available <a href="http://www2.arnes.si/~mmilut/BladeEnc.html">here</a>.
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/xing.php">Xing MP3 encoder</a> 
        Good quality and very fast encoder. It is now the MP3 encoder used in 
        Real Player, and has been recently released under an Open Source license
        (the speed tweaks are still limited to Windows though, because they are
        written in MASM)
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/qdmc.php">QDesign MP3 encoder</a> 
        Horrible quality. Only listed here for completeness.
    </li>
    
    <li>
        <a href="https://www.mp3-tech.org/programmer/encoding.html">Shine</a> is
        a featureless, but clean and readable MP3 encoder by Gabriel Bouvigne of
        LAME fame. Great as a starting point or learning tool. Also probably the
        only open source, fixed point math MP3 encoder.
    </li>
    
    <li>
        <a href="download/dist10.tar.gz">dist10</a> - the MPEG (ISO) reference 
        MP1/2/3 encoders. Bad quality, very slow and buggy. Good as a starting 
        point, maybe?
    </li>

    <li>
        <a href="http://www.rarewares.org/rrw/">ReallyRareWares</a> is an online
        museum preserving obsolete and forgotten encoders for several audio
        formats, including old LAME versions and obscure MP3 encoders (most of
        these encoders are simple compiles of the dist10 MPEG reference sources
        with minimal tweaks, though).
    </li>
</ul>

<hr></hr>

<!--<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="Comparisons">MP3 Encoder Comparisons
based on <i>listening tests:</i></a></h3>

<ul>

    <li>
        <a href="http://ff123.net/">Lots of different MP3 encoders, using blind
        ABX tests</a>
    </li>

    <li>
        <a href="http://www.rjamorim.com/test/">Roberto's</a> page of public
        blind listening tests comparing several formats and encoders.
    </li>

    <li>
        <a href="http://www.listening-tests.info">Sebastian Mares'</a> listening
        tests
    </li>

</ul>-->

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="MP3_sites">MP3 Encoding Web Sites:</a></h3>

<ul>

    <li>
        <a href="https://hydrogenaud.io/">Hydrogenaudio</a> - Public discussion 
        forum focused on psychoacoustic audio compression, featuring an MP3 
        section.
    </li>

    <li>
        <a href="http://www.maz-sound.com/">MAZ Sound</a> Encoders and other
        audio software.
    </li>

</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="MP3_general">General MP3 Web Sites:</a></h3>

<ul>

    <li>
        Great site for technical information: <a
        href="http://www.mp3-tech.org">www.mp3-tech.org</a>
    </li>

    <li>
        <a href="http://www.rarewares.org/index.php">RareWares</a> - audio 
        coding-related download site featuring several audio formats besides MP3.
    </li>

    <li>
        <a href="http://wiki.hydrogenaud.io/index.php?title=Main_Page">
        HydrogenAudio's Wiki</a> is a repository of knowledge on audio-related
        matters.
    </li>

    <li>
        <a href="http://wiki.hydrogenaud.io/index.php?title=Recommended_LAME">
        HydrogenAudio's list of recommended LAME settings</a> to produce best
        quality encodes at several bitrates.
    </li>

    <li>
        <a href="https://cd-rw.org/">cd-rw.org</a> - The CD-R and MP3
        resource
    </li>

    <li>
        <a href="http://www.mpeg.org/MPEG/">MPEG.ORG</a> Many pointers and
        resources.
    </li>

</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="Soft_hard">MP3 Related Software and
Hardware:</a></h3>

<ul>

    <li>
        <a href="http://mpg123.de/">mpg123</a> is a fast, featureful and accurate 
        MP1/2/3 decoder that is actively developed and licensed under the LGPL.
    </li>

    <li>
        A favorite Linux ripper: <a
        href="https://www.xiph.org/paranoia/">cdparanoia</a> <i>(also, GNU's
        <a href="http://www.gnu.org/software/libcdio/">libcdio</a>, a
        multiplatform port of CDparanoia)</i>
    </li>

    <li>
        How to figure out which codec was used to make that mp3? Use <a
        href="http://www.rarewares.org/rrw/encspot.php">EncSpot</a>
    </li>

    <li>
        <a href="http://www.underbit.com/products/mad/">The MAD decoder</a> 24bit 
        and licensed under the GPL
    </li>

    <li>
        <a href="http://maaate.sourceforge.net/">Maate</a> looks like a
        very sophisticated MP3 analysis package. They also have a good
        description of MP3 frames.
    </li>

    <li>
        A nice .wav file viewer and editor: <a
        href="http://www.metadecks.org/software/sweep/index.html">sweep</a>
    </li>

    <li>
        <a href="http://www.mptrim.com/">mptrim</a>: Trim silence and adjust
        volume of mp3 files.
    </li>

    <li>
        <a href="http://programmierer.freepage.de/overmann/">mp3check</a>: A
        program to check integrity of mp3 files.
    </li>

    <li>
        <a href="http://minnie.tuhs.org/Programs/Mpcut/">Mpcut</a>: X11 mp3
        frame editor.
    </li>

    <li>
        <a href="https://sourceforge.net/projects/mp3asm/">mp3asm</a>: A program
        to cut and paste mp3 frames.
    </li>

    <li>
        <a href="http://www.chip.de/downloads/MP3-Splitter_27434282.html">MP3Splitter</a>:
        Win32 MP3 splitter with frame statistics.
    </li>

    <li>
        <a href="download/util/jchopwave.c">jchopwave</a>: Source code to a
        utility to split up .wav files.
    </li>

</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="Line_in">MP3 Encoding directly from
line-in:</a></h3>

<ul>

    <li>
        <a href="http://www.netwaysglobal.com/mpegrec/">mpegrec</a>: Linux/Win32
        line-in/mic MP3 recorder (requires LAME).
    </li>

    <li>
        <a href="http://ldb.tpv.ru/">MixMP3</a> for Windows - by Dmitry Lesnikov
    </li>

    <li>
        <a href="http://messer.aerolit.pl/">Messer</a> for Windows - by Dariusz 
        Sieradzki
    </li>

</ul>

<h3><a href="#Contents" style="text-decoration: none"><sup><font
size="-1">^</font></sup></a> <a name="Patents">Patent Information:</a></h3>

<h4><i>By April 23rd, 2017 all relevant software patents applying to MP3 
compression technology had expired. MP3 is now considered to be a patent-free
format, and licenses are not being collected anymore. Anyone is free to implement
the specification and distribute the implementation.</i></h4>

<ul>

    <li>
        Some information from the source themselves: <a
        href="http://www.mp3licensing.com">Fraunhofer IIS</a>
    </li>

    <li>
        A more accurate portrayal of the situation can be found on <a
        href="http://www.mp3-tech.org">www.mp3-tech.org</a>
    </li>

    <!--<li>  Disappeared
        Eric Scheirer's <a href="http://web.media.mit.edu/%7Eeds/mpeg-patents-faq">
        FAQ: MPEG, Patents, and Audio Coding</a>
    </li>-->

</ul>

<p>
    <i>If you know of some interesting software supporting LAME that is not
    featured here, or if you spot a broken link, please contact the <a
    href="mailto:rjamorim@users.sourceforge.net">webmaster</a>.<br/>
    If you are submitting your own software, please include a brief description
    of it in the e-mail.</i><br />
    <b><i>DO NOT USE THAT E-MAIL FOR SUPPORT QUESTIONS! GO <a
    href="http://lame.sourceforge.net/contact.php">HERE</a> INSTEAD.</i></b>
</p>

</div>
<?php include("footer.html") ?>
</div>

</body>
</html>