// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/storagetransfer/v1/transfer_types.proto

package storagetransfer

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	date "google.golang.org/genproto/googleapis/type/date"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The status of the transfer job.
type TransferJob_Status int32

const (
	// Zero is an illegal value.
	TransferJob_STATUS_UNSPECIFIED TransferJob_Status = 0
	// New transfers will be performed based on the schedule.
	TransferJob_ENABLED TransferJob_Status = 1
	// New transfers will not be scheduled.
	TransferJob_DISABLED TransferJob_Status = 2
	// This is a soft delete state. After a transfer job is set to this
	// state, the job and all the transfer executions are subject to
	// garbage collection. Transfer jobs become eligible for garbage collection
	// 30 days after their status is set to `DELETED`.
	TransferJob_DELETED TransferJob_Status = 3
)

// Enum value maps for TransferJob_Status.
var (
	TransferJob_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "DELETED",
	}
	TransferJob_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"ENABLED":            1,
		"DISABLED":           2,
		"DELETED":            3,
	}
)

func (x TransferJob_Status) Enum() *TransferJob_Status {
	p := new(TransferJob_Status)
	*p = x
	return p
}

func (x TransferJob_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferJob_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[0].Descriptor()
}

func (TransferJob_Status) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[0]
}

func (x TransferJob_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferJob_Status.Descriptor instead.
func (TransferJob_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{11, 0}
}

// Enum for specifying event types for which notifications are to be
// published.
//
// Additional event types may be added in the future. Clients should either
// safely ignore unrecognized event types or explicitly specify which event
// types they are prepared to accept.
type NotificationConfig_EventType int32

const (
	// Illegal value, to avoid allowing a default.
	NotificationConfig_EVENT_TYPE_UNSPECIFIED NotificationConfig_EventType = 0
	// `TransferOperation` completed with status
	// [SUCCESS][google.storagetransfer.v1.TransferOperation.Status.SUCCESS].
	NotificationConfig_TRANSFER_OPERATION_SUCCESS NotificationConfig_EventType = 1
	// `TransferOperation` completed with status
	// [FAILED][google.storagetransfer.v1.TransferOperation.Status.FAILED].
	NotificationConfig_TRANSFER_OPERATION_FAILED NotificationConfig_EventType = 2
	// `TransferOperation` completed with status
	// [ABORTED][google.storagetransfer.v1.TransferOperation.Status.ABORTED].
	NotificationConfig_TRANSFER_OPERATION_ABORTED NotificationConfig_EventType = 3
)

// Enum value maps for NotificationConfig_EventType.
var (
	NotificationConfig_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "TRANSFER_OPERATION_SUCCESS",
		2: "TRANSFER_OPERATION_FAILED",
		3: "TRANSFER_OPERATION_ABORTED",
	}
	NotificationConfig_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":     0,
		"TRANSFER_OPERATION_SUCCESS": 1,
		"TRANSFER_OPERATION_FAILED":  2,
		"TRANSFER_OPERATION_ABORTED": 3,
	}
)

func (x NotificationConfig_EventType) Enum() *NotificationConfig_EventType {
	p := new(NotificationConfig_EventType)
	*p = x
	return p
}

func (x NotificationConfig_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationConfig_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[1].Descriptor()
}

func (NotificationConfig_EventType) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[1]
}

func (x NotificationConfig_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationConfig_EventType.Descriptor instead.
func (NotificationConfig_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{15, 0}
}

// Enum for specifying the format of a notification message's payload.
type NotificationConfig_PayloadFormat int32

const (
	// Illegal value, to avoid allowing a default.
	NotificationConfig_PAYLOAD_FORMAT_UNSPECIFIED NotificationConfig_PayloadFormat = 0
	// No payload is included with the notification.
	NotificationConfig_NONE NotificationConfig_PayloadFormat = 1
	// `TransferOperation` is [formatted as a JSON
	// response](https://developers.google.com/protocol-buffers/docs/proto3#json),
	// in application/json.
	NotificationConfig_JSON NotificationConfig_PayloadFormat = 2
)

// Enum value maps for NotificationConfig_PayloadFormat.
var (
	NotificationConfig_PayloadFormat_name = map[int32]string{
		0: "PAYLOAD_FORMAT_UNSPECIFIED",
		1: "NONE",
		2: "JSON",
	}
	NotificationConfig_PayloadFormat_value = map[string]int32{
		"PAYLOAD_FORMAT_UNSPECIFIED": 0,
		"NONE":                       1,
		"JSON":                       2,
	}
)

func (x NotificationConfig_PayloadFormat) Enum() *NotificationConfig_PayloadFormat {
	p := new(NotificationConfig_PayloadFormat)
	*p = x
	return p
}

func (x NotificationConfig_PayloadFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationConfig_PayloadFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[2].Descriptor()
}

func (NotificationConfig_PayloadFormat) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[2]
}

func (x NotificationConfig_PayloadFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationConfig_PayloadFormat.Descriptor instead.
func (NotificationConfig_PayloadFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{15, 1}
}

// The status of a TransferOperation.
type TransferOperation_Status int32

const (
	// Zero is an illegal value.
	TransferOperation_STATUS_UNSPECIFIED TransferOperation_Status = 0
	// In progress.
	TransferOperation_IN_PROGRESS TransferOperation_Status = 1
	// Paused.
	TransferOperation_PAUSED TransferOperation_Status = 2
	// Completed successfully.
	TransferOperation_SUCCESS TransferOperation_Status = 3
	// Terminated due to an unrecoverable failure.
	TransferOperation_FAILED TransferOperation_Status = 4
	// Aborted by the user.
	TransferOperation_ABORTED TransferOperation_Status = 5
	// Temporarily delayed by the system. No user action is required.
	TransferOperation_QUEUED TransferOperation_Status = 6
)

// Enum value maps for TransferOperation_Status.
var (
	TransferOperation_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "PAUSED",
		3: "SUCCESS",
		4: "FAILED",
		5: "ABORTED",
		6: "QUEUED",
	}
	TransferOperation_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"IN_PROGRESS":        1,
		"PAUSED":             2,
		"SUCCESS":            3,
		"FAILED":             4,
		"ABORTED":            5,
		"QUEUED":             6,
	}
)

func (x TransferOperation_Status) Enum() *TransferOperation_Status {
	p := new(TransferOperation_Status)
	*p = x
	return p
}

func (x TransferOperation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferOperation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[3].Descriptor()
}

func (TransferOperation_Status) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[3]
}

func (x TransferOperation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferOperation_Status.Descriptor instead.
func (TransferOperation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{16, 0}
}

// Google service account
type GoogleServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of the service account.
	AccountEmail string `protobuf:"bytes,1,opt,name=account_email,json=accountEmail,proto3" json:"account_email,omitempty"`
	// Unique identifier for the service account.
	SubjectId string `protobuf:"bytes,2,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
}

func (x *GoogleServiceAccount) Reset() {
	*x = GoogleServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleServiceAccount) ProtoMessage() {}

func (x *GoogleServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleServiceAccount.ProtoReflect.Descriptor instead.
func (*GoogleServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{0}
}

func (x *GoogleServiceAccount) GetAccountEmail() string {
	if x != nil {
		return x.AccountEmail
	}
	return ""
}

func (x *GoogleServiceAccount) GetSubjectId() string {
	if x != nil {
		return x.SubjectId
	}
	return ""
}

// AWS access key (see
// [AWS Security
// Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)).
//
// For information on our data retention policy for user credentials, see
// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
type AwsAccessKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. AWS access key ID.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// Required. AWS secret access key. This field is not returned in RPC
	// responses.
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
}

func (x *AwsAccessKey) Reset() {
	*x = AwsAccessKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsAccessKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsAccessKey) ProtoMessage() {}

func (x *AwsAccessKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsAccessKey.ProtoReflect.Descriptor instead.
func (*AwsAccessKey) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{1}
}

func (x *AwsAccessKey) GetAccessKeyId() string {
	if x != nil {
		return x.AccessKeyId
	}
	return ""
}

func (x *AwsAccessKey) GetSecretAccessKey() string {
	if x != nil {
		return x.SecretAccessKey
	}
	return ""
}

// Azure credentials
//
// For information on our data retention policy for user credentials, see
// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
type AzureCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Azure shared access signature (SAS).
	//
	// <aside class="note">
	// <strong>Note:</strong>Copying data from Azure Data Lake
	// Storage (ADLS) Gen 2 is in [Preview](/products/#product-launch-stages).
	// During Preview, if you are copying data from ADLS Gen 2, you must use an
	// account SAS.
	// </aside>
	//
	// For more information about SAS, see
	// [Grant limited access to Azure Storage resources using shared access
	// signatures
	// (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
	SasToken string `protobuf:"bytes,2,opt,name=sas_token,json=sasToken,proto3" json:"sas_token,omitempty"`
}

func (x *AzureCredentials) Reset() {
	*x = AzureCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureCredentials) ProtoMessage() {}

func (x *AzureCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureCredentials.ProtoReflect.Descriptor instead.
func (*AzureCredentials) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{2}
}

func (x *AzureCredentials) GetSasToken() string {
	if x != nil {
		return x.SasToken
	}
	return ""
}

// Conditions that determine which objects will be transferred. Applies only
// to Cloud Data Sources such as S3, Azure, and Cloud Storage.
//
// The "last modification time" refers to the time of the
// last change to the object's content or metadata — specifically, this is
// the `updated` property of Cloud Storage objects, the `LastModified` field
// of S3 objects, and the `Last-Modified` header of Azure blobs.
type ObjectConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If specified, only objects with a "last modification time" before
	// `NOW` - `min_time_elapsed_since_last_modification` and objects that don't
	//  have a "last modification time" are transferred.
	//
	// For each [TransferOperation][google.storagetransfer.v1.TransferOperation]
	// started by this [TransferJob][google.storagetransfer.v1.TransferJob], `NOW`
	// refers to the [start_time]
	// [google.storagetransfer.v1.TransferOperation.start_time] of the
	// `TransferOperation`.
	MinTimeElapsedSinceLastModification *durationpb.Duration `protobuf:"bytes,1,opt,name=min_time_elapsed_since_last_modification,json=minTimeElapsedSinceLastModification,proto3" json:"min_time_elapsed_since_last_modification,omitempty"`
	// If specified, only objects with a "last modification time" on or after
	// `NOW` - `max_time_elapsed_since_last_modification` and objects that don't
	// have a "last modification time" are transferred.
	//
	// For each [TransferOperation][google.storagetransfer.v1.TransferOperation]
	// started by this [TransferJob][google.storagetransfer.v1.TransferJob],
	// `NOW` refers to the [start_time]
	// [google.storagetransfer.v1.TransferOperation.start_time] of the
	// `TransferOperation`.
	MaxTimeElapsedSinceLastModification *durationpb.Duration `protobuf:"bytes,2,opt,name=max_time_elapsed_since_last_modification,json=maxTimeElapsedSinceLastModification,proto3" json:"max_time_elapsed_since_last_modification,omitempty"`
	// If you specify `include_prefixes`, Storage Transfer Service uses the items
	// in the `include_prefixes` array to determine which objects to include in a
	// transfer. Objects must start with one of the matching `include_prefixes`
	// for inclusion in the transfer. If [exclude_prefixes]
	// [google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
	// objects must not start with any of the `exclude_prefixes` specified for
	// inclusion in the transfer.
	//
	// The following are requirements of `include_prefixes`:
	//
	//   * Each include-prefix can contain any sequence of Unicode characters, to
	//     a max length of 1024 bytes when UTF8-encoded, and must not contain
	//     Carriage Return or Line Feed characters.  Wildcard matching and regular
	//     expression matching are not supported.
	//
	//   * Each include-prefix must omit the leading slash. For example, to
	//     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
	//     specify the include-prefix as `logs/y=2015/requests.gz`.
	//
	//   * None of the include-prefix values can be empty, if specified.
	//
	//   * Each include-prefix must include a distinct portion of the object
	//     namespace. No include-prefix may be a prefix of another
	//     include-prefix.
	//
	// The max size of `include_prefixes` is 1000.
	//
	// For more information, see [Filtering objects from
	// transfers](/storage-transfer/docs/filtering-objects-from-transfers).
	IncludePrefixes []string `protobuf:"bytes,3,rep,name=include_prefixes,json=includePrefixes,proto3" json:"include_prefixes,omitempty"`
	// If you specify `exclude_prefixes`, Storage Transfer Service uses the items
	// in the `exclude_prefixes` array to determine which objects to exclude from
	// a transfer. Objects must not start with one of the matching
	// `exclude_prefixes` for inclusion in a transfer.
	//
	// The following are requirements of `exclude_prefixes`:
	//
	//   * Each exclude-prefix can contain any sequence of Unicode characters, to
	//     a max length of 1024 bytes when UTF8-encoded, and must not contain
	//     Carriage Return or Line Feed characters.  Wildcard matching and regular
	//     expression matching are not supported.
	//
	//   * Each exclude-prefix must omit the leading slash. For example, to
	//     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
	//     specify the exclude-prefix as `logs/y=2015/requests.gz`.
	//
	//   * None of the exclude-prefix values can be empty, if specified.
	//
	//   * Each exclude-prefix must exclude a distinct portion of the object
	//     namespace. No exclude-prefix may be a prefix of another
	//     exclude-prefix.
	//
	//   * If [include_prefixes]
	//     [google.storagetransfer.v1.ObjectConditions.include_prefixes] is
	//     specified, then each exclude-prefix must start with the value of a path
	//     explicitly included by `include_prefixes`.
	//
	// The max size of `exclude_prefixes` is 1000.
	//
	// For more information, see [Filtering objects from
	// transfers](/storage-transfer/docs/filtering-objects-from-transfers).
	ExcludePrefixes []string `protobuf:"bytes,4,rep,name=exclude_prefixes,json=excludePrefixes,proto3" json:"exclude_prefixes,omitempty"`
	// If specified, only objects with a "last modification time" on or after
	// this timestamp and objects that don't have a "last modification time" are
	// transferred.
	//
	// The `last_modified_since` and `last_modified_before` fields can be used
	// together for chunked data processing. For example, consider a script that
	// processes each day's worth of data at a time. For that you'd set each
	// of the fields as follows:
	//
	// *  `last_modified_since` to the start of the day
	//
	// *  `last_modified_before` to the end of the day
	LastModifiedSince *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_modified_since,json=lastModifiedSince,proto3" json:"last_modified_since,omitempty"`
	// If specified, only objects with a "last modification time" before this
	// timestamp and objects that don't have a "last modification time" will be
	// transferred.
	LastModifiedBefore *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_modified_before,json=lastModifiedBefore,proto3" json:"last_modified_before,omitempty"`
}

func (x *ObjectConditions) Reset() {
	*x = ObjectConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectConditions) ProtoMessage() {}

func (x *ObjectConditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectConditions.ProtoReflect.Descriptor instead.
func (*ObjectConditions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{3}
}

func (x *ObjectConditions) GetMinTimeElapsedSinceLastModification() *durationpb.Duration {
	if x != nil {
		return x.MinTimeElapsedSinceLastModification
	}
	return nil
}

func (x *ObjectConditions) GetMaxTimeElapsedSinceLastModification() *durationpb.Duration {
	if x != nil {
		return x.MaxTimeElapsedSinceLastModification
	}
	return nil
}

func (x *ObjectConditions) GetIncludePrefixes() []string {
	if x != nil {
		return x.IncludePrefixes
	}
	return nil
}

func (x *ObjectConditions) GetExcludePrefixes() []string {
	if x != nil {
		return x.ExcludePrefixes
	}
	return nil
}

func (x *ObjectConditions) GetLastModifiedSince() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedSince
	}
	return nil
}

func (x *ObjectConditions) GetLastModifiedBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedBefore
	}
	return nil
}

// In a GcsData resource, an object's name is the Cloud Storage object's
// name and its "last modification time" refers to the object's `updated`
// property of Cloud Storage objects, which changes when the content or the
// metadata of the object is updated.
type GcsData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage bucket name. Must meet
	// [Bucket Name Requirements](/storage/docs/naming#requirements).
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// Root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This field
	// is treated as an object prefix. As such, it should generally not begin with
	// a '/'.
	//
	// The root path value must meet
	// [Object Name Requirements](/storage/docs/naming#objectnames).
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *GcsData) Reset() {
	*x = GcsData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsData) ProtoMessage() {}

func (x *GcsData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsData.ProtoReflect.Descriptor instead.
func (*GcsData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{4}
}

func (x *GcsData) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *GcsData) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// An AwsS3Data resource can be a data source, but not a data sink.
// In an AwsS3Data resource, an object's name is the S3 object's key name.
type AwsS3Data struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. S3 Bucket name (see
	// [Creating a
	// bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// Input only. AWS access key used to sign the API requests to the AWS S3
	// bucket. Permissions on the bucket must be granted to the access ID of the
	// AWS access key. This field is required.
	//
	// For information on our data retention policy for user credentials, see
	// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
	AwsAccessKey *AwsAccessKey `protobuf:"bytes,2,opt,name=aws_access_key,json=awsAccessKey,proto3" json:"aws_access_key,omitempty"`
	// Root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This field
	// is treated as an object prefix. As such, it should generally not begin with
	// a '/'.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Input only. Role arn to support temporary credentials via
	// AssumeRoleWithWebIdentity.
	//
	// When role arn is provided, transfer service will fetch temporary
	// credentials for the session using AssumeRoleWithWebIdentity call for the
	// provided role using the [GoogleServiceAccount] for this project.
	RoleArn string `protobuf:"bytes,4,opt,name=role_arn,json=roleArn,proto3" json:"role_arn,omitempty"`
}

func (x *AwsS3Data) Reset() {
	*x = AwsS3Data{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsS3Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsS3Data) ProtoMessage() {}

func (x *AwsS3Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsS3Data.ProtoReflect.Descriptor instead.
func (*AwsS3Data) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{5}
}

func (x *AwsS3Data) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *AwsS3Data) GetAwsAccessKey() *AwsAccessKey {
	if x != nil {
		return x.AwsAccessKey
	}
	return nil
}

func (x *AwsS3Data) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AwsS3Data) GetRoleArn() string {
	if x != nil {
		return x.RoleArn
	}
	return ""
}

// An AzureBlobStorageData resource can be a data source, but not a data sink.
// An AzureBlobStorageData resource represents one Azure container. The storage
// account determines the [Azure
// endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints).
// In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob
// Storage blob's key
// name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
type AzureBlobStorageData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Azure Storage account.
	StorageAccount string `protobuf:"bytes,1,opt,name=storage_account,json=storageAccount,proto3" json:"storage_account,omitempty"`
	// Required. Input only. Credentials used to authenticate API requests to
	// Azure.
	//
	// For information on our data retention policy for user credentials, see
	// [User credentials](/storage-transfer/docs/data-retention#user-credentials).
	AzureCredentials *AzureCredentials `protobuf:"bytes,2,opt,name=azure_credentials,json=azureCredentials,proto3" json:"azure_credentials,omitempty"`
	// Required. The container to transfer from the Azure Storage account.
	Container string `protobuf:"bytes,4,opt,name=container,proto3" json:"container,omitempty"`
	// Root path to transfer objects.
	//
	// Must be an empty string or full path name that ends with a '/'. This field
	// is treated as an object prefix. As such, it should generally not begin with
	// a '/'.
	Path string `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *AzureBlobStorageData) Reset() {
	*x = AzureBlobStorageData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureBlobStorageData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureBlobStorageData) ProtoMessage() {}

func (x *AzureBlobStorageData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureBlobStorageData.ProtoReflect.Descriptor instead.
func (*AzureBlobStorageData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{6}
}

func (x *AzureBlobStorageData) GetStorageAccount() string {
	if x != nil {
		return x.StorageAccount
	}
	return ""
}

func (x *AzureBlobStorageData) GetAzureCredentials() *AzureCredentials {
	if x != nil {
		return x.AzureCredentials
	}
	return nil
}

func (x *AzureBlobStorageData) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *AzureBlobStorageData) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// An HttpData resource specifies a list of objects on the web to be transferred
// over HTTP.  The information of the objects to be transferred is contained in
// a file referenced by a URL. The first line in the file must be
// `"TsvHttpData-1.0"`, which specifies the format of the file.  Subsequent
// lines specify the information of the list of objects, one object per list
// entry. Each entry has the following tab-delimited fields:
//
// * **HTTP URL** — The location of the object.
//
// * **Length** — The size of the object in bytes.
//
// * **MD5** — The base64-encoded MD5 hash of the object.
//
// For an example of a valid TSV file, see
// [Transferring data from
// URLs](https://cloud.google.com/storage-transfer/docs/create-url-list).
//
// When transferring data based on a URL list, keep the following in mind:
//
// * When an object located at `http(s)://hostname:port/<URL-path>` is
// transferred to a data sink, the name of the object at the data sink is
// `<hostname>/<URL-path>`.
//
// * If the specified size of an object does not match the actual size of the
// object fetched, the object will not be transferred.
//
// * If the specified MD5 does not match the MD5 computed from the transferred
// bytes, the object transfer will fail.
//
// * Ensure that each URL you specify is publicly accessible. For
// example, in Cloud Storage you can
// [share an object publicly]
// (/storage/docs/cloud-console#_sharingdata) and get a link to it.
//
// * Storage Transfer Service obeys `robots.txt` rules and requires the source
// HTTP server to support `Range` requests and to return a `Content-Length`
// header in each response.
//
// * [ObjectConditions][google.storagetransfer.v1.ObjectConditions] have no
// effect when filtering objects to transfer.
type HttpData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URL that points to the file that stores the object list
	// entries. This file must allow public access.  Currently, only URLs with
	// HTTP and HTTPS schemes are supported.
	ListUrl string `protobuf:"bytes,1,opt,name=list_url,json=listUrl,proto3" json:"list_url,omitempty"`
}

func (x *HttpData) Reset() {
	*x = HttpData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpData) ProtoMessage() {}

func (x *HttpData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpData.ProtoReflect.Descriptor instead.
func (*HttpData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{7}
}

func (x *HttpData) GetListUrl() string {
	if x != nil {
		return x.ListUrl
	}
	return ""
}

// TransferOptions define the actions to be performed on objects in a transfer.
type TransferOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When to overwrite objects that already exist in the sink. The default is
	// that only objects that are different from the source are ovewritten. If
	// true, all objects in the sink whose name matches an object in the source
	// will be overwritten with the source object.
	OverwriteObjectsAlreadyExistingInSink bool `protobuf:"varint,1,opt,name=overwrite_objects_already_existing_in_sink,json=overwriteObjectsAlreadyExistingInSink,proto3" json:"overwrite_objects_already_existing_in_sink,omitempty"`
	// Whether objects that exist only in the sink should be deleted.
	//
	// **Note:** This option and [delete_objects_from_source_after_transfer]
	// [google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer]
	// are mutually exclusive.
	DeleteObjectsUniqueInSink bool `protobuf:"varint,2,opt,name=delete_objects_unique_in_sink,json=deleteObjectsUniqueInSink,proto3" json:"delete_objects_unique_in_sink,omitempty"`
	// Whether objects should be deleted from the source after they are
	// transferred to the sink.
	//
	// **Note:** This option and [delete_objects_unique_in_sink]
	// [google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
	// are mutually exclusive.
	DeleteObjectsFromSourceAfterTransfer bool `protobuf:"varint,3,opt,name=delete_objects_from_source_after_transfer,json=deleteObjectsFromSourceAfterTransfer,proto3" json:"delete_objects_from_source_after_transfer,omitempty"`
}

func (x *TransferOptions) Reset() {
	*x = TransferOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferOptions) ProtoMessage() {}

func (x *TransferOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferOptions.ProtoReflect.Descriptor instead.
func (*TransferOptions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{8}
}

func (x *TransferOptions) GetOverwriteObjectsAlreadyExistingInSink() bool {
	if x != nil {
		return x.OverwriteObjectsAlreadyExistingInSink
	}
	return false
}

func (x *TransferOptions) GetDeleteObjectsUniqueInSink() bool {
	if x != nil {
		return x.DeleteObjectsUniqueInSink
	}
	return false
}

func (x *TransferOptions) GetDeleteObjectsFromSourceAfterTransfer() bool {
	if x != nil {
		return x.DeleteObjectsFromSourceAfterTransfer
	}
	return false
}

// Configuration for running a transfer.
type TransferSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The write sink for the data.
	//
	// Types that are assignable to DataSink:
	//	*TransferSpec_GcsDataSink
	DataSink isTransferSpec_DataSink `protobuf_oneof:"data_sink"`
	// The read source of the data.
	//
	// Types that are assignable to DataSource:
	//	*TransferSpec_GcsDataSource
	//	*TransferSpec_AwsS3DataSource
	//	*TransferSpec_HttpDataSource
	//	*TransferSpec_AzureBlobStorageDataSource
	DataSource isTransferSpec_DataSource `protobuf_oneof:"data_source"`
	// Only objects that satisfy these object conditions are included in the set
	// of data source and data sink objects.  Object conditions based on
	// objects' "last modification time" do not exclude objects in a data sink.
	ObjectConditions *ObjectConditions `protobuf:"bytes,5,opt,name=object_conditions,json=objectConditions,proto3" json:"object_conditions,omitempty"`
	// If the option
	// [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
	// is `true` and time-based object conditions such as 'last modification time'
	// are specified, the request fails with an
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
	TransferOptions *TransferOptions `protobuf:"bytes,6,opt,name=transfer_options,json=transferOptions,proto3" json:"transfer_options,omitempty"`
}

func (x *TransferSpec) Reset() {
	*x = TransferSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferSpec) ProtoMessage() {}

func (x *TransferSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferSpec.ProtoReflect.Descriptor instead.
func (*TransferSpec) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{9}
}

func (m *TransferSpec) GetDataSink() isTransferSpec_DataSink {
	if m != nil {
		return m.DataSink
	}
	return nil
}

func (x *TransferSpec) GetGcsDataSink() *GcsData {
	if x, ok := x.GetDataSink().(*TransferSpec_GcsDataSink); ok {
		return x.GcsDataSink
	}
	return nil
}

func (m *TransferSpec) GetDataSource() isTransferSpec_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *TransferSpec) GetGcsDataSource() *GcsData {
	if x, ok := x.GetDataSource().(*TransferSpec_GcsDataSource); ok {
		return x.GcsDataSource
	}
	return nil
}

func (x *TransferSpec) GetAwsS3DataSource() *AwsS3Data {
	if x, ok := x.GetDataSource().(*TransferSpec_AwsS3DataSource); ok {
		return x.AwsS3DataSource
	}
	return nil
}

func (x *TransferSpec) GetHttpDataSource() *HttpData {
	if x, ok := x.GetDataSource().(*TransferSpec_HttpDataSource); ok {
		return x.HttpDataSource
	}
	return nil
}

func (x *TransferSpec) GetAzureBlobStorageDataSource() *AzureBlobStorageData {
	if x, ok := x.GetDataSource().(*TransferSpec_AzureBlobStorageDataSource); ok {
		return x.AzureBlobStorageDataSource
	}
	return nil
}

func (x *TransferSpec) GetObjectConditions() *ObjectConditions {
	if x != nil {
		return x.ObjectConditions
	}
	return nil
}

func (x *TransferSpec) GetTransferOptions() *TransferOptions {
	if x != nil {
		return x.TransferOptions
	}
	return nil
}

type isTransferSpec_DataSink interface {
	isTransferSpec_DataSink()
}

type TransferSpec_GcsDataSink struct {
	// A Cloud Storage data sink.
	GcsDataSink *GcsData `protobuf:"bytes,4,opt,name=gcs_data_sink,json=gcsDataSink,proto3,oneof"`
}

func (*TransferSpec_GcsDataSink) isTransferSpec_DataSink() {}

type isTransferSpec_DataSource interface {
	isTransferSpec_DataSource()
}

type TransferSpec_GcsDataSource struct {
	// A Cloud Storage data source.
	GcsDataSource *GcsData `protobuf:"bytes,1,opt,name=gcs_data_source,json=gcsDataSource,proto3,oneof"`
}

type TransferSpec_AwsS3DataSource struct {
	// An AWS S3 data source.
	AwsS3DataSource *AwsS3Data `protobuf:"bytes,2,opt,name=aws_s3_data_source,json=awsS3DataSource,proto3,oneof"`
}

type TransferSpec_HttpDataSource struct {
	// An HTTP URL data source.
	HttpDataSource *HttpData `protobuf:"bytes,3,opt,name=http_data_source,json=httpDataSource,proto3,oneof"`
}

type TransferSpec_AzureBlobStorageDataSource struct {
	// An Azure Blob Storage data source.
	AzureBlobStorageDataSource *AzureBlobStorageData `protobuf:"bytes,8,opt,name=azure_blob_storage_data_source,json=azureBlobStorageDataSource,proto3,oneof"`
}

func (*TransferSpec_GcsDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_AwsS3DataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_HttpDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_AzureBlobStorageDataSource) isTransferSpec_DataSource() {}

// Transfers can be scheduled to recur or to run just once.
type Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The start date of a transfer. Date boundaries are determined
	// relative to UTC time. If `schedule_start_date` and
	// [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
	// are in the past relative to the job's creation time, the transfer starts
	// the day after you schedule the transfer request.
	//
	// **Note:** When starting jobs at or near midnight UTC it is possible that
	// a job will start later than expected. For example, if you send an outbound
	// request on June 1 one millisecond prior to midnight UTC and the Storage
	// Transfer Service server receives the request on June 2, then it will create
	// a TransferJob with `schedule_start_date` set to June 2 and a
	// `start_time_of_day` set to midnight UTC. The first scheduled
	// [TransferOperation][google.storagetransfer.v1.TransferOperation] will take
	// place on June 3 at midnight UTC.
	ScheduleStartDate *date.Date `protobuf:"bytes,1,opt,name=schedule_start_date,json=scheduleStartDate,proto3" json:"schedule_start_date,omitempty"`
	// The last day a transfer runs. Date boundaries are determined relative to
	// UTC time. A job will run once per 24 hours within the following guidelines:
	//
	// *   If `schedule_end_date` and
	// [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date]
	// are the same and in
	//     the future relative to UTC, the transfer is executed only one time.
	// *   If `schedule_end_date` is later than `schedule_start_date`  and
	//     `schedule_end_date` is in the future relative to UTC, the job will
	//     run each day at
	//     [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
	//     through `schedule_end_date`.
	ScheduleEndDate *date.Date `protobuf:"bytes,2,opt,name=schedule_end_date,json=scheduleEndDate,proto3" json:"schedule_end_date,omitempty"`
	// The time in UTC that a transfer job is scheduled to run. Transfers may
	// start later than this time.
	//
	// If `start_time_of_day` is not specified:
	//
	// *   One-time transfers run immediately.
	// *   Recurring transfers run immediately, and each day at midnight UTC,
	//     through
	//     [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date].
	//
	// If `start_time_of_day` is specified:
	//
	// *   One-time transfers run at the specified time.
	// *   Recurring transfers run at the specified time each day, through
	//     `schedule_end_date`.
	StartTimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=start_time_of_day,json=startTimeOfDay,proto3" json:"start_time_of_day,omitempty"`
	// The time in UTC that no further transfer operations are scheduled. Combined
	// with
	// [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date],
	// `end_time_of_day` specifies the end date and time for starting new transfer
	// operations. This field must be greater than or equal to the timestamp
	// corresponding to the combintation of
	// [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date]
	// and
	// [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day],
	// and is subject to the following:
	//
	// *   If `end_time_of_day` is not set and `schedule_end_date` is set, then
	//     a default value of `23:59:59` is used for `end_time_of_day`.
	//
	// *   If `end_time_of_day` is set and `schedule_end_date` is not set, then
	//     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] is returned.
	EndTimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=end_time_of_day,json=endTimeOfDay,proto3" json:"end_time_of_day,omitempty"`
	// Interval between the start of each scheduled TransferOperation. If
	// unspecified, the default value is 24 hours. This value may not be less than
	// 1 hour.
	RepeatInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=repeat_interval,json=repeatInterval,proto3" json:"repeat_interval,omitempty"`
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10}
}

func (x *Schedule) GetScheduleStartDate() *date.Date {
	if x != nil {
		return x.ScheduleStartDate
	}
	return nil
}

func (x *Schedule) GetScheduleEndDate() *date.Date {
	if x != nil {
		return x.ScheduleEndDate
	}
	return nil
}

func (x *Schedule) GetStartTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTimeOfDay
	}
	return nil
}

func (x *Schedule) GetEndTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.EndTimeOfDay
	}
	return nil
}

func (x *Schedule) GetRepeatInterval() *durationpb.Duration {
	if x != nil {
		return x.RepeatInterval
	}
	return nil
}

// This resource represents the configuration of a transfer job that runs
// periodically.
type TransferJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique name (within the transfer project) assigned when the job is
	// created.  If this field is empty in a CreateTransferJobRequest, Storage
	// Transfer Service will assign a unique name. Otherwise, the specified name
	// is used as the unique name for this job.
	//
	// If the specified name is in use by a job, the creation request fails with
	// an [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
	//
	// This name must start with `"transferJobs/"` prefix and end with a letter or
	// a number, and should be no more than 128 characters. This name must not
	// start with 'transferJobs/OPI'. 'transferJobs/OPI' is a reserved prefix.
	// Example:
	// `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"`
	//
	// Invalid job names will fail with an
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A description provided by the user for the job. Its max length is 1024
	// bytes when Unicode-encoded.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The ID of the Google Cloud Platform Project that owns the job.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Transfer specification.
	TransferSpec *TransferSpec `protobuf:"bytes,4,opt,name=transfer_spec,json=transferSpec,proto3" json:"transfer_spec,omitempty"`
	// Notification configuration.
	NotificationConfig *NotificationConfig `protobuf:"bytes,11,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Specifies schedule for the transfer job.
	// This is an optional field. When the field is not set, the job will never
	// execute a transfer, unless you invoke RunTransferJob or update the job to
	// have a non-empty schedule.
	Schedule *Schedule `protobuf:"bytes,5,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Status of the job. This value MUST be specified for
	// `CreateTransferJobRequests`.
	//
	// **Note:** The effect of the new job status takes place during a subsequent
	// job run. For example, if you change the job status from
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED] to
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and an
	// operation spawned by the transfer is running, the status change would not
	// affect the current operation.
	Status TransferJob_Status `protobuf:"varint,6,opt,name=status,proto3,enum=google.storagetransfer.v1.TransferJob_Status" json:"status,omitempty"`
	// Output only. The time that the transfer job was created.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The time that the transfer job was last modified.
	LastModificationTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=last_modification_time,json=lastModificationTime,proto3" json:"last_modification_time,omitempty"`
	// Output only. The time that the transfer job was deleted.
	DeletionTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=deletion_time,json=deletionTime,proto3" json:"deletion_time,omitempty"`
	// The name of the most recently started TransferOperation of this JobConfig.
	// Present if a TransferOperation has been created for this JobConfig.
	LatestOperationName string `protobuf:"bytes,12,opt,name=latest_operation_name,json=latestOperationName,proto3" json:"latest_operation_name,omitempty"`
}

func (x *TransferJob) Reset() {
	*x = TransferJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferJob) ProtoMessage() {}

func (x *TransferJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferJob.ProtoReflect.Descriptor instead.
func (*TransferJob) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{11}
}

func (x *TransferJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransferJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TransferJob) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TransferJob) GetTransferSpec() *TransferSpec {
	if x != nil {
		return x.TransferSpec
	}
	return nil
}

func (x *TransferJob) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *TransferJob) GetSchedule() *Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *TransferJob) GetStatus() TransferJob_Status {
	if x != nil {
		return x.Status
	}
	return TransferJob_STATUS_UNSPECIFIED
}

func (x *TransferJob) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *TransferJob) GetLastModificationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModificationTime
	}
	return nil
}

func (x *TransferJob) GetDeletionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeletionTime
	}
	return nil
}

func (x *TransferJob) GetLatestOperationName() string {
	if x != nil {
		return x.LatestOperationName
	}
	return ""
}

// An entry describing an error that has occurred.
type ErrorLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A URL that refers to the target (a data source, a data sink,
	// or an object) with which the error is associated.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// A list of messages that carry the error details.
	ErrorDetails []string `protobuf:"bytes,3,rep,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
}

func (x *ErrorLogEntry) Reset() {
	*x = ErrorLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorLogEntry) ProtoMessage() {}

func (x *ErrorLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorLogEntry.ProtoReflect.Descriptor instead.
func (*ErrorLogEntry) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{12}
}

func (x *ErrorLogEntry) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ErrorLogEntry) GetErrorDetails() []string {
	if x != nil {
		return x.ErrorDetails
	}
	return nil
}

// A summary of errors by error code, plus a count and sample error log
// entries.
type ErrorSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	ErrorCode code.Code `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3,enum=google.rpc.Code" json:"error_code,omitempty"`
	// Required. Count of this type of error.
	ErrorCount int64 `protobuf:"varint,2,opt,name=error_count,json=errorCount,proto3" json:"error_count,omitempty"`
	// Error samples.
	//
	// At most 5 error log entries will be recorded for a given
	// error code for a single transfer operation.
	ErrorLogEntries []*ErrorLogEntry `protobuf:"bytes,3,rep,name=error_log_entries,json=errorLogEntries,proto3" json:"error_log_entries,omitempty"`
}

func (x *ErrorSummary) Reset() {
	*x = ErrorSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorSummary) ProtoMessage() {}

func (x *ErrorSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorSummary.ProtoReflect.Descriptor instead.
func (*ErrorSummary) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{13}
}

func (x *ErrorSummary) GetErrorCode() code.Code {
	if x != nil {
		return x.ErrorCode
	}
	return code.Code_OK
}

func (x *ErrorSummary) GetErrorCount() int64 {
	if x != nil {
		return x.ErrorCount
	}
	return 0
}

func (x *ErrorSummary) GetErrorLogEntries() []*ErrorLogEntry {
	if x != nil {
		return x.ErrorLogEntries
	}
	return nil
}

// A collection of counters that report the progress of a transfer operation.
type TransferCounters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Objects found in the data source that are scheduled to be transferred,
	// excluding any that are filtered based on object conditions or skipped due
	// to sync.
	ObjectsFoundFromSource int64 `protobuf:"varint,1,opt,name=objects_found_from_source,json=objectsFoundFromSource,proto3" json:"objects_found_from_source,omitempty"`
	// Bytes found in the data source that are scheduled to be transferred,
	// excluding any that are filtered based on object conditions or skipped due
	// to sync.
	BytesFoundFromSource int64 `protobuf:"varint,2,opt,name=bytes_found_from_source,json=bytesFoundFromSource,proto3" json:"bytes_found_from_source,omitempty"`
	// Objects found only in the data sink that are scheduled to be deleted.
	ObjectsFoundOnlyFromSink int64 `protobuf:"varint,3,opt,name=objects_found_only_from_sink,json=objectsFoundOnlyFromSink,proto3" json:"objects_found_only_from_sink,omitempty"`
	// Bytes found only in the data sink that are scheduled to be deleted.
	BytesFoundOnlyFromSink int64 `protobuf:"varint,4,opt,name=bytes_found_only_from_sink,json=bytesFoundOnlyFromSink,proto3" json:"bytes_found_only_from_sink,omitempty"`
	// Objects in the data source that are not transferred because they already
	// exist in the data sink.
	ObjectsFromSourceSkippedBySync int64 `protobuf:"varint,5,opt,name=objects_from_source_skipped_by_sync,json=objectsFromSourceSkippedBySync,proto3" json:"objects_from_source_skipped_by_sync,omitempty"`
	// Bytes in the data source that are not transferred because they already
	// exist in the data sink.
	BytesFromSourceSkippedBySync int64 `protobuf:"varint,6,opt,name=bytes_from_source_skipped_by_sync,json=bytesFromSourceSkippedBySync,proto3" json:"bytes_from_source_skipped_by_sync,omitempty"`
	// Objects that are copied to the data sink.
	ObjectsCopiedToSink int64 `protobuf:"varint,7,opt,name=objects_copied_to_sink,json=objectsCopiedToSink,proto3" json:"objects_copied_to_sink,omitempty"`
	// Bytes that are copied to the data sink.
	BytesCopiedToSink int64 `protobuf:"varint,8,opt,name=bytes_copied_to_sink,json=bytesCopiedToSink,proto3" json:"bytes_copied_to_sink,omitempty"`
	// Objects that are deleted from the data source.
	ObjectsDeletedFromSource int64 `protobuf:"varint,9,opt,name=objects_deleted_from_source,json=objectsDeletedFromSource,proto3" json:"objects_deleted_from_source,omitempty"`
	// Bytes that are deleted from the data source.
	BytesDeletedFromSource int64 `protobuf:"varint,10,opt,name=bytes_deleted_from_source,json=bytesDeletedFromSource,proto3" json:"bytes_deleted_from_source,omitempty"`
	// Objects that are deleted from the data sink.
	ObjectsDeletedFromSink int64 `protobuf:"varint,11,opt,name=objects_deleted_from_sink,json=objectsDeletedFromSink,proto3" json:"objects_deleted_from_sink,omitempty"`
	// Bytes that are deleted from the data sink.
	BytesDeletedFromSink int64 `protobuf:"varint,12,opt,name=bytes_deleted_from_sink,json=bytesDeletedFromSink,proto3" json:"bytes_deleted_from_sink,omitempty"`
	// Objects in the data source that failed to be transferred or that failed
	// to be deleted after being transferred.
	ObjectsFromSourceFailed int64 `protobuf:"varint,13,opt,name=objects_from_source_failed,json=objectsFromSourceFailed,proto3" json:"objects_from_source_failed,omitempty"`
	// Bytes in the data source that failed to be transferred or that failed to
	// be deleted after being transferred.
	BytesFromSourceFailed int64 `protobuf:"varint,14,opt,name=bytes_from_source_failed,json=bytesFromSourceFailed,proto3" json:"bytes_from_source_failed,omitempty"`
	// Objects that failed to be deleted from the data sink.
	ObjectsFailedToDeleteFromSink int64 `protobuf:"varint,15,opt,name=objects_failed_to_delete_from_sink,json=objectsFailedToDeleteFromSink,proto3" json:"objects_failed_to_delete_from_sink,omitempty"`
	// Bytes that failed to be deleted from the data sink.
	BytesFailedToDeleteFromSink int64 `protobuf:"varint,16,opt,name=bytes_failed_to_delete_from_sink,json=bytesFailedToDeleteFromSink,proto3" json:"bytes_failed_to_delete_from_sink,omitempty"`
}

func (x *TransferCounters) Reset() {
	*x = TransferCounters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferCounters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferCounters) ProtoMessage() {}

func (x *TransferCounters) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferCounters.ProtoReflect.Descriptor instead.
func (*TransferCounters) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{14}
}

func (x *TransferCounters) GetObjectsFoundFromSource() int64 {
	if x != nil {
		return x.ObjectsFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetBytesFoundFromSource() int64 {
	if x != nil {
		return x.BytesFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetObjectsFoundOnlyFromSink() int64 {
	if x != nil {
		return x.ObjectsFoundOnlyFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesFoundOnlyFromSink() int64 {
	if x != nil {
		return x.BytesFoundOnlyFromSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsFromSourceSkippedBySync() int64 {
	if x != nil {
		return x.ObjectsFromSourceSkippedBySync
	}
	return 0
}

func (x *TransferCounters) GetBytesFromSourceSkippedBySync() int64 {
	if x != nil {
		return x.BytesFromSourceSkippedBySync
	}
	return 0
}

func (x *TransferCounters) GetObjectsCopiedToSink() int64 {
	if x != nil {
		return x.ObjectsCopiedToSink
	}
	return 0
}

func (x *TransferCounters) GetBytesCopiedToSink() int64 {
	if x != nil {
		return x.BytesCopiedToSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsDeletedFromSource() int64 {
	if x != nil {
		return x.ObjectsDeletedFromSource
	}
	return 0
}

func (x *TransferCounters) GetBytesDeletedFromSource() int64 {
	if x != nil {
		return x.BytesDeletedFromSource
	}
	return 0
}

func (x *TransferCounters) GetObjectsDeletedFromSink() int64 {
	if x != nil {
		return x.ObjectsDeletedFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesDeletedFromSink() int64 {
	if x != nil {
		return x.BytesDeletedFromSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsFromSourceFailed() int64 {
	if x != nil {
		return x.ObjectsFromSourceFailed
	}
	return 0
}

func (x *TransferCounters) GetBytesFromSourceFailed() int64 {
	if x != nil {
		return x.BytesFromSourceFailed
	}
	return 0
}

func (x *TransferCounters) GetObjectsFailedToDeleteFromSink() int64 {
	if x != nil {
		return x.ObjectsFailedToDeleteFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesFailedToDeleteFromSink() int64 {
	if x != nil {
		return x.BytesFailedToDeleteFromSink
	}
	return 0
}

// Specification to configure notifications published to Cloud Pub/Sub.
// Notifications will be published to the customer-provided topic using the
// following `PubsubMessage.attributes`:
//
// * `"eventType"`: one of the
// [EventType][google.storagetransfer.v1.NotificationConfig.EventType] values
// * `"payloadFormat"`: one of the
// [PayloadFormat][google.storagetransfer.v1.NotificationConfig.PayloadFormat]
// values
// * `"projectId"`: the
// [project_id][google.storagetransfer.v1.TransferOperation.project_id] of the
// `TransferOperation`
// * `"transferJobName"`: the
// [transfer_job_name][google.storagetransfer.v1.TransferOperation.transfer_job_name]
// of the `TransferOperation`
// * `"transferOperationName"`: the
// [name][google.storagetransfer.v1.TransferOperation.name] of the
// `TransferOperation`
//
// The `PubsubMessage.data` will contain a
// [TransferOperation][google.storagetransfer.v1.TransferOperation] resource
// formatted according to the specified `PayloadFormat`.
type NotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Topic.name` of the Cloud Pub/Sub topic to which to publish
	// notifications. Must be of the format: `projects/{project}/topics/{topic}`.
	// Not matching this format will result in an
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// Event types for which a notification is desired. If empty, send
	// notifications for all event types.
	EventTypes []NotificationConfig_EventType `protobuf:"varint,2,rep,packed,name=event_types,json=eventTypes,proto3,enum=google.storagetransfer.v1.NotificationConfig_EventType" json:"event_types,omitempty"`
	// Required. The desired format of the notification message payloads.
	PayloadFormat NotificationConfig_PayloadFormat `protobuf:"varint,3,opt,name=payload_format,json=payloadFormat,proto3,enum=google.storagetransfer.v1.NotificationConfig_PayloadFormat" json:"payload_format,omitempty"`
}

func (x *NotificationConfig) Reset() {
	*x = NotificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig) ProtoMessage() {}

func (x *NotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig.ProtoReflect.Descriptor instead.
func (*NotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{15}
}

func (x *NotificationConfig) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *NotificationConfig) GetEventTypes() []NotificationConfig_EventType {
	if x != nil {
		return x.EventTypes
	}
	return nil
}

func (x *NotificationConfig) GetPayloadFormat() NotificationConfig_PayloadFormat {
	if x != nil {
		return x.PayloadFormat
	}
	return NotificationConfig_PAYLOAD_FORMAT_UNSPECIFIED
}

// A description of the execution of a transfer.
type TransferOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A globally unique ID assigned by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the Google Cloud Platform Project that owns the operation.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Transfer specification.
	TransferSpec *TransferSpec `protobuf:"bytes,3,opt,name=transfer_spec,json=transferSpec,proto3" json:"transfer_spec,omitempty"`
	// Notification configuration.
	NotificationConfig *NotificationConfig `protobuf:"bytes,10,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Start time of this transfer execution.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of this transfer execution.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Status of the transfer operation.
	Status TransferOperation_Status `protobuf:"varint,6,opt,name=status,proto3,enum=google.storagetransfer.v1.TransferOperation_Status" json:"status,omitempty"`
	// Information about the progress of the transfer operation.
	Counters *TransferCounters `protobuf:"bytes,7,opt,name=counters,proto3" json:"counters,omitempty"`
	// Summarizes errors encountered with sample error log entries.
	ErrorBreakdowns []*ErrorSummary `protobuf:"bytes,8,rep,name=error_breakdowns,json=errorBreakdowns,proto3" json:"error_breakdowns,omitempty"`
	// The name of the transfer job that triggers this transfer operation.
	TransferJobName string `protobuf:"bytes,9,opt,name=transfer_job_name,json=transferJobName,proto3" json:"transfer_job_name,omitempty"`
}

func (x *TransferOperation) Reset() {
	*x = TransferOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferOperation) ProtoMessage() {}

func (x *TransferOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferOperation.ProtoReflect.Descriptor instead.
func (*TransferOperation) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{16}
}

func (x *TransferOperation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransferOperation) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TransferOperation) GetTransferSpec() *TransferSpec {
	if x != nil {
		return x.TransferSpec
	}
	return nil
}

func (x *TransferOperation) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *TransferOperation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TransferOperation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TransferOperation) GetStatus() TransferOperation_Status {
	if x != nil {
		return x.Status
	}
	return TransferOperation_STATUS_UNSPECIFIED
}

func (x *TransferOperation) GetCounters() *TransferCounters {
	if x != nil {
		return x.Counters
	}
	return nil
}

func (x *TransferOperation) GetErrorBreakdowns() []*ErrorSummary {
	if x != nil {
		return x.ErrorBreakdowns
	}
	return nil
}

func (x *TransferOperation) GetTransferJobName() string {
	if x != nil {
		return x.TransferJobName
	}
	return ""
}

var File_google_storagetransfer_v1_transfer_types_proto protoreflect.FileDescriptor

var file_google_storagetransfer_v1_transfer_types_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72,
	0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x5a, 0x0a, 0x14, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x68,
	0x0a, 0x0c, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x27,
	0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x22, 0x34, 0x0a, 0x10, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x09,
	0x73, 0x61, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x61, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe6,
	0x03, 0x0a, 0x10, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x70, 0x0a, 0x28, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x23, 0x6d, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64,
	0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x28, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x23, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x6c, 0x61, 0x70, 0x73,
	0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12, 0x4a, 0x0a,
	0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x73,
	0x69, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x14, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x22, 0x43, 0x0a, 0x07, 0x47, 0x63, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xb9, 0x01, 0x0a,
	0x09, 0x41, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x52, 0x0a, 0x0e, 0x61, 0x77, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x61, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1e, 0x0a, 0x08, 0x72, 0x6f, 0x6c, 0x65,
	0x5f, 0x61, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52,
	0x07, 0x72, 0x6f, 0x6c, 0x65, 0x41, 0x72, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x14, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x60, 0x0a, 0x11, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0x52,
	0x10, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x2a, 0x0a, 0x08, 0x48, 0x74, 0x74, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6c, 0x69, 0x73,
	0x74, 0x55, 0x72, 0x6c, 0x22, 0x87, 0x02, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x2a, 0x6f, 0x76, 0x65, 0x72,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x61, 0x6c,
	0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69,
	0x6e, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x25, 0x6f, 0x76,
	0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x41, 0x6c,
	0x72, 0x65, 0x61, 0x64, 0x79, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x1d, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x5f,
	0x73, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49,
	0x6e, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x57, 0x0a, 0x29, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x24, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x41, 0x66, 0x74, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0x90,
	0x05, 0x0a, 0x0c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x48, 0x0a, 0x0d, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x6e, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x63,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x4c, 0x0a, 0x0f, 0x67, 0x63, 0x73,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x12, 0x61, 0x77, 0x73, 0x5f, 0x73,
	0x33, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x0f, 0x61, 0x77, 0x73,
	0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4f, 0x0a, 0x10,
	0x68, 0x74, 0x74, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x0e, 0x68,
	0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x75, 0x0a,
	0x1e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x42, 0x6c, 0x6f, 0x62, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x1a, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x42,
	0x6c, 0x6f, 0x62, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55,
	0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69,
	0x6e, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0xd7, 0x02, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x46,
	0x0a, 0x13, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6e,
	0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x41, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x3d, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x42, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x65, 0x61,
	0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x65, 0x61, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0xf9, 0x05, 0x0a, 0x0b,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x4c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5e,
	0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f,
	0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x45, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x16,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x6c,
	0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x48, 0x0a,
	0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x4b, 0x0a, 0x0d, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x22, 0xc0, 0x01, 0x0a, 0x0c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x54, 0x0a, 0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xf0, 0x07, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x39, 0x0a, 0x19,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x46, 0x72, 0x6f,
	0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46,
	0x6f, 0x75, 0x6e, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3e,
	0x0a, 0x1c, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x6f, 0x75,
	0x6e, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x3a,
	0x0a, 0x1a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x16, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x4f, 0x6e,
	0x6c, 0x79, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x4b, 0x0a, 0x23, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x79, 0x6e,
	0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65,
	0x64, 0x42, 0x79, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x47, 0x0a, 0x21, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x6b, 0x69,
	0x70, 0x70, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x1c, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x42, 0x79, 0x53, 0x79, 0x6e, 0x63,
	0x12, 0x33, 0x0a, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x70, 0x69,
	0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x43, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x54,
	0x6f, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x2f, 0x0a, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x70, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x11, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x70, 0x69, 0x65, 0x64,
	0x54, 0x6f, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x0a, 0x1b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x62, 0x79, 0x74, 0x65, 0x73, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x39, 0x0a, 0x19, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x0a, 0x17, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f,
	0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69,
	0x6e, 0x6b, 0x12, 0x3b, 0x0a, 0x1a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12,
	0x37, 0x0a, 0x18, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x15, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x22, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x1d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x54, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x45, 0x0a, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1b, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x54, 0x6f, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x22, 0xcd, 0x03, 0x0a, 0x12, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x58, 0x0a, 0x0b, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x0e, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x86, 0x01, 0x0a,
	0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x45, 0x52, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x45, 0x52, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45,
	0x52, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x42, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x43, 0x0a, 0x0d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41,
	0x44, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xed, 0x05, 0x0a, 0x11, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x5e, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x47, 0x0a, 0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x52, 0x0a, 0x10, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6f, 0x0a, 0x06, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a,
	0x0a, 0x06, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x06, 0x42, 0xea, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x42, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0xf8, 0x01, 0x01, 0xaa, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storagetransfer_v1_transfer_types_proto_rawDescOnce sync.Once
	file_google_storagetransfer_v1_transfer_types_proto_rawDescData = file_google_storagetransfer_v1_transfer_types_proto_rawDesc
)

func file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP() []byte {
	file_google_storagetransfer_v1_transfer_types_proto_rawDescOnce.Do(func() {
		file_google_storagetransfer_v1_transfer_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storagetransfer_v1_transfer_types_proto_rawDescData)
	})
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescData
}

var file_google_storagetransfer_v1_transfer_types_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_storagetransfer_v1_transfer_types_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_storagetransfer_v1_transfer_types_proto_goTypes = []interface{}{
	(TransferJob_Status)(0),               // 0: google.storagetransfer.v1.TransferJob.Status
	(NotificationConfig_EventType)(0),     // 1: google.storagetransfer.v1.NotificationConfig.EventType
	(NotificationConfig_PayloadFormat)(0), // 2: google.storagetransfer.v1.NotificationConfig.PayloadFormat
	(TransferOperation_Status)(0),         // 3: google.storagetransfer.v1.TransferOperation.Status
	(*GoogleServiceAccount)(nil),          // 4: google.storagetransfer.v1.GoogleServiceAccount
	(*AwsAccessKey)(nil),                  // 5: google.storagetransfer.v1.AwsAccessKey
	(*AzureCredentials)(nil),              // 6: google.storagetransfer.v1.AzureCredentials
	(*ObjectConditions)(nil),              // 7: google.storagetransfer.v1.ObjectConditions
	(*GcsData)(nil),                       // 8: google.storagetransfer.v1.GcsData
	(*AwsS3Data)(nil),                     // 9: google.storagetransfer.v1.AwsS3Data
	(*AzureBlobStorageData)(nil),          // 10: google.storagetransfer.v1.AzureBlobStorageData
	(*HttpData)(nil),                      // 11: google.storagetransfer.v1.HttpData
	(*TransferOptions)(nil),               // 12: google.storagetransfer.v1.TransferOptions
	(*TransferSpec)(nil),                  // 13: google.storagetransfer.v1.TransferSpec
	(*Schedule)(nil),                      // 14: google.storagetransfer.v1.Schedule
	(*TransferJob)(nil),                   // 15: google.storagetransfer.v1.TransferJob
	(*ErrorLogEntry)(nil),                 // 16: google.storagetransfer.v1.ErrorLogEntry
	(*ErrorSummary)(nil),                  // 17: google.storagetransfer.v1.ErrorSummary
	(*TransferCounters)(nil),              // 18: google.storagetransfer.v1.TransferCounters
	(*NotificationConfig)(nil),            // 19: google.storagetransfer.v1.NotificationConfig
	(*TransferOperation)(nil),             // 20: google.storagetransfer.v1.TransferOperation
	(*durationpb.Duration)(nil),           // 21: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),         // 22: google.protobuf.Timestamp
	(*date.Date)(nil),                     // 23: google.type.Date
	(*timeofday.TimeOfDay)(nil),           // 24: google.type.TimeOfDay
	(code.Code)(0),                        // 25: google.rpc.Code
}
var file_google_storagetransfer_v1_transfer_types_proto_depIdxs = []int32{
	21, // 0: google.storagetransfer.v1.ObjectConditions.min_time_elapsed_since_last_modification:type_name -> google.protobuf.Duration
	21, // 1: google.storagetransfer.v1.ObjectConditions.max_time_elapsed_since_last_modification:type_name -> google.protobuf.Duration
	22, // 2: google.storagetransfer.v1.ObjectConditions.last_modified_since:type_name -> google.protobuf.Timestamp
	22, // 3: google.storagetransfer.v1.ObjectConditions.last_modified_before:type_name -> google.protobuf.Timestamp
	5,  // 4: google.storagetransfer.v1.AwsS3Data.aws_access_key:type_name -> google.storagetransfer.v1.AwsAccessKey
	6,  // 5: google.storagetransfer.v1.AzureBlobStorageData.azure_credentials:type_name -> google.storagetransfer.v1.AzureCredentials
	8,  // 6: google.storagetransfer.v1.TransferSpec.gcs_data_sink:type_name -> google.storagetransfer.v1.GcsData
	8,  // 7: google.storagetransfer.v1.TransferSpec.gcs_data_source:type_name -> google.storagetransfer.v1.GcsData
	9,  // 8: google.storagetransfer.v1.TransferSpec.aws_s3_data_source:type_name -> google.storagetransfer.v1.AwsS3Data
	11, // 9: google.storagetransfer.v1.TransferSpec.http_data_source:type_name -> google.storagetransfer.v1.HttpData
	10, // 10: google.storagetransfer.v1.TransferSpec.azure_blob_storage_data_source:type_name -> google.storagetransfer.v1.AzureBlobStorageData
	7,  // 11: google.storagetransfer.v1.TransferSpec.object_conditions:type_name -> google.storagetransfer.v1.ObjectConditions
	12, // 12: google.storagetransfer.v1.TransferSpec.transfer_options:type_name -> google.storagetransfer.v1.TransferOptions
	23, // 13: google.storagetransfer.v1.Schedule.schedule_start_date:type_name -> google.type.Date
	23, // 14: google.storagetransfer.v1.Schedule.schedule_end_date:type_name -> google.type.Date
	24, // 15: google.storagetransfer.v1.Schedule.start_time_of_day:type_name -> google.type.TimeOfDay
	24, // 16: google.storagetransfer.v1.Schedule.end_time_of_day:type_name -> google.type.TimeOfDay
	21, // 17: google.storagetransfer.v1.Schedule.repeat_interval:type_name -> google.protobuf.Duration
	13, // 18: google.storagetransfer.v1.TransferJob.transfer_spec:type_name -> google.storagetransfer.v1.TransferSpec
	19, // 19: google.storagetransfer.v1.TransferJob.notification_config:type_name -> google.storagetransfer.v1.NotificationConfig
	14, // 20: google.storagetransfer.v1.TransferJob.schedule:type_name -> google.storagetransfer.v1.Schedule
	0,  // 21: google.storagetransfer.v1.TransferJob.status:type_name -> google.storagetransfer.v1.TransferJob.Status
	22, // 22: google.storagetransfer.v1.TransferJob.creation_time:type_name -> google.protobuf.Timestamp
	22, // 23: google.storagetransfer.v1.TransferJob.last_modification_time:type_name -> google.protobuf.Timestamp
	22, // 24: google.storagetransfer.v1.TransferJob.deletion_time:type_name -> google.protobuf.Timestamp
	25, // 25: google.storagetransfer.v1.ErrorSummary.error_code:type_name -> google.rpc.Code
	16, // 26: google.storagetransfer.v1.ErrorSummary.error_log_entries:type_name -> google.storagetransfer.v1.ErrorLogEntry
	1,  // 27: google.storagetransfer.v1.NotificationConfig.event_types:type_name -> google.storagetransfer.v1.NotificationConfig.EventType
	2,  // 28: google.storagetransfer.v1.NotificationConfig.payload_format:type_name -> google.storagetransfer.v1.NotificationConfig.PayloadFormat
	13, // 29: google.storagetransfer.v1.TransferOperation.transfer_spec:type_name -> google.storagetransfer.v1.TransferSpec
	19, // 30: google.storagetransfer.v1.TransferOperation.notification_config:type_name -> google.storagetransfer.v1.NotificationConfig
	22, // 31: google.storagetransfer.v1.TransferOperation.start_time:type_name -> google.protobuf.Timestamp
	22, // 32: google.storagetransfer.v1.TransferOperation.end_time:type_name -> google.protobuf.Timestamp
	3,  // 33: google.storagetransfer.v1.TransferOperation.status:type_name -> google.storagetransfer.v1.TransferOperation.Status
	18, // 34: google.storagetransfer.v1.TransferOperation.counters:type_name -> google.storagetransfer.v1.TransferCounters
	17, // 35: google.storagetransfer.v1.TransferOperation.error_breakdowns:type_name -> google.storagetransfer.v1.ErrorSummary
	36, // [36:36] is the sub-list for method output_type
	36, // [36:36] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_storagetransfer_v1_transfer_types_proto_init() }
func file_google_storagetransfer_v1_transfer_types_proto_init() {
	if File_google_storagetransfer_v1_transfer_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsAccessKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectConditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsS3Data); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureBlobStorageData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferCounters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*TransferSpec_GcsDataSink)(nil),
		(*TransferSpec_GcsDataSource)(nil),
		(*TransferSpec_AwsS3DataSource)(nil),
		(*TransferSpec_HttpDataSource)(nil),
		(*TransferSpec_AzureBlobStorageDataSource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storagetransfer_v1_transfer_types_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_storagetransfer_v1_transfer_types_proto_goTypes,
		DependencyIndexes: file_google_storagetransfer_v1_transfer_types_proto_depIdxs,
		EnumInfos:         file_google_storagetransfer_v1_transfer_types_proto_enumTypes,
		MessageInfos:      file_google_storagetransfer_v1_transfer_types_proto_msgTypes,
	}.Build()
	File_google_storagetransfer_v1_transfer_types_proto = out.File
	file_google_storagetransfer_v1_transfer_types_proto_rawDesc = nil
	file_google_storagetransfer_v1_transfer_types_proto_goTypes = nil
	file_google_storagetransfer_v1_transfer_types_proto_depIdxs = nil
}
