/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.searchbox.client.JestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SuggestResult
extends JestResult {
    public SuggestResult(SuggestResult suggestResult) {
        super(suggestResult);
    }

    public SuggestResult(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public List<Suggestion> getSuggestions(String suggestionName) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (this.jsonObject != null && this.jsonObject.has(suggestionName)) {
            for (JsonNode suggestionElement : this.jsonObject.get(suggestionName)) {
                Suggestion suggestion = (Suggestion)this.objectMapper.convertValue((Object)suggestionElement, Suggestion.class);
                suggestions.add(suggestion);
            }
        }
        return suggestions;
    }

    public static class Suggestion {
        public String text;
        public Integer offset;
        public Integer length;
        public List<Map<String, Object>> options;

        public Suggestion() {
        }

        public Suggestion(String text, Integer offset, Integer length, List<Map<String, Object>> options) {
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.options = options;
        }

        public int hashCode() {
            return Objects.hash(this.text, this.offset, this.length, this.options);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Suggestion rhs = (Suggestion)obj;
            return Objects.equals(this.text, rhs.text) && Objects.equals(this.offset, rhs.offset) && Objects.equals(this.length, rhs.length) && Objects.equals(this.options, rhs.options);
        }
    }
}

