/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Ipv4RangeAggregation
extends BucketAggregation {
    public static final String TYPE = "ip_range";
    private List<Ipv4Range> ranges = new LinkedList<Ipv4Range>();

    public Ipv4RangeAggregation(String name, JsonNode ipv4RangeAggregation) {
        super(name, ipv4RangeAggregation);
        if (ipv4RangeAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && ipv4RangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isArray()) {
            this.parseBuckets(ipv4RangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonNode bucketsSource) {
        Iterator iterator = bucketsSource.iterator();
        while (iterator.hasNext()) {
            JsonNode bucket;
            Ipv4Range range = new Ipv4Range(bucket, (bucket = (JsonNode)iterator.next()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).asDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).asDouble()) : null, bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).asLong(), bucket.has(String.valueOf((Object)AggregationField.FROM_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.FROM_AS_STRING)).asText() : null, bucket.has(String.valueOf((Object)AggregationField.TO_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.TO_AS_STRING)).asText() : null);
            this.ranges.add(range);
        }
    }

    public List<Ipv4Range> getBuckets() {
        return this.ranges;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Ipv4RangeAggregation rhs = (Ipv4RangeAggregation)obj;
        return super.equals(obj) && Objects.equals(this.ranges, rhs.ranges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ranges);
    }

    public class Ipv4Range
    extends Range {
        private String fromAsString;
        private String toAsString;

        public Ipv4Range(JsonNode bucket, Double from, Double to, Long count, String fromString, String toString) {
            super(bucket, from, to, count);
            this.fromAsString = fromString;
            this.toAsString = toString;
        }

        public String getFromAsString() {
            return this.fromAsString;
        }

        public String getToAsString() {
            return this.toAsString;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Ipv4Range rhs = (Ipv4Range)obj;
            return super.equals(obj) && Objects.equals(this.toAsString, rhs.toAsString) && Objects.equals(this.fromAsString, rhs.fromAsString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.toAsString, this.fromAsString);
        }
    }
}

