/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ArraySizingStrategy;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.CharArrayList;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.CharContainer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.CharCursor;

public class CharStack
extends CharArrayList {
    public CharStack() {
    }

    public CharStack(int expectedElements) {
        super(expectedElements);
    }

    public CharStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public CharStack(CharContainer container) {
        super(container);
    }

    public void push(char e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(char e1, char e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(char e1, char e2, char e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(char e1, char e2, char e3, char e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(char[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(char ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(CharContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends CharCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public char pop() {
        assert (this.elementsCount > 0);
        char v = this.buffer[--this.elementsCount];
        return v;
    }

    public char peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static CharStack from(char ... elements) {
        CharStack stack = new CharStack(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public CharStack clone() {
        return (CharStack)super.clone();
    }
}

