/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.tdunning.math.stats;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.graylog.shaded.elasticsearch5.com.tdunning.math.stats.Centroid;
import org.graylog.shaded.elasticsearch5.com.tdunning.math.stats.GroupTree;
import org.graylog.shaded.elasticsearch5.com.tdunning.math.stats.TDigest;

public abstract class AbstractTDigest
extends TDigest {
    protected Random gen = new Random();
    protected boolean recordAllData = false;

    public static double interpolate(double x, double x0, double x1) {
        return (x - x0) / (x1 - x0);
    }

    public static void encode(ByteBuffer buf, int n) {
        int k = 0;
        while (n < 0 || n > 127) {
            byte b = (byte)(0x80 | 0x7F & n);
            buf.put(b);
            n >>>= 7;
            if (++k < 6) continue;
            throw new IllegalStateException("Size is implausibly large");
        }
        buf.put((byte)n);
    }

    public static int decode(ByteBuffer buf) {
        byte v = buf.get();
        int z = 0x7F & v;
        int shift = 7;
        while ((v & 0x80) != 0) {
            if (shift > 28) {
                throw new IllegalStateException("Shift too large in decode");
            }
            v = buf.get();
            z += (v & 0x7F) << shift;
            shift += 7;
        }
        return z;
    }

    abstract void add(double var1, int var3, Centroid var4);

    protected static TDigest merge(Iterable<TDigest> subData, Random gen, TDigest r) {
        ArrayList<Centroid> centroids = new ArrayList<Centroid>();
        boolean recordAll = false;
        for (TDigest digest : subData) {
            for (Centroid centroid : digest.centroids()) {
                centroids.add(centroid);
            }
            recordAll |= digest.isRecording();
        }
        Collections.shuffle(centroids, gen);
        if (recordAll) {
            r.recordAllData();
        }
        for (Centroid c : centroids) {
            if (r.isRecording()) {
                // empty if block
            }
            ((AbstractTDigest)r).add(c.mean(), c.count(), c);
        }
        return r;
    }

    public abstract void compress(GroupTree var1);

    static double quantile(double previousIndex, double index, double nextIndex, double previousMean, double nextMean) {
        double delta = nextIndex - previousIndex;
        double previousWeight = (nextIndex - index) / delta;
        double nextWeight = (index - previousIndex) / delta;
        return previousMean * previousWeight + nextMean * nextWeight;
    }

    @Override
    public TDigest recordAllData() {
        this.recordAllData = true;
        return this;
    }

    @Override
    public boolean isRecording() {
        return this.recordAllData;
    }

    @Override
    public void add(double x) {
        this.add(x, 1);
    }

    @Override
    public void add(TDigest other) {
        ArrayList<Centroid> tmp = new ArrayList<Centroid>();
        for (Centroid centroid : other.centroids()) {
            tmp.add(centroid);
        }
        Collections.shuffle(tmp, this.gen);
        for (Centroid centroid : tmp) {
            this.add(centroid.mean(), centroid.count(), centroid);
        }
    }

    protected Centroid createCentroid(double mean, int id) {
        return new Centroid(mean, id, this.recordAllData);
    }
}

