/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.HdrHistogram;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Locale;
import java.util.TreeSet;
import org.graylog.shaded.elasticsearch5.org.HdrHistogram.DoubleHistogram;
import org.graylog.shaded.elasticsearch5.org.HdrHistogram.EncodableHistogram;
import org.graylog.shaded.elasticsearch5.org.HdrHistogram.Histogram;
import org.graylog.shaded.elasticsearch5.org.HdrHistogram.HistogramLogReader;

public class HistogramLogProcessor
extends Thread {
    public static final String versionString = "Histogram Log Processor version 2.1.9";
    private final HistogramLogProcessorConfiguration config;
    private HistogramLogReader logReader;
    int lineNumber = 0;

    private void outputTimeRange(PrintStream log, String title) {
        log.format(Locale.US, "#[%s between %.3f and", title, this.config.rangeStartTimeSec);
        if (this.config.rangeEndTimeSec < Double.MAX_VALUE) {
            log.format(" %.3f", this.config.rangeEndTimeSec);
        } else {
            log.format(" %s", "<Infinite>");
        }
        log.format(" seconds (relative to StartTime)]\n", new Object[0]);
    }

    private void outputStartTime(PrintStream log, Double startTime) {
        log.format(Locale.US, "#[StartTime: %.3f (seconds since epoch), %s]\n", startTime, new Date((long)(startTime * 1000.0)).toString());
    }

    private EncodableHistogram getIntervalHistogram() {
        EncodableHistogram histogram = null;
        try {
            histogram = this.logReader.nextIntervalHistogram(this.config.rangeStartTimeSec, this.config.rangeEndTimeSec);
        }
        catch (RuntimeException ex) {
            System.err.println("Log file parsing error at line number " + this.lineNumber + ": line appears to be malformed.");
            if (this.config.verbose) {
                throw ex;
            }
            System.exit(1);
        }
        ++this.lineNumber;
        return histogram;
    }

    private EncodableHistogram getIntervalHistogram(String tag) {
        EncodableHistogram histogram;
        if (tag == null) {
            while ((histogram = this.getIntervalHistogram()) != null && histogram.getTag() != null) {
            }
        } else {
            while ((histogram = this.getIntervalHistogram()) != null && !tag.equals(histogram.getTag())) {
            }
        }
        return histogram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintStream timeIntervalLog = null;
        PrintStream histogramPercentileLog = System.out;
        Double firstStartTime = 0.0;
        boolean timeIntervalLogLegendWritten = false;
        if (this.config.listTags) {
            EncodableHistogram histogram;
            TreeSet<String> tags = new TreeSet<String>();
            boolean nullTagFound = false;
            while ((histogram = this.getIntervalHistogram()) != null) {
                String tag = histogram.getTag();
                if (tag != null) {
                    tags.add(histogram.getTag());
                    continue;
                }
                nullTagFound = true;
            }
            System.out.println("Tags found in input file:");
            if (nullTagFound) {
                System.out.println("[NO TAG (default)]");
            }
            for (String tag : tags) {
                System.out.println(tag);
            }
            return;
        }
        String logFormat = this.config.logFormatCsv ? "%.3f,%d,%.3f,%.3f,%.3f,%d,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n" : "%4.3f: I:%d ( %7.3f %7.3f %7.3f ) T:%d ( %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f )\n";
        try {
            if (this.config.outputFileName != null) {
                try {
                    timeIntervalLog = new PrintStream(new FileOutputStream(this.config.outputFileName), false);
                    this.outputTimeRange(timeIntervalLog, "Interval percentile log");
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Failed to open output file " + this.config.outputFileName);
                }
                String hgrmOutputFileName = this.config.outputFileName + ".hgrm";
                try {
                    histogramPercentileLog = new PrintStream(new FileOutputStream(hgrmOutputFileName), false);
                    this.outputTimeRange(histogramPercentileLog, "Overall percentile distribution");
                }
                catch (FileNotFoundException ex) {
                    System.err.println("Failed to open percentiles histogram output file " + hgrmOutputFileName);
                }
            }
            EncodableHistogram intervalHistogram = this.getIntervalHistogram(this.config.tag);
            Histogram accumulatedRegularHistogram = null;
            DoubleHistogram accumulatedDoubleHistogram = null;
            if (intervalHistogram != null) {
                if (intervalHistogram instanceof DoubleHistogram) {
                    accumulatedDoubleHistogram = ((DoubleHistogram)intervalHistogram).copy();
                    accumulatedDoubleHistogram.reset();
                    accumulatedDoubleHistogram.setAutoResize(true);
                } else {
                    accumulatedRegularHistogram = ((Histogram)intervalHistogram).copy();
                    accumulatedRegularHistogram.reset();
                    accumulatedRegularHistogram.setAutoResize(true);
                }
            }
            while (intervalHistogram != null) {
                if (intervalHistogram instanceof DoubleHistogram) {
                    if (accumulatedDoubleHistogram == null) {
                        throw new IllegalStateException("Encountered a DoubleHistogram line in a log of Histograms.");
                    }
                    accumulatedDoubleHistogram.add((DoubleHistogram)intervalHistogram);
                } else {
                    if (accumulatedRegularHistogram == null) {
                        throw new IllegalStateException("Encountered a Histogram line in a log of DoubleHistograms.");
                    }
                    accumulatedRegularHistogram.add((Histogram)intervalHistogram);
                }
                if (firstStartTime == 0.0 && this.logReader.getStartTimeSec() != 0.0) {
                    firstStartTime = this.logReader.getStartTimeSec();
                    this.outputStartTime(histogramPercentileLog, firstStartTime);
                    if (timeIntervalLog != null) {
                        this.outputStartTime(timeIntervalLog, firstStartTime);
                    }
                }
                if (timeIntervalLog != null) {
                    if (!timeIntervalLogLegendWritten) {
                        timeIntervalLogLegendWritten = true;
                        if (this.config.logFormatCsv) {
                            timeIntervalLog.println("\"Timestamp\",\"Int_Count\",\"Int_50%\",\"Int_90%\",\"Int_Max\",\"Total_Count\",\"Total_50%\",\"Total_90%\",\"Total_99%\",\"Total_99.9%\",\"Total_99.99%\",\"Total_Max\"");
                        } else {
                            timeIntervalLog.println("Time: IntervalPercentiles:count ( 50% 90% Max ) TotalPercentiles:count ( 50% 90% 99% 99.9% 99.99% Max )");
                        }
                    }
                    if (intervalHistogram instanceof DoubleHistogram) {
                        timeIntervalLog.format(Locale.US, logFormat, (double)intervalHistogram.getEndTimeStamp() / 1000.0 - this.logReader.getStartTimeSec(), ((DoubleHistogram)intervalHistogram).getTotalCount(), ((DoubleHistogram)intervalHistogram).getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, ((DoubleHistogram)intervalHistogram).getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, ((DoubleHistogram)intervalHistogram).getMaxValue() / this.config.outputValueUnitRatio, accumulatedDoubleHistogram.getTotalCount(), accumulatedDoubleHistogram.getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, accumulatedDoubleHistogram.getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, accumulatedDoubleHistogram.getValueAtPercentile(99.0) / this.config.outputValueUnitRatio, accumulatedDoubleHistogram.getValueAtPercentile(99.9) / this.config.outputValueUnitRatio, accumulatedDoubleHistogram.getValueAtPercentile(99.99) / this.config.outputValueUnitRatio, accumulatedDoubleHistogram.getMaxValue() / this.config.outputValueUnitRatio);
                    } else {
                        timeIntervalLog.format(Locale.US, logFormat, (double)intervalHistogram.getEndTimeStamp() / 1000.0 - this.logReader.getStartTimeSec(), ((Histogram)intervalHistogram).getTotalCount(), (double)((Histogram)intervalHistogram).getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, (double)((Histogram)intervalHistogram).getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, (double)((Histogram)intervalHistogram).getMaxValue() / this.config.outputValueUnitRatio, accumulatedRegularHistogram.getTotalCount(), (double)accumulatedRegularHistogram.getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, (double)accumulatedRegularHistogram.getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, (double)accumulatedRegularHistogram.getValueAtPercentile(99.0) / this.config.outputValueUnitRatio, (double)accumulatedRegularHistogram.getValueAtPercentile(99.9) / this.config.outputValueUnitRatio, (double)accumulatedRegularHistogram.getValueAtPercentile(99.99) / this.config.outputValueUnitRatio, (double)accumulatedRegularHistogram.getMaxValue() / this.config.outputValueUnitRatio);
                    }
                }
                intervalHistogram = this.getIntervalHistogram(this.config.tag);
            }
            if (accumulatedDoubleHistogram != null) {
                accumulatedDoubleHistogram.outputPercentileDistribution(histogramPercentileLog, this.config.percentilesOutputTicksPerHalf, this.config.outputValueUnitRatio, this.config.logFormatCsv);
            } else {
                if (accumulatedRegularHistogram == null) {
                    accumulatedRegularHistogram = new Histogram(1000000L, 2);
                }
                accumulatedRegularHistogram.outputPercentileDistribution(histogramPercentileLog, this.config.percentilesOutputTicksPerHalf, this.config.outputValueUnitRatio, this.config.logFormatCsv);
            }
        }
        finally {
            if (this.config.outputFileName != null) {
                timeIntervalLog.close();
                histogramPercentileLog.close();
            }
        }
    }

    public HistogramLogProcessor(String[] args) throws FileNotFoundException {
        this.setName("HistogramLogProcessor");
        this.config = new HistogramLogProcessorConfiguration(args);
        this.logReader = this.config.inputFileName != null ? new HistogramLogReader(this.config.inputFileName) : new HistogramLogReader(System.in);
    }

    public static void main(String[] args) {
        try {
            HistogramLogProcessor processor = new HistogramLogProcessor(args);
            processor.start();
        }
        catch (FileNotFoundException ex) {
            System.err.println("failed to open input file.");
        }
    }

    private static class HistogramLogProcessorConfiguration {
        public boolean verbose = false;
        public String outputFileName = null;
        public String inputFileName = null;
        public String tag = null;
        public double rangeStartTimeSec = 0.0;
        public double rangeEndTimeSec = Double.MAX_VALUE;
        public boolean logFormatCsv = false;
        public boolean listTags = false;
        public boolean allTags = false;
        public int percentilesOutputTicksPerHalf = 5;
        public Double outputValueUnitRatio = 1000000.0;
        public boolean error = false;
        public String errorMessage = "";

        public HistogramLogProcessorConfiguration(String[] args) {
            boolean askedForHelp = false;
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-csv")) {
                        this.logFormatCsv = true;
                        continue;
                    }
                    if (args[i].equals("-v")) {
                        this.verbose = true;
                        continue;
                    }
                    if (args[i].equals("-listtags")) {
                        this.listTags = true;
                        continue;
                    }
                    if (args[i].equals("-alltags")) {
                        this.allTags = true;
                        continue;
                    }
                    if (args[i].equals("-i")) {
                        this.inputFileName = args[++i];
                        continue;
                    }
                    if (args[i].equals("-tag")) {
                        this.tag = args[++i];
                        continue;
                    }
                    if (args[i].equals("-start")) {
                        this.rangeStartTimeSec = Double.parseDouble(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-end")) {
                        this.rangeEndTimeSec = Double.parseDouble(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-o")) {
                        this.outputFileName = args[++i];
                        continue;
                    }
                    if (args[i].equals("-percentilesOutputTicksPerHalf")) {
                        this.percentilesOutputTicksPerHalf = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-outputValueUnitRatio")) {
                        this.outputValueUnitRatio = Double.parseDouble(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-h")) {
                        askedForHelp = true;
                        throw new Exception("Help: " + args[i]);
                    }
                    throw new Exception("Invalid args: " + args[i]);
                }
            }
            catch (Exception e) {
                this.error = true;
                this.errorMessage = "Error: Histogram Log Processor version 2.1.9 launched with the following args:\n";
                for (String arg : args) {
                    this.errorMessage = this.errorMessage + arg + " ";
                }
                if (!askedForHelp) {
                    this.errorMessage = this.errorMessage + "\nWhich was parsed as an error, indicated by the following exception:\n" + e;
                    System.err.println(this.errorMessage);
                }
                String validArgs = "\"[-csv] [-v] [-i inputFileName] [-o outputFileName] [-tag tag] [-start rangeStartTimeSec] [-end rangeEndTimeSec] [-outputValueUnitRatio r] [-listtags]";
                System.err.println("valid arguments = \"[-csv] [-v] [-i inputFileName] [-o outputFileName] [-tag tag] [-start rangeStartTimeSec] [-end rangeEndTimeSec] [-outputValueUnitRatio r] [-listtags]");
                System.err.println(" [-h]                        help\n [-v]                        Provide verbose error output\n [-csv]                      Use CSV format for output log files\n [-i logFileName]            File name of Histogram Log to process (default is standard input)\n [-o outputFileName]         File name to output to (default is standard output)\n [-tag tag]                  The tag (default no tag) of the histogram lines to be processed\n [-start rangeStartTimeSec]  The start time for the range in the file, in seconds (default 0.0)\n [-end rangeEndTimeSec]      The end time for the range in the file, in seconds (default is infinite)\n [-outputValueUnitRatio r]   The scaling factor by which to divide histogram recorded values units\n                             in output. [default = 1000000.0 (1 msec in nsec)]\n [-listtags]                 list all tags found on histogram lines the input file.");
                System.exit(1);
            }
        }
    }
}

