/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.CodepointCountFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.AttributeSource;

public final class NGramTokenFilter
extends TokenFilter {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private final int minGram;
    private final int maxGram;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curCodePointCount;
    private int curGramSize;
    private int curPos;
    private int curPosInc;
    private AttributeSource.State state;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt;

    public NGramTokenFilter(TokenStream input, int minGram, int maxGram) {
        super(new CodepointCountFilter(input, minGram, Integer.MAX_VALUE));
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    }

    public NGramTokenFilter(TokenStream input) {
        this(input, 1, 2);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.buffer().clone();
                this.curTermLength = this.termAtt.length();
                this.curCodePointCount = Character.codePointCount(this.termAtt, 0, this.termAtt.length());
                this.curGramSize = this.minGram;
                this.curPos = 0;
                this.curPosInc = this.posIncAtt.getPositionIncrement();
                this.state = this.captureState();
            }
            if (this.curGramSize > this.maxGram || this.curPos + this.curGramSize > this.curCodePointCount) {
                ++this.curPos;
                this.curGramSize = this.minGram;
            }
            if (this.curPos + this.curGramSize <= this.curCodePointCount) {
                this.restoreState(this.state);
                int start = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, 0, this.curPos);
                int end = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, start, this.curGramSize);
                this.termAtt.copyBuffer(this.curTermBuffer, start, end - start);
                this.posIncAtt.setPositionIncrement(this.curPosInc);
                this.curPosInc = 0;
                ++this.curGramSize;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
    }
}

