/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.misc;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Locale;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.misc.TermStats;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.PriorityQueue;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.SuppressForbidden;

public class HighFreqTerms {
    public static final int DEFAULT_NUMTERMS = 100;

    @SuppressForbidden(reason="System.out required: command line tool")
    public static void main(String[] args) throws Exception {
        String field = null;
        int numTerms = 100;
        if (args.length == 0 || args.length > 4) {
            HighFreqTerms.usage();
            System.exit(1);
        }
        FSDirectory dir = FSDirectory.open(Paths.get(args[0], new String[0]));
        Comparator<TermStats> comparator = new DocFreqComparator();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                comparator = new TotalTermFreqComparator();
                continue;
            }
            try {
                numTerms = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                field = args[i];
            }
        }
        DirectoryReader reader = DirectoryReader.open(dir);
        TermStats[] terms = HighFreqTerms.getHighFreqTerms(reader, numTerms, field, comparator);
        for (int i = 0; i < terms.length; ++i) {
            System.out.printf(Locale.ROOT, "%s:%s \t totalTF = %,d \t docFreq = %,d \n", terms[i].field, terms[i].termtext.utf8ToString(), terms[i].totalTermFreq, terms[i].docFreq);
        }
        reader.close();
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [-t] [number_terms] [field]\n\t -t: order by totalTermFreq\n\n");
    }

    public static TermStats[] getHighFreqTerms(IndexReader reader, int numTerms, String field, Comparator<TermStats> comparator) throws Exception {
        TermStatsQueue tiq = null;
        if (field != null) {
            Terms terms = MultiFields.getTerms(reader, field);
            if (terms == null) {
                throw new RuntimeException("field " + field + " not found");
            }
            TermsEnum termsEnum = terms.iterator();
            tiq = new TermStatsQueue(numTerms, comparator);
            tiq.fill(field, termsEnum);
        } else {
            Fields fields = MultiFields.getFields(reader);
            if (fields.size() == 0) {
                throw new RuntimeException("no fields found for this index");
            }
            tiq = new TermStatsQueue(numTerms, comparator);
            for (String fieldName : fields) {
                Terms terms = fields.terms(fieldName);
                if (terms == null) continue;
                tiq.fill(fieldName, terms.iterator());
            }
        }
        TermStats[] result = new TermStats[tiq.size()];
        int count = tiq.size() - 1;
        while (tiq.size() != 0) {
            result[count] = (TermStats)tiq.pop();
            --count;
        }
        return result;
    }

    static final class TermStatsQueue
    extends PriorityQueue<TermStats> {
        final Comparator<TermStats> comparator;

        TermStatsQueue(int size, Comparator<TermStats> comparator) {
            super(size);
            this.comparator = comparator;
        }

        @Override
        protected boolean lessThan(TermStats termInfoA, TermStats termInfoB) {
            return this.comparator.compare(termInfoA, termInfoB) < 0;
        }

        protected void fill(String field, TermsEnum termsEnum) throws IOException {
            BytesRef term = null;
            while ((term = termsEnum.next()) != null) {
                this.insertWithOverflow(new TermStats(field, term, termsEnum.docFreq(), termsEnum.totalTermFreq()));
            }
        }
    }

    public static final class TotalTermFreqComparator
    implements Comparator<TermStats> {
        @Override
        public int compare(TermStats a, TermStats b) {
            int res = Long.compare(a.totalTermFreq, b.totalTermFreq);
            if (res == 0 && (res = a.field.compareTo(b.field)) == 0) {
                res = a.termtext.compareTo(b.termtext);
            }
            return res;
        }
    }

    public static final class DocFreqComparator
    implements Comparator<TermStats> {
        @Override
        public int compare(TermStats a, TermStats b) {
            int res = Long.compare(a.docFreq, b.docFreq);
            if (res == 0 && (res = a.field.compareTo(b.field)) == 0) {
                res = a.termtext.compareTo(b.termtext);
            }
            return res;
        }
    }
}

