/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FilterScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        Weight inner = this.in.createWeight(searcher, needsScores && this.source.needsScores());
        if (!needsScores) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    @Override
    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)o;
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        float boost = 1.0f;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.inner.extractTerms(terms);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.inner.scorer(context);
            if (scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch("No match", new Explanation[0]);
            }
            DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer(scorer));
            scores.advanceExact(doc);
            Explanation scoreExpl = this.scoreExplanation(context, doc, scores);
            if (this.boost == 1.0f) {
                return scoreExpl;
            }
            return Explanation.match(scoreExpl.getValue() * this.boost, "product of:", Explanation.match(this.boost, "boost", new Explanation[0]), scoreExpl);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.inner.getValueForNormalization();
        }

        @Override
        public void normalize(float norm, float boost) {
            this.inner.normalize(norm, 1.0f);
            this.boost = boost;
        }

        private Explanation scoreExplanation(LeafReaderContext context, int doc, DoubleValues scores) throws IOException {
            if (!this.valueSource.needsScores()) {
                return Explanation.match((float)scores.doubleValue(), this.valueSource.toString(), new Explanation[0]);
            }
            float score = (float)scores.doubleValue();
            return Explanation.match(score, "computed from:", Explanation.match(score, this.valueSource.toString(), new Explanation[0]), this.inner.explain(context, doc));
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer(in));
            return new FilterScorer(in){

                @Override
                public float score() throws IOException {
                    if (scores.advanceExact(this.docID())) {
                        return (float)(scores.doubleValue() * (double)boost);
                    }
                    return 0.0f;
                }
            };
        }
    }
}

