/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.LongHashSet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.RandomAccessWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;

public class DocValuesNumbersQuery
extends Query {
    private final String field;
    private final LongHashSet numbers;

    public DocValuesNumbersQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers);
    }

    public DocValuesNumbersQuery(String field, Collection<Long> numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers.stream().mapToLong(Long::longValue).toArray());
    }

    public DocValuesNumbersQuery(String field, Long ... numbers) {
        this(field, new HashSet<Long>(Arrays.asList(numbers)));
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DocValuesNumbersQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DocValuesNumbersQuery other) {
        return this.field.equals(other.field) && this.numbers.equals(other.numbers);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Objects.hash(this.field, this.numbers);
    }

    public String getField() {
        return this.field;
    }

    public Set<Long> getNumbers() {
        return this.numbers;
    }

    @Override
    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesNumbersQuery.this.field);
                return new Bits(){

                    @Override
                    public boolean get(int doc) {
                        values.setDocument(doc);
                        int count = values.count();
                        for (int i = 0; i < count; ++i) {
                            if (!DocValuesNumbersQuery.this.numbers.contains(values.valueAt(i))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int length() {
                        return context.reader().maxDoc();
                    }
                };
            }
        };
    }
}

