/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.DistinctValuesCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValue;

public class FunctionDistinctValuesCollector
extends DistinctValuesCollector<MutableValue> {
    private final Map<?, ?> vsContext;
    private final ValueSource groupSource;
    private final ValueSource countSource;
    private final Map<MutableValue, DistinctValuesCollector.GroupCount<MutableValue>> groupMap;
    private FunctionValues.ValueFiller groupFiller;
    private FunctionValues.ValueFiller countFiller;
    private MutableValue groupMval;
    private MutableValue countMval;

    public FunctionDistinctValuesCollector(Map<?, ?> vsContext, ValueSource groupSource, ValueSource countSource, Collection<SearchGroup<MutableValue>> groups) {
        this.vsContext = vsContext;
        this.groupSource = groupSource;
        this.countSource = countSource;
        this.groupMap = new LinkedHashMap<MutableValue, DistinctValuesCollector.GroupCount<MutableValue>>();
        for (SearchGroup<MutableValue> group : groups) {
            this.groupMap.put((MutableValue)group.groupValue, new DistinctValuesCollector.GroupCount(group.groupValue));
        }
    }

    @Override
    public List<DistinctValuesCollector.GroupCount<MutableValue>> getGroups() {
        return new ArrayList<DistinctValuesCollector.GroupCount<MutableValue>>(this.groupMap.values());
    }

    @Override
    public void collect(int doc) throws IOException {
        this.groupFiller.fillValue(doc);
        DistinctValuesCollector.GroupCount<MutableValue> groupCount = this.groupMap.get(this.groupMval);
        if (groupCount != null) {
            this.countFiller.fillValue(doc);
            groupCount.uniqueValues.add(this.countMval.duplicate());
        }
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        FunctionValues values = this.groupSource.getValues(this.vsContext, context);
        this.groupFiller = values.getValueFiller();
        this.groupMval = this.groupFiller.getValue();
        values = this.countSource.getValues(this.vsContext, context);
        this.countFiller = values.getValueFiller();
        this.countMval = this.countFiller.getValue();
    }
}

