/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.SecondPassGroupingCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValue;

public class FunctionSecondPassGroupingCollector
extends SecondPassGroupingCollector<MutableValue> {
    private final ValueSource groupByVS;
    private final Map<?, ?> vsContext;
    private FunctionValues.ValueFiller filler;
    private MutableValue mval;

    public FunctionSecondPassGroupingCollector(Collection<SearchGroup<MutableValue>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields, ValueSource groupByVS, Map<?, ?> vsContext) throws IOException {
        super(searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        this.groupByVS = groupByVS;
        this.vsContext = vsContext;
    }

    @Override
    protected SecondPassGroupingCollector.SearchGroupDocs<MutableValue> retrieveGroup(int doc) throws IOException {
        this.filler.fillValue(doc);
        return (SecondPassGroupingCollector.SearchGroupDocs)this.groupMap.get(this.mval);
    }

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        super.doSetNextReader(readerContext);
        FunctionValues values = this.groupByVS.getValues(this.vsContext, readerContext);
        this.filler = values.getValueFiller();
        this.mval = this.filler.getValue();
    }
}

