/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.geopoint.document;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.geopoint.document.GeoPointTokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.util.MortonEncoder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BitUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRefBuilder;

@Deprecated
public final class GeoPointField
extends Field {
    public static final int PRECISION_STEP = 9;
    public static final short BITS = 31;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    private static final double LON_SCALE = 5965232.355555556;
    private static final int BUF_SIZE_LONG = 4;
    @Deprecated
    public static final FieldType NUMERIC_TYPE_NOT_STORED = new FieldType();
    @Deprecated
    public static final FieldType NUMERIC_TYPE_STORED;
    public static final FieldType PREFIX_TYPE_NOT_STORED;
    public static final FieldType PREFIX_TYPE_STORED;

    public GeoPointField(String name, double latitude, double longitude, Field.Store stored) {
        this(name, latitude, longitude, GeoPointField.getFieldType(stored));
    }

    @Deprecated
    public GeoPointField(String name, double latitude, double longitude, TermEncoding termEncoding, Field.Store stored) {
        this(name, latitude, longitude, GeoPointField.getFieldType(termEncoding, stored));
    }

    public GeoPointField(String name, double latitude, double longitude, FieldType type) {
        super(name, type);
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        if (type.indexOptions() == IndexOptions.NONE && !type.stored()) {
            throw new IllegalArgumentException("type.indexOptions() is set to NONE but type.stored() is false");
        }
        if (type.indexOptions() == IndexOptions.DOCS) {
            if (type.docValuesType() != DocValuesType.SORTED_NUMERIC) {
                throw new IllegalArgumentException("type.docValuesType() must be SORTED_NUMERIC but got " + (Object)((Object)type.docValuesType()));
            }
            if (type.numericType() != null && type.numericType() != FieldType.LegacyNumericType.LONG) {
                throw new IllegalArgumentException("type.numericType() must be LONG but got " + (Object)((Object)type.numericType()));
            }
        } else {
            throw new IllegalArgumentException("type.indexOptions() must be one of NONE or DOCS but got " + (Object)((Object)type.indexOptions()));
        }
        this.fieldsData = GeoPointField.encodeLatLon(latitude, longitude);
    }

    private static FieldType getFieldType(Field.Store stored) {
        return GeoPointField.getFieldType(TermEncoding.PREFIX, stored);
    }

    @Deprecated
    private static FieldType getFieldType(TermEncoding termEncoding, Field.Store stored) {
        if (stored == Field.Store.YES) {
            return termEncoding == TermEncoding.PREFIX ? PREFIX_TYPE_STORED : NUMERIC_TYPE_STORED;
        }
        if (stored == Field.Store.NO) {
            return termEncoding == TermEncoding.PREFIX ? PREFIX_TYPE_NOT_STORED : NUMERIC_TYPE_NOT_STORED;
        }
        throw new IllegalArgumentException("stored option must be NO or YES but got " + (Object)((Object)stored));
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        if (this.fieldType().indexOptions() == IndexOptions.NONE) {
            return null;
        }
        if (this.type.numericType() != null) {
            return super.tokenStream(analyzer, reuse);
        }
        if (!(reuse instanceof GeoPointTokenStream)) {
            reuse = new GeoPointTokenStream();
        }
        GeoPointTokenStream gpts = (GeoPointTokenStream)reuse;
        gpts.setGeoCode(((Number)this.fieldsData).longValue());
        return reuse;
    }

    public double getLat() {
        return GeoPointField.decodeLatitude((Long)this.fieldsData);
    }

    public double getLon() {
        return GeoPointField.decodeLongitude((Long)this.fieldsData);
    }

    @Override
    public String toString() {
        if (this.fieldsData == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(GeoPointField.decodeLatitude((Long)this.fieldsData));
        sb.append(',');
        sb.append(GeoPointField.decodeLongitude((Long)this.fieldsData));
        return sb.toString();
    }

    public static long encodeLatLon(double lat, double lon) {
        long result = MortonEncoder.encode(lat, lon);
        if (result == -1L) {
            return result & 0xC000000000000000L;
        }
        return result >>> 2;
    }

    public static final double decodeLongitude(long hash) {
        return GeoPointField.unscaleLon(BitUtil.deinterleave(hash));
    }

    public static final double decodeLatitude(long hash) {
        return GeoPointField.unscaleLat(BitUtil.deinterleave(hash >>> 1));
    }

    private static final double unscaleLon(long val) {
        return (double)val / 5965232.355555556 + -180.0;
    }

    private static final double unscaleLat(long val) {
        return (double)val / 1.1930464711111112E7 + -90.0;
    }

    public static void geoCodedToPrefixCoded(long hash, int shift, BytesRefBuilder bytes) {
        GeoPointField.geoCodedToPrefixCodedBytes(hash, shift, bytes);
    }

    public static long prefixCodedToGeoCoded(BytesRef val) {
        long result = 0L | ((long)val.bytes[val.offset + 0] & 0xFFL) << 24 | ((long)val.bytes[val.offset + 1] & 0xFFL) << 16 | ((long)val.bytes[val.offset + 2] & 0xFFL) << 8 | (long)val.bytes[val.offset + 3] & 0xFFL;
        return result << 32;
    }

    private static void geoCodedToPrefixCodedBytes(long hash, int shift, BytesRefBuilder bytes) {
        if (shift < 32 || shift > 63) {
            throw new IllegalArgumentException("Illegal shift value, must be 32..63; got shift=" + shift);
        }
        int nChars = 5;
        bytes.setLength(nChars);
        bytes.grow(nChars--);
        int sigBits = 64 - shift;
        bytes.setByteAt(4, (byte)sigBits);
        long sortableBits = hash;
        sortableBits >>>= shift;
        sortableBits <<= 32 - sigBits;
        do {
            bytes.setByteAt(--nChars, (byte)sortableBits);
            sortableBits >>>= 8;
        } while (nChars > 0);
    }

    public static int getPrefixCodedShift(BytesRef val) {
        byte shift = val.bytes[val.offset + 4];
        if (shift > 63 || shift < 0) {
            throw new NumberFormatException("Invalid shift value (" + shift + ") in prefixCoded bytes (is encoded value really a geo point?)");
        }
        return shift;
    }

    static {
        NUMERIC_TYPE_NOT_STORED.setTokenized(false);
        NUMERIC_TYPE_NOT_STORED.setOmitNorms(true);
        NUMERIC_TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        NUMERIC_TYPE_NOT_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        NUMERIC_TYPE_NOT_STORED.setNumericType(FieldType.LegacyNumericType.LONG);
        NUMERIC_TYPE_NOT_STORED.setNumericPrecisionStep(9);
        NUMERIC_TYPE_NOT_STORED.freeze();
        NUMERIC_TYPE_STORED = new FieldType();
        NUMERIC_TYPE_STORED.setTokenized(false);
        NUMERIC_TYPE_STORED.setOmitNorms(true);
        NUMERIC_TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        NUMERIC_TYPE_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        NUMERIC_TYPE_STORED.setNumericType(FieldType.LegacyNumericType.LONG);
        NUMERIC_TYPE_STORED.setNumericPrecisionStep(9);
        NUMERIC_TYPE_STORED.setStored(true);
        NUMERIC_TYPE_STORED.freeze();
        PREFIX_TYPE_NOT_STORED = new FieldType();
        PREFIX_TYPE_NOT_STORED.setTokenized(false);
        PREFIX_TYPE_NOT_STORED.setOmitNorms(true);
        PREFIX_TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        PREFIX_TYPE_NOT_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        PREFIX_TYPE_NOT_STORED.freeze();
        PREFIX_TYPE_STORED = new FieldType();
        PREFIX_TYPE_STORED.setTokenized(false);
        PREFIX_TYPE_STORED.setOmitNorms(true);
        PREFIX_TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        PREFIX_TYPE_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        PREFIX_TYPE_STORED.setStored(true);
        PREFIX_TYPE_STORED.freeze();
    }

    public static enum TermEncoding {
        PREFIX,
        NUMERIC;

    }
}

